/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The available logging options for this subnetwork.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SubnetworkLogConfig}
 */
public final class SubnetworkLogConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SubnetworkLogConfig)
    SubnetworkLogConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SubnetworkLogConfig.newBuilder() to construct.
  private SubnetworkLogConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SubnetworkLogConfig() {
    aggregationInterval_ = "";
    filterExpr_ = "";
    metadata_ = "";
    metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SubnetworkLogConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SubnetworkLogConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SubnetworkLogConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SubnetworkLogConfig.class,
            com.google.cloud.compute.v1.SubnetworkLogConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SubnetworkLogConfig.AggregationInterval}
   */
  public enum AggregationInterval implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AGGREGATION_INTERVAL = 0;</code>
     */
    UNDEFINED_AGGREGATION_INTERVAL(0),
    /** <code>INTERVAL_10_MIN = 487155916;</code> */
    INTERVAL_10_MIN(487155916),
    /** <code>INTERVAL_15_MIN = 491773521;</code> */
    INTERVAL_15_MIN(491773521),
    /** <code>INTERVAL_1_MIN = 69052714;</code> */
    INTERVAL_1_MIN(69052714),
    /** <code>INTERVAL_30_SEC = 7548937;</code> */
    INTERVAL_30_SEC(7548937),
    /** <code>INTERVAL_5_MIN = 72746798;</code> */
    INTERVAL_5_MIN(72746798),
    /** <code>INTERVAL_5_SEC = 72752429;</code> */
    INTERVAL_5_SEC(72752429),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_AGGREGATION_INTERVAL = 0;</code>
     */
    public static final int UNDEFINED_AGGREGATION_INTERVAL_VALUE = 0;

    /** <code>INTERVAL_10_MIN = 487155916;</code> */
    public static final int INTERVAL_10_MIN_VALUE = 487155916;

    /** <code>INTERVAL_15_MIN = 491773521;</code> */
    public static final int INTERVAL_15_MIN_VALUE = 491773521;

    /** <code>INTERVAL_1_MIN = 69052714;</code> */
    public static final int INTERVAL_1_MIN_VALUE = 69052714;

    /** <code>INTERVAL_30_SEC = 7548937;</code> */
    public static final int INTERVAL_30_SEC_VALUE = 7548937;

    /** <code>INTERVAL_5_MIN = 72746798;</code> */
    public static final int INTERVAL_5_MIN_VALUE = 72746798;

    /** <code>INTERVAL_5_SEC = 72752429;</code> */
    public static final int INTERVAL_5_SEC_VALUE = 72752429;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AggregationInterval valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static AggregationInterval forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_AGGREGATION_INTERVAL;
        case 487155916:
          return INTERVAL_10_MIN;
        case 491773521:
          return INTERVAL_15_MIN;
        case 69052714:
          return INTERVAL_1_MIN;
        case 7548937:
          return INTERVAL_30_SEC;
        case 72746798:
          return INTERVAL_5_MIN;
        case 72752429:
          return INTERVAL_5_SEC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<AggregationInterval>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<AggregationInterval>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<AggregationInterval>() {
              public AggregationInterval findValueByNumber(int number) {
                return AggregationInterval.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SubnetworkLogConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final AggregationInterval[] VALUES = values();

    public static AggregationInterval valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private AggregationInterval(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SubnetworkLogConfig.AggregationInterval)
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SubnetworkLogConfig.Metadata}
   */
  public enum Metadata implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_METADATA = 0;</code>
     */
    UNDEFINED_METADATA(0),
    /** <code>CUSTOM_METADATA = 62450749;</code> */
    CUSTOM_METADATA(62450749),
    /** <code>EXCLUDE_ALL_METADATA = 334519954;</code> */
    EXCLUDE_ALL_METADATA(334519954),
    /** <code>INCLUDE_ALL_METADATA = 164619908;</code> */
    INCLUDE_ALL_METADATA(164619908),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_METADATA = 0;</code>
     */
    public static final int UNDEFINED_METADATA_VALUE = 0;

    /** <code>CUSTOM_METADATA = 62450749;</code> */
    public static final int CUSTOM_METADATA_VALUE = 62450749;

    /** <code>EXCLUDE_ALL_METADATA = 334519954;</code> */
    public static final int EXCLUDE_ALL_METADATA_VALUE = 334519954;

    /** <code>INCLUDE_ALL_METADATA = 164619908;</code> */
    public static final int INCLUDE_ALL_METADATA_VALUE = 164619908;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Metadata valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Metadata forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_METADATA;
        case 62450749:
          return CUSTOM_METADATA;
        case 334519954:
          return EXCLUDE_ALL_METADATA;
        case 164619908:
          return INCLUDE_ALL_METADATA;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Metadata> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Metadata> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Metadata>() {
          public Metadata findValueByNumber(int number) {
            return Metadata.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SubnetworkLogConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final Metadata[] VALUES = values();

    public static Metadata valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Metadata(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SubnetworkLogConfig.Metadata)
  }

  private int bitField0_;
  public static final int AGGREGATION_INTERVAL_FIELD_NUMBER = 174919042;

  @SuppressWarnings("serial")
  private volatile java.lang.Object aggregationInterval_ = "";

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
   * Check the AggregationInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string aggregation_interval = 174919042;</code>
   *
   * @return Whether the aggregationInterval field is set.
   */
  @java.lang.Override
  public boolean hasAggregationInterval() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
   * Check the AggregationInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string aggregation_interval = 174919042;</code>
   *
   * @return The aggregationInterval.
   */
  @java.lang.Override
  public java.lang.String getAggregationInterval() {
    java.lang.Object ref = aggregationInterval_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      aggregationInterval_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
   * Check the AggregationInterval enum for the list of possible values.
   * </pre>
   *
   * <code>optional string aggregation_interval = 174919042;</code>
   *
   * @return The bytes for aggregationInterval.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAggregationIntervalBytes() {
    java.lang.Object ref = aggregationInterval_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      aggregationInterval_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENABLE_FIELD_NUMBER = 311764355;
  private boolean enable_ = false;

  /**
   *
   *
   * <pre>
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * </pre>
   *
   * <code>optional bool enable = 311764355;</code>
   *
   * @return Whether the enable field is set.
   */
  @java.lang.Override
  public boolean hasEnable() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
   * </pre>
   *
   * <code>optional bool enable = 311764355;</code>
   *
   * @return The enable.
   */
  @java.lang.Override
  public boolean getEnable() {
    return enable_;
  }

  public static final int FILTER_EXPR_FIELD_NUMBER = 183374428;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filterExpr_ = "";

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional string filter_expr = 183374428;</code>
   *
   * @return Whether the filterExpr field is set.
   */
  @java.lang.Override
  public boolean hasFilterExpr() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional string filter_expr = 183374428;</code>
   *
   * @return The filterExpr.
   */
  @java.lang.Override
  public java.lang.String getFilterExpr() {
    java.lang.Object ref = filterExpr_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filterExpr_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
   * </pre>
   *
   * <code>optional string filter_expr = 183374428;</code>
   *
   * @return The bytes for filterExpr.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterExprBytes() {
    java.lang.Object ref = filterExpr_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filterExpr_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FLOW_SAMPLING_FIELD_NUMBER = 530150360;
  private float flowSampling_ = 0F;

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
   * </pre>
   *
   * <code>optional float flow_sampling = 530150360;</code>
   *
   * @return Whether the flowSampling field is set.
   */
  @java.lang.Override
  public boolean hasFlowSampling() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
   * </pre>
   *
   * <code>optional float flow_sampling = 530150360;</code>
   *
   * @return The flowSampling.
   */
  @java.lang.Override
  public float getFlowSampling() {
    return flowSampling_;
  }

  public static final int METADATA_FIELD_NUMBER = 86866735;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metadata_ = "";

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
   * Check the Metadata enum for the list of possible values.
   * </pre>
   *
   * <code>optional string metadata = 86866735;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
   * Check the Metadata enum for the list of possible values.
   * </pre>
   *
   * <code>optional string metadata = 86866735;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public java.lang.String getMetadata() {
    java.lang.Object ref = metadata_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metadata_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
   * Check the Metadata enum for the list of possible values.
   * </pre>
   *
   * <code>optional string metadata = 86866735;</code>
   *
   * @return The bytes for metadata.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetadataBytes() {
    java.lang.Object ref = metadata_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metadata_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELDS_FIELD_NUMBER = 378461641;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList metadataFields_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
   * </pre>
   *
   * <code>repeated string metadata_fields = 378461641;</code>
   *
   * @return A list containing the metadataFields.
   */
  public com.google.protobuf.ProtocolStringList getMetadataFieldsList() {
    return metadataFields_;
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
   * </pre>
   *
   * <code>repeated string metadata_fields = 378461641;</code>
   *
   * @return The count of metadataFields.
   */
  public int getMetadataFieldsCount() {
    return metadataFields_.size();
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
   * </pre>
   *
   * <code>repeated string metadata_fields = 378461641;</code>
   *
   * @param index The index of the element to return.
   * @return The metadataFields at the given index.
   */
  public java.lang.String getMetadataFields(int index) {
    return metadataFields_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
   * </pre>
   *
   * <code>repeated string metadata_fields = 378461641;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the metadataFields at the given index.
   */
  public com.google.protobuf.ByteString getMetadataFieldsBytes(int index) {
    return metadataFields_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 86866735, metadata_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 174919042, aggregationInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 183374428, filterExpr_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(311764355, enable_);
    }
    for (int i = 0; i < metadataFields_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 378461641, metadataFields_.getRaw(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeFloat(530150360, flowSampling_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(86866735, metadata_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(174919042, aggregationInterval_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(183374428, filterExpr_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(311764355, enable_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < metadataFields_.size(); i++) {
        dataSize += computeStringSizeNoTag(metadataFields_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getMetadataFieldsList().size();
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(530150360, flowSampling_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SubnetworkLogConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SubnetworkLogConfig other =
        (com.google.cloud.compute.v1.SubnetworkLogConfig) obj;

    if (hasAggregationInterval() != other.hasAggregationInterval()) return false;
    if (hasAggregationInterval()) {
      if (!getAggregationInterval().equals(other.getAggregationInterval())) return false;
    }
    if (hasEnable() != other.hasEnable()) return false;
    if (hasEnable()) {
      if (getEnable() != other.getEnable()) return false;
    }
    if (hasFilterExpr() != other.hasFilterExpr()) return false;
    if (hasFilterExpr()) {
      if (!getFilterExpr().equals(other.getFilterExpr())) return false;
    }
    if (hasFlowSampling() != other.hasFlowSampling()) return false;
    if (hasFlowSampling()) {
      if (java.lang.Float.floatToIntBits(getFlowSampling())
          != java.lang.Float.floatToIntBits(other.getFlowSampling())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getMetadataFieldsList().equals(other.getMetadataFieldsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAggregationInterval()) {
      hash = (37 * hash) + AGGREGATION_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationInterval().hashCode();
    }
    if (hasEnable()) {
      hash = (37 * hash) + ENABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnable());
    }
    if (hasFilterExpr()) {
      hash = (37 * hash) + FILTER_EXPR_FIELD_NUMBER;
      hash = (53 * hash) + getFilterExpr().hashCode();
    }
    if (hasFlowSampling()) {
      hash = (37 * hash) + FLOW_SAMPLING_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getFlowSampling());
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getMetadataFieldsCount() > 0) {
      hash = (37 * hash) + METADATA_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFieldsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SubnetworkLogConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The available logging options for this subnetwork.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SubnetworkLogConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SubnetworkLogConfig)
      com.google.cloud.compute.v1.SubnetworkLogConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkLogConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkLogConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SubnetworkLogConfig.class,
              com.google.cloud.compute.v1.SubnetworkLogConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SubnetworkLogConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      aggregationInterval_ = "";
      enable_ = false;
      filterExpr_ = "";
      flowSampling_ = 0F;
      metadata_ = "";
      metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SubnetworkLogConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkLogConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkLogConfig build() {
      com.google.cloud.compute.v1.SubnetworkLogConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SubnetworkLogConfig buildPartial() {
      com.google.cloud.compute.v1.SubnetworkLogConfig result =
          new com.google.cloud.compute.v1.SubnetworkLogConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.SubnetworkLogConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.aggregationInterval_ = aggregationInterval_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.enable_ = enable_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filterExpr_ = filterExpr_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.flowSampling_ = flowSampling_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.metadata_ = metadata_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        metadataFields_.makeImmutable();
        result.metadataFields_ = metadataFields_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SubnetworkLogConfig) {
        return mergeFrom((com.google.cloud.compute.v1.SubnetworkLogConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SubnetworkLogConfig other) {
      if (other == com.google.cloud.compute.v1.SubnetworkLogConfig.getDefaultInstance())
        return this;
      if (other.hasAggregationInterval()) {
        aggregationInterval_ = other.aggregationInterval_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasEnable()) {
        setEnable(other.getEnable());
      }
      if (other.hasFilterExpr()) {
        filterExpr_ = other.filterExpr_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasFlowSampling()) {
        setFlowSampling(other.getFlowSampling());
      }
      if (other.hasMetadata()) {
        metadata_ = other.metadata_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.metadataFields_.isEmpty()) {
        if (metadataFields_.isEmpty()) {
          metadataFields_ = other.metadataFields_;
          bitField0_ |= 0x00000020;
        } else {
          ensureMetadataFieldsIsMutable();
          metadataFields_.addAll(other.metadataFields_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 694933882:
              {
                metadata_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 694933882
            case 1399352338:
              {
                aggregationInterval_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1399352338
            case 1466995426:
              {
                filterExpr_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1466995426
            case -1800852456:
              {
                enable_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -1800852456
            case -1267274166:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMetadataFieldsIsMutable();
                metadataFields_.add(s);
                break;
              } // case -1267274166
            case -53764411:
              {
                flowSampling_ = input.readFloat();
                bitField0_ |= 0x00000008;
                break;
              } // case -53764411
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object aggregationInterval_ = "";

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @return Whether the aggregationInterval field is set.
     */
    public boolean hasAggregationInterval() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @return The aggregationInterval.
     */
    public java.lang.String getAggregationInterval() {
      java.lang.Object ref = aggregationInterval_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        aggregationInterval_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @return The bytes for aggregationInterval.
     */
    public com.google.protobuf.ByteString getAggregationIntervalBytes() {
      java.lang.Object ref = aggregationInterval_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        aggregationInterval_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @param value The aggregationInterval to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationInterval(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      aggregationInterval_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAggregationInterval() {
      aggregationInterval_ = getDefaultInstance().getAggregationInterval();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. Toggles the aggregation interval for collecting flow logs. Increasing the interval time will reduce the amount of generated flow logs for long lasting connections. Default is an interval of 5 seconds per connection.
     * Check the AggregationInterval enum for the list of possible values.
     * </pre>
     *
     * <code>optional string aggregation_interval = 174919042;</code>
     *
     * @param value The bytes for aggregationInterval to set.
     * @return This builder for chaining.
     */
    public Builder setAggregationIntervalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      aggregationInterval_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean enable_;

    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return Whether the enable field is set.
     */
    @java.lang.Override
    public boolean hasEnable() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return The enable.
     */
    @java.lang.Override
    public boolean getEnable() {
      return enable_;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @param value The enable to set.
     * @return This builder for chaining.
     */
    public Builder setEnable(boolean value) {

      enable_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether to enable flow logging for this subnetwork. If this field is not explicitly set, it will not appear in get listings. If not set the default behavior is determined by the org policy, if there is no org policy specified, then it will default to disabled. Flow logging isn't supported if the subnet purpose field is set to REGIONAL_MANAGED_PROXY.
     * </pre>
     *
     * <code>optional bool enable = 311764355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnable() {
      bitField0_ = (bitField0_ & ~0x00000002);
      enable_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object filterExpr_ = "";

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @return Whether the filterExpr field is set.
     */
    public boolean hasFilterExpr() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @return The filterExpr.
     */
    public java.lang.String getFilterExpr() {
      java.lang.Object ref = filterExpr_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filterExpr_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @return The bytes for filterExpr.
     */
    public com.google.protobuf.ByteString getFilterExprBytes() {
      java.lang.Object ref = filterExpr_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filterExpr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @param value The filterExpr to set.
     * @return This builder for chaining.
     */
    public Builder setFilterExpr(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterExpr_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterExpr() {
      filterExpr_ = getDefaultInstance().getFilterExpr();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. The filter expression is used to define which VPC flow logs should be exported to Cloud Logging.
     * </pre>
     *
     * <code>optional string filter_expr = 183374428;</code>
     *
     * @param value The bytes for filterExpr to set.
     * @return This builder for chaining.
     */
    public Builder setFilterExprBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterExpr_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private float flowSampling_;

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
     * </pre>
     *
     * <code>optional float flow_sampling = 530150360;</code>
     *
     * @return Whether the flowSampling field is set.
     */
    @java.lang.Override
    public boolean hasFlowSampling() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
     * </pre>
     *
     * <code>optional float flow_sampling = 530150360;</code>
     *
     * @return The flowSampling.
     */
    @java.lang.Override
    public float getFlowSampling() {
      return flowSampling_;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
     * </pre>
     *
     * <code>optional float flow_sampling = 530150360;</code>
     *
     * @param value The flowSampling to set.
     * @return This builder for chaining.
     */
    public Builder setFlowSampling(float value) {

      flowSampling_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logging for this subnetwork is enabled. The value of the field must be in [0, 1]. Set the sampling rate of VPC flow logs within the subnetwork where 1.0 means all collected logs are reported and 0.0 means no logs are reported. Default is 0.5 unless otherwise specified by the org policy, which means half of all collected logs are reported.
     * </pre>
     *
     * <code>optional float flow_sampling = 530150360;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFlowSampling() {
      bitField0_ = (bitField0_ & ~0x00000008);
      flowSampling_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object metadata_ = "";

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @return The metadata.
     */
    public java.lang.String getMetadata() {
      java.lang.Object ref = metadata_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadata_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @return The bytes for metadata.
     */
    public com.google.protobuf.ByteString getMetadataBytes() {
      java.lang.Object ref = metadata_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadata_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @param value The metadata to set.
     * @return This builder for chaining.
     */
    public Builder setMetadata(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metadata_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadata() {
      metadata_ = getDefaultInstance().getMetadata();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled. Configures whether all, none or a subset of metadata fields should be added to the reported VPC flow logs. Default is EXCLUDE_ALL_METADATA.
     * Check the Metadata enum for the list of possible values.
     * </pre>
     *
     * <code>optional string metadata = 86866735;</code>
     *
     * @param value The bytes for metadata to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metadata_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList metadataFields_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureMetadataFieldsIsMutable() {
      if (!metadataFields_.isModifiable()) {
        metadataFields_ = new com.google.protobuf.LazyStringArrayList(metadataFields_);
      }
      bitField0_ |= 0x00000020;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @return A list containing the metadataFields.
     */
    public com.google.protobuf.ProtocolStringList getMetadataFieldsList() {
      metadataFields_.makeImmutable();
      return metadataFields_;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @return The count of metadataFields.
     */
    public int getMetadataFieldsCount() {
      return metadataFields_.size();
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param index The index of the element to return.
     * @return The metadataFields at the given index.
     */
    public java.lang.String getMetadataFields(int index) {
      return metadataFields_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metadataFields at the given index.
     */
    public com.google.protobuf.ByteString getMetadataFieldsBytes(int index) {
      return metadataFields_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param index The index to set the value at.
     * @param value The metadataFields to set.
     * @return This builder for chaining.
     */
    public Builder setMetadataFields(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetadataFieldsIsMutable();
      metadataFields_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param value The metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addMetadataFields(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMetadataFieldsIsMutable();
      metadataFields_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param values The metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addAllMetadataFields(java.lang.Iterable<java.lang.String> values) {
      ensureMetadataFieldsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metadataFields_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetadataFields() {
      metadataFields_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Can only be specified if VPC flow logs for this subnetwork is enabled and "metadata" was set to CUSTOM_METADATA.
     * </pre>
     *
     * <code>repeated string metadata_fields = 378461641;</code>
     *
     * @param value The bytes of the metadataFields to add.
     * @return This builder for chaining.
     */
    public Builder addMetadataFieldsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMetadataFieldsIsMutable();
      metadataFields_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SubnetworkLogConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SubnetworkLogConfig)
  private static final com.google.cloud.compute.v1.SubnetworkLogConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SubnetworkLogConfig();
  }

  public static com.google.cloud.compute.v1.SubnetworkLogConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SubnetworkLogConfig> PARSER =
      new com.google.protobuf.AbstractParser<SubnetworkLogConfig>() {
        @java.lang.Override
        public SubnetworkLogConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SubnetworkLogConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SubnetworkLogConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SubnetworkLogConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
