/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A request message for InstanceGroupManagers.SuspendInstances. See the method description for details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest}
 */
public final class SuspendInstancesInstanceGroupManagerRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest)
    SuspendInstancesInstanceGroupManagerRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use SuspendInstancesInstanceGroupManagerRequest.newBuilder() to construct.
  private SuspendInstancesInstanceGroupManagerRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SuspendInstancesInstanceGroupManagerRequest() {
    instanceGroupManager_ = "";
    project_ = "";
    requestId_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SuspendInstancesInstanceGroupManagerRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SuspendInstancesInstanceGroupManagerRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SuspendInstancesInstanceGroupManagerRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest.class,
            com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest.Builder.class);
  }

  private int bitField0_;
  public static final int INSTANCE_GROUP_MANAGER_FIELD_NUMBER = 249363395;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceGroupManager_ = "";

  /**
   *
   *
   * <pre>
   * The name of the managed instance group.
   * </pre>
   *
   * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceGroupManager.
   */
  @java.lang.Override
  public java.lang.String getInstanceGroupManager() {
    java.lang.Object ref = instanceGroupManager_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceGroupManager_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the managed instance group.
   * </pre>
   *
   * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for instanceGroupManager.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceGroupManagerBytes() {
    java.lang.Object ref = instanceGroupManager_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceGroupManager_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_GROUP_MANAGERS_SUSPEND_INSTANCES_REQUEST_RESOURCE_FIELD_NUMBER =
      46679761;
  private com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
      instanceGroupManagersSuspendInstancesRequestResource_;

  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the instanceGroupManagersSuspendInstancesRequestResource field is set.
   */
  @java.lang.Override
  public boolean hasInstanceGroupManagersSuspendInstancesRequestResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The instanceGroupManagersSuspendInstancesRequestResource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
      getInstanceGroupManagersSuspendInstancesRequestResource() {
    return instanceGroupManagersSuspendInstancesRequestResource_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
            .getDefaultInstance()
        : instanceGroupManagersSuspendInstancesRequestResource_;
  }

  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequestOrBuilder
      getInstanceGroupManagersSuspendInstancesRequestResourceOrBuilder() {
    return instanceGroupManagersSuspendInstancesRequestResource_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
            .getDefaultInstance()
        : instanceGroupManagersSuspendInstancesRequestResource_;
  }

  public static final int PROJECT_FIELD_NUMBER = 227560217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";

  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 37109963;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";

  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return Whether the requestId field is set.
   */
  @java.lang.Override
  public boolean hasRequestId() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * The name of the zone where the managed instance group is located.
   * </pre>
   *
   * <code>
   * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
   * </code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the zone where the managed instance group is located.
   * </pre>
   *
   * <code>
   * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
   * </code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37109963, requestId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(46679761, getInstanceGroupManagersSuspendInstancesRequestResource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupManager_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 249363395, instanceGroupManager_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37109963, requestId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              46679761, getInstanceGroupManagersSuspendInstancesRequestResource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instanceGroupManager_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              249363395, instanceGroupManager_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest other =
        (com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest) obj;

    if (!getInstanceGroupManager().equals(other.getInstanceGroupManager())) return false;
    if (hasInstanceGroupManagersSuspendInstancesRequestResource()
        != other.hasInstanceGroupManagersSuspendInstancesRequestResource()) return false;
    if (hasInstanceGroupManagersSuspendInstancesRequestResource()) {
      if (!getInstanceGroupManagersSuspendInstancesRequestResource()
          .equals(other.getInstanceGroupManagersSuspendInstancesRequestResource())) return false;
    }
    if (!getProject().equals(other.getProject())) return false;
    if (hasRequestId() != other.hasRequestId()) return false;
    if (hasRequestId()) {
      if (!getRequestId().equals(other.getRequestId())) return false;
    }
    if (!getZone().equals(other.getZone())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTANCE_GROUP_MANAGER_FIELD_NUMBER;
    hash = (53 * hash) + getInstanceGroupManager().hashCode();
    if (hasInstanceGroupManagersSuspendInstancesRequestResource()) {
      hash = (37 * hash) + INSTANCE_GROUP_MANAGERS_SUSPEND_INSTANCES_REQUEST_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceGroupManagersSuspendInstancesRequestResource().hashCode();
    }
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    if (hasRequestId()) {
      hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRequestId().hashCode();
    }
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A request message for InstanceGroupManagers.SuspendInstances. See the method description for details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest)
      com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SuspendInstancesInstanceGroupManagerRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SuspendInstancesInstanceGroupManagerRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest.class,
              com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInstanceGroupManagersSuspendInstancesRequestResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      instanceGroupManager_ = "";
      instanceGroupManagersSuspendInstancesRequestResource_ = null;
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ != null) {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_.dispose();
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_ = null;
      }
      project_ = "";
      requestId_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SuspendInstancesInstanceGroupManagerRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest build() {
      com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest buildPartial() {
      com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest result =
          new com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.instanceGroupManager_ = instanceGroupManager_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.instanceGroupManagersSuspendInstancesRequestResource_ =
            instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null
                ? instanceGroupManagersSuspendInstancesRequestResource_
                : instanceGroupManagersSuspendInstancesRequestResourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.project_ = project_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.zone_ = zone_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest) {
        return mergeFrom(
            (com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest other) {
      if (other
          == com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
              .getDefaultInstance()) return this;
      if (!other.getInstanceGroupManager().isEmpty()) {
        instanceGroupManager_ = other.instanceGroupManager_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasInstanceGroupManagersSuspendInstancesRequestResource()) {
        mergeInstanceGroupManagersSuspendInstancesRequestResource(
            other.getInstanceGroupManagersSuspendInstancesRequestResource());
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRequestId()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 29957474
            case 296879706:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 296879706
            case 373438090:
              {
                input.readMessage(
                    getInstanceGroupManagersSuspendInstancesRequestResourceFieldBuilder()
                        .getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 373438090
            case 1820481738:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1820481738
            case 1994907162:
              {
                instanceGroupManager_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1994907162
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object instanceGroupManager_ = "";

    /**
     *
     *
     * <pre>
     * The name of the managed instance group.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceGroupManager.
     */
    public java.lang.String getInstanceGroupManager() {
      java.lang.Object ref = instanceGroupManager_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceGroupManager_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the managed instance group.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for instanceGroupManager.
     */
    public com.google.protobuf.ByteString getInstanceGroupManagerBytes() {
      java.lang.Object ref = instanceGroupManager_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceGroupManager_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the managed instance group.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The instanceGroupManager to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupManager(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceGroupManager_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the managed instance group.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceGroupManager() {
      instanceGroupManager_ = getDefaultInstance().getInstanceGroupManager();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the managed instance group.
     * </pre>
     *
     * <code>string instance_group_manager = 249363395 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for instanceGroupManager to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupManagerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceGroupManager_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
        instanceGroupManagersSuspendInstancesRequestResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest,
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequestOrBuilder>
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_;

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the instanceGroupManagersSuspendInstancesRequestResource field is set.
     */
    public boolean hasInstanceGroupManagersSuspendInstancesRequestResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The instanceGroupManagersSuspendInstancesRequestResource.
     */
    public com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
        getInstanceGroupManagersSuspendInstancesRequestResource() {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null) {
        return instanceGroupManagersSuspendInstancesRequestResource_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
                .getDefaultInstance()
            : instanceGroupManagersSuspendInstancesRequestResource_;
      } else {
        return instanceGroupManagersSuspendInstancesRequestResourceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceGroupManagersSuspendInstancesRequestResource(
        com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest value) {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instanceGroupManagersSuspendInstancesRequestResource_ = value;
      } else {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInstanceGroupManagersSuspendInstancesRequestResource(
        com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest.Builder
            builderForValue) {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null) {
        instanceGroupManagersSuspendInstancesRequestResource_ = builderForValue.build();
      } else {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_.setMessage(
            builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInstanceGroupManagersSuspendInstancesRequestResource(
        com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest value) {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && instanceGroupManagersSuspendInstancesRequestResource_ != null
            && instanceGroupManagersSuspendInstancesRequestResource_
                != com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
                    .getDefaultInstance()) {
          getInstanceGroupManagersSuspendInstancesRequestResourceBuilder().mergeFrom(value);
        } else {
          instanceGroupManagersSuspendInstancesRequestResource_ = value;
        }
      } else {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_.mergeFrom(value);
      }
      if (instanceGroupManagersSuspendInstancesRequestResource_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInstanceGroupManagersSuspendInstancesRequestResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      instanceGroupManagersSuspendInstancesRequestResource_ = null;
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ != null) {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_.dispose();
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest.Builder
        getInstanceGroupManagersSuspendInstancesRequestResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getInstanceGroupManagersSuspendInstancesRequestResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequestOrBuilder
        getInstanceGroupManagersSuspendInstancesRequestResourceOrBuilder() {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ != null) {
        return instanceGroupManagersSuspendInstancesRequestResourceBuilder_.getMessageOrBuilder();
      } else {
        return instanceGroupManagersSuspendInstancesRequestResource_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest
                .getDefaultInstance()
            : instanceGroupManagersSuspendInstancesRequestResource_;
      }
    }

    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest instance_group_managers_suspend_instances_request_resource = 46679761 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest,
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequestOrBuilder>
        getInstanceGroupManagersSuspendInstancesRequestResourceFieldBuilder() {
      if (instanceGroupManagersSuspendInstancesRequestResourceBuilder_ == null) {
        instanceGroupManagersSuspendInstancesRequestResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest,
                com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequest.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagersSuspendInstancesRequestOrBuilder>(
                getInstanceGroupManagersSuspendInstancesRequestResource(),
                getParentForChildren(),
                isClean());
        instanceGroupManagersSuspendInstancesRequestResource_ = null;
      }
      return instanceGroupManagersSuspendInstancesRequestResourceBuilder_;
    }

    private java.lang.Object project_ = "";

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return Whether the requestId field is set.
     */
    public boolean hasRequestId() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * The name of the zone where the managed instance group is located.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the zone where the managed instance group is located.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the zone where the managed instance group is located.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the zone where the managed instance group is located.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the zone where the managed instance group is located.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest)
  private static final com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest();
  }

  public static com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SuspendInstancesInstanceGroupManagerRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<SuspendInstancesInstanceGroupManagerRequest>() {
            @java.lang.Override
            public SuspendInstancesInstanceGroupManagerRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<SuspendInstancesInstanceGroupManagerRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SuspendInstancesInstanceGroupManagerRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SuspendInstancesInstanceGroupManagerRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
