/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a URL Map resource. Compute Engine has two URL Map resources: * [Global](/compute/docs/reference/rest/v1/urlMaps) * [Regional](/compute/docs/reference/rest/v1/regionUrlMaps) A URL map resource is a component of certain types of cloud load balancers and Traffic Director: * urlMaps are used by global external Application Load Balancers, classic Application Load Balancers, and cross-region internal Application Load Balancers. * regionUrlMaps are used by internal Application Load Balancers, regional external Application Load Balancers and regional internal Application Load Balancers. For a list of supported URL map features by the load balancer type, see the Load balancing features: Routing and traffic management table. For a list of supported URL map features for Traffic Director, see the Traffic Director features: Routing and traffic management table. This resource defines mappings from hostnames and URL paths to either a backend service or a backend bucket. To use the global urlMaps resource, the backend service must have a loadBalancingScheme of either EXTERNAL, EXTERNAL_MANAGED, or INTERNAL_SELF_MANAGED. To use the regionUrlMaps resource, the backend service must have a loadBalancingScheme of INTERNAL_MANAGED. For more information, read URL Map Concepts.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.UrlMap}
 */
public final class UrlMap extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.UrlMap)
    UrlMapOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UrlMap.newBuilder() to construct.
  private UrlMap(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UrlMap() {
    creationTimestamp_ = "";
    defaultService_ = "";
    description_ = "";
    fingerprint_ = "";
    hostRules_ = java.util.Collections.emptyList();
    kind_ = "";
    name_ = "";
    pathMatchers_ = java.util.Collections.emptyList();
    region_ = "";
    selfLink_ = "";
    tests_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UrlMap();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMap_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMap_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.UrlMap.class,
            com.google.cloud.compute.v1.UrlMap.Builder.class);
  }

  private int bitField0_;
  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_CUSTOM_ERROR_RESPONSE_POLICY_FIELD_NUMBER = 81266089;
  private com.google.cloud.compute.v1.CustomErrorResponsePolicy defaultCustomErrorResponsePolicy_;

  /**
   *
   *
   * <pre>
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
   * </code>
   *
   * @return Whether the defaultCustomErrorResponsePolicy field is set.
   */
  @java.lang.Override
  public boolean hasDefaultCustomErrorResponsePolicy() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
   * </code>
   *
   * @return The defaultCustomErrorResponsePolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomErrorResponsePolicy
      getDefaultCustomErrorResponsePolicy() {
    return defaultCustomErrorResponsePolicy_ == null
        ? com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance()
        : defaultCustomErrorResponsePolicy_;
  }

  /**
   *
   *
   * <pre>
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder
      getDefaultCustomErrorResponsePolicyOrBuilder() {
    return defaultCustomErrorResponsePolicy_ == null
        ? com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance()
        : defaultCustomErrorResponsePolicy_;
  }

  public static final int DEFAULT_ROUTE_ACTION_FIELD_NUMBER = 378919466;
  private com.google.cloud.compute.v1.HttpRouteAction defaultRouteAction_;

  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   *
   * @return Whether the defaultRouteAction field is set.
   */
  @java.lang.Override
  public boolean hasDefaultRouteAction() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   *
   * @return The defaultRouteAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteAction getDefaultRouteAction() {
    return defaultRouteAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : defaultRouteAction_;
  }

  /**
   *
   *
   * <pre>
   * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getDefaultRouteActionOrBuilder() {
    return defaultRouteAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : defaultRouteAction_;
  }

  public static final int DEFAULT_SERVICE_FIELD_NUMBER = 370242231;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultService_ = "";

  /**
   *
   *
   * <pre>
   * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return Whether the defaultService field is set.
   */
  @java.lang.Override
  public boolean hasDefaultService() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return The defaultService.
   */
  @java.lang.Override
  public java.lang.String getDefaultService() {
    java.lang.Object ref = defaultService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional string default_service = 370242231;</code>
   *
   * @return The bytes for defaultService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultServiceBytes() {
    java.lang.Object ref = defaultService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFAULT_URL_REDIRECT_FIELD_NUMBER = 359503338;
  private com.google.cloud.compute.v1.HttpRedirectAction defaultUrlRedirect_;

  /**
   *
   *
   * <pre>
   * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   *
   * @return Whether the defaultUrlRedirect field is set.
   */
  @java.lang.Override
  public boolean hasDefaultUrlRedirect() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   *
   * @return The defaultUrlRedirect.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectAction getDefaultUrlRedirect() {
    return defaultUrlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : defaultUrlRedirect_;
  }

  /**
   *
   *
   * <pre>
   * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getDefaultUrlRedirectOrBuilder() {
    return defaultUrlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : defaultUrlRedirect_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_ACTION_FIELD_NUMBER = 328077352;
  private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return Whether the headerAction field is set.
   */
  @java.lang.Override
  public boolean hasHeaderAction() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return The headerAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  public static final int HOST_RULES_FIELD_NUMBER = 311804832;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HostRule> hostRules_;

  /**
   *
   *
   * <pre>
   * The list of host rules to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HostRule> getHostRulesList() {
    return hostRules_;
  }

  /**
   *
   *
   * <pre>
   * The list of host rules to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HostRuleOrBuilder>
      getHostRulesOrBuilderList() {
    return hostRules_;
  }

  /**
   *
   *
   * <pre>
   * The list of host rules to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
   */
  @java.lang.Override
  public int getHostRulesCount() {
    return hostRules_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of host rules to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HostRule getHostRules(int index) {
    return hostRules_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of host rules to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HostRuleOrBuilder getHostRulesOrBuilder(int index) {
    return hostRules_.get(index);
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH_MATCHERS_FIELD_NUMBER = 271664219;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.PathMatcher> pathMatchers_;

  /**
   *
   *
   * <pre>
   * The list of named PathMatchers to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.PathMatcher> getPathMatchersList() {
    return pathMatchers_;
  }

  /**
   *
   *
   * <pre>
   * The list of named PathMatchers to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.PathMatcherOrBuilder>
      getPathMatchersOrBuilderList() {
    return pathMatchers_;
  }

  /**
   *
   *
   * <pre>
   * The list of named PathMatchers to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
   */
  @java.lang.Override
  public int getPathMatchersCount() {
    return pathMatchers_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of named PathMatchers to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PathMatcher getPathMatchers(int index) {
    return pathMatchers_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of named PathMatchers to use against the URL.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PathMatcherOrBuilder getPathMatchersOrBuilder(int index) {
    return pathMatchers_.get(index);
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TESTS_FIELD_NUMBER = 110251553;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.UrlMapTest> tests_;

  /**
   *
   *
   * <pre>
   * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.UrlMapTest> getTestsList() {
    return tests_;
  }

  /**
   *
   *
   * <pre>
   * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.UrlMapTestOrBuilder>
      getTestsOrBuilderList() {
    return tests_;
  }

  /**
   *
   *
   * <pre>
   * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
   */
  @java.lang.Override
  public int getTestsCount() {
    return tests_.size();
  }

  /**
   *
   *
   * <pre>
   * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapTest getTests(int index) {
    return tests_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapTestOrBuilder getTestsOrBuilder(int index) {
    return tests_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(81266089, getDefaultCustomErrorResponsePolicy());
    }
    for (int i = 0; i < tests_.size(); i++) {
      output.writeMessage(110251553, tests_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    for (int i = 0; i < pathMatchers_.size(); i++) {
      output.writeMessage(271664219, pathMatchers_.get(i));
    }
    for (int i = 0; i < hostRules_.size(); i++) {
      output.writeMessage(311804832, hostRules_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(359503338, getDefaultUrlRedirect());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 370242231, defaultService_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(378919466, getDefaultRouteAction());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              81266089, getDefaultCustomErrorResponsePolicy());
    }
    for (int i = 0; i < tests_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(110251553, tests_.get(i));
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    for (int i = 0; i < pathMatchers_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(271664219, pathMatchers_.get(i));
    }
    for (int i = 0; i < hostRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(311804832, hostRules_.get(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              359503338, getDefaultUrlRedirect());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(370242231, defaultService_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              378919466, getDefaultRouteAction());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.UrlMap)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.UrlMap other = (com.google.cloud.compute.v1.UrlMap) obj;

    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDefaultCustomErrorResponsePolicy() != other.hasDefaultCustomErrorResponsePolicy())
      return false;
    if (hasDefaultCustomErrorResponsePolicy()) {
      if (!getDefaultCustomErrorResponsePolicy()
          .equals(other.getDefaultCustomErrorResponsePolicy())) return false;
    }
    if (hasDefaultRouteAction() != other.hasDefaultRouteAction()) return false;
    if (hasDefaultRouteAction()) {
      if (!getDefaultRouteAction().equals(other.getDefaultRouteAction())) return false;
    }
    if (hasDefaultService() != other.hasDefaultService()) return false;
    if (hasDefaultService()) {
      if (!getDefaultService().equals(other.getDefaultService())) return false;
    }
    if (hasDefaultUrlRedirect() != other.hasDefaultUrlRedirect()) return false;
    if (hasDefaultUrlRedirect()) {
      if (!getDefaultUrlRedirect().equals(other.getDefaultUrlRedirect())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasHeaderAction() != other.hasHeaderAction()) return false;
    if (hasHeaderAction()) {
      if (!getHeaderAction().equals(other.getHeaderAction())) return false;
    }
    if (!getHostRulesList().equals(other.getHostRulesList())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getPathMatchersList().equals(other.getPathMatchersList())) return false;
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getTestsList().equals(other.getTestsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDefaultCustomErrorResponsePolicy()) {
      hash = (37 * hash) + DEFAULT_CUSTOM_ERROR_RESPONSE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultCustomErrorResponsePolicy().hashCode();
    }
    if (hasDefaultRouteAction()) {
      hash = (37 * hash) + DEFAULT_ROUTE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultRouteAction().hashCode();
    }
    if (hasDefaultService()) {
      hash = (37 * hash) + DEFAULT_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultService().hashCode();
    }
    if (hasDefaultUrlRedirect()) {
      hash = (37 * hash) + DEFAULT_URL_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultUrlRedirect().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasHeaderAction()) {
      hash = (37 * hash) + HEADER_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderAction().hashCode();
    }
    if (getHostRulesCount() > 0) {
      hash = (37 * hash) + HOST_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getHostRulesList().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getPathMatchersCount() > 0) {
      hash = (37 * hash) + PATH_MATCHERS_FIELD_NUMBER;
      hash = (53 * hash) + getPathMatchersList().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getTestsCount() > 0) {
      hash = (37 * hash) + TESTS_FIELD_NUMBER;
      hash = (53 * hash) + getTestsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMap parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMap parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMap parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.UrlMap prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents a URL Map resource. Compute Engine has two URL Map resources: * [Global](/compute/docs/reference/rest/v1/urlMaps) * [Regional](/compute/docs/reference/rest/v1/regionUrlMaps) A URL map resource is a component of certain types of cloud load balancers and Traffic Director: * urlMaps are used by global external Application Load Balancers, classic Application Load Balancers, and cross-region internal Application Load Balancers. * regionUrlMaps are used by internal Application Load Balancers, regional external Application Load Balancers and regional internal Application Load Balancers. For a list of supported URL map features by the load balancer type, see the Load balancing features: Routing and traffic management table. For a list of supported URL map features for Traffic Director, see the Traffic Director features: Routing and traffic management table. This resource defines mappings from hostnames and URL paths to either a backend service or a backend bucket. To use the global urlMaps resource, the backend service must have a loadBalancingScheme of either EXTERNAL, EXTERNAL_MANAGED, or INTERNAL_SELF_MANAGED. To use the regionUrlMaps resource, the backend service must have a loadBalancingScheme of INTERNAL_MANAGED. For more information, read URL Map Concepts.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.UrlMap}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.UrlMap)
      com.google.cloud.compute.v1.UrlMapOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMap_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMap_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.UrlMap.class,
              com.google.cloud.compute.v1.UrlMap.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.UrlMap.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDefaultCustomErrorResponsePolicyFieldBuilder();
        getDefaultRouteActionFieldBuilder();
        getDefaultUrlRedirectFieldBuilder();
        getHeaderActionFieldBuilder();
        getHostRulesFieldBuilder();
        getPathMatchersFieldBuilder();
        getTestsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      creationTimestamp_ = "";
      defaultCustomErrorResponsePolicy_ = null;
      if (defaultCustomErrorResponsePolicyBuilder_ != null) {
        defaultCustomErrorResponsePolicyBuilder_.dispose();
        defaultCustomErrorResponsePolicyBuilder_ = null;
      }
      defaultRouteAction_ = null;
      if (defaultRouteActionBuilder_ != null) {
        defaultRouteActionBuilder_.dispose();
        defaultRouteActionBuilder_ = null;
      }
      defaultService_ = "";
      defaultUrlRedirect_ = null;
      if (defaultUrlRedirectBuilder_ != null) {
        defaultUrlRedirectBuilder_.dispose();
        defaultUrlRedirectBuilder_ = null;
      }
      description_ = "";
      fingerprint_ = "";
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      if (hostRulesBuilder_ == null) {
        hostRules_ = java.util.Collections.emptyList();
      } else {
        hostRules_ = null;
        hostRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      id_ = 0L;
      kind_ = "";
      name_ = "";
      if (pathMatchersBuilder_ == null) {
        pathMatchers_ = java.util.Collections.emptyList();
      } else {
        pathMatchers_ = null;
        pathMatchersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      region_ = "";
      selfLink_ = "";
      if (testsBuilder_ == null) {
        tests_ = java.util.Collections.emptyList();
      } else {
        tests_ = null;
        testsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMap_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMap getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.UrlMap.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMap build() {
      com.google.cloud.compute.v1.UrlMap result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMap buildPartial() {
      com.google.cloud.compute.v1.UrlMap result = new com.google.cloud.compute.v1.UrlMap(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.UrlMap result) {
      if (hostRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          hostRules_ = java.util.Collections.unmodifiableList(hostRules_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.hostRules_ = hostRules_;
      } else {
        result.hostRules_ = hostRulesBuilder_.build();
      }
      if (pathMatchersBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          pathMatchers_ = java.util.Collections.unmodifiableList(pathMatchers_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.pathMatchers_ = pathMatchers_;
      } else {
        result.pathMatchers_ = pathMatchersBuilder_.build();
      }
      if (testsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          tests_ = java.util.Collections.unmodifiableList(tests_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.tests_ = tests_;
      } else {
        result.tests_ = testsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.UrlMap result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.defaultCustomErrorResponsePolicy_ =
            defaultCustomErrorResponsePolicyBuilder_ == null
                ? defaultCustomErrorResponsePolicy_
                : defaultCustomErrorResponsePolicyBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.defaultRouteAction_ =
            defaultRouteActionBuilder_ == null
                ? defaultRouteAction_
                : defaultRouteActionBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.defaultService_ = defaultService_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.defaultUrlRedirect_ =
            defaultUrlRedirectBuilder_ == null
                ? defaultUrlRedirect_
                : defaultUrlRedirectBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.headerAction_ =
            headerActionBuilder_ == null ? headerAction_ : headerActionBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00001000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.UrlMap) {
        return mergeFrom((com.google.cloud.compute.v1.UrlMap) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.UrlMap other) {
      if (other == com.google.cloud.compute.v1.UrlMap.getDefaultInstance()) return this;
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDefaultCustomErrorResponsePolicy()) {
        mergeDefaultCustomErrorResponsePolicy(other.getDefaultCustomErrorResponsePolicy());
      }
      if (other.hasDefaultRouteAction()) {
        mergeDefaultRouteAction(other.getDefaultRouteAction());
      }
      if (other.hasDefaultService()) {
        defaultService_ = other.defaultService_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDefaultUrlRedirect()) {
        mergeDefaultUrlRedirect(other.getDefaultUrlRedirect());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasHeaderAction()) {
        mergeHeaderAction(other.getHeaderAction());
      }
      if (hostRulesBuilder_ == null) {
        if (!other.hostRules_.isEmpty()) {
          if (hostRules_.isEmpty()) {
            hostRules_ = other.hostRules_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureHostRulesIsMutable();
            hostRules_.addAll(other.hostRules_);
          }
          onChanged();
        }
      } else {
        if (!other.hostRules_.isEmpty()) {
          if (hostRulesBuilder_.isEmpty()) {
            hostRulesBuilder_.dispose();
            hostRulesBuilder_ = null;
            hostRules_ = other.hostRules_;
            bitField0_ = (bitField0_ & ~0x00000100);
            hostRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHostRulesFieldBuilder()
                    : null;
          } else {
            hostRulesBuilder_.addAllMessages(other.hostRules_);
          }
        }
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (pathMatchersBuilder_ == null) {
        if (!other.pathMatchers_.isEmpty()) {
          if (pathMatchers_.isEmpty()) {
            pathMatchers_ = other.pathMatchers_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensurePathMatchersIsMutable();
            pathMatchers_.addAll(other.pathMatchers_);
          }
          onChanged();
        }
      } else {
        if (!other.pathMatchers_.isEmpty()) {
          if (pathMatchersBuilder_.isEmpty()) {
            pathMatchersBuilder_.dispose();
            pathMatchersBuilder_ = null;
            pathMatchers_ = other.pathMatchers_;
            bitField0_ = (bitField0_ & ~0x00001000);
            pathMatchersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPathMatchersFieldBuilder()
                    : null;
          } else {
            pathMatchersBuilder_.addAllMessages(other.pathMatchers_);
          }
        }
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (testsBuilder_ == null) {
        if (!other.tests_.isEmpty()) {
          if (tests_.isEmpty()) {
            tests_ = other.tests_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensureTestsIsMutable();
            tests_.addAll(other.tests_);
          }
          onChanged();
        }
      } else {
        if (!other.tests_.isEmpty()) {
          if (testsBuilder_.isEmpty()) {
            testsBuilder_.dispose();
            testsBuilder_ = null;
            tests_ = other.tests_;
            bitField0_ = (bitField0_ & ~0x00008000);
            testsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTestsFieldBuilder()
                    : null;
          } else {
            testsBuilder_.addAllMessages(other.tests_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 244202930
            case 650128714:
              {
                input.readMessage(
                    getDefaultCustomErrorResponsePolicyFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 650128714
            case 882012426:
              {
                com.google.cloud.compute.v1.UrlMapTest m =
                    input.readMessage(
                        com.google.cloud.compute.v1.UrlMapTest.parser(), extensionRegistry);
                if (testsBuilder_ == null) {
                  ensureTestsIsMutable();
                  tests_.add(m);
                } else {
                  testsBuilder_.addMessage(m);
                }
                break;
              } // case 882012426
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1111570338
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1877428002
            case -2121653542:
              {
                com.google.cloud.compute.v1.PathMatcher m =
                    input.readMessage(
                        com.google.cloud.compute.v1.PathMatcher.parser(), extensionRegistry);
                if (pathMatchersBuilder_ == null) {
                  ensurePathMatchersIsMutable();
                  pathMatchers_.add(m);
                } else {
                  pathMatchersBuilder_.addMessage(m);
                }
                break;
              } // case -2121653542
            case -1800528638:
              {
                com.google.cloud.compute.v1.HostRule m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HostRule.parser(), extensionRegistry);
                if (hostRulesBuilder_ == null) {
                  ensureHostRulesIsMutable();
                  hostRules_.add(m);
                } else {
                  hostRulesBuilder_.addMessage(m);
                }
                break;
              } // case -1800528638
            case -1670348478:
              {
                input.readMessage(getHeaderActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -1670348478
            case -1418940590:
              {
                input.readMessage(
                    getDefaultUrlRedirectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -1418940590
            case -1333029446:
              {
                defaultService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1333029446
            case -1263611566:
              {
                input.readMessage(
                    getDefaultRouteActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -1263611566
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -911466526
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomErrorResponsePolicy defaultCustomErrorResponsePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomErrorResponsePolicy,
            com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder>
        defaultCustomErrorResponsePolicyBuilder_;

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     *
     * @return Whether the defaultCustomErrorResponsePolicy field is set.
     */
    public boolean hasDefaultCustomErrorResponsePolicy() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     *
     * @return The defaultCustomErrorResponsePolicy.
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicy
        getDefaultCustomErrorResponsePolicy() {
      if (defaultCustomErrorResponsePolicyBuilder_ == null) {
        return defaultCustomErrorResponsePolicy_ == null
            ? com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance()
            : defaultCustomErrorResponsePolicy_;
      } else {
        return defaultCustomErrorResponsePolicyBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public Builder setDefaultCustomErrorResponsePolicy(
        com.google.cloud.compute.v1.CustomErrorResponsePolicy value) {
      if (defaultCustomErrorResponsePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultCustomErrorResponsePolicy_ = value;
      } else {
        defaultCustomErrorResponsePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public Builder setDefaultCustomErrorResponsePolicy(
        com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder builderForValue) {
      if (defaultCustomErrorResponsePolicyBuilder_ == null) {
        defaultCustomErrorResponsePolicy_ = builderForValue.build();
      } else {
        defaultCustomErrorResponsePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public Builder mergeDefaultCustomErrorResponsePolicy(
        com.google.cloud.compute.v1.CustomErrorResponsePolicy value) {
      if (defaultCustomErrorResponsePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && defaultCustomErrorResponsePolicy_ != null
            && defaultCustomErrorResponsePolicy_
                != com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance()) {
          getDefaultCustomErrorResponsePolicyBuilder().mergeFrom(value);
        } else {
          defaultCustomErrorResponsePolicy_ = value;
        }
      } else {
        defaultCustomErrorResponsePolicyBuilder_.mergeFrom(value);
      }
      if (defaultCustomErrorResponsePolicy_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public Builder clearDefaultCustomErrorResponsePolicy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      defaultCustomErrorResponsePolicy_ = null;
      if (defaultCustomErrorResponsePolicyBuilder_ != null) {
        defaultCustomErrorResponsePolicyBuilder_.dispose();
        defaultCustomErrorResponsePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder
        getDefaultCustomErrorResponsePolicyBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDefaultCustomErrorResponsePolicyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder
        getDefaultCustomErrorResponsePolicyOrBuilder() {
      if (defaultCustomErrorResponsePolicyBuilder_ != null) {
        return defaultCustomErrorResponsePolicyBuilder_.getMessageOrBuilder();
      } else {
        return defaultCustomErrorResponsePolicy_ == null
            ? com.google.cloud.compute.v1.CustomErrorResponsePolicy.getDefaultInstance()
            : defaultCustomErrorResponsePolicy_;
      }
    }

    /**
     *
     *
     * <pre>
     * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when BackendServiceor BackendBucket responds with an error. This policy takes effect at the load balancer level and applies only when no policy has been defined for the error code at lower levels like PathMatcher, RouteRule and PathRule within this UrlMap. For example, consider a UrlMap with the following configuration: - defaultCustomErrorResponsePolicy containing policies for responding to 5xx and 4xx errors - A PathMatcher configured for *.example.com has defaultCustomErrorResponsePolicy for 4xx. If a request for http://www.example.com/ encounters a 404, the policy in pathMatcher.defaultCustomErrorResponsePolicy will be enforced. When the request for http://www.example.com/ encounters a 502, the policy in UrlMap.defaultCustomErrorResponsePolicy will be enforced. When a request that does not match any host in *.example.com such as http://www.myotherexample.com/, encounters a 404, UrlMap.defaultCustomErrorResponsePolicy takes effect. When used in conjunction with defaultRouteAction.retryPolicy, retries take precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is applied. While attempting a retry, if load balancer is successful in reaching the service, the defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to the client. defaultCustomErrorResponsePolicy is supported only for global external Application Load Balancers.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomErrorResponsePolicy default_custom_error_response_policy = 81266089;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomErrorResponsePolicy,
            com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder,
            com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder>
        getDefaultCustomErrorResponsePolicyFieldBuilder() {
      if (defaultCustomErrorResponsePolicyBuilder_ == null) {
        defaultCustomErrorResponsePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomErrorResponsePolicy,
                com.google.cloud.compute.v1.CustomErrorResponsePolicy.Builder,
                com.google.cloud.compute.v1.CustomErrorResponsePolicyOrBuilder>(
                getDefaultCustomErrorResponsePolicy(), getParentForChildren(), isClean());
        defaultCustomErrorResponsePolicy_ = null;
      }
      return defaultCustomErrorResponsePolicyBuilder_;
    }

    private com.google.cloud.compute.v1.HttpRouteAction defaultRouteAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        defaultRouteActionBuilder_;

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     *
     * @return Whether the defaultRouteAction field is set.
     */
    public boolean hasDefaultRouteAction() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     *
     * @return The defaultRouteAction.
     */
    public com.google.cloud.compute.v1.HttpRouteAction getDefaultRouteAction() {
      if (defaultRouteActionBuilder_ == null) {
        return defaultRouteAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : defaultRouteAction_;
      } else {
        return defaultRouteActionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder setDefaultRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (defaultRouteActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultRouteAction_ = value;
      } else {
        defaultRouteActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder setDefaultRouteAction(
        com.google.cloud.compute.v1.HttpRouteAction.Builder builderForValue) {
      if (defaultRouteActionBuilder_ == null) {
        defaultRouteAction_ = builderForValue.build();
      } else {
        defaultRouteActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder mergeDefaultRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (defaultRouteActionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && defaultRouteAction_ != null
            && defaultRouteAction_
                != com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()) {
          getDefaultRouteActionBuilder().mergeFrom(value);
        } else {
          defaultRouteAction_ = value;
        }
      } else {
        defaultRouteActionBuilder_.mergeFrom(value);
      }
      if (defaultRouteAction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public Builder clearDefaultRouteAction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      defaultRouteAction_ = null;
      if (defaultRouteActionBuilder_ != null) {
        defaultRouteActionBuilder_.dispose();
        defaultRouteActionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRouteAction.Builder getDefaultRouteActionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDefaultRouteActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getDefaultRouteActionOrBuilder() {
      if (defaultRouteActionBuilder_ != null) {
        return defaultRouteActionBuilder_.getMessageOrBuilder();
      } else {
        return defaultRouteAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : defaultRouteAction_;
      }
    }

    /**
     *
     *
     * <pre>
     * defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. URL maps for classic Application Load Balancers only support the urlRewrite action within defaultRouteAction. defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction default_route_action = 378919466;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        getDefaultRouteActionFieldBuilder() {
      if (defaultRouteActionBuilder_ == null) {
        defaultRouteActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteAction,
                com.google.cloud.compute.v1.HttpRouteAction.Builder,
                com.google.cloud.compute.v1.HttpRouteActionOrBuilder>(
                getDefaultRouteAction(), getParentForChildren(), isClean());
        defaultRouteAction_ = null;
      }
      return defaultRouteActionBuilder_;
    }

    private java.lang.Object defaultService_ = "";

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return Whether the defaultService field is set.
     */
    public boolean hasDefaultService() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return The defaultService.
     */
    public java.lang.String getDefaultService() {
      java.lang.Object ref = defaultService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return The bytes for defaultService.
     */
    public com.google.protobuf.ByteString getDefaultServiceBytes() {
      java.lang.Object ref = defaultService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @param value The defaultService to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultService_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultService() {
      defaultService_ = getDefaultInstance().getDefaultService();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL of the defaultService resource to which traffic is directed if none of the hostRules match. If defaultRouteAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. defaultService has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional string default_service = 370242231;</code>
     *
     * @param value The bytes for defaultService to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultService_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRedirectAction defaultUrlRedirect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        defaultUrlRedirectBuilder_;

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     *
     * @return Whether the defaultUrlRedirect field is set.
     */
    public boolean hasDefaultUrlRedirect() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     *
     * @return The defaultUrlRedirect.
     */
    public com.google.cloud.compute.v1.HttpRedirectAction getDefaultUrlRedirect() {
      if (defaultUrlRedirectBuilder_ == null) {
        return defaultUrlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : defaultUrlRedirect_;
      } else {
        return defaultUrlRedirectBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder setDefaultUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (defaultUrlRedirectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultUrlRedirect_ = value;
      } else {
        defaultUrlRedirectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder setDefaultUrlRedirect(
        com.google.cloud.compute.v1.HttpRedirectAction.Builder builderForValue) {
      if (defaultUrlRedirectBuilder_ == null) {
        defaultUrlRedirect_ = builderForValue.build();
      } else {
        defaultUrlRedirectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder mergeDefaultUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (defaultUrlRedirectBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && defaultUrlRedirect_ != null
            && defaultUrlRedirect_
                != com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()) {
          getDefaultUrlRedirectBuilder().mergeFrom(value);
        } else {
          defaultUrlRedirect_ = value;
        }
      } else {
        defaultUrlRedirectBuilder_.mergeFrom(value);
      }
      if (defaultUrlRedirect_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public Builder clearDefaultUrlRedirect() {
      bitField0_ = (bitField0_ & ~0x00000010);
      defaultUrlRedirect_ = null;
      if (defaultUrlRedirectBuilder_ != null) {
        defaultUrlRedirectBuilder_.dispose();
        defaultUrlRedirectBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRedirectAction.Builder getDefaultUrlRedirectBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDefaultUrlRedirectFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder
        getDefaultUrlRedirectOrBuilder() {
      if (defaultUrlRedirectBuilder_ != null) {
        return defaultUrlRedirectBuilder_.getMessageOrBuilder();
      } else {
        return defaultUrlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : defaultUrlRedirect_;
      }
    }

    /**
     *
     *
     * <pre>
     * When none of the specified hostRules match, the request is redirected to a URL specified by defaultUrlRedirect. Only one of defaultUrlRedirect, defaultService or defaultRouteAction.weightedBackendService can be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction default_url_redirect = 359503338;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        getDefaultUrlRedirectFieldBuilder() {
      if (defaultUrlRedirectBuilder_ == null) {
        defaultUrlRedirectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRedirectAction,
                com.google.cloud.compute.v1.HttpRedirectAction.Builder,
                com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>(
                getDefaultUrlRedirect(), getParentForChildren(), isClean());
        defaultUrlRedirect_ = null;
      }
      return defaultUrlRedirectBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field is ignored when inserting a UrlMap. An up-to-date fingerprint must be provided in order to update the UrlMap, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a UrlMap.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        headerActionBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return Whether the headerAction field is set.
     */
    public boolean hasHeaderAction() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return The headerAction.
     */
    public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
      if (headerActionBuilder_ == null) {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      } else {
        return headerActionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headerAction_ = value;
      } else {
        headerActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.HttpHeaderAction.Builder builderForValue) {
      if (headerActionBuilder_ == null) {
        headerAction_ = builderForValue.build();
      } else {
        headerActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder mergeHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && headerAction_ != null
            && headerAction_ != com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()) {
          getHeaderActionBuilder().mergeFrom(value);
        } else {
          headerAction_ = value;
        }
      } else {
        headerActionBuilder_.mergeFrom(value);
      }
      if (headerAction_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder clearHeaderAction() {
      bitField0_ = (bitField0_ & ~0x00000080);
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderAction.Builder getHeaderActionBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getHeaderActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
      if (headerActionBuilder_ != null) {
        return headerActionBuilder_.getMessageOrBuilder();
      } else {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction specified here take effect after headerAction specified under pathMatcher. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        getHeaderActionFieldBuilder() {
      if (headerActionBuilder_ == null) {
        headerActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderAction,
                com.google.cloud.compute.v1.HttpHeaderAction.Builder,
                com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>(
                getHeaderAction(), getParentForChildren(), isClean());
        headerAction_ = null;
      }
      return headerActionBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.HostRule> hostRules_ =
        java.util.Collections.emptyList();

    private void ensureHostRulesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        hostRules_ = new java.util.ArrayList<com.google.cloud.compute.v1.HostRule>(hostRules_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HostRule,
            com.google.cloud.compute.v1.HostRule.Builder,
            com.google.cloud.compute.v1.HostRuleOrBuilder>
        hostRulesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HostRule> getHostRulesList() {
      if (hostRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(hostRules_);
      } else {
        return hostRulesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public int getHostRulesCount() {
      if (hostRulesBuilder_ == null) {
        return hostRules_.size();
      } else {
        return hostRulesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public com.google.cloud.compute.v1.HostRule getHostRules(int index) {
      if (hostRulesBuilder_ == null) {
        return hostRules_.get(index);
      } else {
        return hostRulesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder setHostRules(int index, com.google.cloud.compute.v1.HostRule value) {
      if (hostRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostRulesIsMutable();
        hostRules_.set(index, value);
        onChanged();
      } else {
        hostRulesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder setHostRules(
        int index, com.google.cloud.compute.v1.HostRule.Builder builderForValue) {
      if (hostRulesBuilder_ == null) {
        ensureHostRulesIsMutable();
        hostRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        hostRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder addHostRules(com.google.cloud.compute.v1.HostRule value) {
      if (hostRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostRulesIsMutable();
        hostRules_.add(value);
        onChanged();
      } else {
        hostRulesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder addHostRules(int index, com.google.cloud.compute.v1.HostRule value) {
      if (hostRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostRulesIsMutable();
        hostRules_.add(index, value);
        onChanged();
      } else {
        hostRulesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder addHostRules(com.google.cloud.compute.v1.HostRule.Builder builderForValue) {
      if (hostRulesBuilder_ == null) {
        ensureHostRulesIsMutable();
        hostRules_.add(builderForValue.build());
        onChanged();
      } else {
        hostRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder addHostRules(
        int index, com.google.cloud.compute.v1.HostRule.Builder builderForValue) {
      if (hostRulesBuilder_ == null) {
        ensureHostRulesIsMutable();
        hostRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        hostRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder addAllHostRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HostRule> values) {
      if (hostRulesBuilder_ == null) {
        ensureHostRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, hostRules_);
        onChanged();
      } else {
        hostRulesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder clearHostRules() {
      if (hostRulesBuilder_ == null) {
        hostRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        hostRulesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public Builder removeHostRules(int index) {
      if (hostRulesBuilder_ == null) {
        ensureHostRulesIsMutable();
        hostRules_.remove(index);
        onChanged();
      } else {
        hostRulesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public com.google.cloud.compute.v1.HostRule.Builder getHostRulesBuilder(int index) {
      return getHostRulesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public com.google.cloud.compute.v1.HostRuleOrBuilder getHostRulesOrBuilder(int index) {
      if (hostRulesBuilder_ == null) {
        return hostRules_.get(index);
      } else {
        return hostRulesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HostRuleOrBuilder>
        getHostRulesOrBuilderList() {
      if (hostRulesBuilder_ != null) {
        return hostRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(hostRules_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public com.google.cloud.compute.v1.HostRule.Builder addHostRulesBuilder() {
      return getHostRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HostRule.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public com.google.cloud.compute.v1.HostRule.Builder addHostRulesBuilder(int index) {
      return getHostRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HostRule.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of host rules to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HostRule host_rules = 311804832;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HostRule.Builder> getHostRulesBuilderList() {
      return getHostRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HostRule,
            com.google.cloud.compute.v1.HostRule.Builder,
            com.google.cloud.compute.v1.HostRuleOrBuilder>
        getHostRulesFieldBuilder() {
      if (hostRulesBuilder_ == null) {
        hostRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HostRule,
                com.google.cloud.compute.v1.HostRule.Builder,
                com.google.cloud.compute.v1.HostRuleOrBuilder>(
                hostRules_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        hostRules_ = null;
      }
      return hostRulesBuilder_;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000200);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#urlMaps for url maps.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.PathMatcher> pathMatchers_ =
        java.util.Collections.emptyList();

    private void ensurePathMatchersIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        pathMatchers_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.PathMatcher>(pathMatchers_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PathMatcher,
            com.google.cloud.compute.v1.PathMatcher.Builder,
            com.google.cloud.compute.v1.PathMatcherOrBuilder>
        pathMatchersBuilder_;

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.PathMatcher> getPathMatchersList() {
      if (pathMatchersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(pathMatchers_);
      } else {
        return pathMatchersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public int getPathMatchersCount() {
      if (pathMatchersBuilder_ == null) {
        return pathMatchers_.size();
      } else {
        return pathMatchersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public com.google.cloud.compute.v1.PathMatcher getPathMatchers(int index) {
      if (pathMatchersBuilder_ == null) {
        return pathMatchers_.get(index);
      } else {
        return pathMatchersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder setPathMatchers(int index, com.google.cloud.compute.v1.PathMatcher value) {
      if (pathMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathMatchersIsMutable();
        pathMatchers_.set(index, value);
        onChanged();
      } else {
        pathMatchersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder setPathMatchers(
        int index, com.google.cloud.compute.v1.PathMatcher.Builder builderForValue) {
      if (pathMatchersBuilder_ == null) {
        ensurePathMatchersIsMutable();
        pathMatchers_.set(index, builderForValue.build());
        onChanged();
      } else {
        pathMatchersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder addPathMatchers(com.google.cloud.compute.v1.PathMatcher value) {
      if (pathMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathMatchersIsMutable();
        pathMatchers_.add(value);
        onChanged();
      } else {
        pathMatchersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder addPathMatchers(int index, com.google.cloud.compute.v1.PathMatcher value) {
      if (pathMatchersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathMatchersIsMutable();
        pathMatchers_.add(index, value);
        onChanged();
      } else {
        pathMatchersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder addPathMatchers(
        com.google.cloud.compute.v1.PathMatcher.Builder builderForValue) {
      if (pathMatchersBuilder_ == null) {
        ensurePathMatchersIsMutable();
        pathMatchers_.add(builderForValue.build());
        onChanged();
      } else {
        pathMatchersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder addPathMatchers(
        int index, com.google.cloud.compute.v1.PathMatcher.Builder builderForValue) {
      if (pathMatchersBuilder_ == null) {
        ensurePathMatchersIsMutable();
        pathMatchers_.add(index, builderForValue.build());
        onChanged();
      } else {
        pathMatchersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder addAllPathMatchers(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.PathMatcher> values) {
      if (pathMatchersBuilder_ == null) {
        ensurePathMatchersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pathMatchers_);
        onChanged();
      } else {
        pathMatchersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder clearPathMatchers() {
      if (pathMatchersBuilder_ == null) {
        pathMatchers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        pathMatchersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public Builder removePathMatchers(int index) {
      if (pathMatchersBuilder_ == null) {
        ensurePathMatchersIsMutable();
        pathMatchers_.remove(index);
        onChanged();
      } else {
        pathMatchersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public com.google.cloud.compute.v1.PathMatcher.Builder getPathMatchersBuilder(int index) {
      return getPathMatchersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public com.google.cloud.compute.v1.PathMatcherOrBuilder getPathMatchersOrBuilder(int index) {
      if (pathMatchersBuilder_ == null) {
        return pathMatchers_.get(index);
      } else {
        return pathMatchersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.PathMatcherOrBuilder>
        getPathMatchersOrBuilderList() {
      if (pathMatchersBuilder_ != null) {
        return pathMatchersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(pathMatchers_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public com.google.cloud.compute.v1.PathMatcher.Builder addPathMatchersBuilder() {
      return getPathMatchersFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.PathMatcher.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public com.google.cloud.compute.v1.PathMatcher.Builder addPathMatchersBuilder(int index) {
      return getPathMatchersFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.PathMatcher.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of named PathMatchers to use against the URL.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.PathMatcher path_matchers = 271664219;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.PathMatcher.Builder>
        getPathMatchersBuilderList() {
      return getPathMatchersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.PathMatcher,
            com.google.cloud.compute.v1.PathMatcher.Builder,
            com.google.cloud.compute.v1.PathMatcherOrBuilder>
        getPathMatchersFieldBuilder() {
      if (pathMatchersBuilder_ == null) {
        pathMatchersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.PathMatcher,
                com.google.cloud.compute.v1.PathMatcher.Builder,
                com.google.cloud.compute.v1.PathMatcherOrBuilder>(
                pathMatchers_, ((bitField0_ & 0x00001000) != 0), getParentForChildren(), isClean());
        pathMatchers_ = null;
      }
      return pathMatchersBuilder_;
    }

    private java.lang.Object region_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional URL map resides. This field is not applicable to global URL maps. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.UrlMapTest> tests_ =
        java.util.Collections.emptyList();

    private void ensureTestsIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        tests_ = new java.util.ArrayList<com.google.cloud.compute.v1.UrlMapTest>(tests_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMapTest,
            com.google.cloud.compute.v1.UrlMapTest.Builder,
            com.google.cloud.compute.v1.UrlMapTestOrBuilder>
        testsBuilder_;

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.UrlMapTest> getTestsList() {
      if (testsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tests_);
      } else {
        return testsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public int getTestsCount() {
      if (testsBuilder_ == null) {
        return tests_.size();
      } else {
        return testsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTest getTests(int index) {
      if (testsBuilder_ == null) {
        return tests_.get(index);
      } else {
        return testsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder setTests(int index, com.google.cloud.compute.v1.UrlMapTest value) {
      if (testsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestsIsMutable();
        tests_.set(index, value);
        onChanged();
      } else {
        testsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder setTests(
        int index, com.google.cloud.compute.v1.UrlMapTest.Builder builderForValue) {
      if (testsBuilder_ == null) {
        ensureTestsIsMutable();
        tests_.set(index, builderForValue.build());
        onChanged();
      } else {
        testsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder addTests(com.google.cloud.compute.v1.UrlMapTest value) {
      if (testsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestsIsMutable();
        tests_.add(value);
        onChanged();
      } else {
        testsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder addTests(int index, com.google.cloud.compute.v1.UrlMapTest value) {
      if (testsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestsIsMutable();
        tests_.add(index, value);
        onChanged();
      } else {
        testsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder addTests(com.google.cloud.compute.v1.UrlMapTest.Builder builderForValue) {
      if (testsBuilder_ == null) {
        ensureTestsIsMutable();
        tests_.add(builderForValue.build());
        onChanged();
      } else {
        testsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder addTests(
        int index, com.google.cloud.compute.v1.UrlMapTest.Builder builderForValue) {
      if (testsBuilder_ == null) {
        ensureTestsIsMutable();
        tests_.add(index, builderForValue.build());
        onChanged();
      } else {
        testsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder addAllTests(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.UrlMapTest> values) {
      if (testsBuilder_ == null) {
        ensureTestsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tests_);
        onChanged();
      } else {
        testsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder clearTests() {
      if (testsBuilder_ == null) {
        tests_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        testsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public Builder removeTests(int index) {
      if (testsBuilder_ == null) {
        ensureTestsIsMutable();
        tests_.remove(index);
        onChanged();
      } else {
        testsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTest.Builder getTestsBuilder(int index) {
      return getTestsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTestOrBuilder getTestsOrBuilder(int index) {
      if (testsBuilder_ == null) {
        return tests_.get(index);
      } else {
        return testsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.UrlMapTestOrBuilder>
        getTestsOrBuilderList() {
      if (testsBuilder_ != null) {
        return testsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tests_);
      }
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTest.Builder addTestsBuilder() {
      return getTestsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.UrlMapTest.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public com.google.cloud.compute.v1.UrlMapTest.Builder addTestsBuilder(int index) {
      return getTestsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.UrlMapTest.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The list of expected URL mapping tests. Request to update the UrlMap succeeds only if all test cases pass. You can specify a maximum of 100 tests per UrlMap. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.UrlMapTest tests = 110251553;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.UrlMapTest.Builder> getTestsBuilderList() {
      return getTestsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMapTest,
            com.google.cloud.compute.v1.UrlMapTest.Builder,
            com.google.cloud.compute.v1.UrlMapTestOrBuilder>
        getTestsFieldBuilder() {
      if (testsBuilder_ == null) {
        testsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.UrlMapTest,
                com.google.cloud.compute.v1.UrlMapTest.Builder,
                com.google.cloud.compute.v1.UrlMapTestOrBuilder>(
                tests_, ((bitField0_ & 0x00008000) != 0), getParentForChildren(), isClean());
        tests_ = null;
      }
      return testsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.UrlMap)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.UrlMap)
  private static final com.google.cloud.compute.v1.UrlMap DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.UrlMap();
  }

  public static com.google.cloud.compute.v1.UrlMap getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UrlMap> PARSER =
      new com.google.protobuf.AbstractParser<UrlMap>() {
        @java.lang.Override
        public UrlMap parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UrlMap> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UrlMap> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMap getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
