/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Message representing the validation result for a UrlMap.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.UrlMapValidationResult}
 */
public final class UrlMapValidationResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.UrlMapValidationResult)
    UrlMapValidationResultOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UrlMapValidationResult.newBuilder() to construct.
  private UrlMapValidationResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UrlMapValidationResult() {
    loadErrors_ = com.google.protobuf.LazyStringArrayList.emptyList();
    testFailures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UrlMapValidationResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMapValidationResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMapValidationResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.UrlMapValidationResult.class,
            com.google.cloud.compute.v1.UrlMapValidationResult.Builder.class);
  }

  private int bitField0_;
  public static final int LOAD_ERRORS_FIELD_NUMBER = 310147300;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList loadErrors_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   * <code>repeated string load_errors = 310147300;</code>
   *
   * @return A list containing the loadErrors.
   */
  public com.google.protobuf.ProtocolStringList getLoadErrorsList() {
    return loadErrors_;
  }

  /**
   * <code>repeated string load_errors = 310147300;</code>
   *
   * @return The count of loadErrors.
   */
  public int getLoadErrorsCount() {
    return loadErrors_.size();
  }

  /**
   * <code>repeated string load_errors = 310147300;</code>
   *
   * @param index The index of the element to return.
   * @return The loadErrors at the given index.
   */
  public java.lang.String getLoadErrors(int index) {
    return loadErrors_.get(index);
  }

  /**
   * <code>repeated string load_errors = 310147300;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the loadErrors at the given index.
   */
  public com.google.protobuf.ByteString getLoadErrorsBytes(int index) {
    return loadErrors_.getByteString(index);
  }

  public static final int LOAD_SUCCEEDED_FIELD_NUMBER = 128326216;
  private boolean loadSucceeded_ = false;

  /**
   *
   *
   * <pre>
   * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
   * </pre>
   *
   * <code>optional bool load_succeeded = 128326216;</code>
   *
   * @return Whether the loadSucceeded field is set.
   */
  @java.lang.Override
  public boolean hasLoadSucceeded() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
   * </pre>
   *
   * <code>optional bool load_succeeded = 128326216;</code>
   *
   * @return The loadSucceeded.
   */
  @java.lang.Override
  public boolean getLoadSucceeded() {
    return loadSucceeded_;
  }

  public static final int TEST_FAILURES_FIELD_NUMBER = 505934134;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.TestFailure> testFailures_;

  /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.TestFailure> getTestFailuresList() {
    return testFailures_;
  }

  /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.TestFailureOrBuilder>
      getTestFailuresOrBuilderList() {
    return testFailures_;
  }

  /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
  @java.lang.Override
  public int getTestFailuresCount() {
    return testFailures_.size();
  }

  /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.TestFailure getTestFailures(int index) {
    return testFailures_.get(index);
  }

  /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.TestFailureOrBuilder getTestFailuresOrBuilder(int index) {
    return testFailures_.get(index);
  }

  public static final int TEST_PASSED_FIELD_NUMBER = 192708797;
  private boolean testPassed_ = false;

  /**
   *
   *
   * <pre>
   * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
   * </pre>
   *
   * <code>optional bool test_passed = 192708797;</code>
   *
   * @return Whether the testPassed field is set.
   */
  @java.lang.Override
  public boolean hasTestPassed() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
   * </pre>
   *
   * <code>optional bool test_passed = 192708797;</code>
   *
   * @return The testPassed.
   */
  @java.lang.Override
  public boolean getTestPassed() {
    return testPassed_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(128326216, loadSucceeded_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(192708797, testPassed_);
    }
    for (int i = 0; i < loadErrors_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 310147300, loadErrors_.getRaw(i));
    }
    for (int i = 0; i < testFailures_.size(); i++) {
      output.writeMessage(505934134, testFailures_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(128326216, loadSucceeded_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(192708797, testPassed_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < loadErrors_.size(); i++) {
        dataSize += computeStringSizeNoTag(loadErrors_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLoadErrorsList().size();
    }
    for (int i = 0; i < testFailures_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(505934134, testFailures_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.UrlMapValidationResult)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.UrlMapValidationResult other =
        (com.google.cloud.compute.v1.UrlMapValidationResult) obj;

    if (!getLoadErrorsList().equals(other.getLoadErrorsList())) return false;
    if (hasLoadSucceeded() != other.hasLoadSucceeded()) return false;
    if (hasLoadSucceeded()) {
      if (getLoadSucceeded() != other.getLoadSucceeded()) return false;
    }
    if (!getTestFailuresList().equals(other.getTestFailuresList())) return false;
    if (hasTestPassed() != other.hasTestPassed()) return false;
    if (hasTestPassed()) {
      if (getTestPassed() != other.getTestPassed()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLoadErrorsCount() > 0) {
      hash = (37 * hash) + LOAD_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getLoadErrorsList().hashCode();
    }
    if (hasLoadSucceeded()) {
      hash = (37 * hash) + LOAD_SUCCEEDED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLoadSucceeded());
    }
    if (getTestFailuresCount() > 0) {
      hash = (37 * hash) + TEST_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getTestFailuresList().hashCode();
    }
    if (hasTestPassed()) {
      hash = (37 * hash) + TEST_PASSED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTestPassed());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.UrlMapValidationResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Message representing the validation result for a UrlMap.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.UrlMapValidationResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.UrlMapValidationResult)
      com.google.cloud.compute.v1.UrlMapValidationResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapValidationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapValidationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.UrlMapValidationResult.class,
              com.google.cloud.compute.v1.UrlMapValidationResult.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.UrlMapValidationResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      loadErrors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      loadSucceeded_ = false;
      if (testFailuresBuilder_ == null) {
        testFailures_ = java.util.Collections.emptyList();
      } else {
        testFailures_ = null;
        testFailuresBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      testPassed_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapValidationResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapValidationResult getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.UrlMapValidationResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapValidationResult build() {
      com.google.cloud.compute.v1.UrlMapValidationResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapValidationResult buildPartial() {
      com.google.cloud.compute.v1.UrlMapValidationResult result =
          new com.google.cloud.compute.v1.UrlMapValidationResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.UrlMapValidationResult result) {
      if (testFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          testFailures_ = java.util.Collections.unmodifiableList(testFailures_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.testFailures_ = testFailures_;
      } else {
        result.testFailures_ = testFailuresBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.UrlMapValidationResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        loadErrors_.makeImmutable();
        result.loadErrors_ = loadErrors_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.loadSucceeded_ = loadSucceeded_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.testPassed_ = testPassed_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.UrlMapValidationResult) {
        return mergeFrom((com.google.cloud.compute.v1.UrlMapValidationResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.UrlMapValidationResult other) {
      if (other == com.google.cloud.compute.v1.UrlMapValidationResult.getDefaultInstance())
        return this;
      if (!other.loadErrors_.isEmpty()) {
        if (loadErrors_.isEmpty()) {
          loadErrors_ = other.loadErrors_;
          bitField0_ |= 0x00000001;
        } else {
          ensureLoadErrorsIsMutable();
          loadErrors_.addAll(other.loadErrors_);
        }
        onChanged();
      }
      if (other.hasLoadSucceeded()) {
        setLoadSucceeded(other.getLoadSucceeded());
      }
      if (testFailuresBuilder_ == null) {
        if (!other.testFailures_.isEmpty()) {
          if (testFailures_.isEmpty()) {
            testFailures_ = other.testFailures_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureTestFailuresIsMutable();
            testFailures_.addAll(other.testFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.testFailures_.isEmpty()) {
          if (testFailuresBuilder_.isEmpty()) {
            testFailuresBuilder_.dispose();
            testFailuresBuilder_ = null;
            testFailures_ = other.testFailures_;
            bitField0_ = (bitField0_ & ~0x00000004);
            testFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTestFailuresFieldBuilder()
                    : null;
          } else {
            testFailuresBuilder_.addAllMessages(other.testFailures_);
          }
        }
      }
      if (other.hasTestPassed()) {
        setTestPassed(other.getTestPassed());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1026609728:
              {
                loadSucceeded_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 1026609728
            case 1541670376:
              {
                testPassed_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 1541670376
            case -1813788894:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLoadErrorsIsMutable();
                loadErrors_.add(s);
                break;
              } // case -1813788894
            case -247494222:
              {
                com.google.cloud.compute.v1.TestFailure m =
                    input.readMessage(
                        com.google.cloud.compute.v1.TestFailure.parser(), extensionRegistry);
                if (testFailuresBuilder_ == null) {
                  ensureTestFailuresIsMutable();
                  testFailures_.add(m);
                } else {
                  testFailuresBuilder_.addMessage(m);
                }
                break;
              } // case -247494222
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList loadErrors_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLoadErrorsIsMutable() {
      if (!loadErrors_.isModifiable()) {
        loadErrors_ = new com.google.protobuf.LazyStringArrayList(loadErrors_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @return A list containing the loadErrors.
     */
    public com.google.protobuf.ProtocolStringList getLoadErrorsList() {
      loadErrors_.makeImmutable();
      return loadErrors_;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @return The count of loadErrors.
     */
    public int getLoadErrorsCount() {
      return loadErrors_.size();
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param index The index of the element to return.
     * @return The loadErrors at the given index.
     */
    public java.lang.String getLoadErrors(int index) {
      return loadErrors_.get(index);
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the loadErrors at the given index.
     */
    public com.google.protobuf.ByteString getLoadErrorsBytes(int index) {
      return loadErrors_.getByteString(index);
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param index The index to set the value at.
     * @param value The loadErrors to set.
     * @return This builder for chaining.
     */
    public Builder setLoadErrors(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLoadErrorsIsMutable();
      loadErrors_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param value The loadErrors to add.
     * @return This builder for chaining.
     */
    public Builder addLoadErrors(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLoadErrorsIsMutable();
      loadErrors_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param values The loadErrors to add.
     * @return This builder for chaining.
     */
    public Builder addAllLoadErrors(java.lang.Iterable<java.lang.String> values) {
      ensureLoadErrorsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, loadErrors_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadErrors() {
      loadErrors_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     * <code>repeated string load_errors = 310147300;</code>
     *
     * @param value The bytes of the loadErrors to add.
     * @return This builder for chaining.
     */
    public Builder addLoadErrorsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLoadErrorsIsMutable();
      loadErrors_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean loadSucceeded_;

    /**
     *
     *
     * <pre>
     * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
     * </pre>
     *
     * <code>optional bool load_succeeded = 128326216;</code>
     *
     * @return Whether the loadSucceeded field is set.
     */
    @java.lang.Override
    public boolean hasLoadSucceeded() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
     * </pre>
     *
     * <code>optional bool load_succeeded = 128326216;</code>
     *
     * @return The loadSucceeded.
     */
    @java.lang.Override
    public boolean getLoadSucceeded() {
      return loadSucceeded_;
    }

    /**
     *
     *
     * <pre>
     * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
     * </pre>
     *
     * <code>optional bool load_succeeded = 128326216;</code>
     *
     * @param value The loadSucceeded to set.
     * @return This builder for chaining.
     */
    public Builder setLoadSucceeded(boolean value) {

      loadSucceeded_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the given UrlMap can be successfully loaded. If false, 'loadErrors' indicates the reasons.
     * </pre>
     *
     * <code>optional bool load_succeeded = 128326216;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadSucceeded() {
      bitField0_ = (bitField0_ & ~0x00000002);
      loadSucceeded_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.TestFailure> testFailures_ =
        java.util.Collections.emptyList();

    private void ensureTestFailuresIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        testFailures_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.TestFailure>(testFailures_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.TestFailure,
            com.google.cloud.compute.v1.TestFailure.Builder,
            com.google.cloud.compute.v1.TestFailureOrBuilder>
        testFailuresBuilder_;

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public java.util.List<com.google.cloud.compute.v1.TestFailure> getTestFailuresList() {
      if (testFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(testFailures_);
      } else {
        return testFailuresBuilder_.getMessageList();
      }
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public int getTestFailuresCount() {
      if (testFailuresBuilder_ == null) {
        return testFailures_.size();
      } else {
        return testFailuresBuilder_.getCount();
      }
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public com.google.cloud.compute.v1.TestFailure getTestFailures(int index) {
      if (testFailuresBuilder_ == null) {
        return testFailures_.get(index);
      } else {
        return testFailuresBuilder_.getMessage(index);
      }
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder setTestFailures(int index, com.google.cloud.compute.v1.TestFailure value) {
      if (testFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestFailuresIsMutable();
        testFailures_.set(index, value);
        onChanged();
      } else {
        testFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder setTestFailures(
        int index, com.google.cloud.compute.v1.TestFailure.Builder builderForValue) {
      if (testFailuresBuilder_ == null) {
        ensureTestFailuresIsMutable();
        testFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        testFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder addTestFailures(com.google.cloud.compute.v1.TestFailure value) {
      if (testFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestFailuresIsMutable();
        testFailures_.add(value);
        onChanged();
      } else {
        testFailuresBuilder_.addMessage(value);
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder addTestFailures(int index, com.google.cloud.compute.v1.TestFailure value) {
      if (testFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTestFailuresIsMutable();
        testFailures_.add(index, value);
        onChanged();
      } else {
        testFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder addTestFailures(
        com.google.cloud.compute.v1.TestFailure.Builder builderForValue) {
      if (testFailuresBuilder_ == null) {
        ensureTestFailuresIsMutable();
        testFailures_.add(builderForValue.build());
        onChanged();
      } else {
        testFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder addTestFailures(
        int index, com.google.cloud.compute.v1.TestFailure.Builder builderForValue) {
      if (testFailuresBuilder_ == null) {
        ensureTestFailuresIsMutable();
        testFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        testFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder addAllTestFailures(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.TestFailure> values) {
      if (testFailuresBuilder_ == null) {
        ensureTestFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, testFailures_);
        onChanged();
      } else {
        testFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder clearTestFailures() {
      if (testFailuresBuilder_ == null) {
        testFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        testFailuresBuilder_.clear();
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public Builder removeTestFailures(int index) {
      if (testFailuresBuilder_ == null) {
        ensureTestFailuresIsMutable();
        testFailures_.remove(index);
        onChanged();
      } else {
        testFailuresBuilder_.remove(index);
      }
      return this;
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public com.google.cloud.compute.v1.TestFailure.Builder getTestFailuresBuilder(int index) {
      return getTestFailuresFieldBuilder().getBuilder(index);
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public com.google.cloud.compute.v1.TestFailureOrBuilder getTestFailuresOrBuilder(int index) {
      if (testFailuresBuilder_ == null) {
        return testFailures_.get(index);
      } else {
        return testFailuresBuilder_.getMessageOrBuilder(index);
      }
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public java.util.List<? extends com.google.cloud.compute.v1.TestFailureOrBuilder>
        getTestFailuresOrBuilderList() {
      if (testFailuresBuilder_ != null) {
        return testFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(testFailures_);
      }
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public com.google.cloud.compute.v1.TestFailure.Builder addTestFailuresBuilder() {
      return getTestFailuresFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.TestFailure.getDefaultInstance());
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public com.google.cloud.compute.v1.TestFailure.Builder addTestFailuresBuilder(int index) {
      return getTestFailuresFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.TestFailure.getDefaultInstance());
    }

    /** <code>repeated .google.cloud.compute.v1.TestFailure test_failures = 505934134;</code> */
    public java.util.List<com.google.cloud.compute.v1.TestFailure.Builder>
        getTestFailuresBuilderList() {
      return getTestFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.TestFailure,
            com.google.cloud.compute.v1.TestFailure.Builder,
            com.google.cloud.compute.v1.TestFailureOrBuilder>
        getTestFailuresFieldBuilder() {
      if (testFailuresBuilder_ == null) {
        testFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.TestFailure,
                com.google.cloud.compute.v1.TestFailure.Builder,
                com.google.cloud.compute.v1.TestFailureOrBuilder>(
                testFailures_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        testFailures_ = null;
      }
      return testFailuresBuilder_;
    }

    private boolean testPassed_;

    /**
     *
     *
     * <pre>
     * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
     * </pre>
     *
     * <code>optional bool test_passed = 192708797;</code>
     *
     * @return Whether the testPassed field is set.
     */
    @java.lang.Override
    public boolean hasTestPassed() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
     * </pre>
     *
     * <code>optional bool test_passed = 192708797;</code>
     *
     * @return The testPassed.
     */
    @java.lang.Override
    public boolean getTestPassed() {
      return testPassed_;
    }

    /**
     *
     *
     * <pre>
     * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
     * </pre>
     *
     * <code>optional bool test_passed = 192708797;</code>
     *
     * @param value The testPassed to set.
     * @return This builder for chaining.
     */
    public Builder setTestPassed(boolean value) {

      testPassed_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If successfully loaded, this field indicates whether the test passed. If false, 'testFailures's indicate the reason of failure.
     * </pre>
     *
     * <code>optional bool test_passed = 192708797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTestPassed() {
      bitField0_ = (bitField0_ & ~0x00000008);
      testPassed_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.UrlMapValidationResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.UrlMapValidationResult)
  private static final com.google.cloud.compute.v1.UrlMapValidationResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.UrlMapValidationResult();
  }

  public static com.google.cloud.compute.v1.UrlMapValidationResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UrlMapValidationResult> PARSER =
      new com.google.protobuf.AbstractParser<UrlMapValidationResult>() {
        @java.lang.Override
        public UrlMapValidationResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UrlMapValidationResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UrlMapValidationResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapValidationResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
