/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.UrlMapsValidateRequest}
 */
public final class UrlMapsValidateRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.UrlMapsValidateRequest)
    UrlMapsValidateRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use UrlMapsValidateRequest.newBuilder() to construct.
  private UrlMapsValidateRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UrlMapsValidateRequest() {
    loadBalancingSchemes_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UrlMapsValidateRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMapsValidateRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_UrlMapsValidateRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.UrlMapsValidateRequest.class,
            com.google.cloud.compute.v1.UrlMapsValidateRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.UrlMapsValidateRequest.LoadBalancingSchemes}
   */
  public enum LoadBalancingSchemes implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEMES = 0;</code>
     */
    UNDEFINED_LOAD_BALANCING_SCHEMES(0),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for classic Application Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    EXTERNAL(35607499),
    /**
     *
     *
     * <pre>
     * Signifies that this will be used for Envoy-based global external Application Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL_MANAGED = 512006923;</code>
     */
    EXTERNAL_MANAGED(512006923),
    /**
     *
     *
     * <pre>
     * If unspecified, the validation will try to infer the scheme from the backend service resources this Url map references. If the inference is not possible, EXTERNAL will be used as the default type.
     * </pre>
     *
     * <code>LOAD_BALANCING_SCHEME_UNSPECIFIED = 526507452;</code>
     */
    LOAD_BALANCING_SCHEME_UNSPECIFIED(526507452),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEMES = 0;</code>
     */
    public static final int UNDEFINED_LOAD_BALANCING_SCHEMES_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Signifies that this will be used for classic Application Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL = 35607499;</code>
     */
    public static final int EXTERNAL_VALUE = 35607499;

    /**
     *
     *
     * <pre>
     * Signifies that this will be used for Envoy-based global external Application Load Balancers.
     * </pre>
     *
     * <code>EXTERNAL_MANAGED = 512006923;</code>
     */
    public static final int EXTERNAL_MANAGED_VALUE = 512006923;

    /**
     *
     *
     * <pre>
     * If unspecified, the validation will try to infer the scheme from the backend service resources this Url map references. If the inference is not possible, EXTERNAL will be used as the default type.
     * </pre>
     *
     * <code>LOAD_BALANCING_SCHEME_UNSPECIFIED = 526507452;</code>
     */
    public static final int LOAD_BALANCING_SCHEME_UNSPECIFIED_VALUE = 526507452;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoadBalancingSchemes valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoadBalancingSchemes forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOAD_BALANCING_SCHEMES;
        case 35607499:
          return EXTERNAL;
        case 512006923:
          return EXTERNAL_MANAGED;
        case 526507452:
          return LOAD_BALANCING_SCHEME_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoadBalancingSchemes>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoadBalancingSchemes>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LoadBalancingSchemes>() {
              public LoadBalancingSchemes findValueByNumber(int number) {
                return LoadBalancingSchemes.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.UrlMapsValidateRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final LoadBalancingSchemes[] VALUES = values();

    public static LoadBalancingSchemes valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoadBalancingSchemes(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.UrlMapsValidateRequest.LoadBalancingSchemes)
  }

  private int bitField0_;
  public static final int LOAD_BALANCING_SCHEMES_FIELD_NUMBER = 6308527;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList loadBalancingSchemes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
   * Check the LoadBalancingSchemes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string load_balancing_schemes = 6308527;</code>
   *
   * @return A list containing the loadBalancingSchemes.
   */
  public com.google.protobuf.ProtocolStringList getLoadBalancingSchemesList() {
    return loadBalancingSchemes_;
  }

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
   * Check the LoadBalancingSchemes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string load_balancing_schemes = 6308527;</code>
   *
   * @return The count of loadBalancingSchemes.
   */
  public int getLoadBalancingSchemesCount() {
    return loadBalancingSchemes_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
   * Check the LoadBalancingSchemes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string load_balancing_schemes = 6308527;</code>
   *
   * @param index The index of the element to return.
   * @return The loadBalancingSchemes at the given index.
   */
  public java.lang.String getLoadBalancingSchemes(int index) {
    return loadBalancingSchemes_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
   * Check the LoadBalancingSchemes enum for the list of possible values.
   * </pre>
   *
   * <code>repeated string load_balancing_schemes = 6308527;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the loadBalancingSchemes at the given index.
   */
  public com.google.protobuf.ByteString getLoadBalancingSchemesBytes(int index) {
    return loadBalancingSchemes_.getByteString(index);
  }

  public static final int RESOURCE_FIELD_NUMBER = 195806222;
  private com.google.cloud.compute.v1.UrlMap resource_;

  /**
   *
   *
   * <pre>
   * Content of the UrlMap to be validated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Content of the UrlMap to be validated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMap getResource() {
    return resource_ == null ? com.google.cloud.compute.v1.UrlMap.getDefaultInstance() : resource_;
  }

  /**
   *
   *
   * <pre>
   * Content of the UrlMap to be validated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapOrBuilder getResourceOrBuilder() {
    return resource_ == null ? com.google.cloud.compute.v1.UrlMap.getDefaultInstance() : resource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < loadBalancingSchemes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 6308527, loadBalancingSchemes_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(195806222, getResource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < loadBalancingSchemes_.size(); i++) {
        dataSize += computeStringSizeNoTag(loadBalancingSchemes_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getLoadBalancingSchemesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(195806222, getResource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.UrlMapsValidateRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.UrlMapsValidateRequest other =
        (com.google.cloud.compute.v1.UrlMapsValidateRequest) obj;

    if (!getLoadBalancingSchemesList().equals(other.getLoadBalancingSchemesList())) return false;
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getLoadBalancingSchemesCount() > 0) {
      hash = (37 * hash) + LOAD_BALANCING_SCHEMES_FIELD_NUMBER;
      hash = (53 * hash) + getLoadBalancingSchemesList().hashCode();
    }
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.UrlMapsValidateRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.UrlMapsValidateRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.UrlMapsValidateRequest)
      com.google.cloud.compute.v1.UrlMapsValidateRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapsValidateRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapsValidateRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.UrlMapsValidateRequest.class,
              com.google.cloud.compute.v1.UrlMapsValidateRequest.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.UrlMapsValidateRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      loadBalancingSchemes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_UrlMapsValidateRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapsValidateRequest getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.UrlMapsValidateRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapsValidateRequest build() {
      com.google.cloud.compute.v1.UrlMapsValidateRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.UrlMapsValidateRequest buildPartial() {
      com.google.cloud.compute.v1.UrlMapsValidateRequest result =
          new com.google.cloud.compute.v1.UrlMapsValidateRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.UrlMapsValidateRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        loadBalancingSchemes_.makeImmutable();
        result.loadBalancingSchemes_ = loadBalancingSchemes_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.UrlMapsValidateRequest) {
        return mergeFrom((com.google.cloud.compute.v1.UrlMapsValidateRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.UrlMapsValidateRequest other) {
      if (other == com.google.cloud.compute.v1.UrlMapsValidateRequest.getDefaultInstance())
        return this;
      if (!other.loadBalancingSchemes_.isEmpty()) {
        if (loadBalancingSchemes_.isEmpty()) {
          loadBalancingSchemes_ = other.loadBalancingSchemes_;
          bitField0_ |= 0x00000001;
        } else {
          ensureLoadBalancingSchemesIsMutable();
          loadBalancingSchemes_.addAll(other.loadBalancingSchemes_);
        }
        onChanged();
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 50468218:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLoadBalancingSchemesIsMutable();
                loadBalancingSchemes_.add(s);
                break;
              } // case 50468218
            case 1566449778:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 1566449778
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList loadBalancingSchemes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLoadBalancingSchemesIsMutable() {
      if (!loadBalancingSchemes_.isModifiable()) {
        loadBalancingSchemes_ = new com.google.protobuf.LazyStringArrayList(loadBalancingSchemes_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @return A list containing the loadBalancingSchemes.
     */
    public com.google.protobuf.ProtocolStringList getLoadBalancingSchemesList() {
      loadBalancingSchemes_.makeImmutable();
      return loadBalancingSchemes_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @return The count of loadBalancingSchemes.
     */
    public int getLoadBalancingSchemesCount() {
      return loadBalancingSchemes_.size();
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param index The index of the element to return.
     * @return The loadBalancingSchemes at the given index.
     */
    public java.lang.String getLoadBalancingSchemes(int index) {
      return loadBalancingSchemes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the loadBalancingSchemes at the given index.
     */
    public com.google.protobuf.ByteString getLoadBalancingSchemesBytes(int index) {
      return loadBalancingSchemes_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param index The index to set the value at.
     * @param value The loadBalancingSchemes to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancingSchemes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLoadBalancingSchemesIsMutable();
      loadBalancingSchemes_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param value The loadBalancingSchemes to add.
     * @return This builder for chaining.
     */
    public Builder addLoadBalancingSchemes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLoadBalancingSchemesIsMutable();
      loadBalancingSchemes_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param values The loadBalancingSchemes to add.
     * @return This builder for chaining.
     */
    public Builder addAllLoadBalancingSchemes(java.lang.Iterable<java.lang.String> values) {
      ensureLoadBalancingSchemesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, loadBalancingSchemes_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadBalancingSchemes() {
      loadBalancingSchemes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for global external Application Load Balancers and regional external Application Load Balancers. Use EXTERNAL for classic Application Load Balancers. Use INTERNAL_MANAGED for internal Application Load Balancers. For more information, refer to Choosing a load balancer. If unspecified, the load balancing scheme will be inferred from the backend service resources this URL map references. If that can not be inferred (for example, this URL map only references backend buckets, or this Url map is for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as the default type. If specified, the scheme(s) must not conflict with the load balancing scheme of the backend service resources this Url map references.
     * Check the LoadBalancingSchemes enum for the list of possible values.
     * </pre>
     *
     * <code>repeated string load_balancing_schemes = 6308527;</code>
     *
     * @param value The bytes of the loadBalancingSchemes to add.
     * @return This builder for chaining.
     */
    public Builder addLoadBalancingSchemesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLoadBalancingSchemesIsMutable();
      loadBalancingSchemes_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.UrlMap resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMap,
            com.google.cloud.compute.v1.UrlMap.Builder,
            com.google.cloud.compute.v1.UrlMapOrBuilder>
        resourceBuilder_;

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     *
     * @return The resource.
     */
    public com.google.cloud.compute.v1.UrlMap getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null
            ? com.google.cloud.compute.v1.UrlMap.getDefaultInstance()
            : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public Builder setResource(com.google.cloud.compute.v1.UrlMap value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public Builder setResource(com.google.cloud.compute.v1.UrlMap.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public Builder mergeResource(com.google.cloud.compute.v1.UrlMap value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && resource_ != null
            && resource_ != com.google.cloud.compute.v1.UrlMap.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public com.google.cloud.compute.v1.UrlMap.Builder getResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    public com.google.cloud.compute.v1.UrlMapOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null
            ? com.google.cloud.compute.v1.UrlMap.getDefaultInstance()
            : resource_;
      }
    }

    /**
     *
     *
     * <pre>
     * Content of the UrlMap to be validated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.UrlMap resource = 195806222;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.UrlMap,
            com.google.cloud.compute.v1.UrlMap.Builder,
            com.google.cloud.compute.v1.UrlMapOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.UrlMap,
                com.google.cloud.compute.v1.UrlMap.Builder,
                com.google.cloud.compute.v1.UrlMapOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.UrlMapsValidateRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.UrlMapsValidateRequest)
  private static final com.google.cloud.compute.v1.UrlMapsValidateRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.UrlMapsValidateRequest();
  }

  public static com.google.cloud.compute.v1.UrlMapsValidateRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UrlMapsValidateRequest> PARSER =
      new com.google.protobuf.AbstractParser<UrlMapsValidateRequest>() {
        @java.lang.Override
        public UrlMapsValidateRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UrlMapsValidateRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UrlMapsValidateRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.UrlMapsValidateRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
