/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.WafExpressionSet}
 */
public final class WafExpressionSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.WafExpressionSet)
    WafExpressionSetOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WafExpressionSet.newBuilder() to construct.
  private WafExpressionSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WafExpressionSet() {
    aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    expressions_ = java.util.Collections.emptyList();
    id_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WafExpressionSet();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_WafExpressionSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_WafExpressionSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.WafExpressionSet.class,
            com.google.cloud.compute.v1.WafExpressionSet.Builder.class);
  }

  private int bitField0_;
  public static final int ALIASES_FIELD_NUMBER = 159207166;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList aliases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
   * </pre>
   *
   * <code>repeated string aliases = 159207166;</code>
   *
   * @return A list containing the aliases.
   */
  public com.google.protobuf.ProtocolStringList getAliasesList() {
    return aliases_;
  }

  /**
   *
   *
   * <pre>
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
   * </pre>
   *
   * <code>repeated string aliases = 159207166;</code>
   *
   * @return The count of aliases.
   */
  public int getAliasesCount() {
    return aliases_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
   * </pre>
   *
   * <code>repeated string aliases = 159207166;</code>
   *
   * @param index The index of the element to return.
   * @return The aliases at the given index.
   */
  public java.lang.String getAliases(int index) {
    return aliases_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
   * </pre>
   *
   * <code>repeated string aliases = 159207166;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the aliases at the given index.
   */
  public com.google.protobuf.ByteString getAliasesBytes(int index) {
    return aliases_.getByteString(index);
  }

  public static final int EXPRESSIONS_FIELD_NUMBER = 175554779;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.WafExpressionSetExpression> expressions_;

  /**
   *
   *
   * <pre>
   * List of available expressions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.WafExpressionSetExpression>
      getExpressionsList() {
    return expressions_;
  }

  /**
   *
   *
   * <pre>
   * List of available expressions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder>
      getExpressionsOrBuilderList() {
    return expressions_;
  }

  /**
   *
   *
   * <pre>
   * List of available expressions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
   * </code>
   */
  @java.lang.Override
  public int getExpressionsCount() {
    return expressions_.size();
  }

  /**
   *
   *
   * <pre>
   * List of available expressions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WafExpressionSetExpression getExpressions(int index) {
    return expressions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * List of available expressions.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder getExpressionsOrBuilder(
      int index) {
    return expressions_.get(index);
  }

  public static final int ID_FIELD_NUMBER = 3355;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";

  /**
   *
   *
   * <pre>
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
   * </pre>
   *
   * <code>optional string id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
   * </pre>
   *
   * <code>optional string id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
   * </pre>
   *
   * <code>optional string id = 3355;</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3355, id_);
    }
    for (int i = 0; i < aliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 159207166, aliases_.getRaw(i));
    }
    for (int i = 0; i < expressions_.size(); i++) {
      output.writeMessage(175554779, expressions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3355, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < aliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(aliases_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getAliasesList().size();
    }
    for (int i = 0; i < expressions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(175554779, expressions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.WafExpressionSet)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.WafExpressionSet other =
        (com.google.cloud.compute.v1.WafExpressionSet) obj;

    if (!getAliasesList().equals(other.getAliasesList())) return false;
    if (!getExpressionsList().equals(other.getExpressionsList())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (!getId().equals(other.getId())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAliasesCount() > 0) {
      hash = (37 * hash) + ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getAliasesList().hashCode();
    }
    if (getExpressionsCount() > 0) {
      hash = (37 * hash) + EXPRESSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getExpressionsList().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WafExpressionSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.WafExpressionSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.WafExpressionSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.WafExpressionSet)
      com.google.cloud.compute.v1.WafExpressionSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WafExpressionSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WafExpressionSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.WafExpressionSet.class,
              com.google.cloud.compute.v1.WafExpressionSet.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.WafExpressionSet.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (expressionsBuilder_ == null) {
        expressions_ = java.util.Collections.emptyList();
      } else {
        expressions_ = null;
        expressionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      id_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WafExpressionSet_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WafExpressionSet getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.WafExpressionSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WafExpressionSet build() {
      com.google.cloud.compute.v1.WafExpressionSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WafExpressionSet buildPartial() {
      com.google.cloud.compute.v1.WafExpressionSet result =
          new com.google.cloud.compute.v1.WafExpressionSet(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.WafExpressionSet result) {
      if (expressionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          expressions_ = java.util.Collections.unmodifiableList(expressions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.expressions_ = expressions_;
      } else {
        result.expressions_ = expressionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.WafExpressionSet result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        aliases_.makeImmutable();
        result.aliases_ = aliases_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.WafExpressionSet) {
        return mergeFrom((com.google.cloud.compute.v1.WafExpressionSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.WafExpressionSet other) {
      if (other == com.google.cloud.compute.v1.WafExpressionSet.getDefaultInstance()) return this;
      if (!other.aliases_.isEmpty()) {
        if (aliases_.isEmpty()) {
          aliases_ = other.aliases_;
          bitField0_ |= 0x00000001;
        } else {
          ensureAliasesIsMutable();
          aliases_.addAll(other.aliases_);
        }
        onChanged();
      }
      if (expressionsBuilder_ == null) {
        if (!other.expressions_.isEmpty()) {
          if (expressions_.isEmpty()) {
            expressions_ = other.expressions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExpressionsIsMutable();
            expressions_.addAll(other.expressions_);
          }
          onChanged();
        }
      } else {
        if (!other.expressions_.isEmpty()) {
          if (expressionsBuilder_.isEmpty()) {
            expressionsBuilder_.dispose();
            expressionsBuilder_ = null;
            expressions_ = other.expressions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            expressionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExpressionsFieldBuilder()
                    : null;
          } else {
            expressionsBuilder_.addAllMessages(other.expressions_);
          }
        }
      }
      if (other.hasId()) {
        id_ = other.id_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26842:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26842
            case 1273657330:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAliasesIsMutable();
                aliases_.add(s);
                break;
              } // case 1273657330
            case 1404438234:
              {
                com.google.cloud.compute.v1.WafExpressionSetExpression m =
                    input.readMessage(
                        com.google.cloud.compute.v1.WafExpressionSetExpression.parser(),
                        extensionRegistry);
                if (expressionsBuilder_ == null) {
                  ensureExpressionsIsMutable();
                  expressions_.add(m);
                } else {
                  expressionsBuilder_.addMessage(m);
                }
                break;
              } // case 1404438234
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList aliases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAliasesIsMutable() {
      if (!aliases_.isModifiable()) {
        aliases_ = new com.google.protobuf.LazyStringArrayList(aliases_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @return A list containing the aliases.
     */
    public com.google.protobuf.ProtocolStringList getAliasesList() {
      aliases_.makeImmutable();
      return aliases_;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @return The count of aliases.
     */
    public int getAliasesCount() {
      return aliases_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param index The index of the element to return.
     * @return The aliases at the given index.
     */
    public java.lang.String getAliases(int index) {
      return aliases_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the aliases at the given index.
     */
    public com.google.protobuf.ByteString getAliasesBytes(int index) {
      return aliases_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param index The index to set the value at.
     * @param value The aliases to set.
     * @return This builder for chaining.
     */
    public Builder setAliases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAliasesIsMutable();
      aliases_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param value The aliases to add.
     * @return This builder for chaining.
     */
    public Builder addAliases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAliasesIsMutable();
      aliases_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param values The aliases to add.
     * @return This builder for chaining.
     */
    public Builder addAllAliases(java.lang.Iterable<java.lang.String> values) {
      ensureAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aliases_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAliases() {
      aliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic suffix like "stable" is particularly useful if a policy likes to avail newer set of expressions without having to change the policy. A given alias name can't be used for more than one entity set.
     * </pre>
     *
     * <code>repeated string aliases = 159207166;</code>
     *
     * @param value The bytes of the aliases to add.
     * @return This builder for chaining.
     */
    public Builder addAliasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAliasesIsMutable();
      aliases_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.WafExpressionSetExpression> expressions_ =
        java.util.Collections.emptyList();

    private void ensureExpressionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        expressions_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.WafExpressionSetExpression>(
                expressions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.WafExpressionSetExpression,
            com.google.cloud.compute.v1.WafExpressionSetExpression.Builder,
            com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder>
        expressionsBuilder_;

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.WafExpressionSetExpression>
        getExpressionsList() {
      if (expressionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(expressions_);
      } else {
        return expressionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public int getExpressionsCount() {
      if (expressionsBuilder_ == null) {
        return expressions_.size();
      } else {
        return expressionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public com.google.cloud.compute.v1.WafExpressionSetExpression getExpressions(int index) {
      if (expressionsBuilder_ == null) {
        return expressions_.get(index);
      } else {
        return expressionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder setExpressions(
        int index, com.google.cloud.compute.v1.WafExpressionSetExpression value) {
      if (expressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpressionsIsMutable();
        expressions_.set(index, value);
        onChanged();
      } else {
        expressionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder setExpressions(
        int index, com.google.cloud.compute.v1.WafExpressionSetExpression.Builder builderForValue) {
      if (expressionsBuilder_ == null) {
        ensureExpressionsIsMutable();
        expressions_.set(index, builderForValue.build());
        onChanged();
      } else {
        expressionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder addExpressions(com.google.cloud.compute.v1.WafExpressionSetExpression value) {
      if (expressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpressionsIsMutable();
        expressions_.add(value);
        onChanged();
      } else {
        expressionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder addExpressions(
        int index, com.google.cloud.compute.v1.WafExpressionSetExpression value) {
      if (expressionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpressionsIsMutable();
        expressions_.add(index, value);
        onChanged();
      } else {
        expressionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder addExpressions(
        com.google.cloud.compute.v1.WafExpressionSetExpression.Builder builderForValue) {
      if (expressionsBuilder_ == null) {
        ensureExpressionsIsMutable();
        expressions_.add(builderForValue.build());
        onChanged();
      } else {
        expressionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder addExpressions(
        int index, com.google.cloud.compute.v1.WafExpressionSetExpression.Builder builderForValue) {
      if (expressionsBuilder_ == null) {
        ensureExpressionsIsMutable();
        expressions_.add(index, builderForValue.build());
        onChanged();
      } else {
        expressionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder addAllExpressions(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.WafExpressionSetExpression>
            values) {
      if (expressionsBuilder_ == null) {
        ensureExpressionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expressions_);
        onChanged();
      } else {
        expressionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder clearExpressions() {
      if (expressionsBuilder_ == null) {
        expressions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        expressionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public Builder removeExpressions(int index) {
      if (expressionsBuilder_ == null) {
        ensureExpressionsIsMutable();
        expressions_.remove(index);
        onChanged();
      } else {
        expressionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public com.google.cloud.compute.v1.WafExpressionSetExpression.Builder getExpressionsBuilder(
        int index) {
      return getExpressionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder getExpressionsOrBuilder(
        int index) {
      if (expressionsBuilder_ == null) {
        return expressions_.get(index);
      } else {
        return expressionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder>
        getExpressionsOrBuilderList() {
      if (expressionsBuilder_ != null) {
        return expressionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(expressions_);
      }
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public com.google.cloud.compute.v1.WafExpressionSetExpression.Builder addExpressionsBuilder() {
      return getExpressionsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.WafExpressionSetExpression.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public com.google.cloud.compute.v1.WafExpressionSetExpression.Builder addExpressionsBuilder(
        int index) {
      return getExpressionsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.WafExpressionSetExpression.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * List of available expressions.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.WafExpressionSetExpression expressions = 175554779;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.WafExpressionSetExpression.Builder>
        getExpressionsBuilderList() {
      return getExpressionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.WafExpressionSetExpression,
            com.google.cloud.compute.v1.WafExpressionSetExpression.Builder,
            com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder>
        getExpressionsFieldBuilder() {
      if (expressionsBuilder_ == null) {
        expressionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.WafExpressionSetExpression,
                com.google.cloud.compute.v1.WafExpressionSetExpression.Builder,
                com.google.cloud.compute.v1.WafExpressionSetExpressionOrBuilder>(
                expressions_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        expressions_ = null;
      }
      return expressionsBuilder_;
    }

    private java.lang.Object id_ = "";

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    public boolean hasId() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Google specified expression set ID. The format should be: - E.g. XSS-20170329 required
     * </pre>
     *
     * <code>optional string id = 3355;</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.WafExpressionSet)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.WafExpressionSet)
  private static final com.google.cloud.compute.v1.WafExpressionSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.WafExpressionSet();
  }

  public static com.google.cloud.compute.v1.WafExpressionSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WafExpressionSet> PARSER =
      new com.google.protobuf.AbstractParser<WafExpressionSet>() {
        @java.lang.Override
        public WafExpressionSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WafExpressionSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WafExpressionSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.WafExpressionSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
