/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * In contrast to a single BackendService in HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple backend services. The volume of traffic for each backend service is proportional to the weight specified in each WeightedBackendService
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.WeightedBackendService}
 */
public final class WeightedBackendService extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.WeightedBackendService)
    WeightedBackendServiceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WeightedBackendService.newBuilder() to construct.
  private WeightedBackendService(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WeightedBackendService() {
    backendService_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WeightedBackendService();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_WeightedBackendService_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_WeightedBackendService_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.WeightedBackendService.class,
            com.google.cloud.compute.v1.WeightedBackendService.Builder.class);
  }

  private int bitField0_;
  public static final int BACKEND_SERVICE_FIELD_NUMBER = 306946058;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backendService_ = "";

  /**
   *
   *
   * <pre>
   * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return Whether the backendService field is set.
   */
  @java.lang.Override
  public boolean hasBackendService() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return The backendService.
   */
  @java.lang.Override
  public java.lang.String getBackendService() {
    java.lang.Object ref = backendService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backendService_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return The bytes for backendService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackendServiceBytes() {
    java.lang.Object ref = backendService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backendService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_ACTION_FIELD_NUMBER = 328077352;
  private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return Whether the headerAction field is set.
   */
  @java.lang.Override
  public boolean hasHeaderAction() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return The headerAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  public static final int WEIGHT_FIELD_NUMBER = 282149496;
  private int weight_ = 0;

  /**
   *
   *
   * <pre>
   * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
   * </pre>
   *
   * <code>optional uint32 weight = 282149496;</code>
   *
   * @return Whether the weight field is set.
   */
  @java.lang.Override
  public boolean hasWeight() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
   * </pre>
   *
   * <code>optional uint32 weight = 282149496;</code>
   *
   * @return The weight.
   */
  @java.lang.Override
  public int getWeight() {
    return weight_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeUInt32(282149496, weight_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 306946058, backendService_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(328077352, getHeaderAction());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt32Size(282149496, weight_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(306946058, backendService_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328077352, getHeaderAction());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.WeightedBackendService)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.WeightedBackendService other =
        (com.google.cloud.compute.v1.WeightedBackendService) obj;

    if (hasBackendService() != other.hasBackendService()) return false;
    if (hasBackendService()) {
      if (!getBackendService().equals(other.getBackendService())) return false;
    }
    if (hasHeaderAction() != other.hasHeaderAction()) return false;
    if (hasHeaderAction()) {
      if (!getHeaderAction().equals(other.getHeaderAction())) return false;
    }
    if (hasWeight() != other.hasWeight()) return false;
    if (hasWeight()) {
      if (getWeight() != other.getWeight()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasBackendService()) {
      hash = (37 * hash) + BACKEND_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getBackendService().hashCode();
    }
    if (hasHeaderAction()) {
      hash = (37 * hash) + HEADER_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderAction().hashCode();
    }
    if (hasWeight()) {
      hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getWeight();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.WeightedBackendService parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.WeightedBackendService prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * In contrast to a single BackendService in HttpRouteAction to which all matching traffic is directed to, WeightedBackendService allows traffic to be split across multiple backend services. The volume of traffic for each backend service is proportional to the weight specified in each WeightedBackendService
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.WeightedBackendService}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.WeightedBackendService)
      com.google.cloud.compute.v1.WeightedBackendServiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WeightedBackendService_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WeightedBackendService_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.WeightedBackendService.class,
              com.google.cloud.compute.v1.WeightedBackendService.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.WeightedBackendService.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHeaderActionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      backendService_ = "";
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      weight_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_WeightedBackendService_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WeightedBackendService getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.WeightedBackendService.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WeightedBackendService build() {
      com.google.cloud.compute.v1.WeightedBackendService result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.WeightedBackendService buildPartial() {
      com.google.cloud.compute.v1.WeightedBackendService result =
          new com.google.cloud.compute.v1.WeightedBackendService(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.WeightedBackendService result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.backendService_ = backendService_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.headerAction_ =
            headerActionBuilder_ == null ? headerAction_ : headerActionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.weight_ = weight_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.WeightedBackendService) {
        return mergeFrom((com.google.cloud.compute.v1.WeightedBackendService) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.WeightedBackendService other) {
      if (other == com.google.cloud.compute.v1.WeightedBackendService.getDefaultInstance())
        return this;
      if (other.hasBackendService()) {
        backendService_ = other.backendService_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasHeaderAction()) {
        mergeHeaderAction(other.getHeaderAction());
      }
      if (other.hasWeight()) {
        setWeight(other.getWeight());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -2037771328:
              {
                weight_ = input.readUInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case -2037771328
            case -1839398830:
              {
                backendService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1839398830
            case -1670348478:
              {
                input.readMessage(getHeaderActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1670348478
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object backendService_ = "";

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return Whether the backendService field is set.
     */
    public boolean hasBackendService() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return The backendService.
     */
    public java.lang.String getBackendService() {
      java.lang.Object ref = backendService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backendService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return The bytes for backendService.
     */
    public com.google.protobuf.ByteString getBackendServiceBytes() {
      java.lang.Object ref = backendService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backendService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @param value The backendService to set.
     * @return This builder for chaining.
     */
    public Builder setBackendService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backendService_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendService() {
      backendService_ = getDefaultInstance().getBackendService();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The full or partial URL to the default BackendService resource. Before forwarding the request to backendService, the load balancer applies any relevant headerActions specified as part of this backendServiceWeight.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @param value The bytes for backendService to set.
     * @return This builder for chaining.
     */
    public Builder setBackendServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backendService_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        headerActionBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return Whether the headerAction field is set.
     */
    public boolean hasHeaderAction() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return The headerAction.
     */
    public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
      if (headerActionBuilder_ == null) {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      } else {
        return headerActionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headerAction_ = value;
      } else {
        headerActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.HttpHeaderAction.Builder builderForValue) {
      if (headerActionBuilder_ == null) {
        headerAction_ = builderForValue.build();
      } else {
        headerActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder mergeHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && headerAction_ != null
            && headerAction_ != com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()) {
          getHeaderActionBuilder().mergeFrom(value);
        } else {
          headerAction_ = value;
        }
      } else {
        headerActionBuilder_.mergeFrom(value);
      }
      if (headerAction_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder clearHeaderAction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderAction.Builder getHeaderActionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getHeaderActionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
      if (headerActionBuilder_ != null) {
        return headerActionBuilder_.getMessageOrBuilder();
      } else {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. headerAction specified here take effect before headerAction in the enclosing HttpRouteRule, PathMatcher and UrlMap. headerAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        getHeaderActionFieldBuilder() {
      if (headerActionBuilder_ == null) {
        headerActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderAction,
                com.google.cloud.compute.v1.HttpHeaderAction.Builder,
                com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>(
                getHeaderAction(), getParentForChildren(), isClean());
        headerAction_ = null;
      }
      return headerActionBuilder_;
    }

    private int weight_;

    /**
     *
     *
     * <pre>
     * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
     * </pre>
     *
     * <code>optional uint32 weight = 282149496;</code>
     *
     * @return Whether the weight field is set.
     */
    @java.lang.Override
    public boolean hasWeight() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
     * </pre>
     *
     * <code>optional uint32 weight = 282149496;</code>
     *
     * @return The weight.
     */
    @java.lang.Override
    public int getWeight() {
      return weight_;
    }

    /**
     *
     *
     * <pre>
     * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
     * </pre>
     *
     * <code>optional uint32 weight = 282149496;</code>
     *
     * @param value The weight to set.
     * @return This builder for chaining.
     */
    public Builder setWeight(int value) {

      weight_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the fraction of traffic sent to a backend service, computed as weight / (sum of all weightedBackendService weights in routeAction) . The selection of a backend service is determined only for new traffic. Once a user's request has been directed to a backend service, subsequent requests are sent to the same backend service as determined by the backend service's session affinity policy. Don't configure session affinity if you're using weighted traffic splitting. If you do, the weighted traffic splitting configuration takes precedence. The value must be from 0 to 1000.
     * </pre>
     *
     * <code>optional uint32 weight = 282149496;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWeight() {
      bitField0_ = (bitField0_ & ~0x00000004);
      weight_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.WeightedBackendService)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.WeightedBackendService)
  private static final com.google.cloud.compute.v1.WeightedBackendService DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.WeightedBackendService();
  }

  public static com.google.cloud.compute.v1.WeightedBackendService getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WeightedBackendService> PARSER =
      new com.google.protobuf.AbstractParser<WeightedBackendService>() {
        @java.lang.Override
        public WeightedBackendService parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WeightedBackendService> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WeightedBackendService> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.WeightedBackendService getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
