/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IssueModelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ISSUE_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/issueModels/{issue_model}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String issueModel;

    @Deprecated
    protected IssueModelName() {
        this.project = null;
        this.location = null;
        this.issueModel = null;
    }

    private IssueModelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.issueModel = (String)Preconditions.checkNotNull((Object)builder.getIssueModel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getIssueModel() {
        return this.issueModel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static IssueModelName of(String project, String location, String issueModel) {
        return IssueModelName.newBuilder().setProject(project).setLocation(location).setIssueModel(issueModel).build();
    }

    public static String format(String project, String location, String issueModel) {
        return IssueModelName.newBuilder().setProject(project).setLocation(location).setIssueModel(issueModel).build().toString();
    }

    public static IssueModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ISSUE_MODEL.validatedMatch(formattedString, "IssueModelName.parse: formattedString not in valid format");
        return IssueModelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("issue_model"));
    }

    public static List<IssueModelName> parseList(List<String> formattedStrings) {
        ArrayList<IssueModelName> list = new ArrayList<IssueModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IssueModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IssueModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IssueModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ISSUE_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IssueModelName issueModelName = this;
            synchronized (issueModelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.issueModel != null) {
                        fieldMapBuilder.put((Object)"issue_model", (Object)this.issueModel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ISSUE_MODEL.instantiate(new String[]{"project", this.project, "location", this.location, "issue_model", this.issueModel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            IssueModelName that = (IssueModelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.issueModel, that.issueModel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.issueModel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String issueModel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getIssueModel() {
            return this.issueModel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setIssueModel(String issueModel) {
            this.issueModel = issueModel;
            return this;
        }

        private Builder(IssueModelName issueModelName) {
            this.project = issueModelName.project;
            this.location = issueModelName.location;
            this.issueModel = issueModelName.issueModel;
        }

        public IssueModelName build() {
            return new IssueModelName(this);
        }
    }
}

