/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PhraseMatcherName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PHRASE_MATCHER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String phraseMatcher;

    @Deprecated
    protected PhraseMatcherName() {
        this.project = null;
        this.location = null;
        this.phraseMatcher = null;
    }

    private PhraseMatcherName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.phraseMatcher = (String)Preconditions.checkNotNull((Object)builder.getPhraseMatcher());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPhraseMatcher() {
        return this.phraseMatcher;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PhraseMatcherName of(String project, String location, String phraseMatcher) {
        return PhraseMatcherName.newBuilder().setProject(project).setLocation(location).setPhraseMatcher(phraseMatcher).build();
    }

    public static String format(String project, String location, String phraseMatcher) {
        return PhraseMatcherName.newBuilder().setProject(project).setLocation(location).setPhraseMatcher(phraseMatcher).build().toString();
    }

    public static PhraseMatcherName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PHRASE_MATCHER.validatedMatch(formattedString, "PhraseMatcherName.parse: formattedString not in valid format");
        return PhraseMatcherName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("phrase_matcher"));
    }

    public static List<PhraseMatcherName> parseList(List<String> formattedStrings) {
        ArrayList<PhraseMatcherName> list = new ArrayList<PhraseMatcherName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PhraseMatcherName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PhraseMatcherName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PhraseMatcherName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PHRASE_MATCHER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PhraseMatcherName phraseMatcherName = this;
            synchronized (phraseMatcherName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.phraseMatcher != null) {
                        fieldMapBuilder.put((Object)"phrase_matcher", (Object)this.phraseMatcher);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PHRASE_MATCHER.instantiate(new String[]{"project", this.project, "location", this.location, "phrase_matcher", this.phraseMatcher});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PhraseMatcherName that = (PhraseMatcherName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.phraseMatcher, that.phraseMatcher);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.phraseMatcher);
    }

    public static class Builder {
        private String project;
        private String location;
        private String phraseMatcher;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPhraseMatcher() {
            return this.phraseMatcher;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPhraseMatcher(String phraseMatcher) {
            this.phraseMatcher = phraseMatcher;
            return this;
        }

        private Builder(PhraseMatcherName phraseMatcherName) {
            this.project = phraseMatcherName.project;
            this.location = phraseMatcherName.location;
            this.phraseMatcher = phraseMatcherName.phraseMatcher;
        }

        public PhraseMatcherName build() {
            return new PhraseMatcherName(this);
        }
    }
}

