/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The analysis resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.Analysis}
 */
public final class Analysis extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Analysis)
    AnalysisOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Analysis.newBuilder() to construct.
  private Analysis(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Analysis() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Analysis();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Analysis_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Analysis_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.Analysis.class,
            com.google.cloud.contactcenterinsights.v1.Analysis.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the analysis.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the analysis.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp requestTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the requestTime field is set.
   */
  @java.lang.Override
  public boolean hasRequestTime() {
    return requestTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The requestTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRequestTime() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was requested.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was created, which occurs when
   * the long-running operation completes.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was created, which occurs when
   * the long-running operation completes.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the analysis was created, which occurs when
   * the long-running operation completes.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int ANALYSIS_RESULT_FIELD_NUMBER = 7;
  private com.google.cloud.contactcenterinsights.v1.AnalysisResult analysisResult_;
  /**
   *
   *
   * <pre>
   * Output only. The result of the analysis, which is populated when the
   * analysis finishes.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the analysisResult field is set.
   */
  @java.lang.Override
  public boolean hasAnalysisResult() {
    return analysisResult_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The result of the analysis, which is populated when the
   * analysis finishes.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The analysisResult.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisResult getAnalysisResult() {
    return analysisResult_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance()
        : analysisResult_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The result of the analysis, which is populated when the
   * analysis finishes.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder
      getAnalysisResultOrBuilder() {
    return analysisResult_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance()
        : analysisResult_;
  }

  public static final int ANNOTATOR_SELECTOR_FIELD_NUMBER = 8;
  private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
  /**
   *
   *
   * <pre>
   * To select the annotators to run and the phrase matchers to use
   * (if any). If not specified, all annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
   *
   * @return Whether the annotatorSelector field is set.
   */
  @java.lang.Override
  public boolean hasAnnotatorSelector() {
    return annotatorSelector_ != null;
  }
  /**
   *
   *
   * <pre>
   * To select the annotators to run and the phrase matchers to use
   * (if any). If not specified, all annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
   *
   * @return The annotatorSelector.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
    return annotatorSelector_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
        : annotatorSelector_;
  }
  /**
   *
   *
   * <pre>
   * To select the annotators to run and the phrase matchers to use
   * (if any). If not specified, all annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
      getAnnotatorSelectorOrBuilder() {
    return annotatorSelector_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
        : annotatorSelector_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (requestTime_ != null) {
      output.writeMessage(2, getRequestTime());
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (analysisResult_ != null) {
      output.writeMessage(7, getAnalysisResult());
    }
    if (annotatorSelector_ != null) {
      output.writeMessage(8, getAnnotatorSelector());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (requestTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRequestTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (analysisResult_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAnalysisResult());
    }
    if (annotatorSelector_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getAnnotatorSelector());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Analysis)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.Analysis other =
        (com.google.cloud.contactcenterinsights.v1.Analysis) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasRequestTime() != other.hasRequestTime()) return false;
    if (hasRequestTime()) {
      if (!getRequestTime().equals(other.getRequestTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasAnalysisResult() != other.hasAnalysisResult()) return false;
    if (hasAnalysisResult()) {
      if (!getAnalysisResult().equals(other.getAnalysisResult())) return false;
    }
    if (hasAnnotatorSelector() != other.hasAnnotatorSelector()) return false;
    if (hasAnnotatorSelector()) {
      if (!getAnnotatorSelector().equals(other.getAnnotatorSelector())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasRequestTime()) {
      hash = (37 * hash) + REQUEST_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRequestTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasAnalysisResult()) {
      hash = (37 * hash) + ANALYSIS_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getAnalysisResult().hashCode();
    }
    if (hasAnnotatorSelector()) {
      hash = (37 * hash) + ANNOTATOR_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotatorSelector().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.Analysis prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The analysis resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Analysis}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Analysis)
      com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Analysis_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Analysis_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Analysis.class,
              com.google.cloud.contactcenterinsights.v1.Analysis.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.Analysis.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      analysisResult_ = null;
      if (analysisResultBuilder_ != null) {
        analysisResultBuilder_.dispose();
        analysisResultBuilder_ = null;
      }
      annotatorSelector_ = null;
      if (annotatorSelectorBuilder_ != null) {
        annotatorSelectorBuilder_.dispose();
        annotatorSelectorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Analysis_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Analysis getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Analysis build() {
      com.google.cloud.contactcenterinsights.v1.Analysis result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Analysis buildPartial() {
      com.google.cloud.contactcenterinsights.v1.Analysis result =
          new com.google.cloud.contactcenterinsights.v1.Analysis(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.Analysis result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestTime_ =
            requestTimeBuilder_ == null ? requestTime_ : requestTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.analysisResult_ =
            analysisResultBuilder_ == null ? analysisResult_ : analysisResultBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotatorSelector_ =
            annotatorSelectorBuilder_ == null
                ? annotatorSelector_
                : annotatorSelectorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.Analysis) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.Analysis) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.Analysis other) {
      if (other == com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRequestTime()) {
        mergeRequestTime(other.getRequestTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasAnalysisResult()) {
        mergeAnalysisResult(other.getAnalysisResult());
      }
      if (other.hasAnnotatorSelector()) {
        mergeAnnotatorSelector(other.getAnnotatorSelector());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRequestTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 58:
              {
                input.readMessage(getAnalysisResultFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getAnnotatorSelectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the analysis.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the analysis.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the analysis.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the analysis.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the analysis.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp requestTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        requestTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the requestTime field is set.
     */
    public boolean hasRequestTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The requestTime.
     */
    public com.google.protobuf.Timestamp getRequestTime() {
      if (requestTimeBuilder_ == null) {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      } else {
        return requestTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestTime_ = value;
      } else {
        requestTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (requestTimeBuilder_ == null) {
        requestTime_ = builderForValue.build();
      } else {
        requestTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && requestTime_ != null
            && requestTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRequestTimeBuilder().mergeFrom(value);
        } else {
          requestTime_ = value;
        }
      } else {
        requestTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRequestTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRequestTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRequestTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
      if (requestTimeBuilder_ != null) {
        return requestTimeBuilder_.getMessageOrBuilder();
      } else {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was requested.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp request_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRequestTimeFieldBuilder() {
      if (requestTimeBuilder_ == null) {
        requestTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRequestTime(), getParentForChildren(), isClean());
        requestTime_ = null;
      }
      return requestTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the analysis was created, which occurs when
     * the long-running operation completes.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnalysisResult analysisResult_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnalysisResult,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder>
        analysisResultBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the analysisResult field is set.
     */
    public boolean hasAnalysisResult() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The analysisResult.
     */
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult getAnalysisResult() {
      if (analysisResultBuilder_ == null) {
        return analysisResult_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance()
            : analysisResult_;
      } else {
        return analysisResultBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAnalysisResult(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult value) {
      if (analysisResultBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        analysisResult_ = value;
      } else {
        analysisResultBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAnalysisResult(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder builderForValue) {
      if (analysisResultBuilder_ == null) {
        analysisResult_ = builderForValue.build();
      } else {
        analysisResultBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAnalysisResult(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult value) {
      if (analysisResultBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && analysisResult_ != null
            && analysisResult_
                != com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance()) {
          getAnalysisResultBuilder().mergeFrom(value);
        } else {
          analysisResult_ = value;
        }
      } else {
        analysisResultBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAnalysisResult() {
      bitField0_ = (bitField0_ & ~0x00000008);
      analysisResult_ = null;
      if (analysisResultBuilder_ != null) {
        analysisResultBuilder_.dispose();
        analysisResultBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder
        getAnalysisResultBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAnalysisResultFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder
        getAnalysisResultOrBuilder() {
      if (analysisResultBuilder_ != null) {
        return analysisResultBuilder_.getMessageOrBuilder();
      } else {
        return analysisResult_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance()
            : analysisResult_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The result of the analysis, which is populated when the
     * analysis finishes.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult analysis_result = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnalysisResult,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder>
        getAnalysisResultFieldBuilder() {
      if (analysisResultBuilder_ == null) {
        analysisResultBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnalysisResult,
                com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder,
                com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder>(
                getAnalysisResult(), getParentForChildren(), isClean());
        analysisResult_ = null;
      }
      return analysisResultBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
        annotatorSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     *
     * @return Whether the annotatorSelector field is set.
     */
    public boolean hasAnnotatorSelector() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     *
     * @return The annotatorSelector.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
      if (annotatorSelectorBuilder_ == null) {
        return annotatorSelector_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
            : annotatorSelector_;
      } else {
        return annotatorSelectorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public Builder setAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
      if (annotatorSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotatorSelector_ = value;
      } else {
        annotatorSelectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public Builder setAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder builderForValue) {
      if (annotatorSelectorBuilder_ == null) {
        annotatorSelector_ = builderForValue.build();
      } else {
        annotatorSelectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public Builder mergeAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
      if (annotatorSelectorBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && annotatorSelector_ != null
            && annotatorSelector_
                != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                    .getDefaultInstance()) {
          getAnnotatorSelectorBuilder().mergeFrom(value);
        } else {
          annotatorSelector_ = value;
        }
      } else {
        annotatorSelectorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public Builder clearAnnotatorSelector() {
      bitField0_ = (bitField0_ & ~0x00000010);
      annotatorSelector_ = null;
      if (annotatorSelectorBuilder_ != null) {
        annotatorSelectorBuilder_.dispose();
        annotatorSelectorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder
        getAnnotatorSelectorBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAnnotatorSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
        getAnnotatorSelectorOrBuilder() {
      if (annotatorSelectorBuilder_ != null) {
        return annotatorSelectorBuilder_.getMessageOrBuilder();
      } else {
        return annotatorSelector_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
            : annotatorSelector_;
      }
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
        getAnnotatorSelectorFieldBuilder() {
      if (annotatorSelectorBuilder_ == null) {
        annotatorSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>(
                getAnnotatorSelector(), getParentForChildren(), isClean());
        annotatorSelector_ = null;
      }
      return annotatorSelectorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Analysis)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Analysis)
  private static final com.google.cloud.contactcenterinsights.v1.Analysis DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Analysis();
  }

  public static com.google.cloud.contactcenterinsights.v1.Analysis getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Analysis> PARSER =
      new com.google.protobuf.AbstractParser<Analysis>() {
        @java.lang.Override
        public Analysis parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Analysis> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Analysis> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Analysis getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
