/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The result of an analysis.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnalysisResult}
 */
public final class AnalysisResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnalysisResult)
    AnalysisResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalysisResult.newBuilder() to construct.
  private AnalysisResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalysisResult() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalysisResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.class,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder.class);
  }

  public interface CallAnalysisMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation> getAnnotationsList();
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    com.google.cloud.contactcenterinsights.v1.CallAnnotation getAnnotations(int index);
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    int getAnnotationsCount();
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    java.util.List<? extends com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>
        getAnnotationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder getAnnotationsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    int getEntitiesCount();
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    boolean containsEntities(java.lang.String key);
    /** Use {@link #getEntitiesMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity> getEntities();
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
        getEntitiesMap();
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    /* nullable */
    com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.contactcenterinsights.v1.Entity defaultValue);
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
        getSentimentsList();
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment getSentiments(int index);
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    int getSentimentsCount();
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>
        getSentimentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder
        getSentimentsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    int getIntentsCount();
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    boolean containsIntents(java.lang.String key);
    /** Use {@link #getIntentsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent> getIntents();
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
        getIntentsMap();
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    /* nullable */
    com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.contactcenterinsights.v1.Intent defaultValue);
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    int getPhraseMatchersCount();
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    boolean containsPhraseMatchers(java.lang.String key);
    /** Use {@link #getPhraseMatchersMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        getPhraseMatchers();
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        getPhraseMatchersMap();
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    /* nullable */
    com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.contactcenterinsights.v1.PhraseMatchData defaultValue);
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchersOrThrow(
        java.lang.String key);

    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     *
     * @return Whether the issueModelResult field is set.
     */
    boolean hasIssueModelResult();
    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     *
     * @return The issueModelResult.
     */
    com.google.cloud.contactcenterinsights.v1.IssueModelResult getIssueModelResult();
    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     */
    com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder
        getIssueModelResultOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata created during analysis.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata}
   */
  public static final class CallAnalysisMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
      CallAnalysisMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CallAnalysisMetadata.newBuilder() to construct.
    private CallAnalysisMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CallAnalysisMetadata() {
      annotations_ = java.util.Collections.emptyList();
      sentiments_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CallAnalysisMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetEntities();
        case 6:
          return internalGetIntents();
        case 7:
          return internalGetPhraseMatchers();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.class,
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.Builder
                  .class);
    }

    public static final int ANNOTATIONS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation> annotations_;
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation>
        getAnnotationsList() {
      return annotations_;
    }
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>
        getAnnotationsOrBuilderList() {
      return annotations_;
    }
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    @java.lang.Override
    public int getAnnotationsCount() {
      return annotations_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CallAnnotation getAnnotations(int index) {
      return annotations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of call annotations that apply to this call.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder
        getAnnotationsOrBuilder(int index) {
      return annotations_.get(index);
    }

    public static final int ENTITIES_FIELD_NUMBER = 3;

    private static final class EntitiesDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
                      newDefaultInstance(
                          com.google.cloud.contactcenterinsights.v1.ResourcesProto
                              .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_EntitiesEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.contactcenterinsights.v1.Entity.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
        entities_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
        internalGetEntities() {
      if (entities_ == null) {
        return com.google.protobuf.MapField.emptyMapField(EntitiesDefaultEntryHolder.defaultEntry);
      }
      return entities_;
    }

    public int getEntitiesCount() {
      return internalGetEntities().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    @java.lang.Override
    public boolean containsEntities(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEntities().getMap().containsKey(key);
    }
    /** Use {@link #getEntitiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
        getEntities() {
      return getEntitiesMap();
    }
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
        getEntitiesMap() {
      return internalGetEntities().getMap();
    }
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.contactcenterinsights.v1.Entity defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity> map =
          internalGetEntities().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * All the entities in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity> map =
          internalGetEntities().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int SENTIMENTS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
        sentiments_;
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
        getSentimentsList() {
      return sentiments_;
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>
        getSentimentsOrBuilderList() {
      return sentiments_;
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    @java.lang.Override
    public int getSentimentsCount() {
      return sentiments_.size();
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment getSentiments(
        int index) {
      return sentiments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level sentiment for each channel of the call.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder
        getSentimentsOrBuilder(int index) {
      return sentiments_.get(index);
    }

    public static final int INTENTS_FIELD_NUMBER = 6;

    private static final class IntentsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
                      newDefaultInstance(
                          com.google.cloud.contactcenterinsights.v1.ResourcesProto
                              .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_IntentsEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.contactcenterinsights.v1.Intent.getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
        intents_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
        internalGetIntents() {
      if (intents_ == null) {
        return com.google.protobuf.MapField.emptyMapField(IntentsDefaultEntryHolder.defaultEntry);
      }
      return intents_;
    }

    public int getIntentsCount() {
      return internalGetIntents().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    @java.lang.Override
    public boolean containsIntents(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIntents().getMap().containsKey(key);
    }
    /** Use {@link #getIntentsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
        getIntents() {
      return getIntentsMap();
    }
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
        getIntentsMap() {
      return internalGetIntents().getMap();
    }
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.contactcenterinsights.v1.Intent defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent> map =
          internalGetIntents().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * All the matched intents in the call.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent> map =
          internalGetIntents().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int PHRASE_MATCHERS_FIELD_NUMBER = 7;

    private static final class PhraseMatchersDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          defaultEntry =
              com.google.protobuf.MapEntry
                  .<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
                      newDefaultInstance(
                          com.google.cloud.contactcenterinsights.v1.ResourcesProto
                              .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_PhraseMatchersEntry_descriptor,
                          com.google.protobuf.WireFormat.FieldType.STRING,
                          "",
                          com.google.protobuf.WireFormat.FieldType.MESSAGE,
                          com.google.cloud.contactcenterinsights.v1.PhraseMatchData
                              .getDefaultInstance());
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        phraseMatchers_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        internalGetPhraseMatchers() {
      if (phraseMatchers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PhraseMatchersDefaultEntryHolder.defaultEntry);
      }
      return phraseMatchers_;
    }

    public int getPhraseMatchersCount() {
      return internalGetPhraseMatchers().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    @java.lang.Override
    public boolean containsPhraseMatchers(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPhraseMatchers().getMap().containsKey(key);
    }
    /** Use {@link #getPhraseMatchersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        getPhraseMatchers() {
      return getPhraseMatchersMap();
    }
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
        getPhraseMatchersMap() {
      return internalGetPhraseMatchers().getMap();
    }
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.PhraseMatchData
        getPhraseMatchersOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.contactcenterinsights.v1.PhraseMatchData defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          map = internalGetPhraseMatchers().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * All the matched phrase matchers in the call.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchersOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          map = internalGetPhraseMatchers().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ISSUE_MODEL_RESULT_FIELD_NUMBER = 8;
    private com.google.cloud.contactcenterinsights.v1.IssueModelResult issueModelResult_;
    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     *
     * @return Whether the issueModelResult field is set.
     */
    @java.lang.Override
    public boolean hasIssueModelResult() {
      return issueModelResult_ != null;
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     *
     * @return The issueModelResult.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelResult getIssueModelResult() {
      return issueModelResult_ == null
          ? com.google.cloud.contactcenterinsights.v1.IssueModelResult.getDefaultInstance()
          : issueModelResult_;
    }
    /**
     *
     *
     * <pre>
     * Overall conversation-level issue modeling result.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder
        getIssueModelResultOrBuilder() {
      return issueModelResult_ == null
          ? com.google.cloud.contactcenterinsights.v1.IssueModelResult.getDefaultInstance()
          : issueModelResult_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < annotations_.size(); i++) {
        output.writeMessage(2, annotations_.get(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetEntities(), EntitiesDefaultEntryHolder.defaultEntry, 3);
      for (int i = 0; i < sentiments_.size(); i++) {
        output.writeMessage(4, sentiments_.get(i));
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetIntents(), IntentsDefaultEntryHolder.defaultEntry, 6);
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetPhraseMatchers(), PhraseMatchersDefaultEntryHolder.defaultEntry, 7);
      if (issueModelResult_ != null) {
        output.writeMessage(8, getIssueModelResult());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < annotations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, annotations_.get(i));
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          entry : internalGetEntities().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
            entities__ =
                EntitiesDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, entities__);
      }
      for (int i = 0; i < sentiments_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, sentiments_.get(i));
      }
      for (java.util.Map.Entry<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          entry : internalGetIntents().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
            intents__ =
                IntentsDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, intents__);
      }
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          entry : internalGetPhraseMatchers().getMap().entrySet()) {
        com.google.protobuf.MapEntry<
                java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
            phraseMatchers__ =
                PhraseMatchersDefaultEntryHolder.defaultEntry
                    .newBuilderForType()
                    .setKey(entry.getKey())
                    .setValue(entry.getValue())
                    .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, phraseMatchers__);
      }
      if (issueModelResult_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getIssueModelResult());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata other =
          (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata) obj;

      if (!getAnnotationsList().equals(other.getAnnotationsList())) return false;
      if (!internalGetEntities().equals(other.internalGetEntities())) return false;
      if (!getSentimentsList().equals(other.getSentimentsList())) return false;
      if (!internalGetIntents().equals(other.internalGetIntents())) return false;
      if (!internalGetPhraseMatchers().equals(other.internalGetPhraseMatchers())) return false;
      if (hasIssueModelResult() != other.hasIssueModelResult()) return false;
      if (hasIssueModelResult()) {
        if (!getIssueModelResult().equals(other.getIssueModelResult())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAnnotationsCount() > 0) {
        hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotationsList().hashCode();
      }
      if (!internalGetEntities().getMap().isEmpty()) {
        hash = (37 * hash) + ENTITIES_FIELD_NUMBER;
        hash = (53 * hash) + internalGetEntities().hashCode();
      }
      if (getSentimentsCount() > 0) {
        hash = (37 * hash) + SENTIMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getSentimentsList().hashCode();
      }
      if (!internalGetIntents().getMap().isEmpty()) {
        hash = (37 * hash) + INTENTS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetIntents().hashCode();
      }
      if (!internalGetPhraseMatchers().getMap().isEmpty()) {
        hash = (37 * hash) + PHRASE_MATCHERS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetPhraseMatchers().hashCode();
      }
      if (hasIssueModelResult()) {
        hash = (37 * hash) + ISSUE_MODEL_RESULT_FIELD_NUMBER;
        hash = (53 * hash) + getIssueModelResult().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created during analysis.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 3:
            return internalGetEntities();
          case 6:
            return internalGetIntents();
          case 7:
            return internalGetPhraseMatchers();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 3:
            return internalGetMutableEntities();
          case 6:
            return internalGetMutableIntents();
          case 7:
            return internalGetMutablePhraseMatchers();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.class,
                com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (annotationsBuilder_ == null) {
          annotations_ = java.util.Collections.emptyList();
        } else {
          annotations_ = null;
          annotationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableEntities().clear();
        if (sentimentsBuilder_ == null) {
          sentiments_ = java.util.Collections.emptyList();
        } else {
          sentiments_ = null;
          sentimentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        internalGetMutableIntents().clear();
        internalGetMutablePhraseMatchers().clear();
        issueModelResult_ = null;
        if (issueModelResultBuilder_ != null) {
          issueModelResultBuilder_.dispose();
          issueModelResultBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_CallAnalysisMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata build() {
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata result =
            new com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata result) {
        if (annotationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            annotations_ = java.util.Collections.unmodifiableList(annotations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.annotations_ = annotations_;
        } else {
          result.annotations_ = annotationsBuilder_.build();
        }
        if (sentimentsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            sentiments_ = java.util.Collections.unmodifiableList(sentiments_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.sentiments_ = sentiments_;
        } else {
          result.sentiments_ = sentimentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.entities_ = internalGetEntities();
          result.entities_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.intents_ = internalGetIntents();
          result.intents_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.phraseMatchers_ = internalGetPhraseMatchers();
          result.phraseMatchers_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.issueModelResult_ =
              issueModelResultBuilder_ == null
                  ? issueModelResult_
                  : issueModelResultBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                .getDefaultInstance()) return this;
        if (annotationsBuilder_ == null) {
          if (!other.annotations_.isEmpty()) {
            if (annotations_.isEmpty()) {
              annotations_ = other.annotations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAnnotationsIsMutable();
              annotations_.addAll(other.annotations_);
            }
            onChanged();
          }
        } else {
          if (!other.annotations_.isEmpty()) {
            if (annotationsBuilder_.isEmpty()) {
              annotationsBuilder_.dispose();
              annotationsBuilder_ = null;
              annotations_ = other.annotations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              annotationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getAnnotationsFieldBuilder()
                      : null;
            } else {
              annotationsBuilder_.addAllMessages(other.annotations_);
            }
          }
        }
        internalGetMutableEntities().mergeFrom(other.internalGetEntities());
        bitField0_ |= 0x00000002;
        if (sentimentsBuilder_ == null) {
          if (!other.sentiments_.isEmpty()) {
            if (sentiments_.isEmpty()) {
              sentiments_ = other.sentiments_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureSentimentsIsMutable();
              sentiments_.addAll(other.sentiments_);
            }
            onChanged();
          }
        } else {
          if (!other.sentiments_.isEmpty()) {
            if (sentimentsBuilder_.isEmpty()) {
              sentimentsBuilder_.dispose();
              sentimentsBuilder_ = null;
              sentiments_ = other.sentiments_;
              bitField0_ = (bitField0_ & ~0x00000004);
              sentimentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSentimentsFieldBuilder()
                      : null;
            } else {
              sentimentsBuilder_.addAllMessages(other.sentiments_);
            }
          }
        }
        internalGetMutableIntents().mergeFrom(other.internalGetIntents());
        bitField0_ |= 0x00000008;
        internalGetMutablePhraseMatchers().mergeFrom(other.internalGetPhraseMatchers());
        bitField0_ |= 0x00000010;
        if (other.hasIssueModelResult()) {
          mergeIssueModelResult(other.getIssueModelResult());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  com.google.cloud.contactcenterinsights.v1.CallAnnotation m =
                      input.readMessage(
                          com.google.cloud.contactcenterinsights.v1.CallAnnotation.parser(),
                          extensionRegistry);
                  if (annotationsBuilder_ == null) {
                    ensureAnnotationsIsMutable();
                    annotations_.add(m);
                  } else {
                    annotationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 26:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
                      entities__ =
                          input.readMessage(
                              EntitiesDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableEntities()
                      .getMutableMap()
                      .put(entities__.getKey(), entities__.getValue());
                  bitField0_ |= 0x00000002;
                  break;
                } // case 26
              case 34:
                {
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment m =
                      input.readMessage(
                          com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment
                              .parser(),
                          extensionRegistry);
                  if (sentimentsBuilder_ == null) {
                    ensureSentimentsIsMutable();
                    sentiments_.add(m);
                  } else {
                    sentimentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 50:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
                      intents__ =
                          input.readMessage(
                              IntentsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableIntents()
                      .getMutableMap()
                      .put(intents__.getKey(), intents__.getValue());
                  bitField0_ |= 0x00000008;
                  break;
                } // case 50
              case 58:
                {
                  com.google.protobuf.MapEntry<
                          java.lang.String,
                          com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
                      phraseMatchers__ =
                          input.readMessage(
                              PhraseMatchersDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutablePhraseMatchers()
                      .getMutableMap()
                      .put(phraseMatchers__.getKey(), phraseMatchers__.getValue());
                  bitField0_ |= 0x00000010;
                  break;
                } // case 58
              case 66:
                {
                  input.readMessage(
                      getIssueModelResultFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 66
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation>
          annotations_ = java.util.Collections.emptyList();

      private void ensureAnnotationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          annotations_ =
              new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.CallAnnotation>(
                  annotations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.CallAnnotation,
              com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder,
              com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>
          annotationsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation>
          getAnnotationsList() {
        if (annotationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(annotations_);
        } else {
          return annotationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public int getAnnotationsCount() {
        if (annotationsBuilder_ == null) {
          return annotations_.size();
        } else {
          return annotationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CallAnnotation getAnnotations(int index) {
        if (annotationsBuilder_ == null) {
          return annotations_.get(index);
        } else {
          return annotationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder setAnnotations(
          int index, com.google.cloud.contactcenterinsights.v1.CallAnnotation value) {
        if (annotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAnnotationsIsMutable();
          annotations_.set(index, value);
          onChanged();
        } else {
          annotationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder setAnnotations(
          int index,
          com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder builderForValue) {
        if (annotationsBuilder_ == null) {
          ensureAnnotationsIsMutable();
          annotations_.set(index, builderForValue.build());
          onChanged();
        } else {
          annotationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder addAnnotations(
          com.google.cloud.contactcenterinsights.v1.CallAnnotation value) {
        if (annotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAnnotationsIsMutable();
          annotations_.add(value);
          onChanged();
        } else {
          annotationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder addAnnotations(
          int index, com.google.cloud.contactcenterinsights.v1.CallAnnotation value) {
        if (annotationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAnnotationsIsMutable();
          annotations_.add(index, value);
          onChanged();
        } else {
          annotationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder addAnnotations(
          com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder builderForValue) {
        if (annotationsBuilder_ == null) {
          ensureAnnotationsIsMutable();
          annotations_.add(builderForValue.build());
          onChanged();
        } else {
          annotationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder addAnnotations(
          int index,
          com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder builderForValue) {
        if (annotationsBuilder_ == null) {
          ensureAnnotationsIsMutable();
          annotations_.add(index, builderForValue.build());
          onChanged();
        } else {
          annotationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder addAllAnnotations(
          java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.CallAnnotation>
              values) {
        if (annotationsBuilder_ == null) {
          ensureAnnotationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotations_);
          onChanged();
        } else {
          annotationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder clearAnnotations() {
        if (annotationsBuilder_ == null) {
          annotations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          annotationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public Builder removeAnnotations(int index) {
        if (annotationsBuilder_ == null) {
          ensureAnnotationsIsMutable();
          annotations_.remove(index);
          onChanged();
        } else {
          annotationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder getAnnotationsBuilder(
          int index) {
        return getAnnotationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder
          getAnnotationsOrBuilder(int index) {
        if (annotationsBuilder_ == null) {
          return annotations_.get(index);
        } else {
          return annotationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public java.util.List<
              ? extends com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>
          getAnnotationsOrBuilderList() {
        if (annotationsBuilder_ != null) {
          return annotationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(annotations_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder
          addAnnotationsBuilder() {
        return getAnnotationsFieldBuilder()
            .addBuilder(
                com.google.cloud.contactcenterinsights.v1.CallAnnotation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder addAnnotationsBuilder(
          int index) {
        return getAnnotationsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.contactcenterinsights.v1.CallAnnotation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of call annotations that apply to this call.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.CallAnnotation annotations = 2;
       * </code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder>
          getAnnotationsBuilderList() {
        return getAnnotationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.CallAnnotation,
              com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder,
              com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>
          getAnnotationsFieldBuilder() {
        if (annotationsBuilder_ == null) {
          annotationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.CallAnnotation,
                  com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder,
                  com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder>(
                  annotations_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          annotations_ = null;
        }
        return annotationsBuilder_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          entities_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          internalGetEntities() {
        if (entities_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              EntitiesDefaultEntryHolder.defaultEntry);
        }
        return entities_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          internalGetMutableEntities() {
        if (entities_ == null) {
          entities_ =
              com.google.protobuf.MapField.newMapField(EntitiesDefaultEntryHolder.defaultEntry);
        }
        if (!entities_.isMutable()) {
          entities_ = entities_.copy();
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return entities_;
      }

      public int getEntitiesCount() {
        return internalGetEntities().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      @java.lang.Override
      public boolean containsEntities(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetEntities().getMap().containsKey(key);
      }
      /** Use {@link #getEntitiesMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          getEntities() {
        return getEntitiesMap();
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          getEntitiesMap() {
        return internalGetEntities().getMap();
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.contactcenterinsights.v1.Entity defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity> map =
            internalGetEntities().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Entity getEntitiesOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity> map =
            internalGetEntities().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearEntities() {
        bitField0_ = (bitField0_ & ~0x00000002);
        internalGetMutableEntities().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      public Builder removeEntities(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableEntities().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
          getMutableEntities() {
        bitField0_ |= 0x00000002;
        return internalGetMutableEntities().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      public Builder putEntities(
          java.lang.String key, com.google.cloud.contactcenterinsights.v1.Entity value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableEntities().getMutableMap().put(key, value);
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the entities in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Entity&gt; entities = 3;</code>
       */
      public Builder putAllEntities(
          java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Entity>
              values) {
        internalGetMutableEntities().getMutableMap().putAll(values);
        bitField0_ |= 0x00000002;
        return this;
      }

      private java.util.List<com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
          sentiments_ = java.util.Collections.emptyList();

      private void ensureSentimentsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          sentiments_ =
              new java.util.ArrayList<
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>(
                  sentiments_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment,
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder,
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>
          sentimentsBuilder_;

      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
          getSentimentsList() {
        if (sentimentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(sentiments_);
        } else {
          return sentimentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public int getSentimentsCount() {
        if (sentimentsBuilder_ == null) {
          return sentiments_.size();
        } else {
          return sentimentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment getSentiments(
          int index) {
        if (sentimentsBuilder_ == null) {
          return sentiments_.get(index);
        } else {
          return sentimentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder setSentiments(
          int index, com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment value) {
        if (sentimentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSentimentsIsMutable();
          sentiments_.set(index, value);
          onChanged();
        } else {
          sentimentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder setSentiments(
          int index,
          com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
              builderForValue) {
        if (sentimentsBuilder_ == null) {
          ensureSentimentsIsMutable();
          sentiments_.set(index, builderForValue.build());
          onChanged();
        } else {
          sentimentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder addSentiments(
          com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment value) {
        if (sentimentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSentimentsIsMutable();
          sentiments_.add(value);
          onChanged();
        } else {
          sentimentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder addSentiments(
          int index, com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment value) {
        if (sentimentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSentimentsIsMutable();
          sentiments_.add(index, value);
          onChanged();
        } else {
          sentimentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder addSentiments(
          com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
              builderForValue) {
        if (sentimentsBuilder_ == null) {
          ensureSentimentsIsMutable();
          sentiments_.add(builderForValue.build());
          onChanged();
        } else {
          sentimentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder addSentiments(
          int index,
          com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
              builderForValue) {
        if (sentimentsBuilder_ == null) {
          ensureSentimentsIsMutable();
          sentiments_.add(index, builderForValue.build());
          onChanged();
        } else {
          sentimentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder addAllSentiments(
          java.lang.Iterable<
                  ? extends com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment>
              values) {
        if (sentimentsBuilder_ == null) {
          ensureSentimentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sentiments_);
          onChanged();
        } else {
          sentimentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder clearSentiments() {
        if (sentimentsBuilder_ == null) {
          sentiments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          sentimentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public Builder removeSentiments(int index) {
        if (sentimentsBuilder_ == null) {
          ensureSentimentsIsMutable();
          sentiments_.remove(index);
          onChanged();
        } else {
          sentimentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
          getSentimentsBuilder(int index) {
        return getSentimentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder
          getSentimentsOrBuilder(int index) {
        if (sentimentsBuilder_ == null) {
          return sentiments_.get(index);
        } else {
          return sentimentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>
          getSentimentsOrBuilderList() {
        if (sentimentsBuilder_ != null) {
          return sentimentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(sentiments_);
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
          addSentimentsBuilder() {
        return getSentimentsFieldBuilder()
            .addBuilder(
                com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder
          addSentimentsBuilder(int index) {
        return getSentimentsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level sentiment for each channel of the call.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.ConversationLevelSentiment sentiments = 4;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder>
          getSentimentsBuilderList() {
        return getSentimentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment,
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder,
              com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>
          getSentimentsFieldBuilder() {
        if (sentimentsBuilder_ == null) {
          sentimentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment,
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentiment.Builder,
                  com.google.cloud.contactcenterinsights.v1.ConversationLevelSentimentOrBuilder>(
                  sentiments_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
          sentiments_ = null;
        }
        return sentimentsBuilder_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          intents_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          internalGetIntents() {
        if (intents_ == null) {
          return com.google.protobuf.MapField.emptyMapField(IntentsDefaultEntryHolder.defaultEntry);
        }
        return intents_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          internalGetMutableIntents() {
        if (intents_ == null) {
          intents_ =
              com.google.protobuf.MapField.newMapField(IntentsDefaultEntryHolder.defaultEntry);
        }
        if (!intents_.isMutable()) {
          intents_ = intents_.copy();
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return intents_;
      }

      public int getIntentsCount() {
        return internalGetIntents().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      @java.lang.Override
      public boolean containsIntents(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetIntents().getMap().containsKey(key);
      }
      /** Use {@link #getIntentsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          getIntents() {
        return getIntentsMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          getIntentsMap() {
        return internalGetIntents().getMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.contactcenterinsights.v1.Intent defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent> map =
            internalGetIntents().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Intent getIntentsOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent> map =
            internalGetIntents().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearIntents() {
        bitField0_ = (bitField0_ & ~0x00000008);
        internalGetMutableIntents().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      public Builder removeIntents(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableIntents().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
          getMutableIntents() {
        bitField0_ |= 0x00000008;
        return internalGetMutableIntents().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      public Builder putIntents(
          java.lang.String key, com.google.cloud.contactcenterinsights.v1.Intent value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableIntents().getMutableMap().put(key, value);
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the matched intents in the call.
       * </pre>
       *
       * <code>map&lt;string, .google.cloud.contactcenterinsights.v1.Intent&gt; intents = 6;</code>
       */
      public Builder putAllIntents(
          java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.Intent>
              values) {
        internalGetMutableIntents().getMutableMap().putAll(values);
        bitField0_ |= 0x00000008;
        return this;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          phraseMatchers_;

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          internalGetPhraseMatchers() {
        if (phraseMatchers_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              PhraseMatchersDefaultEntryHolder.defaultEntry);
        }
        return phraseMatchers_;
      }

      private com.google.protobuf.MapField<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          internalGetMutablePhraseMatchers() {
        if (phraseMatchers_ == null) {
          phraseMatchers_ =
              com.google.protobuf.MapField.newMapField(
                  PhraseMatchersDefaultEntryHolder.defaultEntry);
        }
        if (!phraseMatchers_.isMutable()) {
          phraseMatchers_ = phraseMatchers_.copy();
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return phraseMatchers_;
      }

      public int getPhraseMatchersCount() {
        return internalGetPhraseMatchers().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      @java.lang.Override
      public boolean containsPhraseMatchers(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetPhraseMatchers().getMap().containsKey(key);
      }
      /** Use {@link #getPhraseMatchersMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          getPhraseMatchers() {
        return getPhraseMatchersMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      @java.lang.Override
      public java.util.Map<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          getPhraseMatchersMap() {
        return internalGetPhraseMatchers().getMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      @java.lang.Override
      public /* nullable */ com.google.cloud.contactcenterinsights.v1.PhraseMatchData
          getPhraseMatchersOrDefault(
              java.lang.String key,
              /* nullable */
              com.google.cloud.contactcenterinsights.v1.PhraseMatchData defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
            map = internalGetPhraseMatchers().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchersOrThrow(
          java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
            map = internalGetPhraseMatchers().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearPhraseMatchers() {
        bitField0_ = (bitField0_ & ~0x00000010);
        internalGetMutablePhraseMatchers().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      public Builder removePhraseMatchers(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutablePhraseMatchers().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
          getMutablePhraseMatchers() {
        bitField0_ |= 0x00000010;
        return internalGetMutablePhraseMatchers().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      public Builder putPhraseMatchers(
          java.lang.String key, com.google.cloud.contactcenterinsights.v1.PhraseMatchData value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutablePhraseMatchers().getMutableMap().put(key, value);
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       *
       *
       * <pre>
       * All the matched phrase matchers in the call.
       * </pre>
       *
       * <code>
       * map&lt;string, .google.cloud.contactcenterinsights.v1.PhraseMatchData&gt; phrase_matchers = 7;
       * </code>
       */
      public Builder putAllPhraseMatchers(
          java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.PhraseMatchData>
              values) {
        internalGetMutablePhraseMatchers().getMutableMap().putAll(values);
        bitField0_ |= 0x00000010;
        return this;
      }

      private com.google.cloud.contactcenterinsights.v1.IssueModelResult issueModelResult_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.IssueModelResult,
              com.google.cloud.contactcenterinsights.v1.IssueModelResult.Builder,
              com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder>
          issueModelResultBuilder_;
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       *
       * @return Whether the issueModelResult field is set.
       */
      public boolean hasIssueModelResult() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       *
       * @return The issueModelResult.
       */
      public com.google.cloud.contactcenterinsights.v1.IssueModelResult getIssueModelResult() {
        if (issueModelResultBuilder_ == null) {
          return issueModelResult_ == null
              ? com.google.cloud.contactcenterinsights.v1.IssueModelResult.getDefaultInstance()
              : issueModelResult_;
        } else {
          return issueModelResultBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public Builder setIssueModelResult(
          com.google.cloud.contactcenterinsights.v1.IssueModelResult value) {
        if (issueModelResultBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          issueModelResult_ = value;
        } else {
          issueModelResultBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public Builder setIssueModelResult(
          com.google.cloud.contactcenterinsights.v1.IssueModelResult.Builder builderForValue) {
        if (issueModelResultBuilder_ == null) {
          issueModelResult_ = builderForValue.build();
        } else {
          issueModelResultBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public Builder mergeIssueModelResult(
          com.google.cloud.contactcenterinsights.v1.IssueModelResult value) {
        if (issueModelResultBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && issueModelResult_ != null
              && issueModelResult_
                  != com.google.cloud.contactcenterinsights.v1.IssueModelResult
                      .getDefaultInstance()) {
            getIssueModelResultBuilder().mergeFrom(value);
          } else {
            issueModelResult_ = value;
          }
        } else {
          issueModelResultBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public Builder clearIssueModelResult() {
        bitField0_ = (bitField0_ & ~0x00000020);
        issueModelResult_ = null;
        if (issueModelResultBuilder_ != null) {
          issueModelResultBuilder_.dispose();
          issueModelResultBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.IssueModelResult.Builder
          getIssueModelResultBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getIssueModelResultFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder
          getIssueModelResultOrBuilder() {
        if (issueModelResultBuilder_ != null) {
          return issueModelResultBuilder_.getMessageOrBuilder();
        } else {
          return issueModelResult_ == null
              ? com.google.cloud.contactcenterinsights.v1.IssueModelResult.getDefaultInstance()
              : issueModelResult_;
        }
      }
      /**
       *
       *
       * <pre>
       * Overall conversation-level issue modeling result.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.IssueModelResult issue_model_result = 8;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.IssueModelResult,
              com.google.cloud.contactcenterinsights.v1.IssueModelResult.Builder,
              com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder>
          getIssueModelResultFieldBuilder() {
        if (issueModelResultBuilder_ == null) {
          issueModelResultBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.IssueModelResult,
                  com.google.cloud.contactcenterinsights.v1.IssueModelResult.Builder,
                  com.google.cloud.contactcenterinsights.v1.IssueModelResultOrBuilder>(
                  getIssueModelResult(), getParentForChildren(), isClean());
          issueModelResult_ = null;
        }
        return issueModelResultBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.AnalysisResult
            .CallAnalysisMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CallAnalysisMetadata> PARSER =
        new com.google.protobuf.AbstractParser<CallAnalysisMetadata>() {
          @java.lang.Override
          public CallAnalysisMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CallAnalysisMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CallAnalysisMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int metadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CALL_ANALYSIS_METADATA(2),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 2:
          return CALL_ANALYSIS_METADATA;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  public static final int CALL_ANALYSIS_METADATA_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Call-specific metadata created by the analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
   * </code>
   *
   * @return Whether the callAnalysisMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCallAnalysisMetadata() {
    return metadataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata created by the analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
   * </code>
   *
   * @return The callAnalysisMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
      getCallAnalysisMetadata() {
    if (metadataCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
          metadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata created by the analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadataOrBuilder
      getCallAnalysisMetadataOrBuilder() {
    if (metadataCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
          metadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        .getDefaultInstance();
  }

  public static final int END_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time at which the analysis ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 1;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the analysis ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 1;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the analysis ended.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (endTime_ != null) {
      output.writeMessage(1, getEndTime());
    }
    if (metadataCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
              metadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEndTime());
    }
    if (metadataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
                  metadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.AnalysisResult)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.AnalysisResult other =
        (com.google.cloud.contactcenterinsights.v1.AnalysisResult) obj;

    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 2:
        if (!getCallAnalysisMetadata().equals(other.getCallAnalysisMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    switch (metadataCase_) {
      case 2:
        hash = (37 * hash) + CALL_ANALYSIS_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getCallAnalysisMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.AnalysisResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The result of an analysis.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnalysisResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnalysisResult)
      com.google.cloud.contactcenterinsights.v1.AnalysisResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.class,
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.AnalysisResult.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (callAnalysisMetadataBuilder_ != null) {
        callAnalysisMetadataBuilder_.clear();
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      metadataCase_ = 0;
      metadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult build() {
      com.google.cloud.contactcenterinsights.v1.AnalysisResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult buildPartial() {
      com.google.cloud.contactcenterinsights.v1.AnalysisResult result =
          new com.google.cloud.contactcenterinsights.v1.AnalysisResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.AnalysisResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult result) {
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 2 && callAnalysisMetadataBuilder_ != null) {
        result.metadata_ = callAnalysisMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.AnalysisResult) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.AnalysisResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.AnalysisResult other) {
      if (other == com.google.cloud.contactcenterinsights.v1.AnalysisResult.getDefaultInstance())
        return this;
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      switch (other.getMetadataCase()) {
        case CALL_ANALYSIS_METADATA:
          {
            mergeCallAnalysisMetadata(other.getCallAnalysisMetadata());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getCallAnalysisMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadataOrBuilder>
        callAnalysisMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     *
     * @return Whether the callAnalysisMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCallAnalysisMetadata() {
      return metadataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     *
     * @return The callAnalysisMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
        getCallAnalysisMetadata() {
      if (callAnalysisMetadataBuilder_ == null) {
        if (metadataCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
              metadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
            .getDefaultInstance();
      } else {
        if (metadataCase_ == 2) {
          return callAnalysisMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    public Builder setCallAnalysisMetadata(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata value) {
      if (callAnalysisMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        callAnalysisMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    public Builder setCallAnalysisMetadata(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.Builder
            builderForValue) {
      if (callAnalysisMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        callAnalysisMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    public Builder mergeCallAnalysisMetadata(
        com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata value) {
      if (callAnalysisMetadataBuilder_ == null) {
        if (metadataCase_ == 2
            && metadata_
                != com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                    .getDefaultInstance()) {
          metadata_ =
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.AnalysisResult
                              .CallAnalysisMetadata)
                          metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 2) {
          callAnalysisMetadataBuilder_.mergeFrom(value);
        } else {
          callAnalysisMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    public Builder clearCallAnalysisMetadata() {
      if (callAnalysisMetadataBuilder_ == null) {
        if (metadataCase_ == 2) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 2) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        callAnalysisMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.Builder
        getCallAnalysisMetadataBuilder() {
      return getCallAnalysisMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadataOrBuilder
        getCallAnalysisMetadataOrBuilder() {
      if ((metadataCase_ == 2) && (callAnalysisMetadataBuilder_ != null)) {
        return callAnalysisMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
              metadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata created by the analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata call_analysis_metadata = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadataOrBuilder>
        getCallAnalysisMetadataFieldBuilder() {
      if (callAnalysisMetadataBuilder_ == null) {
        if (!(metadataCase_ == 2)) {
          metadata_ =
              com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                  .getDefaultInstance();
        }
        callAnalysisMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata,
                com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.AnalysisResult
                    .CallAnalysisMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.AnalysisResult.CallAnalysisMetadata)
                    metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 2;
      onChanged();
      return callAnalysisMetadataBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the analysis ended.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnalysisResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnalysisResult)
  private static final com.google.cloud.contactcenterinsights.v1.AnalysisResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.AnalysisResult();
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalysisResult> PARSER =
      new com.google.protobuf.AbstractParser<AnalysisResult>() {
        @java.lang.Override
        public AnalysisResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnalysisResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalysisResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
