/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The metadata for a bulk analyze conversations operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata}
 */
public final class BulkAnalyzeConversationsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata)
    BulkAnalyzeConversationsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkAnalyzeConversationsMetadata.newBuilder() to construct.
  private BulkAnalyzeConversationsMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkAnalyzeConversationsMetadata() {
    partialErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkAnalyzeConversationsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkAnalyzeConversationsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkAnalyzeConversationsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.class,
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.Builder
                .class);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request_;
  /**
   *
   *
   * <pre>
   * The original request for bulk analyze.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
   * </code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return request_ != null;
  }
  /**
   *
   *
   * <pre>
   * The original request for bulk analyze.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
   * </code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest getRequest() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
            .getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * The original request for bulk analyze.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequestOrBuilder
      getRequestOrBuilder() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
            .getDefaultInstance()
        : request_;
  }

  public static final int COMPLETED_ANALYSES_COUNT_FIELD_NUMBER = 4;
  private int completedAnalysesCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of requested analyses that have completed successfully so far.
   * </pre>
   *
   * <code>int32 completed_analyses_count = 4;</code>
   *
   * @return The completedAnalysesCount.
   */
  @java.lang.Override
  public int getCompletedAnalysesCount() {
    return completedAnalysesCount_;
  }

  public static final int FAILED_ANALYSES_COUNT_FIELD_NUMBER = 5;
  private int failedAnalysesCount_ = 0;
  /**
   *
   *
   * <pre>
   * The number of requested analyses that have failed so far.
   * </pre>
   *
   * <code>int32 failed_analyses_count = 5;</code>
   *
   * @return The failedAnalysesCount.
   */
  @java.lang.Override
  public int getFailedAnalysesCount() {
    return failedAnalysesCount_;
  }

  public static final int TOTAL_REQUESTED_ANALYSES_COUNT_FIELD_NUMBER = 6;
  private int totalRequestedAnalysesCount_ = 0;
  /**
   *
   *
   * <pre>
   * Total number of analyses requested. Computed by the number of conversations
   * returned by `filter` multiplied by `analysis_percentage` in the request.
   * </pre>
   *
   * <code>int32 total_requested_analyses_count = 6;</code>
   *
   * @return The totalRequestedAnalysesCount.
   */
  @java.lang.Override
  public int getTotalRequestedAnalysesCount() {
    return totalRequestedAnalysesCount_;
  }

  public static final int PARTIAL_ERRORS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialErrors_;
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during bulk analyze operation that might cause
   * the operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during bulk analyze operation that might cause
   * the operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getPartialErrorsOrBuilderList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during bulk analyze operation that might cause
   * the operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPartialErrorsCount() {
    return partialErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during bulk analyze operation that might cause
   * the operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialErrors(int index) {
    return partialErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during bulk analyze operation that might cause
   * the operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
    return partialErrors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (request_ != null) {
      output.writeMessage(3, getRequest());
    }
    if (completedAnalysesCount_ != 0) {
      output.writeInt32(4, completedAnalysesCount_);
    }
    if (failedAnalysesCount_ != 0) {
      output.writeInt32(5, failedAnalysesCount_);
    }
    if (totalRequestedAnalysesCount_ != 0) {
      output.writeInt32(6, totalRequestedAnalysesCount_);
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      output.writeMessage(7, partialErrors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (request_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    if (completedAnalysesCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, completedAnalysesCount_);
    }
    if (failedAnalysesCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, failedAnalysesCount_);
    }
    if (totalRequestedAnalysesCount_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(6, totalRequestedAnalysesCount_);
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, partialErrors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata other =
        (com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (getCompletedAnalysesCount() != other.getCompletedAnalysesCount()) return false;
    if (getFailedAnalysesCount() != other.getFailedAnalysesCount()) return false;
    if (getTotalRequestedAnalysesCount() != other.getTotalRequestedAnalysesCount()) return false;
    if (!getPartialErrorsList().equals(other.getPartialErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    hash = (37 * hash) + COMPLETED_ANALYSES_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getCompletedAnalysesCount();
    hash = (37 * hash) + FAILED_ANALYSES_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getFailedAnalysesCount();
    hash = (37 * hash) + TOTAL_REQUESTED_ANALYSES_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalRequestedAnalysesCount();
    if (getPartialErrorsCount() > 0) {
      hash = (37 * hash) + PARTIAL_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metadata for a bulk analyze conversations operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata)
      com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkAnalyzeConversationsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkAnalyzeConversationsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.class,
              com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      completedAnalysesCount_ = 0;
      failedAnalysesCount_ = 0;
      totalRequestedAnalysesCount_ = 0;
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
      } else {
        partialErrors_ = null;
        partialErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkAnalyzeConversationsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata build() {
      com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata result =
          new com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata result) {
      if (partialErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.partialErrors_ = partialErrors_;
      } else {
        result.partialErrors_ = partialErrorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.completedAnalysesCount_ = completedAnalysesCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.failedAnalysesCount_ = failedAnalysesCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.totalRequestedAnalysesCount_ = totalRequestedAnalysesCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
              .getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (other.getCompletedAnalysesCount() != 0) {
        setCompletedAnalysesCount(other.getCompletedAnalysesCount());
      }
      if (other.getFailedAnalysesCount() != 0) {
        setFailedAnalysesCount(other.getFailedAnalysesCount());
      }
      if (other.getTotalRequestedAnalysesCount() != 0) {
        setTotalRequestedAnalysesCount(other.getTotalRequestedAnalysesCount());
      }
      if (partialErrorsBuilder_ == null) {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrors_.isEmpty()) {
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensurePartialErrorsIsMutable();
            partialErrors_.addAll(other.partialErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrorsBuilder_.isEmpty()) {
            partialErrorsBuilder_.dispose();
            partialErrorsBuilder_ = null;
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000040);
            partialErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialErrorsFieldBuilder()
                    : null;
          } else {
            partialErrorsBuilder_.addAllMessages(other.partialErrors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                completedAnalysesCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                failedAnalysesCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                totalRequestedAnalysesCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialErrorsBuilder_ == null) {
                  ensurePartialErrorsIsMutable();
                  partialErrors_.add(m);
                } else {
                  partialErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     *
     * @return The request.
     */
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
                .getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.Builder
            builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public Builder mergeRequest(
        com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_
                != com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
                    .getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.Builder
        getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequestOrBuilder
        getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest
                .getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * The original request for bulk analyze.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest request = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest,
                com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequest.Builder,
                com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private int completedAnalysesCount_;
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have completed successfully so far.
     * </pre>
     *
     * <code>int32 completed_analyses_count = 4;</code>
     *
     * @return The completedAnalysesCount.
     */
    @java.lang.Override
    public int getCompletedAnalysesCount() {
      return completedAnalysesCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have completed successfully so far.
     * </pre>
     *
     * <code>int32 completed_analyses_count = 4;</code>
     *
     * @param value The completedAnalysesCount to set.
     * @return This builder for chaining.
     */
    public Builder setCompletedAnalysesCount(int value) {

      completedAnalysesCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have completed successfully so far.
     * </pre>
     *
     * <code>int32 completed_analyses_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletedAnalysesCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      completedAnalysesCount_ = 0;
      onChanged();
      return this;
    }

    private int failedAnalysesCount_;
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have failed so far.
     * </pre>
     *
     * <code>int32 failed_analyses_count = 5;</code>
     *
     * @return The failedAnalysesCount.
     */
    @java.lang.Override
    public int getFailedAnalysesCount() {
      return failedAnalysesCount_;
    }
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have failed so far.
     * </pre>
     *
     * <code>int32 failed_analyses_count = 5;</code>
     *
     * @param value The failedAnalysesCount to set.
     * @return This builder for chaining.
     */
    public Builder setFailedAnalysesCount(int value) {

      failedAnalysesCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of requested analyses that have failed so far.
     * </pre>
     *
     * <code>int32 failed_analyses_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailedAnalysesCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      failedAnalysesCount_ = 0;
      onChanged();
      return this;
    }

    private int totalRequestedAnalysesCount_;
    /**
     *
     *
     * <pre>
     * Total number of analyses requested. Computed by the number of conversations
     * returned by `filter` multiplied by `analysis_percentage` in the request.
     * </pre>
     *
     * <code>int32 total_requested_analyses_count = 6;</code>
     *
     * @return The totalRequestedAnalysesCount.
     */
    @java.lang.Override
    public int getTotalRequestedAnalysesCount() {
      return totalRequestedAnalysesCount_;
    }
    /**
     *
     *
     * <pre>
     * Total number of analyses requested. Computed by the number of conversations
     * returned by `filter` multiplied by `analysis_percentage` in the request.
     * </pre>
     *
     * <code>int32 total_requested_analyses_count = 6;</code>
     *
     * @param value The totalRequestedAnalysesCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalRequestedAnalysesCount(int value) {

      totalRequestedAnalysesCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Total number of analyses requested. Computed by the number of conversations
     * returned by `filter` multiplied by `analysis_percentage` in the request.
     * </pre>
     *
     * <code>int32 total_requested_analyses_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalRequestedAnalysesCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      totalRequestedAnalysesCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> partialErrors_ =
        java.util.Collections.emptyList();

    private void ensurePartialErrorsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>(partialErrors_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
      if (partialErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialErrors_);
      } else {
        return partialErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPartialErrorsCount() {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.size();
      } else {
        return partialErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getPartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPartialErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialErrors_);
        onChanged();
      } else {
        partialErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPartialErrors() {
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.remove(index);
        onChanged();
      } else {
        partialErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialErrorsOrBuilderList() {
      if (partialErrorsBuilder_ != null) {
        return partialErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder() {
      return getPartialErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during bulk analyze operation that might cause
     * the operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialErrorsBuilderList() {
      return getPartialErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialErrorsFieldBuilder() {
      if (partialErrorsBuilder_ == null) {
        partialErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialErrors_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        partialErrors_ = null;
      }
      return partialErrorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata)
  private static final com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata();
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkAnalyzeConversationsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BulkAnalyzeConversationsMetadata>() {
        @java.lang.Override
        public BulkAnalyzeConversationsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkAnalyzeConversationsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkAnalyzeConversationsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkAnalyzeConversationsMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
