/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The response for calculating conversation statistics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.CalculateStatsResponse}
 */
public final class CalculateStatsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse)
    CalculateStatsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CalculateStatsResponse.newBuilder() to construct.
  private CalculateStatsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CalculateStatsResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CalculateStatsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetSmartHighlighterMatches();
      case 5:
        return internalGetCustomHighlighterMatches();
      case 6:
        return internalGetIssueMatches();
      case 8:
        return internalGetIssueMatchesStats();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.class,
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.Builder.class);
  }

  public interface TimeSeriesOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     *
     * @return Whether the intervalDuration field is set.
     */
    boolean hasIntervalDuration();
    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     *
     * @return The intervalDuration.
     */
    com.google.protobuf.Duration getIntervalDuration();
    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     */
    com.google.protobuf.DurationOrBuilder getIntervalDurationOrBuilder();

    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    java.util.List<
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval>
        getPointsList();
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval getPoints(
        int index);
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    int getPointsCount();
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                    .IntervalOrBuilder>
        getPointsOrBuilderList();
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.IntervalOrBuilder
        getPointsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A time series representing conversations over time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries}
   */
  public static final class TimeSeries extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)
      TimeSeriesOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TimeSeries.newBuilder() to construct.
    private TimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TimeSeries() {
      points_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TimeSeries();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.class,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder
                  .class);
    }

    public interface IntervalOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      boolean hasStartTime();
      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      com.google.protobuf.Timestamp getStartTime();
      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * The number of conversations created in this interval.
       * </pre>
       *
       * <code>int32 conversation_count = 2;</code>
       *
       * @return The conversationCount.
       */
      int getConversationCount();
    }
    /**
     *
     *
     * <pre>
     * A single interval in a time series.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval}
     */
    public static final class Interval extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
        IntervalOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Interval.newBuilder() to construct.
      private Interval(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Interval() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Interval();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_Interval_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_Interval_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                    .class,
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                    .Builder.class);
      }

      public static final int START_TIME_FIELD_NUMBER = 1;
      private com.google.protobuf.Timestamp startTime_;
      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return Whether the startTime field is set.
       */
      @java.lang.Override
      public boolean hasStartTime() {
        return startTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       *
       * @return The startTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getStartTime() {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
      /**
       *
       *
       * <pre>
       * The start time of this interval.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_time = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }

      public static final int CONVERSATION_COUNT_FIELD_NUMBER = 2;
      private int conversationCount_ = 0;
      /**
       *
       *
       * <pre>
       * The number of conversations created in this interval.
       * </pre>
       *
       * <code>int32 conversation_count = 2;</code>
       *
       * @return The conversationCount.
       */
      @java.lang.Override
      public int getConversationCount() {
        return conversationCount_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (startTime_ != null) {
          output.writeMessage(1, getStartTime());
        }
        if (conversationCount_ != 0) {
          output.writeInt32(2, conversationCount_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (startTime_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTime());
        }
        if (conversationCount_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, conversationCount_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval other =
            (com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
                obj;

        if (hasStartTime() != other.hasStartTime()) return false;
        if (hasStartTime()) {
          if (!getStartTime().equals(other.getStartTime())) return false;
        }
        if (getConversationCount() != other.getConversationCount()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStartTime()) {
          hash = (37 * hash) + START_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getStartTime().hashCode();
        }
        hash = (37 * hash) + CONVERSATION_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getConversationCount();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A single interval in a time series.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .IntervalOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_Interval_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_Interval_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval.class,
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval.Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          startTime_ = null;
          if (startTimeBuilder_ != null) {
            startTimeBuilder_.dispose();
            startTimeBuilder_ = null;
          }
          conversationCount_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_Interval_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
            build() {
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              result =
                  new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.conversationCount_ = conversationCount_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                  .Interval) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                        .Interval)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                  .Interval.getDefaultInstance()) return this;
          if (other.hasStartTime()) {
            mergeStartTime(other.getStartTime());
          }
          if (other.getConversationCount() != 0) {
            setConversationCount(other.getConversationCount());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    conversationCount_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Timestamp startTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            startTimeBuilder_;
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         *
         * @return Whether the startTime field is set.
         */
        public boolean hasStartTime() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         *
         * @return The startTime.
         */
        public com.google.protobuf.Timestamp getStartTime() {
          if (startTimeBuilder_ == null) {
            return startTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : startTime_;
          } else {
            return startTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public Builder setStartTime(com.google.protobuf.Timestamp value) {
          if (startTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            startTime_ = value;
          } else {
            startTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (startTimeBuilder_ == null) {
            startTime_ = builderForValue.build();
          } else {
            startTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
          if (startTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && startTime_ != null
                && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getStartTimeBuilder().mergeFrom(value);
            } else {
              startTime_ = value;
            }
          } else {
            startTimeBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public Builder clearStartTime() {
          bitField0_ = (bitField0_ & ~0x00000001);
          startTime_ = null;
          if (startTimeBuilder_ != null) {
            startTimeBuilder_.dispose();
            startTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getStartTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
          if (startTimeBuilder_ != null) {
            return startTimeBuilder_.getMessageOrBuilder();
          } else {
            return startTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : startTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * The start time of this interval.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp start_time = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getStartTimeFieldBuilder() {
          if (startTimeBuilder_ == null) {
            startTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getStartTime(), getParentForChildren(), isClean());
            startTime_ = null;
          }
          return startTimeBuilder_;
        }

        private int conversationCount_;
        /**
         *
         *
         * <pre>
         * The number of conversations created in this interval.
         * </pre>
         *
         * <code>int32 conversation_count = 2;</code>
         *
         * @return The conversationCount.
         */
        @java.lang.Override
        public int getConversationCount() {
          return conversationCount_;
        }
        /**
         *
         *
         * <pre>
         * The number of conversations created in this interval.
         * </pre>
         *
         * <code>int32 conversation_count = 2;</code>
         *
         * @param value The conversationCount to set.
         * @return This builder for chaining.
         */
        public Builder setConversationCount(int value) {

          conversationCount_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The number of conversations created in this interval.
         * </pre>
         *
         * <code>int32 conversation_count = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConversationCount() {
          bitField0_ = (bitField0_ & ~0x00000002);
          conversationCount_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval)
      private static final com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
              .TimeSeries.Interval
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                .Interval();
      }

      public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .Interval
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Interval> PARSER =
          new com.google.protobuf.AbstractParser<Interval>() {
            @java.lang.Override
            public Interval parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Interval> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Interval> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int INTERVAL_DURATION_FIELD_NUMBER = 1;
    private com.google.protobuf.Duration intervalDuration_;
    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     *
     * @return Whether the intervalDuration field is set.
     */
    @java.lang.Override
    public boolean hasIntervalDuration() {
      return intervalDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     *
     * @return The intervalDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getIntervalDuration() {
      return intervalDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : intervalDuration_;
    }
    /**
     *
     *
     * <pre>
     * The duration of each interval.
     * </pre>
     *
     * <code>.google.protobuf.Duration interval_duration = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getIntervalDurationOrBuilder() {
      return intervalDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : intervalDuration_;
    }

    public static final int POINTS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval>
        points_;
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval>
        getPointsList() {
      return points_;
    }
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                    .IntervalOrBuilder>
        getPointsOrBuilderList() {
      return points_;
    }
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    @java.lang.Override
    public int getPointsCount() {
      return points_.size();
    }
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
        getPoints(int index) {
      return points_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An ordered list of intervals from earliest to latest, where each interval
     * represents the number of conversations that transpired during the time
     * window.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
            .IntervalOrBuilder
        getPointsOrBuilder(int index) {
      return points_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (intervalDuration_ != null) {
        output.writeMessage(1, getIntervalDuration());
      }
      for (int i = 0; i < points_.size(); i++) {
        output.writeMessage(2, points_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (intervalDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIntervalDuration());
      }
      for (int i = 0; i < points_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, points_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries other =
          (com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries) obj;

      if (hasIntervalDuration() != other.hasIntervalDuration()) return false;
      if (hasIntervalDuration()) {
        if (!getIntervalDuration().equals(other.getIntervalDuration())) return false;
      }
      if (!getPointsList().equals(other.getPointsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIntervalDuration()) {
        hash = (37 * hash) + INTERVAL_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getIntervalDuration().hashCode();
      }
      if (getPointsCount() > 0) {
        hash = (37 * hash) + POINTS_FIELD_NUMBER;
        hash = (53 * hash) + getPointsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A time series representing conversations over time.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeriesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.class,
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        intervalDuration_ = null;
        if (intervalDurationBuilder_ != null) {
          intervalDurationBuilder_.dispose();
          intervalDurationBuilder_ = null;
        }
        if (pointsBuilder_ == null) {
          points_ = java.util.Collections.emptyList();
        } else {
          points_ = null;
          pointsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_TimeSeries_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries build() {
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries result =
            new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries result) {
        if (pointsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            points_ = java.util.Collections.unmodifiableList(points_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.points_ = points_;
        } else {
          result.points_ = pointsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.intervalDuration_ =
              intervalDurationBuilder_ == null
                  ? intervalDuration_
                  : intervalDurationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                .getDefaultInstance()) return this;
        if (other.hasIntervalDuration()) {
          mergeIntervalDuration(other.getIntervalDuration());
        }
        if (pointsBuilder_ == null) {
          if (!other.points_.isEmpty()) {
            if (points_.isEmpty()) {
              points_ = other.points_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensurePointsIsMutable();
              points_.addAll(other.points_);
            }
            onChanged();
          }
        } else {
          if (!other.points_.isEmpty()) {
            if (pointsBuilder_.isEmpty()) {
              pointsBuilder_.dispose();
              pointsBuilder_ = null;
              points_ = other.points_;
              bitField0_ = (bitField0_ & ~0x00000002);
              pointsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPointsFieldBuilder()
                      : null;
            } else {
              pointsBuilder_.addAllMessages(other.points_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getIntervalDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                          .Interval
                      m =
                          input.readMessage(
                              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
                                  .TimeSeries.Interval.parser(),
                              extensionRegistry);
                  if (pointsBuilder_ == null) {
                    ensurePointsIsMutable();
                    points_.add(m);
                  } else {
                    pointsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Duration intervalDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          intervalDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       *
       * @return Whether the intervalDuration field is set.
       */
      public boolean hasIntervalDuration() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       *
       * @return The intervalDuration.
       */
      public com.google.protobuf.Duration getIntervalDuration() {
        if (intervalDurationBuilder_ == null) {
          return intervalDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : intervalDuration_;
        } else {
          return intervalDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public Builder setIntervalDuration(com.google.protobuf.Duration value) {
        if (intervalDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          intervalDuration_ = value;
        } else {
          intervalDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public Builder setIntervalDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (intervalDurationBuilder_ == null) {
          intervalDuration_ = builderForValue.build();
        } else {
          intervalDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public Builder mergeIntervalDuration(com.google.protobuf.Duration value) {
        if (intervalDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && intervalDuration_ != null
              && intervalDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getIntervalDurationBuilder().mergeFrom(value);
          } else {
            intervalDuration_ = value;
          }
        } else {
          intervalDurationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public Builder clearIntervalDuration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        intervalDuration_ = null;
        if (intervalDurationBuilder_ != null) {
          intervalDurationBuilder_.dispose();
          intervalDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public com.google.protobuf.Duration.Builder getIntervalDurationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getIntervalDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      public com.google.protobuf.DurationOrBuilder getIntervalDurationOrBuilder() {
        if (intervalDurationBuilder_ != null) {
          return intervalDurationBuilder_.getMessageOrBuilder();
        } else {
          return intervalDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : intervalDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The duration of each interval.
       * </pre>
       *
       * <code>.google.protobuf.Duration interval_duration = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getIntervalDurationFieldBuilder() {
        if (intervalDurationBuilder_ == null) {
          intervalDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getIntervalDuration(), getParentForChildren(), isClean());
          intervalDuration_ = null;
        }
        return intervalDurationBuilder_;
      }

      private java.util.List<
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval>
          points_ = java.util.Collections.emptyList();

      private void ensurePointsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          points_ =
              new java.util.ArrayList<
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval>(points_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                  .IntervalOrBuilder>
          pointsBuilder_;

      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval>
          getPointsList() {
        if (pointsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(points_);
        } else {
          return pointsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public int getPointsCount() {
        if (pointsBuilder_ == null) {
          return points_.size();
        } else {
          return pointsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
          getPoints(int index) {
        if (pointsBuilder_ == null) {
          return points_.get(index);
        } else {
          return pointsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder setPoints(
          int index,
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              value) {
        if (pointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePointsIsMutable();
          points_.set(index, value);
          onChanged();
        } else {
          pointsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder setPoints(
          int index,
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder
              builderForValue) {
        if (pointsBuilder_ == null) {
          ensurePointsIsMutable();
          points_.set(index, builderForValue.build());
          onChanged();
        } else {
          pointsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder addPoints(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              value) {
        if (pointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePointsIsMutable();
          points_.add(value);
          onChanged();
        } else {
          pointsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder addPoints(
          int index,
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              value) {
        if (pointsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePointsIsMutable();
          points_.add(index, value);
          onChanged();
        } else {
          pointsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder addPoints(
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder
              builderForValue) {
        if (pointsBuilder_ == null) {
          ensurePointsIsMutable();
          points_.add(builderForValue.build());
          onChanged();
        } else {
          pointsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder addPoints(
          int index,
          com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder
              builderForValue) {
        if (pointsBuilder_ == null) {
          ensurePointsIsMutable();
          points_.add(index, builderForValue.build());
          onChanged();
        } else {
          pointsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder addAllPoints(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                          .Interval>
              values) {
        if (pointsBuilder_ == null) {
          ensurePointsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, points_);
          onChanged();
        } else {
          pointsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder clearPoints() {
        if (pointsBuilder_ == null) {
          points_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          pointsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public Builder removePoints(int index) {
        if (pointsBuilder_ == null) {
          ensurePointsIsMutable();
          points_.remove(index);
          onChanged();
        } else {
          pointsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              .Builder
          getPointsBuilder(int index) {
        return getPointsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
              .IntervalOrBuilder
          getPointsOrBuilder(int index) {
        if (pointsBuilder_ == null) {
          return points_.get(index);
        } else {
          return pointsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .IntervalOrBuilder>
          getPointsOrBuilderList() {
        if (pointsBuilder_ != null) {
          return pointsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(points_);
        }
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              .Builder
          addPointsBuilder() {
        return getPointsFieldBuilder()
            .addBuilder(
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
              .Builder
          addPointsBuilder(int index) {
        return getPointsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An ordered list of intervals from earliest to latest, where each interval
       * represents the number of conversations that transpired during the time
       * window.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval points = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder>
          getPointsBuilderList() {
        return getPointsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Interval
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                  .IntervalOrBuilder>
          getPointsFieldBuilder() {
        if (pointsBuilder_ == null) {
          pointsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval,
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .Interval.Builder,
                  com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                      .IntervalOrBuilder>(
                  points_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          points_ = null;
        }
        return pointsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries)
    private static final com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries();
    }

    public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TimeSeries> PARSER =
        new com.google.protobuf.AbstractParser<TimeSeries>() {
          @java.lang.Override
          public TimeSeries parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TimeSeries> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeSeries> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int AVERAGE_DURATION_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration averageDuration_;
  /**
   *
   *
   * <pre>
   * The average duration of all conversations. The average is calculated using
   * only conversations that have a time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration average_duration = 1;</code>
   *
   * @return Whether the averageDuration field is set.
   */
  @java.lang.Override
  public boolean hasAverageDuration() {
    return averageDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * The average duration of all conversations. The average is calculated using
   * only conversations that have a time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration average_duration = 1;</code>
   *
   * @return The averageDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getAverageDuration() {
    return averageDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : averageDuration_;
  }
  /**
   *
   *
   * <pre>
   * The average duration of all conversations. The average is calculated using
   * only conversations that have a time duration.
   * </pre>
   *
   * <code>.google.protobuf.Duration average_duration = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getAverageDurationOrBuilder() {
    return averageDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : averageDuration_;
  }

  public static final int AVERAGE_TURN_COUNT_FIELD_NUMBER = 2;
  private int averageTurnCount_ = 0;
  /**
   *
   *
   * <pre>
   * The average number of turns per conversation.
   * </pre>
   *
   * <code>int32 average_turn_count = 2;</code>
   *
   * @return The averageTurnCount.
   */
  @java.lang.Override
  public int getAverageTurnCount() {
    return averageTurnCount_;
  }

  public static final int CONVERSATION_COUNT_FIELD_NUMBER = 3;
  private int conversationCount_ = 0;
  /**
   *
   *
   * <pre>
   * The total number of conversations.
   * </pre>
   *
   * <code>int32 conversation_count = 3;</code>
   *
   * @return The conversationCount.
   */
  @java.lang.Override
  public int getConversationCount() {
    return conversationCount_;
  }

  public static final int SMART_HIGHLIGHTER_MATCHES_FIELD_NUMBER = 4;

  private static final class SmartHighlighterMatchesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_SmartHighlighterMatchesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      smartHighlighterMatches_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetSmartHighlighterMatches() {
    if (smartHighlighterMatches_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          SmartHighlighterMatchesDefaultEntryHolder.defaultEntry);
    }
    return smartHighlighterMatches_;
  }

  public int getSmartHighlighterMatchesCount() {
    return internalGetSmartHighlighterMatches().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map associating each smart highlighter display name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
   */
  @java.lang.Override
  public boolean containsSmartHighlighterMatches(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetSmartHighlighterMatches().getMap().containsKey(key);
  }
  /** Use {@link #getSmartHighlighterMatchesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getSmartHighlighterMatches() {
    return getSmartHighlighterMatchesMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each smart highlighter display name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getSmartHighlighterMatchesMap() {
    return internalGetSmartHighlighterMatches().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each smart highlighter display name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
   */
  @java.lang.Override
  public int getSmartHighlighterMatchesOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetSmartHighlighterMatches().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map associating each smart highlighter display name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
   */
  @java.lang.Override
  public int getSmartHighlighterMatchesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetSmartHighlighterMatches().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CUSTOM_HIGHLIGHTER_MATCHES_FIELD_NUMBER = 5;

  private static final class CustomHighlighterMatchesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_CustomHighlighterMatchesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      customHighlighterMatches_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetCustomHighlighterMatches() {
    if (customHighlighterMatches_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CustomHighlighterMatchesDefaultEntryHolder.defaultEntry);
    }
    return customHighlighterMatches_;
  }

  public int getCustomHighlighterMatchesCount() {
    return internalGetCustomHighlighterMatches().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map associating each custom highlighter resource name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
   */
  @java.lang.Override
  public boolean containsCustomHighlighterMatches(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCustomHighlighterMatches().getMap().containsKey(key);
  }
  /** Use {@link #getCustomHighlighterMatchesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getCustomHighlighterMatches() {
    return getCustomHighlighterMatchesMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each custom highlighter resource name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getCustomHighlighterMatchesMap() {
    return internalGetCustomHighlighterMatches().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each custom highlighter resource name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
   */
  @java.lang.Override
  public int getCustomHighlighterMatchesOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetCustomHighlighterMatches().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map associating each custom highlighter resource name with its respective
   * number of matches in the set of conversations.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
   */
  @java.lang.Override
  public int getCustomHighlighterMatchesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map =
        internalGetCustomHighlighterMatches().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ISSUE_MATCHES_FIELD_NUMBER = 6;

  private static final class IssueMatchesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_IssueMatchesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> issueMatches_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetIssueMatches() {
    if (issueMatches_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          IssueMatchesDefaultEntryHolder.defaultEntry);
    }
    return issueMatches_;
  }

  @java.lang.Deprecated
  public int getIssueMatchesCount() {
    return internalGetIssueMatches().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * Deprecated, use `issue_matches_stats` field instead.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean containsIssueMatches(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetIssueMatches().getMap().containsKey(key);
  }
  /** Use {@link #getIssueMatchesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getIssueMatches() {
    return getIssueMatchesMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * Deprecated, use `issue_matches_stats` field instead.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getIssueMatchesMap() {
    return internalGetIssueMatches().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * Deprecated, use `issue_matches_stats` field instead.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getIssueMatchesOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetIssueMatches().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * Deprecated, use `issue_matches_stats` field instead.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getIssueMatchesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetIssueMatches().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ISSUE_MATCHES_STATS_FIELD_NUMBER = 8;

  private static final class IssueMatchesStatsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
                    newDefaultInstance(
                        com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                            .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_IssueMatchesStatsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      issueMatchesStats_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      internalGetIssueMatchesStats() {
    if (issueMatchesStats_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          IssueMatchesStatsDefaultEntryHolder.defaultEntry);
    }
    return issueMatchesStats_;
  }

  public int getIssueMatchesStatsCount() {
    return internalGetIssueMatchesStats().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
   * </code>
   */
  @java.lang.Override
  public boolean containsIssueMatchesStats(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetIssueMatchesStats().getMap().containsKey(key);
  }
  /** Use {@link #getIssueMatchesStatsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      getIssueMatchesStats() {
    return getIssueMatchesStatsMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      getIssueMatchesStatsMap() {
    return internalGetIssueMatchesStats().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
      getIssueMatchesStatsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        map = internalGetIssueMatchesStats().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map associating each issue resource name with its respective number of
   * matches in the set of conversations. Key has the format:
   * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
      getIssueMatchesStatsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        map = internalGetIssueMatchesStats().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONVERSATION_COUNT_TIME_SERIES_FIELD_NUMBER = 7;
  private com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
      conversationCountTimeSeries_;
  /**
   *
   *
   * <pre>
   * A time series representing the count of conversations created over time
   * that match that requested filter criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
   * </code>
   *
   * @return Whether the conversationCountTimeSeries field is set.
   */
  @java.lang.Override
  public boolean hasConversationCountTimeSeries() {
    return conversationCountTimeSeries_ != null;
  }
  /**
   *
   *
   * <pre>
   * A time series representing the count of conversations created over time
   * that match that requested filter criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
   * </code>
   *
   * @return The conversationCountTimeSeries.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
      getConversationCountTimeSeries() {
    return conversationCountTimeSeries_ == null
        ? com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
            .getDefaultInstance()
        : conversationCountTimeSeries_;
  }
  /**
   *
   *
   * <pre>
   * A time series representing the count of conversations created over time
   * that match that requested filter criteria.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeriesOrBuilder
      getConversationCountTimeSeriesOrBuilder() {
    return conversationCountTimeSeries_ == null
        ? com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
            .getDefaultInstance()
        : conversationCountTimeSeries_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (averageDuration_ != null) {
      output.writeMessage(1, getAverageDuration());
    }
    if (averageTurnCount_ != 0) {
      output.writeInt32(2, averageTurnCount_);
    }
    if (conversationCount_ != 0) {
      output.writeInt32(3, conversationCount_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetSmartHighlighterMatches(),
        SmartHighlighterMatchesDefaultEntryHolder.defaultEntry,
        4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetCustomHighlighterMatches(),
        CustomHighlighterMatchesDefaultEntryHolder.defaultEntry,
        5);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetIssueMatches(), IssueMatchesDefaultEntryHolder.defaultEntry, 6);
    if (conversationCountTimeSeries_ != null) {
      output.writeMessage(7, getConversationCountTimeSeries());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetIssueMatchesStats(),
        IssueMatchesStatsDefaultEntryHolder.defaultEntry,
        8);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (averageDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAverageDuration());
    }
    if (averageTurnCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, averageTurnCount_);
    }
    if (conversationCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, conversationCount_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetSmartHighlighterMatches().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> smartHighlighterMatches__ =
          SmartHighlighterMatchesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, smartHighlighterMatches__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetCustomHighlighterMatches().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> customHighlighterMatches__ =
          CustomHighlighterMatchesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, customHighlighterMatches__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetIssueMatches().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> issueMatches__ =
          IssueMatchesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, issueMatches__);
    }
    if (conversationCountTimeSeries_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, getConversationCountTimeSeries());
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        entry : internalGetIssueMatchesStats().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          issueMatchesStats__ =
              IssueMatchesStatsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, issueMatchesStats__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse other =
        (com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse) obj;

    if (hasAverageDuration() != other.hasAverageDuration()) return false;
    if (hasAverageDuration()) {
      if (!getAverageDuration().equals(other.getAverageDuration())) return false;
    }
    if (getAverageTurnCount() != other.getAverageTurnCount()) return false;
    if (getConversationCount() != other.getConversationCount()) return false;
    if (!internalGetSmartHighlighterMatches().equals(other.internalGetSmartHighlighterMatches()))
      return false;
    if (!internalGetCustomHighlighterMatches().equals(other.internalGetCustomHighlighterMatches()))
      return false;
    if (!internalGetIssueMatches().equals(other.internalGetIssueMatches())) return false;
    if (!internalGetIssueMatchesStats().equals(other.internalGetIssueMatchesStats())) return false;
    if (hasConversationCountTimeSeries() != other.hasConversationCountTimeSeries()) return false;
    if (hasConversationCountTimeSeries()) {
      if (!getConversationCountTimeSeries().equals(other.getConversationCountTimeSeries()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAverageDuration()) {
      hash = (37 * hash) + AVERAGE_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getAverageDuration().hashCode();
    }
    hash = (37 * hash) + AVERAGE_TURN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getAverageTurnCount();
    hash = (37 * hash) + CONVERSATION_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getConversationCount();
    if (!internalGetSmartHighlighterMatches().getMap().isEmpty()) {
      hash = (37 * hash) + SMART_HIGHLIGHTER_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetSmartHighlighterMatches().hashCode();
    }
    if (!internalGetCustomHighlighterMatches().getMap().isEmpty()) {
      hash = (37 * hash) + CUSTOM_HIGHLIGHTER_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCustomHighlighterMatches().hashCode();
    }
    if (!internalGetIssueMatches().getMap().isEmpty()) {
      hash = (37 * hash) + ISSUE_MATCHES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetIssueMatches().hashCode();
    }
    if (!internalGetIssueMatchesStats().getMap().isEmpty()) {
      hash = (37 * hash) + ISSUE_MATCHES_STATS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetIssueMatchesStats().hashCode();
    }
    if (hasConversationCountTimeSeries()) {
      hash = (37 * hash) + CONVERSATION_COUNT_TIME_SERIES_FIELD_NUMBER;
      hash = (53 * hash) + getConversationCountTimeSeries().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for calculating conversation statistics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.CalculateStatsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.CalculateStatsResponse)
      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetSmartHighlighterMatches();
        case 5:
          return internalGetCustomHighlighterMatches();
        case 6:
          return internalGetIssueMatches();
        case 8:
          return internalGetIssueMatchesStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableSmartHighlighterMatches();
        case 5:
          return internalGetMutableCustomHighlighterMatches();
        case 6:
          return internalGetMutableIssueMatches();
        case 8:
          return internalGetMutableIssueMatchesStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.class,
              com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      averageDuration_ = null;
      if (averageDurationBuilder_ != null) {
        averageDurationBuilder_.dispose();
        averageDurationBuilder_ = null;
      }
      averageTurnCount_ = 0;
      conversationCount_ = 0;
      internalGetMutableSmartHighlighterMatches().clear();
      internalGetMutableCustomHighlighterMatches().clear();
      internalGetMutableIssueMatches().clear();
      internalGetMutableIssueMatchesStats().clear();
      conversationCountTimeSeries_ = null;
      if (conversationCountTimeSeriesBuilder_ != null) {
        conversationCountTimeSeriesBuilder_.dispose();
        conversationCountTimeSeriesBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_CalculateStatsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse build() {
      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse buildPartial() {
      com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse result =
          new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.averageDuration_ =
            averageDurationBuilder_ == null ? averageDuration_ : averageDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.averageTurnCount_ = averageTurnCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conversationCount_ = conversationCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.smartHighlighterMatches_ = internalGetSmartHighlighterMatches();
        result.smartHighlighterMatches_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.customHighlighterMatches_ = internalGetCustomHighlighterMatches();
        result.customHighlighterMatches_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.issueMatches_ = internalGetIssueMatches();
        result.issueMatches_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.issueMatchesStats_ = internalGetIssueMatchesStats();
        result.issueMatchesStats_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.conversationCountTimeSeries_ =
            conversationCountTimeSeriesBuilder_ == null
                ? conversationCountTimeSeries_
                : conversationCountTimeSeriesBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.getDefaultInstance())
        return this;
      if (other.hasAverageDuration()) {
        mergeAverageDuration(other.getAverageDuration());
      }
      if (other.getAverageTurnCount() != 0) {
        setAverageTurnCount(other.getAverageTurnCount());
      }
      if (other.getConversationCount() != 0) {
        setConversationCount(other.getConversationCount());
      }
      internalGetMutableSmartHighlighterMatches()
          .mergeFrom(other.internalGetSmartHighlighterMatches());
      bitField0_ |= 0x00000008;
      internalGetMutableCustomHighlighterMatches()
          .mergeFrom(other.internalGetCustomHighlighterMatches());
      bitField0_ |= 0x00000010;
      internalGetMutableIssueMatches().mergeFrom(other.internalGetIssueMatches());
      bitField0_ |= 0x00000020;
      internalGetMutableIssueMatchesStats().mergeFrom(other.internalGetIssueMatchesStats());
      bitField0_ |= 0x00000040;
      if (other.hasConversationCountTimeSeries()) {
        mergeConversationCountTimeSeries(other.getConversationCountTimeSeries());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAverageDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                averageTurnCount_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                conversationCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer>
                    smartHighlighterMatches__ =
                        input.readMessage(
                            SmartHighlighterMatchesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableSmartHighlighterMatches()
                    .getMutableMap()
                    .put(smartHighlighterMatches__.getKey(), smartHighlighterMatches__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer>
                    customHighlighterMatches__ =
                        input.readMessage(
                            CustomHighlighterMatchesDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableCustomHighlighterMatches()
                    .getMutableMap()
                    .put(
                        customHighlighterMatches__.getKey(), customHighlighterMatches__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> issueMatches__ =
                    input.readMessage(
                        IssueMatchesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableIssueMatches()
                    .getMutableMap()
                    .put(issueMatches__.getKey(), issueMatches__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getConversationCountTimeSeriesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
                    issueMatchesStats__ =
                        input.readMessage(
                            IssueMatchesStatsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableIssueMatchesStats()
                    .getMutableMap()
                    .put(issueMatchesStats__.getKey(), issueMatchesStats__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration averageDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        averageDurationBuilder_;
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     *
     * @return Whether the averageDuration field is set.
     */
    public boolean hasAverageDuration() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     *
     * @return The averageDuration.
     */
    public com.google.protobuf.Duration getAverageDuration() {
      if (averageDurationBuilder_ == null) {
        return averageDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : averageDuration_;
      } else {
        return averageDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public Builder setAverageDuration(com.google.protobuf.Duration value) {
      if (averageDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        averageDuration_ = value;
      } else {
        averageDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public Builder setAverageDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (averageDurationBuilder_ == null) {
        averageDuration_ = builderForValue.build();
      } else {
        averageDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public Builder mergeAverageDuration(com.google.protobuf.Duration value) {
      if (averageDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && averageDuration_ != null
            && averageDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getAverageDurationBuilder().mergeFrom(value);
        } else {
          averageDuration_ = value;
        }
      } else {
        averageDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public Builder clearAverageDuration() {
      bitField0_ = (bitField0_ & ~0x00000001);
      averageDuration_ = null;
      if (averageDurationBuilder_ != null) {
        averageDurationBuilder_.dispose();
        averageDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getAverageDurationBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAverageDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getAverageDurationOrBuilder() {
      if (averageDurationBuilder_ != null) {
        return averageDurationBuilder_.getMessageOrBuilder();
      } else {
        return averageDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : averageDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * The average duration of all conversations. The average is calculated using
     * only conversations that have a time duration.
     * </pre>
     *
     * <code>.google.protobuf.Duration average_duration = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getAverageDurationFieldBuilder() {
      if (averageDurationBuilder_ == null) {
        averageDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getAverageDuration(), getParentForChildren(), isClean());
        averageDuration_ = null;
      }
      return averageDurationBuilder_;
    }

    private int averageTurnCount_;
    /**
     *
     *
     * <pre>
     * The average number of turns per conversation.
     * </pre>
     *
     * <code>int32 average_turn_count = 2;</code>
     *
     * @return The averageTurnCount.
     */
    @java.lang.Override
    public int getAverageTurnCount() {
      return averageTurnCount_;
    }
    /**
     *
     *
     * <pre>
     * The average number of turns per conversation.
     * </pre>
     *
     * <code>int32 average_turn_count = 2;</code>
     *
     * @param value The averageTurnCount to set.
     * @return This builder for chaining.
     */
    public Builder setAverageTurnCount(int value) {

      averageTurnCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The average number of turns per conversation.
     * </pre>
     *
     * <code>int32 average_turn_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAverageTurnCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      averageTurnCount_ = 0;
      onChanged();
      return this;
    }

    private int conversationCount_;
    /**
     *
     *
     * <pre>
     * The total number of conversations.
     * </pre>
     *
     * <code>int32 conversation_count = 3;</code>
     *
     * @return The conversationCount.
     */
    @java.lang.Override
    public int getConversationCount() {
      return conversationCount_;
    }
    /**
     *
     *
     * <pre>
     * The total number of conversations.
     * </pre>
     *
     * <code>int32 conversation_count = 3;</code>
     *
     * @param value The conversationCount to set.
     * @return This builder for chaining.
     */
    public Builder setConversationCount(int value) {

      conversationCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The total number of conversations.
     * </pre>
     *
     * <code>int32 conversation_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      conversationCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        smartHighlighterMatches_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetSmartHighlighterMatches() {
      if (smartHighlighterMatches_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            SmartHighlighterMatchesDefaultEntryHolder.defaultEntry);
      }
      return smartHighlighterMatches_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableSmartHighlighterMatches() {
      if (smartHighlighterMatches_ == null) {
        smartHighlighterMatches_ =
            com.google.protobuf.MapField.newMapField(
                SmartHighlighterMatchesDefaultEntryHolder.defaultEntry);
      }
      if (!smartHighlighterMatches_.isMutable()) {
        smartHighlighterMatches_ = smartHighlighterMatches_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return smartHighlighterMatches_;
    }

    public int getSmartHighlighterMatchesCount() {
      return internalGetSmartHighlighterMatches().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    @java.lang.Override
    public boolean containsSmartHighlighterMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetSmartHighlighterMatches().getMap().containsKey(key);
    }
    /** Use {@link #getSmartHighlighterMatchesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getSmartHighlighterMatches() {
      return getSmartHighlighterMatchesMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getSmartHighlighterMatchesMap() {
      return internalGetSmartHighlighterMatches().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    @java.lang.Override
    public int getSmartHighlighterMatchesOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSmartHighlighterMatches().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    @java.lang.Override
    public int getSmartHighlighterMatchesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetSmartHighlighterMatches().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearSmartHighlighterMatches() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableSmartHighlighterMatches().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    public Builder removeSmartHighlighterMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableSmartHighlighterMatches().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableSmartHighlighterMatches() {
      bitField0_ |= 0x00000008;
      return internalGetMutableSmartHighlighterMatches().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    public Builder putSmartHighlighterMatches(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableSmartHighlighterMatches().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each smart highlighter display name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; smart_highlighter_matches = 4;</code>
     */
    public Builder putAllSmartHighlighterMatches(
        java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableSmartHighlighterMatches().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        customHighlighterMatches_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetCustomHighlighterMatches() {
      if (customHighlighterMatches_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            CustomHighlighterMatchesDefaultEntryHolder.defaultEntry);
      }
      return customHighlighterMatches_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableCustomHighlighterMatches() {
      if (customHighlighterMatches_ == null) {
        customHighlighterMatches_ =
            com.google.protobuf.MapField.newMapField(
                CustomHighlighterMatchesDefaultEntryHolder.defaultEntry);
      }
      if (!customHighlighterMatches_.isMutable()) {
        customHighlighterMatches_ = customHighlighterMatches_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return customHighlighterMatches_;
    }

    public int getCustomHighlighterMatchesCount() {
      return internalGetCustomHighlighterMatches().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    @java.lang.Override
    public boolean containsCustomHighlighterMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCustomHighlighterMatches().getMap().containsKey(key);
    }
    /** Use {@link #getCustomHighlighterMatchesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getCustomHighlighterMatches() {
      return getCustomHighlighterMatchesMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getCustomHighlighterMatchesMap() {
      return internalGetCustomHighlighterMatches().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    @java.lang.Override
    public int getCustomHighlighterMatchesOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetCustomHighlighterMatches().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    @java.lang.Override
    public int getCustomHighlighterMatchesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map =
          internalGetCustomHighlighterMatches().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearCustomHighlighterMatches() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableCustomHighlighterMatches().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    public Builder removeCustomHighlighterMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCustomHighlighterMatches().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableCustomHighlighterMatches() {
      bitField0_ |= 0x00000010;
      return internalGetMutableCustomHighlighterMatches().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    public Builder putCustomHighlighterMatches(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableCustomHighlighterMatches().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each custom highlighter resource name with its respective
     * number of matches in the set of conversations.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; custom_highlighter_matches = 5;</code>
     */
    public Builder putAllCustomHighlighterMatches(
        java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableCustomHighlighterMatches().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> issueMatches_;

    @java.lang.Deprecated
    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetIssueMatches() {
      if (issueMatches_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            IssueMatchesDefaultEntryHolder.defaultEntry);
      }
      return issueMatches_;
    }

    @java.lang.Deprecated
    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableIssueMatches() {
      if (issueMatches_ == null) {
        issueMatches_ =
            com.google.protobuf.MapField.newMapField(IssueMatchesDefaultEntryHolder.defaultEntry);
      }
      if (!issueMatches_.isMutable()) {
        issueMatches_ = issueMatches_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return issueMatches_;
    }

    @java.lang.Deprecated
    public int getIssueMatchesCount() {
      return internalGetIssueMatches().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean containsIssueMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIssueMatches().getMap().containsKey(key);
    }
    /** Use {@link #getIssueMatchesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getIssueMatches() {
      return getIssueMatchesMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getIssueMatchesMap() {
      return internalGetIssueMatches().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getIssueMatchesOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetIssueMatches().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getIssueMatchesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetIssueMatches().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    @java.lang.Deprecated
    public Builder clearIssueMatches() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableIssueMatches().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder removeIssueMatches(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableIssueMatches().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableIssueMatches() {
      bitField0_ |= 0x00000020;
      return internalGetMutableIssueMatches().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putIssueMatches(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableIssueMatches().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * Deprecated, use `issue_matches_stats` field instead.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; issue_matches = 6 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    public Builder putAllIssueMatches(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableIssueMatches().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        issueMatchesStats_;

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        internalGetIssueMatchesStats() {
      if (issueMatchesStats_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            IssueMatchesStatsDefaultEntryHolder.defaultEntry);
      }
      return issueMatchesStats_;
    }

    private com.google.protobuf.MapField<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        internalGetMutableIssueMatchesStats() {
      if (issueMatchesStats_ == null) {
        issueMatchesStats_ =
            com.google.protobuf.MapField.newMapField(
                IssueMatchesStatsDefaultEntryHolder.defaultEntry);
      }
      if (!issueMatchesStats_.isMutable()) {
        issueMatchesStats_ = issueMatchesStats_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return issueMatchesStats_;
    }

    public int getIssueMatchesStatsCount() {
      return internalGetIssueMatchesStats().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    @java.lang.Override
    public boolean containsIssueMatchesStats(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIssueMatchesStats().getMap().containsKey(key);
    }
    /** Use {@link #getIssueMatchesStatsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getIssueMatchesStats() {
      return getIssueMatchesStatsMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getIssueMatchesStatsMap() {
      return internalGetIssueMatchesStats().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getIssueMatchesStatsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          map = internalGetIssueMatchesStats().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getIssueMatchesStatsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          map = internalGetIssueMatchesStats().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearIssueMatchesStats() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableIssueMatchesStats().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    public Builder removeIssueMatchesStats(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableIssueMatchesStats().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getMutableIssueMatchesStats() {
      bitField0_ |= 0x00000040;
      return internalGetMutableIssueMatchesStats().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    public Builder putIssueMatchesStats(
        java.lang.String key,
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableIssueMatchesStats().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map associating each issue resource name with its respective number of
     * matches in the set of conversations. Key has the format:
     * `projects/&lt;Project-ID&gt;/locations/&lt;Location-ID&gt;/issueModels/&lt;Issue-Model-ID&gt;/issues/&lt;Issue-ID&gt;`
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_matches_stats = 8;
     * </code>
     */
    public Builder putAllIssueMatchesStats(
        java.util.Map<
                java.lang.String,
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
            values) {
      internalGetMutableIssueMatchesStats().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        conversationCountTimeSeries_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries,
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder,
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeriesOrBuilder>
        conversationCountTimeSeriesBuilder_;
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     *
     * @return Whether the conversationCountTimeSeries field is set.
     */
    public boolean hasConversationCountTimeSeries() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     *
     * @return The conversationCountTimeSeries.
     */
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
        getConversationCountTimeSeries() {
      if (conversationCountTimeSeriesBuilder_ == null) {
        return conversationCountTimeSeries_ == null
            ? com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                .getDefaultInstance()
            : conversationCountTimeSeries_;
      } else {
        return conversationCountTimeSeriesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public Builder setConversationCountTimeSeries(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries value) {
      if (conversationCountTimeSeriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationCountTimeSeries_ = value;
      } else {
        conversationCountTimeSeriesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public Builder setConversationCountTimeSeries(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder
            builderForValue) {
      if (conversationCountTimeSeriesBuilder_ == null) {
        conversationCountTimeSeries_ = builderForValue.build();
      } else {
        conversationCountTimeSeriesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public Builder mergeConversationCountTimeSeries(
        com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries value) {
      if (conversationCountTimeSeriesBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && conversationCountTimeSeries_ != null
            && conversationCountTimeSeries_
                != com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                    .getDefaultInstance()) {
          getConversationCountTimeSeriesBuilder().mergeFrom(value);
        } else {
          conversationCountTimeSeries_ = value;
        }
      } else {
        conversationCountTimeSeriesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public Builder clearConversationCountTimeSeries() {
      bitField0_ = (bitField0_ & ~0x00000080);
      conversationCountTimeSeries_ = null;
      if (conversationCountTimeSeriesBuilder_ != null) {
        conversationCountTimeSeriesBuilder_.dispose();
        conversationCountTimeSeriesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder
        getConversationCountTimeSeriesBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getConversationCountTimeSeriesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeriesOrBuilder
        getConversationCountTimeSeriesOrBuilder() {
      if (conversationCountTimeSeriesBuilder_ != null) {
        return conversationCountTimeSeriesBuilder_.getMessageOrBuilder();
      } else {
        return conversationCountTimeSeries_ == null
            ? com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries
                .getDefaultInstance()
            : conversationCountTimeSeries_;
      }
    }
    /**
     *
     *
     * <pre>
     * A time series representing the count of conversations created over time
     * that match that requested filter criteria.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries conversation_count_time_series = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries,
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder,
            com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeriesOrBuilder>
        getConversationCountTimeSeriesFieldBuilder() {
      if (conversationCountTimeSeriesBuilder_ == null) {
        conversationCountTimeSeriesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries,
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse.TimeSeries.Builder,
                com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
                    .TimeSeriesOrBuilder>(
                getConversationCountTimeSeries(), getParentForChildren(), isClean());
        conversationCountTimeSeries_ = null;
      }
      return conversationCountTimeSeriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.CalculateStatsResponse)
  private static final com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse();
  }

  public static com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CalculateStatsResponse> PARSER =
      new com.google.protobuf.AbstractParser<CalculateStatsResponse>() {
        @java.lang.Override
        public CalculateStatsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CalculateStatsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CalculateStatsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.CalculateStatsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
