/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The conversation resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation}
 */
public final class Conversation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation)
    ConversationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Conversation.newBuilder() to construct.
  private Conversation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Conversation() {
    name_ = "";
    languageCode_ = "";
    agentId_ = "";
    medium_ = 0;
    runtimeAnnotations_ = java.util.Collections.emptyList();
    obfuscatedUserId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Conversation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Conversation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      case 18:
        return internalGetDialogflowIntents();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Conversation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.Conversation.class,
            com.google.cloud.contactcenterinsights.v1.Conversation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible media for the conversation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.Conversation.Medium}
   */
  public enum Medium implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value, if unspecified will default to PHONE_CALL.
     * </pre>
     *
     * <code>MEDIUM_UNSPECIFIED = 0;</code>
     */
    MEDIUM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The format for conversations that took place over the phone.
     * </pre>
     *
     * <code>PHONE_CALL = 1;</code>
     */
    PHONE_CALL(1),
    /**
     *
     *
     * <pre>
     * The format for conversations that took place over chat.
     * </pre>
     *
     * <code>CHAT = 2;</code>
     */
    CHAT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value, if unspecified will default to PHONE_CALL.
     * </pre>
     *
     * <code>MEDIUM_UNSPECIFIED = 0;</code>
     */
    public static final int MEDIUM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The format for conversations that took place over the phone.
     * </pre>
     *
     * <code>PHONE_CALL = 1;</code>
     */
    public static final int PHONE_CALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The format for conversations that took place over chat.
     * </pre>
     *
     * <code>CHAT = 2;</code>
     */
    public static final int CHAT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Medium valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Medium forNumber(int value) {
      switch (value) {
        case 0:
          return MEDIUM_UNSPECIFIED;
        case 1:
          return PHONE_CALL;
        case 2:
          return CHAT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Medium> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Medium> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Medium>() {
          public Medium findValueByNumber(int number) {
            return Medium.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.Conversation.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Medium[] VALUES = values();

    public static Medium valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Medium(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.Conversation.Medium)
  }

  public interface CallMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The audio channel that contains the customer.
     * </pre>
     *
     * <code>int32 customer_channel = 1;</code>
     *
     * @return The customerChannel.
     */
    int getCustomerChannel();

    /**
     *
     *
     * <pre>
     * The audio channel that contains the agent.
     * </pre>
     *
     * <code>int32 agent_channel = 2;</code>
     *
     * @return The agentChannel.
     */
    int getAgentChannel();
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation.CallMetadata}
   */
  public static final class CallMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
      CallMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CallMetadata.newBuilder() to construct.
    private CallMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CallMetadata() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CallMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_CallMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_CallMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.class,
              com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder.class);
    }

    public static final int CUSTOMER_CHANNEL_FIELD_NUMBER = 1;
    private int customerChannel_ = 0;
    /**
     *
     *
     * <pre>
     * The audio channel that contains the customer.
     * </pre>
     *
     * <code>int32 customer_channel = 1;</code>
     *
     * @return The customerChannel.
     */
    @java.lang.Override
    public int getCustomerChannel() {
      return customerChannel_;
    }

    public static final int AGENT_CHANNEL_FIELD_NUMBER = 2;
    private int agentChannel_ = 0;
    /**
     *
     *
     * <pre>
     * The audio channel that contains the agent.
     * </pre>
     *
     * <code>int32 agent_channel = 2;</code>
     *
     * @return The agentChannel.
     */
    @java.lang.Override
    public int getAgentChannel() {
      return agentChannel_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (customerChannel_ != 0) {
        output.writeInt32(1, customerChannel_);
      }
      if (agentChannel_ != 0) {
        output.writeInt32(2, agentChannel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (customerChannel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, customerChannel_);
      }
      if (agentChannel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, agentChannel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata other =
          (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) obj;

      if (getCustomerChannel() != other.getCustomerChannel()) return false;
      if (getAgentChannel() != other.getAgentChannel()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CUSTOMER_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerChannel();
      hash = (37 * hash) + AGENT_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getAgentChannel();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation.CallMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_CallMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_CallMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.class,
                com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        customerChannel_ = 0;
        agentChannel_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_CallMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata build() {
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata result =
            new com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.customerChannel_ = customerChannel_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.agentChannel_ = agentChannel_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
                .getDefaultInstance()) return this;
        if (other.getCustomerChannel() != 0) {
          setCustomerChannel(other.getCustomerChannel());
        }
        if (other.getAgentChannel() != 0) {
          setAgentChannel(other.getAgentChannel());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  customerChannel_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  agentChannel_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int customerChannel_;
      /**
       *
       *
       * <pre>
       * The audio channel that contains the customer.
       * </pre>
       *
       * <code>int32 customer_channel = 1;</code>
       *
       * @return The customerChannel.
       */
      @java.lang.Override
      public int getCustomerChannel() {
        return customerChannel_;
      }
      /**
       *
       *
       * <pre>
       * The audio channel that contains the customer.
       * </pre>
       *
       * <code>int32 customer_channel = 1;</code>
       *
       * @param value The customerChannel to set.
       * @return This builder for chaining.
       */
      public Builder setCustomerChannel(int value) {

        customerChannel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The audio channel that contains the customer.
       * </pre>
       *
       * <code>int32 customer_channel = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomerChannel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        customerChannel_ = 0;
        onChanged();
        return this;
      }

      private int agentChannel_;
      /**
       *
       *
       * <pre>
       * The audio channel that contains the agent.
       * </pre>
       *
       * <code>int32 agent_channel = 2;</code>
       *
       * @return The agentChannel.
       */
      @java.lang.Override
      public int getAgentChannel() {
        return agentChannel_;
      }
      /**
       *
       *
       * <pre>
       * The audio channel that contains the agent.
       * </pre>
       *
       * <code>int32 agent_channel = 2;</code>
       *
       * @param value The agentChannel to set.
       * @return This builder for chaining.
       */
      public Builder setAgentChannel(int value) {

        agentChannel_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The audio channel that contains the agent.
       * </pre>
       *
       * <code>int32 agent_channel = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentChannel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        agentChannel_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CallMetadata> PARSER =
        new com.google.protobuf.AbstractParser<CallMetadata>() {
          @java.lang.Override
          public CallMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CallMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CallMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TranscriptOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Conversation.Transcript)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment>
        getTranscriptSegmentsList();
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
        getTranscriptSegments(int index);
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    int getTranscriptSegmentsCount();
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegmentOrBuilder>
        getTranscriptSegmentsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegmentOrBuilder
        getTranscriptSegmentsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A message representing the transcript of a conversation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation.Transcript}
   */
  public static final class Transcript extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript)
      TranscriptOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Transcript.newBuilder() to construct.
    private Transcript(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Transcript() {
      transcriptSegments_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Transcript();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.class,
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder.class);
    }

    public interface TranscriptSegmentOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       *
       * @return Whether the messageTime field is set.
       */
      boolean hasMessageTime();
      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       *
       * @return The messageTime.
       */
      com.google.protobuf.Timestamp getMessageTime();
      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       */
      com.google.protobuf.TimestampOrBuilder getMessageTimeOrBuilder();

      /**
       *
       *
       * <pre>
       * The text of this segment.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      java.lang.String getText();
      /**
       *
       *
       * <pre>
       * The text of this segment.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      com.google.protobuf.ByteString getTextBytes();

      /**
       *
       *
       * <pre>
       * A confidence estimate between 0.0 and 1.0 of the fidelity of this
       * segment. A default value of 0.0 indicates that the value is unset.
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      float getConfidence();

      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo>
          getWordsList();
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo
          getWords(int index);
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      int getWordsCount();
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfoOrBuilder>
          getWordsOrBuilderList();
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .WordInfoOrBuilder
          getWordsOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * The language code of this segment as a
       * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
       * Example: "en-US".
       * </pre>
       *
       * <code>string language_code = 4;</code>
       *
       * @return The languageCode.
       */
      java.lang.String getLanguageCode();
      /**
       *
       *
       * <pre>
       * The language code of this segment as a
       * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
       * Example: "en-US".
       * </pre>
       *
       * <code>string language_code = 4;</code>
       *
       * @return The bytes for languageCode.
       */
      com.google.protobuf.ByteString getLanguageCodeBytes();

      /**
       *
       *
       * <pre>
       * For conversations derived from multi-channel audio, this is the channel
       * number corresponding to the audio from that channel. For
       * audioChannelCount = N, its output values can range from '1' to 'N'. A
       * channel tag of 0 indicates that the audio is mono.
       * </pre>
       *
       * <code>int32 channel_tag = 5;</code>
       *
       * @return The channelTag.
       */
      int getChannelTag();

      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       *
       * @return Whether the segmentParticipant field is set.
       */
      boolean hasSegmentParticipant();
      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       *
       * @return The segmentParticipant.
       */
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant getSegmentParticipant();
      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder
          getSegmentParticipantOrBuilder();

      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       *
       * @return Whether the dialogflowSegmentMetadata field is set.
       */
      boolean hasDialogflowSegmentMetadata();
      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       *
       * @return The dialogflowSegmentMetadata.
       */
      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .DialogflowSegmentMetadata
          getDialogflowSegmentMetadata();
      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .DialogflowSegmentMetadataOrBuilder
          getDialogflowSegmentMetadataOrBuilder();

      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       *
       * @return Whether the sentiment field is set.
       */
      boolean hasSentiment();
      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       *
       * @return The sentiment.
       */
      com.google.cloud.contactcenterinsights.v1.SentimentData getSentiment();
      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       */
      com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder getSentimentOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * A segment of a full transcript.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment}
     */
    public static final class TranscriptSegment extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
        TranscriptSegmentOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TranscriptSegment.newBuilder() to construct.
      private TranscriptSegment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TranscriptSegment() {
        text_ = "";
        words_ = java.util.Collections.emptyList();
        languageCode_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TranscriptSegment();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .class,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .Builder.class);
      }

      public interface WordInfoOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         *
         * @return Whether the startOffset field is set.
         */
        boolean hasStartOffset();
        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         *
         * @return The startOffset.
         */
        com.google.protobuf.Duration getStartOffset();
        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         */
        com.google.protobuf.DurationOrBuilder getStartOffsetOrBuilder();

        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         *
         * @return Whether the endOffset field is set.
         */
        boolean hasEndOffset();
        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         *
         * @return The endOffset.
         */
        com.google.protobuf.Duration getEndOffset();
        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         */
        com.google.protobuf.DurationOrBuilder getEndOffsetOrBuilder();

        /**
         *
         *
         * <pre>
         * The word itself. Includes punctuation marks that surround the word.
         * </pre>
         *
         * <code>string word = 3;</code>
         *
         * @return The word.
         */
        java.lang.String getWord();
        /**
         *
         *
         * <pre>
         * The word itself. Includes punctuation marks that surround the word.
         * </pre>
         *
         * <code>string word = 3;</code>
         *
         * @return The bytes for word.
         */
        com.google.protobuf.ByteString getWordBytes();

        /**
         *
         *
         * <pre>
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this
         * word. A default value of 0.0 indicates that the value is unset.
         * </pre>
         *
         * <code>float confidence = 4;</code>
         *
         * @return The confidence.
         */
        float getConfidence();
      }
      /**
       *
       *
       * <pre>
       * Word-level info for words in a transcript.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo}
       */
      public static final class WordInfo extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo)
          WordInfoOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use WordInfo.newBuilder() to construct.
        private WordInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private WordInfo() {
          word_ = "";
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new WordInfo();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_WordInfo_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_WordInfo_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfo.class,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfo.Builder.class);
        }

        public static final int START_OFFSET_FIELD_NUMBER = 1;
        private com.google.protobuf.Duration startOffset_;
        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         *
         * @return Whether the startOffset field is set.
         */
        @java.lang.Override
        public boolean hasStartOffset() {
          return startOffset_ != null;
        }
        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         *
         * @return The startOffset.
         */
        @java.lang.Override
        public com.google.protobuf.Duration getStartOffset() {
          return startOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startOffset_;
        }
        /**
         *
         *
         * <pre>
         * Time offset of the start of this word relative to the beginning of
         * the total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration start_offset = 1;</code>
         */
        @java.lang.Override
        public com.google.protobuf.DurationOrBuilder getStartOffsetOrBuilder() {
          return startOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : startOffset_;
        }

        public static final int END_OFFSET_FIELD_NUMBER = 2;
        private com.google.protobuf.Duration endOffset_;
        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         *
         * @return Whether the endOffset field is set.
         */
        @java.lang.Override
        public boolean hasEndOffset() {
          return endOffset_ != null;
        }
        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         *
         * @return The endOffset.
         */
        @java.lang.Override
        public com.google.protobuf.Duration getEndOffset() {
          return endOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endOffset_;
        }
        /**
         *
         *
         * <pre>
         * Time offset of the end of this word relative to the beginning of the
         * total conversation.
         * </pre>
         *
         * <code>.google.protobuf.Duration end_offset = 2;</code>
         */
        @java.lang.Override
        public com.google.protobuf.DurationOrBuilder getEndOffsetOrBuilder() {
          return endOffset_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : endOffset_;
        }

        public static final int WORD_FIELD_NUMBER = 3;

        @SuppressWarnings("serial")
        private volatile java.lang.Object word_ = "";
        /**
         *
         *
         * <pre>
         * The word itself. Includes punctuation marks that surround the word.
         * </pre>
         *
         * <code>string word = 3;</code>
         *
         * @return The word.
         */
        @java.lang.Override
        public java.lang.String getWord() {
          java.lang.Object ref = word_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            word_ = s;
            return s;
          }
        }
        /**
         *
         *
         * <pre>
         * The word itself. Includes punctuation marks that surround the word.
         * </pre>
         *
         * <code>string word = 3;</code>
         *
         * @return The bytes for word.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getWordBytes() {
          java.lang.Object ref = word_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            word_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        public static final int CONFIDENCE_FIELD_NUMBER = 4;
        private float confidence_ = 0F;
        /**
         *
         *
         * <pre>
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this
         * word. A default value of 0.0 indicates that the value is unset.
         * </pre>
         *
         * <code>float confidence = 4;</code>
         *
         * @return The confidence.
         */
        @java.lang.Override
        public float getConfidence() {
          return confidence_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (startOffset_ != null) {
            output.writeMessage(1, getStartOffset());
          }
          if (endOffset_ != null) {
            output.writeMessage(2, getEndOffset());
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(word_)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 3, word_);
          }
          if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
            output.writeFloat(4, confidence_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (startOffset_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartOffset());
          }
          if (endOffset_ != null) {
            size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndOffset());
          }
          if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(word_)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, word_);
          }
          if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, confidence_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo)) {
            return super.equals(obj);
          }
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo
              other =
                  (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment.WordInfo)
                      obj;

          if (hasStartOffset() != other.hasStartOffset()) return false;
          if (hasStartOffset()) {
            if (!getStartOffset().equals(other.getStartOffset())) return false;
          }
          if (hasEndOffset() != other.hasEndOffset()) return false;
          if (hasEndOffset()) {
            if (!getEndOffset().equals(other.getEndOffset())) return false;
          }
          if (!getWord().equals(other.getWord())) return false;
          if (java.lang.Float.floatToIntBits(getConfidence())
              != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasStartOffset()) {
            hash = (37 * hash) + START_OFFSET_FIELD_NUMBER;
            hash = (53 * hash) + getStartOffset().hashCode();
          }
          if (hasEndOffset()) {
            hash = (37 * hash) + END_OFFSET_FIELD_NUMBER;
            hash = (53 * hash) + getEndOffset().hashCode();
          }
          hash = (37 * hash) + WORD_FIELD_NUMBER;
          hash = (53 * hash) + getWord().hashCode();
          hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Word-level info for words in a transcript.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo)
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfoOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_WordInfo_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_WordInfo_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo.class,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo.Builder.class);
          }

          // Construct using
          // com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            startOffset_ = null;
            if (startOffsetBuilder_ != null) {
              startOffsetBuilder_.dispose();
              startOffsetBuilder_ = null;
            }
            endOffset_ = null;
            if (endOffsetBuilder_ != null) {
              endOffsetBuilder_.dispose();
              endOffsetBuilder_ = null;
            }
            word_ = "";
            confidence_ = 0F;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_WordInfo_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo
              getDefaultInstanceForType() {
            return com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo
              build() {
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo
              buildPartial() {
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                result =
                    new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                      .WordInfo
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.startOffset_ =
                  startOffsetBuilder_ == null ? startOffset_ : startOffsetBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.endOffset_ =
                  endOffsetBuilder_ == null ? endOffset_ : endOffsetBuilder_.build();
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.word_ = word_;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.confidence_ = confidence_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo) {
              return mergeFrom(
                  (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment.WordInfo)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                      .WordInfo
                  other) {
            if (other
                == com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegment.WordInfo.getDefaultInstance()) return this;
            if (other.hasStartOffset()) {
              mergeStartOffset(other.getStartOffset());
            }
            if (other.hasEndOffset()) {
              mergeEndOffset(other.getEndOffset());
            }
            if (!other.getWord().isEmpty()) {
              word_ = other.word_;
              bitField0_ |= 0x00000004;
              onChanged();
            }
            if (other.getConfidence() != 0F) {
              setConfidence(other.getConfidence());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      input.readMessage(
                          getStartOffsetFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 10
                  case 18:
                    {
                      input.readMessage(getEndOffsetFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 18
                  case 26:
                    {
                      word_ = input.readStringRequireUtf8();
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 37:
                    {
                      confidence_ = input.readFloat();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 37
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Duration startOffset_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              startOffsetBuilder_;
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           *
           * @return Whether the startOffset field is set.
           */
          public boolean hasStartOffset() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           *
           * @return The startOffset.
           */
          public com.google.protobuf.Duration getStartOffset() {
            if (startOffsetBuilder_ == null) {
              return startOffset_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : startOffset_;
            } else {
              return startOffsetBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public Builder setStartOffset(com.google.protobuf.Duration value) {
            if (startOffsetBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              startOffset_ = value;
            } else {
              startOffsetBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public Builder setStartOffset(com.google.protobuf.Duration.Builder builderForValue) {
            if (startOffsetBuilder_ == null) {
              startOffset_ = builderForValue.build();
            } else {
              startOffsetBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public Builder mergeStartOffset(com.google.protobuf.Duration value) {
            if (startOffsetBuilder_ == null) {
              if (((bitField0_ & 0x00000001) != 0)
                  && startOffset_ != null
                  && startOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
                getStartOffsetBuilder().mergeFrom(value);
              } else {
                startOffset_ = value;
              }
            } else {
              startOffsetBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public Builder clearStartOffset() {
            bitField0_ = (bitField0_ & ~0x00000001);
            startOffset_ = null;
            if (startOffsetBuilder_ != null) {
              startOffsetBuilder_.dispose();
              startOffsetBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public com.google.protobuf.Duration.Builder getStartOffsetBuilder() {
            bitField0_ |= 0x00000001;
            onChanged();
            return getStartOffsetFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          public com.google.protobuf.DurationOrBuilder getStartOffsetOrBuilder() {
            if (startOffsetBuilder_ != null) {
              return startOffsetBuilder_.getMessageOrBuilder();
            } else {
              return startOffset_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : startOffset_;
            }
          }
          /**
           *
           *
           * <pre>
           * Time offset of the start of this word relative to the beginning of
           * the total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration start_offset = 1;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              getStartOffsetFieldBuilder() {
            if (startOffsetBuilder_ == null) {
              startOffsetBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Duration,
                      com.google.protobuf.Duration.Builder,
                      com.google.protobuf.DurationOrBuilder>(
                      getStartOffset(), getParentForChildren(), isClean());
              startOffset_ = null;
            }
            return startOffsetBuilder_;
          }

          private com.google.protobuf.Duration endOffset_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              endOffsetBuilder_;
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           *
           * @return Whether the endOffset field is set.
           */
          public boolean hasEndOffset() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           *
           * @return The endOffset.
           */
          public com.google.protobuf.Duration getEndOffset() {
            if (endOffsetBuilder_ == null) {
              return endOffset_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : endOffset_;
            } else {
              return endOffsetBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public Builder setEndOffset(com.google.protobuf.Duration value) {
            if (endOffsetBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              endOffset_ = value;
            } else {
              endOffsetBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public Builder setEndOffset(com.google.protobuf.Duration.Builder builderForValue) {
            if (endOffsetBuilder_ == null) {
              endOffset_ = builderForValue.build();
            } else {
              endOffsetBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public Builder mergeEndOffset(com.google.protobuf.Duration value) {
            if (endOffsetBuilder_ == null) {
              if (((bitField0_ & 0x00000002) != 0)
                  && endOffset_ != null
                  && endOffset_ != com.google.protobuf.Duration.getDefaultInstance()) {
                getEndOffsetBuilder().mergeFrom(value);
              } else {
                endOffset_ = value;
              }
            } else {
              endOffsetBuilder_.mergeFrom(value);
            }
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public Builder clearEndOffset() {
            bitField0_ = (bitField0_ & ~0x00000002);
            endOffset_ = null;
            if (endOffsetBuilder_ != null) {
              endOffsetBuilder_.dispose();
              endOffsetBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public com.google.protobuf.Duration.Builder getEndOffsetBuilder() {
            bitField0_ |= 0x00000002;
            onChanged();
            return getEndOffsetFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          public com.google.protobuf.DurationOrBuilder getEndOffsetOrBuilder() {
            if (endOffsetBuilder_ != null) {
              return endOffsetBuilder_.getMessageOrBuilder();
            } else {
              return endOffset_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : endOffset_;
            }
          }
          /**
           *
           *
           * <pre>
           * Time offset of the end of this word relative to the beginning of the
           * total conversation.
           * </pre>
           *
           * <code>.google.protobuf.Duration end_offset = 2;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              getEndOffsetFieldBuilder() {
            if (endOffsetBuilder_ == null) {
              endOffsetBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Duration,
                      com.google.protobuf.Duration.Builder,
                      com.google.protobuf.DurationOrBuilder>(
                      getEndOffset(), getParentForChildren(), isClean());
              endOffset_ = null;
            }
            return endOffsetBuilder_;
          }

          private java.lang.Object word_ = "";
          /**
           *
           *
           * <pre>
           * The word itself. Includes punctuation marks that surround the word.
           * </pre>
           *
           * <code>string word = 3;</code>
           *
           * @return The word.
           */
          public java.lang.String getWord() {
            java.lang.Object ref = word_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              word_ = s;
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The word itself. Includes punctuation marks that surround the word.
           * </pre>
           *
           * <code>string word = 3;</code>
           *
           * @return The bytes for word.
           */
          public com.google.protobuf.ByteString getWordBytes() {
            java.lang.Object ref = word_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              word_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           *
           *
           * <pre>
           * The word itself. Includes punctuation marks that surround the word.
           * </pre>
           *
           * <code>string word = 3;</code>
           *
           * @param value The word to set.
           * @return This builder for chaining.
           */
          public Builder setWord(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            word_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The word itself. Includes punctuation marks that surround the word.
           * </pre>
           *
           * <code>string word = 3;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearWord() {
            word_ = getDefaultInstance().getWord();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The word itself. Includes punctuation marks that surround the word.
           * </pre>
           *
           * <code>string word = 3;</code>
           *
           * @param value The bytes for word to set.
           * @return This builder for chaining.
           */
          public Builder setWordBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            word_ = value;
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }

          private float confidence_;
          /**
           *
           *
           * <pre>
           * A confidence estimate between 0.0 and 1.0 of the fidelity of this
           * word. A default value of 0.0 indicates that the value is unset.
           * </pre>
           *
           * <code>float confidence = 4;</code>
           *
           * @return The confidence.
           */
          @java.lang.Override
          public float getConfidence() {
            return confidence_;
          }
          /**
           *
           *
           * <pre>
           * A confidence estimate between 0.0 and 1.0 of the fidelity of this
           * word. A default value of 0.0 indicates that the value is unset.
           * </pre>
           *
           * <code>float confidence = 4;</code>
           *
           * @param value The confidence to set.
           * @return This builder for chaining.
           */
          public Builder setConfidence(float value) {

            confidence_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * A confidence estimate between 0.0 and 1.0 of the fidelity of this
           * word. A default value of 0.0 indicates that the value is unset.
           * </pre>
           *
           * <code>float confidence = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearConfidence() {
            bitField0_ = (bitField0_ & ~0x00000008);
            confidence_ = 0F;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo)
        private static final com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                  .TranscriptSegment.WordInfo();
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.WordInfo
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<WordInfo> PARSER =
            new com.google.protobuf.AbstractParser<WordInfo>() {
              @java.lang.Override
              public WordInfo parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<WordInfo> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<WordInfo> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfo
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface DialogflowSegmentMetadataOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Whether the transcript segment was covered under the configured smart
         * reply allowlist in Agent Assist.
         * </pre>
         *
         * <code>bool smart_reply_allowlist_covered = 1;</code>
         *
         * @return The smartReplyAllowlistCovered.
         */
        boolean getSmartReplyAllowlistCovered();
      }
      /**
       *
       *
       * <pre>
       * Metadata from Dialogflow relating to the current transcript segment.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata}
       */
      public static final class DialogflowSegmentMetadata
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata)
          DialogflowSegmentMetadataOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DialogflowSegmentMetadata.newBuilder() to construct.
        private DialogflowSegmentMetadata(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DialogflowSegmentMetadata() {}

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DialogflowSegmentMetadata();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.DialogflowSegmentMetadata.class,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.DialogflowSegmentMetadata.Builder.class);
        }

        public static final int SMART_REPLY_ALLOWLIST_COVERED_FIELD_NUMBER = 1;
        private boolean smartReplyAllowlistCovered_ = false;
        /**
         *
         *
         * <pre>
         * Whether the transcript segment was covered under the configured smart
         * reply allowlist in Agent Assist.
         * </pre>
         *
         * <code>bool smart_reply_allowlist_covered = 1;</code>
         *
         * @return The smartReplyAllowlistCovered.
         */
        @java.lang.Override
        public boolean getSmartReplyAllowlistCovered() {
          return smartReplyAllowlistCovered_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (smartReplyAllowlistCovered_ != false) {
            output.writeBool(1, smartReplyAllowlistCovered_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (smartReplyAllowlistCovered_ != false) {
            size +=
                com.google.protobuf.CodedOutputStream.computeBoolSize(
                    1, smartReplyAllowlistCovered_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .DialogflowSegmentMetadata)) {
            return super.equals(obj);
          }
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .DialogflowSegmentMetadata
              other =
                  (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment.DialogflowSegmentMetadata)
                      obj;

          if (getSmartReplyAllowlistCovered() != other.getSmartReplyAllowlistCovered())
            return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          hash = (37 * hash) + SMART_REPLY_ALLOWLIST_COVERED_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashBoolean(getSmartReplyAllowlistCovered());
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Metadata from Dialogflow relating to the current transcript segment.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata)
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadataOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata.class,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata.Builder.class);
          }

          // Construct using
          // com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            smartReplyAllowlistCovered_ = false;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_DialogflowSegmentMetadata_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .DialogflowSegmentMetadata
              getDefaultInstanceForType() {
            return com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .DialogflowSegmentMetadata
              build() {
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .DialogflowSegmentMetadata
              buildPartial() {
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata
                result =
                    new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                      .DialogflowSegmentMetadata
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.smartReplyAllowlistCovered_ = smartReplyAllowlistCovered_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata) {
              return mergeFrom(
                  (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment.DialogflowSegmentMetadata)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                      .DialogflowSegmentMetadata
                  other) {
            if (other
                == com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegment.DialogflowSegmentMetadata.getDefaultInstance()) return this;
            if (other.getSmartReplyAllowlistCovered() != false) {
              setSmartReplyAllowlistCovered(other.getSmartReplyAllowlistCovered());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      smartReplyAllowlistCovered_ = input.readBool();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private boolean smartReplyAllowlistCovered_;
          /**
           *
           *
           * <pre>
           * Whether the transcript segment was covered under the configured smart
           * reply allowlist in Agent Assist.
           * </pre>
           *
           * <code>bool smart_reply_allowlist_covered = 1;</code>
           *
           * @return The smartReplyAllowlistCovered.
           */
          @java.lang.Override
          public boolean getSmartReplyAllowlistCovered() {
            return smartReplyAllowlistCovered_;
          }
          /**
           *
           *
           * <pre>
           * Whether the transcript segment was covered under the configured smart
           * reply allowlist in Agent Assist.
           * </pre>
           *
           * <code>bool smart_reply_allowlist_covered = 1;</code>
           *
           * @param value The smartReplyAllowlistCovered to set.
           * @return This builder for chaining.
           */
          public Builder setSmartReplyAllowlistCovered(boolean value) {

            smartReplyAllowlistCovered_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Whether the transcript segment was covered under the configured smart
           * reply allowlist in Agent Assist.
           * </pre>
           *
           * <code>bool smart_reply_allowlist_covered = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearSmartReplyAllowlistCovered() {
            bitField0_ = (bitField0_ & ~0x00000001);
            smartReplyAllowlistCovered_ = false;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata)
        private static final com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                  .TranscriptSegment.DialogflowSegmentMetadata();
        }

        public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment.DialogflowSegmentMetadata
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DialogflowSegmentMetadata> PARSER =
            new com.google.protobuf.AbstractParser<DialogflowSegmentMetadata>() {
              @java.lang.Override
              public DialogflowSegmentMetadata parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DialogflowSegmentMetadata> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DialogflowSegmentMetadata> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public static final int MESSAGE_TIME_FIELD_NUMBER = 6;
      private com.google.protobuf.Timestamp messageTime_;
      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       *
       * @return Whether the messageTime field is set.
       */
      @java.lang.Override
      public boolean hasMessageTime() {
        return messageTime_ != null;
      }
      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       *
       * @return The messageTime.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getMessageTime() {
        return messageTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : messageTime_;
      }
      /**
       *
       *
       * <pre>
       * The time that the message occurred, if provided.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp message_time = 6;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getMessageTimeOrBuilder() {
        return messageTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : messageTime_;
      }

      public static final int TEXT_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object text_ = "";
      /**
       *
       *
       * <pre>
       * The text of this segment.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The text.
       */
      @java.lang.Override
      public java.lang.String getText() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          text_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The text of this segment.
       * </pre>
       *
       * <code>string text = 1;</code>
       *
       * @return The bytes for text.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getTextBytes() {
        java.lang.Object ref = text_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          text_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CONFIDENCE_FIELD_NUMBER = 2;
      private float confidence_ = 0F;
      /**
       *
       *
       * <pre>
       * A confidence estimate between 0.0 and 1.0 of the fidelity of this
       * segment. A default value of 0.0 indicates that the value is unset.
       * </pre>
       *
       * <code>float confidence = 2;</code>
       *
       * @return The confidence.
       */
      @java.lang.Override
      public float getConfidence() {
        return confidence_;
      }

      public static final int WORDS_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo>
          words_;
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .WordInfo>
          getWordsList() {
        return words_;
      }
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfoOrBuilder>
          getWordsOrBuilderList() {
        return words_;
      }
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      @java.lang.Override
      public int getWordsCount() {
        return words_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .WordInfo
          getWords(int index) {
        return words_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of the word-specific information for each word in the segment.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .WordInfoOrBuilder
          getWordsOrBuilder(int index) {
        return words_.get(index);
      }

      public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object languageCode_ = "";
      /**
       *
       *
       * <pre>
       * The language code of this segment as a
       * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
       * Example: "en-US".
       * </pre>
       *
       * <code>string language_code = 4;</code>
       *
       * @return The languageCode.
       */
      @java.lang.Override
      public java.lang.String getLanguageCode() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          languageCode_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * The language code of this segment as a
       * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
       * Example: "en-US".
       * </pre>
       *
       * <code>string language_code = 4;</code>
       *
       * @return The bytes for languageCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getLanguageCodeBytes() {
        java.lang.Object ref = languageCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          languageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int CHANNEL_TAG_FIELD_NUMBER = 5;
      private int channelTag_ = 0;
      /**
       *
       *
       * <pre>
       * For conversations derived from multi-channel audio, this is the channel
       * number corresponding to the audio from that channel. For
       * audioChannelCount = N, its output values can range from '1' to 'N'. A
       * channel tag of 0 indicates that the audio is mono.
       * </pre>
       *
       * <code>int32 channel_tag = 5;</code>
       *
       * @return The channelTag.
       */
      @java.lang.Override
      public int getChannelTag() {
        return channelTag_;
      }

      public static final int SEGMENT_PARTICIPANT_FIELD_NUMBER = 9;
      private com.google.cloud.contactcenterinsights.v1.ConversationParticipant segmentParticipant_;
      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       *
       * @return Whether the segmentParticipant field is set.
       */
      @java.lang.Override
      public boolean hasSegmentParticipant() {
        return segmentParticipant_ != null;
      }
      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       *
       * @return The segmentParticipant.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.ConversationParticipant
          getSegmentParticipant() {
        return segmentParticipant_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.getDefaultInstance()
            : segmentParticipant_;
      }
      /**
       *
       *
       * <pre>
       * The participant of this segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder
          getSegmentParticipantOrBuilder() {
        return segmentParticipant_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.getDefaultInstance()
            : segmentParticipant_;
      }

      public static final int DIALOGFLOW_SEGMENT_METADATA_FIELD_NUMBER = 10;
      private com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .DialogflowSegmentMetadata
          dialogflowSegmentMetadata_;
      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       *
       * @return Whether the dialogflowSegmentMetadata field is set.
       */
      @java.lang.Override
      public boolean hasDialogflowSegmentMetadata() {
        return dialogflowSegmentMetadata_ != null;
      }
      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       *
       * @return The dialogflowSegmentMetadata.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .DialogflowSegmentMetadata
          getDialogflowSegmentMetadata() {
        return dialogflowSegmentMetadata_ == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata.getDefaultInstance()
            : dialogflowSegmentMetadata_;
      }
      /**
       *
       *
       * <pre>
       * CCAI metadata relating to the current transcript segment.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .DialogflowSegmentMetadataOrBuilder
          getDialogflowSegmentMetadataOrBuilder() {
        return dialogflowSegmentMetadata_ == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata.getDefaultInstance()
            : dialogflowSegmentMetadata_;
      }

      public static final int SENTIMENT_FIELD_NUMBER = 11;
      private com.google.cloud.contactcenterinsights.v1.SentimentData sentiment_;
      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       *
       * @return Whether the sentiment field is set.
       */
      @java.lang.Override
      public boolean hasSentiment() {
        return sentiment_ != null;
      }
      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       *
       * @return The sentiment.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.SentimentData getSentiment() {
        return sentiment_ == null
            ? com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance()
            : sentiment_;
      }
      /**
       *
       *
       * <pre>
       * The sentiment for this transcript segment.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder
          getSentimentOrBuilder() {
        return sentiment_ == null
            ? com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance()
            : sentiment_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          output.writeFloat(2, confidence_);
        }
        for (int i = 0; i < words_.size(); i++) {
          output.writeMessage(3, words_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
        }
        if (channelTag_ != 0) {
          output.writeInt32(5, channelTag_);
        }
        if (messageTime_ != null) {
          output.writeMessage(6, getMessageTime());
        }
        if (segmentParticipant_ != null) {
          output.writeMessage(9, getSegmentParticipant());
        }
        if (dialogflowSegmentMetadata_ != null) {
          output.writeMessage(10, getDialogflowSegmentMetadata());
        }
        if (sentiment_ != null) {
          output.writeMessage(11, getSentiment());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
        }
        if (java.lang.Float.floatToRawIntBits(confidence_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidence_);
        }
        for (int i = 0; i < words_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, words_.get(i));
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
        }
        if (channelTag_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, channelTag_);
        }
        if (messageTime_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMessageTime());
        }
        if (segmentParticipant_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSegmentParticipant());
        }
        if (dialogflowSegmentMetadata_ != null) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  10, getDialogflowSegmentMetadata());
        }
        if (sentiment_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSentiment());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment other =
            (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
                obj;

        if (hasMessageTime() != other.hasMessageTime()) return false;
        if (hasMessageTime()) {
          if (!getMessageTime().equals(other.getMessageTime())) return false;
        }
        if (!getText().equals(other.getText())) return false;
        if (java.lang.Float.floatToIntBits(getConfidence())
            != java.lang.Float.floatToIntBits(other.getConfidence())) return false;
        if (!getWordsList().equals(other.getWordsList())) return false;
        if (!getLanguageCode().equals(other.getLanguageCode())) return false;
        if (getChannelTag() != other.getChannelTag()) return false;
        if (hasSegmentParticipant() != other.hasSegmentParticipant()) return false;
        if (hasSegmentParticipant()) {
          if (!getSegmentParticipant().equals(other.getSegmentParticipant())) return false;
        }
        if (hasDialogflowSegmentMetadata() != other.hasDialogflowSegmentMetadata()) return false;
        if (hasDialogflowSegmentMetadata()) {
          if (!getDialogflowSegmentMetadata().equals(other.getDialogflowSegmentMetadata()))
            return false;
        }
        if (hasSentiment() != other.hasSentiment()) return false;
        if (hasSentiment()) {
          if (!getSentiment().equals(other.getSentiment())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasMessageTime()) {
          hash = (37 * hash) + MESSAGE_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getMessageTime().hashCode();
        }
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        hash = (37 * hash) + CONFIDENCE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidence());
        if (getWordsCount() > 0) {
          hash = (37 * hash) + WORDS_FIELD_NUMBER;
          hash = (53 * hash) + getWordsList().hashCode();
        }
        hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getLanguageCode().hashCode();
        hash = (37 * hash) + CHANNEL_TAG_FIELD_NUMBER;
        hash = (53 * hash) + getChannelTag();
        if (hasSegmentParticipant()) {
          hash = (37 * hash) + SEGMENT_PARTICIPANT_FIELD_NUMBER;
          hash = (53 * hash) + getSegmentParticipant().hashCode();
        }
        if (hasDialogflowSegmentMetadata()) {
          hash = (37 * hash) + DIALOGFLOW_SEGMENT_METADATA_FIELD_NUMBER;
          hash = (53 * hash) + getDialogflowSegmentMetadata().hashCode();
        }
        if (hasSentiment()) {
          hash = (37 * hash) + SENTIMENT_FIELD_NUMBER;
          hash = (53 * hash) + getSentiment().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A segment of a full transcript.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegmentOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.class,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          messageTime_ = null;
          if (messageTimeBuilder_ != null) {
            messageTimeBuilder_.dispose();
            messageTimeBuilder_ = null;
          }
          text_ = "";
          confidence_ = 0F;
          if (wordsBuilder_ == null) {
            words_ = java.util.Collections.emptyList();
          } else {
            words_ = null;
            wordsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          languageCode_ = "";
          channelTag_ = 0;
          segmentParticipant_ = null;
          if (segmentParticipantBuilder_ != null) {
            segmentParticipantBuilder_.dispose();
            segmentParticipantBuilder_ = null;
          }
          dialogflowSegmentMetadata_ = null;
          if (dialogflowSegmentMetadataBuilder_ != null) {
            dialogflowSegmentMetadataBuilder_.dispose();
            dialogflowSegmentMetadataBuilder_ = null;
          }
          sentiment_ = null;
          if (sentimentBuilder_ != null) {
            sentimentBuilder_.dispose();
            sentimentBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_TranscriptSegment_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
            build() {
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              result =
                  new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                result) {
          if (wordsBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)) {
              words_ = java.util.Collections.unmodifiableList(words_);
              bitField0_ = (bitField0_ & ~0x00000008);
            }
            result.words_ = words_;
          } else {
            result.words_ = wordsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.messageTime_ =
                messageTimeBuilder_ == null ? messageTime_ : messageTimeBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.text_ = text_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.confidence_ = confidence_;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.languageCode_ = languageCode_;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.channelTag_ = channelTag_;
          }
          if (((from_bitField0_ & 0x00000040) != 0)) {
            result.segmentParticipant_ =
                segmentParticipantBuilder_ == null
                    ? segmentParticipant_
                    : segmentParticipantBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000080) != 0)) {
            result.dialogflowSegmentMetadata_ =
                dialogflowSegmentMetadataBuilder_ == null
                    ? dialogflowSegmentMetadata_
                    : dialogflowSegmentMetadataBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000100) != 0)) {
            result.sentiment_ = sentimentBuilder_ == null ? sentiment_ : sentimentBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .getDefaultInstance()) return this;
          if (other.hasMessageTime()) {
            mergeMessageTime(other.getMessageTime());
          }
          if (!other.getText().isEmpty()) {
            text_ = other.text_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (other.getConfidence() != 0F) {
            setConfidence(other.getConfidence());
          }
          if (wordsBuilder_ == null) {
            if (!other.words_.isEmpty()) {
              if (words_.isEmpty()) {
                words_ = other.words_;
                bitField0_ = (bitField0_ & ~0x00000008);
              } else {
                ensureWordsIsMutable();
                words_.addAll(other.words_);
              }
              onChanged();
            }
          } else {
            if (!other.words_.isEmpty()) {
              if (wordsBuilder_.isEmpty()) {
                wordsBuilder_.dispose();
                wordsBuilder_ = null;
                words_ = other.words_;
                bitField0_ = (bitField0_ & ~0x00000008);
                wordsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getWordsFieldBuilder()
                        : null;
              } else {
                wordsBuilder_.addAllMessages(other.words_);
              }
            }
          }
          if (!other.getLanguageCode().isEmpty()) {
            languageCode_ = other.languageCode_;
            bitField0_ |= 0x00000010;
            onChanged();
          }
          if (other.getChannelTag() != 0) {
            setChannelTag(other.getChannelTag());
          }
          if (other.hasSegmentParticipant()) {
            mergeSegmentParticipant(other.getSegmentParticipant());
          }
          if (other.hasDialogflowSegmentMetadata()) {
            mergeDialogflowSegmentMetadata(other.getDialogflowSegmentMetadata());
          }
          if (other.hasSentiment()) {
            mergeSentiment(other.getSentiment());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    text_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 10
                case 21:
                  {
                    confidence_ = input.readFloat();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 21
                case 26:
                  {
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                            .TranscriptSegment.WordInfo
                        m =
                            input.readMessage(
                                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                                    .TranscriptSegment.WordInfo.parser(),
                                extensionRegistry);
                    if (wordsBuilder_ == null) {
                      ensureWordsIsMutable();
                      words_.add(m);
                    } else {
                      wordsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                case 34:
                  {
                    languageCode_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000010;
                    break;
                  } // case 34
                case 40:
                  {
                    channelTag_ = input.readInt32();
                    bitField0_ |= 0x00000020;
                    break;
                  } // case 40
                case 50:
                  {
                    input.readMessage(getMessageTimeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 50
                case 74:
                  {
                    input.readMessage(
                        getSegmentParticipantFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000040;
                    break;
                  } // case 74
                case 82:
                  {
                    input.readMessage(
                        getDialogflowSegmentMetadataFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000080;
                    break;
                  } // case 82
                case 90:
                  {
                    input.readMessage(getSentimentFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000100;
                    break;
                  } // case 90
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Timestamp messageTime_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            messageTimeBuilder_;
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         *
         * @return Whether the messageTime field is set.
         */
        public boolean hasMessageTime() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         *
         * @return The messageTime.
         */
        public com.google.protobuf.Timestamp getMessageTime() {
          if (messageTimeBuilder_ == null) {
            return messageTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : messageTime_;
          } else {
            return messageTimeBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public Builder setMessageTime(com.google.protobuf.Timestamp value) {
          if (messageTimeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            messageTime_ = value;
          } else {
            messageTimeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public Builder setMessageTime(com.google.protobuf.Timestamp.Builder builderForValue) {
          if (messageTimeBuilder_ == null) {
            messageTime_ = builderForValue.build();
          } else {
            messageTimeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public Builder mergeMessageTime(com.google.protobuf.Timestamp value) {
          if (messageTimeBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && messageTime_ != null
                && messageTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
              getMessageTimeBuilder().mergeFrom(value);
            } else {
              messageTime_ = value;
            }
          } else {
            messageTimeBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public Builder clearMessageTime() {
          bitField0_ = (bitField0_ & ~0x00000001);
          messageTime_ = null;
          if (messageTimeBuilder_ != null) {
            messageTimeBuilder_.dispose();
            messageTimeBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public com.google.protobuf.Timestamp.Builder getMessageTimeBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getMessageTimeFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getMessageTimeOrBuilder() {
          if (messageTimeBuilder_ != null) {
            return messageTimeBuilder_.getMessageOrBuilder();
          } else {
            return messageTime_ == null
                ? com.google.protobuf.Timestamp.getDefaultInstance()
                : messageTime_;
          }
        }
        /**
         *
         *
         * <pre>
         * The time that the message occurred, if provided.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp message_time = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>
            getMessageTimeFieldBuilder() {
          if (messageTimeBuilder_ == null) {
            messageTimeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Timestamp,
                    com.google.protobuf.Timestamp.Builder,
                    com.google.protobuf.TimestampOrBuilder>(
                    getMessageTime(), getParentForChildren(), isClean());
            messageTime_ = null;
          }
          return messageTimeBuilder_;
        }

        private java.lang.Object text_ = "";
        /**
         *
         *
         * <pre>
         * The text of this segment.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return The text.
         */
        public java.lang.String getText() {
          java.lang.Object ref = text_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            text_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The text of this segment.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return The bytes for text.
         */
        public com.google.protobuf.ByteString getTextBytes() {
          java.lang.Object ref = text_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            text_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The text of this segment.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @param value The text to set.
         * @return This builder for chaining.
         */
        public Builder setText(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          text_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The text of this segment.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearText() {
          text_ = getDefaultInstance().getText();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The text of this segment.
         * </pre>
         *
         * <code>string text = 1;</code>
         *
         * @param value The bytes for text to set.
         * @return This builder for chaining.
         */
        public Builder setTextBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          text_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private float confidence_;
        /**
         *
         *
         * <pre>
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this
         * segment. A default value of 0.0 indicates that the value is unset.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return The confidence.
         */
        @java.lang.Override
        public float getConfidence() {
          return confidence_;
        }
        /**
         *
         *
         * <pre>
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this
         * segment. A default value of 0.0 indicates that the value is unset.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @param value The confidence to set.
         * @return This builder for chaining.
         */
        public Builder setConfidence(float value) {

          confidence_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A confidence estimate between 0.0 and 1.0 of the fidelity of this
         * segment. A default value of 0.0 indicates that the value is unset.
         * </pre>
         *
         * <code>float confidence = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearConfidence() {
          bitField0_ = (bitField0_ & ~0x00000004);
          confidence_ = 0F;
          onChanged();
          return this;
        }

        private java.util.List<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo>
            words_ = java.util.Collections.emptyList();

        private void ensureWordsIsMutable() {
          if (!((bitField0_ & 0x00000008) != 0)) {
            words_ =
                new java.util.ArrayList<
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo>(words_);
            bitField0_ |= 0x00000008;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfoOrBuilder>
            wordsBuilder_;

        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo>
            getWordsList() {
          if (wordsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(words_);
          } else {
            return wordsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public int getWordsCount() {
          if (wordsBuilder_ == null) {
            return words_.size();
          } else {
            return wordsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfo
            getWords(int index) {
          if (wordsBuilder_ == null) {
            return words_.get(index);
          } else {
            return wordsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder setWords(
            int index,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                value) {
          if (wordsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureWordsIsMutable();
            words_.set(index, value);
            onChanged();
          } else {
            wordsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder setWords(
            int index,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder
                builderForValue) {
          if (wordsBuilder_ == null) {
            ensureWordsIsMutable();
            words_.set(index, builderForValue.build());
            onChanged();
          } else {
            wordsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder addWords(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                value) {
          if (wordsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureWordsIsMutable();
            words_.add(value);
            onChanged();
          } else {
            wordsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder addWords(
            int index,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo
                value) {
          if (wordsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureWordsIsMutable();
            words_.add(index, value);
            onChanged();
          } else {
            wordsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder addWords(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder
                builderForValue) {
          if (wordsBuilder_ == null) {
            ensureWordsIsMutable();
            words_.add(builderForValue.build());
            onChanged();
          } else {
            wordsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder addWords(
            int index,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder
                builderForValue) {
          if (wordsBuilder_ == null) {
            ensureWordsIsMutable();
            words_.add(index, builderForValue.build());
            onChanged();
          } else {
            wordsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder addAllWords(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                            .TranscriptSegment.WordInfo>
                values) {
          if (wordsBuilder_ == null) {
            ensureWordsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, words_);
            onChanged();
          } else {
            wordsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder clearWords() {
          if (wordsBuilder_ == null) {
            words_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000008);
            onChanged();
          } else {
            wordsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public Builder removeWords(int index) {
          if (wordsBuilder_ == null) {
            ensureWordsIsMutable();
            words_.remove(index);
            onChanged();
          } else {
            wordsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfo.Builder
            getWordsBuilder(int index) {
          return getWordsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfoOrBuilder
            getWordsOrBuilder(int index) {
          if (wordsBuilder_ == null) {
            return words_.get(index);
          } else {
            return wordsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfoOrBuilder>
            getWordsOrBuilderList() {
          if (wordsBuilder_ != null) {
            return wordsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(words_);
          }
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfo.Builder
            addWordsBuilder() {
          return getWordsFieldBuilder()
              .addBuilder(
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfo.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .WordInfo.Builder
            addWordsBuilder(int index) {
          return getWordsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.WordInfo.getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * A list of the word-specific information for each word in the segment.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.WordInfo words = 3;
         * </code>
         */
        public java.util.List<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder>
            getWordsBuilderList() {
          return getWordsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfo.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .WordInfoOrBuilder>
            getWordsFieldBuilder() {
          if (wordsBuilder_ == null) {
            wordsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfo.Builder,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.WordInfoOrBuilder>(
                    words_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
            words_ = null;
          }
          return wordsBuilder_;
        }

        private java.lang.Object languageCode_ = "";
        /**
         *
         *
         * <pre>
         * The language code of this segment as a
         * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
         * Example: "en-US".
         * </pre>
         *
         * <code>string language_code = 4;</code>
         *
         * @return The languageCode.
         */
        public java.lang.String getLanguageCode() {
          java.lang.Object ref = languageCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            languageCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The language code of this segment as a
         * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
         * Example: "en-US".
         * </pre>
         *
         * <code>string language_code = 4;</code>
         *
         * @return The bytes for languageCode.
         */
        public com.google.protobuf.ByteString getLanguageCodeBytes() {
          java.lang.Object ref = languageCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            languageCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * The language code of this segment as a
         * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
         * Example: "en-US".
         * </pre>
         *
         * <code>string language_code = 4;</code>
         *
         * @param value The languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCode(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          languageCode_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The language code of this segment as a
         * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
         * Example: "en-US".
         * </pre>
         *
         * <code>string language_code = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearLanguageCode() {
          languageCode_ = getDefaultInstance().getLanguageCode();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The language code of this segment as a
         * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
         * Example: "en-US".
         * </pre>
         *
         * <code>string language_code = 4;</code>
         *
         * @param value The bytes for languageCode to set.
         * @return This builder for chaining.
         */
        public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          languageCode_ = value;
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }

        private int channelTag_;
        /**
         *
         *
         * <pre>
         * For conversations derived from multi-channel audio, this is the channel
         * number corresponding to the audio from that channel. For
         * audioChannelCount = N, its output values can range from '1' to 'N'. A
         * channel tag of 0 indicates that the audio is mono.
         * </pre>
         *
         * <code>int32 channel_tag = 5;</code>
         *
         * @return The channelTag.
         */
        @java.lang.Override
        public int getChannelTag() {
          return channelTag_;
        }
        /**
         *
         *
         * <pre>
         * For conversations derived from multi-channel audio, this is the channel
         * number corresponding to the audio from that channel. For
         * audioChannelCount = N, its output values can range from '1' to 'N'. A
         * channel tag of 0 indicates that the audio is mono.
         * </pre>
         *
         * <code>int32 channel_tag = 5;</code>
         *
         * @param value The channelTag to set.
         * @return This builder for chaining.
         */
        public Builder setChannelTag(int value) {

          channelTag_ = value;
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * For conversations derived from multi-channel audio, this is the channel
         * number corresponding to the audio from that channel. For
         * audioChannelCount = N, its output values can range from '1' to 'N'. A
         * channel tag of 0 indicates that the audio is mono.
         * </pre>
         *
         * <code>int32 channel_tag = 5;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearChannelTag() {
          bitField0_ = (bitField0_ & ~0x00000020);
          channelTag_ = 0;
          onChanged();
          return this;
        }

        private com.google.cloud.contactcenterinsights.v1.ConversationParticipant
            segmentParticipant_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ConversationParticipant,
                com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder,
                com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder>
            segmentParticipantBuilder_;
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         *
         * @return Whether the segmentParticipant field is set.
         */
        public boolean hasSegmentParticipant() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         *
         * @return The segmentParticipant.
         */
        public com.google.cloud.contactcenterinsights.v1.ConversationParticipant
            getSegmentParticipant() {
          if (segmentParticipantBuilder_ == null) {
            return segmentParticipant_ == null
                ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant
                    .getDefaultInstance()
                : segmentParticipant_;
          } else {
            return segmentParticipantBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public Builder setSegmentParticipant(
            com.google.cloud.contactcenterinsights.v1.ConversationParticipant value) {
          if (segmentParticipantBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            segmentParticipant_ = value;
          } else {
            segmentParticipantBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public Builder setSegmentParticipant(
            com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder
                builderForValue) {
          if (segmentParticipantBuilder_ == null) {
            segmentParticipant_ = builderForValue.build();
          } else {
            segmentParticipantBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public Builder mergeSegmentParticipant(
            com.google.cloud.contactcenterinsights.v1.ConversationParticipant value) {
          if (segmentParticipantBuilder_ == null) {
            if (((bitField0_ & 0x00000040) != 0)
                && segmentParticipant_ != null
                && segmentParticipant_
                    != com.google.cloud.contactcenterinsights.v1.ConversationParticipant
                        .getDefaultInstance()) {
              getSegmentParticipantBuilder().mergeFrom(value);
            } else {
              segmentParticipant_ = value;
            }
          } else {
            segmentParticipantBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000040;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public Builder clearSegmentParticipant() {
          bitField0_ = (bitField0_ & ~0x00000040);
          segmentParticipant_ = null;
          if (segmentParticipantBuilder_ != null) {
            segmentParticipantBuilder_.dispose();
            segmentParticipantBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder
            getSegmentParticipantBuilder() {
          bitField0_ |= 0x00000040;
          onChanged();
          return getSegmentParticipantFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder
            getSegmentParticipantOrBuilder() {
          if (segmentParticipantBuilder_ != null) {
            return segmentParticipantBuilder_.getMessageOrBuilder();
          } else {
            return segmentParticipant_ == null
                ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant
                    .getDefaultInstance()
                : segmentParticipant_;
          }
        }
        /**
         *
         *
         * <pre>
         * The participant of this segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.ConversationParticipant segment_participant = 9;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ConversationParticipant,
                com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder,
                com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder>
            getSegmentParticipantFieldBuilder() {
          if (segmentParticipantBuilder_ == null) {
            segmentParticipantBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.ConversationParticipant,
                    com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder,
                    com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder>(
                    getSegmentParticipant(), getParentForChildren(), isClean());
            segmentParticipant_ = null;
          }
          return segmentParticipantBuilder_;
        }

        private com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata
            dialogflowSegmentMetadata_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadataOrBuilder>
            dialogflowSegmentMetadataBuilder_;
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         *
         * @return Whether the dialogflowSegmentMetadata field is set.
         */
        public boolean hasDialogflowSegmentMetadata() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         *
         * @return The dialogflowSegmentMetadata.
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata
            getDialogflowSegmentMetadata() {
          if (dialogflowSegmentMetadataBuilder_ == null) {
            return dialogflowSegmentMetadata_ == null
                ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegment.DialogflowSegmentMetadata.getDefaultInstance()
                : dialogflowSegmentMetadata_;
          } else {
            return dialogflowSegmentMetadataBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public Builder setDialogflowSegmentMetadata(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata
                value) {
          if (dialogflowSegmentMetadataBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            dialogflowSegmentMetadata_ = value;
          } else {
            dialogflowSegmentMetadataBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public Builder setDialogflowSegmentMetadata(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata.Builder
                builderForValue) {
          if (dialogflowSegmentMetadataBuilder_ == null) {
            dialogflowSegmentMetadata_ = builderForValue.build();
          } else {
            dialogflowSegmentMetadataBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public Builder mergeDialogflowSegmentMetadata(
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata
                value) {
          if (dialogflowSegmentMetadataBuilder_ == null) {
            if (((bitField0_ & 0x00000080) != 0)
                && dialogflowSegmentMetadata_ != null
                && dialogflowSegmentMetadata_
                    != com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata.getDefaultInstance()) {
              getDialogflowSegmentMetadataBuilder().mergeFrom(value);
            } else {
              dialogflowSegmentMetadata_ = value;
            }
          } else {
            dialogflowSegmentMetadataBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000080;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public Builder clearDialogflowSegmentMetadata() {
          bitField0_ = (bitField0_ & ~0x00000080);
          dialogflowSegmentMetadata_ = null;
          if (dialogflowSegmentMetadataBuilder_ != null) {
            dialogflowSegmentMetadataBuilder_.dispose();
            dialogflowSegmentMetadataBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadata.Builder
            getDialogflowSegmentMetadataBuilder() {
          bitField0_ |= 0x00000080;
          onChanged();
          return getDialogflowSegmentMetadataFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                .DialogflowSegmentMetadataOrBuilder
            getDialogflowSegmentMetadataOrBuilder() {
          if (dialogflowSegmentMetadataBuilder_ != null) {
            return dialogflowSegmentMetadataBuilder_.getMessageOrBuilder();
          } else {
            return dialogflowSegmentMetadata_ == null
                ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegment.DialogflowSegmentMetadata.getDefaultInstance()
                : dialogflowSegmentMetadata_;
          }
        }
        /**
         *
         *
         * <pre>
         * CCAI metadata relating to the current transcript segment.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment.DialogflowSegmentMetadata dialogflow_segment_metadata = 10;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .DialogflowSegmentMetadataOrBuilder>
            getDialogflowSegmentMetadataFieldBuilder() {
          if (dialogflowSegmentMetadataBuilder_ == null) {
            dialogflowSegmentMetadataBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadata.Builder,
                    com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                        .TranscriptSegment.DialogflowSegmentMetadataOrBuilder>(
                    getDialogflowSegmentMetadata(), getParentForChildren(), isClean());
            dialogflowSegmentMetadata_ = null;
          }
          return dialogflowSegmentMetadataBuilder_;
        }

        private com.google.cloud.contactcenterinsights.v1.SentimentData sentiment_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SentimentData,
                com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
                com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>
            sentimentBuilder_;
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         *
         * @return Whether the sentiment field is set.
         */
        public boolean hasSentiment() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         *
         * @return The sentiment.
         */
        public com.google.cloud.contactcenterinsights.v1.SentimentData getSentiment() {
          if (sentimentBuilder_ == null) {
            return sentiment_ == null
                ? com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance()
                : sentiment_;
          } else {
            return sentimentBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public Builder setSentiment(com.google.cloud.contactcenterinsights.v1.SentimentData value) {
          if (sentimentBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            sentiment_ = value;
          } else {
            sentimentBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public Builder setSentiment(
            com.google.cloud.contactcenterinsights.v1.SentimentData.Builder builderForValue) {
          if (sentimentBuilder_ == null) {
            sentiment_ = builderForValue.build();
          } else {
            sentimentBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public Builder mergeSentiment(
            com.google.cloud.contactcenterinsights.v1.SentimentData value) {
          if (sentimentBuilder_ == null) {
            if (((bitField0_ & 0x00000100) != 0)
                && sentiment_ != null
                && sentiment_
                    != com.google.cloud.contactcenterinsights.v1.SentimentData
                        .getDefaultInstance()) {
              getSentimentBuilder().mergeFrom(value);
            } else {
              sentiment_ = value;
            }
          } else {
            sentimentBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000100;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public Builder clearSentiment() {
          bitField0_ = (bitField0_ & ~0x00000100);
          sentiment_ = null;
          if (sentimentBuilder_ != null) {
            sentimentBuilder_.dispose();
            sentimentBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public com.google.cloud.contactcenterinsights.v1.SentimentData.Builder
            getSentimentBuilder() {
          bitField0_ |= 0x00000100;
          onChanged();
          return getSentimentFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        public com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder
            getSentimentOrBuilder() {
          if (sentimentBuilder_ != null) {
            return sentimentBuilder_.getMessageOrBuilder();
          } else {
            return sentiment_ == null
                ? com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance()
                : sentiment_;
          }
        }
        /**
         *
         *
         * <pre>
         * The sentiment for this transcript segment.
         * </pre>
         *
         * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment = 11;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SentimentData,
                com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
                com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>
            getSentimentFieldBuilder() {
          if (sentimentBuilder_ == null) {
            sentimentBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.SentimentData,
                    com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
                    com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>(
                    getSentiment(), getParentForChildren(), isClean());
            sentiment_ = null;
          }
          return sentimentBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment)
      private static final com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .TranscriptSegment();
      }

      public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegment
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TranscriptSegment> PARSER =
          new com.google.protobuf.AbstractParser<TranscriptSegment>() {
            @java.lang.Override
            public TranscriptSegment parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TranscriptSegment> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TranscriptSegment> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public static final int TRANSCRIPT_SEGMENTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment>
        transcriptSegments_;
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment>
        getTranscriptSegmentsList() {
      return transcriptSegments_;
    }
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .TranscriptSegmentOrBuilder>
        getTranscriptSegmentsOrBuilderList() {
      return transcriptSegments_;
    }
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    @java.lang.Override
    public int getTranscriptSegmentsCount() {
      return transcriptSegments_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
        getTranscriptSegments(int index) {
      return transcriptSegments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of sequential transcript segments that comprise the conversation.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
            .TranscriptSegmentOrBuilder
        getTranscriptSegmentsOrBuilder(int index) {
      return transcriptSegments_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < transcriptSegments_.size(); i++) {
        output.writeMessage(1, transcriptSegments_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < transcriptSegments_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, transcriptSegments_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Conversation.Transcript)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript other =
          (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript) obj;

      if (!getTranscriptSegmentsList().equals(other.getTranscriptSegmentsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getTranscriptSegmentsCount() > 0) {
        hash = (37 * hash) + TRANSCRIPT_SEGMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getTranscriptSegmentsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A message representing the transcript of a conversation.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation.Transcript}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation.Transcript)
        com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.class,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (transcriptSegmentsBuilder_ == null) {
          transcriptSegments_ = java.util.Collections.emptyList();
        } else {
          transcriptSegments_ = null;
          transcriptSegmentsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_Transcript_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript build() {
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript result =
            new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript result) {
        if (transcriptSegmentsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            transcriptSegments_ = java.util.Collections.unmodifiableList(transcriptSegments_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.transcriptSegments_ = transcriptSegments_;
        } else {
          result.transcriptSegments_ = transcriptSegmentsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.Conversation.Transcript) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Conversation.Transcript) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                .getDefaultInstance()) return this;
        if (transcriptSegmentsBuilder_ == null) {
          if (!other.transcriptSegments_.isEmpty()) {
            if (transcriptSegments_.isEmpty()) {
              transcriptSegments_ = other.transcriptSegments_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTranscriptSegmentsIsMutable();
              transcriptSegments_.addAll(other.transcriptSegments_);
            }
            onChanged();
          }
        } else {
          if (!other.transcriptSegments_.isEmpty()) {
            if (transcriptSegmentsBuilder_.isEmpty()) {
              transcriptSegmentsBuilder_.dispose();
              transcriptSegmentsBuilder_ = null;
              transcriptSegments_ = other.transcriptSegments_;
              bitField0_ = (bitField0_ & ~0x00000001);
              transcriptSegmentsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTranscriptSegmentsFieldBuilder()
                      : null;
            } else {
              transcriptSegmentsBuilder_.addAllMessages(other.transcriptSegments_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment
                      m =
                          input.readMessage(
                              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                                  .TranscriptSegment.parser(),
                              extensionRegistry);
                  if (transcriptSegmentsBuilder_ == null) {
                    ensureTranscriptSegmentsIsMutable();
                    transcriptSegments_.add(m);
                  } else {
                    transcriptSegmentsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment>
          transcriptSegments_ = java.util.Collections.emptyList();

      private void ensureTranscriptSegmentsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          transcriptSegments_ =
              new java.util.ArrayList<
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment>(transcriptSegments_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment,
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                  .TranscriptSegmentOrBuilder>
          transcriptSegmentsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment>
          getTranscriptSegmentsList() {
        if (transcriptSegmentsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(transcriptSegments_);
        } else {
          return transcriptSegmentsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public int getTranscriptSegmentsCount() {
        if (transcriptSegmentsBuilder_ == null) {
          return transcriptSegments_.size();
        } else {
          return transcriptSegmentsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
          getTranscriptSegments(int index) {
        if (transcriptSegmentsBuilder_ == null) {
          return transcriptSegments_.get(index);
        } else {
          return transcriptSegmentsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder setTranscriptSegments(
          int index,
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              value) {
        if (transcriptSegmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.set(index, value);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder setTranscriptSegments(
          int index,
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder
              builderForValue) {
        if (transcriptSegmentsBuilder_ == null) {
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.set(index, builderForValue.build());
          onChanged();
        } else {
          transcriptSegmentsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder addTranscriptSegments(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              value) {
        if (transcriptSegmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.add(value);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder addTranscriptSegments(
          int index,
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              value) {
        if (transcriptSegmentsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.add(index, value);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder addTranscriptSegments(
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder
              builderForValue) {
        if (transcriptSegmentsBuilder_ == null) {
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.add(builderForValue.build());
          onChanged();
        } else {
          transcriptSegmentsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder addTranscriptSegments(
          int index,
          com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder
              builderForValue) {
        if (transcriptSegmentsBuilder_ == null) {
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.add(index, builderForValue.build());
          onChanged();
        } else {
          transcriptSegmentsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder addAllTranscriptSegments(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                          .TranscriptSegment>
              values) {
        if (transcriptSegmentsBuilder_ == null) {
          ensureTranscriptSegmentsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, transcriptSegments_);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder clearTranscriptSegments() {
        if (transcriptSegmentsBuilder_ == null) {
          transcriptSegments_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public Builder removeTranscriptSegments(int index) {
        if (transcriptSegmentsBuilder_ == null) {
          ensureTranscriptSegmentsIsMutable();
          transcriptSegments_.remove(index);
          onChanged();
        } else {
          transcriptSegmentsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .Builder
          getTranscriptSegmentsBuilder(int index) {
        return getTranscriptSegmentsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
              .TranscriptSegmentOrBuilder
          getTranscriptSegmentsOrBuilder(int index) {
        if (transcriptSegmentsBuilder_ == null) {
          return transcriptSegments_.get(index);
        } else {
          return transcriptSegmentsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegmentOrBuilder>
          getTranscriptSegmentsOrBuilderList() {
        if (transcriptSegmentsBuilder_ != null) {
          return transcriptSegmentsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(transcriptSegments_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .Builder
          addTranscriptSegmentsBuilder() {
        return getTranscriptSegmentsFieldBuilder()
            .addBuilder(
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
              .Builder
          addTranscriptSegmentsBuilder(int index) {
        return getTranscriptSegmentsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of sequential transcript segments that comprise the conversation.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment transcript_segments = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder>
          getTranscriptSegmentsBuilderList() {
        return getTranscriptSegmentsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment,
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.TranscriptSegment
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                  .TranscriptSegmentOrBuilder>
          getTranscriptSegmentsFieldBuilder() {
        if (transcriptSegmentsBuilder_ == null) {
          transcriptSegmentsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegment.Builder,
                  com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                      .TranscriptSegmentOrBuilder>(
                  transcriptSegments_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          transcriptSegments_ = null;
        }
        return transcriptSegmentsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation.Transcript)
    private static final com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Conversation.Transcript();
    }

    public static com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Transcript> PARSER =
        new com.google.protobuf.AbstractParser<Transcript>() {
          @java.lang.Override
          public Transcript parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Transcript> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Transcript> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int metadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object metadata_;

  public enum MetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CALL_METADATA(7),
    METADATA_NOT_SET(0);
    private final int value;

    private MetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static MetadataCase forNumber(int value) {
      switch (value) {
        case 7:
          return CALL_METADATA;
        case 0:
          return METADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MetadataCase getMetadataCase() {
    return MetadataCase.forNumber(metadataCase_);
  }

  private int expirationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object expiration_;

  public enum ExpirationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    EXPIRE_TIME(15),
    TTL(16),
    EXPIRATION_NOT_SET(0);
    private final int value;

    private ExpirationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ExpirationCase valueOf(int value) {
      return forNumber(value);
    }

    public static ExpirationCase forNumber(int value) {
      switch (value) {
        case 15:
          return EXPIRE_TIME;
        case 16:
          return TTL;
        case 0:
          return EXPIRATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ExpirationCase getExpirationCase() {
    return ExpirationCase.forNumber(expirationCase_);
  }

  public static final int CALL_METADATA_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Call-specific metadata.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
   * </code>
   *
   * @return Whether the callMetadata field is set.
   */
  @java.lang.Override
  public boolean hasCallMetadata() {
    return metadataCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
   * </code>
   *
   * @return The callMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata getCallMetadata() {
    if (metadataCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Call-specific metadata.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder
      getCallMetadataOrBuilder() {
    if (metadataCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.getDefaultInstance();
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * The time at which this conversation should expire. After this time, the
   * conversation data and any associated analyses will be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 15;</code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expirationCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * The time at which this conversation should expire. After this time, the
   * conversation data and any associated analyses will be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 15;</code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    if (expirationCase_ == 15) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The time at which this conversation should expire. After this time, the
   * conversation data and any associated analyses will be deleted.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 15;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    if (expirationCase_ == 15) {
      return (com.google.protobuf.Timestamp) expiration_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int TTL_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. If specified, then this TTL will
   * be used to calculate the expire time.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return expirationCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. If specified, then this TTL will
   * be used to calculate the expire time.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    if (expirationCase_ == 16) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input only. The TTL for this resource. If specified, then this TTL will
   * be used to calculate the expire time.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    if (expirationCase_ == 16) {
      return (com.google.protobuf.Duration) expiration_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the conversation.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the conversation.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_SOURCE_FIELD_NUMBER = 2;
  private com.google.cloud.contactcenterinsights.v1.ConversationDataSource dataSource_;
  /**
   *
   *
   * <pre>
   * The source of the audio and transcription for the conversation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
   *
   * @return Whether the dataSource field is set.
   */
  @java.lang.Override
  public boolean hasDataSource() {
    return dataSource_ != null;
  }
  /**
   *
   *
   * <pre>
   * The source of the audio and transcription for the conversation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
   *
   * @return The dataSource.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationDataSource getDataSource() {
    return dataSource_ == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationDataSource.getDefaultInstance()
        : dataSource_;
  }
  /**
   *
   *
   * <pre>
   * The source of the audio and transcription for the conversation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationDataSourceOrBuilder
      getDataSourceOrBuilder() {
    return dataSource_ == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationDataSource.getDefaultInstance()
        : dataSource_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the conversation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the conversation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the conversation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the conversation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the conversation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the conversation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * The time at which the conversation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 17;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the conversation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 17;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the conversation started.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 17;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * A user-specified language code for the conversation.
   * </pre>
   *
   * <code>string language_code = 14;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-specified language code for the conversation.
   * </pre>
   *
   * <code>string language_code = 14;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AGENT_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agentId_ = "";
  /**
   *
   *
   * <pre>
   * An opaque, user-specified string representing the human agent who handled
   * the conversation.
   * </pre>
   *
   * <code>string agent_id = 5;</code>
   *
   * @return The agentId.
   */
  @java.lang.Override
  public java.lang.String getAgentId() {
    java.lang.Object ref = agentId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An opaque, user-specified string representing the human agent who handled
   * the conversation.
   * </pre>
   *
   * <code>string agent_id = 5;</code>
   *
   * @return The bytes for agentId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentIdBytes() {
    java.lang.Object ref = agentId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Conversation_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map for the user to specify any custom fields. A maximum of 20 labels per
   * conversation is allowed, with a maximum of 256 characters per entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * A map for the user to specify any custom fields. A maximum of 20 labels per
   * conversation is allowed, with a maximum of 256 characters per entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map for the user to specify any custom fields. A maximum of 20 labels per
   * conversation is allowed, with a maximum of 256 characters per entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map for the user to specify any custom fields. A maximum of 20 labels per
   * conversation is allowed, with a maximum of 256 characters per entry.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TRANSCRIPT_FIELD_NUMBER = 8;
  private com.google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript_;
  /**
   *
   *
   * <pre>
   * Output only. The conversation transcript.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the transcript field is set.
   */
  @java.lang.Override
  public boolean hasTranscript() {
    return transcript_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The conversation transcript.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The transcript.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript getTranscript() {
    return transcript_ == null
        ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.getDefaultInstance()
        : transcript_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The conversation transcript.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder
      getTranscriptOrBuilder() {
    return transcript_ == null
        ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.getDefaultInstance()
        : transcript_;
  }

  public static final int MEDIUM_FIELD_NUMBER = 9;
  private int medium_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The conversation medium, if unspecified will default to
   * PHONE_CALL.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for medium.
   */
  @java.lang.Override
  public int getMediumValue() {
    return medium_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The conversation medium, if unspecified will default to
   * PHONE_CALL.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The medium.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
    com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
        com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
        : result;
  }

  public static final int DURATION_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration duration_;
  /**
   *
   *
   * <pre>
   * Output only. The duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the duration field is set.
   */
  @java.lang.Override
  public boolean hasDuration() {
    return duration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The duration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDuration() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The duration of the conversation.
   * </pre>
   *
   * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
    return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
  }

  public static final int TURN_COUNT_FIELD_NUMBER = 11;
  private int turnCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of turns in the conversation.
   * </pre>
   *
   * <code>int32 turn_count = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The turnCount.
   */
  @java.lang.Override
  public int getTurnCount() {
    return turnCount_;
  }

  public static final int LATEST_ANALYSIS_FIELD_NUMBER = 12;
  private com.google.cloud.contactcenterinsights.v1.Analysis latestAnalysis_;
  /**
   *
   *
   * <pre>
   * Output only. The conversation's latest analysis, if one exists.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the latestAnalysis field is set.
   */
  @java.lang.Override
  public boolean hasLatestAnalysis() {
    return latestAnalysis_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The conversation's latest analysis, if one exists.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestAnalysis.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Analysis getLatestAnalysis() {
    return latestAnalysis_ == null
        ? com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance()
        : latestAnalysis_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The conversation's latest analysis, if one exists.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder getLatestAnalysisOrBuilder() {
    return latestAnalysis_ == null
        ? com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance()
        : latestAnalysis_;
  }

  public static final int LATEST_SUMMARY_FIELD_NUMBER = 20;
  private com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
      latestSummary_;
  /**
   *
   *
   * <pre>
   * Output only. Latest summary of the conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the latestSummary field is set.
   */
  @java.lang.Override
  public boolean hasLatestSummary() {
    return latestSummary_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Latest summary of the conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The latestSummary.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
      getLatestSummary() {
    return latestSummary_ == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
            .getDefaultInstance()
        : latestSummary_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Latest summary of the conversation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionDataOrBuilder
      getLatestSummaryOrBuilder() {
    return latestSummary_ == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
            .getDefaultInstance()
        : latestSummary_;
  }

  public static final int RUNTIME_ANNOTATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>
      runtimeAnnotations_;
  /**
   *
   *
   * <pre>
   * Output only. The annotations that were generated during the customer and
   * agent interaction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>
      getRuntimeAnnotationsList() {
    return runtimeAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotations that were generated during the customer and
   * agent interaction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder>
      getRuntimeAnnotationsOrBuilderList() {
    return runtimeAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotations that were generated during the customer and
   * agent interaction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getRuntimeAnnotationsCount() {
    return runtimeAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotations that were generated during the customer and
   * agent interaction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation getRuntimeAnnotations(
      int index) {
    return runtimeAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The annotations that were generated during the customer and
   * agent interaction.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder
      getRuntimeAnnotationsOrBuilder(int index) {
    return runtimeAnnotations_.get(index);
  }

  public static final int DIALOGFLOW_INTENTS_FIELD_NUMBER = 18;

  private static final class DialogflowIntentsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
                    newDefaultInstance(
                        com.google.cloud.contactcenterinsights.v1.ResourcesProto
                            .internal_static_google_cloud_contactcenterinsights_v1_Conversation_DialogflowIntentsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.contactcenterinsights.v1.DialogflowIntent
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
      dialogflowIntents_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
      internalGetDialogflowIntents() {
    if (dialogflowIntents_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DialogflowIntentsDefaultEntryHolder.defaultEntry);
    }
    return dialogflowIntents_;
  }

  public int getDialogflowIntentsCount() {
    return internalGetDialogflowIntents().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. All the matched Dialogflow intents in the call. The key
   * corresponds to a Dialogflow intent, format:
   * projects/{project}/agent/{agent}/intents/{intent}
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsDialogflowIntents(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDialogflowIntents().getMap().containsKey(key);
  }
  /** Use {@link #getDialogflowIntentsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
      getDialogflowIntents() {
    return getDialogflowIntentsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. All the matched Dialogflow intents in the call. The key
   * corresponds to a Dialogflow intent, format:
   * projects/{project}/agent/{agent}/intents/{intent}
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
      getDialogflowIntentsMap() {
    return internalGetDialogflowIntents().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. All the matched Dialogflow intents in the call. The key
   * corresponds to a Dialogflow intent, format:
   * projects/{project}/agent/{agent}/intents/{intent}
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.contactcenterinsights.v1.DialogflowIntent
      getDialogflowIntentsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.contactcenterinsights.v1.DialogflowIntent defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        map = internalGetDialogflowIntents().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. All the matched Dialogflow intents in the call. The key
   * corresponds to a Dialogflow intent, format:
   * projects/{project}/agent/{agent}/intents/{intent}
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.DialogflowIntent getDialogflowIntentsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        map = internalGetDialogflowIntents().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OBFUSCATED_USER_ID_FIELD_NUMBER = 21;

  @SuppressWarnings("serial")
  private volatile java.lang.Object obfuscatedUserId_ = "";
  /**
   *
   *
   * <pre>
   * Obfuscated user ID which the customer sent to us.
   * </pre>
   *
   * <code>string obfuscated_user_id = 21;</code>
   *
   * @return The obfuscatedUserId.
   */
  @java.lang.Override
  public java.lang.String getObfuscatedUserId() {
    java.lang.Object ref = obfuscatedUserId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      obfuscatedUserId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Obfuscated user ID which the customer sent to us.
   * </pre>
   *
   * <code>string obfuscated_user_id = 21;</code>
   *
   * @return The bytes for obfuscatedUserId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObfuscatedUserIdBytes() {
    java.lang.Object ref = obfuscatedUserId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      obfuscatedUserId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (dataSource_ != null) {
      output.writeMessage(2, getDataSource());
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, agentId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (metadataCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_);
    }
    if (transcript_ != null) {
      output.writeMessage(8, getTranscript());
    }
    if (medium_
        != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, medium_);
    }
    if (duration_ != null) {
      output.writeMessage(10, getDuration());
    }
    if (turnCount_ != 0) {
      output.writeInt32(11, turnCount_);
    }
    if (latestAnalysis_ != null) {
      output.writeMessage(12, getLatestAnalysis());
    }
    for (int i = 0; i < runtimeAnnotations_.size(); i++) {
      output.writeMessage(13, runtimeAnnotations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, languageCode_);
    }
    if (expirationCase_ == 15) {
      output.writeMessage(15, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 16) {
      output.writeMessage(16, (com.google.protobuf.Duration) expiration_);
    }
    if (startTime_ != null) {
      output.writeMessage(17, getStartTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetDialogflowIntents(),
        DialogflowIntentsDefaultEntryHolder.defaultEntry,
        18);
    if (latestSummary_ != null) {
      output.writeMessage(20, getLatestSummary());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(obfuscatedUserId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, obfuscatedUserId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (dataSource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataSource());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, agentId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (metadataCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_);
    }
    if (transcript_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTranscript());
    }
    if (medium_
        != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, medium_);
    }
    if (duration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getDuration());
    }
    if (turnCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, turnCount_);
    }
    if (latestAnalysis_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLatestAnalysis());
    }
    for (int i = 0; i < runtimeAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, runtimeAnnotations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, languageCode_);
    }
    if (expirationCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.protobuf.Timestamp) expiration_);
    }
    if (expirationCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.protobuf.Duration) expiration_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getStartTime());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        entry : internalGetDialogflowIntents().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
          dialogflowIntents__ =
              DialogflowIntentsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, dialogflowIntents__);
    }
    if (latestSummary_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getLatestSummary());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(obfuscatedUserId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, obfuscatedUserId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Conversation)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.Conversation other =
        (com.google.cloud.contactcenterinsights.v1.Conversation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasDataSource() != other.hasDataSource()) return false;
    if (hasDataSource()) {
      if (!getDataSource().equals(other.getDataSource())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getAgentId().equals(other.getAgentId())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasTranscript() != other.hasTranscript()) return false;
    if (hasTranscript()) {
      if (!getTranscript().equals(other.getTranscript())) return false;
    }
    if (medium_ != other.medium_) return false;
    if (hasDuration() != other.hasDuration()) return false;
    if (hasDuration()) {
      if (!getDuration().equals(other.getDuration())) return false;
    }
    if (getTurnCount() != other.getTurnCount()) return false;
    if (hasLatestAnalysis() != other.hasLatestAnalysis()) return false;
    if (hasLatestAnalysis()) {
      if (!getLatestAnalysis().equals(other.getLatestAnalysis())) return false;
    }
    if (hasLatestSummary() != other.hasLatestSummary()) return false;
    if (hasLatestSummary()) {
      if (!getLatestSummary().equals(other.getLatestSummary())) return false;
    }
    if (!getRuntimeAnnotationsList().equals(other.getRuntimeAnnotationsList())) return false;
    if (!internalGetDialogflowIntents().equals(other.internalGetDialogflowIntents())) return false;
    if (!getObfuscatedUserId().equals(other.getObfuscatedUserId())) return false;
    if (!getMetadataCase().equals(other.getMetadataCase())) return false;
    switch (metadataCase_) {
      case 7:
        if (!getCallMetadata().equals(other.getCallMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getExpirationCase().equals(other.getExpirationCase())) return false;
    switch (expirationCase_) {
      case 15:
        if (!getExpireTime().equals(other.getExpireTime())) return false;
        break;
      case 16:
        if (!getTtl().equals(other.getTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasDataSource()) {
      hash = (37 * hash) + DATA_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getDataSource().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + AGENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAgentId().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasTranscript()) {
      hash = (37 * hash) + TRANSCRIPT_FIELD_NUMBER;
      hash = (53 * hash) + getTranscript().hashCode();
    }
    hash = (37 * hash) + MEDIUM_FIELD_NUMBER;
    hash = (53 * hash) + medium_;
    if (hasDuration()) {
      hash = (37 * hash) + DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getDuration().hashCode();
    }
    hash = (37 * hash) + TURN_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTurnCount();
    if (hasLatestAnalysis()) {
      hash = (37 * hash) + LATEST_ANALYSIS_FIELD_NUMBER;
      hash = (53 * hash) + getLatestAnalysis().hashCode();
    }
    if (hasLatestSummary()) {
      hash = (37 * hash) + LATEST_SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getLatestSummary().hashCode();
    }
    if (getRuntimeAnnotationsCount() > 0) {
      hash = (37 * hash) + RUNTIME_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeAnnotationsList().hashCode();
    }
    if (!internalGetDialogflowIntents().getMap().isEmpty()) {
      hash = (37 * hash) + DIALOGFLOW_INTENTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDialogflowIntents().hashCode();
    }
    hash = (37 * hash) + OBFUSCATED_USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getObfuscatedUserId().hashCode();
    switch (metadataCase_) {
      case 7:
        hash = (37 * hash) + CALL_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getCallMetadata().hashCode();
        break;
      case 0:
      default:
    }
    switch (expirationCase_) {
      case 15:
        hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getExpireTime().hashCode();
        break;
      case 16:
        hash = (37 * hash) + TTL_FIELD_NUMBER;
        hash = (53 * hash) + getTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.Conversation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The conversation resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Conversation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Conversation)
      com.google.cloud.contactcenterinsights.v1.ConversationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        case 18:
          return internalGetDialogflowIntents();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        case 18:
          return internalGetMutableDialogflowIntents();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Conversation.class,
              com.google.cloud.contactcenterinsights.v1.Conversation.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.Conversation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (callMetadataBuilder_ != null) {
        callMetadataBuilder_.clear();
      }
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.clear();
      }
      if (ttlBuilder_ != null) {
        ttlBuilder_.clear();
      }
      name_ = "";
      dataSource_ = null;
      if (dataSourceBuilder_ != null) {
        dataSourceBuilder_.dispose();
        dataSourceBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      languageCode_ = "";
      agentId_ = "";
      internalGetMutableLabels().clear();
      transcript_ = null;
      if (transcriptBuilder_ != null) {
        transcriptBuilder_.dispose();
        transcriptBuilder_ = null;
      }
      medium_ = 0;
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      turnCount_ = 0;
      latestAnalysis_ = null;
      if (latestAnalysisBuilder_ != null) {
        latestAnalysisBuilder_.dispose();
        latestAnalysisBuilder_ = null;
      }
      latestSummary_ = null;
      if (latestSummaryBuilder_ != null) {
        latestSummaryBuilder_.dispose();
        latestSummaryBuilder_ = null;
      }
      if (runtimeAnnotationsBuilder_ == null) {
        runtimeAnnotations_ = java.util.Collections.emptyList();
      } else {
        runtimeAnnotations_ = null;
        runtimeAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableDialogflowIntents().clear();
      obfuscatedUserId_ = "";
      metadataCase_ = 0;
      metadata_ = null;
      expirationCase_ = 0;
      expiration_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Conversation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.Conversation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation build() {
      com.google.cloud.contactcenterinsights.v1.Conversation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation buildPartial() {
      com.google.cloud.contactcenterinsights.v1.Conversation result =
          new com.google.cloud.contactcenterinsights.v1.Conversation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.Conversation result) {
      if (runtimeAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)) {
          runtimeAnnotations_ = java.util.Collections.unmodifiableList(runtimeAnnotations_);
          bitField0_ = (bitField0_ & ~0x00020000);
        }
        result.runtimeAnnotations_ = runtimeAnnotations_;
      } else {
        result.runtimeAnnotations_ = runtimeAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.Conversation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dataSource_ = dataSourceBuilder_ == null ? dataSource_ : dataSourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.agentId_ = agentId_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.transcript_ = transcriptBuilder_ == null ? transcript_ : transcriptBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.medium_ = medium_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.duration_ = durationBuilder_ == null ? duration_ : durationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.turnCount_ = turnCount_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.latestAnalysis_ =
            latestAnalysisBuilder_ == null ? latestAnalysis_ : latestAnalysisBuilder_.build();
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.latestSummary_ =
            latestSummaryBuilder_ == null ? latestSummary_ : latestSummaryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.dialogflowIntents_ = internalGetDialogflowIntents();
        result.dialogflowIntents_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.obfuscatedUserId_ = obfuscatedUserId_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.contactcenterinsights.v1.Conversation result) {
      result.metadataCase_ = metadataCase_;
      result.metadata_ = this.metadata_;
      if (metadataCase_ == 7 && callMetadataBuilder_ != null) {
        result.metadata_ = callMetadataBuilder_.build();
      }
      result.expirationCase_ = expirationCase_;
      result.expiration_ = this.expiration_;
      if (expirationCase_ == 15 && expireTimeBuilder_ != null) {
        result.expiration_ = expireTimeBuilder_.build();
      }
      if (expirationCase_ == 16 && ttlBuilder_ != null) {
        result.expiration_ = ttlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.Conversation) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.Conversation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.Conversation other) {
      if (other == com.google.cloud.contactcenterinsights.v1.Conversation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDataSource()) {
        mergeDataSource(other.getDataSource());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getAgentId().isEmpty()) {
        agentId_ = other.agentId_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000400;
      if (other.hasTranscript()) {
        mergeTranscript(other.getTranscript());
      }
      if (other.medium_ != 0) {
        setMediumValue(other.getMediumValue());
      }
      if (other.hasDuration()) {
        mergeDuration(other.getDuration());
      }
      if (other.getTurnCount() != 0) {
        setTurnCount(other.getTurnCount());
      }
      if (other.hasLatestAnalysis()) {
        mergeLatestAnalysis(other.getLatestAnalysis());
      }
      if (other.hasLatestSummary()) {
        mergeLatestSummary(other.getLatestSummary());
      }
      if (runtimeAnnotationsBuilder_ == null) {
        if (!other.runtimeAnnotations_.isEmpty()) {
          if (runtimeAnnotations_.isEmpty()) {
            runtimeAnnotations_ = other.runtimeAnnotations_;
            bitField0_ = (bitField0_ & ~0x00020000);
          } else {
            ensureRuntimeAnnotationsIsMutable();
            runtimeAnnotations_.addAll(other.runtimeAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.runtimeAnnotations_.isEmpty()) {
          if (runtimeAnnotationsBuilder_.isEmpty()) {
            runtimeAnnotationsBuilder_.dispose();
            runtimeAnnotationsBuilder_ = null;
            runtimeAnnotations_ = other.runtimeAnnotations_;
            bitField0_ = (bitField0_ & ~0x00020000);
            runtimeAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRuntimeAnnotationsFieldBuilder()
                    : null;
          } else {
            runtimeAnnotationsBuilder_.addAllMessages(other.runtimeAnnotations_);
          }
        }
      }
      internalGetMutableDialogflowIntents().mergeFrom(other.internalGetDialogflowIntents());
      bitField0_ |= 0x00040000;
      if (!other.getObfuscatedUserId().isEmpty()) {
        obfuscatedUserId_ = other.obfuscatedUserId_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      switch (other.getMetadataCase()) {
        case CALL_METADATA:
          {
            mergeCallMetadata(other.getCallMetadata());
            break;
          }
        case METADATA_NOT_SET:
          {
            break;
          }
      }
      switch (other.getExpirationCase()) {
        case EXPIRE_TIME:
          {
            mergeExpireTime(other.getExpireTime());
            break;
          }
        case TTL:
          {
            mergeTtl(other.getTtl());
            break;
          }
        case EXPIRATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDataSourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 34
            case 42:
              {
                agentId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCallMetadataFieldBuilder().getBuilder(), extensionRegistry);
                metadataCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTranscriptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 66
            case 72:
              {
                medium_ = input.readEnum();
                bitField0_ |= 0x00001000;
                break;
              } // case 72
            case 82:
              {
                input.readMessage(getDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 82
            case 88:
              {
                turnCount_ = input.readInt32();
                bitField0_ |= 0x00004000;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getLatestAnalysisFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.parser(),
                        extensionRegistry);
                if (runtimeAnnotationsBuilder_ == null) {
                  ensureRuntimeAnnotationsIsMutable();
                  runtimeAnnotations_.add(m);
                } else {
                  runtimeAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                expirationCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 138
            case 146:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
                    dialogflowIntents__ =
                        input.readMessage(
                            DialogflowIntentsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableDialogflowIntents()
                    .getMutableMap()
                    .put(dialogflowIntents__.getKey(), dialogflowIntents__.getValue());
                bitField0_ |= 0x00040000;
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getLatestSummaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 162
            case 170:
              {
                obfuscatedUserId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 170
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int metadataCase_ = 0;
    private java.lang.Object metadata_;

    public MetadataCase getMetadataCase() {
      return MetadataCase.forNumber(metadataCase_);
    }

    public Builder clearMetadata() {
      metadataCase_ = 0;
      metadata_ = null;
      onChanged();
      return this;
    }

    private int expirationCase_ = 0;
    private java.lang.Object expiration_;

    public ExpirationCase getExpirationCase() {
      return ExpirationCase.forNumber(expirationCase_);
    }

    public Builder clearExpiration() {
      expirationCase_ = 0;
      expiration_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata,
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder>
        callMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     *
     * @return Whether the callMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCallMetadata() {
      return metadataCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     *
     * @return The callMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata getCallMetadata() {
      if (callMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
            .getDefaultInstance();
      } else {
        if (metadataCase_ == 7) {
          return callMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    public Builder setCallMetadata(
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata value) {
      if (callMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
        onChanged();
      } else {
        callMetadataBuilder_.setMessage(value);
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    public Builder setCallMetadata(
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder
            builderForValue) {
      if (callMetadataBuilder_ == null) {
        metadata_ = builderForValue.build();
        onChanged();
      } else {
        callMetadataBuilder_.setMessage(builderForValue.build());
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    public Builder mergeCallMetadata(
        com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata value) {
      if (callMetadataBuilder_ == null) {
        if (metadataCase_ == 7
            && metadata_
                != com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
                    .getDefaultInstance()) {
          metadata_ =
              com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata)
                          metadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          metadata_ = value;
        }
        onChanged();
      } else {
        if (metadataCase_ == 7) {
          callMetadataBuilder_.mergeFrom(value);
        } else {
          callMetadataBuilder_.setMessage(value);
        }
      }
      metadataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    public Builder clearCallMetadata() {
      if (callMetadataBuilder_ == null) {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
          onChanged();
        }
      } else {
        if (metadataCase_ == 7) {
          metadataCase_ = 0;
          metadata_ = null;
        }
        callMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder
        getCallMetadataBuilder() {
      return getCallMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder
        getCallMetadataOrBuilder() {
      if ((metadataCase_ == 7) && (callMetadataBuilder_ != null)) {
        return callMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (metadataCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Call-specific metadata.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata call_metadata = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata,
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder>
        getCallMetadataFieldBuilder() {
      if (callMetadataBuilder_ == null) {
        if (!(metadataCase_ == 7)) {
          metadata_ =
              com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata
                  .getDefaultInstance();
        }
        callMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata,
                com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.Conversation.CallMetadata) metadata_,
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      metadataCase_ = 7;
      onChanged();
      return callMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     *
     * @return Whether the expireTime field is set.
     */
    @java.lang.Override
    public boolean hasExpireTime() {
      return expirationCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     *
     * @return The expireTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 15) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (expirationCase_ == 15) {
          return expireTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      expirationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 15
            && expiration_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 15) {
          expireTimeBuilder_.mergeFrom(value);
        } else {
          expireTimeBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    public Builder clearExpireTime() {
      if (expireTimeBuilder_ == null) {
        if (expirationCase_ == 15) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 15) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        expireTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if ((expirationCase_ == 15) && (expireTimeBuilder_ != null)) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 15) {
          return (com.google.protobuf.Timestamp) expiration_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which this conversation should expire. After this time, the
     * conversation data and any associated analyses will be deleted.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        if (!(expirationCase_ == 15)) {
          expiration_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 15;
      onChanged();
      return expireTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return Whether the ttl field is set.
     */
    @java.lang.Override
    public boolean hasTtl() {
      return expirationCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The ttl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 16) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (expirationCase_ == 16) {
          return ttlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expiration_ = value;
        onChanged();
      } else {
        ttlBuilder_.setMessage(value);
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        expiration_ = builderForValue.build();
        onChanged();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 16
            && expiration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          expiration_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) expiration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          expiration_ = value;
        }
        onChanged();
      } else {
        if (expirationCase_ == 16) {
          ttlBuilder_.mergeFrom(value);
        } else {
          ttlBuilder_.setMessage(value);
        }
      }
      expirationCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public Builder clearTtl() {
      if (ttlBuilder_ == null) {
        if (expirationCase_ == 16) {
          expirationCase_ = 0;
          expiration_ = null;
          onChanged();
        }
      } else {
        if (expirationCase_ == 16) {
          expirationCase_ = 0;
          expiration_ = null;
        }
        ttlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      return getTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if ((expirationCase_ == 16) && (ttlBuilder_ != null)) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        if (expirationCase_ == 16) {
          return (com.google.protobuf.Duration) expiration_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The TTL for this resource. If specified, then this TTL will
     * be used to calculate the expire time.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 16 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        if (!(expirationCase_ == 16)) {
          expiration_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) expiration_, getParentForChildren(), isClean());
        expiration_ = null;
      }
      expirationCase_ = 16;
      onChanged();
      return ttlBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the conversation.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the conversation.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the conversation.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the conversation.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the conversation.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.ConversationDataSource dataSource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationDataSource,
            com.google.cloud.contactcenterinsights.v1.ConversationDataSource.Builder,
            com.google.cloud.contactcenterinsights.v1.ConversationDataSourceOrBuilder>
        dataSourceBuilder_;
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     *
     * @return Whether the dataSource field is set.
     */
    public boolean hasDataSource() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     *
     * @return The dataSource.
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationDataSource getDataSource() {
      if (dataSourceBuilder_ == null) {
        return dataSource_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationDataSource.getDefaultInstance()
            : dataSource_;
      } else {
        return dataSourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public Builder setDataSource(
        com.google.cloud.contactcenterinsights.v1.ConversationDataSource value) {
      if (dataSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataSource_ = value;
      } else {
        dataSourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public Builder setDataSource(
        com.google.cloud.contactcenterinsights.v1.ConversationDataSource.Builder builderForValue) {
      if (dataSourceBuilder_ == null) {
        dataSource_ = builderForValue.build();
      } else {
        dataSourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public Builder mergeDataSource(
        com.google.cloud.contactcenterinsights.v1.ConversationDataSource value) {
      if (dataSourceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && dataSource_ != null
            && dataSource_
                != com.google.cloud.contactcenterinsights.v1.ConversationDataSource
                    .getDefaultInstance()) {
          getDataSourceBuilder().mergeFrom(value);
        } else {
          dataSource_ = value;
        }
      } else {
        dataSourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public Builder clearDataSource() {
      bitField0_ = (bitField0_ & ~0x00000010);
      dataSource_ = null;
      if (dataSourceBuilder_ != null) {
        dataSourceBuilder_.dispose();
        dataSourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationDataSource.Builder
        getDataSourceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDataSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationDataSourceOrBuilder
        getDataSourceOrBuilder() {
      if (dataSourceBuilder_ != null) {
        return dataSourceBuilder_.getMessageOrBuilder();
      } else {
        return dataSource_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationDataSource.getDefaultInstance()
            : dataSource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The source of the audio and transcription for the conversation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationDataSource data_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationDataSource,
            com.google.cloud.contactcenterinsights.v1.ConversationDataSource.Builder,
            com.google.cloud.contactcenterinsights.v1.ConversationDataSourceOrBuilder>
        getDataSourceFieldBuilder() {
      if (dataSourceBuilder_ == null) {
        dataSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ConversationDataSource,
                com.google.cloud.contactcenterinsights.v1.ConversationDataSource.Builder,
                com.google.cloud.contactcenterinsights.v1.ConversationDataSourceOrBuilder>(
                getDataSource(), getParentForChildren(), isClean());
        dataSource_ = null;
      }
      return dataSourceBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the conversation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the conversation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the conversation started.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * A user-specified language code for the conversation.
     * </pre>
     *
     * <code>string language_code = 14;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-specified language code for the conversation.
     * </pre>
     *
     * <code>string language_code = 14;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-specified language code for the conversation.
     * </pre>
     *
     * <code>string language_code = 14;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-specified language code for the conversation.
     * </pre>
     *
     * <code>string language_code = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-specified language code for the conversation.
     * </pre>
     *
     * <code>string language_code = 14;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object agentId_ = "";
    /**
     *
     *
     * <pre>
     * An opaque, user-specified string representing the human agent who handled
     * the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return The agentId.
     */
    public java.lang.String getAgentId() {
      java.lang.Object ref = agentId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque, user-specified string representing the human agent who handled
     * the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return The bytes for agentId.
     */
    public com.google.protobuf.ByteString getAgentIdBytes() {
      java.lang.Object ref = agentId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque, user-specified string representing the human agent who handled
     * the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @param value The agentId to set.
     * @return This builder for chaining.
     */
    public Builder setAgentId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque, user-specified string representing the human agent who handled
     * the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentId() {
      agentId_ = getDefaultInstance().getAgentId();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque, user-specified string representing the human agent who handled
     * the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @param value The bytes for agentId to set.
     * @return This builder for chaining.
     */
    public Builder setAgentIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentId_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000400;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map for the user to specify any custom fields. A maximum of 20 labels per
     * conversation is allowed, with a maximum of 256 characters per entry.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder,
            com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder>
        transcriptBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the transcript field is set.
     */
    public boolean hasTranscript() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The transcript.
     */
    public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript getTranscript() {
      if (transcriptBuilder_ == null) {
        return transcript_ == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.getDefaultInstance()
            : transcript_;
      } else {
        return transcriptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTranscript(
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript value) {
      if (transcriptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transcript_ = value;
      } else {
        transcriptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTranscript(
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder builderForValue) {
      if (transcriptBuilder_ == null) {
        transcript_ = builderForValue.build();
      } else {
        transcriptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeTranscript(
        com.google.cloud.contactcenterinsights.v1.Conversation.Transcript value) {
      if (transcriptBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && transcript_ != null
            && transcript_
                != com.google.cloud.contactcenterinsights.v1.Conversation.Transcript
                    .getDefaultInstance()) {
          getTranscriptBuilder().mergeFrom(value);
        } else {
          transcript_ = value;
        }
      } else {
        transcriptBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTranscript() {
      bitField0_ = (bitField0_ & ~0x00000800);
      transcript_ = null;
      if (transcriptBuilder_ != null) {
        transcriptBuilder_.dispose();
        transcriptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder
        getTranscriptBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getTranscriptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder
        getTranscriptOrBuilder() {
      if (transcriptBuilder_ != null) {
        return transcriptBuilder_.getMessageOrBuilder();
      } else {
        return transcript_ == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.getDefaultInstance()
            : transcript_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation transcript.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Transcript transcript = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript,
            com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder,
            com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder>
        getTranscriptFieldBuilder() {
      if (transcriptBuilder_ == null) {
        transcriptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript,
                com.google.cloud.contactcenterinsights.v1.Conversation.Transcript.Builder,
                com.google.cloud.contactcenterinsights.v1.Conversation.TranscriptOrBuilder>(
                getTranscript(), getParentForChildren(), isClean());
        transcript_ = null;
      }
      return transcriptBuilder_;
    }

    private int medium_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The conversation medium, if unspecified will default to
     * PHONE_CALL.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for medium.
     */
    @java.lang.Override
    public int getMediumValue() {
      return medium_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The conversation medium, if unspecified will default to
     * PHONE_CALL.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for medium to set.
     * @return This builder for chaining.
     */
    public Builder setMediumValue(int value) {
      medium_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The conversation medium, if unspecified will default to
     * PHONE_CALL.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The medium.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
      com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
          com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The conversation medium, if unspecified will default to
     * PHONE_CALL.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The medium to set.
     * @return This builder for chaining.
     */
    public Builder setMedium(com.google.cloud.contactcenterinsights.v1.Conversation.Medium value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00001000;
      medium_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The conversation medium, if unspecified will default to
     * PHONE_CALL.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 9 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMedium() {
      bitField0_ = (bitField0_ & ~0x00001000);
      medium_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration duration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        durationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the duration field is set.
     */
    public boolean hasDuration() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The duration.
     */
    public com.google.protobuf.Duration getDuration() {
      if (durationBuilder_ == null) {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      } else {
        return durationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        duration_ = value;
      } else {
        durationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (durationBuilder_ == null) {
        duration_ = builderForValue.build();
      } else {
        durationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDuration(com.google.protobuf.Duration value) {
      if (durationBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && duration_ != null
            && duration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDurationBuilder().mergeFrom(value);
        } else {
          duration_ = value;
        }
      } else {
        durationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDuration() {
      bitField0_ = (bitField0_ & ~0x00002000);
      duration_ = null;
      if (durationBuilder_ != null) {
        durationBuilder_.dispose();
        durationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getDurationBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getDurationOrBuilder() {
      if (durationBuilder_ != null) {
        return durationBuilder_.getMessageOrBuilder();
      } else {
        return duration_ == null ? com.google.protobuf.Duration.getDefaultInstance() : duration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The duration of the conversation.
     * </pre>
     *
     * <code>.google.protobuf.Duration duration = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDurationFieldBuilder() {
      if (durationBuilder_ == null) {
        durationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDuration(), getParentForChildren(), isClean());
        duration_ = null;
      }
      return durationBuilder_;
    }

    private int turnCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of turns in the conversation.
     * </pre>
     *
     * <code>int32 turn_count = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The turnCount.
     */
    @java.lang.Override
    public int getTurnCount() {
      return turnCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of turns in the conversation.
     * </pre>
     *
     * <code>int32 turn_count = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The turnCount to set.
     * @return This builder for chaining.
     */
    public Builder setTurnCount(int value) {

      turnCount_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of turns in the conversation.
     * </pre>
     *
     * <code>int32 turn_count = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTurnCount() {
      bitField0_ = (bitField0_ & ~0x00004000);
      turnCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.Analysis latestAnalysis_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Analysis,
            com.google.cloud.contactcenterinsights.v1.Analysis.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder>
        latestAnalysisBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the latestAnalysis field is set.
     */
    public boolean hasLatestAnalysis() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestAnalysis.
     */
    public com.google.cloud.contactcenterinsights.v1.Analysis getLatestAnalysis() {
      if (latestAnalysisBuilder_ == null) {
        return latestAnalysis_ == null
            ? com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance()
            : latestAnalysis_;
      } else {
        return latestAnalysisBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestAnalysis(com.google.cloud.contactcenterinsights.v1.Analysis value) {
      if (latestAnalysisBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestAnalysis_ = value;
      } else {
        latestAnalysisBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestAnalysis(
        com.google.cloud.contactcenterinsights.v1.Analysis.Builder builderForValue) {
      if (latestAnalysisBuilder_ == null) {
        latestAnalysis_ = builderForValue.build();
      } else {
        latestAnalysisBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLatestAnalysis(com.google.cloud.contactcenterinsights.v1.Analysis value) {
      if (latestAnalysisBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && latestAnalysis_ != null
            && latestAnalysis_
                != com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance()) {
          getLatestAnalysisBuilder().mergeFrom(value);
        } else {
          latestAnalysis_ = value;
        }
      } else {
        latestAnalysisBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLatestAnalysis() {
      bitField0_ = (bitField0_ & ~0x00008000);
      latestAnalysis_ = null;
      if (latestAnalysisBuilder_ != null) {
        latestAnalysisBuilder_.dispose();
        latestAnalysisBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Analysis.Builder getLatestAnalysisBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getLatestAnalysisFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder
        getLatestAnalysisOrBuilder() {
      if (latestAnalysisBuilder_ != null) {
        return latestAnalysisBuilder_.getMessageOrBuilder();
      } else {
        return latestAnalysis_ == null
            ? com.google.cloud.contactcenterinsights.v1.Analysis.getDefaultInstance()
            : latestAnalysis_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The conversation's latest analysis, if one exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Analysis latest_analysis = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Analysis,
            com.google.cloud.contactcenterinsights.v1.Analysis.Builder,
            com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder>
        getLatestAnalysisFieldBuilder() {
      if (latestAnalysisBuilder_ == null) {
        latestAnalysisBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Analysis,
                com.google.cloud.contactcenterinsights.v1.Analysis.Builder,
                com.google.cloud.contactcenterinsights.v1.AnalysisOrBuilder>(
                getLatestAnalysis(), getParentForChildren(), isClean());
        latestAnalysis_ = null;
      }
      return latestAnalysisBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
        latestSummary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .Builder,
            com.google.cloud.contactcenterinsights.v1
                .ConversationSummarizationSuggestionDataOrBuilder>
        latestSummaryBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the latestSummary field is set.
     */
    public boolean hasLatestSummary() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The latestSummary.
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
        getLatestSummary() {
      if (latestSummaryBuilder_ == null) {
        return latestSummary_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .getDefaultInstance()
            : latestSummary_;
      } else {
        return latestSummaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestSummary(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData value) {
      if (latestSummaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latestSummary_ = value;
      } else {
        latestSummaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLatestSummary(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData.Builder
            builderForValue) {
      if (latestSummaryBuilder_ == null) {
        latestSummary_ = builderForValue.build();
      } else {
        latestSummaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLatestSummary(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData value) {
      if (latestSummaryBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && latestSummary_ != null
            && latestSummary_
                != com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                    .getDefaultInstance()) {
          getLatestSummaryBuilder().mergeFrom(value);
        } else {
          latestSummary_ = value;
        }
      } else {
        latestSummaryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLatestSummary() {
      bitField0_ = (bitField0_ & ~0x00010000);
      latestSummary_ = null;
      if (latestSummaryBuilder_ != null) {
        latestSummaryBuilder_.dispose();
        latestSummaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData.Builder
        getLatestSummaryBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getLatestSummaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1
            .ConversationSummarizationSuggestionDataOrBuilder
        getLatestSummaryOrBuilder() {
      if (latestSummaryBuilder_ != null) {
        return latestSummaryBuilder_.getMessageOrBuilder();
      } else {
        return latestSummary_ == null
            ? com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .getDefaultInstance()
            : latestSummary_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Latest summary of the conversation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData latest_summary = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .Builder,
            com.google.cloud.contactcenterinsights.v1
                .ConversationSummarizationSuggestionDataOrBuilder>
        getLatestSummaryFieldBuilder() {
      if (latestSummaryBuilder_ == null) {
        latestSummaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
                com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                    .Builder,
                com.google.cloud.contactcenterinsights.v1
                    .ConversationSummarizationSuggestionDataOrBuilder>(
                getLatestSummary(), getParentForChildren(), isClean());
        latestSummary_ = null;
      }
      return latestSummaryBuilder_;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>
        runtimeAnnotations_ = java.util.Collections.emptyList();

    private void ensureRuntimeAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00020000) != 0)) {
        runtimeAnnotations_ =
            new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>(
                runtimeAnnotations_);
        bitField0_ |= 0x00020000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder>
        runtimeAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>
        getRuntimeAnnotationsList() {
      if (runtimeAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(runtimeAnnotations_);
      } else {
        return runtimeAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getRuntimeAnnotationsCount() {
      if (runtimeAnnotationsBuilder_ == null) {
        return runtimeAnnotations_.size();
      } else {
        return runtimeAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation getRuntimeAnnotations(
        int index) {
      if (runtimeAnnotationsBuilder_ == null) {
        return runtimeAnnotations_.get(index);
      } else {
        return runtimeAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeAnnotations(
        int index, com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation value) {
      if (runtimeAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.set(index, value);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeAnnotations(
        int index,
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder builderForValue) {
      if (runtimeAnnotationsBuilder_ == null) {
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRuntimeAnnotations(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation value) {
      if (runtimeAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.add(value);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRuntimeAnnotations(
        int index, com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation value) {
      if (runtimeAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.add(index, value);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRuntimeAnnotations(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder builderForValue) {
      if (runtimeAnnotationsBuilder_ == null) {
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRuntimeAnnotations(
        int index,
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder builderForValue) {
      if (runtimeAnnotationsBuilder_ == null) {
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllRuntimeAnnotations(
        java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation>
            values) {
      if (runtimeAnnotationsBuilder_ == null) {
        ensureRuntimeAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, runtimeAnnotations_);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRuntimeAnnotations() {
      if (runtimeAnnotationsBuilder_ == null) {
        runtimeAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00020000);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeRuntimeAnnotations(int index) {
      if (runtimeAnnotationsBuilder_ == null) {
        ensureRuntimeAnnotationsIsMutable();
        runtimeAnnotations_.remove(index);
        onChanged();
      } else {
        runtimeAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder
        getRuntimeAnnotationsBuilder(int index) {
      return getRuntimeAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder
        getRuntimeAnnotationsOrBuilder(int index) {
      if (runtimeAnnotationsBuilder_ == null) {
        return runtimeAnnotations_.get(index);
      } else {
        return runtimeAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder>
        getRuntimeAnnotationsOrBuilderList() {
      if (runtimeAnnotationsBuilder_ != null) {
        return runtimeAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(runtimeAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder
        addRuntimeAnnotationsBuilder() {
      return getRuntimeAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder
        addRuntimeAnnotationsBuilder(int index) {
      return getRuntimeAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The annotations that were generated during the customer and
     * agent interaction.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.RuntimeAnnotation runtime_annotations = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder>
        getRuntimeAnnotationsBuilderList() {
      return getRuntimeAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder>
        getRuntimeAnnotationsFieldBuilder() {
      if (runtimeAnnotationsBuilder_ == null) {
        runtimeAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation,
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder,
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder>(
                runtimeAnnotations_,
                ((bitField0_ & 0x00020000) != 0),
                getParentForChildren(),
                isClean());
        runtimeAnnotations_ = null;
      }
      return runtimeAnnotationsBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        dialogflowIntents_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        internalGetDialogflowIntents() {
      if (dialogflowIntents_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DialogflowIntentsDefaultEntryHolder.defaultEntry);
      }
      return dialogflowIntents_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        internalGetMutableDialogflowIntents() {
      if (dialogflowIntents_ == null) {
        dialogflowIntents_ =
            com.google.protobuf.MapField.newMapField(
                DialogflowIntentsDefaultEntryHolder.defaultEntry);
      }
      if (!dialogflowIntents_.isMutable()) {
        dialogflowIntents_ = dialogflowIntents_.copy();
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return dialogflowIntents_;
    }

    public int getDialogflowIntentsCount() {
      return internalGetDialogflowIntents().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsDialogflowIntents(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDialogflowIntents().getMap().containsKey(key);
    }
    /** Use {@link #getDialogflowIntentsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        getDialogflowIntents() {
      return getDialogflowIntentsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        getDialogflowIntentsMap() {
      return internalGetDialogflowIntents().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.DialogflowIntent
        getDialogflowIntentsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.contactcenterinsights.v1.DialogflowIntent defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
          map = internalGetDialogflowIntents().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DialogflowIntent getDialogflowIntentsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
          map = internalGetDialogflowIntents().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDialogflowIntents() {
      bitField0_ = (bitField0_ & ~0x00040000);
      internalGetMutableDialogflowIntents().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeDialogflowIntents(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDialogflowIntents().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
        getMutableDialogflowIntents() {
      bitField0_ |= 0x00040000;
      return internalGetMutableDialogflowIntents().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putDialogflowIntents(
        java.lang.String key, com.google.cloud.contactcenterinsights.v1.DialogflowIntent value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDialogflowIntents().getMutableMap().put(key, value);
      bitField0_ |= 0x00040000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. All the matched Dialogflow intents in the call. The key
     * corresponds to a Dialogflow intent, format:
     * projects/{project}/agent/{agent}/intents/{intent}
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.DialogflowIntent&gt; dialogflow_intents = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllDialogflowIntents(
        java.util.Map<java.lang.String, com.google.cloud.contactcenterinsights.v1.DialogflowIntent>
            values) {
      internalGetMutableDialogflowIntents().getMutableMap().putAll(values);
      bitField0_ |= 0x00040000;
      return this;
    }

    private java.lang.Object obfuscatedUserId_ = "";
    /**
     *
     *
     * <pre>
     * Obfuscated user ID which the customer sent to us.
     * </pre>
     *
     * <code>string obfuscated_user_id = 21;</code>
     *
     * @return The obfuscatedUserId.
     */
    public java.lang.String getObfuscatedUserId() {
      java.lang.Object ref = obfuscatedUserId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        obfuscatedUserId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID which the customer sent to us.
     * </pre>
     *
     * <code>string obfuscated_user_id = 21;</code>
     *
     * @return The bytes for obfuscatedUserId.
     */
    public com.google.protobuf.ByteString getObfuscatedUserIdBytes() {
      java.lang.Object ref = obfuscatedUserId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        obfuscatedUserId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID which the customer sent to us.
     * </pre>
     *
     * <code>string obfuscated_user_id = 21;</code>
     *
     * @param value The obfuscatedUserId to set.
     * @return This builder for chaining.
     */
    public Builder setObfuscatedUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      obfuscatedUserId_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID which the customer sent to us.
     * </pre>
     *
     * <code>string obfuscated_user_id = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObfuscatedUserId() {
      obfuscatedUserId_ = getDefaultInstance().getObfuscatedUserId();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID which the customer sent to us.
     * </pre>
     *
     * <code>string obfuscated_user_id = 21;</code>
     *
     * @param value The bytes for obfuscatedUserId to set.
     * @return This builder for chaining.
     */
    public Builder setObfuscatedUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      obfuscatedUserId_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Conversation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Conversation)
  private static final com.google.cloud.contactcenterinsights.v1.Conversation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Conversation();
  }

  public static com.google.cloud.contactcenterinsights.v1.Conversation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Conversation> PARSER =
      new com.google.protobuf.AbstractParser<Conversation>() {
        @java.lang.Override
        public Conversation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Conversation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Conversation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Conversation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
