/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Agent Assist frequently-asked-question answer data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.FaqAnswerData}
 */
public final class FaqAnswerData extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.FaqAnswerData)
    FaqAnswerDataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FaqAnswerData.newBuilder() to construct.
  private FaqAnswerData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FaqAnswerData() {
    answer_ = "";
    question_ = "";
    queryRecord_ = "";
    source_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FaqAnswerData();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData.class,
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder.class);
  }

  public static final int ANSWER_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answer_ = "";
  /**
   *
   *
   * <pre>
   * The piece of text from the `source` knowledge base document.
   * </pre>
   *
   * <code>string answer = 1;</code>
   *
   * @return The answer.
   */
  @java.lang.Override
  public java.lang.String getAnswer() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answer_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The piece of text from the `source` knowledge base document.
   * </pre>
   *
   * <code>string answer = 1;</code>
   *
   * @return The bytes for answer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerBytes() {
    java.lang.Object ref = answer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIDENCE_SCORE_FIELD_NUMBER = 2;
  private float confidenceScore_ = 0F;
  /**
   *
   *
   * <pre>
   * The system's confidence score that this answer is a good match for this
   * conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
   * certain).
   * </pre>
   *
   * <code>float confidence_score = 2;</code>
   *
   * @return The confidenceScore.
   */
  @java.lang.Override
  public float getConfidenceScore() {
    return confidenceScore_;
  }

  public static final int QUESTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object question_ = "";
  /**
   *
   *
   * <pre>
   * The corresponding FAQ question.
   * </pre>
   *
   * <code>string question = 3;</code>
   *
   * @return The question.
   */
  @java.lang.Override
  public java.lang.String getQuestion() {
    java.lang.Object ref = question_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      question_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The corresponding FAQ question.
   * </pre>
   *
   * <code>string question = 3;</code>
   *
   * @return The bytes for question.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuestionBytes() {
    java.lang.Object ref = question_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      question_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 4;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Map that contains metadata about the FAQ answer and the document that
   * it originates from.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }
  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }
  /**
   *
   *
   * <pre>
   * Map that contains metadata about the FAQ answer and the document that
   * it originates from.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }
  /**
   *
   *
   * <pre>
   * Map that contains metadata about the FAQ answer and the document that
   * it originates from.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Map that contains metadata about the FAQ answer and the document that
   * it originates from.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int QUERY_RECORD_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object queryRecord_ = "";
  /**
   *
   *
   * <pre>
   * The name of the answer record.
   * Format:
   * projects/{project}/locations/{location}/answerRecords/{answer_record}
   * </pre>
   *
   * <code>string query_record = 5;</code>
   *
   * @return The queryRecord.
   */
  @java.lang.Override
  public java.lang.String getQueryRecord() {
    java.lang.Object ref = queryRecord_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryRecord_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the answer record.
   * Format:
   * projects/{project}/locations/{location}/answerRecords/{answer_record}
   * </pre>
   *
   * <code>string query_record = 5;</code>
   *
   * @return The bytes for queryRecord.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryRecordBytes() {
    java.lang.Object ref = queryRecord_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryRecord_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object source_ = "";
  /**
   *
   *
   * <pre>
   * The knowledge document that this answer was extracted from.
   * Format:
   * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
   * </pre>
   *
   * <code>string source = 6;</code>
   *
   * @return The source.
   */
  @java.lang.Override
  public java.lang.String getSource() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      source_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The knowledge document that this answer was extracted from.
   * Format:
   * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
   * </pre>
   *
   * <code>string source = 6;</code>
   *
   * @return The bytes for source.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBytes() {
    java.lang.Object ref = source_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      source_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, answer_);
    }
    if (java.lang.Float.floatToRawIntBits(confidenceScore_) != 0) {
      output.writeFloat(2, confidenceScore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, question_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryRecord_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, queryRecord_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answer_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, answer_);
    }
    if (java.lang.Float.floatToRawIntBits(confidenceScore_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, confidenceScore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, question_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, metadata__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryRecord_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, queryRecord_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.FaqAnswerData)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.FaqAnswerData other =
        (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) obj;

    if (!getAnswer().equals(other.getAnswer())) return false;
    if (java.lang.Float.floatToIntBits(getConfidenceScore())
        != java.lang.Float.floatToIntBits(other.getConfidenceScore())) return false;
    if (!getQuestion().equals(other.getQuestion())) return false;
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (!getQueryRecord().equals(other.getQueryRecord())) return false;
    if (!getSource().equals(other.getSource())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANSWER_FIELD_NUMBER;
    hash = (53 * hash) + getAnswer().hashCode();
    hash = (37 * hash) + CONFIDENCE_SCORE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceScore());
    hash = (37 * hash) + QUESTION_FIELD_NUMBER;
    hash = (53 * hash) + getQuestion().hashCode();
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    hash = (37 * hash) + QUERY_RECORD_FIELD_NUMBER;
    hash = (53 * hash) + getQueryRecord().hashCode();
    hash = (37 * hash) + SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getSource().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.FaqAnswerData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Agent Assist frequently-asked-question answer data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.FaqAnswerData}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.FaqAnswerData)
      com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.FaqAnswerData.class,
              com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.FaqAnswerData.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      answer_ = "";
      confidenceScore_ = 0F;
      question_ = "";
      internalGetMutableMetadata().clear();
      queryRecord_ = "";
      source_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FaqAnswerData_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerData getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerData build() {
      com.google.cloud.contactcenterinsights.v1.FaqAnswerData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerData buildPartial() {
      com.google.cloud.contactcenterinsights.v1.FaqAnswerData result =
          new com.google.cloud.contactcenterinsights.v1.FaqAnswerData(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.FaqAnswerData result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.answer_ = answer_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.confidenceScore_ = confidenceScore_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.question_ = question_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.queryRecord_ = queryRecord_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.source_ = source_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.FaqAnswerData) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.FaqAnswerData) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.FaqAnswerData other) {
      if (other == com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance())
        return this;
      if (!other.getAnswer().isEmpty()) {
        answer_ = other.answer_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getConfidenceScore() != 0F) {
        setConfidenceScore(other.getConfidenceScore());
      }
      if (!other.getQuestion().isEmpty()) {
        question_ = other.question_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x00000008;
      if (!other.getQueryRecord().isEmpty()) {
        queryRecord_ = other.queryRecord_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getSource().isEmpty()) {
        source_ = other.source_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                answer_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 21:
              {
                confidenceScore_ = input.readFloat();
                bitField0_ |= 0x00000002;
                break;
              } // case 21
            case 26:
              {
                question_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                queryRecord_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                source_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object answer_ = "";
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The answer.
     */
    public java.lang.String getAnswer() {
      java.lang.Object ref = answer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return The bytes for answer.
     */
    public com.google.protobuf.ByteString getAnswerBytes() {
      java.lang.Object ref = answer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @param value The answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswer() {
      answer_ = getDefaultInstance().getAnswer();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The piece of text from the `source` knowledge base document.
     * </pre>
     *
     * <code>string answer = 1;</code>
     *
     * @param value The bytes for answer to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answer_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private float confidenceScore_;
    /**
     *
     *
     * <pre>
     * The system's confidence score that this answer is a good match for this
     * conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
     * certain).
     * </pre>
     *
     * <code>float confidence_score = 2;</code>
     *
     * @return The confidenceScore.
     */
    @java.lang.Override
    public float getConfidenceScore() {
      return confidenceScore_;
    }
    /**
     *
     *
     * <pre>
     * The system's confidence score that this answer is a good match for this
     * conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
     * certain).
     * </pre>
     *
     * <code>float confidence_score = 2;</code>
     *
     * @param value The confidenceScore to set.
     * @return This builder for chaining.
     */
    public Builder setConfidenceScore(float value) {

      confidenceScore_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The system's confidence score that this answer is a good match for this
     * conversation, ranging from 0.0 (completely uncertain) to 1.0 (completely
     * certain).
     * </pre>
     *
     * <code>float confidence_score = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConfidenceScore() {
      bitField0_ = (bitField0_ & ~0x00000002);
      confidenceScore_ = 0F;
      onChanged();
      return this;
    }

    private java.lang.Object question_ = "";
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The question.
     */
    public java.lang.String getQuestion() {
      java.lang.Object ref = question_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        question_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return The bytes for question.
     */
    public com.google.protobuf.ByteString getQuestionBytes() {
      java.lang.Object ref = question_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        question_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @param value The question to set.
     * @return This builder for chaining.
     */
    public Builder setQuestion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      question_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuestion() {
      question_ = getDefaultInstance().getQuestion();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The corresponding FAQ question.
     * </pre>
     *
     * <code>string question = 3;</code>
     *
     * @param value The bytes for question to set.
     * @return This builder for chaining.
     */
    public Builder setQuestionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      question_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }
    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x00000008;
      return internalGetMutableMetadata().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Map that contains metadata about the FAQ answer and the document that
     * it originates from.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 4;</code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object queryRecord_ = "";
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format:
     * projects/{project}/locations/{location}/answerRecords/{answer_record}
     * </pre>
     *
     * <code>string query_record = 5;</code>
     *
     * @return The queryRecord.
     */
    public java.lang.String getQueryRecord() {
      java.lang.Object ref = queryRecord_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryRecord_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format:
     * projects/{project}/locations/{location}/answerRecords/{answer_record}
     * </pre>
     *
     * <code>string query_record = 5;</code>
     *
     * @return The bytes for queryRecord.
     */
    public com.google.protobuf.ByteString getQueryRecordBytes() {
      java.lang.Object ref = queryRecord_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryRecord_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format:
     * projects/{project}/locations/{location}/answerRecords/{answer_record}
     * </pre>
     *
     * <code>string query_record = 5;</code>
     *
     * @param value The queryRecord to set.
     * @return This builder for chaining.
     */
    public Builder setQueryRecord(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryRecord_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format:
     * projects/{project}/locations/{location}/answerRecords/{answer_record}
     * </pre>
     *
     * <code>string query_record = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryRecord() {
      queryRecord_ = getDefaultInstance().getQueryRecord();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the answer record.
     * Format:
     * projects/{project}/locations/{location}/answerRecords/{answer_record}
     * </pre>
     *
     * <code>string query_record = 5;</code>
     *
     * @param value The bytes for queryRecord to set.
     * @return This builder for chaining.
     */
    public Builder setQueryRecordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryRecord_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * The knowledge document that this answer was extracted from.
     * Format:
     * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
     * </pre>
     *
     * <code>string source = 6;</code>
     *
     * @return The source.
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The knowledge document that this answer was extracted from.
     * Format:
     * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
     * </pre>
     *
     * <code>string source = 6;</code>
     *
     * @return The bytes for source.
     */
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The knowledge document that this answer was extracted from.
     * Format:
     * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
     * </pre>
     *
     * <code>string source = 6;</code>
     *
     * @param value The source to set.
     * @return This builder for chaining.
     */
    public Builder setSource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      source_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The knowledge document that this answer was extracted from.
     * Format:
     * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
     * </pre>
     *
     * <code>string source = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSource() {
      source_ = getDefaultInstance().getSource();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The knowledge document that this answer was extracted from.
     * Format:
     * projects/{project}/knowledgeBases/{knowledge_base}/documents/{document}.
     * </pre>
     *
     * <code>string source = 6;</code>
     *
     * @param value The bytes for source to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      source_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.FaqAnswerData)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.FaqAnswerData)
  private static final com.google.cloud.contactcenterinsights.v1.FaqAnswerData DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.FaqAnswerData();
  }

  public static com.google.cloud.contactcenterinsights.v1.FaqAnswerData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FaqAnswerData> PARSER =
      new com.google.protobuf.AbstractParser<FaqAnswerData>() {
        @java.lang.Override
        public FaqAnswerData parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FaqAnswerData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FaqAnswerData> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.FaqAnswerData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
