/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The metadata for an IngestConversations operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.IngestConversationsMetadata}
 */
public final class IngestConversationsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata)
    IngestConversationsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IngestConversationsMetadata.newBuilder() to construct.
  private IngestConversationsMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestConversationsMetadata() {
    partialErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestConversationsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.class,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.Builder.class);
  }

  public interface IngestConversationsStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The number of objects processed during the ingest operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The processedObjectCount.
     */
    int getProcessedObjectCount();

    /**
     *
     *
     * <pre>
     * Output only. The number of objects skipped because another conversation
     * with the same transcript uri had already been ingested.
     * </pre>
     *
     * <code>int32 duplicates_skipped_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The duplicatesSkippedCount.
     */
    int getDuplicatesSkippedCount();

    /**
     *
     *
     * <pre>
     * Output only. The number of new conversations added during this ingest
     * operation.
     * </pre>
     *
     * <code>int32 successful_ingest_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The successfulIngestCount.
     */
    int getSuccessfulIngestCount();

    /**
     *
     *
     * <pre>
     * Output only. The number of objects which were unable to be ingested due
     * to errors. The errors are populated in the partial_errors field.
     * </pre>
     *
     * <code>int32 failed_ingest_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failedIngestCount.
     */
    int getFailedIngestCount();
  }
  /**
   *
   *
   * <pre>
   * Statistics for IngestConversations operation.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats}
   */
  public static final class IngestConversationsStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats)
      IngestConversationsStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngestConversationsStats.newBuilder() to construct.
    private IngestConversationsStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngestConversationsStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IngestConversationsStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_IngestConversationsStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_IngestConversationsStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                  .IngestConversationsStats.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                  .IngestConversationsStats.Builder.class);
    }

    public static final int PROCESSED_OBJECT_COUNT_FIELD_NUMBER = 1;
    private int processedObjectCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The number of objects processed during the ingest operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The processedObjectCount.
     */
    @java.lang.Override
    public int getProcessedObjectCount() {
      return processedObjectCount_;
    }

    public static final int DUPLICATES_SKIPPED_COUNT_FIELD_NUMBER = 2;
    private int duplicatesSkippedCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The number of objects skipped because another conversation
     * with the same transcript uri had already been ingested.
     * </pre>
     *
     * <code>int32 duplicates_skipped_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The duplicatesSkippedCount.
     */
    @java.lang.Override
    public int getDuplicatesSkippedCount() {
      return duplicatesSkippedCount_;
    }

    public static final int SUCCESSFUL_INGEST_COUNT_FIELD_NUMBER = 3;
    private int successfulIngestCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The number of new conversations added during this ingest
     * operation.
     * </pre>
     *
     * <code>int32 successful_ingest_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The successfulIngestCount.
     */
    @java.lang.Override
    public int getSuccessfulIngestCount() {
      return successfulIngestCount_;
    }

    public static final int FAILED_INGEST_COUNT_FIELD_NUMBER = 4;
    private int failedIngestCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The number of objects which were unable to be ingested due
     * to errors. The errors are populated in the partial_errors field.
     * </pre>
     *
     * <code>int32 failed_ingest_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failedIngestCount.
     */
    @java.lang.Override
    public int getFailedIngestCount() {
      return failedIngestCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (processedObjectCount_ != 0) {
        output.writeInt32(1, processedObjectCount_);
      }
      if (duplicatesSkippedCount_ != 0) {
        output.writeInt32(2, duplicatesSkippedCount_);
      }
      if (successfulIngestCount_ != 0) {
        output.writeInt32(3, successfulIngestCount_);
      }
      if (failedIngestCount_ != 0) {
        output.writeInt32(4, failedIngestCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (processedObjectCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, processedObjectCount_);
      }
      if (duplicatesSkippedCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, duplicatesSkippedCount_);
      }
      if (successfulIngestCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, successfulIngestCount_);
      }
      if (failedIngestCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, failedIngestCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .IngestConversationsStats)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats
          other =
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                      .IngestConversationsStats)
                  obj;

      if (getProcessedObjectCount() != other.getProcessedObjectCount()) return false;
      if (getDuplicatesSkippedCount() != other.getDuplicatesSkippedCount()) return false;
      if (getSuccessfulIngestCount() != other.getSuccessfulIngestCount()) return false;
      if (getFailedIngestCount() != other.getFailedIngestCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSED_OBJECT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getProcessedObjectCount();
      hash = (37 * hash) + DUPLICATES_SKIPPED_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getDuplicatesSkippedCount();
      hash = (37 * hash) + SUCCESSFUL_INGEST_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessfulIngestCount();
      hash = (37 * hash) + FAILED_INGEST_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFailedIngestCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistics for IngestConversations operation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats)
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_IngestConversationsStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_IngestConversationsStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats.class,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processedObjectCount_ = 0;
        duplicatesSkippedCount_ = 0;
        successfulIngestCount_ = 0;
        failedIngestCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_IngestConversationsStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .IngestConversationsStats
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .IngestConversationsStats
          build() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .IngestConversationsStats
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats
            result =
                new com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                  .IngestConversationsStats
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processedObjectCount_ = processedObjectCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.duplicatesSkippedCount_ = duplicatesSkippedCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.successfulIngestCount_ = successfulIngestCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.failedIngestCount_ = failedIngestCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                      .IngestConversationsStats)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                  .IngestConversationsStats
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.getDefaultInstance()) return this;
        if (other.getProcessedObjectCount() != 0) {
          setProcessedObjectCount(other.getProcessedObjectCount());
        }
        if (other.getDuplicatesSkippedCount() != 0) {
          setDuplicatesSkippedCount(other.getDuplicatesSkippedCount());
        }
        if (other.getSuccessfulIngestCount() != 0) {
          setSuccessfulIngestCount(other.getSuccessfulIngestCount());
        }
        if (other.getFailedIngestCount() != 0) {
          setFailedIngestCount(other.getFailedIngestCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  processedObjectCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  duplicatesSkippedCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  successfulIngestCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  failedIngestCount_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int processedObjectCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of objects processed during the ingest operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The processedObjectCount.
       */
      @java.lang.Override
      public int getProcessedObjectCount() {
        return processedObjectCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects processed during the ingest operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The processedObjectCount to set.
       * @return This builder for chaining.
       */
      public Builder setProcessedObjectCount(int value) {

        processedObjectCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects processed during the ingest operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessedObjectCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        processedObjectCount_ = 0;
        onChanged();
        return this;
      }

      private int duplicatesSkippedCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of objects skipped because another conversation
       * with the same transcript uri had already been ingested.
       * </pre>
       *
       * <code>int32 duplicates_skipped_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The duplicatesSkippedCount.
       */
      @java.lang.Override
      public int getDuplicatesSkippedCount() {
        return duplicatesSkippedCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects skipped because another conversation
       * with the same transcript uri had already been ingested.
       * </pre>
       *
       * <code>int32 duplicates_skipped_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The duplicatesSkippedCount to set.
       * @return This builder for chaining.
       */
      public Builder setDuplicatesSkippedCount(int value) {

        duplicatesSkippedCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects skipped because another conversation
       * with the same transcript uri had already been ingested.
       * </pre>
       *
       * <code>int32 duplicates_skipped_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDuplicatesSkippedCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        duplicatesSkippedCount_ = 0;
        onChanged();
        return this;
      }

      private int successfulIngestCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of new conversations added during this ingest
       * operation.
       * </pre>
       *
       * <code>int32 successful_ingest_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The successfulIngestCount.
       */
      @java.lang.Override
      public int getSuccessfulIngestCount() {
        return successfulIngestCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of new conversations added during this ingest
       * operation.
       * </pre>
       *
       * <code>int32 successful_ingest_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The successfulIngestCount to set.
       * @return This builder for chaining.
       */
      public Builder setSuccessfulIngestCount(int value) {

        successfulIngestCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of new conversations added during this ingest
       * operation.
       * </pre>
       *
       * <code>int32 successful_ingest_count = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuccessfulIngestCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        successfulIngestCount_ = 0;
        onChanged();
        return this;
      }

      private int failedIngestCount_;
      /**
       *
       *
       * <pre>
       * Output only. The number of objects which were unable to be ingested due
       * to errors. The errors are populated in the partial_errors field.
       * </pre>
       *
       * <code>int32 failed_ingest_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The failedIngestCount.
       */
      @java.lang.Override
      public int getFailedIngestCount() {
        return failedIngestCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects which were unable to be ingested due
       * to errors. The errors are populated in the partial_errors field.
       * </pre>
       *
       * <code>int32 failed_ingest_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The failedIngestCount to set.
       * @return This builder for chaining.
       */
      public Builder setFailedIngestCount(int value) {

        failedIngestCount_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The number of objects which were unable to be ingested due
       * to errors. The errors are populated in the partial_errors field.
       * </pre>
       *
       * <code>int32 failed_ingest_count = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailedIngestCount() {
        bitField0_ = (bitField0_ & ~0x00000008);
        failedIngestCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats)
    private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .IngestConversationsStats();
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IngestConversationsStats> PARSER =
        new com.google.protobuf.AbstractParser<IngestConversationsStats>() {
          @java.lang.Override
          public IngestConversationsStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IngestConversationsStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngestConversationsStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest request_;
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return request_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest getRequest() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder
      getRequestOrBuilder() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.getDefaultInstance()
        : request_;
  }

  public static final int PARTIAL_ERRORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialErrors_;
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during ingest operation that might cause the
   * operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during ingest operation that might cause the
   * operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getPartialErrorsOrBuilderList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during ingest operation that might cause the
   * operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getPartialErrorsCount() {
    return partialErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during ingest operation that might cause the
   * operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialErrors(int index) {
    return partialErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial errors during ingest operation that might cause the
   * operation output to be incomplete.
   * </pre>
   *
   * <code>
   * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
    return partialErrors_.get(index);
  }

  public static final int INGEST_CONVERSATIONS_STATS_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
          .IngestConversationsStats
      ingestConversationsStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics for IngestConversations operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the ingestConversationsStats field is set.
   */
  @java.lang.Override
  public boolean hasIngestConversationsStats() {
    return ingestConversationsStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for IngestConversations operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The ingestConversationsStats.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
          .IngestConversationsStats
      getIngestConversationsStats() {
    return ingestConversationsStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats.getDefaultInstance()
        : ingestConversationsStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for IngestConversations operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
          .IngestConversationsStatsOrBuilder
      getIngestConversationsStatsOrBuilder() {
    return ingestConversationsStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats.getDefaultInstance()
        : ingestConversationsStats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (createTime_ != null) {
      output.writeMessage(1, getCreateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(2, getEndTime());
    }
    if (request_ != null) {
      output.writeMessage(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      output.writeMessage(4, partialErrors_.get(i));
    }
    if (ingestConversationsStats_ != null) {
      output.writeMessage(5, getIngestConversationsStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (request_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, partialErrors_.get(i));
    }
    if (ingestConversationsStats_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, getIngestConversationsStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata other =
        (com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (!getPartialErrorsList().equals(other.getPartialErrorsList())) return false;
    if (hasIngestConversationsStats() != other.hasIngestConversationsStats()) return false;
    if (hasIngestConversationsStats()) {
      if (!getIngestConversationsStats().equals(other.getIngestConversationsStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (getPartialErrorsCount() > 0) {
      hash = (37 * hash) + PARTIAL_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialErrorsList().hashCode();
    }
    if (hasIngestConversationsStats()) {
      hash = (37 * hash) + INGEST_CONVERSATIONS_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getIngestConversationsStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metadata for an IngestConversations operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IngestConversationsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata)
      com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.Builder.class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
      } else {
        partialErrors_ = null;
        partialErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      ingestConversationsStats_ = null;
      if (ingestConversationsStatsBuilder_ != null) {
        ingestConversationsStatsBuilder_.dispose();
        ingestConversationsStatsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata build() {
      com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata buildPartial() {
      com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata result =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata result) {
      if (partialErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.partialErrors_ = partialErrors_;
      } else {
        result.partialErrors_ = partialErrorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ingestConversationsStats_ =
            ingestConversationsStatsBuilder_ == null
                ? ingestConversationsStats_
                : ingestConversationsStatsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
              .getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (partialErrorsBuilder_ == null) {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrors_.isEmpty()) {
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePartialErrorsIsMutable();
            partialErrors_.addAll(other.partialErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrorsBuilder_.isEmpty()) {
            partialErrorsBuilder_.dispose();
            partialErrorsBuilder_ = null;
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
            partialErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialErrorsFieldBuilder()
                    : null;
          } else {
            partialErrorsBuilder_.addAllMessages(other.partialErrors_);
          }
        }
      }
      if (other.hasIngestConversationsStats()) {
        mergeIngestConversationsStats(other.getIngestConversationsStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialErrorsBuilder_ == null) {
                  ensurePartialErrorsIsMutable();
                  partialErrors_.add(m);
                } else {
                  partialErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getIngestConversationsStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The request.
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder
            builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRequest(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_
                != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder
        getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder
        getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private java.util.List<com.google.rpc.Status> partialErrors_ =
        java.util.Collections.emptyList();

    private void ensurePartialErrorsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>(partialErrors_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
      if (partialErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialErrors_);
      } else {
        return partialErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getPartialErrorsCount() {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.size();
      } else {
        return partialErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status getPartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllPartialErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialErrors_);
        onChanged();
      } else {
        partialErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPartialErrors() {
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removePartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.remove(index);
        onChanged();
      } else {
        partialErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder getPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialErrorsOrBuilderList() {
      if (partialErrorsBuilder_ != null) {
        return partialErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder() {
      return getPartialErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial errors during ingest operation that might cause the
     * operation output to be incomplete.
     * </pre>
     *
     * <code>
     * repeated .google.rpc.Status partial_errors = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialErrorsBuilderList() {
      return getPartialErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialErrorsFieldBuilder() {
      if (partialErrorsBuilder_ == null) {
        partialErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialErrors_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        partialErrors_ = null;
      }
      return partialErrorsBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        ingestConversationsStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStatsOrBuilder>
        ingestConversationsStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the ingestConversationsStats field is set.
     */
    public boolean hasIngestConversationsStats() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The ingestConversationsStats.
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats
        getIngestConversationsStats() {
      if (ingestConversationsStatsBuilder_ == null) {
        return ingestConversationsStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.getDefaultInstance()
            : ingestConversationsStats_;
      } else {
        return ingestConversationsStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIngestConversationsStats(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats
            value) {
      if (ingestConversationsStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ingestConversationsStats_ = value;
      } else {
        ingestConversationsStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIngestConversationsStats(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.Builder
            builderForValue) {
      if (ingestConversationsStatsBuilder_ == null) {
        ingestConversationsStats_ = builderForValue.build();
      } else {
        ingestConversationsStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIngestConversationsStats(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats
            value) {
      if (ingestConversationsStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && ingestConversationsStats_ != null
            && ingestConversationsStats_
                != com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats.getDefaultInstance()) {
          getIngestConversationsStatsBuilder().mergeFrom(value);
        } else {
          ingestConversationsStats_ = value;
        }
      } else {
        ingestConversationsStatsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIngestConversationsStats() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ingestConversationsStats_ = null;
      if (ingestConversationsStatsBuilder_ != null) {
        ingestConversationsStatsBuilder_.dispose();
        ingestConversationsStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStats.Builder
        getIngestConversationsStatsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getIngestConversationsStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
            .IngestConversationsStatsOrBuilder
        getIngestConversationsStatsOrBuilder() {
      if (ingestConversationsStatsBuilder_ != null) {
        return ingestConversationsStatsBuilder_.getMessageOrBuilder();
      } else {
        return ingestConversationsStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.getDefaultInstance()
            : ingestConversationsStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for IngestConversations operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsMetadata.IngestConversationsStats ingest_conversations_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStats.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                .IngestConversationsStatsOrBuilder>
        getIngestConversationsStatsFieldBuilder() {
      if (ingestConversationsStatsBuilder_ == null) {
        ingestConversationsStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStats.Builder,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
                    .IngestConversationsStatsOrBuilder>(
                getIngestConversationsStats(), getParentForChildren(), isClean());
        ingestConversationsStats_ = null;
      }
      return ingestConversationsStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsMetadata)
  private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata();
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestConversationsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<IngestConversationsMetadata>() {
        @java.lang.Override
        public IngestConversationsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestConversationsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestConversationsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
