/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The issue model resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModel}
 */
public final class IssueModel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IssueModel)
    IssueModelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IssueModel.newBuilder() to construct.
  private IssueModel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IssueModel() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    modelType_ = 0;
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IssueModel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.IssueModel.class,
            com.google.cloud.contactcenterinsights.v1.IssueModel.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.IssueModel.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Model is not deployed but is ready to deploy.
     * </pre>
     *
     * <code>UNDEPLOYED = 1;</code>
     */
    UNDEPLOYED(1),
    /**
     *
     *
     * <pre>
     * Model is being deployed.
     * </pre>
     *
     * <code>DEPLOYING = 2;</code>
     */
    DEPLOYING(2),
    /**
     *
     *
     * <pre>
     * Model is deployed and is ready to be used. A model can only be used in
     * analysis if it's in this state.
     * </pre>
     *
     * <code>DEPLOYED = 3;</code>
     */
    DEPLOYED(3),
    /**
     *
     *
     * <pre>
     * Model is being undeployed.
     * </pre>
     *
     * <code>UNDEPLOYING = 4;</code>
     */
    UNDEPLOYING(4),
    /**
     *
     *
     * <pre>
     * Model is being deleted.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    DELETING(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Model is not deployed but is ready to deploy.
     * </pre>
     *
     * <code>UNDEPLOYED = 1;</code>
     */
    public static final int UNDEPLOYED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Model is being deployed.
     * </pre>
     *
     * <code>DEPLOYING = 2;</code>
     */
    public static final int DEPLOYING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Model is deployed and is ready to be used. A model can only be used in
     * analysis if it's in this state.
     * </pre>
     *
     * <code>DEPLOYED = 3;</code>
     */
    public static final int DEPLOYED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Model is being undeployed.
     * </pre>
     *
     * <code>UNDEPLOYING = 4;</code>
     */
    public static final int UNDEPLOYING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Model is being deleted.
     * </pre>
     *
     * <code>DELETING = 5;</code>
     */
    public static final int DELETING_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return UNDEPLOYED;
        case 2:
          return DEPLOYING;
        case 3:
          return DEPLOYED;
        case 4:
          return UNDEPLOYING;
        case 5:
          return DELETING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.IssueModel.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.IssueModel.State)
  }

  /**
   *
   *
   * <pre>
   * Type of the model.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.IssueModel.ModelType}
   */
  public enum ModelType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified model type.
     * </pre>
     *
     * <code>MODEL_TYPE_UNSPECIFIED = 0;</code>
     */
    MODEL_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Type V1.
     * </pre>
     *
     * <code>TYPE_V1 = 1;</code>
     */
    TYPE_V1(1),
    /**
     *
     *
     * <pre>
     * Type V2.
     * </pre>
     *
     * <code>TYPE_V2 = 2;</code>
     */
    TYPE_V2(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified model type.
     * </pre>
     *
     * <code>MODEL_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MODEL_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Type V1.
     * </pre>
     *
     * <code>TYPE_V1 = 1;</code>
     */
    public static final int TYPE_V1_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Type V2.
     * </pre>
     *
     * <code>TYPE_V2 = 2;</code>
     */
    public static final int TYPE_V2_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ModelType forNumber(int value) {
      switch (value) {
        case 0:
          return MODEL_TYPE_UNSPECIFIED;
        case 1:
          return TYPE_V1;
        case 2:
          return TYPE_V2;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ModelType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ModelType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ModelType>() {
          public ModelType findValueByNumber(int number) {
            return ModelType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.IssueModel.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final ModelType[] VALUES = values();

    public static ModelType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ModelType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.IssueModel.ModelType)
  }

  public interface InputDataConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Medium of conversations used in training data. This field is being
     * deprecated. To specify the medium to be used in training a new issue
     * model, set the `medium` field on `filter`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
     * @return The enum numeric value on the wire for medium.
     */
    @java.lang.Deprecated
    int getMediumValue();
    /**
     *
     *
     * <pre>
     * Medium of conversations used in training data. This field is being
     * deprecated. To specify the medium to be used in training a new issue
     * model, set the `medium` field on `filter`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
     * @return The medium.
     */
    @java.lang.Deprecated
    com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium();

    /**
     *
     *
     * <pre>
     * Output only. Number of conversations used in training. Output only.
     * </pre>
     *
     * <code>int64 training_conversations_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The trainingConversationsCount.
     */
    long getTrainingConversationsCount();

    /**
     *
     *
     * <pre>
     * A filter to reduce the conversations used for training the model to a
     * specific subset.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();
    /**
     *
     *
     * <pre>
     * A filter to reduce the conversations used for training the model to a
     * specific subset.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }
  /**
   *
   *
   * <pre>
   * Configs for the input data used to create the issue model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig}
   */
  public static final class InputDataConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)
      InputDataConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InputDataConfig.newBuilder() to construct.
    private InputDataConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputDataConfig() {
      medium_ = 0;
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputDataConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_InputDataConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_InputDataConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.class,
              com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder.class);
    }

    public static final int MEDIUM_FIELD_NUMBER = 1;
    private int medium_ = 0;
    /**
     *
     *
     * <pre>
     * Medium of conversations used in training data. This field is being
     * deprecated. To specify the medium to be used in training a new issue
     * model, set the `medium` field on `filter`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
     * @return The enum numeric value on the wire for medium.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getMediumValue() {
      return medium_;
    }
    /**
     *
     *
     * <pre>
     * Medium of conversations used in training data. This field is being
     * deprecated. To specify the medium to be used in training a new issue
     * model, set the `medium` field on `filter`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
     * @return The medium.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
      com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
          com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
          : result;
    }

    public static final int TRAINING_CONVERSATIONS_COUNT_FIELD_NUMBER = 2;
    private long trainingConversationsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Output only. Number of conversations used in training. Output only.
     * </pre>
     *
     * <code>int64 training_conversations_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The trainingConversationsCount.
     */
    @java.lang.Override
    public long getTrainingConversationsCount() {
      return trainingConversationsCount_;
    }

    public static final int FILTER_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * A filter to reduce the conversations used for training the model to a
     * specific subset.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter to reduce the conversations used for training the model to a
     * specific subset.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (medium_
          != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, medium_);
      }
      if (trainingConversationsCount_ != 0L) {
        output.writeInt64(2, trainingConversationsCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (medium_
          != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, medium_);
      }
      if (trainingConversationsCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(2, trainingConversationsCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig other =
          (com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig) obj;

      if (medium_ != other.medium_) return false;
      if (getTrainingConversationsCount() != other.getTrainingConversationsCount()) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MEDIUM_FIELD_NUMBER;
      hash = (53 * hash) + medium_;
      hash = (37 * hash) + TRAINING_CONVERSATIONS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTrainingConversationsCount());
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data used to create the issue model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_InputDataConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_InputDataConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.class,
                com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        medium_ = 0;
        trainingConversationsCount_ = 0L;
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_InputDataConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig build() {
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig result =
            new com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.medium_ = medium_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.trainingConversationsCount_ = trainingConversationsCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
                .getDefaultInstance()) return this;
        if (other.medium_ != 0) {
          setMediumValue(other.getMediumValue());
        }
        if (other.getTrainingConversationsCount() != 0L) {
          setTrainingConversationsCount(other.getTrainingConversationsCount());
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  medium_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  trainingConversationsCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int medium_ = 0;
      /**
       *
       *
       * <pre>
       * Medium of conversations used in training data. This field is being
       * deprecated. To specify the medium to be used in training a new issue
       * model, set the `medium` field on `filter`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
       *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
       * @return The enum numeric value on the wire for medium.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public int getMediumValue() {
        return medium_;
      }
      /**
       *
       *
       * <pre>
       * Medium of conversations used in training data. This field is being
       * deprecated. To specify the medium to be used in training a new issue
       * model, set the `medium` field on `filter`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
       *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
       * @param value The enum numeric value on the wire for medium to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setMediumValue(int value) {
        medium_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Medium of conversations used in training data. This field is being
       * deprecated. To specify the medium to be used in training a new issue
       * model, set the `medium` field on `filter`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
       *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
       * @return The medium.
       */
      @java.lang.Override
      @java.lang.Deprecated
      public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
        com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
            com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Medium of conversations used in training data. This field is being
       * deprecated. To specify the medium to be used in training a new issue
       * model, set the `medium` field on `filter`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
       *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
       * @param value The medium to set.
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder setMedium(
          com.google.cloud.contactcenterinsights.v1.Conversation.Medium value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        medium_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Medium of conversations used in training data. This field is being
       * deprecated. To specify the medium to be used in training a new issue
       * model, set the `medium` field on `filter`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [deprecated = true];
       * </code>
       *
       * @deprecated google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.medium is
       *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=623
       * @return This builder for chaining.
       */
      @java.lang.Deprecated
      public Builder clearMedium() {
        bitField0_ = (bitField0_ & ~0x00000001);
        medium_ = 0;
        onChanged();
        return this;
      }

      private long trainingConversationsCount_;
      /**
       *
       *
       * <pre>
       * Output only. Number of conversations used in training. Output only.
       * </pre>
       *
       * <code>int64 training_conversations_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The trainingConversationsCount.
       */
      @java.lang.Override
      public long getTrainingConversationsCount() {
        return trainingConversationsCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of conversations used in training. Output only.
       * </pre>
       *
       * <code>int64 training_conversations_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The trainingConversationsCount to set.
       * @return This builder for chaining.
       */
      public Builder setTrainingConversationsCount(long value) {

        trainingConversationsCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of conversations used in training. Output only.
       * </pre>
       *
       * <code>int64 training_conversations_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTrainingConversationsCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        trainingConversationsCount_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";
      /**
       *
       *
       * <pre>
       * A filter to reduce the conversations used for training the model to a
       * specific subset.
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A filter to reduce the conversations used for training the model to a
       * specific subset.
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A filter to reduce the conversations used for training the model to a
       * specific subset.
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter to reduce the conversations used for training the model to a
       * specific subset.
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A filter to reduce the conversations used for training the model to a
       * specific subset.
       * </pre>
       *
       * <code>string filter = 3;</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig)
    private static final com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputDataConfig> PARSER =
        new com.google.protobuf.AbstractParser<InputDataConfig>() {
          @java.lang.Override
          public InputDataConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InputDataConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputDataConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the issue model.
   * Format:
   * projects/{project}/locations/{location}/issueModels/{issue_model}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the issue model.
   * Format:
   * projects/{project}/locations/{location}/issueModels/{issue_model}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The representative name for the issue model.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The representative name for the issue model.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this issue model was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this issue model was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this issue model was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the issue model was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the issue model was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the issue model was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ISSUE_COUNT_FIELD_NUMBER = 8;
  private long issueCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Number of issues in this issue model.
   * </pre>
   *
   * <code>int64 issue_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The issueCount.
   */
  @java.lang.Override
  public long getIssueCount() {
    return issueCount_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the model.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModel.State getState() {
    com.google.cloud.contactcenterinsights.v1.IssueModel.State result =
        com.google.cloud.contactcenterinsights.v1.IssueModel.State.forNumber(state_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModel.State.UNRECOGNIZED
        : result;
  }

  public static final int INPUT_DATA_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig inputDataConfig_;
  /**
   *
   *
   * <pre>
   * Configs for the input data that used to create the issue model.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
   * </code>
   *
   * @return Whether the inputDataConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputDataConfig() {
    return inputDataConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configs for the input data that used to create the issue model.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
   * </code>
   *
   * @return The inputDataConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig getInputDataConfig() {
    return inputDataConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.getDefaultInstance()
        : inputDataConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configs for the input data that used to create the issue model.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder
      getInputDataConfigOrBuilder() {
    return inputDataConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.getDefaultInstance()
        : inputDataConfig_;
  }

  public static final int TRAINING_STATS_FIELD_NUMBER = 7;
  private com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats trainingStats_;
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The issue model's label statistics on its training
   * data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the trainingStats field is set.
   */
  @java.lang.Override
  public boolean hasTrainingStats() {
    return trainingStats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The issue model's label statistics on its training
   * data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The trainingStats.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats getTrainingStats() {
    return trainingStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance()
        : trainingStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The issue model's label statistics on its training
   * data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder
      getTrainingStatsOrBuilder() {
    return trainingStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance()
        : trainingStats_;
  }

  public static final int MODEL_TYPE_FIELD_NUMBER = 9;
  private int modelType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of the model.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
   *
   * @return The enum numeric value on the wire for modelType.
   */
  @java.lang.Override
  public int getModelTypeValue() {
    return modelType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the model.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
   *
   * @return The modelType.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType getModelType() {
    com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType result =
        com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.forNumber(modelType_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.UNRECOGNIZED
        : result;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Language of the model.
   * </pre>
   *
   * <code>string language_code = 10;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Language of the model.
   * </pre>
   *
   * <code>string language_code = 10;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(4, getUpdateTime());
    }
    if (state_
        != com.google.cloud.contactcenterinsights.v1.IssueModel.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, state_);
    }
    if (inputDataConfig_ != null) {
      output.writeMessage(6, getInputDataConfig());
    }
    if (trainingStats_ != null) {
      output.writeMessage(7, getTrainingStats());
    }
    if (issueCount_ != 0L) {
      output.writeInt64(8, issueCount_);
    }
    if (modelType_
        != com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.MODEL_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(9, modelType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, languageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (state_
        != com.google.cloud.contactcenterinsights.v1.IssueModel.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (inputDataConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getInputDataConfig());
    }
    if (trainingStats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTrainingStats());
    }
    if (issueCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, issueCount_);
    }
    if (modelType_
        != com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.MODEL_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, modelType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, languageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.IssueModel)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.IssueModel other =
        (com.google.cloud.contactcenterinsights.v1.IssueModel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getIssueCount() != other.getIssueCount()) return false;
    if (state_ != other.state_) return false;
    if (hasInputDataConfig() != other.hasInputDataConfig()) return false;
    if (hasInputDataConfig()) {
      if (!getInputDataConfig().equals(other.getInputDataConfig())) return false;
    }
    if (hasTrainingStats() != other.hasTrainingStats()) return false;
    if (hasTrainingStats()) {
      if (!getTrainingStats().equals(other.getTrainingStats())) return false;
    }
    if (modelType_ != other.modelType_) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ISSUE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIssueCount());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasInputDataConfig()) {
      hash = (37 * hash) + INPUT_DATA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputDataConfig().hashCode();
    }
    if (hasTrainingStats()) {
      hash = (37 * hash) + TRAINING_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingStats().hashCode();
    }
    hash = (37 * hash) + MODEL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + modelType_;
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.IssueModel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The issue model resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IssueModel)
      com.google.cloud.contactcenterinsights.v1.IssueModelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IssueModel.class,
              com.google.cloud.contactcenterinsights.v1.IssueModel.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.IssueModel.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      issueCount_ = 0L;
      state_ = 0;
      inputDataConfig_ = null;
      if (inputDataConfigBuilder_ != null) {
        inputDataConfigBuilder_.dispose();
        inputDataConfigBuilder_ = null;
      }
      trainingStats_ = null;
      if (trainingStatsBuilder_ != null) {
        trainingStatsBuilder_.dispose();
        trainingStatsBuilder_ = null;
      }
      modelType_ = 0;
      languageCode_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.IssueModel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel build() {
      com.google.cloud.contactcenterinsights.v1.IssueModel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel buildPartial() {
      com.google.cloud.contactcenterinsights.v1.IssueModel result =
          new com.google.cloud.contactcenterinsights.v1.IssueModel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.IssueModel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.issueCount_ = issueCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.inputDataConfig_ =
            inputDataConfigBuilder_ == null ? inputDataConfig_ : inputDataConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.trainingStats_ =
            trainingStatsBuilder_ == null ? trainingStats_ : trainingStatsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.modelType_ = modelType_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.languageCode_ = languageCode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.IssueModel) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.IssueModel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.IssueModel other) {
      if (other == com.google.cloud.contactcenterinsights.v1.IssueModel.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getIssueCount() != 0L) {
        setIssueCount(other.getIssueCount());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasInputDataConfig()) {
        mergeInputDataConfig(other.getInputDataConfig());
      }
      if (other.hasTrainingStats()) {
        mergeTrainingStats(other.getTrainingStats());
      }
      if (other.modelType_ != 0) {
        setModelTypeValue(other.getModelTypeValue());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getInputDataConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTrainingStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 64:
              {
                issueCount_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 64
            case 72:
              {
                modelType_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the issue model.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the issue model.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the issue model.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the issue model.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the issue model.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The representative name for the issue model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative name for the issue model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The representative name for the issue model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative name for the issue model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The representative name for the issue model.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this issue model was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the issue model was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private long issueCount_;
    /**
     *
     *
     * <pre>
     * Output only. Number of issues in this issue model.
     * </pre>
     *
     * <code>int64 issue_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The issueCount.
     */
    @java.lang.Override
    public long getIssueCount() {
      return issueCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of issues in this issue model.
     * </pre>
     *
     * <code>int64 issue_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The issueCount to set.
     * @return This builder for chaining.
     */
    public Builder setIssueCount(long value) {

      issueCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of issues in this issue model.
     * </pre>
     *
     * <code>int64 issue_count = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssueCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      issueCount_ = 0L;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel.State getState() {
      com.google.cloud.contactcenterinsights.v1.IssueModel.State result =
          com.google.cloud.contactcenterinsights.v1.IssueModel.State.forNumber(state_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.IssueModel.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.contactcenterinsights.v1.IssueModel.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig inputDataConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig,
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder>
        inputDataConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     *
     * @return Whether the inputDataConfig field is set.
     */
    public boolean hasInputDataConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     *
     * @return The inputDataConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
        getInputDataConfig() {
      if (inputDataConfigBuilder_ == null) {
        return inputDataConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
                .getDefaultInstance()
            : inputDataConfig_;
      } else {
        return inputDataConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public Builder setInputDataConfig(
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig value) {
      if (inputDataConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputDataConfig_ = value;
      } else {
        inputDataConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public Builder setInputDataConfig(
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder
            builderForValue) {
      if (inputDataConfigBuilder_ == null) {
        inputDataConfig_ = builderForValue.build();
      } else {
        inputDataConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public Builder mergeInputDataConfig(
        com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig value) {
      if (inputDataConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && inputDataConfig_ != null
            && inputDataConfig_
                != com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
                    .getDefaultInstance()) {
          getInputDataConfigBuilder().mergeFrom(value);
        } else {
          inputDataConfig_ = value;
        }
      } else {
        inputDataConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public Builder clearInputDataConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      inputDataConfig_ = null;
      if (inputDataConfigBuilder_ != null) {
        inputDataConfigBuilder_.dispose();
        inputDataConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder
        getInputDataConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getInputDataConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder
        getInputDataConfigOrBuilder() {
      if (inputDataConfigBuilder_ != null) {
        return inputDataConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputDataConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig
                .getDefaultInstance()
            : inputDataConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configs for the input data that used to create the issue model.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig input_data_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig,
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder>
        getInputDataConfigFieldBuilder() {
      if (inputDataConfigBuilder_ == null) {
        inputDataConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig,
                com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.IssueModel.InputDataConfigOrBuilder>(
                getInputDataConfig(), getParentForChildren(), isClean());
        inputDataConfig_ = null;
      }
      return inputDataConfigBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats trainingStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder>
        trainingStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the trainingStats field is set.
     */
    public boolean hasTrainingStats() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The trainingStats.
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats getTrainingStats() {
      if (trainingStatsBuilder_ == null) {
        return trainingStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance()
            : trainingStats_;
      } else {
        return trainingStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setTrainingStats(
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats value) {
      if (trainingStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingStats_ = value;
      } else {
        trainingStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setTrainingStats(
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder builderForValue) {
      if (trainingStatsBuilder_ == null) {
        trainingStats_ = builderForValue.build();
      } else {
        trainingStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeTrainingStats(
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats value) {
      if (trainingStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && trainingStats_ != null
            && trainingStats_
                != com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats
                    .getDefaultInstance()) {
          getTrainingStatsBuilder().mergeFrom(value);
        } else {
          trainingStats_ = value;
        }
      } else {
        trainingStatsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearTrainingStats() {
      bitField0_ = (bitField0_ & ~0x00000080);
      trainingStats_ = null;
      if (trainingStatsBuilder_ != null) {
        trainingStatsBuilder_.dispose();
        trainingStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder
        getTrainingStatsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getTrainingStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder
        getTrainingStatsOrBuilder() {
      if (trainingStatsBuilder_ != null) {
        return trainingStatsBuilder_.getMessageOrBuilder();
      } else {
        return trainingStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance()
            : trainingStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The issue model's label statistics on its training
     * data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IssueModelLabelStats training_stats = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder>
        getTrainingStatsFieldBuilder() {
      if (trainingStatsBuilder_ == null) {
        trainingStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats,
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder,
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder>(
                getTrainingStats(), getParentForChildren(), isClean());
        trainingStats_ = null;
      }
      return trainingStatsBuilder_;
    }

    private int modelType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the model.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
     *
     * @return The enum numeric value on the wire for modelType.
     */
    @java.lang.Override
    public int getModelTypeValue() {
      return modelType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the model.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
     *
     * @param value The enum numeric value on the wire for modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelTypeValue(int value) {
      modelType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the model.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
     *
     * @return The modelType.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType getModelType() {
      com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType result =
          com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.forNumber(modelType_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the model.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
     *
     * @param value The modelType to set.
     * @return This builder for chaining.
     */
    public Builder setModelType(
        com.google.cloud.contactcenterinsights.v1.IssueModel.ModelType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      modelType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the model.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueModel.ModelType model_type = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelType() {
      bitField0_ = (bitField0_ & ~0x00000100);
      modelType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Language of the model.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the model.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Language of the model.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the model.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Language of the model.
     * </pre>
     *
     * <code>string language_code = 10;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IssueModel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IssueModel)
  private static final com.google.cloud.contactcenterinsights.v1.IssueModel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.IssueModel();
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IssueModel> PARSER =
      new com.google.protobuf.AbstractParser<IssueModel>() {
        @java.lang.Override
        public IssueModel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IssueModel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IssueModel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
