/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The phrase matcher resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.PhraseMatcher}
 */
public final class PhraseMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.PhraseMatcher)
    PhraseMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PhraseMatcher.newBuilder() to construct.
  private PhraseMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhraseMatcher() {
    name_ = "";
    revisionId_ = "";
    versionTag_ = "";
    displayName_ = "";
    type_ = 0;
    phraseMatchRuleGroups_ = java.util.Collections.emptyList();
    roleMatch_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhraseMatcher();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.PhraseMatcher.class,
            com.google.cloud.contactcenterinsights.v1.PhraseMatcher.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how to combine each phrase match rule group to determine whether
   * there is a match.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType}
   */
  public enum PhraseMatcherType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PHRASE_MATCHER_TYPE_UNSPECIFIED = 0;</code>
     */
    PHRASE_MATCHER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Must meet all phrase match rule groups or there is no match.
     * </pre>
     *
     * <code>ALL_OF = 1;</code>
     */
    ALL_OF(1),
    /**
     *
     *
     * <pre>
     * If any of the phrase match rule groups are met, there is a match.
     * </pre>
     *
     * <code>ANY_OF = 2;</code>
     */
    ANY_OF(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PHRASE_MATCHER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int PHRASE_MATCHER_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Must meet all phrase match rule groups or there is no match.
     * </pre>
     *
     * <code>ALL_OF = 1;</code>
     */
    public static final int ALL_OF_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If any of the phrase match rule groups are met, there is a match.
     * </pre>
     *
     * <code>ANY_OF = 2;</code>
     */
    public static final int ANY_OF_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PhraseMatcherType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PhraseMatcherType forNumber(int value) {
      switch (value) {
        case 0:
          return PHRASE_MATCHER_TYPE_UNSPECIFIED;
        case 1:
          return ALL_OF;
        case 2:
          return ANY_OF;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PhraseMatcherType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PhraseMatcherType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PhraseMatcherType>() {
              public PhraseMatcherType findValueByNumber(int number) {
                return PhraseMatcherType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.PhraseMatcher.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PhraseMatcherType[] VALUES = values();

    public static PhraseMatcherType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PhraseMatcherType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The resource name of the phrase matcher.
   * Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the phrase matcher.
   * Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revisionId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The revision ID of the phrase matcher.
   * A new revision is committed whenever the matcher is changed, except when it
   * is activated or deactivated. A server generated random ID will be used.
   * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
   * </pre>
   *
   * <code>
   * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionId.
   */
  @java.lang.Override
  public java.lang.String getRevisionId() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revisionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Immutable. The revision ID of the phrase matcher.
   * A new revision is committed whenever the matcher is changed, except when it
   * is activated or deactivated. A server generated random ID will be used.
   * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
   * </pre>
   *
   * <code>
   * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for revisionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionIdBytes() {
    java.lang.Object ref = revisionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revisionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_TAG_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionTag_ = "";
  /**
   *
   *
   * <pre>
   * The customized version tag to use for the phrase matcher. If not specified,
   * it will default to `revision_id`.
   * </pre>
   *
   * <code>string version_tag = 3;</code>
   *
   * @return The versionTag.
   */
  @java.lang.Override
  public java.lang.String getVersionTag() {
    java.lang.Object ref = versionTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The customized version tag to use for the phrase matcher. If not specified,
   * it will default to `revision_id`.
   * </pre>
   *
   * <code>string version_tag = 3;</code>
   *
   * @return The bytes for versionTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionTagBytes() {
    java.lang.Object ref = versionTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REVISION_CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp revisionCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the revision was created. It is also the
   * create time when a new matcher is added.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the revisionCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasRevisionCreateTime() {
    return revisionCreateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the revision was created. It is also the
   * create time when a new matcher is added.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The revisionCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRevisionCreateTime() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp of when the revision was created. It is also the
   * create time when a new matcher is added.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
    return revisionCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : revisionCreateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The human-readable name of the phrase matcher.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The human-readable name of the phrase matcher.
   * </pre>
   *
   * <code>string display_name = 5;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 6;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The type of this phrase matcher.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of this phrase matcher.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType getType() {
    com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType result =
        com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType.forNumber(type_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType.UNRECOGNIZED
        : result;
  }

  public static final int ACTIVE_FIELD_NUMBER = 7;
  private boolean active_ = false;
  /**
   *
   *
   * <pre>
   * Applies the phrase matcher only when it is active.
   * </pre>
   *
   * <code>bool active = 7;</code>
   *
   * @return The active.
   */
  @java.lang.Override
  public boolean getActive() {
    return active_;
  }

  public static final int PHRASE_MATCH_RULE_GROUPS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>
      phraseMatchRuleGroups_;
  /**
   *
   *
   * <pre>
   * A list of phase match rule groups that are included in this matcher.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>
      getPhraseMatchRuleGroupsList() {
    return phraseMatchRuleGroups_;
  }
  /**
   *
   *
   * <pre>
   * A list of phase match rule groups that are included in this matcher.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder>
      getPhraseMatchRuleGroupsOrBuilderList() {
    return phraseMatchRuleGroups_;
  }
  /**
   *
   *
   * <pre>
   * A list of phase match rule groups that are included in this matcher.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
   * </code>
   */
  @java.lang.Override
  public int getPhraseMatchRuleGroupsCount() {
    return phraseMatchRuleGroups_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of phase match rule groups that are included in this matcher.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup getPhraseMatchRuleGroups(
      int index) {
    return phraseMatchRuleGroups_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of phase match rule groups that are included in this matcher.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder
      getPhraseMatchRuleGroupsOrBuilder(int index) {
    return phraseMatchRuleGroups_.get(index);
  }

  public static final int ACTIVATION_UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp activationUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the activation status was
   * updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the activationUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasActivationUpdateTime() {
    return activationUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the activation status was
   * updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The activationUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getActivationUpdateTime() {
    return activationUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : activationUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the activation status was
   * updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getActivationUpdateTimeOrBuilder() {
    return activationUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : activationUpdateTime_;
  }

  public static final int ROLE_MATCH_FIELD_NUMBER = 10;
  private int roleMatch_ = 0;
  /**
   *
   *
   * <pre>
   * The role whose utterances the phrase matcher should be matched
   * against. If the role is ROLE_UNSPECIFIED it will be matched against any
   * utterances in the transcript.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
   * </code>
   *
   * @return The enum numeric value on the wire for roleMatch.
   */
  @java.lang.Override
  public int getRoleMatchValue() {
    return roleMatch_;
  }
  /**
   *
   *
   * <pre>
   * The role whose utterances the phrase matcher should be matched
   * against. If the role is ROLE_UNSPECIFIED it will be matched against any
   * utterances in the transcript.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
   * </code>
   *
   * @return The roleMatch.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role getRoleMatch() {
    com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role result =
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.forNumber(
            roleMatch_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.UNRECOGNIZED
        : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the phrase matcher was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the phrase matcher was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the phrase matcher was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, revisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, versionTag_);
    }
    if (revisionCreateTime_ != null) {
      output.writeMessage(4, getRevisionCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (type_
        != com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType
            .PHRASE_MATCHER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, type_);
    }
    if (active_ != false) {
      output.writeBool(7, active_);
    }
    for (int i = 0; i < phraseMatchRuleGroups_.size(); i++) {
      output.writeMessage(8, phraseMatchRuleGroups_.get(i));
    }
    if (activationUpdateTime_ != null) {
      output.writeMessage(9, getActivationUpdateTime());
    }
    if (roleMatch_
        != com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.ROLE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, roleMatch_);
    }
    if (updateTime_ != null) {
      output.writeMessage(11, getUpdateTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revisionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, revisionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, versionTag_);
    }
    if (revisionCreateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRevisionCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (type_
        != com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType
            .PHRASE_MATCHER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, type_);
    }
    if (active_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, active_);
    }
    for (int i = 0; i < phraseMatchRuleGroups_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, phraseMatchRuleGroups_.get(i));
    }
    if (activationUpdateTime_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getActivationUpdateTime());
    }
    if (roleMatch_
        != com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.ROLE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, roleMatch_);
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getUpdateTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.PhraseMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.PhraseMatcher other =
        (com.google.cloud.contactcenterinsights.v1.PhraseMatcher) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getRevisionId().equals(other.getRevisionId())) return false;
    if (!getVersionTag().equals(other.getVersionTag())) return false;
    if (hasRevisionCreateTime() != other.hasRevisionCreateTime()) return false;
    if (hasRevisionCreateTime()) {
      if (!getRevisionCreateTime().equals(other.getRevisionCreateTime())) return false;
    }
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (type_ != other.type_) return false;
    if (getActive() != other.getActive()) return false;
    if (!getPhraseMatchRuleGroupsList().equals(other.getPhraseMatchRuleGroupsList())) return false;
    if (hasActivationUpdateTime() != other.hasActivationUpdateTime()) return false;
    if (hasActivationUpdateTime()) {
      if (!getActivationUpdateTime().equals(other.getActivationUpdateTime())) return false;
    }
    if (roleMatch_ != other.roleMatch_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + REVISION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRevisionId().hashCode();
    hash = (37 * hash) + VERSION_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getVersionTag().hashCode();
    if (hasRevisionCreateTime()) {
      hash = (37 * hash) + REVISION_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRevisionCreateTime().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getActive());
    if (getPhraseMatchRuleGroupsCount() > 0) {
      hash = (37 * hash) + PHRASE_MATCH_RULE_GROUPS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseMatchRuleGroupsList().hashCode();
    }
    if (hasActivationUpdateTime()) {
      hash = (37 * hash) + ACTIVATION_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getActivationUpdateTime().hashCode();
    }
    hash = (37 * hash) + ROLE_MATCH_FIELD_NUMBER;
    hash = (53 * hash) + roleMatch_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.PhraseMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The phrase matcher resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.PhraseMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.PhraseMatcher)
      com.google.cloud.contactcenterinsights.v1.PhraseMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.PhraseMatcher.class,
              com.google.cloud.contactcenterinsights.v1.PhraseMatcher.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.PhraseMatcher.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      revisionId_ = "";
      versionTag_ = "";
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      displayName_ = "";
      type_ = 0;
      active_ = false;
      if (phraseMatchRuleGroupsBuilder_ == null) {
        phraseMatchRuleGroups_ = java.util.Collections.emptyList();
      } else {
        phraseMatchRuleGroups_ = null;
        phraseMatchRuleGroupsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      activationUpdateTime_ = null;
      if (activationUpdateTimeBuilder_ != null) {
        activationUpdateTimeBuilder_.dispose();
        activationUpdateTimeBuilder_ = null;
      }
      roleMatch_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatcher getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.PhraseMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatcher build() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatcher buildPartial() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatcher result =
          new com.google.cloud.contactcenterinsights.v1.PhraseMatcher(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.PhraseMatcher result) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          phraseMatchRuleGroups_ = java.util.Collections.unmodifiableList(phraseMatchRuleGroups_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.phraseMatchRuleGroups_ = phraseMatchRuleGroups_;
      } else {
        result.phraseMatchRuleGroups_ = phraseMatchRuleGroupsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.PhraseMatcher result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.revisionId_ = revisionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.versionTag_ = versionTag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.revisionCreateTime_ =
            revisionCreateTimeBuilder_ == null
                ? revisionCreateTime_
                : revisionCreateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.active_ = active_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.activationUpdateTime_ =
            activationUpdateTimeBuilder_ == null
                ? activationUpdateTime_
                : activationUpdateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.roleMatch_ = roleMatch_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.PhraseMatcher) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.PhraseMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.PhraseMatcher other) {
      if (other == com.google.cloud.contactcenterinsights.v1.PhraseMatcher.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRevisionId().isEmpty()) {
        revisionId_ = other.revisionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getVersionTag().isEmpty()) {
        versionTag_ = other.versionTag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRevisionCreateTime()) {
        mergeRevisionCreateTime(other.getRevisionCreateTime());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getActive() != false) {
        setActive(other.getActive());
      }
      if (phraseMatchRuleGroupsBuilder_ == null) {
        if (!other.phraseMatchRuleGroups_.isEmpty()) {
          if (phraseMatchRuleGroups_.isEmpty()) {
            phraseMatchRuleGroups_ = other.phraseMatchRuleGroups_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensurePhraseMatchRuleGroupsIsMutable();
            phraseMatchRuleGroups_.addAll(other.phraseMatchRuleGroups_);
          }
          onChanged();
        }
      } else {
        if (!other.phraseMatchRuleGroups_.isEmpty()) {
          if (phraseMatchRuleGroupsBuilder_.isEmpty()) {
            phraseMatchRuleGroupsBuilder_.dispose();
            phraseMatchRuleGroupsBuilder_ = null;
            phraseMatchRuleGroups_ = other.phraseMatchRuleGroups_;
            bitField0_ = (bitField0_ & ~0x00000080);
            phraseMatchRuleGroupsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhraseMatchRuleGroupsFieldBuilder()
                    : null;
          } else {
            phraseMatchRuleGroupsBuilder_.addAllMessages(other.phraseMatchRuleGroups_);
          }
        }
      }
      if (other.hasActivationUpdateTime()) {
        mergeActivationUpdateTime(other.getActivationUpdateTime());
      }
      if (other.roleMatch_ != 0) {
        setRoleMatchValue(other.getRoleMatchValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                revisionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                versionTag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getRevisionCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                active_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.parser(),
                        extensionRegistry);
                if (phraseMatchRuleGroupsBuilder_ == null) {
                  ensurePhraseMatchRuleGroupsIsMutable();
                  phraseMatchRuleGroups_.add(m);
                } else {
                  phraseMatchRuleGroupsBuilder_.addMessage(m);
                }
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getActivationUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 80:
              {
                roleMatch_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the phrase matcher.
     * Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase matcher.
     * Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase matcher.
     * Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase matcher.
     * Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the phrase matcher.
     * Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object revisionId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the phrase matcher.
     * A new revision is committed whenever the matcher is changed, except when it
     * is activated or deactivated. A server generated random ID will be used.
     * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
     * </pre>
     *
     * <code>
     * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionId.
     */
    public java.lang.String getRevisionId() {
      java.lang.Object ref = revisionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revisionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the phrase matcher.
     * A new revision is committed whenever the matcher is changed, except when it
     * is activated or deactivated. A server generated random ID will be used.
     * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
     * </pre>
     *
     * <code>
     * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for revisionId.
     */
    public com.google.protobuf.ByteString getRevisionIdBytes() {
      java.lang.Object ref = revisionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revisionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the phrase matcher.
     * A new revision is committed whenever the matcher is changed, except when it
     * is activated or deactivated. A server generated random ID will be used.
     * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
     * </pre>
     *
     * <code>
     * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revisionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the phrase matcher.
     * A new revision is committed whenever the matcher is changed, except when it
     * is activated or deactivated. A server generated random ID will be used.
     * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
     * </pre>
     *
     * <code>
     * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevisionId() {
      revisionId_ = getDefaultInstance().getRevisionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Immutable. The revision ID of the phrase matcher.
     * A new revision is committed whenever the matcher is changed, except when it
     * is activated or deactivated. A server generated random ID will be used.
     * Example: locations/global/phraseMatchers/my-first-matcher&#64;1234567
     * </pre>
     *
     * <code>
     * string revision_id = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for revisionId to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revisionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object versionTag_ = "";
    /**
     *
     *
     * <pre>
     * The customized version tag to use for the phrase matcher. If not specified,
     * it will default to `revision_id`.
     * </pre>
     *
     * <code>string version_tag = 3;</code>
     *
     * @return The versionTag.
     */
    public java.lang.String getVersionTag() {
      java.lang.Object ref = versionTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The customized version tag to use for the phrase matcher. If not specified,
     * it will default to `revision_id`.
     * </pre>
     *
     * <code>string version_tag = 3;</code>
     *
     * @return The bytes for versionTag.
     */
    public com.google.protobuf.ByteString getVersionTagBytes() {
      java.lang.Object ref = versionTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The customized version tag to use for the phrase matcher. If not specified,
     * it will default to `revision_id`.
     * </pre>
     *
     * <code>string version_tag = 3;</code>
     *
     * @param value The versionTag to set.
     * @return This builder for chaining.
     */
    public Builder setVersionTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionTag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customized version tag to use for the phrase matcher. If not specified,
     * it will default to `revision_id`.
     * </pre>
     *
     * <code>string version_tag = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionTag() {
      versionTag_ = getDefaultInstance().getVersionTag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customized version tag to use for the phrase matcher. If not specified,
     * it will default to `revision_id`.
     * </pre>
     *
     * <code>string version_tag = 3;</code>
     *
     * @param value The bytes for versionTag to set.
     * @return This builder for chaining.
     */
    public Builder setVersionTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionTag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp revisionCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        revisionCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the revisionCreateTime field is set.
     */
    public boolean hasRevisionCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The revisionCreateTime.
     */
    public com.google.protobuf.Timestamp getRevisionCreateTime() {
      if (revisionCreateTimeBuilder_ == null) {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      } else {
        return revisionCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        revisionCreateTime_ = value;
      } else {
        revisionCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRevisionCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTime_ = builderForValue.build();
      } else {
        revisionCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRevisionCreateTime(com.google.protobuf.Timestamp value) {
      if (revisionCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && revisionCreateTime_ != null
            && revisionCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRevisionCreateTimeBuilder().mergeFrom(value);
        } else {
          revisionCreateTime_ = value;
        }
      } else {
        revisionCreateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRevisionCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      revisionCreateTime_ = null;
      if (revisionCreateTimeBuilder_ != null) {
        revisionCreateTimeBuilder_.dispose();
        revisionCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRevisionCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRevisionCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRevisionCreateTimeOrBuilder() {
      if (revisionCreateTimeBuilder_ != null) {
        return revisionCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return revisionCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : revisionCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp of when the revision was created. It is also the
     * create time when a new matcher is added.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp revision_create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRevisionCreateTimeFieldBuilder() {
      if (revisionCreateTimeBuilder_ == null) {
        revisionCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRevisionCreateTime(), getParentForChildren(), isClean());
        revisionCreateTime_ = null;
      }
      return revisionCreateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The human-readable name of the phrase matcher.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the phrase matcher.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the phrase matcher.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the phrase matcher.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The human-readable name of the phrase matcher.
     * </pre>
     *
     * <code>string display_name = 5;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase matcher.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase matcher.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase matcher.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType getType() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType result =
          com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType.forNumber(
              type_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase matcher.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase matcher.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatcher.PhraseMatcherType type = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      type_ = 0;
      onChanged();
      return this;
    }

    private boolean active_;
    /**
     *
     *
     * <pre>
     * Applies the phrase matcher only when it is active.
     * </pre>
     *
     * <code>bool active = 7;</code>
     *
     * @return The active.
     */
    @java.lang.Override
    public boolean getActive() {
      return active_;
    }
    /**
     *
     *
     * <pre>
     * Applies the phrase matcher only when it is active.
     * </pre>
     *
     * <code>bool active = 7;</code>
     *
     * @param value The active to set.
     * @return This builder for chaining.
     */
    public Builder setActive(boolean value) {

      active_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the phrase matcher only when it is active.
     * </pre>
     *
     * <code>bool active = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActive() {
      bitField0_ = (bitField0_ & ~0x00000040);
      active_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>
        phraseMatchRuleGroups_ = java.util.Collections.emptyList();

    private void ensurePhraseMatchRuleGroupsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        phraseMatchRuleGroups_ =
            new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>(
                phraseMatchRuleGroups_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder>
        phraseMatchRuleGroupsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>
        getPhraseMatchRuleGroupsList() {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phraseMatchRuleGroups_);
      } else {
        return phraseMatchRuleGroupsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public int getPhraseMatchRuleGroupsCount() {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        return phraseMatchRuleGroups_.size();
      } else {
        return phraseMatchRuleGroupsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup getPhraseMatchRuleGroups(
        int index) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        return phraseMatchRuleGroups_.get(index);
      } else {
        return phraseMatchRuleGroupsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder setPhraseMatchRuleGroups(
        int index, com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup value) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.set(index, value);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder setPhraseMatchRuleGroups(
        int index,
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder builderForValue) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.set(index, builderForValue.build());
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder addPhraseMatchRuleGroups(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup value) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.add(value);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder addPhraseMatchRuleGroups(
        int index, com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup value) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.add(index, value);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder addPhraseMatchRuleGroups(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder builderForValue) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.add(builderForValue.build());
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder addPhraseMatchRuleGroups(
        int index,
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder builderForValue) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.add(index, builderForValue.build());
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder addAllPhraseMatchRuleGroups(
        java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup>
            values) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        ensurePhraseMatchRuleGroupsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseMatchRuleGroups_);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder clearPhraseMatchRuleGroups() {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        phraseMatchRuleGroups_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public Builder removePhraseMatchRuleGroups(int index) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        ensurePhraseMatchRuleGroupsIsMutable();
        phraseMatchRuleGroups_.remove(index);
        onChanged();
      } else {
        phraseMatchRuleGroupsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder
        getPhraseMatchRuleGroupsBuilder(int index) {
      return getPhraseMatchRuleGroupsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder
        getPhraseMatchRuleGroupsOrBuilder(int index) {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        return phraseMatchRuleGroups_.get(index);
      } else {
        return phraseMatchRuleGroupsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder>
        getPhraseMatchRuleGroupsOrBuilderList() {
      if (phraseMatchRuleGroupsBuilder_ != null) {
        return phraseMatchRuleGroupsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phraseMatchRuleGroups_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder
        addPhraseMatchRuleGroupsBuilder() {
      return getPhraseMatchRuleGroupsFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder
        addPhraseMatchRuleGroupsBuilder(int index) {
      return getPhraseMatchRuleGroupsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of phase match rule groups that are included in this matcher.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup phrase_match_rule_groups = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder>
        getPhraseMatchRuleGroupsBuilderList() {
      return getPhraseMatchRuleGroupsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder>
        getPhraseMatchRuleGroupsFieldBuilder() {
      if (phraseMatchRuleGroupsBuilder_ == null) {
        phraseMatchRuleGroupsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder>(
                phraseMatchRuleGroups_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        phraseMatchRuleGroups_ = null;
      }
      return phraseMatchRuleGroupsBuilder_;
    }

    private com.google.protobuf.Timestamp activationUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        activationUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the activationUpdateTime field is set.
     */
    public boolean hasActivationUpdateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The activationUpdateTime.
     */
    public com.google.protobuf.Timestamp getActivationUpdateTime() {
      if (activationUpdateTimeBuilder_ == null) {
        return activationUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : activationUpdateTime_;
      } else {
        return activationUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setActivationUpdateTime(com.google.protobuf.Timestamp value) {
      if (activationUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        activationUpdateTime_ = value;
      } else {
        activationUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setActivationUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (activationUpdateTimeBuilder_ == null) {
        activationUpdateTime_ = builderForValue.build();
      } else {
        activationUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeActivationUpdateTime(com.google.protobuf.Timestamp value) {
      if (activationUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && activationUpdateTime_ != null
            && activationUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getActivationUpdateTimeBuilder().mergeFrom(value);
        } else {
          activationUpdateTime_ = value;
        }
      } else {
        activationUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearActivationUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      activationUpdateTime_ = null;
      if (activationUpdateTimeBuilder_ != null) {
        activationUpdateTimeBuilder_.dispose();
        activationUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getActivationUpdateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getActivationUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getActivationUpdateTimeOrBuilder() {
      if (activationUpdateTimeBuilder_ != null) {
        return activationUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return activationUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : activationUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the activation status was
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp activation_update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getActivationUpdateTimeFieldBuilder() {
      if (activationUpdateTimeBuilder_ == null) {
        activationUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getActivationUpdateTime(), getParentForChildren(), isClean());
        activationUpdateTime_ = null;
      }
      return activationUpdateTimeBuilder_;
    }

    private int roleMatch_ = 0;
    /**
     *
     *
     * <pre>
     * The role whose utterances the phrase matcher should be matched
     * against. If the role is ROLE_UNSPECIFIED it will be matched against any
     * utterances in the transcript.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
     * </code>
     *
     * @return The enum numeric value on the wire for roleMatch.
     */
    @java.lang.Override
    public int getRoleMatchValue() {
      return roleMatch_;
    }
    /**
     *
     *
     * <pre>
     * The role whose utterances the phrase matcher should be matched
     * against. If the role is ROLE_UNSPECIFIED it will be matched against any
     * utterances in the transcript.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
     * </code>
     *
     * @param value The enum numeric value on the wire for roleMatch to set.
     * @return This builder for chaining.
     */
    public Builder setRoleMatchValue(int value) {
      roleMatch_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role whose utterances the phrase matcher should be matched
     * against. If the role is ROLE_UNSPECIFIED it will be matched against any
     * utterances in the transcript.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
     * </code>
     *
     * @return The roleMatch.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role getRoleMatch() {
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role result =
          com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.forNumber(
              roleMatch_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The role whose utterances the phrase matcher should be matched
     * against. If the role is ROLE_UNSPECIFIED it will be matched against any
     * utterances in the transcript.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
     * </code>
     *
     * @param value The roleMatch to set.
     * @return This builder for chaining.
     */
    public Builder setRoleMatch(
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      roleMatch_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role whose utterances the phrase matcher should be matched
     * against. If the role is ROLE_UNSPECIFIED it will be matched against any
     * utterances in the transcript.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role_match = 10;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoleMatch() {
      bitField0_ = (bitField0_ & ~0x00000200);
      roleMatch_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the phrase matcher was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.PhraseMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.PhraseMatcher)
  private static final com.google.cloud.contactcenterinsights.v1.PhraseMatcher DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.PhraseMatcher();
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhraseMatcher> PARSER =
      new com.google.protobuf.AbstractParser<PhraseMatcher>() {
        @java.lang.Override
        public PhraseMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PhraseMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhraseMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
