/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String conversation;

    @Deprecated
    protected ConversationName() {
        this.project = null;
        this.location = null;
        this.conversation = null;
    }

    private ConversationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversation() {
        return this.conversation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationName of(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build();
    }

    public static String format(String project, String location, String conversation) {
        return ConversationName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).build().toString();
    }

    public static ConversationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONVERSATION.validatedMatch(formattedString, "ConversationName.parse: formattedString not in valid format");
        return ConversationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"));
    }

    public static List<ConversationName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationName> list = new ArrayList<ConversationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationName conversationName = this;
            synchronized (conversationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONVERSATION.instantiate(new String[]{"project", this.project, "location", this.location, "conversation", this.conversation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ConversationName that = (ConversationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversation, that.conversation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        private Builder(ConversationName conversationName) {
            this.project = conversationName.project;
            this.location = conversationName.location;
            this.conversation = conversationName.conversation;
        }

        public ConversationName build() {
            return new ConversationName(this);
        }
    }
}

