/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ViewName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VIEW = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/views/{view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String view;

    @Deprecated
    protected ViewName() {
        this.project = null;
        this.location = null;
        this.view = null;
    }

    private ViewName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.view = (String)Preconditions.checkNotNull((Object)builder.getView());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getView() {
        return this.view;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ViewName of(String project, String location, String view) {
        return ViewName.newBuilder().setProject(project).setLocation(location).setView(view).build();
    }

    public static String format(String project, String location, String view) {
        return ViewName.newBuilder().setProject(project).setLocation(location).setView(view).build().toString();
    }

    public static ViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VIEW.validatedMatch(formattedString, "ViewName.parse: formattedString not in valid format");
        return ViewName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("view"));
    }

    public static List<ViewName> parseList(List<String> formattedStrings) {
        ArrayList<ViewName> list = new ArrayList<ViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VIEW.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ViewName viewName = this;
            synchronized (viewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.view != null) {
                        fieldMapBuilder.put((Object)"view", (Object)this.view);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VIEW.instantiate(new String[]{"project", this.project, "location", this.location, "view", this.view});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ViewName that = (ViewName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.view, that.view);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.view);
    }

    public static class Builder {
        private String project;
        private String location;
        private String view;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getView() {
            return this.view;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setView(String view) {
            this.view = view;
            return this;
        }

        private Builder(ViewName viewName) {
            this.project = viewName.project;
            this.location = viewName.location;
            this.view = viewName.view;
        }

        public ViewName build() {
            return new ViewName(this);
        }
    }
}

