/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedbackLabelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String conversation;
    private final String feedbackLabel;

    @Deprecated
    protected FeedbackLabelName() {
        this.project = null;
        this.location = null;
        this.conversation = null;
        this.feedbackLabel = null;
    }

    private FeedbackLabelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.feedbackLabel = (String)Preconditions.checkNotNull((Object)builder.getFeedbackLabel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getFeedbackLabel() {
        return this.feedbackLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedbackLabelName of(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build();
    }

    public static String format(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build().toString();
    }

    public static FeedbackLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.validatedMatch(formattedString, "FeedbackLabelName.parse: formattedString not in valid format");
        return FeedbackLabelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("feedback_label"));
    }

    public static List<FeedbackLabelName> parseList(List<String> formattedStrings) {
        ArrayList<FeedbackLabelName> list = new ArrayList<FeedbackLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedbackLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedbackLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedbackLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedbackLabelName feedbackLabelName = this;
            synchronized (feedbackLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.feedbackLabel != null) {
                        fieldMapBuilder.put((Object)"feedback_label", (Object)this.feedbackLabel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.instantiate(new String[]{"project", this.project, "location", this.location, "conversation", this.conversation, "feedback_label", this.feedbackLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeedbackLabelName that = (FeedbackLabelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.feedbackLabel, that.feedbackLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedbackLabel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversation;
        private String feedbackLabel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getFeedbackLabel() {
            return this.feedbackLabel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setFeedbackLabel(String feedbackLabel) {
            this.feedbackLabel = feedbackLabel;
            return this;
        }

        private Builder(FeedbackLabelName feedbackLabelName) {
            this.project = feedbackLabelName.project;
            this.location = feedbackLabelName.location;
            this.conversation = feedbackLabelName.conversation;
            this.feedbackLabel = feedbackLabelName.feedbackLabel;
        }

        public FeedbackLabelName build() {
            return new FeedbackLabelName(this);
        }
    }
}

