/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Metadata for the Bulk Upload Feedback Labels API.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata}
 */
public final class BulkUploadFeedbackLabelsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata)
    BulkUploadFeedbackLabelsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkUploadFeedbackLabelsMetadata.newBuilder() to construct.
  private BulkUploadFeedbackLabelsMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkUploadFeedbackLabelsMetadata() {
    partialErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkUploadFeedbackLabelsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.class,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.Builder
                .class);
  }

  public interface UploadStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of objects processed during the upload operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1;</code>
     *
     * @return The processedObjectCount.
     */
    int getProcessedObjectCount();

    /**
     *
     *
     * <pre>
     * The number of objects skipped because of failed validation
     * </pre>
     *
     * <code>int32 failed_validation_count = 2;</code>
     *
     * @return The failedValidationCount.
     */
    int getFailedValidationCount();

    /**
     *
     *
     * <pre>
     * The number of new feedback labels added during this ingest operation.
     * </pre>
     *
     * <code>int32 successful_upload_count = 3;</code>
     *
     * @return The successfulUploadCount.
     */
    int getSuccessfulUploadCount();
  }
  /**
   *
   *
   * <pre>
   * Statistics for BulkUploadFeedbackLabels operation.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats}
   */
  public static final class UploadStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
      UploadStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UploadStats.newBuilder() to construct.
    private UploadStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UploadStats() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UploadStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_UploadStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_UploadStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                  .class,
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                  .Builder.class);
    }

    public static final int PROCESSED_OBJECT_COUNT_FIELD_NUMBER = 1;
    private int processedObjectCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of objects processed during the upload operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1;</code>
     *
     * @return The processedObjectCount.
     */
    @java.lang.Override
    public int getProcessedObjectCount() {
      return processedObjectCount_;
    }

    public static final int FAILED_VALIDATION_COUNT_FIELD_NUMBER = 2;
    private int failedValidationCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of objects skipped because of failed validation
     * </pre>
     *
     * <code>int32 failed_validation_count = 2;</code>
     *
     * @return The failedValidationCount.
     */
    @java.lang.Override
    public int getFailedValidationCount() {
      return failedValidationCount_;
    }

    public static final int SUCCESSFUL_UPLOAD_COUNT_FIELD_NUMBER = 3;
    private int successfulUploadCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of new feedback labels added during this ingest operation.
     * </pre>
     *
     * <code>int32 successful_upload_count = 3;</code>
     *
     * @return The successfulUploadCount.
     */
    @java.lang.Override
    public int getSuccessfulUploadCount() {
      return successfulUploadCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (processedObjectCount_ != 0) {
        output.writeInt32(1, processedObjectCount_);
      }
      if (failedValidationCount_ != 0) {
        output.writeInt32(2, failedValidationCount_);
      }
      if (successfulUploadCount_ != 0) {
        output.writeInt32(3, successfulUploadCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (processedObjectCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, processedObjectCount_);
      }
      if (failedValidationCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, failedValidationCount_);
      }
      if (successfulUploadCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, successfulUploadCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats other =
          (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
              obj;

      if (getProcessedObjectCount() != other.getProcessedObjectCount()) return false;
      if (getFailedValidationCount() != other.getFailedValidationCount()) return false;
      if (getSuccessfulUploadCount() != other.getSuccessfulUploadCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSED_OBJECT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getProcessedObjectCount();
      hash = (37 * hash) + FAILED_VALIDATION_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getFailedValidationCount();
      hash = (37 * hash) + SUCCESSFUL_UPLOAD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessfulUploadCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_UploadStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_UploadStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats.class,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processedObjectCount_ = 0;
        failedValidationCount_ = 0;
        successfulUploadCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_UploadStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
          build() {
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            result =
                new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processedObjectCount_ = processedObjectCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.failedValidationCount_ = failedValidationCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.successfulUploadCount_ = successfulUploadCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                .UploadStats) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                      .UploadStats)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                .UploadStats.getDefaultInstance()) return this;
        if (other.getProcessedObjectCount() != 0) {
          setProcessedObjectCount(other.getProcessedObjectCount());
        }
        if (other.getFailedValidationCount() != 0) {
          setFailedValidationCount(other.getFailedValidationCount());
        }
        if (other.getSuccessfulUploadCount() != 0) {
          setSuccessfulUploadCount(other.getSuccessfulUploadCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  processedObjectCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  failedValidationCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  successfulUploadCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int processedObjectCount_;
      /**
       *
       *
       * <pre>
       * The number of objects processed during the upload operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @return The processedObjectCount.
       */
      @java.lang.Override
      public int getProcessedObjectCount() {
        return processedObjectCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of objects processed during the upload operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @param value The processedObjectCount to set.
       * @return This builder for chaining.
       */
      public Builder setProcessedObjectCount(int value) {

        processedObjectCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of objects processed during the upload operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessedObjectCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        processedObjectCount_ = 0;
        onChanged();
        return this;
      }

      private int failedValidationCount_;
      /**
       *
       *
       * <pre>
       * The number of objects skipped because of failed validation
       * </pre>
       *
       * <code>int32 failed_validation_count = 2;</code>
       *
       * @return The failedValidationCount.
       */
      @java.lang.Override
      public int getFailedValidationCount() {
        return failedValidationCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of objects skipped because of failed validation
       * </pre>
       *
       * <code>int32 failed_validation_count = 2;</code>
       *
       * @param value The failedValidationCount to set.
       * @return This builder for chaining.
       */
      public Builder setFailedValidationCount(int value) {

        failedValidationCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of objects skipped because of failed validation
       * </pre>
       *
       * <code>int32 failed_validation_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailedValidationCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        failedValidationCount_ = 0;
        onChanged();
        return this;
      }

      private int successfulUploadCount_;
      /**
       *
       *
       * <pre>
       * The number of new feedback labels added during this ingest operation.
       * </pre>
       *
       * <code>int32 successful_upload_count = 3;</code>
       *
       * @return The successfulUploadCount.
       */
      @java.lang.Override
      public int getSuccessfulUploadCount() {
        return successfulUploadCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of new feedback labels added during this ingest operation.
       * </pre>
       *
       * <code>int32 successful_upload_count = 3;</code>
       *
       * @param value The successfulUploadCount to set.
       * @return This builder for chaining.
       */
      public Builder setSuccessfulUploadCount(int value) {

        successfulUploadCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of new feedback labels added during this ingest operation.
       * </pre>
       *
       * <code>int32 successful_upload_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuccessfulUploadCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        successfulUploadCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats)
    private static final com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
              .UploadStats();
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UploadStats> PARSER =
        new com.google.protobuf.AbstractParser<UploadStats>() {
          @java.lang.Override
          public UploadStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UploadStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UploadStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request_;
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest getRequest() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for ingest.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder
      getRequestOrBuilder() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .getDefaultInstance()
        : request_;
  }

  public static final int PARTIAL_ERRORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialErrors_;
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getPartialErrorsOrBuilderList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public int getPartialErrorsCount() {
    return partialErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialErrors(int index) {
    return partialErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
    return partialErrors_.get(index);
  }

  public static final int UPLOAD_STATS_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
      uploadStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkUploadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the uploadStats field is set.
   */
  @java.lang.Override
  public boolean hasUploadStats() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkUploadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The uploadStats.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
      getUploadStats() {
    return uploadStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            .getDefaultInstance()
        : uploadStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkUploadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
          .UploadStatsOrBuilder
      getUploadStatsOrBuilder() {
    return uploadStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            .getDefaultInstance()
        : uploadStats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      output.writeMessage(4, partialErrors_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getUploadStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, partialErrors_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUploadStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata other =
        (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (!getPartialErrorsList().equals(other.getPartialErrorsList())) return false;
    if (hasUploadStats() != other.hasUploadStats()) return false;
    if (hasUploadStats()) {
      if (!getUploadStats().equals(other.getUploadStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (getPartialErrorsCount() > 0) {
      hash = (37 * hash) + PARTIAL_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialErrorsList().hashCode();
    }
    if (hasUploadStats()) {
      hash = (37 * hash) + UPLOAD_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getUploadStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the Bulk Upload Feedback Labels API.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata)
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.class,
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getRequestFieldBuilder();
        getPartialErrorsFieldBuilder();
        getUploadStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
      } else {
        partialErrors_ = null;
        partialErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      uploadStats_ = null;
      if (uploadStatsBuilder_ != null) {
        uploadStatsBuilder_.dispose();
        uploadStatsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata build() {
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata result =
          new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata result) {
      if (partialErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.partialErrors_ = partialErrors_;
      } else {
        result.partialErrors_ = partialErrorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.uploadStats_ =
            uploadStatsBuilder_ == null ? uploadStats_ : uploadStatsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
              .getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (partialErrorsBuilder_ == null) {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrors_.isEmpty()) {
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePartialErrorsIsMutable();
            partialErrors_.addAll(other.partialErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrorsBuilder_.isEmpty()) {
            partialErrorsBuilder_.dispose();
            partialErrorsBuilder_ = null;
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
            partialErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialErrorsFieldBuilder()
                    : null;
          } else {
            partialErrorsBuilder_.addAllMessages(other.partialErrors_);
          }
        }
      }
      if (other.hasUploadStats()) {
        mergeUploadStats(other.getUploadStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialErrorsBuilder_ == null) {
                  ensurePartialErrorsIsMutable();
                  partialErrors_.add(m);
                } else {
                  partialErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUploadStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The request.
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                .getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder
            builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRequest(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_
                != com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                    .getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder
        getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder
        getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                .getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for ingest.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private java.util.List<com.google.rpc.Status> partialErrors_ =
        java.util.Collections.emptyList();

    private void ensurePartialErrorsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>(partialErrors_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
      if (partialErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialErrors_);
      } else {
        return partialErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public int getPartialErrorsCount() {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.size();
      } else {
        return partialErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status getPartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addAllPartialErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialErrors_);
        onChanged();
      } else {
        partialErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder clearPartialErrors() {
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder removePartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.remove(index);
        onChanged();
      } else {
        partialErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder getPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialErrorsOrBuilderList() {
      if (partialErrorsBuilder_ != null) {
        return partialErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder() {
      return getPartialErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialErrorsBuilderList() {
      return getPartialErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialErrorsFieldBuilder() {
      if (partialErrorsBuilder_ == null) {
        partialErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialErrors_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        partialErrors_ = null;
      }
      return partialErrorsBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
        uploadStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                .Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                .UploadStatsOrBuilder>
        uploadStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the uploadStats field is set.
     */
    public boolean hasUploadStats() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The uploadStats.
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
        getUploadStats() {
      if (uploadStatsBuilder_ == null) {
        return uploadStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                .getDefaultInstance()
            : uploadStats_;
      } else {
        return uploadStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUploadStats(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            value) {
      if (uploadStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        uploadStats_ = value;
      } else {
        uploadStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUploadStats(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                .Builder
            builderForValue) {
      if (uploadStatsBuilder_ == null) {
        uploadStats_ = builderForValue.build();
      } else {
        uploadStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUploadStats(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            value) {
      if (uploadStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && uploadStats_ != null
            && uploadStats_
                != com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats.getDefaultInstance()) {
          getUploadStatsBuilder().mergeFrom(value);
        } else {
          uploadStats_ = value;
        }
      } else {
        uploadStatsBuilder_.mergeFrom(value);
      }
      if (uploadStats_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUploadStats() {
      bitField0_ = (bitField0_ & ~0x00000010);
      uploadStats_ = null;
      if (uploadStatsBuilder_ != null) {
        uploadStatsBuilder_.dispose();
        uploadStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
            .Builder
        getUploadStatsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUploadStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
            .UploadStatsOrBuilder
        getUploadStatsOrBuilder() {
      if (uploadStatsBuilder_ != null) {
        return uploadStatsBuilder_.getMessageOrBuilder();
      } else {
        return uploadStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                .getDefaultInstance()
            : uploadStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkUploadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats upload_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata.UploadStats
                .Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                .UploadStatsOrBuilder>
        getUploadStatsFieldBuilder() {
      if (uploadStatsBuilder_ == null) {
        uploadStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStats.Builder,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
                    .UploadStatsOrBuilder>(getUploadStats(), getParentForChildren(), isClean());
        uploadStats_ = null;
      }
      return uploadStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata)
  private static final com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata();
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkUploadFeedbackLabelsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BulkUploadFeedbackLabelsMetadata>() {
        @java.lang.Override
        public BulkUploadFeedbackLabelsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkUploadFeedbackLabelsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkUploadFeedbackLabelsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
