/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Aggregated statistics about an issue model.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModelLabelStats}
 */
public final class IssueModelLabelStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IssueModelLabelStats)
    IssueModelLabelStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IssueModelLabelStats.newBuilder() to construct.
  private IssueModelLabelStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IssueModelLabelStats() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IssueModelLabelStats();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetIssueStats();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.class,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder.class);
  }

  public interface IssueStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Issue resource.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The issue.
     */
    java.lang.String getIssue();
    /**
     *
     *
     * <pre>
     * Issue resource.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The bytes for issue.
     */
    com.google.protobuf.ByteString getIssueBytes();

    /**
     *
     *
     * <pre>
     * Number of conversations attached to the issue at this point in time.
     * </pre>
     *
     * <code>int64 labeled_conversations_count = 2;</code>
     *
     * @return The labeledConversationsCount.
     */
    long getLabeledConversationsCount();

    /**
     *
     *
     * <pre>
     * Display name of the issue.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * Display name of the issue.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * Aggregated statistics about an issue.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats}
   */
  public static final class IssueStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)
      IssueStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IssueStats.newBuilder() to construct.
    private IssueStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IssueStats() {
      issue_ = "";
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IssueStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.class,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder
                  .class);
    }

    public static final int ISSUE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object issue_ = "";
    /**
     *
     *
     * <pre>
     * Issue resource.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The issue.
     */
    @java.lang.Override
    public java.lang.String getIssue() {
      java.lang.Object ref = issue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Issue resource.
     * Format:
     * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
     * </pre>
     *
     * <code>string issue = 1;</code>
     *
     * @return The bytes for issue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIssueBytes() {
      java.lang.Object ref = issue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABELED_CONVERSATIONS_COUNT_FIELD_NUMBER = 2;
    private long labeledConversationsCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Number of conversations attached to the issue at this point in time.
     * </pre>
     *
     * <code>int64 labeled_conversations_count = 2;</code>
     *
     * @return The labeledConversationsCount.
     */
    @java.lang.Override
    public long getLabeledConversationsCount() {
      return labeledConversationsCount_;
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display name of the issue.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Display name of the issue.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issue_);
      }
      if (labeledConversationsCount_ != 0L) {
        output.writeInt64(2, labeledConversationsCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issue_);
      }
      if (labeledConversationsCount_ != 0L) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(2, labeledConversationsCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats other =
          (com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) obj;

      if (!getIssue().equals(other.getIssue())) return false;
      if (getLabeledConversationsCount() != other.getLabeledConversationsCount()) return false;
      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ISSUE_FIELD_NUMBER;
      hash = (53 * hash) + getIssue().hashCode();
      hash = (37 * hash) + LABELED_CONVERSATIONS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getLabeledConversationsCount());
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Aggregated statistics about an issue.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.class,
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        issue_ = "";
        labeledConversationsCount_ = 0L;
        displayName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats build() {
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats result =
            new com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.issue_ = issue_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.labeledConversationsCount_ = labeledConversationsCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.displayName_ = displayName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
                .getDefaultInstance()) return this;
        if (!other.getIssue().isEmpty()) {
          issue_ = other.issue_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getLabeledConversationsCount() != 0L) {
          setLabeledConversationsCount(other.getLabeledConversationsCount());
        }
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  issue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  labeledConversationsCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object issue_ = "";
      /**
       *
       *
       * <pre>
       * Issue resource.
       * Format:
       * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
       * </pre>
       *
       * <code>string issue = 1;</code>
       *
       * @return The issue.
       */
      public java.lang.String getIssue() {
        java.lang.Object ref = issue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Issue resource.
       * Format:
       * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
       * </pre>
       *
       * <code>string issue = 1;</code>
       *
       * @return The bytes for issue.
       */
      public com.google.protobuf.ByteString getIssueBytes() {
        java.lang.Object ref = issue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Issue resource.
       * Format:
       * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
       * </pre>
       *
       * <code>string issue = 1;</code>
       *
       * @param value The issue to set.
       * @return This builder for chaining.
       */
      public Builder setIssue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        issue_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue resource.
       * Format:
       * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
       * </pre>
       *
       * <code>string issue = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIssue() {
        issue_ = getDefaultInstance().getIssue();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Issue resource.
       * Format:
       * projects/{project}/locations/{location}/issueModels/{issue_model}/issues/{issue}
       * </pre>
       *
       * <code>string issue = 1;</code>
       *
       * @param value The bytes for issue to set.
       * @return This builder for chaining.
       */
      public Builder setIssueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        issue_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private long labeledConversationsCount_;
      /**
       *
       *
       * <pre>
       * Number of conversations attached to the issue at this point in time.
       * </pre>
       *
       * <code>int64 labeled_conversations_count = 2;</code>
       *
       * @return The labeledConversationsCount.
       */
      @java.lang.Override
      public long getLabeledConversationsCount() {
        return labeledConversationsCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of conversations attached to the issue at this point in time.
       * </pre>
       *
       * <code>int64 labeled_conversations_count = 2;</code>
       *
       * @param value The labeledConversationsCount to set.
       * @return This builder for chaining.
       */
      public Builder setLabeledConversationsCount(long value) {

        labeledConversationsCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of conversations attached to the issue at this point in time.
       * </pre>
       *
       * <code>int64 labeled_conversations_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLabeledConversationsCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        labeledConversationsCount_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * Display name of the issue.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name of the issue.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Display name of the issue.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name of the issue.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Display name of the issue.
       * </pre>
       *
       * <code>string display_name = 3;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats)
    private static final com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats();
    }

    public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IssueStats> PARSER =
        new com.google.protobuf.AbstractParser<IssueStats>() {
          @java.lang.Override
          public IssueStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IssueStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IssueStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANALYZED_CONVERSATIONS_COUNT_FIELD_NUMBER = 1;
  private long analyzedConversationsCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of conversations the issue model has analyzed at this point in time.
   * </pre>
   *
   * <code>int64 analyzed_conversations_count = 1;</code>
   *
   * @return The analyzedConversationsCount.
   */
  @java.lang.Override
  public long getAnalyzedConversationsCount() {
    return analyzedConversationsCount_;
  }

  public static final int UNCLASSIFIED_CONVERSATIONS_COUNT_FIELD_NUMBER = 2;
  private long unclassifiedConversationsCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Number of analyzed conversations for which no issue was applicable at this
   * point in time.
   * </pre>
   *
   * <code>int64 unclassified_conversations_count = 2;</code>
   *
   * @return The unclassifiedConversationsCount.
   */
  @java.lang.Override
  public long getUnclassifiedConversationsCount() {
    return unclassifiedConversationsCount_;
  }

  public static final int ISSUE_STATS_FIELD_NUMBER = 3;

  private static final class IssueStatsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
                    newDefaultInstance(
                        com.google.cloud.contactcenterinsights.v1.ResourcesProto
                            .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_IssueStatsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      issueStats_;

  private com.google.protobuf.MapField<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      internalGetIssueStats() {
    if (issueStats_ == null) {
      return com.google.protobuf.MapField.emptyMapField(IssueStatsDefaultEntryHolder.defaultEntry);
    }
    return issueStats_;
  }

  public int getIssueStatsCount() {
    return internalGetIssueStats().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Statistics on each issue. Key is the issue's resource name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
   * </code>
   */
  @java.lang.Override
  public boolean containsIssueStats(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetIssueStats().getMap().containsKey(key);
  }
  /** Use {@link #getIssueStatsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      getIssueStats() {
    return getIssueStatsMap();
  }
  /**
   *
   *
   * <pre>
   * Statistics on each issue. Key is the issue's resource name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String,
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
      getIssueStatsMap() {
    return internalGetIssueStats().getMap();
  }
  /**
   *
   *
   * <pre>
   * Statistics on each issue. Key is the issue's resource name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
      getIssueStatsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        map = internalGetIssueStats().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Statistics on each issue. Key is the issue's resource name.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
      getIssueStatsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        map = internalGetIssueStats().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (analyzedConversationsCount_ != 0L) {
      output.writeInt64(1, analyzedConversationsCount_);
    }
    if (unclassifiedConversationsCount_ != 0L) {
      output.writeInt64(2, unclassifiedConversationsCount_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetIssueStats(), IssueStatsDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (analyzedConversationsCount_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(1, analyzedConversationsCount_);
    }
    if (unclassifiedConversationsCount_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              2, unclassifiedConversationsCount_);
    }
    for (java.util.Map.Entry<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        entry : internalGetIssueStats().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          issueStats__ =
              IssueStatsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, issueStats__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats other =
        (com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats) obj;

    if (getAnalyzedConversationsCount() != other.getAnalyzedConversationsCount()) return false;
    if (getUnclassifiedConversationsCount() != other.getUnclassifiedConversationsCount())
      return false;
    if (!internalGetIssueStats().equals(other.internalGetIssueStats())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANALYZED_CONVERSATIONS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getAnalyzedConversationsCount());
    hash = (37 * hash) + UNCLASSIFIED_CONVERSATIONS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getUnclassifiedConversationsCount());
    if (!internalGetIssueStats().getMap().isEmpty()) {
      hash = (37 * hash) + ISSUE_STATS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetIssueStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Aggregated statistics about an issue model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IssueModelLabelStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IssueModelLabelStats)
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetIssueStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableIssueStats();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.class,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      analyzedConversationsCount_ = 0L;
      unclassifiedConversationsCount_ = 0L;
      internalGetMutableIssueStats().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_IssueModelLabelStats_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats build() {
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats buildPartial() {
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats result =
          new com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.analyzedConversationsCount_ = analyzedConversationsCount_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.unclassifiedConversationsCount_ = unclassifiedConversationsCount_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.issueStats_ =
            internalGetIssueStats().build(IssueStatsDefaultEntryHolder.defaultEntry);
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.getDefaultInstance())
        return this;
      if (other.getAnalyzedConversationsCount() != 0L) {
        setAnalyzedConversationsCount(other.getAnalyzedConversationsCount());
      }
      if (other.getUnclassifiedConversationsCount() != 0L) {
        setUnclassifiedConversationsCount(other.getUnclassifiedConversationsCount());
      }
      internalGetMutableIssueStats().mergeFrom(other.internalGetIssueStats());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                analyzedConversationsCount_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                unclassifiedConversationsCount_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
                    issueStats__ =
                        input.readMessage(
                            IssueStatsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableIssueStats()
                    .ensureBuilderMap()
                    .put(issueStats__.getKey(), issueStats__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long analyzedConversationsCount_;
    /**
     *
     *
     * <pre>
     * Number of conversations the issue model has analyzed at this point in time.
     * </pre>
     *
     * <code>int64 analyzed_conversations_count = 1;</code>
     *
     * @return The analyzedConversationsCount.
     */
    @java.lang.Override
    public long getAnalyzedConversationsCount() {
      return analyzedConversationsCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of conversations the issue model has analyzed at this point in time.
     * </pre>
     *
     * <code>int64 analyzed_conversations_count = 1;</code>
     *
     * @param value The analyzedConversationsCount to set.
     * @return This builder for chaining.
     */
    public Builder setAnalyzedConversationsCount(long value) {

      analyzedConversationsCount_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of conversations the issue model has analyzed at this point in time.
     * </pre>
     *
     * <code>int64 analyzed_conversations_count = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalyzedConversationsCount() {
      bitField0_ = (bitField0_ & ~0x00000001);
      analyzedConversationsCount_ = 0L;
      onChanged();
      return this;
    }

    private long unclassifiedConversationsCount_;
    /**
     *
     *
     * <pre>
     * Number of analyzed conversations for which no issue was applicable at this
     * point in time.
     * </pre>
     *
     * <code>int64 unclassified_conversations_count = 2;</code>
     *
     * @return The unclassifiedConversationsCount.
     */
    @java.lang.Override
    public long getUnclassifiedConversationsCount() {
      return unclassifiedConversationsCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of analyzed conversations for which no issue was applicable at this
     * point in time.
     * </pre>
     *
     * <code>int64 unclassified_conversations_count = 2;</code>
     *
     * @param value The unclassifiedConversationsCount to set.
     * @return This builder for chaining.
     */
    public Builder setUnclassifiedConversationsCount(long value) {

      unclassifiedConversationsCount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of analyzed conversations for which no issue was applicable at this
     * point in time.
     * </pre>
     *
     * <code>int64 unclassified_conversations_count = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnclassifiedConversationsCount() {
      bitField0_ = (bitField0_ & ~0x00000002);
      unclassifiedConversationsCount_ = 0L;
      onChanged();
      return this;
    }

    private static final class IssueStatsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats> {
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats build(
          com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder val) {
        if (val
            instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) {
          return (com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) val;
        }
        return ((com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder)
                val)
            .build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          defaultEntry() {
        return IssueStatsDefaultEntryHolder.defaultEntry;
      }
    };

    private static final IssueStatsConverter issueStatsConverter = new IssueStatsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder>
        issueStats_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder>
        internalGetIssueStats() {
      if (issueStats_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(issueStatsConverter);
      }
      return issueStats_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder>
        internalGetMutableIssueStats() {
      if (issueStats_ == null) {
        issueStats_ = new com.google.protobuf.MapFieldBuilder<>(issueStatsConverter);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return issueStats_;
    }

    public int getIssueStatsCount() {
      return internalGetIssueStats().ensureBuilderMap().size();
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    @java.lang.Override
    public boolean containsIssueStats(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetIssueStats().ensureBuilderMap().containsKey(key);
    }
    /** Use {@link #getIssueStatsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getIssueStats() {
      return getIssueStatsMap();
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getIssueStatsMap() {
      return internalGetIssueStats().getImmutableMap();
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getIssueStatsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
                defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder>
          map = internalGetMutableIssueStats().ensureBuilderMap();
      return map.containsKey(key) ? issueStatsConverter.build(map.get(key)) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats
        getIssueStatsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder>
          map = internalGetMutableIssueStats().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return issueStatsConverter.build(map.get(key));
    }

    public Builder clearIssueStats() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableIssueStats().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    public Builder removeIssueStats(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableIssueStats().ensureBuilderMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String,
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
        getMutableIssueStats() {
      bitField0_ |= 0x00000004;
      return internalGetMutableIssueStats().ensureMessageMap();
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    public Builder putIssueStats(
        java.lang.String key,
        com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableIssueStats().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    public Builder putAllIssueStats(
        java.util.Map<
                java.lang.String,
                com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
            values) {
      for (java.util.Map.Entry<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableIssueStats().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics on each issue. Key is the issue's resource name.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats&gt; issue_stats = 3;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder
        putIssueStatsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String,
              com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder>
          builderMap = internalGetMutableIssueStats().ensureBuilderMap();
      com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStatsOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry =
            com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry
          instanceof com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) {
        entry =
            ((com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats) entry)
                .toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats.IssueStats.Builder)
          entry;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IssueModelLabelStats)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IssueModelLabelStats)
  private static final com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats();
  }

  public static com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IssueModelLabelStats> PARSER =
      new com.google.protobuf.AbstractParser<IssueModelLabelStats>() {
        @java.lang.Override
        public IssueModelLabelStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IssueModelLabelStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IssueModelLabelStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueModelLabelStats
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
