/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

public interface ListConversationsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.ListConversationsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource of the conversation.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The parent resource of the conversation.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * The maximum number of conversations to return in the response. A valid page
   * size ranges from 0 to 100,000 inclusive. If the page size is zero or
   * unspecified, a default page size of 100 will be chosen. Note that a call
   * might return fewer results than the requested page size.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * The value returned by the last `ListConversationsResponse`. This value
   * indicates that this is a continuation of a prior `ListConversations` call
   * and that the system should return the next page of data.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();
  /**
   *
   *
   * <pre>
   * The value returned by the last `ListConversationsResponse`. This value
   * indicates that this is a continuation of a prior `ListConversations` call
   * and that the system should return the next page of data.
   * </pre>
   *
   * <code>string page_token = 3;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * A filter to reduce results to a specific subset. Useful for querying
   * conversations with specific properties.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();
  /**
   *
   *
   * <pre>
   * A filter to reduce results to a specific subset. Useful for querying
   * conversations with specific properties.
   * </pre>
   *
   * <code>string filter = 4;</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();

  /**
   *
   *
   * <pre>
   * Optional. The attribute by which to order conversations in the response.
   * If empty, conversations will be ordered by descending creation time.
   * Supported values are one of the following:
   *
   * * create_time
   * * customer_satisfaction_rating
   * * duration
   * * latest_analysis
   * * start_time
   * * turn_count
   *
   * The default sort order is ascending. To specify order, append `asc` or
   * `desc` (`create_time desc`).
   * For more details, see [Google AIPs
   * Ordering](https://google.aip.dev/132#ordering).
   * </pre>
   *
   * <code>string order_by = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  java.lang.String getOrderBy();
  /**
   *
   *
   * <pre>
   * Optional. The attribute by which to order conversations in the response.
   * If empty, conversations will be ordered by descending creation time.
   * Supported values are one of the following:
   *
   * * create_time
   * * customer_satisfaction_rating
   * * duration
   * * latest_analysis
   * * start_time
   * * turn_count
   *
   * The default sort order is ascending. To specify order, append `asc` or
   * `desc` (`create_time desc`).
   * For more details, see [Google AIPs
   * Ordering](https://google.aip.dev/132#ordering).
   * </pre>
   *
   * <code>string order_by = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  com.google.protobuf.ByteString getOrderByBytes();

  /**
   *
   *
   * <pre>
   * The level of details of the conversation. Default is `BASIC`.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationView view = 5;</code>
   *
   * @return The enum numeric value on the wire for view.
   */
  int getViewValue();
  /**
   *
   *
   * <pre>
   * The level of details of the conversation. Default is `BASIC`.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationView view = 5;</code>
   *
   * @return The view.
   */
  com.google.cloud.contactcenterinsights.v1.ConversationView getView();
}
