/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * A single question to be scored by the Insights QA feature.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion}
 */
public final class QaQuestion extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaQuestion)
    QaQuestionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QaQuestion.newBuilder() to construct.
  private QaQuestion(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QaQuestion() {
    name_ = "";
    abbreviation_ = "";
    questionBody_ = "";
    answerInstructions_ = "";
    answerChoices_ = java.util.Collections.emptyList();
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QaQuestion();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QaQuestion.class,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.Builder.class);
  }

  public interface AnswerChoiceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return Whether the strValue field is set.
     */
    boolean hasStrValue();
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The strValue.
     */
    java.lang.String getStrValue();
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The bytes for strValue.
     */
    com.google.protobuf.ByteString getStrValueBytes();

    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return Whether the numValue field is set.
     */
    boolean hasNumValue();
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return The numValue.
     */
    double getNumValue();

    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return Whether the boolValue field is set.
     */
    boolean hasBoolValue();
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return The boolValue.
     */
    boolean getBoolValue();

    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". If provided, this field may only
     * be set to `true`. If a question receives this answer, it will be
     * excluded from any score calculations.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return Whether the naValue field is set.
     */
    boolean hasNaValue();
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". If provided, this field may only
     * be set to `true`. If a question receives this answer, it will be
     * excluded from any score calculations.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return The naValue.
     */
    boolean getNaValue();

    /**
     *
     *
     * <pre>
     * A short string used as an identifier.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * A short string used as an identifier.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * Numerical score of the answer, used for generating the overall score of
     * a QaScorecardResult. If the answer uses na_value, this field is unused.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return Whether the score field is set.
     */
    boolean hasScore();
    /**
     *
     *
     * <pre>
     * Numerical score of the answer, used for generating the overall score of
     * a QaScorecardResult. If the answer uses na_value, this field is unused.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return The score.
     */
    double getScore();

    com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.ValueCase getValueCase();
  }
  /**
   *
   *
   * <pre>
   * Message representing a possible answer to the question.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice}
   */
  public static final class AnswerChoice extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)
      AnswerChoiceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerChoice.newBuilder() to construct.
    private AnswerChoice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerChoice() {
      key_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerChoice();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_AnswerChoice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_AnswerChoice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.class,
              com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder.class);
    }

    private int bitField0_;
    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STR_VALUE(2),
      NUM_VALUE(3),
      BOOL_VALUE(4),
      NA_VALUE(5),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 2:
            return STR_VALUE;
          case 3:
            return NUM_VALUE;
          case 4:
            return BOOL_VALUE;
          case 5:
            return NA_VALUE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int STR_VALUE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return Whether the strValue field is set.
     */
    public boolean hasStrValue() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The strValue.
     */
    public java.lang.String getStrValue() {
      java.lang.Object ref = "";
      if (valueCase_ == 2) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 2) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The bytes for strValue.
     */
    public com.google.protobuf.ByteString getStrValueBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 2) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 2) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUM_VALUE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return Whether the numValue field is set.
     */
    @java.lang.Override
    public boolean hasNumValue() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return The numValue.
     */
    @java.lang.Override
    public double getNumValue() {
      if (valueCase_ == 3) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int BOOL_VALUE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return Whether the boolValue field is set.
     */
    @java.lang.Override
    public boolean hasBoolValue() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return The boolValue.
     */
    @java.lang.Override
    public boolean getBoolValue() {
      if (valueCase_ == 4) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }

    public static final int NA_VALUE_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". If provided, this field may only
     * be set to `true`. If a question receives this answer, it will be
     * excluded from any score calculations.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return Whether the naValue field is set.
     */
    @java.lang.Override
    public boolean hasNaValue() {
      return valueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". If provided, this field may only
     * be set to `true`. If a question receives this answer, it will be
     * excluded from any score calculations.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return The naValue.
     */
    @java.lang.Override
    public boolean getNaValue() {
      if (valueCase_ == 5) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * A short string used as an identifier.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A short string used as an identifier.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 6;
    private double score_ = 0D;
    /**
     *
     *
     * <pre>
     * Numerical score of the answer, used for generating the overall score of
     * a QaScorecardResult. If the answer uses na_value, this field is unused.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Numerical score of the answer, used for generating the overall score of
     * a QaScorecardResult. If the answer uses na_value, this field is unused.
     * </pre>
     *
     * <code>optional double score = 6;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (valueCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      if (valueCase_ == 3) {
        output.writeDouble(3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        output.writeBool(4, (boolean) ((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        output.writeBool(5, (boolean) ((java.lang.Boolean) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(6, score_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (valueCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      if (valueCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, (boolean) ((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                5, (boolean) ((java.lang.Boolean) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, score_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice other =
          (com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (hasScore() != other.hasScore()) return false;
      if (hasScore()) {
        if (java.lang.Double.doubleToLongBits(getScore())
            != java.lang.Double.doubleToLongBits(other.getScore())) return false;
      }
      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 2:
          if (!getStrValue().equals(other.getStrValue())) return false;
          break;
        case 3:
          if (java.lang.Double.doubleToLongBits(getNumValue())
              != java.lang.Double.doubleToLongBits(other.getNumValue())) return false;
          break;
        case 4:
          if (getBoolValue() != other.getBoolValue()) return false;
          break;
        case 5:
          if (getNaValue() != other.getNaValue()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (hasScore()) {
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScore()));
      }
      switch (valueCase_) {
        case 2:
          hash = (37 * hash) + STR_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getStrValue().hashCode();
          break;
        case 3:
          hash = (37 * hash) + NUM_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getNumValue()));
          break;
        case 4:
          hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
          break;
        case 5:
          hash = (37 * hash) + NA_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNaValue());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message representing a possible answer to the question.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_AnswerChoice_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_AnswerChoice_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.class,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        score_ = 0D;
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_AnswerChoice_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice build() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice result =
            new com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.key_ = key_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.score_ = score_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
                .getDefaultInstance()) return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasScore()) {
          setScore(other.getScore());
        }
        switch (other.getValueCase()) {
          case STR_VALUE:
            {
              valueCase_ = 2;
              value_ = other.value_;
              onChanged();
              break;
            }
          case NUM_VALUE:
            {
              setNumValue(other.getNumValue());
              break;
            }
          case BOOL_VALUE:
            {
              setBoolValue(other.getBoolValue());
              break;
            }
          case NA_VALUE:
            {
              setNaValue(other.getNaValue());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  valueCase_ = 2;
                  value_ = s;
                  break;
                } // case 18
              case 25:
                {
                  value_ = input.readDouble();
                  valueCase_ = 3;
                  break;
                } // case 25
              case 32:
                {
                  value_ = input.readBool();
                  valueCase_ = 4;
                  break;
                } // case 32
              case 40:
                {
                  value_ = input.readBool();
                  valueCase_ = 5;
                  break;
                } // case 40
              case 49:
                {
                  score_ = input.readDouble();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 49
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return Whether the strValue field is set.
       */
      @java.lang.Override
      public boolean hasStrValue() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return The strValue.
       */
      @java.lang.Override
      public java.lang.String getStrValue() {
        java.lang.Object ref = "";
        if (valueCase_ == 2) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 2) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return The bytes for strValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getStrValueBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 2) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (valueCase_ == 2) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @param value The strValue to set.
       * @return This builder for chaining.
       */
      public Builder setStrValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrValue() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @param value The bytes for strValue to set.
       * @return This builder for chaining.
       */
      public Builder setStrValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return Whether the numValue field is set.
       */
      public boolean hasNumValue() {
        return valueCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return The numValue.
       */
      public double getNumValue() {
        if (valueCase_ == 3) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @param value The numValue to set.
       * @return This builder for chaining.
       */
      public Builder setNumValue(double value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumValue() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return Whether the boolValue field is set.
       */
      public boolean hasBoolValue() {
        return valueCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return The boolValue.
       */
      public boolean getBoolValue() {
        if (valueCase_ == 4) {
          return (java.lang.Boolean) value_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @param value The boolValue to set.
       * @return This builder for chaining.
       */
      public Builder setBoolValue(boolean value) {

        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBoolValue() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". If provided, this field may only
       * be set to `true`. If a question receives this answer, it will be
       * excluded from any score calculations.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return Whether the naValue field is set.
       */
      public boolean hasNaValue() {
        return valueCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". If provided, this field may only
       * be set to `true`. If a question receives this answer, it will be
       * excluded from any score calculations.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return The naValue.
       */
      public boolean getNaValue() {
        if (valueCase_ == 5) {
          return (java.lang.Boolean) value_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". If provided, this field may only
       * be set to `true`. If a question receives this answer, it will be
       * excluded from any score calculations.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @param value The naValue to set.
       * @return This builder for chaining.
       */
      public Builder setNaValue(boolean value) {

        valueCase_ = 5;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". If provided, this field may only
       * be set to `true`. If a question receives this answer, it will be
       * excluded from any score calculations.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNaValue() {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * A short string used as an identifier.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private double score_;
      /**
       *
       *
       * <pre>
       * Numerical score of the answer, used for generating the overall score of
       * a QaScorecardResult. If the answer uses na_value, this field is unused.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Numerical score of the answer, used for generating the overall score of
       * a QaScorecardResult. If the answer uses na_value, this field is unused.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Numerical score of the answer, used for generating the overall score of
       * a QaScorecardResult. If the answer uses na_value, this field is unused.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(double value) {

        score_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Numerical score of the answer, used for generating the overall score of
       * a QaScorecardResult. If the answer uses na_value, this field is unused.
       * </pre>
       *
       * <code>optional double score = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000020);
        score_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice)
    private static final com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerChoice> PARSER =
        new com.google.protobuf.AbstractParser<AnswerChoice>() {
          @java.lang.Override
          public AnswerChoice parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerChoice> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerChoice> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Accuracy of the model. Measures the percentage of correct
     * answers the model gave on the test set.
     * </pre>
     *
     * <code>double accuracy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The accuracy.
     */
    double getAccuracy();
  }
  /**
   *
   *
   * <pre>
   * A wrapper representing metrics calculated against a test-set on a LLM that
   * was fine tuned for this question.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.Metrics}
   */
  public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)
      MetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Metrics.newBuilder() to construct.
    private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Metrics() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Metrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_Metrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_Metrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.class,
              com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder.class);
    }

    public static final int ACCURACY_FIELD_NUMBER = 1;
    private double accuracy_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. Accuracy of the model. Measures the percentage of correct
     * answers the model gave on the test set.
     * </pre>
     *
     * <code>double accuracy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The accuracy.
     */
    @java.lang.Override
    public double getAccuracy() {
      return accuracy_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(accuracy_) != 0) {
        output.writeDouble(1, accuracy_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(accuracy_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, accuracy_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics other =
          (com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics) obj;

      if (java.lang.Double.doubleToLongBits(getAccuracy())
          != java.lang.Double.doubleToLongBits(other.getAccuracy())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getAccuracy()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A wrapper representing metrics calculated against a test-set on a LLM that
     * was fine tuned for this question.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.Metrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)
        com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_Metrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.class,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder.class);
      }

      // Construct using com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        accuracy_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_Metrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics build() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics result =
            new com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.accuracy_ = accuracy_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics) {
          return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance())
          return this;
        if (other.getAccuracy() != 0D) {
          setAccuracy(other.getAccuracy());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  accuracy_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double accuracy_;
      /**
       *
       *
       * <pre>
       * Output only. Accuracy of the model. Measures the percentage of correct
       * answers the model gave on the test set.
       * </pre>
       *
       * <code>double accuracy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The accuracy.
       */
      @java.lang.Override
      public double getAccuracy() {
        return accuracy_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Accuracy of the model. Measures the percentage of correct
       * answers the model gave on the test set.
       * </pre>
       *
       * <code>double accuracy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The accuracy to set.
       * @return This builder for chaining.
       */
      public Builder setAccuracy(double value) {

        accuracy_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Accuracy of the model. Measures the percentage of correct
       * answers the model gave on the test set.
       * </pre>
       *
       * <code>double accuracy = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAccuracy() {
        bitField0_ = (bitField0_ & ~0x00000001);
        accuracy_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaQuestion.Metrics)
    private static final com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Metrics> PARSER =
        new com.google.protobuf.AbstractParser<Metrics>() {
          @java.lang.Override
          public Metrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Metrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Metrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TuningMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Total number of valid labels provided for the question at the time of
     * tuining.
     * </pre>
     *
     * <code>int64 total_valid_label_count = 1;</code>
     *
     * @return The totalValidLabelCount.
     */
    long getTotalValidLabelCount();

    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the datasetValidationWarnings.
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        getDatasetValidationWarningsList();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return The count of datasetValidationWarnings.
     */
    int getDatasetValidationWarningsCount();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The datasetValidationWarnings at the given index.
     */
    com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning getDatasetValidationWarnings(
        int index);
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for datasetValidationWarnings.
     */
    java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
     */
    int getDatasetValidationWarningsValue(int index);

    /**
     *
     *
     * <pre>
     * Error status of the tuning operation for the question. Will only be set
     * if the tuning operation failed.
     * </pre>
     *
     * <code>string tuning_error = 3;</code>
     *
     * @return The tuningError.
     */
    java.lang.String getTuningError();
    /**
     *
     *
     * <pre>
     * Error status of the tuning operation for the question. Will only be set
     * if the tuning operation failed.
     * </pre>
     *
     * <code>string tuning_error = 3;</code>
     *
     * @return The bytes for tuningError.
     */
    com.google.protobuf.ByteString getTuningErrorBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the tuning operation for the question. Will only be set if a
   * scorecard containing this question has been tuned.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata}
   */
  public static final class TuningMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)
      TuningMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TuningMetadata.newBuilder() to construct.
    private TuningMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TuningMetadata() {
      datasetValidationWarnings_ = java.util.Collections.emptyList();
      tuningError_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TuningMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_TuningMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_TuningMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.class,
              com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder.class);
    }

    public static final int TOTAL_VALID_LABEL_COUNT_FIELD_NUMBER = 1;
    private long totalValidLabelCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Total number of valid labels provided for the question at the time of
     * tuining.
     * </pre>
     *
     * <code>int64 total_valid_label_count = 1;</code>
     *
     * @return The totalValidLabelCount.
     */
    @java.lang.Override
    public long getTotalValidLabelCount() {
      return totalValidLabelCount_;
    }

    public static final int DATASET_VALIDATION_WARNINGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> datasetValidationWarnings_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        datasetValidationWarnings_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>() {
              public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning convert(
                  java.lang.Integer from) {
                com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning result =
                    com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning.forNumber(
                        from);
                return result == null
                    ? com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
                        .UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the datasetValidationWarnings.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        getDatasetValidationWarningsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>(
          datasetValidationWarnings_, datasetValidationWarnings_converter_);
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return The count of datasetValidationWarnings.
     */
    @java.lang.Override
    public int getDatasetValidationWarningsCount() {
      return datasetValidationWarnings_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The datasetValidationWarnings at the given index.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
        getDatasetValidationWarnings(int index) {
      return datasetValidationWarnings_converter_.convert(datasetValidationWarnings_.get(index));
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for datasetValidationWarnings.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList() {
      return datasetValidationWarnings_;
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
     */
    @java.lang.Override
    public int getDatasetValidationWarningsValue(int index) {
      return datasetValidationWarnings_.get(index);
    }

    private int datasetValidationWarningsMemoizedSerializedSize;

    public static final int TUNING_ERROR_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tuningError_ = "";
    /**
     *
     *
     * <pre>
     * Error status of the tuning operation for the question. Will only be set
     * if the tuning operation failed.
     * </pre>
     *
     * <code>string tuning_error = 3;</code>
     *
     * @return The tuningError.
     */
    @java.lang.Override
    public java.lang.String getTuningError() {
      java.lang.Object ref = tuningError_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tuningError_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Error status of the tuning operation for the question. Will only be set
     * if the tuning operation failed.
     * </pre>
     *
     * <code>string tuning_error = 3;</code>
     *
     * @return The bytes for tuningError.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTuningErrorBytes() {
      java.lang.Object ref = tuningError_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tuningError_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (totalValidLabelCount_ != 0L) {
        output.writeInt64(1, totalValidLabelCount_);
      }
      if (getDatasetValidationWarningsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(datasetValidationWarningsMemoizedSerializedSize);
      }
      for (int i = 0; i < datasetValidationWarnings_.size(); i++) {
        output.writeEnumNoTag(datasetValidationWarnings_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningError_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, tuningError_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (totalValidLabelCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalValidLabelCount_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < datasetValidationWarnings_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  datasetValidationWarnings_.get(i));
        }
        size += dataSize;
        if (!getDatasetValidationWarningsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        datasetValidationWarningsMemoizedSerializedSize = dataSize;
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tuningError_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, tuningError_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata other =
          (com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata) obj;

      if (getTotalValidLabelCount() != other.getTotalValidLabelCount()) return false;
      if (!datasetValidationWarnings_.equals(other.datasetValidationWarnings_)) return false;
      if (!getTuningError().equals(other.getTuningError())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TOTAL_VALID_LABEL_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalValidLabelCount());
      if (getDatasetValidationWarningsCount() > 0) {
        hash = (37 * hash) + DATASET_VALIDATION_WARNINGS_FIELD_NUMBER;
        hash = (53 * hash) + datasetValidationWarnings_.hashCode();
      }
      hash = (37 * hash) + TUNING_ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getTuningError().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question. Will only be set if a
     * scorecard containing this question has been tuned.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_TuningMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_TuningMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.class,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        totalValidLabelCount_ = 0L;
        datasetValidationWarnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        tuningError_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_TuningMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata build() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata result =
            new com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          datasetValidationWarnings_ =
              java.util.Collections.unmodifiableList(datasetValidationWarnings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.datasetValidationWarnings_ = datasetValidationWarnings_;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.totalValidLabelCount_ = totalValidLabelCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.tuningError_ = tuningError_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
                .getDefaultInstance()) return this;
        if (other.getTotalValidLabelCount() != 0L) {
          setTotalValidLabelCount(other.getTotalValidLabelCount());
        }
        if (!other.datasetValidationWarnings_.isEmpty()) {
          if (datasetValidationWarnings_.isEmpty()) {
            datasetValidationWarnings_ = other.datasetValidationWarnings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDatasetValidationWarningsIsMutable();
            datasetValidationWarnings_.addAll(other.datasetValidationWarnings_);
          }
          onChanged();
        }
        if (!other.getTuningError().isEmpty()) {
          tuningError_ = other.tuningError_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  totalValidLabelCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureDatasetValidationWarningsIsMutable();
                  datasetValidationWarnings_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureDatasetValidationWarningsIsMutable();
                    datasetValidationWarnings_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              case 26:
                {
                  tuningError_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long totalValidLabelCount_;
      /**
       *
       *
       * <pre>
       * Total number of valid labels provided for the question at the time of
       * tuining.
       * </pre>
       *
       * <code>int64 total_valid_label_count = 1;</code>
       *
       * @return The totalValidLabelCount.
       */
      @java.lang.Override
      public long getTotalValidLabelCount() {
        return totalValidLabelCount_;
      }
      /**
       *
       *
       * <pre>
       * Total number of valid labels provided for the question at the time of
       * tuining.
       * </pre>
       *
       * <code>int64 total_valid_label_count = 1;</code>
       *
       * @param value The totalValidLabelCount to set.
       * @return This builder for chaining.
       */
      public Builder setTotalValidLabelCount(long value) {

        totalValidLabelCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of valid labels provided for the question at the time of
       * tuining.
       * </pre>
       *
       * <code>int64 total_valid_label_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalValidLabelCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        totalValidLabelCount_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> datasetValidationWarnings_ =
          java.util.Collections.emptyList();

      private void ensureDatasetValidationWarningsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          datasetValidationWarnings_ =
              new java.util.ArrayList<java.lang.Integer>(datasetValidationWarnings_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return A list containing the datasetValidationWarnings.
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
          getDatasetValidationWarningsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>(
            datasetValidationWarnings_, datasetValidationWarnings_converter_);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return The count of datasetValidationWarnings.
       */
      public int getDatasetValidationWarningsCount() {
        return datasetValidationWarnings_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The datasetValidationWarnings at the given index.
       */
      public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
          getDatasetValidationWarnings(int index) {
        return datasetValidationWarnings_converter_.convert(datasetValidationWarnings_.get(index));
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The datasetValidationWarnings to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetValidationWarnings(
          int index, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param value The datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addDatasetValidationWarnings(
          com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param values The datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addAllDatasetValidationWarnings(
          java.lang.Iterable<
                  ? extends com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
              values) {
        ensureDatasetValidationWarningsIsMutable();
        for (com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value : values) {
          datasetValidationWarnings_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetValidationWarnings() {
        datasetValidationWarnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for
       *     datasetValidationWarnings.
       */
      public java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList() {
        return java.util.Collections.unmodifiableList(datasetValidationWarnings_);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
       */
      public int getDatasetValidationWarningsValue(int index) {
        return datasetValidationWarnings_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for datasetValidationWarnings to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetValidationWarningsValue(int index, int value) {
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addDatasetValidationWarningsValue(int value) {
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param values The enum numeric values on the wire for datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addAllDatasetValidationWarningsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureDatasetValidationWarningsIsMutable();
        for (int value : values) {
          datasetValidationWarnings_.add(value);
        }
        onChanged();
        return this;
      }

      private java.lang.Object tuningError_ = "";
      /**
       *
       *
       * <pre>
       * Error status of the tuning operation for the question. Will only be set
       * if the tuning operation failed.
       * </pre>
       *
       * <code>string tuning_error = 3;</code>
       *
       * @return The tuningError.
       */
      public java.lang.String getTuningError() {
        java.lang.Object ref = tuningError_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tuningError_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Error status of the tuning operation for the question. Will only be set
       * if the tuning operation failed.
       * </pre>
       *
       * <code>string tuning_error = 3;</code>
       *
       * @return The bytes for tuningError.
       */
      public com.google.protobuf.ByteString getTuningErrorBytes() {
        java.lang.Object ref = tuningError_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tuningError_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Error status of the tuning operation for the question. Will only be set
       * if the tuning operation failed.
       * </pre>
       *
       * <code>string tuning_error = 3;</code>
       *
       * @param value The tuningError to set.
       * @return This builder for chaining.
       */
      public Builder setTuningError(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningError_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error status of the tuning operation for the question. Will only be set
       * if the tuning operation failed.
       * </pre>
       *
       * <code>string tuning_error = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTuningError() {
        tuningError_ = getDefaultInstance().getTuningError();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Error status of the tuning operation for the question. Will only be set
       * if the tuning operation failed.
       * </pre>
       *
       * <code>string tuning_error = 3;</code>
       *
       * @param value The bytes for tuningError to set.
       * @return This builder for chaining.
       */
      public Builder setTuningErrorBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tuningError_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TuningMetadata> PARSER =
        new com.google.protobuf.AbstractParser<TuningMetadata>() {
          @java.lang.Override
          public TuningMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TuningMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TuningMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the question.
   * Format:
   * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the question.
   * Format:
   * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ABBREVIATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object abbreviation_ = "";
  /**
   *
   *
   * <pre>
   * Short, descriptive string, used in the UI where it's not practical
   * to display the full question body. E.g., "Greeting".
   * </pre>
   *
   * <code>string abbreviation = 2;</code>
   *
   * @return The abbreviation.
   */
  @java.lang.Override
  public java.lang.String getAbbreviation() {
    java.lang.Object ref = abbreviation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      abbreviation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Short, descriptive string, used in the UI where it's not practical
   * to display the full question body. E.g., "Greeting".
   * </pre>
   *
   * <code>string abbreviation = 2;</code>
   *
   * @return The bytes for abbreviation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAbbreviationBytes() {
    java.lang.Object ref = abbreviation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      abbreviation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this question was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this question was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this question was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the question was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the question was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which the question was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int QUESTION_BODY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object questionBody_ = "";
  /**
   *
   *
   * <pre>
   * Question text. E.g., "Did the agent greet the customer?"
   * </pre>
   *
   * <code>string question_body = 5;</code>
   *
   * @return The questionBody.
   */
  @java.lang.Override
  public java.lang.String getQuestionBody() {
    java.lang.Object ref = questionBody_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      questionBody_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Question text. E.g., "Did the agent greet the customer?"
   * </pre>
   *
   * <code>string question_body = 5;</code>
   *
   * @return The bytes for questionBody.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuestionBodyBytes() {
    java.lang.Object ref = questionBody_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      questionBody_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_INSTRUCTIONS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object answerInstructions_ = "";
  /**
   *
   *
   * <pre>
   * Instructions describing how to determine the answer.
   * </pre>
   *
   * <code>string answer_instructions = 9;</code>
   *
   * @return The answerInstructions.
   */
  @java.lang.Override
  public java.lang.String getAnswerInstructions() {
    java.lang.Object ref = answerInstructions_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      answerInstructions_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Instructions describing how to determine the answer.
   * </pre>
   *
   * <code>string answer_instructions = 9;</code>
   *
   * @return The bytes for answerInstructions.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnswerInstructionsBytes() {
    java.lang.Object ref = answerInstructions_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      answerInstructions_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_CHOICES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>
      answerChoices_;
  /**
   *
   *
   * <pre>
   * A list of valid answers to the question, which the LLM must choose from.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>
      getAnswerChoicesList() {
    return answerChoices_;
  }
  /**
   *
   *
   * <pre>
   * A list of valid answers to the question, which the LLM must choose from.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder>
      getAnswerChoicesOrBuilderList() {
    return answerChoices_;
  }
  /**
   *
   *
   * <pre>
   * A list of valid answers to the question, which the LLM must choose from.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
   * </code>
   */
  @java.lang.Override
  public int getAnswerChoicesCount() {
    return answerChoices_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of valid answers to the question, which the LLM must choose from.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice getAnswerChoices(
      int index) {
    return answerChoices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of valid answers to the question, which the LLM must choose from.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder
      getAnswerChoicesOrBuilder(int index) {
    return answerChoices_.get(index);
  }

  public static final int TAGS_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags for the question. Used for
   * grouping/organization and for weighting the score of each question.
   * </pre>
   *
   * <code>repeated string tags = 7;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags for the question. Used for
   * grouping/organization and for weighting the score of each question.
   * </pre>
   *
   * <code>repeated string tags = 7;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags for the question. Used for
   * grouping/organization and for weighting the score of each question.
   * </pre>
   *
   * <code>repeated string tags = 7;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags for the question. Used for
   * grouping/organization and for weighting the score of each question.
   * </pre>
   *
   * <code>repeated string tags = 7;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int ORDER_FIELD_NUMBER = 8;
  private int order_ = 0;
  /**
   *
   *
   * <pre>
   * Defines the order of the question within its parent scorecard revision.
   * </pre>
   *
   * <code>int32 order = 8;</code>
   *
   * @return The order.
   */
  @java.lang.Override
  public int getOrder() {
    return order_;
  }

  public static final int METRICS_FIELD_NUMBER = 10;
  private com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics_;
  /**
   *
   *
   * <pre>
   * Metrics of the underlying tuned LLM over a holdout/test set while fine
   * tuning the underlying LLM for the given question. This field will only be
   * populated if and only if the question is part of a scorecard revision that
   * has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
   *
   * @return Whether the metrics field is set.
   */
  @java.lang.Override
  public boolean hasMetrics() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metrics of the underlying tuned LLM over a holdout/test set while fine
   * tuning the underlying LLM for the given question. This field will only be
   * populated if and only if the question is part of a scorecard revision that
   * has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
   *
   * @return The metrics.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics getMetrics() {
    return metrics_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance()
        : metrics_;
  }
  /**
   *
   *
   * <pre>
   * Metrics of the underlying tuned LLM over a holdout/test set while fine
   * tuning the underlying LLM for the given question. This field will only be
   * populated if and only if the question is part of a scorecard revision that
   * has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder
      getMetricsOrBuilder() {
    return metrics_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance()
        : metrics_;
  }

  public static final int TUNING_METADATA_FIELD_NUMBER = 11;
  private com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuningMetadata_;
  /**
   *
   *
   * <pre>
   * Metadata about the tuning operation for the question.This field will only
   * be populated if and only if the question is part of a scorecard revision
   * that has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
   * </code>
   *
   * @return Whether the tuningMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTuningMetadata() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Metadata about the tuning operation for the question.This field will only
   * be populated if and only if the question is part of a scorecard revision
   * that has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
   * </code>
   *
   * @return The tuningMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata getTuningMetadata() {
    return tuningMetadata_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.getDefaultInstance()
        : tuningMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Metadata about the tuning operation for the question.This field will only
   * be populated if and only if the question is part of a scorecard revision
   * that has been tuned.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder
      getTuningMetadataOrBuilder() {
    return tuningMetadata_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.getDefaultInstance()
        : tuningMetadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(abbreviation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, abbreviation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, questionBody_);
    }
    for (int i = 0; i < answerChoices_.size(); i++) {
      output.writeMessage(6, answerChoices_.get(i));
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, tags_.getRaw(i));
    }
    if (order_ != 0) {
      output.writeInt32(8, order_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerInstructions_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, answerInstructions_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getMetrics());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(11, getTuningMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(abbreviation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, abbreviation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, questionBody_);
    }
    for (int i = 0; i < answerChoices_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, answerChoices_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (order_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, order_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerInstructions_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, answerInstructions_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMetrics());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getTuningMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QaQuestion other =
        (com.google.cloud.contactcenterinsights.v1.QaQuestion) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAbbreviation().equals(other.getAbbreviation())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getQuestionBody().equals(other.getQuestionBody())) return false;
    if (!getAnswerInstructions().equals(other.getAnswerInstructions())) return false;
    if (!getAnswerChoicesList().equals(other.getAnswerChoicesList())) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (getOrder() != other.getOrder()) return false;
    if (hasMetrics() != other.hasMetrics()) return false;
    if (hasMetrics()) {
      if (!getMetrics().equals(other.getMetrics())) return false;
    }
    if (hasTuningMetadata() != other.hasTuningMetadata()) return false;
    if (hasTuningMetadata()) {
      if (!getTuningMetadata().equals(other.getTuningMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ABBREVIATION_FIELD_NUMBER;
    hash = (53 * hash) + getAbbreviation().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + QUESTION_BODY_FIELD_NUMBER;
    hash = (53 * hash) + getQuestionBody().hashCode();
    hash = (37 * hash) + ANSWER_INSTRUCTIONS_FIELD_NUMBER;
    hash = (53 * hash) + getAnswerInstructions().hashCode();
    if (getAnswerChoicesCount() > 0) {
      hash = (37 * hash) + ANSWER_CHOICES_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerChoicesList().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (37 * hash) + ORDER_FIELD_NUMBER;
    hash = (53 * hash) + getOrder();
    if (hasMetrics()) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetrics().hashCode();
    }
    if (hasTuningMetadata()) {
      hash = (37 * hash) + TUNING_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getTuningMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.QaQuestion prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A single question to be scored by the Insights QA feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaQuestion}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaQuestion)
      com.google.cloud.contactcenterinsights.v1.QaQuestionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaQuestion.class,
              com.google.cloud.contactcenterinsights.v1.QaQuestion.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QaQuestion.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getAnswerChoicesFieldBuilder();
        getMetricsFieldBuilder();
        getTuningMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      abbreviation_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      questionBody_ = "";
      answerInstructions_ = "";
      if (answerChoicesBuilder_ == null) {
        answerChoices_ = java.util.Collections.emptyList();
      } else {
        answerChoices_ = null;
        answerChoicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      order_ = 0;
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      tuningMetadata_ = null;
      if (tuningMetadataBuilder_ != null) {
        tuningMetadataBuilder_.dispose();
        tuningMetadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaQuestion_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QaQuestion.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion build() {
      com.google.cloud.contactcenterinsights.v1.QaQuestion result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaQuestion buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QaQuestion result =
          new com.google.cloud.contactcenterinsights.v1.QaQuestion(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.QaQuestion result) {
      if (answerChoicesBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          answerChoices_ = java.util.Collections.unmodifiableList(answerChoices_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.answerChoices_ = answerChoices_;
      } else {
        result.answerChoices_ = answerChoicesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.QaQuestion result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.abbreviation_ = abbreviation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.questionBody_ = questionBody_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.answerInstructions_ = answerInstructions_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.order_ = order_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.tuningMetadata_ =
            tuningMetadataBuilder_ == null ? tuningMetadata_ : tuningMetadataBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QaQuestion) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaQuestion) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QaQuestion other) {
      if (other == com.google.cloud.contactcenterinsights.v1.QaQuestion.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getAbbreviation().isEmpty()) {
        abbreviation_ = other.abbreviation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getQuestionBody().isEmpty()) {
        questionBody_ = other.questionBody_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.getAnswerInstructions().isEmpty()) {
        answerInstructions_ = other.answerInstructions_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (answerChoicesBuilder_ == null) {
        if (!other.answerChoices_.isEmpty()) {
          if (answerChoices_.isEmpty()) {
            answerChoices_ = other.answerChoices_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureAnswerChoicesIsMutable();
            answerChoices_.addAll(other.answerChoices_);
          }
          onChanged();
        }
      } else {
        if (!other.answerChoices_.isEmpty()) {
          if (answerChoicesBuilder_.isEmpty()) {
            answerChoicesBuilder_.dispose();
            answerChoicesBuilder_ = null;
            answerChoices_ = other.answerChoices_;
            bitField0_ = (bitField0_ & ~0x00000040);
            answerChoicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnswerChoicesFieldBuilder()
                    : null;
          } else {
            answerChoicesBuilder_.addAllMessages(other.answerChoices_);
          }
        }
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000080;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (other.getOrder() != 0) {
        setOrder(other.getOrder());
      }
      if (other.hasMetrics()) {
        mergeMetrics(other.getMetrics());
      }
      if (other.hasTuningMetadata()) {
        mergeTuningMetadata(other.getTuningMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                abbreviation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                questionBody_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.parser(),
                        extensionRegistry);
                if (answerChoicesBuilder_ == null) {
                  ensureAnswerChoicesIsMutable();
                  answerChoices_.add(m);
                } else {
                  answerChoicesBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 58
            case 64:
              {
                order_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 64
            case 74:
              {
                answerInstructions_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getTuningMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the question.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the question.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the question.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the question.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the question.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}/qaQuestions/{qa_question}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object abbreviation_ = "";
    /**
     *
     *
     * <pre>
     * Short, descriptive string, used in the UI where it's not practical
     * to display the full question body. E.g., "Greeting".
     * </pre>
     *
     * <code>string abbreviation = 2;</code>
     *
     * @return The abbreviation.
     */
    public java.lang.String getAbbreviation() {
      java.lang.Object ref = abbreviation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        abbreviation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short, descriptive string, used in the UI where it's not practical
     * to display the full question body. E.g., "Greeting".
     * </pre>
     *
     * <code>string abbreviation = 2;</code>
     *
     * @return The bytes for abbreviation.
     */
    public com.google.protobuf.ByteString getAbbreviationBytes() {
      java.lang.Object ref = abbreviation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        abbreviation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short, descriptive string, used in the UI where it's not practical
     * to display the full question body. E.g., "Greeting".
     * </pre>
     *
     * <code>string abbreviation = 2;</code>
     *
     * @param value The abbreviation to set.
     * @return This builder for chaining.
     */
    public Builder setAbbreviation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      abbreviation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short, descriptive string, used in the UI where it's not practical
     * to display the full question body. E.g., "Greeting".
     * </pre>
     *
     * <code>string abbreviation = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAbbreviation() {
      abbreviation_ = getDefaultInstance().getAbbreviation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short, descriptive string, used in the UI where it's not practical
     * to display the full question body. E.g., "Greeting".
     * </pre>
     *
     * <code>string abbreviation = 2;</code>
     *
     * @param value The bytes for abbreviation to set.
     * @return This builder for chaining.
     */
    public Builder setAbbreviationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      abbreviation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this question was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which the question was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object questionBody_ = "";
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 5;</code>
     *
     * @return The questionBody.
     */
    public java.lang.String getQuestionBody() {
      java.lang.Object ref = questionBody_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        questionBody_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 5;</code>
     *
     * @return The bytes for questionBody.
     */
    public com.google.protobuf.ByteString getQuestionBodyBytes() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        questionBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 5;</code>
     *
     * @param value The questionBody to set.
     * @return This builder for chaining.
     */
    public Builder setQuestionBody(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      questionBody_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuestionBody() {
      questionBody_ = getDefaultInstance().getQuestionBody();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 5;</code>
     *
     * @param value The bytes for questionBody to set.
     * @return This builder for chaining.
     */
    public Builder setQuestionBodyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      questionBody_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object answerInstructions_ = "";
    /**
     *
     *
     * <pre>
     * Instructions describing how to determine the answer.
     * </pre>
     *
     * <code>string answer_instructions = 9;</code>
     *
     * @return The answerInstructions.
     */
    public java.lang.String getAnswerInstructions() {
      java.lang.Object ref = answerInstructions_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerInstructions_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Instructions describing how to determine the answer.
     * </pre>
     *
     * <code>string answer_instructions = 9;</code>
     *
     * @return The bytes for answerInstructions.
     */
    public com.google.protobuf.ByteString getAnswerInstructionsBytes() {
      java.lang.Object ref = answerInstructions_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerInstructions_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Instructions describing how to determine the answer.
     * </pre>
     *
     * <code>string answer_instructions = 9;</code>
     *
     * @param value The answerInstructions to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerInstructions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      answerInstructions_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructions describing how to determine the answer.
     * </pre>
     *
     * <code>string answer_instructions = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnswerInstructions() {
      answerInstructions_ = getDefaultInstance().getAnswerInstructions();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instructions describing how to determine the answer.
     * </pre>
     *
     * <code>string answer_instructions = 9;</code>
     *
     * @param value The bytes for answerInstructions to set.
     * @return This builder for chaining.
     */
    public Builder setAnswerInstructionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      answerInstructions_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>
        answerChoices_ = java.util.Collections.emptyList();

    private void ensureAnswerChoicesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        answerChoices_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>(answerChoices_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder>
        answerChoicesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>
        getAnswerChoicesList() {
      if (answerChoicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(answerChoices_);
      } else {
        return answerChoicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public int getAnswerChoicesCount() {
      if (answerChoicesBuilder_ == null) {
        return answerChoices_.size();
      } else {
        return answerChoicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice getAnswerChoices(
        int index) {
      if (answerChoicesBuilder_ == null) {
        return answerChoices_.get(index);
      } else {
        return answerChoicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder setAnswerChoices(
        int index, com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice value) {
      if (answerChoicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerChoicesIsMutable();
        answerChoices_.set(index, value);
        onChanged();
      } else {
        answerChoicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder setAnswerChoices(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder builderForValue) {
      if (answerChoicesBuilder_ == null) {
        ensureAnswerChoicesIsMutable();
        answerChoices_.set(index, builderForValue.build());
        onChanged();
      } else {
        answerChoicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder addAnswerChoices(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice value) {
      if (answerChoicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerChoicesIsMutable();
        answerChoices_.add(value);
        onChanged();
      } else {
        answerChoicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder addAnswerChoices(
        int index, com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice value) {
      if (answerChoicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerChoicesIsMutable();
        answerChoices_.add(index, value);
        onChanged();
      } else {
        answerChoicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder addAnswerChoices(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder builderForValue) {
      if (answerChoicesBuilder_ == null) {
        ensureAnswerChoicesIsMutable();
        answerChoices_.add(builderForValue.build());
        onChanged();
      } else {
        answerChoicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder addAnswerChoices(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder builderForValue) {
      if (answerChoicesBuilder_ == null) {
        ensureAnswerChoicesIsMutable();
        answerChoices_.add(index, builderForValue.build());
        onChanged();
      } else {
        answerChoicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder addAllAnswerChoices(
        java.lang.Iterable<
                ? extends com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice>
            values) {
      if (answerChoicesBuilder_ == null) {
        ensureAnswerChoicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, answerChoices_);
        onChanged();
      } else {
        answerChoicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder clearAnswerChoices() {
      if (answerChoicesBuilder_ == null) {
        answerChoices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        answerChoicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public Builder removeAnswerChoices(int index) {
      if (answerChoicesBuilder_ == null) {
        ensureAnswerChoicesIsMutable();
        answerChoices_.remove(index);
        onChanged();
      } else {
        answerChoicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder
        getAnswerChoicesBuilder(int index) {
      return getAnswerChoicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder
        getAnswerChoicesOrBuilder(int index) {
      if (answerChoicesBuilder_ == null) {
        return answerChoices_.get(index);
      } else {
        return answerChoicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder>
        getAnswerChoicesOrBuilderList() {
      if (answerChoicesBuilder_ != null) {
        return answerChoicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(answerChoices_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder
        addAnswerChoicesBuilder() {
      return getAnswerChoicesFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder
        addAnswerChoicesBuilder(int index) {
      return getAnswerChoicesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of valid answers to the question, which the LLM must choose from.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice answer_choices = 6;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder>
        getAnswerChoicesBuilderList() {
      return getAnswerChoicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder>
        getAnswerChoicesFieldBuilder() {
      if (answerChoicesBuilder_ == null) {
        answerChoicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice.Builder,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoiceOrBuilder>(
                answerChoices_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        answerChoices_ = null;
      }
      return answerChoicesBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags for the question. Used for
     * grouping/organization and for weighting the score of each question.
     * </pre>
     *
     * <code>repeated string tags = 7;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int order_;
    /**
     *
     *
     * <pre>
     * Defines the order of the question within its parent scorecard revision.
     * </pre>
     *
     * <code>int32 order = 8;</code>
     *
     * @return The order.
     */
    @java.lang.Override
    public int getOrder() {
      return order_;
    }
    /**
     *
     *
     * <pre>
     * Defines the order of the question within its parent scorecard revision.
     * </pre>
     *
     * <code>int32 order = 8;</code>
     *
     * @param value The order to set.
     * @return This builder for chaining.
     */
    public Builder setOrder(int value) {

      order_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Defines the order of the question within its parent scorecard revision.
     * </pre>
     *
     * <code>int32 order = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrder() {
      bitField0_ = (bitField0_ & ~0x00000100);
      order_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder>
        metricsBuilder_;
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     *
     * @return Whether the metrics field is set.
     */
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     *
     * @return The metrics.
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics getMetrics() {
      if (metricsBuilder_ == null) {
        return metrics_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance()
            : metrics_;
      } else {
        return metricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public Builder setMetrics(com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metrics_ = value;
      } else {
        metricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public Builder setMetrics(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        metrics_ = builderForValue.build();
      } else {
        metricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public Builder mergeMetrics(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics value) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && metrics_ != null
            && metrics_
                != com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics
                    .getDefaultInstance()) {
          getMetricsBuilder().mergeFrom(value);
        } else {
          metrics_ = value;
        }
      } else {
        metricsBuilder_.mergeFrom(value);
      }
      if (metrics_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public Builder clearMetrics() {
      bitField0_ = (bitField0_ & ~0x00000200);
      metrics_ = null;
      if (metricsBuilder_ != null) {
        metricsBuilder_.dispose();
        metricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder
        getMetricsBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder
        getMetricsOrBuilder() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilder();
      } else {
        return metrics_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.getDefaultInstance()
            : metrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metrics of the underlying tuned LLM over a holdout/test set while fine
     * tuning the underlying LLM for the given question. This field will only be
     * populated if and only if the question is part of a scorecard revision that
     * has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics metrics = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.Metrics.Builder,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.MetricsOrBuilder>(
                getMetrics(), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuningMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder>
        tuningMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     *
     * @return Whether the tuningMetadata field is set.
     */
    public boolean hasTuningMetadata() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     *
     * @return The tuningMetadata.
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata getTuningMetadata() {
      if (tuningMetadataBuilder_ == null) {
        return tuningMetadata_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
                .getDefaultInstance()
            : tuningMetadata_;
      } else {
        return tuningMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public Builder setTuningMetadata(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata value) {
      if (tuningMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tuningMetadata_ = value;
      } else {
        tuningMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public Builder setTuningMetadata(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder
            builderForValue) {
      if (tuningMetadataBuilder_ == null) {
        tuningMetadata_ = builderForValue.build();
      } else {
        tuningMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public Builder mergeTuningMetadata(
        com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata value) {
      if (tuningMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && tuningMetadata_ != null
            && tuningMetadata_
                != com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
                    .getDefaultInstance()) {
          getTuningMetadataBuilder().mergeFrom(value);
        } else {
          tuningMetadata_ = value;
        }
      } else {
        tuningMetadataBuilder_.mergeFrom(value);
      }
      if (tuningMetadata_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public Builder clearTuningMetadata() {
      bitField0_ = (bitField0_ & ~0x00000400);
      tuningMetadata_ = null;
      if (tuningMetadataBuilder_ != null) {
        tuningMetadataBuilder_.dispose();
        tuningMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder
        getTuningMetadataBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getTuningMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder
        getTuningMetadataOrBuilder() {
      if (tuningMetadataBuilder_ != null) {
        return tuningMetadataBuilder_.getMessageOrBuilder();
      } else {
        return tuningMetadata_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata
                .getDefaultInstance()
            : tuningMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Metadata about the tuning operation for the question.This field will only
     * be populated if and only if the question is part of a scorecard revision
     * that has been tuned.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata tuning_metadata = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder>
        getTuningMetadataFieldBuilder() {
      if (tuningMetadataBuilder_ == null) {
        tuningMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.QaQuestion.TuningMetadataOrBuilder>(
                getTuningMetadata(), getParentForChildren(), isClean());
        tuningMetadata_ = null;
      }
      return tuningMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaQuestion)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaQuestion)
  private static final com.google.cloud.contactcenterinsights.v1.QaQuestion DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaQuestion();
  }

  public static com.google.cloud.contactcenterinsights.v1.QaQuestion getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QaQuestion> PARSER =
      new com.google.protobuf.AbstractParser<QaQuestion>() {
        @java.lang.Override
        public QaQuestion parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QaQuestion> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QaQuestion> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaQuestion getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
