/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * A revision of a QaScorecard.
 *
 * Modifying published scorecard fields would invalidate existing scorecard
 * results — the questions may have changed, or the score weighting will make
 * existing scores impossible to understand. So changes must create a new
 * revision, rather than modifying the existing resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardRevision}
 */
public final class QaScorecardRevision extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaScorecardRevision)
    QaScorecardRevisionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QaScorecardRevision.newBuilder() to construct.
  private QaScorecardRevision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QaScorecardRevision() {
    name_ = "";
    alternateIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QaScorecardRevision();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardRevision_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardRevision_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.class,
            com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum representing the set of states a scorecard revision may be in.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.QaScorecardRevision.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The scorecard revision can be edited.
     * </pre>
     *
     * <code>EDITABLE = 12;</code>
     */
    EDITABLE(12),
    /**
     *
     *
     * <pre>
     * Scorecard model training is in progress.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    TRAINING(2),
    /**
     *
     *
     * <pre>
     * Scorecard revision model training failed.
     * </pre>
     *
     * <code>TRAINING_FAILED = 9;</code>
     */
    TRAINING_FAILED(9),
    /**
     *
     *
     * <pre>
     * The revision can be used in analysis.
     * </pre>
     *
     * <code>READY = 11;</code>
     */
    READY(11),
    /**
     *
     *
     * <pre>
     * Scorecard is being deleted.
     * </pre>
     *
     * <code>DELETING = 7;</code>
     */
    DELETING(7),
    /**
     *
     *
     * <pre>
     * Scorecard model training was explicitly cancelled by the user.
     * </pre>
     *
     * <code>TRAINING_CANCELLED = 14;</code>
     */
    TRAINING_CANCELLED(14),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The scorecard revision can be edited.
     * </pre>
     *
     * <code>EDITABLE = 12;</code>
     */
    public static final int EDITABLE_VALUE = 12;
    /**
     *
     *
     * <pre>
     * Scorecard model training is in progress.
     * </pre>
     *
     * <code>TRAINING = 2;</code>
     */
    public static final int TRAINING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Scorecard revision model training failed.
     * </pre>
     *
     * <code>TRAINING_FAILED = 9;</code>
     */
    public static final int TRAINING_FAILED_VALUE = 9;
    /**
     *
     *
     * <pre>
     * The revision can be used in analysis.
     * </pre>
     *
     * <code>READY = 11;</code>
     */
    public static final int READY_VALUE = 11;
    /**
     *
     *
     * <pre>
     * Scorecard is being deleted.
     * </pre>
     *
     * <code>DELETING = 7;</code>
     */
    public static final int DELETING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * Scorecard model training was explicitly cancelled by the user.
     * </pre>
     *
     * <code>TRAINING_CANCELLED = 14;</code>
     */
    public static final int TRAINING_CANCELLED_VALUE = 14;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 12:
          return EDITABLE;
        case 2:
          return TRAINING;
        case 9:
          return TRAINING_FAILED;
        case 11:
          return READY;
        case 7:
          return DELETING;
        case 14:
          return TRAINING_CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.QaScorecardRevision.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The name of the scorecard revision.
   * Format:
   * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The name of the scorecard revision.
   * Format:
   * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_FIELD_NUMBER = 2;
  private com.google.cloud.contactcenterinsights.v1.QaScorecard snapshot_;
  /**
   *
   *
   * <pre>
   * The snapshot of the scorecard at the time of this revision's creation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
   *
   * @return Whether the snapshot field is set.
   */
  @java.lang.Override
  public boolean hasSnapshot() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The snapshot of the scorecard at the time of this revision's creation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
   *
   * @return The snapshot.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecard getSnapshot() {
    return snapshot_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaScorecard.getDefaultInstance()
        : snapshot_;
  }
  /**
   *
   *
   * <pre>
   * The snapshot of the scorecard at the time of this revision's creation.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardOrBuilder getSnapshotOrBuilder() {
    return snapshot_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaScorecard.getDefaultInstance()
        : snapshot_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int ALTERNATE_IDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList alternateIds_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Alternative IDs for this revision of the scorecard, e.g.,
   * `latest`.
   * </pre>
   *
   * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return A list containing the alternateIds.
   */
  public com.google.protobuf.ProtocolStringList getAlternateIdsList() {
    return alternateIds_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Alternative IDs for this revision of the scorecard, e.g.,
   * `latest`.
   * </pre>
   *
   * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The count of alternateIds.
   */
  public int getAlternateIdsCount() {
    return alternateIds_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Alternative IDs for this revision of the scorecard, e.g.,
   * `latest`.
   * </pre>
   *
   * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the element to return.
   * @return The alternateIds at the given index.
   */
  public java.lang.String getAlternateIds(int index) {
    return alternateIds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Alternative IDs for this revision of the scorecard, e.g.,
   * `latest`.
   * </pre>
   *
   * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the alternateIds at the given index.
   */
  public com.google.protobuf.ByteString getAlternateIdsBytes(int index) {
    return alternateIds_.getByteString(index);
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the scorecard revision, indicating whether it's ready
   * to be used in analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the scorecard revision, indicating whether it's ready
   * to be used in analysis.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State getState() {
    com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State result =
        com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.forNumber(state_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getSnapshot());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    for (int i = 0; i < alternateIds_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, alternateIds_.getRaw(i));
    }
    if (state_
        != com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, state_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSnapshot());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < alternateIds_.size(); i++) {
        dataSize += computeStringSizeNoTag(alternateIds_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAlternateIdsList().size();
    }
    if (state_
        != com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardRevision)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QaScorecardRevision other =
        (com.google.cloud.contactcenterinsights.v1.QaScorecardRevision) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasSnapshot() != other.hasSnapshot()) return false;
    if (hasSnapshot()) {
      if (!getSnapshot().equals(other.getSnapshot())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getAlternateIdsList().equals(other.getAlternateIdsList())) return false;
    if (state_ != other.state_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasSnapshot()) {
      hash = (37 * hash) + SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshot().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getAlternateIdsCount() > 0) {
      hash = (37 * hash) + ALTERNATE_IDS_FIELD_NUMBER;
      hash = (53 * hash) + getAlternateIdsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.QaScorecardRevision prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A revision of a QaScorecard.
   *
   * Modifying published scorecard fields would invalidate existing scorecard
   * results — the questions may have changed, or the score weighting will make
   * existing scores impossible to understand. So changes must create a new
   * revision, rather than modifying the existing resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardRevision}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaScorecardRevision)
      com.google.cloud.contactcenterinsights.v1.QaScorecardRevisionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardRevision_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardRevision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.class,
              com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSnapshotFieldBuilder();
        getCreateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      snapshot_ = null;
      if (snapshotBuilder_ != null) {
        snapshotBuilder_.dispose();
        snapshotBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      alternateIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      state_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardRevision_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision build() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardRevision result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardRevision result =
          new com.google.cloud.contactcenterinsights.v1.QaScorecardRevision(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.QaScorecardRevision result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.snapshot_ = snapshotBuilder_ == null ? snapshot_ : snapshotBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        alternateIds_.makeImmutable();
        result.alternateIds_ = alternateIds_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardRevision) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaScorecardRevision) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QaScorecardRevision other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSnapshot()) {
        mergeSnapshot(other.getSnapshot());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.alternateIds_.isEmpty()) {
        if (alternateIds_.isEmpty()) {
          alternateIds_ = other.alternateIds_;
          bitField0_ |= 0x00000008;
        } else {
          ensureAlternateIdsIsMutable();
          alternateIds_.addAll(other.alternateIds_);
        }
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAlternateIdsIsMutable();
                alternateIds_.add(s);
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard revision.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard revision.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard revision.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard revision.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard revision.
     * Format:
     * projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.QaScorecard snapshot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecard,
            com.google.cloud.contactcenterinsights.v1.QaScorecard.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardOrBuilder>
        snapshotBuilder_;
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     *
     * @return Whether the snapshot field is set.
     */
    public boolean hasSnapshot() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     *
     * @return The snapshot.
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecard getSnapshot() {
      if (snapshotBuilder_ == null) {
        return snapshot_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaScorecard.getDefaultInstance()
            : snapshot_;
      } else {
        return snapshotBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public Builder setSnapshot(com.google.cloud.contactcenterinsights.v1.QaScorecard value) {
      if (snapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshot_ = value;
      } else {
        snapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public Builder setSnapshot(
        com.google.cloud.contactcenterinsights.v1.QaScorecard.Builder builderForValue) {
      if (snapshotBuilder_ == null) {
        snapshot_ = builderForValue.build();
      } else {
        snapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public Builder mergeSnapshot(com.google.cloud.contactcenterinsights.v1.QaScorecard value) {
      if (snapshotBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && snapshot_ != null
            && snapshot_
                != com.google.cloud.contactcenterinsights.v1.QaScorecard.getDefaultInstance()) {
          getSnapshotBuilder().mergeFrom(value);
        } else {
          snapshot_ = value;
        }
      } else {
        snapshotBuilder_.mergeFrom(value);
      }
      if (snapshot_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public Builder clearSnapshot() {
      bitField0_ = (bitField0_ & ~0x00000002);
      snapshot_ = null;
      if (snapshotBuilder_ != null) {
        snapshotBuilder_.dispose();
        snapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecard.Builder getSnapshotBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSnapshotFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardOrBuilder getSnapshotOrBuilder() {
      if (snapshotBuilder_ != null) {
        return snapshotBuilder_.getMessageOrBuilder();
      } else {
        return snapshot_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaScorecard.getDefaultInstance()
            : snapshot_;
      }
    }
    /**
     *
     *
     * <pre>
     * The snapshot of the scorecard at the time of this revision's creation.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaScorecard snapshot = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecard,
            com.google.cloud.contactcenterinsights.v1.QaScorecard.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardOrBuilder>
        getSnapshotFieldBuilder() {
      if (snapshotBuilder_ == null) {
        snapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaScorecard,
                com.google.cloud.contactcenterinsights.v1.QaScorecard.Builder,
                com.google.cloud.contactcenterinsights.v1.QaScorecardOrBuilder>(
                getSnapshot(), getParentForChildren(), isClean());
        snapshot_ = null;
      }
      return snapshotBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList alternateIds_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAlternateIdsIsMutable() {
      if (!alternateIds_.isModifiable()) {
        alternateIds_ = new com.google.protobuf.LazyStringArrayList(alternateIds_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the alternateIds.
     */
    public com.google.protobuf.ProtocolStringList getAlternateIdsList() {
      alternateIds_.makeImmutable();
      return alternateIds_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of alternateIds.
     */
    public int getAlternateIdsCount() {
      return alternateIds_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The alternateIds at the given index.
     */
    public java.lang.String getAlternateIds(int index) {
      return alternateIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the alternateIds at the given index.
     */
    public com.google.protobuf.ByteString getAlternateIdsBytes(int index) {
      return alternateIds_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index to set the value at.
     * @param value The alternateIds to set.
     * @return This builder for chaining.
     */
    public Builder setAlternateIds(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAlternateIdsIsMutable();
      alternateIds_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The alternateIds to add.
     * @return This builder for chaining.
     */
    public Builder addAlternateIds(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAlternateIdsIsMutable();
      alternateIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param values The alternateIds to add.
     * @return This builder for chaining.
     */
    public Builder addAllAlternateIds(java.lang.Iterable<java.lang.String> values) {
      ensureAlternateIdsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, alternateIds_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlternateIds() {
      alternateIds_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Alternative IDs for this revision of the scorecard, e.g.,
     * `latest`.
     * </pre>
     *
     * <code>repeated string alternate_ids = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes of the alternateIds to add.
     * @return This builder for chaining.
     */
    public Builder addAlternateIdsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAlternateIdsIsMutable();
      alternateIds_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the scorecard revision, indicating whether it's ready
     * to be used in analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the scorecard revision, indicating whether it's ready
     * to be used in analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the scorecard revision, indicating whether it's ready
     * to be used in analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State getState() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State result =
          com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.forNumber(state_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the scorecard revision, indicating whether it's ready
     * to be used in analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.contactcenterinsights.v1.QaScorecardRevision.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the scorecard revision, indicating whether it's ready
     * to be used in analysis.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardRevision.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaScorecardRevision)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaScorecardRevision)
  private static final com.google.cloud.contactcenterinsights.v1.QaScorecardRevision
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaScorecardRevision();
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardRevision getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QaScorecardRevision> PARSER =
      new com.google.protobuf.AbstractParser<QaScorecardRevision>() {
        @java.lang.Override
        public QaScorecardRevision parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QaScorecardRevision> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QaScorecardRevision> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardRevision getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
