/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The response for querying metrics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsResponse}
 */
public final class QueryMetricsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse)
    QueryMetricsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryMetricsResponse.newBuilder() to construct.
  private QueryMetricsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryMetricsResponse() {
    location_ = "";
    slices_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryMetricsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.class,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Builder.class);
  }

  public interface SliceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> getDimensionsList();
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    com.google.cloud.contactcenterinsights.v1.Dimension getDimensions(int index);
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    int getDimensionsCount();
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    java.util.List<? extends com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
        getDimensionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder getDimensionsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     *
     * @return Whether the total field is set.
     */
    boolean hasTotal();
    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     *
     * @return The total.
     */
    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint getTotal();
    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder
        getTotalOrBuilder();

    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     *
     * @return Whether the timeSeries field is set.
     */
    boolean hasTimeSeries();
    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     *
     * @return The timeSeries.
     */
    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries getTimeSeries();
    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeriesOrBuilder
        getTimeSeriesOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   *
   * For example, if the request specifies a single ISSUE dimension and it has a
   * cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in
   * total), the response will have 2 slices:
   *
   * * Slice 1 -&gt; dimensions=[Issue 1]
   * * Slice 2 -&gt; dimensions=[Issue 2]
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice}
   */
  public static final class Slice extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)
      SliceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Slice.newBuilder() to construct.
    private Slice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Slice() {
      dimensions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Slice();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.class,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder.class);
    }

    public interface DataPointOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       *
       * @return Whether the conversationMeasure field is set.
       */
      boolean hasConversationMeasure();
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       *
       * @return The conversationMeasure.
       */
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .ConversationMeasure
          getConversationMeasure();
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .ConversationMeasureOrBuilder
          getConversationMeasureOrBuilder();

      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       *
       * @return Whether the interval field is set.
       */
      boolean hasInterval();
      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       *
       * @return The interval.
       */
      com.google.type.Interval getInterval();
      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       */
      com.google.type.IntervalOrBuilder getIntervalOrBuilder();

      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.MeasureCase
          getMeasureCase();
    }
    /**
     *
     *
     * <pre>
     * A data point contains the metric values mapped to an interval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint}
     */
    public static final class DataPoint extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
        DataPointOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DataPoint.newBuilder() to construct.
      private DataPoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DataPoint() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DataPoint();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .class,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .Builder.class);
      }

      public interface ConversationMeasureOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * The conversation count.
         * </pre>
         *
         * <code>optional int32 conversation_count = 1;</code>
         *
         * @return Whether the conversationCount field is set.
         */
        boolean hasConversationCount();
        /**
         *
         *
         * <pre>
         * The conversation count.
         * </pre>
         *
         * <code>optional int32 conversation_count = 1;</code>
         *
         * @return The conversationCount.
         */
        int getConversationCount();

        /**
         *
         *
         * <pre>
         * The average silence percentage.
         * </pre>
         *
         * <code>optional float average_silence_percentage = 2;</code>
         *
         * @return Whether the averageSilencePercentage field is set.
         */
        boolean hasAverageSilencePercentage();
        /**
         *
         *
         * <pre>
         * The average silence percentage.
         * </pre>
         *
         * <code>optional float average_silence_percentage = 2;</code>
         *
         * @return The averageSilencePercentage.
         */
        float getAverageSilencePercentage();

        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         *
         * @return Whether the averageDuration field is set.
         */
        boolean hasAverageDuration();
        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         *
         * @return The averageDuration.
         */
        com.google.protobuf.Duration getAverageDuration();
        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         */
        com.google.protobuf.DurationOrBuilder getAverageDurationOrBuilder();

        /**
         *
         *
         * <pre>
         * The average turn count.
         * </pre>
         *
         * <code>optional float average_turn_count = 4;</code>
         *
         * @return Whether the averageTurnCount field is set.
         */
        boolean hasAverageTurnCount();
        /**
         *
         *
         * <pre>
         * The average turn count.
         * </pre>
         *
         * <code>optional float average_turn_count = 4;</code>
         *
         * @return The averageTurnCount.
         */
        float getAverageTurnCount();

        /**
         *
         *
         * <pre>
         * The average agent's sentiment score.
         * </pre>
         *
         * <code>optional float average_agent_sentiment_score = 5;</code>
         *
         * @return Whether the averageAgentSentimentScore field is set.
         */
        boolean hasAverageAgentSentimentScore();
        /**
         *
         *
         * <pre>
         * The average agent's sentiment score.
         * </pre>
         *
         * <code>optional float average_agent_sentiment_score = 5;</code>
         *
         * @return The averageAgentSentimentScore.
         */
        float getAverageAgentSentimentScore();

        /**
         *
         *
         * <pre>
         * The average client's sentiment score.
         * </pre>
         *
         * <code>optional float average_client_sentiment_score = 6;</code>
         *
         * @return Whether the averageClientSentimentScore field is set.
         */
        boolean hasAverageClientSentimentScore();
        /**
         *
         *
         * <pre>
         * The average client's sentiment score.
         * </pre>
         *
         * <code>optional float average_client_sentiment_score = 6;</code>
         *
         * @return The averageClientSentimentScore.
         */
        float getAverageClientSentimentScore();

        /**
         *
         *
         * <pre>
         * The average customer satisfaction rating.
         * </pre>
         *
         * <code>optional double average_customer_satisfaction_rating = 8;</code>
         *
         * @return Whether the averageCustomerSatisfactionRating field is set.
         */
        boolean hasAverageCustomerSatisfactionRating();
        /**
         *
         *
         * <pre>
         * The average customer satisfaction rating.
         * </pre>
         *
         * <code>optional double average_customer_satisfaction_rating = 8;</code>
         *
         * @return The averageCustomerSatisfactionRating.
         */
        double getAverageCustomerSatisfactionRating();

        /**
         *
         *
         * <pre>
         * Average QA normalized score.
         * Will exclude 0's in average calculation.
         * </pre>
         *
         * <code>optional double average_qa_normalized_score = 7;</code>
         *
         * @return Whether the averageQaNormalizedScore field is set.
         */
        boolean hasAverageQaNormalizedScore();
        /**
         *
         *
         * <pre>
         * Average QA normalized score.
         * Will exclude 0's in average calculation.
         * </pre>
         *
         * <code>optional double average_qa_normalized_score = 7;</code>
         *
         * @return The averageQaNormalizedScore.
         */
        double getAverageQaNormalizedScore();

        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore>
            getQaTagScoresList();
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.QaTagScore
            getQaTagScores(int index);
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        int getQaTagScoresCount();
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        java.util.List<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScoreOrBuilder>
            getQaTagScoresOrBuilderList();
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.QaTagScoreOrBuilder
            getQaTagScoresOrBuilder(int index);

        /**
         *
         *
         * <pre>
         * Average QA normalized score averaged for questions averaged across
         * all revisions of the parent scorecard.
         * Will be only populated if the request specifies a dimension of
         * QA_QUESTION_ID.
         * </pre>
         *
         * <code>optional double average_qa_question_normalized_score = 10;</code>
         *
         * @return Whether the averageQaQuestionNormalizedScore field is set.
         */
        boolean hasAverageQaQuestionNormalizedScore();
        /**
         *
         *
         * <pre>
         * Average QA normalized score averaged for questions averaged across
         * all revisions of the parent scorecard.
         * Will be only populated if the request specifies a dimension of
         * QA_QUESTION_ID.
         * </pre>
         *
         * <code>optional double average_qa_question_normalized_score = 10;</code>
         *
         * @return The averageQaQuestionNormalizedScore.
         */
        double getAverageQaQuestionNormalizedScore();
      }
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure}
       */
      public static final class ConversationMeasure extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure)
          ConversationMeasureOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use ConversationMeasure.newBuilder() to construct.
        private ConversationMeasure(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private ConversationMeasure() {
          qaTagScores_ = java.util.Collections.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new ConversationMeasure();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.class,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.Builder.class);
        }

        public interface QaTagScoreOrBuilder
            extends
            // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore)
            com.google.protobuf.MessageOrBuilder {

          /**
           *
           *
           * <pre>
           * Tag name.
           * </pre>
           *
           * <code>string tag = 1;</code>
           *
           * @return The tag.
           */
          java.lang.String getTag();
          /**
           *
           *
           * <pre>
           * Tag name.
           * </pre>
           *
           * <code>string tag = 1;</code>
           *
           * @return The bytes for tag.
           */
          com.google.protobuf.ByteString getTagBytes();

          /**
           *
           *
           * <pre>
           * Average tag normalized score per tag.
           * </pre>
           *
           * <code>double average_tag_normalized_score = 2;</code>
           *
           * @return The averageTagNormalizedScore.
           */
          double getAverageTagNormalizedScore();
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score for the tag.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore}
         */
        public static final class QaTagScore extends com.google.protobuf.GeneratedMessageV3
            implements
            // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore)
            QaTagScoreOrBuilder {
          private static final long serialVersionUID = 0L;
          // Use QaTagScore.newBuilder() to construct.
          private QaTagScore(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
            super(builder);
          }

          private QaTagScore() {
            tag_ = "";
          }

          @java.lang.Override
          @SuppressWarnings({"unused"})
          protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
            return new QaTagScore();
          }

          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore.class,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore.Builder.class);
          }

          public static final int TAG_FIELD_NUMBER = 1;

          @SuppressWarnings("serial")
          private volatile java.lang.Object tag_ = "";
          /**
           *
           *
           * <pre>
           * Tag name.
           * </pre>
           *
           * <code>string tag = 1;</code>
           *
           * @return The tag.
           */
          @java.lang.Override
          public java.lang.String getTag() {
            java.lang.Object ref = tag_;
            if (ref instanceof java.lang.String) {
              return (java.lang.String) ref;
            } else {
              com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              tag_ = s;
              return s;
            }
          }
          /**
           *
           *
           * <pre>
           * Tag name.
           * </pre>
           *
           * <code>string tag = 1;</code>
           *
           * @return The bytes for tag.
           */
          @java.lang.Override
          public com.google.protobuf.ByteString getTagBytes() {
            java.lang.Object ref = tag_;
            if (ref instanceof java.lang.String) {
              com.google.protobuf.ByteString b =
                  com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
              tag_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }

          public static final int AVERAGE_TAG_NORMALIZED_SCORE_FIELD_NUMBER = 2;
          private double averageTagNormalizedScore_ = 0D;
          /**
           *
           *
           * <pre>
           * Average tag normalized score per tag.
           * </pre>
           *
           * <code>double average_tag_normalized_score = 2;</code>
           *
           * @return The averageTagNormalizedScore.
           */
          @java.lang.Override
          public double getAverageTagNormalizedScore() {
            return averageTagNormalizedScore_;
          }

          private byte memoizedIsInitialized = -1;

          @java.lang.Override
          public final boolean isInitialized() {
            byte isInitialized = memoizedIsInitialized;
            if (isInitialized == 1) return true;
            if (isInitialized == 0) return false;

            memoizedIsInitialized = 1;
            return true;
          }

          @java.lang.Override
          public void writeTo(com.google.protobuf.CodedOutputStream output)
              throws java.io.IOException {
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
              com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tag_);
            }
            if (java.lang.Double.doubleToRawLongBits(averageTagNormalizedScore_) != 0) {
              output.writeDouble(2, averageTagNormalizedScore_);
            }
            getUnknownFields().writeTo(output);
          }

          @java.lang.Override
          public int getSerializedSize() {
            int size = memoizedSize;
            if (size != -1) return size;

            size = 0;
            if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
              size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tag_);
            }
            if (java.lang.Double.doubleToRawLongBits(averageTagNormalizedScore_) != 0) {
              size +=
                  com.google.protobuf.CodedOutputStream.computeDoubleSize(
                      2, averageTagNormalizedScore_);
            }
            size += getUnknownFields().getSerializedSize();
            memoizedSize = size;
            return size;
          }

          @java.lang.Override
          public boolean equals(final java.lang.Object obj) {
            if (obj == this) {
              return true;
            }
            if (!(obj
                instanceof
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore)) {
              return super.equals(obj);
            }
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore
                other =
                    (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                            .ConversationMeasure.QaTagScore)
                        obj;

            if (!getTag().equals(other.getTag())) return false;
            if (java.lang.Double.doubleToLongBits(getAverageTagNormalizedScore())
                != java.lang.Double.doubleToLongBits(other.getAverageTagNormalizedScore()))
              return false;
            if (!getUnknownFields().equals(other.getUnknownFields())) return false;
            return true;
          }

          @java.lang.Override
          public int hashCode() {
            if (memoizedHashCode != 0) {
              return memoizedHashCode;
            }
            int hash = 41;
            hash = (19 * hash) + getDescriptor().hashCode();
            hash = (37 * hash) + TAG_FIELD_NUMBER;
            hash = (53 * hash) + getTag().hashCode();
            hash = (37 * hash) + AVERAGE_TAG_NORMALIZED_SCORE_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getAverageTagNormalizedScore()));
            hash = (29 * hash) + getUnknownFields().hashCode();
            memoizedHashCode = hash;
            return hash;
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(java.nio.ByteBuffer data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(
                  java.nio.ByteBuffer data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(com.google.protobuf.ByteString data)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(
                  com.google.protobuf.ByteString data,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseDelimitedFrom(
                  java.io.InputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
                PARSER, input, extensionRegistry);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              parseFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws java.io.IOException {
            return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
                PARSER, input, extensionRegistry);
          }

          @java.lang.Override
          public Builder newBuilderForType() {
            return newBuilder();
          }

          public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
          }

          public static Builder newBuilder(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
          }

          @java.lang.Override
          public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
          }

          @java.lang.Override
          protected Builder newBuilderForType(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for the tag.
           * </pre>
           *
           * Protobuf type {@code
           * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore}
           */
          public static final class Builder
              extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
              implements
              // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore)
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScoreOrBuilder {
            public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
              return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                  .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore_descriptor;
            }

            @java.lang.Override
            protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
                internalGetFieldAccessorTable() {
              return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                  .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore_fieldAccessorTable
                  .ensureFieldAccessorsInitialized(
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScore.class,
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScore.Builder.class);
            }

            // Construct using
            // com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore.newBuilder()
            private Builder() {}

            private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
              super(parent);
            }

            @java.lang.Override
            public Builder clear() {
              super.clear();
              bitField0_ = 0;
              tag_ = "";
              averageTagNormalizedScore_ = 0D;
              return this;
            }

            @java.lang.Override
            public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
              return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                  .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_QaTagScore_descriptor;
            }

            @java.lang.Override
            public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore
                getDefaultInstanceForType() {
              return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore.getDefaultInstance();
            }

            @java.lang.Override
            public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore
                build() {
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  result = buildPartial();
              if (!result.isInitialized()) {
                throw newUninitializedMessageException(result);
              }
              return result;
            }

            @java.lang.Override
            public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore
                buildPartial() {
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  result =
                      new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                          .DataPoint.ConversationMeasure.QaTagScore(this);
              if (bitField0_ != 0) {
                buildPartial0(result);
              }
              onBuilt();
              return result;
            }

            private void buildPartial0(
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore
                    result) {
              int from_bitField0_ = bitField0_;
              if (((from_bitField0_ & 0x00000001) != 0)) {
                result.tag_ = tag_;
              }
              if (((from_bitField0_ & 0x00000002) != 0)) {
                result.averageTagNormalizedScore_ = averageTagNormalizedScore_;
              }
            }

            @java.lang.Override
            public Builder clone() {
              return super.clone();
            }

            @java.lang.Override
            public Builder setField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.setField(field, value);
            }

            @java.lang.Override
            public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
              return super.clearField(field);
            }

            @java.lang.Override
            public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
              return super.clearOneof(oneof);
            }

            @java.lang.Override
            public Builder setRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field,
                int index,
                java.lang.Object value) {
              return super.setRepeatedField(field, index, value);
            }

            @java.lang.Override
            public Builder addRepeatedField(
                com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
              return super.addRepeatedField(field, value);
            }

            @java.lang.Override
            public Builder mergeFrom(com.google.protobuf.Message other) {
              if (other
                  instanceof
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore) {
                return mergeFrom(
                    (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                            .ConversationMeasure.QaTagScore)
                        other);
              } else {
                super.mergeFrom(other);
                return this;
              }
            }

            public Builder mergeFrom(
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore
                    other) {
              if (other
                  == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.getDefaultInstance()) return this;
              if (!other.getTag().isEmpty()) {
                tag_ = other.tag_;
                bitField0_ |= 0x00000001;
                onChanged();
              }
              if (other.getAverageTagNormalizedScore() != 0D) {
                setAverageTagNormalizedScore(other.getAverageTagNormalizedScore());
              }
              this.mergeUnknownFields(other.getUnknownFields());
              onChanged();
              return this;
            }

            @java.lang.Override
            public final boolean isInitialized() {
              return true;
            }

            @java.lang.Override
            public Builder mergeFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
              if (extensionRegistry == null) {
                throw new java.lang.NullPointerException();
              }
              try {
                boolean done = false;
                while (!done) {
                  int tag = input.readTag();
                  switch (tag) {
                    case 0:
                      done = true;
                      break;
                    case 10:
                      {
                        tag_ = input.readStringRequireUtf8();
                        bitField0_ |= 0x00000001;
                        break;
                      } // case 10
                    case 17:
                      {
                        averageTagNormalizedScore_ = input.readDouble();
                        bitField0_ |= 0x00000002;
                        break;
                      } // case 17
                    default:
                      {
                        if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                          done = true; // was an endgroup tag
                        }
                        break;
                      } // default:
                  } // switch (tag)
                } // while (!done)
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
              } finally {
                onChanged();
              } // finally
              return this;
            }

            private int bitField0_;

            private java.lang.Object tag_ = "";
            /**
             *
             *
             * <pre>
             * Tag name.
             * </pre>
             *
             * <code>string tag = 1;</code>
             *
             * @return The tag.
             */
            public java.lang.String getTag() {
              java.lang.Object ref = tag_;
              if (!(ref instanceof java.lang.String)) {
                com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
                java.lang.String s = bs.toStringUtf8();
                tag_ = s;
                return s;
              } else {
                return (java.lang.String) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Tag name.
             * </pre>
             *
             * <code>string tag = 1;</code>
             *
             * @return The bytes for tag.
             */
            public com.google.protobuf.ByteString getTagBytes() {
              java.lang.Object ref = tag_;
              if (ref instanceof String) {
                com.google.protobuf.ByteString b =
                    com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
                tag_ = b;
                return b;
              } else {
                return (com.google.protobuf.ByteString) ref;
              }
            }
            /**
             *
             *
             * <pre>
             * Tag name.
             * </pre>
             *
             * <code>string tag = 1;</code>
             *
             * @param value The tag to set.
             * @return This builder for chaining.
             */
            public Builder setTag(java.lang.String value) {
              if (value == null) {
                throw new NullPointerException();
              }
              tag_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Tag name.
             * </pre>
             *
             * <code>string tag = 1;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearTag() {
              tag_ = getDefaultInstance().getTag();
              bitField0_ = (bitField0_ & ~0x00000001);
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Tag name.
             * </pre>
             *
             * <code>string tag = 1;</code>
             *
             * @param value The bytes for tag to set.
             * @return This builder for chaining.
             */
            public Builder setTagBytes(com.google.protobuf.ByteString value) {
              if (value == null) {
                throw new NullPointerException();
              }
              checkByteStringIsUtf8(value);
              tag_ = value;
              bitField0_ |= 0x00000001;
              onChanged();
              return this;
            }

            private double averageTagNormalizedScore_;
            /**
             *
             *
             * <pre>
             * Average tag normalized score per tag.
             * </pre>
             *
             * <code>double average_tag_normalized_score = 2;</code>
             *
             * @return The averageTagNormalizedScore.
             */
            @java.lang.Override
            public double getAverageTagNormalizedScore() {
              return averageTagNormalizedScore_;
            }
            /**
             *
             *
             * <pre>
             * Average tag normalized score per tag.
             * </pre>
             *
             * <code>double average_tag_normalized_score = 2;</code>
             *
             * @param value The averageTagNormalizedScore to set.
             * @return This builder for chaining.
             */
            public Builder setAverageTagNormalizedScore(double value) {

              averageTagNormalizedScore_ = value;
              bitField0_ |= 0x00000002;
              onChanged();
              return this;
            }
            /**
             *
             *
             * <pre>
             * Average tag normalized score per tag.
             * </pre>
             *
             * <code>double average_tag_normalized_score = 2;</code>
             *
             * @return This builder for chaining.
             */
            public Builder clearAverageTagNormalizedScore() {
              bitField0_ = (bitField0_ & ~0x00000002);
              averageTagNormalizedScore_ = 0D;
              onChanged();
              return this;
            }

            @java.lang.Override
            public final Builder setUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.setUnknownFields(unknownFields);
            }

            @java.lang.Override
            public final Builder mergeUnknownFields(
                final com.google.protobuf.UnknownFieldSet unknownFields) {
              return super.mergeUnknownFields(unknownFields);
            }

            // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore)
          }

          // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore)
          private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              DEFAULT_INSTANCE;

          static {
            DEFAULT_INSTANCE =
                new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore();
          }

          public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPoint.ConversationMeasure.QaTagScore
              getDefaultInstance() {
            return DEFAULT_INSTANCE;
          }

          private static final com.google.protobuf.Parser<QaTagScore> PARSER =
              new com.google.protobuf.AbstractParser<QaTagScore>() {
                @java.lang.Override
                public QaTagScore parsePartialFrom(
                    com.google.protobuf.CodedInputStream input,
                    com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                    throws com.google.protobuf.InvalidProtocolBufferException {
                  Builder builder = newBuilder();
                  try {
                    builder.mergeFrom(input, extensionRegistry);
                  } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                  } catch (com.google.protobuf.UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException()
                        .setUnfinishedMessage(builder.buildPartial());
                  } catch (java.io.IOException e) {
                    throw new com.google.protobuf.InvalidProtocolBufferException(e)
                        .setUnfinishedMessage(builder.buildPartial());
                  }
                  return builder.buildPartial();
                }
              };

          public static com.google.protobuf.Parser<QaTagScore> parser() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.protobuf.Parser<QaTagScore> getParserForType() {
            return PARSER;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore
              getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
          }
        }

        private int bitField0_;
        public static final int CONVERSATION_COUNT_FIELD_NUMBER = 1;
        private int conversationCount_ = 0;
        /**
         *
         *
         * <pre>
         * The conversation count.
         * </pre>
         *
         * <code>optional int32 conversation_count = 1;</code>
         *
         * @return Whether the conversationCount field is set.
         */
        @java.lang.Override
        public boolean hasConversationCount() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * The conversation count.
         * </pre>
         *
         * <code>optional int32 conversation_count = 1;</code>
         *
         * @return The conversationCount.
         */
        @java.lang.Override
        public int getConversationCount() {
          return conversationCount_;
        }

        public static final int AVERAGE_SILENCE_PERCENTAGE_FIELD_NUMBER = 2;
        private float averageSilencePercentage_ = 0F;
        /**
         *
         *
         * <pre>
         * The average silence percentage.
         * </pre>
         *
         * <code>optional float average_silence_percentage = 2;</code>
         *
         * @return Whether the averageSilencePercentage field is set.
         */
        @java.lang.Override
        public boolean hasAverageSilencePercentage() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average silence percentage.
         * </pre>
         *
         * <code>optional float average_silence_percentage = 2;</code>
         *
         * @return The averageSilencePercentage.
         */
        @java.lang.Override
        public float getAverageSilencePercentage() {
          return averageSilencePercentage_;
        }

        public static final int AVERAGE_DURATION_FIELD_NUMBER = 3;
        private com.google.protobuf.Duration averageDuration_;
        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         *
         * @return Whether the averageDuration field is set.
         */
        @java.lang.Override
        public boolean hasAverageDuration() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         *
         * @return The averageDuration.
         */
        @java.lang.Override
        public com.google.protobuf.Duration getAverageDuration() {
          return averageDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : averageDuration_;
        }
        /**
         *
         *
         * <pre>
         * The average duration.
         * </pre>
         *
         * <code>optional .google.protobuf.Duration average_duration = 3;</code>
         */
        @java.lang.Override
        public com.google.protobuf.DurationOrBuilder getAverageDurationOrBuilder() {
          return averageDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : averageDuration_;
        }

        public static final int AVERAGE_TURN_COUNT_FIELD_NUMBER = 4;
        private float averageTurnCount_ = 0F;
        /**
         *
         *
         * <pre>
         * The average turn count.
         * </pre>
         *
         * <code>optional float average_turn_count = 4;</code>
         *
         * @return Whether the averageTurnCount field is set.
         */
        @java.lang.Override
        public boolean hasAverageTurnCount() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average turn count.
         * </pre>
         *
         * <code>optional float average_turn_count = 4;</code>
         *
         * @return The averageTurnCount.
         */
        @java.lang.Override
        public float getAverageTurnCount() {
          return averageTurnCount_;
        }

        public static final int AVERAGE_AGENT_SENTIMENT_SCORE_FIELD_NUMBER = 5;
        private float averageAgentSentimentScore_ = 0F;
        /**
         *
         *
         * <pre>
         * The average agent's sentiment score.
         * </pre>
         *
         * <code>optional float average_agent_sentiment_score = 5;</code>
         *
         * @return Whether the averageAgentSentimentScore field is set.
         */
        @java.lang.Override
        public boolean hasAverageAgentSentimentScore() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average agent's sentiment score.
         * </pre>
         *
         * <code>optional float average_agent_sentiment_score = 5;</code>
         *
         * @return The averageAgentSentimentScore.
         */
        @java.lang.Override
        public float getAverageAgentSentimentScore() {
          return averageAgentSentimentScore_;
        }

        public static final int AVERAGE_CLIENT_SENTIMENT_SCORE_FIELD_NUMBER = 6;
        private float averageClientSentimentScore_ = 0F;
        /**
         *
         *
         * <pre>
         * The average client's sentiment score.
         * </pre>
         *
         * <code>optional float average_client_sentiment_score = 6;</code>
         *
         * @return Whether the averageClientSentimentScore field is set.
         */
        @java.lang.Override
        public boolean hasAverageClientSentimentScore() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average client's sentiment score.
         * </pre>
         *
         * <code>optional float average_client_sentiment_score = 6;</code>
         *
         * @return The averageClientSentimentScore.
         */
        @java.lang.Override
        public float getAverageClientSentimentScore() {
          return averageClientSentimentScore_;
        }

        public static final int AVERAGE_CUSTOMER_SATISFACTION_RATING_FIELD_NUMBER = 8;
        private double averageCustomerSatisfactionRating_ = 0D;
        /**
         *
         *
         * <pre>
         * The average customer satisfaction rating.
         * </pre>
         *
         * <code>optional double average_customer_satisfaction_rating = 8;</code>
         *
         * @return Whether the averageCustomerSatisfactionRating field is set.
         */
        @java.lang.Override
        public boolean hasAverageCustomerSatisfactionRating() {
          return ((bitField0_ & 0x00000040) != 0);
        }
        /**
         *
         *
         * <pre>
         * The average customer satisfaction rating.
         * </pre>
         *
         * <code>optional double average_customer_satisfaction_rating = 8;</code>
         *
         * @return The averageCustomerSatisfactionRating.
         */
        @java.lang.Override
        public double getAverageCustomerSatisfactionRating() {
          return averageCustomerSatisfactionRating_;
        }

        public static final int AVERAGE_QA_NORMALIZED_SCORE_FIELD_NUMBER = 7;
        private double averageQaNormalizedScore_ = 0D;
        /**
         *
         *
         * <pre>
         * Average QA normalized score.
         * Will exclude 0's in average calculation.
         * </pre>
         *
         * <code>optional double average_qa_normalized_score = 7;</code>
         *
         * @return Whether the averageQaNormalizedScore field is set.
         */
        @java.lang.Override
        public boolean hasAverageQaNormalizedScore() {
          return ((bitField0_ & 0x00000080) != 0);
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score.
         * Will exclude 0's in average calculation.
         * </pre>
         *
         * <code>optional double average_qa_normalized_score = 7;</code>
         *
         * @return The averageQaNormalizedScore.
         */
        @java.lang.Override
        public double getAverageQaNormalizedScore() {
          return averageQaNormalizedScore_;
        }

        public static final int QA_TAG_SCORES_FIELD_NUMBER = 9;

        @SuppressWarnings("serial")
        private java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore>
            qaTagScores_;
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.QaTagScore>
            getQaTagScoresList() {
          return qaTagScores_;
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        @java.lang.Override
        public java.util.List<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScoreOrBuilder>
            getQaTagScoresOrBuilderList() {
          return qaTagScores_;
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        @java.lang.Override
        public int getQaTagScoresCount() {
          return qaTagScores_.size();
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.QaTagScore
            getQaTagScores(int index) {
          return qaTagScores_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score for all the tags.
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.QaTagScoreOrBuilder
            getQaTagScoresOrBuilder(int index) {
          return qaTagScores_.get(index);
        }

        public static final int AVERAGE_QA_QUESTION_NORMALIZED_SCORE_FIELD_NUMBER = 10;
        private double averageQaQuestionNormalizedScore_ = 0D;
        /**
         *
         *
         * <pre>
         * Average QA normalized score averaged for questions averaged across
         * all revisions of the parent scorecard.
         * Will be only populated if the request specifies a dimension of
         * QA_QUESTION_ID.
         * </pre>
         *
         * <code>optional double average_qa_question_normalized_score = 10;</code>
         *
         * @return Whether the averageQaQuestionNormalizedScore field is set.
         */
        @java.lang.Override
        public boolean hasAverageQaQuestionNormalizedScore() {
          return ((bitField0_ & 0x00000100) != 0);
        }
        /**
         *
         *
         * <pre>
         * Average QA normalized score averaged for questions averaged across
         * all revisions of the parent scorecard.
         * Will be only populated if the request specifies a dimension of
         * QA_QUESTION_ID.
         * </pre>
         *
         * <code>optional double average_qa_question_normalized_score = 10;</code>
         *
         * @return The averageQaQuestionNormalizedScore.
         */
        @java.lang.Override
        public double getAverageQaQuestionNormalizedScore() {
          return averageQaQuestionNormalizedScore_;
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          if (((bitField0_ & 0x00000001) != 0)) {
            output.writeInt32(1, conversationCount_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            output.writeFloat(2, averageSilencePercentage_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            output.writeMessage(3, getAverageDuration());
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            output.writeFloat(4, averageTurnCount_);
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            output.writeFloat(5, averageAgentSentimentScore_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            output.writeFloat(6, averageClientSentimentScore_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            output.writeDouble(7, averageQaNormalizedScore_);
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            output.writeDouble(8, averageCustomerSatisfactionRating_);
          }
          for (int i = 0; i < qaTagScores_.size(); i++) {
            output.writeMessage(9, qaTagScores_.get(i));
          }
          if (((bitField0_ & 0x00000100) != 0)) {
            output.writeDouble(10, averageQaQuestionNormalizedScore_);
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, conversationCount_);
          }
          if (((bitField0_ & 0x00000002) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeFloatSize(
                    2, averageSilencePercentage_);
          }
          if (((bitField0_ & 0x00000004) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAverageDuration());
          }
          if (((bitField0_ & 0x00000008) != 0)) {
            size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, averageTurnCount_);
          }
          if (((bitField0_ & 0x00000010) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeFloatSize(
                    5, averageAgentSentimentScore_);
          }
          if (((bitField0_ & 0x00000020) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeFloatSize(
                    6, averageClientSentimentScore_);
          }
          if (((bitField0_ & 0x00000080) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeDoubleSize(
                    7, averageQaNormalizedScore_);
          }
          if (((bitField0_ & 0x00000040) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeDoubleSize(
                    8, averageCustomerSatisfactionRating_);
          }
          for (int i = 0; i < qaTagScores_.size(); i++) {
            size +=
                com.google.protobuf.CodedOutputStream.computeMessageSize(9, qaTagScores_.get(i));
          }
          if (((bitField0_ & 0x00000100) != 0)) {
            size +=
                com.google.protobuf.CodedOutputStream.computeDoubleSize(
                    10, averageQaQuestionNormalizedScore_);
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure)) {
            return super.equals(obj);
          }
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure
              other =
                  (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure)
                      obj;

          if (hasConversationCount() != other.hasConversationCount()) return false;
          if (hasConversationCount()) {
            if (getConversationCount() != other.getConversationCount()) return false;
          }
          if (hasAverageSilencePercentage() != other.hasAverageSilencePercentage()) return false;
          if (hasAverageSilencePercentage()) {
            if (java.lang.Float.floatToIntBits(getAverageSilencePercentage())
                != java.lang.Float.floatToIntBits(other.getAverageSilencePercentage()))
              return false;
          }
          if (hasAverageDuration() != other.hasAverageDuration()) return false;
          if (hasAverageDuration()) {
            if (!getAverageDuration().equals(other.getAverageDuration())) return false;
          }
          if (hasAverageTurnCount() != other.hasAverageTurnCount()) return false;
          if (hasAverageTurnCount()) {
            if (java.lang.Float.floatToIntBits(getAverageTurnCount())
                != java.lang.Float.floatToIntBits(other.getAverageTurnCount())) return false;
          }
          if (hasAverageAgentSentimentScore() != other.hasAverageAgentSentimentScore())
            return false;
          if (hasAverageAgentSentimentScore()) {
            if (java.lang.Float.floatToIntBits(getAverageAgentSentimentScore())
                != java.lang.Float.floatToIntBits(other.getAverageAgentSentimentScore()))
              return false;
          }
          if (hasAverageClientSentimentScore() != other.hasAverageClientSentimentScore())
            return false;
          if (hasAverageClientSentimentScore()) {
            if (java.lang.Float.floatToIntBits(getAverageClientSentimentScore())
                != java.lang.Float.floatToIntBits(other.getAverageClientSentimentScore()))
              return false;
          }
          if (hasAverageCustomerSatisfactionRating()
              != other.hasAverageCustomerSatisfactionRating()) return false;
          if (hasAverageCustomerSatisfactionRating()) {
            if (java.lang.Double.doubleToLongBits(getAverageCustomerSatisfactionRating())
                != java.lang.Double.doubleToLongBits(other.getAverageCustomerSatisfactionRating()))
              return false;
          }
          if (hasAverageQaNormalizedScore() != other.hasAverageQaNormalizedScore()) return false;
          if (hasAverageQaNormalizedScore()) {
            if (java.lang.Double.doubleToLongBits(getAverageQaNormalizedScore())
                != java.lang.Double.doubleToLongBits(other.getAverageQaNormalizedScore()))
              return false;
          }
          if (!getQaTagScoresList().equals(other.getQaTagScoresList())) return false;
          if (hasAverageQaQuestionNormalizedScore() != other.hasAverageQaQuestionNormalizedScore())
            return false;
          if (hasAverageQaQuestionNormalizedScore()) {
            if (java.lang.Double.doubleToLongBits(getAverageQaQuestionNormalizedScore())
                != java.lang.Double.doubleToLongBits(other.getAverageQaQuestionNormalizedScore()))
              return false;
          }
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasConversationCount()) {
            hash = (37 * hash) + CONVERSATION_COUNT_FIELD_NUMBER;
            hash = (53 * hash) + getConversationCount();
          }
          if (hasAverageSilencePercentage()) {
            hash = (37 * hash) + AVERAGE_SILENCE_PERCENTAGE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverageSilencePercentage());
          }
          if (hasAverageDuration()) {
            hash = (37 * hash) + AVERAGE_DURATION_FIELD_NUMBER;
            hash = (53 * hash) + getAverageDuration().hashCode();
          }
          if (hasAverageTurnCount()) {
            hash = (37 * hash) + AVERAGE_TURN_COUNT_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverageTurnCount());
          }
          if (hasAverageAgentSentimentScore()) {
            hash = (37 * hash) + AVERAGE_AGENT_SENTIMENT_SCORE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverageAgentSentimentScore());
          }
          if (hasAverageClientSentimentScore()) {
            hash = (37 * hash) + AVERAGE_CLIENT_SENTIMENT_SCORE_FIELD_NUMBER;
            hash = (53 * hash) + java.lang.Float.floatToIntBits(getAverageClientSentimentScore());
          }
          if (hasAverageCustomerSatisfactionRating()) {
            hash = (37 * hash) + AVERAGE_CUSTOMER_SATISFACTION_RATING_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getAverageCustomerSatisfactionRating()));
          }
          if (hasAverageQaNormalizedScore()) {
            hash = (37 * hash) + AVERAGE_QA_NORMALIZED_SCORE_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getAverageQaNormalizedScore()));
          }
          if (getQaTagScoresCount() > 0) {
            hash = (37 * hash) + QA_TAG_SCORES_FIELD_NUMBER;
            hash = (53 * hash) + getQaTagScoresList().hashCode();
          }
          if (hasAverageQaQuestionNormalizedScore()) {
            hash = (37 * hash) + AVERAGE_QA_QUESTION_NORMALIZED_SCORE_FIELD_NUMBER;
            hash =
                (53 * hash)
                    + com.google.protobuf.Internal.hashLong(
                        java.lang.Double.doubleToLongBits(getAverageQaQuestionNormalizedScore()));
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure)
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasureOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.class,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.Builder.class);
          }

          // Construct using
          // com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }

          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
              getAverageDurationFieldBuilder();
              getQaTagScoresFieldBuilder();
            }
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            conversationCount_ = 0;
            averageSilencePercentage_ = 0F;
            averageDuration_ = null;
            if (averageDurationBuilder_ != null) {
              averageDurationBuilder_.dispose();
              averageDurationBuilder_ = null;
            }
            averageTurnCount_ = 0F;
            averageAgentSentimentScore_ = 0F;
            averageClientSentimentScore_ = 0F;
            averageCustomerSatisfactionRating_ = 0D;
            averageQaNormalizedScore_ = 0D;
            if (qaTagScoresBuilder_ == null) {
              qaTagScores_ = java.util.Collections.emptyList();
            } else {
              qaTagScores_ = null;
              qaTagScoresBuilder_.clear();
            }
            bitField0_ = (bitField0_ & ~0x00000100);
            averageQaQuestionNormalizedScore_ = 0D;
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
                .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_ConversationMeasure_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure
              getDefaultInstanceForType() {
            return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure
              build() {
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure
              buildPartial() {
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure
                result =
                    new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                        .DataPoint.ConversationMeasure(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure
                  result) {
            if (qaTagScoresBuilder_ == null) {
              if (((bitField0_ & 0x00000100) != 0)) {
                qaTagScores_ = java.util.Collections.unmodifiableList(qaTagScores_);
                bitField0_ = (bitField0_ & ~0x00000100);
              }
              result.qaTagScores_ = qaTagScores_;
            } else {
              result.qaTagScores_ = qaTagScoresBuilder_.build();
            }
          }

          private void buildPartial0(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure
                  result) {
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              result.conversationCount_ = conversationCount_;
              to_bitField0_ |= 0x00000001;
            }
            if (((from_bitField0_ & 0x00000002) != 0)) {
              result.averageSilencePercentage_ = averageSilencePercentage_;
              to_bitField0_ |= 0x00000002;
            }
            if (((from_bitField0_ & 0x00000004) != 0)) {
              result.averageDuration_ =
                  averageDurationBuilder_ == null
                      ? averageDuration_
                      : averageDurationBuilder_.build();
              to_bitField0_ |= 0x00000004;
            }
            if (((from_bitField0_ & 0x00000008) != 0)) {
              result.averageTurnCount_ = averageTurnCount_;
              to_bitField0_ |= 0x00000008;
            }
            if (((from_bitField0_ & 0x00000010) != 0)) {
              result.averageAgentSentimentScore_ = averageAgentSentimentScore_;
              to_bitField0_ |= 0x00000010;
            }
            if (((from_bitField0_ & 0x00000020) != 0)) {
              result.averageClientSentimentScore_ = averageClientSentimentScore_;
              to_bitField0_ |= 0x00000020;
            }
            if (((from_bitField0_ & 0x00000040) != 0)) {
              result.averageCustomerSatisfactionRating_ = averageCustomerSatisfactionRating_;
              to_bitField0_ |= 0x00000040;
            }
            if (((from_bitField0_ & 0x00000080) != 0)) {
              result.averageQaNormalizedScore_ = averageQaNormalizedScore_;
              to_bitField0_ |= 0x00000080;
            }
            if (((from_bitField0_ & 0x00000200) != 0)) {
              result.averageQaQuestionNormalizedScore_ = averageQaQuestionNormalizedScore_;
              to_bitField0_ |= 0x00000100;
            }
            result.bitField0_ |= to_bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure) {
              return mergeFrom(
                  (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure
                  other) {
            if (other
                == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.getDefaultInstance()) return this;
            if (other.hasConversationCount()) {
              setConversationCount(other.getConversationCount());
            }
            if (other.hasAverageSilencePercentage()) {
              setAverageSilencePercentage(other.getAverageSilencePercentage());
            }
            if (other.hasAverageDuration()) {
              mergeAverageDuration(other.getAverageDuration());
            }
            if (other.hasAverageTurnCount()) {
              setAverageTurnCount(other.getAverageTurnCount());
            }
            if (other.hasAverageAgentSentimentScore()) {
              setAverageAgentSentimentScore(other.getAverageAgentSentimentScore());
            }
            if (other.hasAverageClientSentimentScore()) {
              setAverageClientSentimentScore(other.getAverageClientSentimentScore());
            }
            if (other.hasAverageCustomerSatisfactionRating()) {
              setAverageCustomerSatisfactionRating(other.getAverageCustomerSatisfactionRating());
            }
            if (other.hasAverageQaNormalizedScore()) {
              setAverageQaNormalizedScore(other.getAverageQaNormalizedScore());
            }
            if (qaTagScoresBuilder_ == null) {
              if (!other.qaTagScores_.isEmpty()) {
                if (qaTagScores_.isEmpty()) {
                  qaTagScores_ = other.qaTagScores_;
                  bitField0_ = (bitField0_ & ~0x00000100);
                } else {
                  ensureQaTagScoresIsMutable();
                  qaTagScores_.addAll(other.qaTagScores_);
                }
                onChanged();
              }
            } else {
              if (!other.qaTagScores_.isEmpty()) {
                if (qaTagScoresBuilder_.isEmpty()) {
                  qaTagScoresBuilder_.dispose();
                  qaTagScoresBuilder_ = null;
                  qaTagScores_ = other.qaTagScores_;
                  bitField0_ = (bitField0_ & ~0x00000100);
                  qaTagScoresBuilder_ =
                      com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                          ? getQaTagScoresFieldBuilder()
                          : null;
                } else {
                  qaTagScoresBuilder_.addAllMessages(other.qaTagScores_);
                }
              }
            }
            if (other.hasAverageQaQuestionNormalizedScore()) {
              setAverageQaQuestionNormalizedScore(other.getAverageQaQuestionNormalizedScore());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      conversationCount_ = input.readInt32();
                      bitField0_ |= 0x00000001;
                      break;
                    } // case 8
                  case 21:
                    {
                      averageSilencePercentage_ = input.readFloat();
                      bitField0_ |= 0x00000002;
                      break;
                    } // case 21
                  case 26:
                    {
                      input.readMessage(
                          getAverageDurationFieldBuilder().getBuilder(), extensionRegistry);
                      bitField0_ |= 0x00000004;
                      break;
                    } // case 26
                  case 37:
                    {
                      averageTurnCount_ = input.readFloat();
                      bitField0_ |= 0x00000008;
                      break;
                    } // case 37
                  case 45:
                    {
                      averageAgentSentimentScore_ = input.readFloat();
                      bitField0_ |= 0x00000010;
                      break;
                    } // case 45
                  case 53:
                    {
                      averageClientSentimentScore_ = input.readFloat();
                      bitField0_ |= 0x00000020;
                      break;
                    } // case 53
                  case 57:
                    {
                      averageQaNormalizedScore_ = input.readDouble();
                      bitField0_ |= 0x00000080;
                      break;
                    } // case 57
                  case 65:
                    {
                      averageCustomerSatisfactionRating_ = input.readDouble();
                      bitField0_ |= 0x00000040;
                      break;
                    } // case 65
                  case 74:
                    {
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                              .ConversationMeasure.QaTagScore
                          m =
                              input.readMessage(
                                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse
                                      .Slice.DataPoint.ConversationMeasure.QaTagScore.parser(),
                                  extensionRegistry);
                      if (qaTagScoresBuilder_ == null) {
                        ensureQaTagScoresIsMutable();
                        qaTagScores_.add(m);
                      } else {
                        qaTagScoresBuilder_.addMessage(m);
                      }
                      break;
                    } // case 74
                  case 81:
                    {
                      averageQaQuestionNormalizedScore_ = input.readDouble();
                      bitField0_ |= 0x00000200;
                      break;
                    } // case 81
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private int conversationCount_;
          /**
           *
           *
           * <pre>
           * The conversation count.
           * </pre>
           *
           * <code>optional int32 conversation_count = 1;</code>
           *
           * @return Whether the conversationCount field is set.
           */
          @java.lang.Override
          public boolean hasConversationCount() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           *
           *
           * <pre>
           * The conversation count.
           * </pre>
           *
           * <code>optional int32 conversation_count = 1;</code>
           *
           * @return The conversationCount.
           */
          @java.lang.Override
          public int getConversationCount() {
            return conversationCount_;
          }
          /**
           *
           *
           * <pre>
           * The conversation count.
           * </pre>
           *
           * <code>optional int32 conversation_count = 1;</code>
           *
           * @param value The conversationCount to set.
           * @return This builder for chaining.
           */
          public Builder setConversationCount(int value) {

            conversationCount_ = value;
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The conversation count.
           * </pre>
           *
           * <code>optional int32 conversation_count = 1;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearConversationCount() {
            bitField0_ = (bitField0_ & ~0x00000001);
            conversationCount_ = 0;
            onChanged();
            return this;
          }

          private float averageSilencePercentage_;
          /**
           *
           *
           * <pre>
           * The average silence percentage.
           * </pre>
           *
           * <code>optional float average_silence_percentage = 2;</code>
           *
           * @return Whether the averageSilencePercentage field is set.
           */
          @java.lang.Override
          public boolean hasAverageSilencePercentage() {
            return ((bitField0_ & 0x00000002) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average silence percentage.
           * </pre>
           *
           * <code>optional float average_silence_percentage = 2;</code>
           *
           * @return The averageSilencePercentage.
           */
          @java.lang.Override
          public float getAverageSilencePercentage() {
            return averageSilencePercentage_;
          }
          /**
           *
           *
           * <pre>
           * The average silence percentage.
           * </pre>
           *
           * <code>optional float average_silence_percentage = 2;</code>
           *
           * @param value The averageSilencePercentage to set.
           * @return This builder for chaining.
           */
          public Builder setAverageSilencePercentage(float value) {

            averageSilencePercentage_ = value;
            bitField0_ |= 0x00000002;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average silence percentage.
           * </pre>
           *
           * <code>optional float average_silence_percentage = 2;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageSilencePercentage() {
            bitField0_ = (bitField0_ & ~0x00000002);
            averageSilencePercentage_ = 0F;
            onChanged();
            return this;
          }

          private com.google.protobuf.Duration averageDuration_;
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              averageDurationBuilder_;
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           *
           * @return Whether the averageDuration field is set.
           */
          public boolean hasAverageDuration() {
            return ((bitField0_ & 0x00000004) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           *
           * @return The averageDuration.
           */
          public com.google.protobuf.Duration getAverageDuration() {
            if (averageDurationBuilder_ == null) {
              return averageDuration_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : averageDuration_;
            } else {
              return averageDurationBuilder_.getMessage();
            }
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public Builder setAverageDuration(com.google.protobuf.Duration value) {
            if (averageDurationBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              averageDuration_ = value;
            } else {
              averageDurationBuilder_.setMessage(value);
            }
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public Builder setAverageDuration(com.google.protobuf.Duration.Builder builderForValue) {
            if (averageDurationBuilder_ == null) {
              averageDuration_ = builderForValue.build();
            } else {
              averageDurationBuilder_.setMessage(builderForValue.build());
            }
            bitField0_ |= 0x00000004;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public Builder mergeAverageDuration(com.google.protobuf.Duration value) {
            if (averageDurationBuilder_ == null) {
              if (((bitField0_ & 0x00000004) != 0)
                  && averageDuration_ != null
                  && averageDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
                getAverageDurationBuilder().mergeFrom(value);
              } else {
                averageDuration_ = value;
              }
            } else {
              averageDurationBuilder_.mergeFrom(value);
            }
            if (averageDuration_ != null) {
              bitField0_ |= 0x00000004;
              onChanged();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public Builder clearAverageDuration() {
            bitField0_ = (bitField0_ & ~0x00000004);
            averageDuration_ = null;
            if (averageDurationBuilder_ != null) {
              averageDurationBuilder_.dispose();
              averageDurationBuilder_ = null;
            }
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public com.google.protobuf.Duration.Builder getAverageDurationBuilder() {
            bitField0_ |= 0x00000004;
            onChanged();
            return getAverageDurationFieldBuilder().getBuilder();
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          public com.google.protobuf.DurationOrBuilder getAverageDurationOrBuilder() {
            if (averageDurationBuilder_ != null) {
              return averageDurationBuilder_.getMessageOrBuilder();
            } else {
              return averageDuration_ == null
                  ? com.google.protobuf.Duration.getDefaultInstance()
                  : averageDuration_;
            }
          }
          /**
           *
           *
           * <pre>
           * The average duration.
           * </pre>
           *
           * <code>optional .google.protobuf.Duration average_duration = 3;</code>
           */
          private com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>
              getAverageDurationFieldBuilder() {
            if (averageDurationBuilder_ == null) {
              averageDurationBuilder_ =
                  new com.google.protobuf.SingleFieldBuilderV3<
                      com.google.protobuf.Duration,
                      com.google.protobuf.Duration.Builder,
                      com.google.protobuf.DurationOrBuilder>(
                      getAverageDuration(), getParentForChildren(), isClean());
              averageDuration_ = null;
            }
            return averageDurationBuilder_;
          }

          private float averageTurnCount_;
          /**
           *
           *
           * <pre>
           * The average turn count.
           * </pre>
           *
           * <code>optional float average_turn_count = 4;</code>
           *
           * @return Whether the averageTurnCount field is set.
           */
          @java.lang.Override
          public boolean hasAverageTurnCount() {
            return ((bitField0_ & 0x00000008) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average turn count.
           * </pre>
           *
           * <code>optional float average_turn_count = 4;</code>
           *
           * @return The averageTurnCount.
           */
          @java.lang.Override
          public float getAverageTurnCount() {
            return averageTurnCount_;
          }
          /**
           *
           *
           * <pre>
           * The average turn count.
           * </pre>
           *
           * <code>optional float average_turn_count = 4;</code>
           *
           * @param value The averageTurnCount to set.
           * @return This builder for chaining.
           */
          public Builder setAverageTurnCount(float value) {

            averageTurnCount_ = value;
            bitField0_ |= 0x00000008;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average turn count.
           * </pre>
           *
           * <code>optional float average_turn_count = 4;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageTurnCount() {
            bitField0_ = (bitField0_ & ~0x00000008);
            averageTurnCount_ = 0F;
            onChanged();
            return this;
          }

          private float averageAgentSentimentScore_;
          /**
           *
           *
           * <pre>
           * The average agent's sentiment score.
           * </pre>
           *
           * <code>optional float average_agent_sentiment_score = 5;</code>
           *
           * @return Whether the averageAgentSentimentScore field is set.
           */
          @java.lang.Override
          public boolean hasAverageAgentSentimentScore() {
            return ((bitField0_ & 0x00000010) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average agent's sentiment score.
           * </pre>
           *
           * <code>optional float average_agent_sentiment_score = 5;</code>
           *
           * @return The averageAgentSentimentScore.
           */
          @java.lang.Override
          public float getAverageAgentSentimentScore() {
            return averageAgentSentimentScore_;
          }
          /**
           *
           *
           * <pre>
           * The average agent's sentiment score.
           * </pre>
           *
           * <code>optional float average_agent_sentiment_score = 5;</code>
           *
           * @param value The averageAgentSentimentScore to set.
           * @return This builder for chaining.
           */
          public Builder setAverageAgentSentimentScore(float value) {

            averageAgentSentimentScore_ = value;
            bitField0_ |= 0x00000010;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average agent's sentiment score.
           * </pre>
           *
           * <code>optional float average_agent_sentiment_score = 5;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageAgentSentimentScore() {
            bitField0_ = (bitField0_ & ~0x00000010);
            averageAgentSentimentScore_ = 0F;
            onChanged();
            return this;
          }

          private float averageClientSentimentScore_;
          /**
           *
           *
           * <pre>
           * The average client's sentiment score.
           * </pre>
           *
           * <code>optional float average_client_sentiment_score = 6;</code>
           *
           * @return Whether the averageClientSentimentScore field is set.
           */
          @java.lang.Override
          public boolean hasAverageClientSentimentScore() {
            return ((bitField0_ & 0x00000020) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average client's sentiment score.
           * </pre>
           *
           * <code>optional float average_client_sentiment_score = 6;</code>
           *
           * @return The averageClientSentimentScore.
           */
          @java.lang.Override
          public float getAverageClientSentimentScore() {
            return averageClientSentimentScore_;
          }
          /**
           *
           *
           * <pre>
           * The average client's sentiment score.
           * </pre>
           *
           * <code>optional float average_client_sentiment_score = 6;</code>
           *
           * @param value The averageClientSentimentScore to set.
           * @return This builder for chaining.
           */
          public Builder setAverageClientSentimentScore(float value) {

            averageClientSentimentScore_ = value;
            bitField0_ |= 0x00000020;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average client's sentiment score.
           * </pre>
           *
           * <code>optional float average_client_sentiment_score = 6;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageClientSentimentScore() {
            bitField0_ = (bitField0_ & ~0x00000020);
            averageClientSentimentScore_ = 0F;
            onChanged();
            return this;
          }

          private double averageCustomerSatisfactionRating_;
          /**
           *
           *
           * <pre>
           * The average customer satisfaction rating.
           * </pre>
           *
           * <code>optional double average_customer_satisfaction_rating = 8;</code>
           *
           * @return Whether the averageCustomerSatisfactionRating field is set.
           */
          @java.lang.Override
          public boolean hasAverageCustomerSatisfactionRating() {
            return ((bitField0_ & 0x00000040) != 0);
          }
          /**
           *
           *
           * <pre>
           * The average customer satisfaction rating.
           * </pre>
           *
           * <code>optional double average_customer_satisfaction_rating = 8;</code>
           *
           * @return The averageCustomerSatisfactionRating.
           */
          @java.lang.Override
          public double getAverageCustomerSatisfactionRating() {
            return averageCustomerSatisfactionRating_;
          }
          /**
           *
           *
           * <pre>
           * The average customer satisfaction rating.
           * </pre>
           *
           * <code>optional double average_customer_satisfaction_rating = 8;</code>
           *
           * @param value The averageCustomerSatisfactionRating to set.
           * @return This builder for chaining.
           */
          public Builder setAverageCustomerSatisfactionRating(double value) {

            averageCustomerSatisfactionRating_ = value;
            bitField0_ |= 0x00000040;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * The average customer satisfaction rating.
           * </pre>
           *
           * <code>optional double average_customer_satisfaction_rating = 8;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageCustomerSatisfactionRating() {
            bitField0_ = (bitField0_ & ~0x00000040);
            averageCustomerSatisfactionRating_ = 0D;
            onChanged();
            return this;
          }

          private double averageQaNormalizedScore_;
          /**
           *
           *
           * <pre>
           * Average QA normalized score.
           * Will exclude 0's in average calculation.
           * </pre>
           *
           * <code>optional double average_qa_normalized_score = 7;</code>
           *
           * @return Whether the averageQaNormalizedScore field is set.
           */
          @java.lang.Override
          public boolean hasAverageQaNormalizedScore() {
            return ((bitField0_ & 0x00000080) != 0);
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score.
           * Will exclude 0's in average calculation.
           * </pre>
           *
           * <code>optional double average_qa_normalized_score = 7;</code>
           *
           * @return The averageQaNormalizedScore.
           */
          @java.lang.Override
          public double getAverageQaNormalizedScore() {
            return averageQaNormalizedScore_;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score.
           * Will exclude 0's in average calculation.
           * </pre>
           *
           * <code>optional double average_qa_normalized_score = 7;</code>
           *
           * @param value The averageQaNormalizedScore to set.
           * @return This builder for chaining.
           */
          public Builder setAverageQaNormalizedScore(double value) {

            averageQaNormalizedScore_ = value;
            bitField0_ |= 0x00000080;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score.
           * Will exclude 0's in average calculation.
           * </pre>
           *
           * <code>optional double average_qa_normalized_score = 7;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageQaNormalizedScore() {
            bitField0_ = (bitField0_ & ~0x00000080);
            averageQaNormalizedScore_ = 0D;
            onChanged();
            return this;
          }

          private java.util.List<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore>
              qaTagScores_ = java.util.Collections.emptyList();

          private void ensureQaTagScoresIsMutable() {
            if (!((bitField0_ & 0x00000100) != 0)) {
              qaTagScores_ =
                  new java.util.ArrayList<
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScore>(qaTagScores_);
              bitField0_ |= 0x00000100;
            }
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScoreOrBuilder>
              qaTagScoresBuilder_;

          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore>
              getQaTagScoresList() {
            if (qaTagScoresBuilder_ == null) {
              return java.util.Collections.unmodifiableList(qaTagScores_);
            } else {
              return qaTagScoresBuilder_.getMessageList();
            }
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public int getQaTagScoresCount() {
            if (qaTagScoresBuilder_ == null) {
              return qaTagScores_.size();
            } else {
              return qaTagScoresBuilder_.getCount();
            }
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore
              getQaTagScores(int index) {
            if (qaTagScoresBuilder_ == null) {
              return qaTagScores_.get(index);
            } else {
              return qaTagScoresBuilder_.getMessage(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder setQaTagScores(
              int index,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  value) {
            if (qaTagScoresBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureQaTagScoresIsMutable();
              qaTagScores_.set(index, value);
              onChanged();
            } else {
              qaTagScoresBuilder_.setMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder setQaTagScores(
              int index,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder
                  builderForValue) {
            if (qaTagScoresBuilder_ == null) {
              ensureQaTagScoresIsMutable();
              qaTagScores_.set(index, builderForValue.build());
              onChanged();
            } else {
              qaTagScoresBuilder_.setMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder addQaTagScores(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  value) {
            if (qaTagScoresBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureQaTagScoresIsMutable();
              qaTagScores_.add(value);
              onChanged();
            } else {
              qaTagScoresBuilder_.addMessage(value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder addQaTagScores(
              int index,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore
                  value) {
            if (qaTagScoresBuilder_ == null) {
              if (value == null) {
                throw new NullPointerException();
              }
              ensureQaTagScoresIsMutable();
              qaTagScores_.add(index, value);
              onChanged();
            } else {
              qaTagScoresBuilder_.addMessage(index, value);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder addQaTagScores(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder
                  builderForValue) {
            if (qaTagScoresBuilder_ == null) {
              ensureQaTagScoresIsMutable();
              qaTagScores_.add(builderForValue.build());
              onChanged();
            } else {
              qaTagScoresBuilder_.addMessage(builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder addQaTagScores(
              int index,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder
                  builderForValue) {
            if (qaTagScoresBuilder_ == null) {
              ensureQaTagScoresIsMutable();
              qaTagScores_.add(index, builderForValue.build());
              onChanged();
            } else {
              qaTagScoresBuilder_.addMessage(index, builderForValue.build());
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder addAllQaTagScores(
              java.lang.Iterable<
                      ? extends
                          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                              .DataPoint.ConversationMeasure.QaTagScore>
                  values) {
            if (qaTagScoresBuilder_ == null) {
              ensureQaTagScoresIsMutable();
              com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qaTagScores_);
              onChanged();
            } else {
              qaTagScoresBuilder_.addAllMessages(values);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder clearQaTagScores() {
            if (qaTagScoresBuilder_ == null) {
              qaTagScores_ = java.util.Collections.emptyList();
              bitField0_ = (bitField0_ & ~0x00000100);
              onChanged();
            } else {
              qaTagScoresBuilder_.clear();
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public Builder removeQaTagScores(int index) {
            if (qaTagScoresBuilder_ == null) {
              ensureQaTagScoresIsMutable();
              qaTagScores_.remove(index);
              onChanged();
            } else {
              qaTagScoresBuilder_.remove(index);
            }
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore.Builder
              getQaTagScoresBuilder(int index) {
            return getQaTagScoresFieldBuilder().getBuilder(index);
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScoreOrBuilder
              getQaTagScoresOrBuilder(int index) {
            if (qaTagScoresBuilder_ == null) {
              return qaTagScores_.get(index);
            } else {
              return qaTagScoresBuilder_.getMessageOrBuilder(index);
            }
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public java.util.List<
                  ? extends
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScoreOrBuilder>
              getQaTagScoresOrBuilderList() {
            if (qaTagScoresBuilder_ != null) {
              return qaTagScoresBuilder_.getMessageOrBuilderList();
            } else {
              return java.util.Collections.unmodifiableList(qaTagScores_);
            }
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore.Builder
              addQaTagScoresBuilder() {
            return getQaTagScoresFieldBuilder()
                .addBuilder(
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure.QaTagScore.Builder
              addQaTagScoresBuilder(int index) {
            return getQaTagScoresFieldBuilder()
                .addBuilder(
                    index,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.QaTagScore.getDefaultInstance());
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score for all the tags.
           * </pre>
           *
           * <code>
           * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure.QaTagScore qa_tag_scores = 9;
           * </code>
           */
          public java.util.List<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder>
              getQaTagScoresBuilderList() {
            return getQaTagScoresFieldBuilder().getBuilderList();
          }

          private com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScore.Builder,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.QaTagScoreOrBuilder>
              getQaTagScoresFieldBuilder() {
            if (qaTagScoresBuilder_ == null) {
              qaTagScoresBuilder_ =
                  new com.google.protobuf.RepeatedFieldBuilderV3<
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScore,
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScore.Builder,
                      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure.QaTagScoreOrBuilder>(
                      qaTagScores_,
                      ((bitField0_ & 0x00000100) != 0),
                      getParentForChildren(),
                      isClean());
              qaTagScores_ = null;
            }
            return qaTagScoresBuilder_;
          }

          private double averageQaQuestionNormalizedScore_;
          /**
           *
           *
           * <pre>
           * Average QA normalized score averaged for questions averaged across
           * all revisions of the parent scorecard.
           * Will be only populated if the request specifies a dimension of
           * QA_QUESTION_ID.
           * </pre>
           *
           * <code>optional double average_qa_question_normalized_score = 10;</code>
           *
           * @return Whether the averageQaQuestionNormalizedScore field is set.
           */
          @java.lang.Override
          public boolean hasAverageQaQuestionNormalizedScore() {
            return ((bitField0_ & 0x00000200) != 0);
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score averaged for questions averaged across
           * all revisions of the parent scorecard.
           * Will be only populated if the request specifies a dimension of
           * QA_QUESTION_ID.
           * </pre>
           *
           * <code>optional double average_qa_question_normalized_score = 10;</code>
           *
           * @return The averageQaQuestionNormalizedScore.
           */
          @java.lang.Override
          public double getAverageQaQuestionNormalizedScore() {
            return averageQaQuestionNormalizedScore_;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score averaged for questions averaged across
           * all revisions of the parent scorecard.
           * Will be only populated if the request specifies a dimension of
           * QA_QUESTION_ID.
           * </pre>
           *
           * <code>optional double average_qa_question_normalized_score = 10;</code>
           *
           * @param value The averageQaQuestionNormalizedScore to set.
           * @return This builder for chaining.
           */
          public Builder setAverageQaQuestionNormalizedScore(double value) {

            averageQaQuestionNormalizedScore_ = value;
            bitField0_ |= 0x00000200;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Average QA normalized score averaged for questions averaged across
           * all revisions of the parent scorecard.
           * Will be only populated if the request specifies a dimension of
           * QA_QUESTION_ID.
           * </pre>
           *
           * <code>optional double average_qa_question_normalized_score = 10;</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearAverageQaQuestionNormalizedScore() {
            bitField0_ = (bitField0_ & ~0x00000200);
            averageQaQuestionNormalizedScore_ = 0D;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure)
        private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                .DataPoint.ConversationMeasure
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure();
        }

        public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<ConversationMeasure> PARSER =
            new com.google.protobuf.AbstractParser<ConversationMeasure>() {
              @java.lang.Override
              public ConversationMeasure parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<ConversationMeasure> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<ConversationMeasure> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int bitField0_;
      private int measureCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object measure_;

      public enum MeasureCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        CONVERSATION_MEASURE(2),
        MEASURE_NOT_SET(0);
        private final int value;

        private MeasureCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static MeasureCase valueOf(int value) {
          return forNumber(value);
        }

        public static MeasureCase forNumber(int value) {
          switch (value) {
            case 2:
              return CONVERSATION_MEASURE;
            case 0:
              return MEASURE_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public MeasureCase getMeasureCase() {
        return MeasureCase.forNumber(measureCase_);
      }

      public static final int CONVERSATION_MEASURE_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       *
       * @return Whether the conversationMeasure field is set.
       */
      @java.lang.Override
      public boolean hasConversationMeasure() {
        return measureCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       *
       * @return The conversationMeasure.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .ConversationMeasure
          getConversationMeasure() {
        if (measureCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure)
              measure_;
        }
        return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            .ConversationMeasure.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The measure related to conversations.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .ConversationMeasureOrBuilder
          getConversationMeasureOrBuilder() {
        if (measureCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .ConversationMeasure)
              measure_;
        }
        return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            .ConversationMeasure.getDefaultInstance();
      }

      public static final int INTERVAL_FIELD_NUMBER = 1;
      private com.google.type.Interval interval_;
      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       *
       * @return Whether the interval field is set.
       */
      @java.lang.Override
      public boolean hasInterval() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       *
       * @return The interval.
       */
      @java.lang.Override
      public com.google.type.Interval getInterval() {
        return interval_ == null ? com.google.type.Interval.getDefaultInstance() : interval_;
      }
      /**
       *
       *
       * <pre>
       * The interval that this data point represents.
       *
       * * If this is the total data point, the interval is
       * [starting create time, ending create time) from the request.
       * * If this a data point from the time series, the interval is
       * [time, time + time granularity from the request).
       * </pre>
       *
       * <code>.google.type.Interval interval = 1;</code>
       */
      @java.lang.Override
      public com.google.type.IntervalOrBuilder getIntervalOrBuilder() {
        return interval_ == null ? com.google.type.Interval.getDefaultInstance() : interval_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getInterval());
        }
        if (measureCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure)
                  measure_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInterval());
        }
        if (measureCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                          .ConversationMeasure)
                      measure_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint other =
            (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint) obj;

        if (hasInterval() != other.hasInterval()) return false;
        if (hasInterval()) {
          if (!getInterval().equals(other.getInterval())) return false;
        }
        if (!getMeasureCase().equals(other.getMeasureCase())) return false;
        switch (measureCase_) {
          case 2:
            if (!getConversationMeasure().equals(other.getConversationMeasure())) return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasInterval()) {
          hash = (37 * hash) + INTERVAL_FIELD_NUMBER;
          hash = (53 * hash) + getInterval().hashCode();
        }
        switch (measureCase_) {
          case 2:
            hash = (37 * hash) + CONVERSATION_MEASURE_FIELD_NUMBER;
            hash = (53 * hash) + getConversationMeasure().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A data point contains the metric values mapped to an interval.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .class,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getIntervalFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (conversationMeasureBuilder_ != null) {
            conversationMeasureBuilder_.clear();
          }
          interval_ = null;
          if (intervalBuilder_ != null) {
            intervalBuilder_.dispose();
            intervalBuilder_ = null;
          }
          measureCase_ = 0;
          measure_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_DataPoint_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            build() {
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint result =
              new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.interval_ = intervalBuilder_ == null ? interval_ : intervalBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        private void buildPartialOneofs(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint result) {
          result.measureCase_ = measureCase_;
          result.measure_ = this.measure_;
          if (measureCase_ == 2 && conversationMeasureBuilder_ != null) {
            result.measure_ = conversationMeasureBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .getDefaultInstance()) return this;
          if (other.hasInterval()) {
            mergeInterval(other.getInterval());
          }
          switch (other.getMeasureCase()) {
            case CONVERSATION_MEASURE:
              {
                mergeConversationMeasure(other.getConversationMeasure());
                break;
              }
            case MEASURE_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getIntervalFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getConversationMeasureFieldBuilder().getBuilder(), extensionRegistry);
                    measureCase_ = 2;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int measureCase_ = 0;
        private java.lang.Object measure_;

        public MeasureCase getMeasureCase() {
          return MeasureCase.forNumber(measureCase_);
        }

        public Builder clearMeasure() {
          measureCase_ = 0;
          measure_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasureOrBuilder>
            conversationMeasureBuilder_;
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         *
         * @return Whether the conversationMeasure field is set.
         */
        @java.lang.Override
        public boolean hasConversationMeasure() {
          return measureCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         *
         * @return The conversationMeasure.
         */
        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure
            getConversationMeasure() {
          if (conversationMeasureBuilder_ == null) {
            if (measureCase_ == 2) {
              return (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure)
                  measure_;
            }
            return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.getDefaultInstance();
          } else {
            if (measureCase_ == 2) {
              return conversationMeasureBuilder_.getMessage();
            }
            return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        public Builder setConversationMeasure(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure
                value) {
          if (conversationMeasureBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            measure_ = value;
            onChanged();
          } else {
            conversationMeasureBuilder_.setMessage(value);
          }
          measureCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        public Builder setConversationMeasure(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.Builder
                builderForValue) {
          if (conversationMeasureBuilder_ == null) {
            measure_ = builderForValue.build();
            onChanged();
          } else {
            conversationMeasureBuilder_.setMessage(builderForValue.build());
          }
          measureCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        public Builder mergeConversationMeasure(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure
                value) {
          if (conversationMeasureBuilder_ == null) {
            if (measureCase_ == 2
                && measure_
                    != com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                        .DataPoint.ConversationMeasure.getDefaultInstance()) {
              measure_ =
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.newBuilder(
                          (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                                  .DataPoint.ConversationMeasure)
                              measure_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              measure_ = value;
            }
            onChanged();
          } else {
            if (measureCase_ == 2) {
              conversationMeasureBuilder_.mergeFrom(value);
            } else {
              conversationMeasureBuilder_.setMessage(value);
            }
          }
          measureCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        public Builder clearConversationMeasure() {
          if (conversationMeasureBuilder_ == null) {
            if (measureCase_ == 2) {
              measureCase_ = 0;
              measure_ = null;
              onChanged();
            }
          } else {
            if (measureCase_ == 2) {
              measureCase_ = 0;
              measure_ = null;
            }
            conversationMeasureBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.Builder
            getConversationMeasureBuilder() {
          return getConversationMeasureFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasureOrBuilder
            getConversationMeasureOrBuilder() {
          if ((measureCase_ == 2) && (conversationMeasureBuilder_ != null)) {
            return conversationMeasureBuilder_.getMessageOrBuilder();
          } else {
            if (measureCase_ == 2) {
              return (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure)
                  measure_;
            }
            return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .ConversationMeasure.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The measure related to conversations.
         * </pre>
         *
         * <code>
         * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.ConversationMeasure conversation_measure = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasure.Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .ConversationMeasureOrBuilder>
            getConversationMeasureFieldBuilder() {
          if (conversationMeasureBuilder_ == null) {
            if (!(measureCase_ == 2)) {
              measure_ =
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .ConversationMeasure.getDefaultInstance();
            }
            conversationMeasureBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasure.Builder,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .ConversationMeasureOrBuilder>(
                    (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                            .ConversationMeasure)
                        measure_,
                    getParentForChildren(),
                    isClean());
            measure_ = null;
          }
          measureCase_ = 2;
          onChanged();
          return conversationMeasureBuilder_;
        }

        private com.google.type.Interval interval_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>
            intervalBuilder_;
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         *
         * @return Whether the interval field is set.
         */
        public boolean hasInterval() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         *
         * @return The interval.
         */
        public com.google.type.Interval getInterval() {
          if (intervalBuilder_ == null) {
            return interval_ == null ? com.google.type.Interval.getDefaultInstance() : interval_;
          } else {
            return intervalBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public Builder setInterval(com.google.type.Interval value) {
          if (intervalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            interval_ = value;
          } else {
            intervalBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public Builder setInterval(com.google.type.Interval.Builder builderForValue) {
          if (intervalBuilder_ == null) {
            interval_ = builderForValue.build();
          } else {
            intervalBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public Builder mergeInterval(com.google.type.Interval value) {
          if (intervalBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && interval_ != null
                && interval_ != com.google.type.Interval.getDefaultInstance()) {
              getIntervalBuilder().mergeFrom(value);
            } else {
              interval_ = value;
            }
          } else {
            intervalBuilder_.mergeFrom(value);
          }
          if (interval_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public Builder clearInterval() {
          bitField0_ = (bitField0_ & ~0x00000002);
          interval_ = null;
          if (intervalBuilder_ != null) {
            intervalBuilder_.dispose();
            intervalBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public com.google.type.Interval.Builder getIntervalBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getIntervalFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        public com.google.type.IntervalOrBuilder getIntervalOrBuilder() {
          if (intervalBuilder_ != null) {
            return intervalBuilder_.getMessageOrBuilder();
          } else {
            return interval_ == null ? com.google.type.Interval.getDefaultInstance() : interval_;
          }
        }
        /**
         *
         *
         * <pre>
         * The interval that this data point represents.
         *
         * * If this is the total data point, the interval is
         * [starting create time, ending create time) from the request.
         * * If this a data point from the time series, the interval is
         * [time, time + time granularity from the request).
         * </pre>
         *
         * <code>.google.type.Interval interval = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Interval,
                com.google.type.Interval.Builder,
                com.google.type.IntervalOrBuilder>
            getIntervalFieldBuilder() {
          if (intervalBuilder_ == null) {
            intervalBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.type.Interval,
                    com.google.type.Interval.Builder,
                    com.google.type.IntervalOrBuilder>(
                    getInterval(), getParentForChildren(), isClean());
            interval_ = null;
          }
          return intervalBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint)
      private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
              .DataPoint
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint();
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DataPoint> PARSER =
          new com.google.protobuf.AbstractParser<DataPoint>() {
            @java.lang.Override
            public DataPoint parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DataPoint> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DataPoint> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface TimeSeriesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      java.util.List<com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>
          getDataPointsList();
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint getDataPoints(
          int index);
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      int getDataPointsCount();
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                      .DataPointOrBuilder>
          getDataPointsOrBuilderList();
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder
          getDataPointsOrBuilder(int index);
    }
    /**
     *
     *
     * <pre>
     * A time series of metric values.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries}
     */
    public static final class TimeSeries extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
        TimeSeriesOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use TimeSeries.newBuilder() to construct.
      private TimeSeries(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private TimeSeries() {
        dataPoints_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new TimeSeries();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_TimeSeries_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_TimeSeries_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                    .class,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                    .Builder.class);
      }

      public static final int DATA_POINTS_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private java.util.List<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>
          dataPoints_;
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>
          getDataPointsList() {
        return dataPoints_;
      }
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                      .DataPointOrBuilder>
          getDataPointsOrBuilderList() {
        return dataPoints_;
      }
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      @java.lang.Override
      public int getDataPointsCount() {
        return dataPoints_.size();
      }
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          getDataPoints(int index) {
        return dataPoints_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The data points that make up the time series .
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder
          getDataPointsOrBuilder(int index) {
        return dataPoints_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < dataPoints_.size(); i++) {
          output.writeMessage(4, dataPoints_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < dataPoints_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, dataPoints_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries other =
            (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries) obj;

        if (!getDataPointsList().equals(other.getDataPointsList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getDataPointsCount() > 0) {
          hash = (37 * hash) + DATA_POINTS_FIELD_NUMBER;
          hash = (53 * hash) + getDataPointsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeriesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_TimeSeries_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_TimeSeries_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                      .class,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (dataPointsBuilder_ == null) {
            dataPoints_ = java.util.Collections.emptyList();
          } else {
            dataPoints_ = null;
            dataPointsBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_TimeSeries_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
            build() {
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries result =
              new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries(
                  this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                result) {
          if (dataPointsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              dataPoints_ = java.util.Collections.unmodifiableList(dataPoints_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.dataPoints_ = dataPoints_;
          } else {
            result.dataPoints_ = dataPointsBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                  .getDefaultInstance()) return this;
          if (dataPointsBuilder_ == null) {
            if (!other.dataPoints_.isEmpty()) {
              if (dataPoints_.isEmpty()) {
                dataPoints_ = other.dataPoints_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureDataPointsIsMutable();
                dataPoints_.addAll(other.dataPoints_);
              }
              onChanged();
            }
          } else {
            if (!other.dataPoints_.isEmpty()) {
              if (dataPointsBuilder_.isEmpty()) {
                dataPointsBuilder_.dispose();
                dataPointsBuilder_ = null;
                dataPoints_ = other.dataPoints_;
                bitField0_ = (bitField0_ & ~0x00000001);
                dataPointsBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getDataPointsFieldBuilder()
                        : null;
              } else {
                dataPointsBuilder_.addAllMessages(other.dataPoints_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 34:
                  {
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        m =
                            input.readMessage(
                                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                                    .DataPoint.parser(),
                                extensionRegistry);
                    if (dataPointsBuilder_ == null) {
                      ensureDataPointsIsMutable();
                      dataPoints_.add(m);
                    } else {
                      dataPointsBuilder_.addMessage(m);
                    }
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>
            dataPoints_ = java.util.Collections.emptyList();

        private void ensureDataPointsIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            dataPoints_ =
                new java.util.ArrayList<
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>(
                    dataPoints_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                    .DataPointOrBuilder>
            dataPointsBuilder_;

        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint>
            getDataPointsList() {
          if (dataPointsBuilder_ == null) {
            return java.util.Collections.unmodifiableList(dataPoints_);
          } else {
            return dataPointsBuilder_.getMessageList();
          }
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public int getDataPointsCount() {
          if (dataPointsBuilder_ == null) {
            return dataPoints_.size();
          } else {
            return dataPointsBuilder_.getCount();
          }
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
            getDataPoints(int index) {
          if (dataPointsBuilder_ == null) {
            return dataPoints_.get(index);
          } else {
            return dataPointsBuilder_.getMessage(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder setDataPoints(
            int index,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint value) {
          if (dataPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataPointsIsMutable();
            dataPoints_.set(index, value);
            onChanged();
          } else {
            dataPointsBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder setDataPoints(
            int index,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.Builder
                builderForValue) {
          if (dataPointsBuilder_ == null) {
            ensureDataPointsIsMutable();
            dataPoints_.set(index, builderForValue.build());
            onChanged();
          } else {
            dataPointsBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder addDataPoints(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint value) {
          if (dataPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataPointsIsMutable();
            dataPoints_.add(value);
            onChanged();
          } else {
            dataPointsBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder addDataPoints(
            int index,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint value) {
          if (dataPointsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureDataPointsIsMutable();
            dataPoints_.add(index, value);
            onChanged();
          } else {
            dataPointsBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder addDataPoints(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.Builder
                builderForValue) {
          if (dataPointsBuilder_ == null) {
            ensureDataPointsIsMutable();
            dataPoints_.add(builderForValue.build());
            onChanged();
          } else {
            dataPointsBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder addDataPoints(
            int index,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.Builder
                builderForValue) {
          if (dataPointsBuilder_ == null) {
            ensureDataPointsIsMutable();
            dataPoints_.add(index, builderForValue.build());
            onChanged();
          } else {
            dataPointsBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder addAllDataPoints(
            java.lang.Iterable<
                    ? extends
                        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                            .DataPoint>
                values) {
          if (dataPointsBuilder_ == null) {
            ensureDataPointsIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataPoints_);
            onChanged();
          } else {
            dataPointsBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder clearDataPoints() {
          if (dataPointsBuilder_ == null) {
            dataPoints_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            dataPointsBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public Builder removeDataPoints(int index) {
          if (dataPointsBuilder_ == null) {
            ensureDataPointsIsMutable();
            dataPoints_.remove(index);
            onChanged();
          } else {
            dataPointsBuilder_.remove(index);
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .Builder
            getDataPointsBuilder(int index) {
          return getDataPointsFieldBuilder().getBuilder(index);
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                .DataPointOrBuilder
            getDataPointsOrBuilder(int index) {
          if (dataPointsBuilder_ == null) {
            return dataPoints_.get(index);
          } else {
            return dataPointsBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                        .DataPointOrBuilder>
            getDataPointsOrBuilderList() {
          if (dataPointsBuilder_ != null) {
            return dataPointsBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(dataPoints_);
          }
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .Builder
            addDataPointsBuilder() {
          return getDataPointsFieldBuilder()
              .addBuilder(
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                .Builder
            addDataPointsBuilder(int index) {
          return getDataPointsFieldBuilder()
              .addBuilder(
                  index,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .getDefaultInstance());
        }
        /**
         *
         *
         * <pre>
         * The data points that make up the time series .
         * </pre>
         *
         * <code>
         * repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint data_points = 4;
         * </code>
         */
        public java.util.List<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .Builder>
            getDataPointsBuilderList() {
          return getDataPointsFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                    .DataPointOrBuilder>
            getDataPointsFieldBuilder() {
          if (dataPointsBuilder_ == null) {
            dataPointsBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                        .Builder,
                    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                        .DataPointOrBuilder>(
                    dataPoints_,
                    ((bitField0_ & 0x00000001) != 0),
                    getParentForChildren(),
                    isClean());
            dataPoints_ = null;
          }
          return dataPointsBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries)
      private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
              .TimeSeries
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries();
      }

      public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<TimeSeries> PARSER =
          new com.google.protobuf.AbstractParser<TimeSeries>() {
            @java.lang.Override
            public TimeSeries parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<TimeSeries> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TimeSeries> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int DIMENSIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> dimensions_;
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> getDimensionsList() {
      return dimensions_;
    }
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
        getDimensionsOrBuilderList() {
      return dimensions_;
    }
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    @java.lang.Override
    public int getDimensionsCount() {
      return dimensions_.size();
    }
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension getDimensions(int index) {
      return dimensions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A unique combination of dimensions that this slice represents.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder getDimensionsOrBuilder(
        int index) {
      return dimensions_.get(index);
    }

    public static final int TOTAL_FIELD_NUMBER = 2;
    private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total_;
    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     *
     * @return Whether the total field is set.
     */
    @java.lang.Override
    public boolean hasTotal() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     *
     * @return The total.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
        getTotal() {
      return total_ == null
          ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .getDefaultInstance()
          : total_;
    }
    /**
     *
     *
     * <pre>
     * The total metric value. The interval of this data point is
     * [starting create time, ending create time) from the request.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder
        getTotalOrBuilder() {
      return total_ == null
          ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
              .getDefaultInstance()
          : total_;
    }

    public static final int TIME_SERIES_FIELD_NUMBER = 3;
    private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
        timeSeries_;
    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     *
     * @return Whether the timeSeries field is set.
     */
    @java.lang.Override
    public boolean hasTimeSeries() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     *
     * @return The timeSeries.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
        getTimeSeries() {
      return timeSeries_ == null
          ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
              .getDefaultInstance()
          : timeSeries_;
    }
    /**
     *
     *
     * <pre>
     * A time series of metric values. This is only populated if the request
     * specifies a time granularity other than NONE.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeriesOrBuilder
        getTimeSeriesOrBuilder() {
      return timeSeries_ == null
          ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
              .getDefaultInstance()
          : timeSeries_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < dimensions_.size(); i++) {
        output.writeMessage(1, dimensions_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getTotal());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getTimeSeries());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < dimensions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dimensions_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTotal());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimeSeries());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice other =
          (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice) obj;

      if (!getDimensionsList().equals(other.getDimensionsList())) return false;
      if (hasTotal() != other.hasTotal()) return false;
      if (hasTotal()) {
        if (!getTotal().equals(other.getTotal())) return false;
      }
      if (hasTimeSeries() != other.hasTimeSeries()) return false;
      if (hasTimeSeries()) {
        if (!getTimeSeries().equals(other.getTimeSeries())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getDimensionsCount() > 0) {
        hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
        hash = (53 * hash) + getDimensionsList().hashCode();
      }
      if (hasTotal()) {
        hash = (37 * hash) + TOTAL_FIELD_NUMBER;
        hash = (53 * hash) + getTotal().hashCode();
      }
      if (hasTimeSeries()) {
        hash = (37 * hash) + TIME_SERIES_FIELD_NUMBER;
        hash = (53 * hash) + getTimeSeries().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     *
     * For example, if the request specifies a single ISSUE dimension and it has a
     * cardinality of 2 (i.e. the data used to compute the metrics has 2 issues in
     * total), the response will have 2 slices:
     *
     * * Slice 1 -&gt; dimensions=[Issue 1]
     * * Slice 2 -&gt; dimensions=[Issue 2]
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.class,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDimensionsFieldBuilder();
          getTotalFieldBuilder();
          getTimeSeriesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (dimensionsBuilder_ == null) {
          dimensions_ = java.util.Collections.emptyList();
        } else {
          dimensions_ = null;
          dimensionsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        total_ = null;
        if (totalBuilder_ != null) {
          totalBuilder_.dispose();
          totalBuilder_ = null;
        }
        timeSeries_ = null;
        if (timeSeriesBuilder_ != null) {
          timeSeriesBuilder_.dispose();
          timeSeriesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_Slice_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice build() {
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice result =
            new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice result) {
        if (dimensionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.dimensions_ = dimensions_;
        } else {
          result.dimensions_ = dimensionsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.total_ = totalBuilder_ == null ? total_ : totalBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timeSeries_ =
              timeSeriesBuilder_ == null ? timeSeries_ : timeSeriesBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                .getDefaultInstance()) return this;
        if (dimensionsBuilder_ == null) {
          if (!other.dimensions_.isEmpty()) {
            if (dimensions_.isEmpty()) {
              dimensions_ = other.dimensions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureDimensionsIsMutable();
              dimensions_.addAll(other.dimensions_);
            }
            onChanged();
          }
        } else {
          if (!other.dimensions_.isEmpty()) {
            if (dimensionsBuilder_.isEmpty()) {
              dimensionsBuilder_.dispose();
              dimensionsBuilder_ = null;
              dimensions_ = other.dimensions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              dimensionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getDimensionsFieldBuilder()
                      : null;
            } else {
              dimensionsBuilder_.addAllMessages(other.dimensions_);
            }
          }
        }
        if (other.hasTotal()) {
          mergeTotal(other.getTotal());
        }
        if (other.hasTimeSeries()) {
          mergeTimeSeries(other.getTimeSeries());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.contactcenterinsights.v1.Dimension m =
                      input.readMessage(
                          com.google.cloud.contactcenterinsights.v1.Dimension.parser(),
                          extensionRegistry);
                  if (dimensionsBuilder_ == null) {
                    ensureDimensionsIsMutable();
                    dimensions_.add(m);
                  } else {
                    dimensionsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getTotalFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimeSeriesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> dimensions_ =
          java.util.Collections.emptyList();

      private void ensureDimensionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          dimensions_ =
              new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.Dimension>(
                  dimensions_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.Dimension,
              com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
              com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
          dimensionsBuilder_;

      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension>
          getDimensionsList() {
        if (dimensionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(dimensions_);
        } else {
          return dimensionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public int getDimensionsCount() {
        if (dimensionsBuilder_ == null) {
          return dimensions_.size();
        } else {
          return dimensionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.Dimension getDimensions(int index) {
        if (dimensionsBuilder_ == null) {
          return dimensions_.get(index);
        } else {
          return dimensionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder setDimensions(
          int index, com.google.cloud.contactcenterinsights.v1.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.set(index, value);
          onChanged();
        } else {
          dimensionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder setDimensions(
          int index, com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.set(index, builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder addDimensions(com.google.cloud.contactcenterinsights.v1.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.add(value);
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder addDimensions(
          int index, com.google.cloud.contactcenterinsights.v1.Dimension value) {
        if (dimensionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureDimensionsIsMutable();
          dimensions_.add(index, value);
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder addDimensions(
          com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.add(builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder addDimensions(
          int index, com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.add(index, builderForValue.build());
          onChanged();
        } else {
          dimensionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder addAllDimensions(
          java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.Dimension>
              values) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
          onChanged();
        } else {
          dimensionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder clearDimensions() {
        if (dimensionsBuilder_ == null) {
          dimensions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          dimensionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public Builder removeDimensions(int index) {
        if (dimensionsBuilder_ == null) {
          ensureDimensionsIsMutable();
          dimensions_.remove(index);
          onChanged();
        } else {
          dimensionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.Dimension.Builder getDimensionsBuilder(
          int index) {
        return getDimensionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder getDimensionsOrBuilder(
          int index) {
        if (dimensionsBuilder_ == null) {
          return dimensions_.get(index);
        } else {
          return dimensionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
          getDimensionsOrBuilderList() {
        if (dimensionsBuilder_ != null) {
          return dimensionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(dimensions_);
        }
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.Dimension.Builder addDimensionsBuilder() {
        return getDimensionsFieldBuilder()
            .addBuilder(com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.Dimension.Builder addDimensionsBuilder(
          int index) {
        return getDimensionsFieldBuilder()
            .addBuilder(
                index, com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A unique combination of dimensions that this slice represents.
       * </pre>
       *
       * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 1;</code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension.Builder>
          getDimensionsBuilderList() {
        return getDimensionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.Dimension,
              com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
              com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
          getDimensionsFieldBuilder() {
        if (dimensionsBuilder_ == null) {
          dimensionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.Dimension,
                  com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
                  com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>(
                  dimensions_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          dimensions_ = null;
        }
        return dimensionsBuilder_;
      }

      private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPointOrBuilder>
          totalBuilder_;
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       *
       * @return Whether the total field is set.
       */
      public boolean hasTotal() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       *
       * @return The total.
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
          getTotal() {
        if (totalBuilder_ == null) {
          return total_ == null
              ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .getDefaultInstance()
              : total_;
        } else {
          return totalBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public Builder setTotal(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint value) {
        if (totalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          total_ = value;
        } else {
          totalBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public Builder setTotal(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.Builder
              builderForValue) {
        if (totalBuilder_ == null) {
          total_ = builderForValue.build();
        } else {
          totalBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public Builder mergeTotal(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint value) {
        if (totalBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && total_ != null
              && total_
                  != com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .getDefaultInstance()) {
            getTotalBuilder().mergeFrom(value);
          } else {
            total_ = value;
          }
        } else {
          totalBuilder_.mergeFrom(value);
        }
        if (total_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public Builder clearTotal() {
        bitField0_ = (bitField0_ & ~0x00000002);
        total_ = null;
        if (totalBuilder_ != null) {
          totalBuilder_.dispose();
          totalBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint.Builder
          getTotalBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTotalFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPointOrBuilder
          getTotalOrBuilder() {
        if (totalBuilder_ != null) {
          return totalBuilder_.getMessageOrBuilder();
        } else {
          return total_ == null
              ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .getDefaultInstance()
              : total_;
        }
      }
      /**
       *
       *
       * <pre>
       * The total metric value. The interval of this data point is
       * [starting create time, ending create time) from the request.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint total = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .DataPointOrBuilder>
          getTotalFieldBuilder() {
        if (totalBuilder_ == null) {
          totalBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.DataPoint
                      .Builder,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                      .DataPointOrBuilder>(getTotal(), getParentForChildren(), isClean());
          total_ = null;
        }
        return totalBuilder_;
      }

      private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          timeSeries_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .TimeSeriesOrBuilder>
          timeSeriesBuilder_;
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       *
       * @return Whether the timeSeries field is set.
       */
      public boolean hasTimeSeries() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       *
       * @return The timeSeries.
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
          getTimeSeries() {
        if (timeSeriesBuilder_ == null) {
          return timeSeries_ == null
              ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                  .getDefaultInstance()
              : timeSeries_;
        } else {
          return timeSeriesBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public Builder setTimeSeries(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries value) {
        if (timeSeriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeSeries_ = value;
        } else {
          timeSeriesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public Builder setTimeSeries(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries.Builder
              builderForValue) {
        if (timeSeriesBuilder_ == null) {
          timeSeries_ = builderForValue.build();
        } else {
          timeSeriesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public Builder mergeTimeSeries(
          com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries value) {
        if (timeSeriesBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timeSeries_ != null
              && timeSeries_
                  != com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                      .getDefaultInstance()) {
            getTimeSeriesBuilder().mergeFrom(value);
          } else {
            timeSeries_ = value;
          }
        } else {
          timeSeriesBuilder_.mergeFrom(value);
        }
        if (timeSeries_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public Builder clearTimeSeries() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeSeries_ = null;
        if (timeSeriesBuilder_ != null) {
          timeSeriesBuilder_.dispose();
          timeSeriesBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries.Builder
          getTimeSeriesBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimeSeriesFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
              .TimeSeriesOrBuilder
          getTimeSeriesOrBuilder() {
        if (timeSeriesBuilder_ != null) {
          return timeSeriesBuilder_.getMessageOrBuilder();
        } else {
          return timeSeries_ == null
              ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                  .getDefaultInstance()
              : timeSeries_;
        }
      }
      /**
       *
       *
       * <pre>
       * A time series of metric values. This is only populated if the request
       * specifies a time granularity other than NONE.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries time_series = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .TimeSeriesOrBuilder>
          getTimeSeriesFieldBuilder() {
        if (timeSeriesBuilder_ == null) {
          timeSeriesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.TimeSeries
                      .Builder,
                  com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                      .TimeSeriesOrBuilder>(getTimeSeries(), getParentForChildren(), isClean());
          timeSeries_ = null;
        }
        return timeSeriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice)
    private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice();
    }

    public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Slice> PARSER =
        new com.google.protobuf.AbstractParser<Slice>() {
          @java.lang.Override
          public Slice parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Slice> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Slice> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Required. The location of the data.
   * "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The location of the data.
   * "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The metrics last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The metrics last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The metrics last update time.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SLICES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>
      slices_;
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>
      getSlicesList() {
    return slices_;
  }
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
      getSlicesOrBuilderList() {
    return slices_;
  }
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
   * </code>
   */
  @java.lang.Override
  public int getSlicesCount() {
    return slices_.size();
  }
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice getSlices(int index) {
    return slices_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A slice contains a total and (if the request specified a time granularity)
   * a time series of metric values. Each slice contains a unique combination of
   * the cardinality of dimensions from the request.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder
      getSlicesOrBuilder(int index) {
    return slices_.get(index);
  }

  public static final int MACRO_AVERAGE_SLICE_FIELD_NUMBER = 4;
  private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macroAverageSlice_;
  /**
   *
   *
   * <pre>
   * The macro average slice contains aggregated averages across the selected
   * dimension. i.e. if group_by agent is specified this field will contain the
   * average across all agents.
   * This field is only populated if the request specifies a Dimension.
   * </pre>
   *
   * <code>
   * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
   * </code>
   *
   * @return Whether the macroAverageSlice field is set.
   */
  @java.lang.Override
  public boolean hasMacroAverageSlice() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The macro average slice contains aggregated averages across the selected
   * dimension. i.e. if group_by agent is specified this field will contain the
   * average across all agents.
   * This field is only populated if the request specifies a Dimension.
   * </pre>
   *
   * <code>
   * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
   * </code>
   *
   * @return The macroAverageSlice.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
      getMacroAverageSlice() {
    return macroAverageSlice_ == null
        ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.getDefaultInstance()
        : macroAverageSlice_;
  }
  /**
   *
   *
   * <pre>
   * The macro average slice contains aggregated averages across the selected
   * dimension. i.e. if group_by agent is specified this field will contain the
   * average across all agents.
   * This field is only populated if the request specifies a Dimension.
   * </pre>
   *
   * <code>
   * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder
      getMacroAverageSliceOrBuilder() {
    return macroAverageSlice_ == null
        ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.getDefaultInstance()
        : macroAverageSlice_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    for (int i = 0; i < slices_.size(); i++) {
      output.writeMessage(2, slices_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getMacroAverageSlice());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    for (int i = 0; i < slices_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, slices_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMacroAverageSlice());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse other =
        (com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getSlicesList().equals(other.getSlicesList())) return false;
    if (hasMacroAverageSlice() != other.hasMacroAverageSlice()) return false;
    if (hasMacroAverageSlice()) {
      if (!getMacroAverageSlice().equals(other.getMacroAverageSlice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (getSlicesCount() > 0) {
      hash = (37 * hash) + SLICES_FIELD_NUMBER;
      hash = (53 * hash) + getSlicesList().hashCode();
    }
    if (hasMacroAverageSlice()) {
      hash = (37 * hash) + MACRO_AVERAGE_SLICE_FIELD_NUMBER;
      hash = (53 * hash) + getMacroAverageSlice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for querying metrics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsResponse)
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.class,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getUpdateTimeFieldBuilder();
        getSlicesFieldBuilder();
        getMacroAverageSliceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (slicesBuilder_ == null) {
        slices_ = java.util.Collections.emptyList();
      } else {
        slices_ = null;
        slicesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      macroAverageSlice_ = null;
      if (macroAverageSliceBuilder_ != null) {
        macroAverageSliceBuilder_.dispose();
        macroAverageSliceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse build() {
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse result =
          new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse result) {
      if (slicesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          slices_ = java.util.Collections.unmodifiableList(slices_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.slices_ = slices_;
      } else {
        result.slices_ = slicesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.macroAverageSlice_ =
            macroAverageSliceBuilder_ == null
                ? macroAverageSlice_
                : macroAverageSliceBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (slicesBuilder_ == null) {
        if (!other.slices_.isEmpty()) {
          if (slices_.isEmpty()) {
            slices_ = other.slices_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSlicesIsMutable();
            slices_.addAll(other.slices_);
          }
          onChanged();
        }
      } else {
        if (!other.slices_.isEmpty()) {
          if (slicesBuilder_.isEmpty()) {
            slicesBuilder_.dispose();
            slicesBuilder_ = null;
            slices_ = other.slices_;
            bitField0_ = (bitField0_ & ~0x00000004);
            slicesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSlicesFieldBuilder()
                    : null;
          } else {
            slicesBuilder_.addAllMessages(other.slices_);
          }
        }
      }
      if (other.hasMacroAverageSlice()) {
        mergeMacroAverageSlice(other.getMacroAverageSlice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                            .parser(),
                        extensionRegistry);
                if (slicesBuilder_ == null) {
                  ensureSlicesIsMutable();
                  slices_.add(m);
                } else {
                  slicesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getMacroAverageSliceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metrics last update time.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>
        slices_ = java.util.Collections.emptyList();

    private void ensureSlicesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        slices_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>(slices_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
        slicesBuilder_;

    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>
        getSlicesList() {
      if (slicesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(slices_);
      } else {
        return slicesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public int getSlicesCount() {
      if (slicesBuilder_ == null) {
        return slices_.size();
      } else {
        return slicesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice getSlices(
        int index) {
      if (slicesBuilder_ == null) {
        return slices_.get(index);
      } else {
        return slicesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder setSlices(
        int index, com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice value) {
      if (slicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSlicesIsMutable();
        slices_.set(index, value);
        onChanged();
      } else {
        slicesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder setSlices(
        int index,
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
            builderForValue) {
      if (slicesBuilder_ == null) {
        ensureSlicesIsMutable();
        slices_.set(index, builderForValue.build());
        onChanged();
      } else {
        slicesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder addSlices(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice value) {
      if (slicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSlicesIsMutable();
        slices_.add(value);
        onChanged();
      } else {
        slicesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder addSlices(
        int index, com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice value) {
      if (slicesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSlicesIsMutable();
        slices_.add(index, value);
        onChanged();
      } else {
        slicesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder addSlices(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
            builderForValue) {
      if (slicesBuilder_ == null) {
        ensureSlicesIsMutable();
        slices_.add(builderForValue.build());
        onChanged();
      } else {
        slicesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder addSlices(
        int index,
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
            builderForValue) {
      if (slicesBuilder_ == null) {
        ensureSlicesIsMutable();
        slices_.add(index, builderForValue.build());
        onChanged();
      } else {
        slicesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder addAllSlices(
        java.lang.Iterable<
                ? extends com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice>
            values) {
      if (slicesBuilder_ == null) {
        ensureSlicesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, slices_);
        onChanged();
      } else {
        slicesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder clearSlices() {
      if (slicesBuilder_ == null) {
        slices_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        slicesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public Builder removeSlices(int index) {
      if (slicesBuilder_ == null) {
        ensureSlicesIsMutable();
        slices_.remove(index);
        onChanged();
      } else {
        slicesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
        getSlicesBuilder(int index) {
      return getSlicesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder
        getSlicesOrBuilder(int index) {
      if (slicesBuilder_ == null) {
        return slices_.get(index);
      } else {
        return slicesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
        getSlicesOrBuilderList() {
      if (slicesBuilder_ != null) {
        return slicesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(slices_);
      }
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
        addSlicesBuilder() {
      return getSlicesFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
        addSlicesBuilder(int index) {
      return getSlicesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A slice contains a total and (if the request specified a time granularity)
     * a time series of metric values. Each slice contains a unique combination of
     * the cardinality of dimensions from the request.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice slices = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder>
        getSlicesBuilderList() {
      return getSlicesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
        getSlicesFieldBuilder() {
      if (slicesBuilder_ == null) {
        slicesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>(
                slices_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        slices_ = null;
      }
      return slicesBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macroAverageSlice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
        macroAverageSliceBuilder_;
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     *
     * @return Whether the macroAverageSlice field is set.
     */
    public boolean hasMacroAverageSlice() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     *
     * @return The macroAverageSlice.
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
        getMacroAverageSlice() {
      if (macroAverageSliceBuilder_ == null) {
        return macroAverageSlice_ == null
            ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                .getDefaultInstance()
            : macroAverageSlice_;
      } else {
        return macroAverageSliceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public Builder setMacroAverageSlice(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice value) {
      if (macroAverageSliceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        macroAverageSlice_ = value;
      } else {
        macroAverageSliceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public Builder setMacroAverageSlice(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
            builderForValue) {
      if (macroAverageSliceBuilder_ == null) {
        macroAverageSlice_ = builderForValue.build();
      } else {
        macroAverageSliceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public Builder mergeMacroAverageSlice(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice value) {
      if (macroAverageSliceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && macroAverageSlice_ != null
            && macroAverageSlice_
                != com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                    .getDefaultInstance()) {
          getMacroAverageSliceBuilder().mergeFrom(value);
        } else {
          macroAverageSlice_ = value;
        }
      } else {
        macroAverageSliceBuilder_.mergeFrom(value);
      }
      if (macroAverageSlice_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public Builder clearMacroAverageSlice() {
      bitField0_ = (bitField0_ & ~0x00000008);
      macroAverageSlice_ = null;
      if (macroAverageSliceBuilder_ != null) {
        macroAverageSliceBuilder_.dispose();
        macroAverageSliceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder
        getMacroAverageSliceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMacroAverageSliceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder
        getMacroAverageSliceOrBuilder() {
      if (macroAverageSliceBuilder_ != null) {
        return macroAverageSliceBuilder_.getMessageOrBuilder();
      } else {
        return macroAverageSlice_ == null
            ? com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice
                .getDefaultInstance()
            : macroAverageSlice_;
      }
    }
    /**
     *
     *
     * <pre>
     * The macro average slice contains aggregated averages across the selected
     * dimension. i.e. if group_by agent is specified this field will contain the
     * average across all agents.
     * This field is only populated if the request specifies a Dimension.
     * </pre>
     *
     * <code>
     * optional .google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice macro_average_slice = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>
        getMacroAverageSliceFieldBuilder() {
      if (macroAverageSliceBuilder_ == null) {
        macroAverageSliceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.Slice.Builder,
                com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse.SliceOrBuilder>(
                getMacroAverageSlice(), getParentForChildren(), isClean());
        macroAverageSlice_ = null;
      }
      return macroAverageSliceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsResponse)
  private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse();
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryMetricsResponse> PARSER =
      new com.google.protobuf.AbstractParser<QueryMetricsResponse>() {
        @java.lang.Override
        public QueryMetricsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryMetricsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryMetricsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
