/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * An annotation that was generated during the customer and agent interaction.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.RuntimeAnnotation}
 */
public final class RuntimeAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.RuntimeAnnotation)
    RuntimeAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RuntimeAnnotation.newBuilder() to construct.
  private RuntimeAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RuntimeAnnotation() {
    annotationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RuntimeAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.class,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder.class);
  }

  public interface UserInputOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Query text. Article Search uses this to store the input query used
     * to generate the search results.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The query.
     */
    java.lang.String getQuery();
    /**
     *
     *
     * <pre>
     * Query text. Article Search uses this to store the input query used
     * to generate the search results.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The bytes for query.
     */
    com.google.protobuf.ByteString getQueryBytes();

    /**
     *
     *
     * <pre>
     * The resource name of associated generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 2;</code>
     *
     * @return The generatorName.
     */
    java.lang.String getGeneratorName();
    /**
     *
     *
     * <pre>
     * The resource name of associated generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 2;</code>
     *
     * @return The bytes for generatorName.
     */
    com.google.protobuf.ByteString getGeneratorNameBytes();

    /**
     *
     *
     * <pre>
     * Query source for the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for querySource.
     */
    int getQuerySourceValue();
    /**
     *
     *
     * <pre>
     * Query source for the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
     * </code>
     *
     * @return The querySource.
     */
    com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
        getQuerySource();
  }
  /**
   *
   *
   * <pre>
   * Explicit input used for generating the answer
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput}
   */
  public static final class UserInput extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)
      UserInputOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UserInput.newBuilder() to construct.
    private UserInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UserInput() {
      query_ = "";
      generatorName_ = "";
      querySource_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UserInput();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_UserInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_UserInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.class,
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The source of the query.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource}
     */
    public enum QuerySource implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unknown query source.
       * </pre>
       *
       * <code>QUERY_SOURCE_UNSPECIFIED = 0;</code>
       */
      QUERY_SOURCE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The query is from agents.
       * </pre>
       *
       * <code>AGENT_QUERY = 1;</code>
       */
      AGENT_QUERY(1),
      /**
       *
       *
       * <pre>
       * The query is a query from previous suggestions, e.g. from a preceding
       * SuggestKnowledgeAssist response.
       * </pre>
       *
       * <code>SUGGESTED_QUERY = 2;</code>
       */
      SUGGESTED_QUERY(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unknown query source.
       * </pre>
       *
       * <code>QUERY_SOURCE_UNSPECIFIED = 0;</code>
       */
      public static final int QUERY_SOURCE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The query is from agents.
       * </pre>
       *
       * <code>AGENT_QUERY = 1;</code>
       */
      public static final int AGENT_QUERY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The query is a query from previous suggestions, e.g. from a preceding
       * SuggestKnowledgeAssist response.
       * </pre>
       *
       * <code>SUGGESTED_QUERY = 2;</code>
       */
      public static final int SUGGESTED_QUERY_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static QuerySource valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static QuerySource forNumber(int value) {
        switch (value) {
          case 0:
            return QUERY_SOURCE_UNSPECIFIED;
          case 1:
            return AGENT_QUERY;
          case 2:
            return SUGGESTED_QUERY;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<QuerySource> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<QuerySource> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QuerySource>() {
            public QuerySource findValueByNumber(int number) {
              return QuerySource.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final QuerySource[] VALUES = values();

      public static QuerySource valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private QuerySource(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource)
    }

    public static final int QUERY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Query text. Article Search uses this to store the input query used
     * to generate the search results.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Query text. Article Search uses this to store the input query used
     * to generate the search results.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The bytes for query.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GENERATOR_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object generatorName_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of associated generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 2;</code>
     *
     * @return The generatorName.
     */
    @java.lang.Override
    public java.lang.String getGeneratorName() {
      java.lang.Object ref = generatorName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        generatorName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of associated generator. Format:
     * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
     * </pre>
     *
     * <code>string generator_name = 2;</code>
     *
     * @return The bytes for generatorName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGeneratorNameBytes() {
      java.lang.Object ref = generatorName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        generatorName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUERY_SOURCE_FIELD_NUMBER = 3;
    private int querySource_ = 0;
    /**
     *
     *
     * <pre>
     * Query source for the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for querySource.
     */
    @java.lang.Override
    public int getQuerySourceValue() {
      return querySource_;
    }
    /**
     *
     *
     * <pre>
     * Query source for the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
     * </code>
     *
     * @return The querySource.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
        getQuerySource() {
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource result =
          com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
              .forNumber(querySource_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatorName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, generatorName_);
      }
      if (querySource_
          != com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
              .QUERY_SOURCE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, querySource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(generatorName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, generatorName_);
      }
      if (querySource_
          != com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
              .QUERY_SOURCE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, querySource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput other =
          (com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput) obj;

      if (!getQuery().equals(other.getQuery())) return false;
      if (!getGeneratorName().equals(other.getGeneratorName())) return false;
      if (querySource_ != other.querySource_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getQuery().hashCode();
      hash = (37 * hash) + GENERATOR_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getGeneratorName().hashCode();
      hash = (37 * hash) + QUERY_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + querySource_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_UserInput_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_UserInput_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.class,
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        query_ = "";
        generatorName_ = "";
        querySource_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_UserInput_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput build() {
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput buildPartial() {
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput result =
            new com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.query_ = query_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.generatorName_ = generatorName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.querySource_ = querySource_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
                .getDefaultInstance()) return this;
        if (!other.getQuery().isEmpty()) {
          query_ = other.query_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getGeneratorName().isEmpty()) {
          generatorName_ = other.generatorName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.querySource_ != 0) {
          setQuerySourceValue(other.getQuerySourceValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  query_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  generatorName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  querySource_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object query_ = "";
      /**
       *
       *
       * <pre>
       * Query text. Article Search uses this to store the input query used
       * to generate the search results.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The query.
       */
      public java.lang.String getQuery() {
        java.lang.Object ref = query_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          query_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Query text. Article Search uses this to store the input query used
       * to generate the search results.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return The bytes for query.
       */
      public com.google.protobuf.ByteString getQueryBytes() {
        java.lang.Object ref = query_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          query_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Query text. Article Search uses this to store the input query used
       * to generate the search results.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @param value The query to set.
       * @return This builder for chaining.
       */
      public Builder setQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        query_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query text. Article Search uses this to store the input query used
       * to generate the search results.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuery() {
        query_ = getDefaultInstance().getQuery();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query text. Article Search uses this to store the input query used
       * to generate the search results.
       * </pre>
       *
       * <code>string query = 1;</code>
       *
       * @param value The bytes for query to set.
       * @return This builder for chaining.
       */
      public Builder setQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        query_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object generatorName_ = "";
      /**
       *
       *
       * <pre>
       * The resource name of associated generator. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
       * </pre>
       *
       * <code>string generator_name = 2;</code>
       *
       * @return The generatorName.
       */
      public java.lang.String getGeneratorName() {
        java.lang.Object ref = generatorName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          generatorName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of associated generator. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
       * </pre>
       *
       * <code>string generator_name = 2;</code>
       *
       * @return The bytes for generatorName.
       */
      public com.google.protobuf.ByteString getGeneratorNameBytes() {
        java.lang.Object ref = generatorName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          generatorName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The resource name of associated generator. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
       * </pre>
       *
       * <code>string generator_name = 2;</code>
       *
       * @param value The generatorName to set.
       * @return This builder for chaining.
       */
      public Builder setGeneratorName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        generatorName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of associated generator. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
       * </pre>
       *
       * <code>string generator_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGeneratorName() {
        generatorName_ = getDefaultInstance().getGeneratorName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The resource name of associated generator. Format:
       * `projects/&lt;Project ID&gt;/locations/&lt;Location ID&gt;/generators/&lt;Generator ID&gt;`
       * </pre>
       *
       * <code>string generator_name = 2;</code>
       *
       * @param value The bytes for generatorName to set.
       * @return This builder for chaining.
       */
      public Builder setGeneratorNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        generatorName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private int querySource_ = 0;
      /**
       *
       *
       * <pre>
       * Query source for the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for querySource.
       */
      @java.lang.Override
      public int getQuerySourceValue() {
        return querySource_;
      }
      /**
       *
       *
       * <pre>
       * Query source for the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for querySource to set.
       * @return This builder for chaining.
       */
      public Builder setQuerySourceValue(int value) {
        querySource_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query source for the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
       * </code>
       *
       * @return The querySource.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
          getQuerySource() {
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource result =
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
                .forNumber(querySource_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Query source for the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
       * </code>
       *
       * @param value The querySource to set.
       * @return This builder for chaining.
       */
      public Builder setQuerySource(
          com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        querySource_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Query source for the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.QuerySource query_source = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuerySource() {
        bitField0_ = (bitField0_ & ~0x00000004);
        querySource_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput)
    private static final com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput();
    }

    public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UserInput> PARSER =
        new com.google.protobuf.AbstractParser<UserInput>() {
          @java.lang.Override
          public UserInput parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UserInput> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UserInput> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ARTICLE_SUGGESTION(6),
    FAQ_ANSWER(7),
    SMART_REPLY(8),
    SMART_COMPOSE_SUGGESTION(9),
    DIALOGFLOW_INTERACTION(10),
    CONVERSATION_SUMMARIZATION_SUGGESTION(12),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 6:
          return ARTICLE_SUGGESTION;
        case 7:
          return FAQ_ANSWER;
        case 8:
          return SMART_REPLY;
        case 9:
          return SMART_COMPOSE_SUGGESTION;
        case 10:
          return DIALOGFLOW_INTERACTION;
        case 12:
          return CONVERSATION_SUMMARIZATION_SUGGESTION;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int ARTICLE_SUGGESTION_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Agent Assist Article Suggestion data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
   * </code>
   *
   * @return Whether the articleSuggestion field is set.
   */
  @java.lang.Override
  public boolean hasArticleSuggestion() {
    return dataCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Article Suggestion data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
   * </code>
   *
   * @return The articleSuggestion.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData getArticleSuggestion() {
    if (dataCase_ == 6) {
      return (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Article Suggestion data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ArticleSuggestionDataOrBuilder
      getArticleSuggestionOrBuilder() {
    if (dataCase_ == 6) {
      return (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
  }

  public static final int FAQ_ANSWER_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Agent Assist FAQ answer data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
   *
   * @return Whether the faqAnswer field is set.
   */
  @java.lang.Override
  public boolean hasFaqAnswer() {
    return dataCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Agent Assist FAQ answer data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
   *
   * @return The faqAnswer.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.FaqAnswerData getFaqAnswer() {
    if (dataCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Agent Assist FAQ answer data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder getFaqAnswerOrBuilder() {
    if (dataCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
  }

  public static final int SMART_REPLY_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Reply data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
   *
   * @return Whether the smartReply field is set.
   */
  @java.lang.Override
  public boolean hasSmartReply() {
    return dataCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Reply data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
   *
   * @return The smartReply.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SmartReplyData getSmartReply() {
    if (dataCase_ == 8) {
      return (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Reply data.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SmartReplyDataOrBuilder
      getSmartReplyOrBuilder() {
    if (dataCase_ == 8) {
      return (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
  }

  public static final int SMART_COMPOSE_SUGGESTION_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Compose suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
   * </code>
   *
   * @return Whether the smartComposeSuggestion field is set.
   */
  @java.lang.Override
  public boolean hasSmartComposeSuggestion() {
    return dataCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Compose suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
   * </code>
   *
   * @return The smartComposeSuggestion.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
      getSmartComposeSuggestion() {
    if (dataCase_ == 9) {
      return (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Agent Assist Smart Compose suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionDataOrBuilder
      getSmartComposeSuggestionOrBuilder() {
    if (dataCase_ == 9) {
      return (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
        .getDefaultInstance();
  }

  public static final int DIALOGFLOW_INTERACTION_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Dialogflow interaction data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
   * </code>
   *
   * @return Whether the dialogflowInteraction field is set.
   */
  @java.lang.Override
  public boolean hasDialogflowInteraction() {
    return dataCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Dialogflow interaction data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
   * </code>
   *
   * @return The dialogflowInteraction.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
      getDialogflowInteraction() {
    if (dataCase_ == 10) {
      return (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Dialogflow interaction data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.DialogflowInteractionDataOrBuilder
      getDialogflowInteractionOrBuilder() {
    if (dataCase_ == 10) {
      return (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.getDefaultInstance();
  }

  public static final int CONVERSATION_SUMMARIZATION_SUGGESTION_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Conversation summarization suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
   * </code>
   *
   * @return Whether the conversationSummarizationSuggestion field is set.
   */
  @java.lang.Override
  public boolean hasConversationSummarizationSuggestion() {
    return dataCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Conversation summarization suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
   * </code>
   *
   * @return The conversationSummarizationSuggestion.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
      getConversationSummarizationSuggestion() {
    if (dataCase_ == 12) {
      return (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
          data_;
    }
    return com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Conversation summarization suggestion data.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionDataOrBuilder
      getConversationSummarizationSuggestionOrBuilder() {
    if (dataCase_ == 12) {
      return (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
          data_;
    }
    return com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
        .getDefaultInstance();
  }

  public static final int ANNOTATION_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object annotationId_ = "";
  /**
   *
   *
   * <pre>
   * The unique identifier of the annotation.
   * Format:
   * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
   * </pre>
   *
   * <code>string annotation_id = 1;</code>
   *
   * @return The annotationId.
   */
  @java.lang.Override
  public java.lang.String getAnnotationId() {
    java.lang.Object ref = annotationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The unique identifier of the annotation.
   * Format:
   * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
   * </pre>
   *
   * <code>string annotation_id = 1;</code>
   *
   * @return The bytes for annotationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAnnotationIdBytes() {
    java.lang.Object ref = annotationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time at which this annotation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time at which this annotation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which this annotation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_BOUNDARY_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary startBoundary_;
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
   *
   * @return Whether the startBoundary field is set.
   */
  @java.lang.Override
  public boolean hasStartBoundary() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
   *
   * @return The startBoundary.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getStartBoundary() {
    return startBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : startBoundary_;
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
      getStartBoundaryOrBuilder() {
    return startBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : startBoundary_;
  }

  public static final int END_BOUNDARY_FIELD_NUMBER = 4;
  private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary endBoundary_;
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
   *
   * @return Whether the endBoundary field is set.
   */
  @java.lang.Override
  public boolean hasEndBoundary() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
   *
   * @return The endBoundary.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getEndBoundary() {
    return endBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : endBoundary_;
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
      getEndBoundaryOrBuilder() {
    return endBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : endBoundary_;
  }

  public static final int ANSWER_FEEDBACK_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.AnswerFeedback answerFeedback_;
  /**
   *
   *
   * <pre>
   * The feedback that the customer has about the answer in `data`.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
   *
   * @return Whether the answerFeedback field is set.
   */
  @java.lang.Override
  public boolean hasAnswerFeedback() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The feedback that the customer has about the answer in `data`.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
   *
   * @return The answerFeedback.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnswerFeedback getAnswerFeedback() {
    return answerFeedback_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnswerFeedback.getDefaultInstance()
        : answerFeedback_;
  }
  /**
   *
   *
   * <pre>
   * The feedback that the customer has about the answer in `data`.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnswerFeedbackOrBuilder
      getAnswerFeedbackOrBuilder() {
    return answerFeedback_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnswerFeedback.getDefaultInstance()
        : answerFeedback_;
  }

  public static final int USER_INPUT_FIELD_NUMBER = 16;
  private com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput userInput_;
  /**
   *
   *
   * <pre>
   * Explicit input used for generating the answer
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
   * </code>
   *
   * @return Whether the userInput field is set.
   */
  @java.lang.Override
  public boolean hasUserInput() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Explicit input used for generating the answer
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
   * </code>
   *
   * @return The userInput.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput getUserInput() {
    return userInput_ == null
        ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.getDefaultInstance()
        : userInput_;
  }
  /**
   *
   *
   * <pre>
   * Explicit input used for generating the answer
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder
      getUserInputOrBuilder() {
    return userInput_ == null
        ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.getDefaultInstance()
        : userInput_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getStartBoundary());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getEndBoundary());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getAnswerFeedback());
    }
    if (dataCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_);
    }
    if (dataCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_);
    }
    if (dataCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_);
    }
    if (dataCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_);
    }
    if (dataCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_);
    }
    if (dataCase_ == 12) {
      output.writeMessage(
          12,
          (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
              data_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(16, getUserInput());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotationId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStartBoundary());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getEndBoundary());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAnswerFeedback());
    }
    if (dataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_);
    }
    if (dataCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_);
    }
    if (dataCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_);
    }
    if (dataCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_);
    }
    if (dataCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_);
    }
    if (dataCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12,
              (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
                  data_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getUserInput());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation other =
        (com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation) obj;

    if (!getAnnotationId().equals(other.getAnnotationId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartBoundary() != other.hasStartBoundary()) return false;
    if (hasStartBoundary()) {
      if (!getStartBoundary().equals(other.getStartBoundary())) return false;
    }
    if (hasEndBoundary() != other.hasEndBoundary()) return false;
    if (hasEndBoundary()) {
      if (!getEndBoundary().equals(other.getEndBoundary())) return false;
    }
    if (hasAnswerFeedback() != other.hasAnswerFeedback()) return false;
    if (hasAnswerFeedback()) {
      if (!getAnswerFeedback().equals(other.getAnswerFeedback())) return false;
    }
    if (hasUserInput() != other.hasUserInput()) return false;
    if (hasUserInput()) {
      if (!getUserInput().equals(other.getUserInput())) return false;
    }
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 6:
        if (!getArticleSuggestion().equals(other.getArticleSuggestion())) return false;
        break;
      case 7:
        if (!getFaqAnswer().equals(other.getFaqAnswer())) return false;
        break;
      case 8:
        if (!getSmartReply().equals(other.getSmartReply())) return false;
        break;
      case 9:
        if (!getSmartComposeSuggestion().equals(other.getSmartComposeSuggestion())) return false;
        break;
      case 10:
        if (!getDialogflowInteraction().equals(other.getDialogflowInteraction())) return false;
        break;
      case 12:
        if (!getConversationSummarizationSuggestion()
            .equals(other.getConversationSummarizationSuggestion())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ANNOTATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartBoundary()) {
      hash = (37 * hash) + START_BOUNDARY_FIELD_NUMBER;
      hash = (53 * hash) + getStartBoundary().hashCode();
    }
    if (hasEndBoundary()) {
      hash = (37 * hash) + END_BOUNDARY_FIELD_NUMBER;
      hash = (53 * hash) + getEndBoundary().hashCode();
    }
    if (hasAnswerFeedback()) {
      hash = (37 * hash) + ANSWER_FEEDBACK_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerFeedback().hashCode();
    }
    if (hasUserInput()) {
      hash = (37 * hash) + USER_INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getUserInput().hashCode();
    }
    switch (dataCase_) {
      case 6:
        hash = (37 * hash) + ARTICLE_SUGGESTION_FIELD_NUMBER;
        hash = (53 * hash) + getArticleSuggestion().hashCode();
        break;
      case 7:
        hash = (37 * hash) + FAQ_ANSWER_FIELD_NUMBER;
        hash = (53 * hash) + getFaqAnswer().hashCode();
        break;
      case 8:
        hash = (37 * hash) + SMART_REPLY_FIELD_NUMBER;
        hash = (53 * hash) + getSmartReply().hashCode();
        break;
      case 9:
        hash = (37 * hash) + SMART_COMPOSE_SUGGESTION_FIELD_NUMBER;
        hash = (53 * hash) + getSmartComposeSuggestion().hashCode();
        break;
      case 10:
        hash = (37 * hash) + DIALOGFLOW_INTERACTION_FIELD_NUMBER;
        hash = (53 * hash) + getDialogflowInteraction().hashCode();
        break;
      case 12:
        hash = (37 * hash) + CONVERSATION_SUMMARIZATION_SUGGESTION_FIELD_NUMBER;
        hash = (53 * hash) + getConversationSummarizationSuggestion().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An annotation that was generated during the customer and agent interaction.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.RuntimeAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.RuntimeAnnotation)
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.class,
              com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getStartBoundaryFieldBuilder();
        getEndBoundaryFieldBuilder();
        getAnswerFeedbackFieldBuilder();
        getUserInputFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (articleSuggestionBuilder_ != null) {
        articleSuggestionBuilder_.clear();
      }
      if (faqAnswerBuilder_ != null) {
        faqAnswerBuilder_.clear();
      }
      if (smartReplyBuilder_ != null) {
        smartReplyBuilder_.clear();
      }
      if (smartComposeSuggestionBuilder_ != null) {
        smartComposeSuggestionBuilder_.clear();
      }
      if (dialogflowInteractionBuilder_ != null) {
        dialogflowInteractionBuilder_.clear();
      }
      if (conversationSummarizationSuggestionBuilder_ != null) {
        conversationSummarizationSuggestionBuilder_.clear();
      }
      annotationId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startBoundary_ = null;
      if (startBoundaryBuilder_ != null) {
        startBoundaryBuilder_.dispose();
        startBoundaryBuilder_ = null;
      }
      endBoundary_ = null;
      if (endBoundaryBuilder_ != null) {
        endBoundaryBuilder_.dispose();
        endBoundaryBuilder_ = null;
      }
      answerFeedback_ = null;
      if (answerFeedbackBuilder_ != null) {
        answerFeedbackBuilder_.dispose();
        answerFeedbackBuilder_ = null;
      }
      userInput_ = null;
      if (userInputBuilder_ != null) {
        userInputBuilder_.dispose();
        userInputBuilder_ = null;
      }
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_RuntimeAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation build() {
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation buildPartial() {
      com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation result =
          new com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.annotationId_ = annotationId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.startBoundary_ =
            startBoundaryBuilder_ == null ? startBoundary_ : startBoundaryBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.endBoundary_ =
            endBoundaryBuilder_ == null ? endBoundary_ : endBoundaryBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.answerFeedback_ =
            answerFeedbackBuilder_ == null ? answerFeedback_ : answerFeedbackBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.userInput_ = userInputBuilder_ == null ? userInput_ : userInputBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 6 && articleSuggestionBuilder_ != null) {
        result.data_ = articleSuggestionBuilder_.build();
      }
      if (dataCase_ == 7 && faqAnswerBuilder_ != null) {
        result.data_ = faqAnswerBuilder_.build();
      }
      if (dataCase_ == 8 && smartReplyBuilder_ != null) {
        result.data_ = smartReplyBuilder_.build();
      }
      if (dataCase_ == 9 && smartComposeSuggestionBuilder_ != null) {
        result.data_ = smartComposeSuggestionBuilder_.build();
      }
      if (dataCase_ == 10 && dialogflowInteractionBuilder_ != null) {
        result.data_ = dialogflowInteractionBuilder_.build();
      }
      if (dataCase_ == 12 && conversationSummarizationSuggestionBuilder_ != null) {
        result.data_ = conversationSummarizationSuggestionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation other) {
      if (other == com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.getDefaultInstance())
        return this;
      if (!other.getAnnotationId().isEmpty()) {
        annotationId_ = other.annotationId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartBoundary()) {
        mergeStartBoundary(other.getStartBoundary());
      }
      if (other.hasEndBoundary()) {
        mergeEndBoundary(other.getEndBoundary());
      }
      if (other.hasAnswerFeedback()) {
        mergeAnswerFeedback(other.getAnswerFeedback());
      }
      if (other.hasUserInput()) {
        mergeUserInput(other.getUserInput());
      }
      switch (other.getDataCase()) {
        case ARTICLE_SUGGESTION:
          {
            mergeArticleSuggestion(other.getArticleSuggestion());
            break;
          }
        case FAQ_ANSWER:
          {
            mergeFaqAnswer(other.getFaqAnswer());
            break;
          }
        case SMART_REPLY:
          {
            mergeSmartReply(other.getSmartReply());
            break;
          }
        case SMART_COMPOSE_SUGGESTION:
          {
            mergeSmartComposeSuggestion(other.getSmartComposeSuggestion());
            break;
          }
        case DIALOGFLOW_INTERACTION:
          {
            mergeDialogflowInteraction(other.getDialogflowInteraction());
            break;
          }
        case CONVERSATION_SUMMARIZATION_SUGGESTION:
          {
            mergeConversationSummarizationSuggestion(
                other.getConversationSummarizationSuggestion());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                annotationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStartBoundaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getEndBoundaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAnswerFeedbackFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getArticleSuggestionFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getFaqAnswerFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSmartReplyFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getSmartComposeSuggestionFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getDialogflowInteractionFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 10;
                break;
              } // case 82
            case 98:
              {
                input.readMessage(
                    getConversationSummarizationSuggestionFieldBuilder().getBuilder(),
                    extensionRegistry);
                dataCase_ = 12;
                break;
              } // case 98
            case 130:
              {
                input.readMessage(getUserInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 130
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.Builder,
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionDataOrBuilder>
        articleSuggestionBuilder_;
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     *
     * @return Whether the articleSuggestion field is set.
     */
    @java.lang.Override
    public boolean hasArticleSuggestion() {
      return dataCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     *
     * @return The articleSuggestion.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData getArticleSuggestion() {
      if (articleSuggestionBuilder_ == null) {
        if (dataCase_ == 6) {
          return (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
      } else {
        if (dataCase_ == 6) {
          return articleSuggestionBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    public Builder setArticleSuggestion(
        com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData value) {
      if (articleSuggestionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        articleSuggestionBuilder_.setMessage(value);
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    public Builder setArticleSuggestion(
        com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.Builder builderForValue) {
      if (articleSuggestionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        articleSuggestionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    public Builder mergeArticleSuggestion(
        com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData value) {
      if (articleSuggestionBuilder_ == null) {
        if (dataCase_ == 6
            && data_
                != com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 6) {
          articleSuggestionBuilder_.mergeFrom(value);
        } else {
          articleSuggestionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    public Builder clearArticleSuggestion() {
      if (articleSuggestionBuilder_ == null) {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 6) {
          dataCase_ = 0;
          data_ = null;
        }
        articleSuggestionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.Builder
        getArticleSuggestionBuilder() {
      return getArticleSuggestionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ArticleSuggestionDataOrBuilder
        getArticleSuggestionOrBuilder() {
      if ((dataCase_ == 6) && (articleSuggestionBuilder_ != null)) {
        return articleSuggestionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 6) {
          return (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Article Suggestion data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ArticleSuggestionData article_suggestion = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.Builder,
            com.google.cloud.contactcenterinsights.v1.ArticleSuggestionDataOrBuilder>
        getArticleSuggestionFieldBuilder() {
      if (articleSuggestionBuilder_ == null) {
        if (!(dataCase_ == 6)) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.getDefaultInstance();
        }
        articleSuggestionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData,
                com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData.Builder,
                com.google.cloud.contactcenterinsights.v1.ArticleSuggestionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.ArticleSuggestionData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 6;
      onChanged();
      return articleSuggestionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData,
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder,
            com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder>
        faqAnswerBuilder_;
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     *
     * @return Whether the faqAnswer field is set.
     */
    @java.lang.Override
    public boolean hasFaqAnswer() {
      return dataCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     *
     * @return The faqAnswer.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerData getFaqAnswer() {
      if (faqAnswerBuilder_ == null) {
        if (dataCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
      } else {
        if (dataCase_ == 7) {
          return faqAnswerBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    public Builder setFaqAnswer(com.google.cloud.contactcenterinsights.v1.FaqAnswerData value) {
      if (faqAnswerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        faqAnswerBuilder_.setMessage(value);
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    public Builder setFaqAnswer(
        com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder builderForValue) {
      if (faqAnswerBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        faqAnswerBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    public Builder mergeFaqAnswer(com.google.cloud.contactcenterinsights.v1.FaqAnswerData value) {
      if (faqAnswerBuilder_ == null) {
        if (dataCase_ == 7
            && data_
                != com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.FaqAnswerData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 7) {
          faqAnswerBuilder_.mergeFrom(value);
        } else {
          faqAnswerBuilder_.setMessage(value);
        }
      }
      dataCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    public Builder clearFaqAnswer() {
      if (faqAnswerBuilder_ == null) {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
        }
        faqAnswerBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder getFaqAnswerBuilder() {
      return getFaqAnswerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder
        getFaqAnswerOrBuilder() {
      if ((dataCase_ == 7) && (faqAnswerBuilder_ != null)) {
        return faqAnswerBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist FAQ answer data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.FaqAnswerData faq_answer = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData,
            com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder,
            com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder>
        getFaqAnswerFieldBuilder() {
      if (faqAnswerBuilder_ == null) {
        if (!(dataCase_ == 7)) {
          data_ = com.google.cloud.contactcenterinsights.v1.FaqAnswerData.getDefaultInstance();
        }
        faqAnswerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.FaqAnswerData,
                com.google.cloud.contactcenterinsights.v1.FaqAnswerData.Builder,
                com.google.cloud.contactcenterinsights.v1.FaqAnswerDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.FaqAnswerData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 7;
      onChanged();
      return faqAnswerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SmartReplyData,
            com.google.cloud.contactcenterinsights.v1.SmartReplyData.Builder,
            com.google.cloud.contactcenterinsights.v1.SmartReplyDataOrBuilder>
        smartReplyBuilder_;
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     *
     * @return Whether the smartReply field is set.
     */
    @java.lang.Override
    public boolean hasSmartReply() {
      return dataCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     *
     * @return The smartReply.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SmartReplyData getSmartReply() {
      if (smartReplyBuilder_ == null) {
        if (dataCase_ == 8) {
          return (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
      } else {
        if (dataCase_ == 8) {
          return smartReplyBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    public Builder setSmartReply(com.google.cloud.contactcenterinsights.v1.SmartReplyData value) {
      if (smartReplyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        smartReplyBuilder_.setMessage(value);
      }
      dataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    public Builder setSmartReply(
        com.google.cloud.contactcenterinsights.v1.SmartReplyData.Builder builderForValue) {
      if (smartReplyBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        smartReplyBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    public Builder mergeSmartReply(com.google.cloud.contactcenterinsights.v1.SmartReplyData value) {
      if (smartReplyBuilder_ == null) {
        if (dataCase_ == 8
            && data_
                != com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.SmartReplyData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 8) {
          smartReplyBuilder_.mergeFrom(value);
        } else {
          smartReplyBuilder_.setMessage(value);
        }
      }
      dataCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    public Builder clearSmartReply() {
      if (smartReplyBuilder_ == null) {
        if (dataCase_ == 8) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 8) {
          dataCase_ = 0;
          data_ = null;
        }
        smartReplyBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.SmartReplyData.Builder getSmartReplyBuilder() {
      return getSmartReplyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SmartReplyDataOrBuilder
        getSmartReplyOrBuilder() {
      if ((dataCase_ == 8) && (smartReplyBuilder_ != null)) {
        return smartReplyBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 8) {
          return (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Reply data.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SmartReplyData smart_reply = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SmartReplyData,
            com.google.cloud.contactcenterinsights.v1.SmartReplyData.Builder,
            com.google.cloud.contactcenterinsights.v1.SmartReplyDataOrBuilder>
        getSmartReplyFieldBuilder() {
      if (smartReplyBuilder_ == null) {
        if (!(dataCase_ == 8)) {
          data_ = com.google.cloud.contactcenterinsights.v1.SmartReplyData.getDefaultInstance();
        }
        smartReplyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SmartReplyData,
                com.google.cloud.contactcenterinsights.v1.SmartReplyData.Builder,
                com.google.cloud.contactcenterinsights.v1.SmartReplyDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.SmartReplyData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 8;
      onChanged();
      return smartReplyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData,
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.Builder,
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionDataOrBuilder>
        smartComposeSuggestionBuilder_;
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     *
     * @return Whether the smartComposeSuggestion field is set.
     */
    @java.lang.Override
    public boolean hasSmartComposeSuggestion() {
      return dataCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     *
     * @return The smartComposeSuggestion.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
        getSmartComposeSuggestion() {
      if (smartComposeSuggestionBuilder_ == null) {
        if (dataCase_ == 9) {
          return (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
            .getDefaultInstance();
      } else {
        if (dataCase_ == 9) {
          return smartComposeSuggestionBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    public Builder setSmartComposeSuggestion(
        com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData value) {
      if (smartComposeSuggestionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        smartComposeSuggestionBuilder_.setMessage(value);
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    public Builder setSmartComposeSuggestion(
        com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.Builder
            builderForValue) {
      if (smartComposeSuggestionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        smartComposeSuggestionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    public Builder mergeSmartComposeSuggestion(
        com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData value) {
      if (smartComposeSuggestionBuilder_ == null) {
        if (dataCase_ == 9
            && data_
                != com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 9) {
          smartComposeSuggestionBuilder_.mergeFrom(value);
        } else {
          smartComposeSuggestionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    public Builder clearSmartComposeSuggestion() {
      if (smartComposeSuggestionBuilder_ == null) {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
        }
        smartComposeSuggestionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.Builder
        getSmartComposeSuggestionBuilder() {
      return getSmartComposeSuggestionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionDataOrBuilder
        getSmartComposeSuggestionOrBuilder() {
      if ((dataCase_ == 9) && (smartComposeSuggestionBuilder_ != null)) {
        return smartComposeSuggestionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 9) {
          return (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Agent Assist Smart Compose suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData smart_compose_suggestion = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData,
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.Builder,
            com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionDataOrBuilder>
        getSmartComposeSuggestionFieldBuilder() {
      if (smartComposeSuggestionBuilder_ == null) {
        if (!(dataCase_ == 9)) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData
                  .getDefaultInstance();
        }
        smartComposeSuggestionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData,
                com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData.Builder,
                com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.SmartComposeSuggestionData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 9;
      onChanged();
      return smartComposeSuggestionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData,
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.Builder,
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionDataOrBuilder>
        dialogflowInteractionBuilder_;
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     *
     * @return Whether the dialogflowInteraction field is set.
     */
    @java.lang.Override
    public boolean hasDialogflowInteraction() {
      return dataCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     *
     * @return The dialogflowInteraction.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
        getDialogflowInteraction() {
      if (dialogflowInteractionBuilder_ == null) {
        if (dataCase_ == 10) {
          return (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
            .getDefaultInstance();
      } else {
        if (dataCase_ == 10) {
          return dialogflowInteractionBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    public Builder setDialogflowInteraction(
        com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData value) {
      if (dialogflowInteractionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        dialogflowInteractionBuilder_.setMessage(value);
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    public Builder setDialogflowInteraction(
        com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.Builder
            builderForValue) {
      if (dialogflowInteractionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        dialogflowInteractionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    public Builder mergeDialogflowInteraction(
        com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData value) {
      if (dialogflowInteractionBuilder_ == null) {
        if (dataCase_ == 10
            && data_
                != com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 10) {
          dialogflowInteractionBuilder_.mergeFrom(value);
        } else {
          dialogflowInteractionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    public Builder clearDialogflowInteraction() {
      if (dialogflowInteractionBuilder_ == null) {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
        }
        dialogflowInteractionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.Builder
        getDialogflowInteractionBuilder() {
      return getDialogflowInteractionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DialogflowInteractionDataOrBuilder
        getDialogflowInteractionOrBuilder() {
      if ((dataCase_ == 10) && (dialogflowInteractionBuilder_ != null)) {
        return dialogflowInteractionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 10) {
          return (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Dialogflow interaction data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.DialogflowInteractionData dialogflow_interaction = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData,
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.Builder,
            com.google.cloud.contactcenterinsights.v1.DialogflowInteractionDataOrBuilder>
        getDialogflowInteractionFieldBuilder() {
      if (dialogflowInteractionBuilder_ == null) {
        if (!(dataCase_ == 10)) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData
                  .getDefaultInstance();
        }
        dialogflowInteractionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData,
                com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData.Builder,
                com.google.cloud.contactcenterinsights.v1.DialogflowInteractionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.DialogflowInteractionData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 10;
      onChanged();
      return dialogflowInteractionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .Builder,
            com.google.cloud.contactcenterinsights.v1
                .ConversationSummarizationSuggestionDataOrBuilder>
        conversationSummarizationSuggestionBuilder_;
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     *
     * @return Whether the conversationSummarizationSuggestion field is set.
     */
    @java.lang.Override
    public boolean hasConversationSummarizationSuggestion() {
      return dataCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     *
     * @return The conversationSummarizationSuggestion.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
        getConversationSummarizationSuggestion() {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        if (dataCase_ == 12) {
          return (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
              data_;
        }
        return com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
            .getDefaultInstance();
      } else {
        if (dataCase_ == 12) {
          return conversationSummarizationSuggestionBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    public Builder setConversationSummarizationSuggestion(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData value) {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        conversationSummarizationSuggestionBuilder_.setMessage(value);
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    public Builder setConversationSummarizationSuggestion(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData.Builder
            builderForValue) {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        conversationSummarizationSuggestionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    public Builder mergeConversationSummarizationSuggestion(
        com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData value) {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        if (dataCase_ == 12
            && data_
                != com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1
                              .ConversationSummarizationSuggestionData)
                          data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 12) {
          conversationSummarizationSuggestionBuilder_.mergeFrom(value);
        } else {
          conversationSummarizationSuggestionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    public Builder clearConversationSummarizationSuggestion() {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        if (dataCase_ == 12) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 12) {
          dataCase_ = 0;
          data_ = null;
        }
        conversationSummarizationSuggestionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData.Builder
        getConversationSummarizationSuggestionBuilder() {
      return getConversationSummarizationSuggestionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1
            .ConversationSummarizationSuggestionDataOrBuilder
        getConversationSummarizationSuggestionOrBuilder() {
      if ((dataCase_ == 12) && (conversationSummarizationSuggestionBuilder_ != null)) {
        return conversationSummarizationSuggestionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 12) {
          return (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
              data_;
        }
        return com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Conversation summarization suggestion data.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData conversation_summarization_suggestion = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
            com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                .Builder,
            com.google.cloud.contactcenterinsights.v1
                .ConversationSummarizationSuggestionDataOrBuilder>
        getConversationSummarizationSuggestionFieldBuilder() {
      if (conversationSummarizationSuggestionBuilder_ == null) {
        if (!(dataCase_ == 12)) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                  .getDefaultInstance();
        }
        conversationSummarizationSuggestionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData,
                com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData
                    .Builder,
                com.google.cloud.contactcenterinsights.v1
                    .ConversationSummarizationSuggestionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.ConversationSummarizationSuggestionData)
                    data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 12;
      onChanged();
      return conversationSummarizationSuggestionBuilder_;
    }

    private java.lang.Object annotationId_ = "";
    /**
     *
     *
     * <pre>
     * The unique identifier of the annotation.
     * Format:
     * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
     * </pre>
     *
     * <code>string annotation_id = 1;</code>
     *
     * @return The annotationId.
     */
    public java.lang.String getAnnotationId() {
      java.lang.Object ref = annotationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the annotation.
     * Format:
     * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
     * </pre>
     *
     * <code>string annotation_id = 1;</code>
     *
     * @return The bytes for annotationId.
     */
    public com.google.protobuf.ByteString getAnnotationIdBytes() {
      java.lang.Object ref = annotationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the annotation.
     * Format:
     * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
     * </pre>
     *
     * <code>string annotation_id = 1;</code>
     *
     * @param value The annotationId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      annotationId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the annotation.
     * Format:
     * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
     * </pre>
     *
     * <code>string annotation_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationId() {
      annotationId_ = getDefaultInstance().getAnnotationId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The unique identifier of the annotation.
     * Format:
     * projects/{project}/locations/{location}/conversationDatasets/{dataset}/conversationDataItems/{data_item}/conversationAnnotations/{annotation}
     * </pre>
     *
     * <code>string annotation_id = 1;</code>
     *
     * @param value The bytes for annotationId to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      annotationId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which this annotation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary startBoundary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        startBoundaryBuilder_;
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     *
     * @return Whether the startBoundary field is set.
     */
    public boolean hasStartBoundary() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     *
     * @return The startBoundary.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getStartBoundary() {
      if (startBoundaryBuilder_ == null) {
        return startBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : startBoundary_;
      } else {
        return startBoundaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public Builder setStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (startBoundaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startBoundary_ = value;
      } else {
        startBoundaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public Builder setStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder builderForValue) {
      if (startBoundaryBuilder_ == null) {
        startBoundary_ = builderForValue.build();
      } else {
        startBoundaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public Builder mergeStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (startBoundaryBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && startBoundary_ != null
            && startBoundary_
                != com.google.cloud.contactcenterinsights.v1.AnnotationBoundary
                    .getDefaultInstance()) {
          getStartBoundaryBuilder().mergeFrom(value);
        } else {
          startBoundary_ = value;
        }
      } else {
        startBoundaryBuilder_.mergeFrom(value);
      }
      if (startBoundary_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public Builder clearStartBoundary() {
      bitField0_ = (bitField0_ & ~0x00000100);
      startBoundary_ = null;
      if (startBoundaryBuilder_ != null) {
        startBoundaryBuilder_.dispose();
        startBoundaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder
        getStartBoundaryBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStartBoundaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
        getStartBoundaryOrBuilder() {
      if (startBoundaryBuilder_ != null) {
        return startBoundaryBuilder_.getMessageOrBuilder();
      } else {
        return startBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : startBoundary_;
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary start_boundary = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        getStartBoundaryFieldBuilder() {
      if (startBoundaryBuilder_ == null) {
        startBoundaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>(
                getStartBoundary(), getParentForChildren(), isClean());
        startBoundary_ = null;
      }
      return startBoundaryBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary endBoundary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        endBoundaryBuilder_;
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     *
     * @return Whether the endBoundary field is set.
     */
    public boolean hasEndBoundary() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     *
     * @return The endBoundary.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getEndBoundary() {
      if (endBoundaryBuilder_ == null) {
        return endBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : endBoundary_;
      } else {
        return endBoundaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public Builder setEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (endBoundaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endBoundary_ = value;
      } else {
        endBoundaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public Builder setEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder builderForValue) {
      if (endBoundaryBuilder_ == null) {
        endBoundary_ = builderForValue.build();
      } else {
        endBoundaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public Builder mergeEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (endBoundaryBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && endBoundary_ != null
            && endBoundary_
                != com.google.cloud.contactcenterinsights.v1.AnnotationBoundary
                    .getDefaultInstance()) {
          getEndBoundaryBuilder().mergeFrom(value);
        } else {
          endBoundary_ = value;
        }
      } else {
        endBoundaryBuilder_.mergeFrom(value);
      }
      if (endBoundary_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public Builder clearEndBoundary() {
      bitField0_ = (bitField0_ & ~0x00000200);
      endBoundary_ = null;
      if (endBoundaryBuilder_ != null) {
        endBoundaryBuilder_.dispose();
        endBoundaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder
        getEndBoundaryBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getEndBoundaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
        getEndBoundaryOrBuilder() {
      if (endBoundaryBuilder_ != null) {
        return endBoundaryBuilder_.getMessageOrBuilder();
      } else {
        return endBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : endBoundary_;
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary end_boundary = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        getEndBoundaryFieldBuilder() {
      if (endBoundaryBuilder_ == null) {
        endBoundaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>(
                getEndBoundary(), getParentForChildren(), isClean());
        endBoundary_ = null;
      }
      return endBoundaryBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnswerFeedback answerFeedback_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnswerFeedback,
            com.google.cloud.contactcenterinsights.v1.AnswerFeedback.Builder,
            com.google.cloud.contactcenterinsights.v1.AnswerFeedbackOrBuilder>
        answerFeedbackBuilder_;
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     *
     * @return Whether the answerFeedback field is set.
     */
    public boolean hasAnswerFeedback() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     *
     * @return The answerFeedback.
     */
    public com.google.cloud.contactcenterinsights.v1.AnswerFeedback getAnswerFeedback() {
      if (answerFeedbackBuilder_ == null) {
        return answerFeedback_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnswerFeedback.getDefaultInstance()
            : answerFeedback_;
      } else {
        return answerFeedbackBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public Builder setAnswerFeedback(
        com.google.cloud.contactcenterinsights.v1.AnswerFeedback value) {
      if (answerFeedbackBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerFeedback_ = value;
      } else {
        answerFeedbackBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public Builder setAnswerFeedback(
        com.google.cloud.contactcenterinsights.v1.AnswerFeedback.Builder builderForValue) {
      if (answerFeedbackBuilder_ == null) {
        answerFeedback_ = builderForValue.build();
      } else {
        answerFeedbackBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public Builder mergeAnswerFeedback(
        com.google.cloud.contactcenterinsights.v1.AnswerFeedback value) {
      if (answerFeedbackBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && answerFeedback_ != null
            && answerFeedback_
                != com.google.cloud.contactcenterinsights.v1.AnswerFeedback.getDefaultInstance()) {
          getAnswerFeedbackBuilder().mergeFrom(value);
        } else {
          answerFeedback_ = value;
        }
      } else {
        answerFeedbackBuilder_.mergeFrom(value);
      }
      if (answerFeedback_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public Builder clearAnswerFeedback() {
      bitField0_ = (bitField0_ & ~0x00000400);
      answerFeedback_ = null;
      if (answerFeedbackBuilder_ != null) {
        answerFeedbackBuilder_.dispose();
        answerFeedbackBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnswerFeedback.Builder
        getAnswerFeedbackBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getAnswerFeedbackFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnswerFeedbackOrBuilder
        getAnswerFeedbackOrBuilder() {
      if (answerFeedbackBuilder_ != null) {
        return answerFeedbackBuilder_.getMessageOrBuilder();
      } else {
        return answerFeedback_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnswerFeedback.getDefaultInstance()
            : answerFeedback_;
      }
    }
    /**
     *
     *
     * <pre>
     * The feedback that the customer has about the answer in `data`.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnswerFeedback answer_feedback = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnswerFeedback,
            com.google.cloud.contactcenterinsights.v1.AnswerFeedback.Builder,
            com.google.cloud.contactcenterinsights.v1.AnswerFeedbackOrBuilder>
        getAnswerFeedbackFieldBuilder() {
      if (answerFeedbackBuilder_ == null) {
        answerFeedbackBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnswerFeedback,
                com.google.cloud.contactcenterinsights.v1.AnswerFeedback.Builder,
                com.google.cloud.contactcenterinsights.v1.AnswerFeedbackOrBuilder>(
                getAnswerFeedback(), getParentForChildren(), isClean());
        answerFeedback_ = null;
      }
      return answerFeedbackBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput userInput_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder>
        userInputBuilder_;
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     *
     * @return Whether the userInput field is set.
     */
    public boolean hasUserInput() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     *
     * @return The userInput.
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput getUserInput() {
      if (userInputBuilder_ == null) {
        return userInput_ == null
            ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
                .getDefaultInstance()
            : userInput_;
      } else {
        return userInputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public Builder setUserInput(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput value) {
      if (userInputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        userInput_ = value;
      } else {
        userInputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public Builder setUserInput(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder
            builderForValue) {
      if (userInputBuilder_ == null) {
        userInput_ = builderForValue.build();
      } else {
        userInputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public Builder mergeUserInput(
        com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput value) {
      if (userInputBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && userInput_ != null
            && userInput_
                != com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
                    .getDefaultInstance()) {
          getUserInputBuilder().mergeFrom(value);
        } else {
          userInput_ = value;
        }
      } else {
        userInputBuilder_.mergeFrom(value);
      }
      if (userInput_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public Builder clearUserInput() {
      bitField0_ = (bitField0_ & ~0x00000800);
      userInput_ = null;
      if (userInputBuilder_ != null) {
        userInputBuilder_.dispose();
        userInputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder
        getUserInputBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUserInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder
        getUserInputOrBuilder() {
      if (userInputBuilder_ != null) {
        return userInputBuilder_.getMessageOrBuilder();
      } else {
        return userInput_ == null
            ? com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput
                .getDefaultInstance()
            : userInput_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit input used for generating the answer
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput user_input = 16;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder,
            com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder>
        getUserInputFieldBuilder() {
      if (userInputBuilder_ == null) {
        userInputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput,
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInput.Builder,
                com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation.UserInputOrBuilder>(
                getUserInput(), getParentForChildren(), isClean());
        userInput_ = null;
      }
      return userInputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.RuntimeAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.RuntimeAnnotation)
  private static final com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation();
  }

  public static com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RuntimeAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<RuntimeAnnotation>() {
        @java.lang.Override
        public RuntimeAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RuntimeAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RuntimeAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RuntimeAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
