/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QaScorecardRevisionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QA_SCORECARD_REVISION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}/revisions/{revision}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String qaScorecard;
    private final String revision;

    @Deprecated
    protected QaScorecardRevisionName() {
        this.project = null;
        this.location = null;
        this.qaScorecard = null;
        this.revision = null;
    }

    private QaScorecardRevisionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.qaScorecard = (String)Preconditions.checkNotNull((Object)builder.getQaScorecard());
        this.revision = (String)Preconditions.checkNotNull((Object)builder.getRevision());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQaScorecard() {
        return this.qaScorecard;
    }

    public String getRevision() {
        return this.revision;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QaScorecardRevisionName of(String project, String location, String qaScorecard, String revision) {
        return QaScorecardRevisionName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).setRevision(revision).build();
    }

    public static String format(String project, String location, String qaScorecard, String revision) {
        return QaScorecardRevisionName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).setRevision(revision).build().toString();
    }

    public static QaScorecardRevisionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_QA_SCORECARD_REVISION.validatedMatch(formattedString, "QaScorecardRevisionName.parse: formattedString not in valid format");
        return QaScorecardRevisionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("qa_scorecard"), (String)matchMap.get("revision"));
    }

    public static List<QaScorecardRevisionName> parseList(List<String> formattedStrings) {
        ArrayList<QaScorecardRevisionName> list = new ArrayList<QaScorecardRevisionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QaScorecardRevisionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QaScorecardRevisionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QaScorecardRevisionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QA_SCORECARD_REVISION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QaScorecardRevisionName qaScorecardRevisionName = this;
            synchronized (qaScorecardRevisionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.qaScorecard != null) {
                        fieldMapBuilder.put((Object)"qa_scorecard", (Object)this.qaScorecard);
                    }
                    if (this.revision != null) {
                        fieldMapBuilder.put((Object)"revision", (Object)this.revision);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_QA_SCORECARD_REVISION.instantiate(new String[]{"project", this.project, "location", this.location, "qa_scorecard", this.qaScorecard, "revision", this.revision});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QaScorecardRevisionName that = (QaScorecardRevisionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.qaScorecard, that.qaScorecard) && Objects.equals(this.revision, that.revision);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.qaScorecard);
        h *= 1000003;
        return h ^= Objects.hashCode(this.revision);
    }

    public static class Builder {
        private String project;
        private String location;
        private String qaScorecard;
        private String revision;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQaScorecard() {
            return this.qaScorecard;
        }

        public String getRevision() {
            return this.revision;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQaScorecard(String qaScorecard) {
            this.qaScorecard = qaScorecard;
            return this;
        }

        public Builder setRevision(String revision) {
            this.revision = revision;
            return this;
        }

        private Builder(QaScorecardRevisionName qaScorecardRevisionName) {
            this.project = qaScorecardRevisionName.project;
            this.location = qaScorecardRevisionName.location;
            this.qaScorecard = qaScorecardRevisionName.qaScorecard;
            this.revision = qaScorecardRevisionName.revision;
        }

        public QaScorecardRevisionName build() {
            return new QaScorecardRevisionName(this);
        }
    }
}

