/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The CCAI Insights project wide analysis rule. This rule will be applied to
 * all conversations that match the filter defined in the rule. For a
 * conversation matches the filter, the annotators specified in the rule will be
 * run. If a conversation matches multiple rules, a union of all the annotators
 * will be run. One project can have multiple analysis rules.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnalysisRule}
 */
public final class AnalysisRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnalysisRule)
    AnalysisRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnalysisRule.newBuilder() to construct.
  private AnalysisRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnalysisRule() {
    name_ = "";
    displayName_ = "";
    conversationFilter_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnalysisRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnalysisRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnalysisRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.AnalysisRule.class,
            com.google.cloud.contactcenterinsights.v1.AnalysisRule.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the analysis rule.
   * Format:
   * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The resource name of the analysis rule.
   * Format:
   * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which this analysis rule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this analysis rule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which this analysis rule was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which this analysis rule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which this analysis rule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The most recent time at which this analysis rule was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Display Name of the analysis rule.
   * </pre>
   *
   * <code>optional string display_name = 4;</code>
   *
   * @return Whether the displayName field is set.
   */
  @java.lang.Override
  public boolean hasDisplayName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Display Name of the analysis rule.
   * </pre>
   *
   * <code>optional string display_name = 4;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Display Name of the analysis rule.
   * </pre>
   *
   * <code>optional string display_name = 4;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_FILTER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversationFilter_ = "";
  /**
   *
   *
   * <pre>
   * Filter for the conversations that should apply this analysis
   * rule. An empty filter means this analysis rule applies to all
   * conversations.
   * </pre>
   *
   * <code>string conversation_filter = 5;</code>
   *
   * @return The conversationFilter.
   */
  @java.lang.Override
  public java.lang.String getConversationFilter() {
    java.lang.Object ref = conversationFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversationFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filter for the conversations that should apply this analysis
   * rule. An empty filter means this analysis rule applies to all
   * conversations.
   * </pre>
   *
   * <code>string conversation_filter = 5;</code>
   *
   * @return The bytes for conversationFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationFilterBytes() {
    java.lang.Object ref = conversationFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversationFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATOR_SELECTOR_FIELD_NUMBER = 6;
  private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
  /**
   *
   *
   * <pre>
   * Selector of annotators to run and the phrase matchers to use for
   * conversations that matches the conversation_filter. If not specified, NO
   * annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
   *
   * @return Whether the annotatorSelector field is set.
   */
  @java.lang.Override
  public boolean hasAnnotatorSelector() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Selector of annotators to run and the phrase matchers to use for
   * conversations that matches the conversation_filter. If not specified, NO
   * annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
   *
   * @return The annotatorSelector.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
    return annotatorSelector_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
        : annotatorSelector_;
  }
  /**
   *
   *
   * <pre>
   * Selector of annotators to run and the phrase matchers to use for
   * conversations that matches the conversation_filter. If not specified, NO
   * annotators will be run.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
      getAnnotatorSelectorOrBuilder() {
    return annotatorSelector_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
        : annotatorSelector_;
  }

  public static final int ANALYSIS_PERCENTAGE_FIELD_NUMBER = 7;
  private double analysisPercentage_ = 0D;
  /**
   *
   *
   * <pre>
   * Percentage of conversations that we should apply this analysis setting
   * automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
   * are sampled in a determenestic way. The original runtime_percentage &amp;
   * upload percentage will be replaced by defining filters on the conversation.
   * </pre>
   *
   * <code>double analysis_percentage = 7;</code>
   *
   * @return The analysisPercentage.
   */
  @java.lang.Override
  public double getAnalysisPercentage() {
    return analysisPercentage_;
  }

  public static final int ACTIVE_FIELD_NUMBER = 8;
  private boolean active_ = false;
  /**
   *
   *
   * <pre>
   * If true, apply this rule to conversations. Otherwise, this rule is
   * inactive and saved as a draft.
   * </pre>
   *
   * <code>bool active = 8;</code>
   *
   * @return The active.
   */
  @java.lang.Override
  public boolean getActive() {
    return active_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, conversationFilter_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(6, getAnnotatorSelector());
    }
    if (java.lang.Double.doubleToRawLongBits(analysisPercentage_) != 0) {
      output.writeDouble(7, analysisPercentage_);
    }
    if (active_ != false) {
      output.writeBool(8, active_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, conversationFilter_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAnnotatorSelector());
    }
    if (java.lang.Double.doubleToRawLongBits(analysisPercentage_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(7, analysisPercentage_);
    }
    if (active_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, active_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.AnalysisRule)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.AnalysisRule other =
        (com.google.cloud.contactcenterinsights.v1.AnalysisRule) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasDisplayName() != other.hasDisplayName()) return false;
    if (hasDisplayName()) {
      if (!getDisplayName().equals(other.getDisplayName())) return false;
    }
    if (!getConversationFilter().equals(other.getConversationFilter())) return false;
    if (hasAnnotatorSelector() != other.hasAnnotatorSelector()) return false;
    if (hasAnnotatorSelector()) {
      if (!getAnnotatorSelector().equals(other.getAnnotatorSelector())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getAnalysisPercentage())
        != java.lang.Double.doubleToLongBits(other.getAnalysisPercentage())) return false;
    if (getActive() != other.getActive()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasDisplayName()) {
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
    }
    hash = (37 * hash) + CONVERSATION_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getConversationFilter().hashCode();
    if (hasAnnotatorSelector()) {
      hash = (37 * hash) + ANNOTATOR_SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotatorSelector().hashCode();
    }
    hash = (37 * hash) + ANALYSIS_PERCENTAGE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getAnalysisPercentage()));
    hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getActive());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.AnalysisRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The CCAI Insights project wide analysis rule. This rule will be applied to
   * all conversations that match the filter defined in the rule. For a
   * conversation matches the filter, the annotators specified in the rule will be
   * run. If a conversation matches multiple rules, a union of all the annotators
   * will be run. One project can have multiple analysis rules.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnalysisRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnalysisRule)
      com.google.cloud.contactcenterinsights.v1.AnalysisRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnalysisRule.class,
              com.google.cloud.contactcenterinsights.v1.AnalysisRule.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.AnalysisRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getAnnotatorSelectorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      displayName_ = "";
      conversationFilter_ = "";
      annotatorSelector_ = null;
      if (annotatorSelectorBuilder_ != null) {
        annotatorSelectorBuilder_.dispose();
        annotatorSelectorBuilder_ = null;
      }
      analysisPercentage_ = 0D;
      active_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnalysisRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisRule getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.AnalysisRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisRule build() {
      com.google.cloud.contactcenterinsights.v1.AnalysisRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnalysisRule buildPartial() {
      com.google.cloud.contactcenterinsights.v1.AnalysisRule result =
          new com.google.cloud.contactcenterinsights.v1.AnalysisRule(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.AnalysisRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.conversationFilter_ = conversationFilter_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.annotatorSelector_ =
            annotatorSelectorBuilder_ == null
                ? annotatorSelector_
                : annotatorSelectorBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.analysisPercentage_ = analysisPercentage_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.active_ = active_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.AnalysisRule) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.AnalysisRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.AnalysisRule other) {
      if (other == com.google.cloud.contactcenterinsights.v1.AnalysisRule.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasDisplayName()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getConversationFilter().isEmpty()) {
        conversationFilter_ = other.conversationFilter_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasAnnotatorSelector()) {
        mergeAnnotatorSelector(other.getAnnotatorSelector());
      }
      if (other.getAnalysisPercentage() != 0D) {
        setAnalysisPercentage(other.getAnalysisPercentage());
      }
      if (other.getActive() != false) {
        setActive(other.getActive());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                conversationFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAnnotatorSelectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 57:
              {
                analysisPercentage_ = input.readDouble();
                bitField0_ |= 0x00000040;
                break;
              } // case 57
            case 64:
              {
                active_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the analysis rule.
     * Format:
     * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the analysis rule.
     * Format:
     * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the analysis rule.
     * Format:
     * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the analysis rule.
     * Format:
     * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The resource name of the analysis rule.
     * Format:
     * projects/{project}/locations/{location}/analysisRules/{analysis_rule}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which this analysis rule was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The most recent time at which this analysis rule was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @return Whether the displayName field is set.
     */
    public boolean hasDisplayName() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Display Name of the analysis rule.
     * </pre>
     *
     * <code>optional string display_name = 4;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object conversationFilter_ = "";
    /**
     *
     *
     * <pre>
     * Filter for the conversations that should apply this analysis
     * rule. An empty filter means this analysis rule applies to all
     * conversations.
     * </pre>
     *
     * <code>string conversation_filter = 5;</code>
     *
     * @return The conversationFilter.
     */
    public java.lang.String getConversationFilter() {
      java.lang.Object ref = conversationFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for the conversations that should apply this analysis
     * rule. An empty filter means this analysis rule applies to all
     * conversations.
     * </pre>
     *
     * <code>string conversation_filter = 5;</code>
     *
     * @return The bytes for conversationFilter.
     */
    public com.google.protobuf.ByteString getConversationFilterBytes() {
      java.lang.Object ref = conversationFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filter for the conversations that should apply this analysis
     * rule. An empty filter means this analysis rule applies to all
     * conversations.
     * </pre>
     *
     * <code>string conversation_filter = 5;</code>
     *
     * @param value The conversationFilter to set.
     * @return This builder for chaining.
     */
    public Builder setConversationFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversationFilter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for the conversations that should apply this analysis
     * rule. An empty filter means this analysis rule applies to all
     * conversations.
     * </pre>
     *
     * <code>string conversation_filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationFilter() {
      conversationFilter_ = getDefaultInstance().getConversationFilter();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filter for the conversations that should apply this analysis
     * rule. An empty filter means this analysis rule applies to all
     * conversations.
     * </pre>
     *
     * <code>string conversation_filter = 5;</code>
     *
     * @param value The bytes for conversationFilter to set.
     * @return This builder for chaining.
     */
    public Builder setConversationFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversationFilter_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
        annotatorSelectorBuilder_;
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     *
     * @return Whether the annotatorSelector field is set.
     */
    public boolean hasAnnotatorSelector() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     *
     * @return The annotatorSelector.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
      if (annotatorSelectorBuilder_ == null) {
        return annotatorSelector_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
            : annotatorSelector_;
      } else {
        return annotatorSelectorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public Builder setAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
      if (annotatorSelectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotatorSelector_ = value;
      } else {
        annotatorSelectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public Builder setAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder builderForValue) {
      if (annotatorSelectorBuilder_ == null) {
        annotatorSelector_ = builderForValue.build();
      } else {
        annotatorSelectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public Builder mergeAnnotatorSelector(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
      if (annotatorSelectorBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && annotatorSelector_ != null
            && annotatorSelector_
                != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                    .getDefaultInstance()) {
          getAnnotatorSelectorBuilder().mergeFrom(value);
        } else {
          annotatorSelector_ = value;
        }
      } else {
        annotatorSelectorBuilder_.mergeFrom(value);
      }
      if (annotatorSelector_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public Builder clearAnnotatorSelector() {
      bitField0_ = (bitField0_ & ~0x00000020);
      annotatorSelector_ = null;
      if (annotatorSelectorBuilder_ != null) {
        annotatorSelectorBuilder_.dispose();
        annotatorSelectorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder
        getAnnotatorSelectorBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAnnotatorSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
        getAnnotatorSelectorOrBuilder() {
      if (annotatorSelectorBuilder_ != null) {
        return annotatorSelectorBuilder_.getMessageOrBuilder();
      } else {
        return annotatorSelector_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
            : annotatorSelector_;
      }
    }
    /**
     *
     *
     * <pre>
     * Selector of annotators to run and the phrase matchers to use for
     * conversations that matches the conversation_filter. If not specified, NO
     * annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
        getAnnotatorSelectorFieldBuilder() {
      if (annotatorSelectorBuilder_ == null) {
        annotatorSelectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>(
                getAnnotatorSelector(), getParentForChildren(), isClean());
        annotatorSelector_ = null;
      }
      return annotatorSelectorBuilder_;
    }

    private double analysisPercentage_;
    /**
     *
     *
     * <pre>
     * Percentage of conversations that we should apply this analysis setting
     * automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
     * are sampled in a determenestic way. The original runtime_percentage &amp;
     * upload percentage will be replaced by defining filters on the conversation.
     * </pre>
     *
     * <code>double analysis_percentage = 7;</code>
     *
     * @return The analysisPercentage.
     */
    @java.lang.Override
    public double getAnalysisPercentage() {
      return analysisPercentage_;
    }
    /**
     *
     *
     * <pre>
     * Percentage of conversations that we should apply this analysis setting
     * automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
     * are sampled in a determenestic way. The original runtime_percentage &amp;
     * upload percentage will be replaced by defining filters on the conversation.
     * </pre>
     *
     * <code>double analysis_percentage = 7;</code>
     *
     * @param value The analysisPercentage to set.
     * @return This builder for chaining.
     */
    public Builder setAnalysisPercentage(double value) {

      analysisPercentage_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Percentage of conversations that we should apply this analysis setting
     * automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
     * are sampled in a determenestic way. The original runtime_percentage &amp;
     * upload percentage will be replaced by defining filters on the conversation.
     * </pre>
     *
     * <code>double analysis_percentage = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnalysisPercentage() {
      bitField0_ = (bitField0_ & ~0x00000040);
      analysisPercentage_ = 0D;
      onChanged();
      return this;
    }

    private boolean active_;
    /**
     *
     *
     * <pre>
     * If true, apply this rule to conversations. Otherwise, this rule is
     * inactive and saved as a draft.
     * </pre>
     *
     * <code>bool active = 8;</code>
     *
     * @return The active.
     */
    @java.lang.Override
    public boolean getActive() {
      return active_;
    }
    /**
     *
     *
     * <pre>
     * If true, apply this rule to conversations. Otherwise, this rule is
     * inactive and saved as a draft.
     * </pre>
     *
     * <code>bool active = 8;</code>
     *
     * @param value The active to set.
     * @return This builder for chaining.
     */
    public Builder setActive(boolean value) {

      active_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, apply this rule to conversations. Otherwise, this rule is
     * inactive and saved as a draft.
     * </pre>
     *
     * <code>bool active = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActive() {
      bitField0_ = (bitField0_ & ~0x00000080);
      active_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnalysisRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnalysisRule)
  private static final com.google.cloud.contactcenterinsights.v1.AnalysisRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.AnalysisRule();
  }

  public static com.google.cloud.contactcenterinsights.v1.AnalysisRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnalysisRule> PARSER =
      new com.google.protobuf.AbstractParser<AnalysisRule>() {
        @java.lang.Override
        public AnalysisRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnalysisRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnalysisRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnalysisRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
