/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Selector of all available annotators and phrase matchers to run.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnnotatorSelector}
 */
public final class AnnotatorSelector extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector)
    AnnotatorSelectorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotatorSelector.newBuilder() to construct.
  private AnnotatorSelector(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotatorSelector() {
    phraseMatchers_ = com.google.protobuf.LazyStringArrayList.emptyList();
    issueModels_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotatorSelector();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.class,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder.class);
  }

  public interface SummarizationConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the conversationProfile field is set.
     */
    boolean hasConversationProfile();
    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The conversationProfile.
     */
    java.lang.String getConversationProfile();
    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for conversationProfile.
     */
    com.google.protobuf.ByteString getConversationProfileBytes();

    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return Whether the summarizationModel field is set.
     */
    boolean hasSummarizationModel();
    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for summarizationModel.
     */
    int getSummarizationModelValue();
    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return The summarizationModel.
     */
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .SummarizationModel
        getSummarizationModel();

    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.ModelSourceCase
        getModelSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration for summarization.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig}
   */
  public static final class SummarizationConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
      SummarizationConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SummarizationConfig.newBuilder() to construct.
    private SummarizationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SummarizationConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SummarizationConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_SummarizationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_SummarizationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.class,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Summarization model to use, if `conversation_profile` is not used.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel}
     */
    public enum SummarizationModel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified summarization model.
       * </pre>
       *
       * <code>SUMMARIZATION_MODEL_UNSPECIFIED = 0;</code>
       */
      SUMMARIZATION_MODEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The CCAI baseline model.
       * </pre>
       *
       * <code>BASELINE_MODEL = 1;</code>
       */
      BASELINE_MODEL(1),
      /**
       *
       *
       * <pre>
       * The CCAI baseline model, V2.0.
       * </pre>
       *
       * <code>BASELINE_MODEL_V2_0 = 2;</code>
       */
      BASELINE_MODEL_V2_0(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified summarization model.
       * </pre>
       *
       * <code>SUMMARIZATION_MODEL_UNSPECIFIED = 0;</code>
       */
      public static final int SUMMARIZATION_MODEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The CCAI baseline model.
       * </pre>
       *
       * <code>BASELINE_MODEL = 1;</code>
       */
      public static final int BASELINE_MODEL_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The CCAI baseline model, V2.0.
       * </pre>
       *
       * <code>BASELINE_MODEL_V2_0 = 2;</code>
       */
      public static final int BASELINE_MODEL_V2_0_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SummarizationModel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SummarizationModel forNumber(int value) {
        switch (value) {
          case 0:
            return SUMMARIZATION_MODEL_UNSPECIFIED;
          case 1:
            return BASELINE_MODEL;
          case 2:
            return BASELINE_MODEL_V2_0;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SummarizationModel>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SummarizationModel>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<SummarizationModel>() {
                public SummarizationModel findValueByNumber(int number) {
                  return SummarizationModel.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SummarizationModel[] VALUES = values();

      public static SummarizationModel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SummarizationModel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel)
    }

    private int modelSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object modelSource_;

    public enum ModelSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      CONVERSATION_PROFILE(1),
      SUMMARIZATION_MODEL(2),
      MODELSOURCE_NOT_SET(0);
      private final int value;

      private ModelSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ModelSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ModelSourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return CONVERSATION_PROFILE;
          case 2:
            return SUMMARIZATION_MODEL;
          case 0:
            return MODELSOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ModelSourceCase getModelSourceCase() {
      return ModelSourceCase.forNumber(modelSourceCase_);
    }

    public static final int CONVERSATION_PROFILE_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return Whether the conversationProfile field is set.
     */
    public boolean hasConversationProfile() {
      return modelSourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The conversationProfile.
     */
    public java.lang.String getConversationProfile() {
      java.lang.Object ref = "";
      if (modelSourceCase_ == 1) {
        ref = modelSource_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (modelSourceCase_ == 1) {
          modelSource_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the Dialogflow conversation profile.
     * Format:
     * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
     * </pre>
     *
     * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for conversationProfile.
     */
    public com.google.protobuf.ByteString getConversationProfileBytes() {
      java.lang.Object ref = "";
      if (modelSourceCase_ == 1) {
        ref = modelSource_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (modelSourceCase_ == 1) {
          modelSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUMMARIZATION_MODEL_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return Whether the summarizationModel field is set.
     */
    public boolean hasSummarizationModel() {
      return modelSourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for summarizationModel.
     */
    public int getSummarizationModelValue() {
      if (modelSourceCase_ == 2) {
        return (java.lang.Integer) modelSource_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Default summarization model to be used.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
     * </code>
     *
     * @return The summarizationModel.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .SummarizationModel
        getSummarizationModel() {
      if (modelSourceCase_ == 2) {
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                .SummarizationModel
            result =
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                    .SummarizationModel.forNumber((java.lang.Integer) modelSource_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                .SummarizationModel.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
          .SummarizationModel.SUMMARIZATION_MODEL_UNSPECIFIED;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (modelSourceCase_ == 1) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, modelSource_);
      }
      if (modelSourceCase_ == 2) {
        output.writeEnum(2, ((java.lang.Integer) modelSource_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (modelSourceCase_ == 1) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, modelSource_);
      }
      if (modelSourceCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeEnumSize(
                2, ((java.lang.Integer) modelSource_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig other =
          (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig) obj;

      if (!getModelSourceCase().equals(other.getModelSourceCase())) return false;
      switch (modelSourceCase_) {
        case 1:
          if (!getConversationProfile().equals(other.getConversationProfile())) return false;
          break;
        case 2:
          if (getSummarizationModelValue() != other.getSummarizationModelValue()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (modelSourceCase_) {
        case 1:
          hash = (37 * hash) + CONVERSATION_PROFILE_FIELD_NUMBER;
          hash = (53 * hash) + getConversationProfile().hashCode();
          break;
        case 2:
          hash = (37 * hash) + SUMMARIZATION_MODEL_FIELD_NUMBER;
          hash = (53 * hash) + getSummarizationModelValue();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for summarization.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_SummarizationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_SummarizationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                    .class,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        modelSourceCase_ = 0;
        modelSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_SummarizationConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
          build() {
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig result =
            new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig result) {
        result.modelSourceCase_ = modelSourceCase_;
        result.modelSource_ = this.modelSource_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                .getDefaultInstance()) return this;
        switch (other.getModelSourceCase()) {
          case CONVERSATION_PROFILE:
            {
              modelSourceCase_ = 1;
              modelSource_ = other.modelSource_;
              onChanged();
              break;
            }
          case SUMMARIZATION_MODEL:
            {
              setSummarizationModelValue(other.getSummarizationModelValue());
              break;
            }
          case MODELSOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  modelSourceCase_ = 1;
                  modelSource_ = s;
                  break;
                } // case 10
              case 16:
                {
                  int rawValue = input.readEnum();
                  modelSourceCase_ = 2;
                  modelSource_ = rawValue;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int modelSourceCase_ = 0;
      private java.lang.Object modelSource_;

      public ModelSourceCase getModelSourceCase() {
        return ModelSourceCase.forNumber(modelSourceCase_);
      }

      public Builder clearModelSource() {
        modelSourceCase_ = 0;
        modelSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return Whether the conversationProfile field is set.
       */
      @java.lang.Override
      public boolean hasConversationProfile() {
        return modelSourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The conversationProfile.
       */
      @java.lang.Override
      public java.lang.String getConversationProfile() {
        java.lang.Object ref = "";
        if (modelSourceCase_ == 1) {
          ref = modelSource_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (modelSourceCase_ == 1) {
            modelSource_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for conversationProfile.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getConversationProfileBytes() {
        java.lang.Object ref = "";
        if (modelSourceCase_ == 1) {
          ref = modelSource_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (modelSourceCase_ == 1) {
            modelSource_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The conversationProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConversationProfile(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelSourceCase_ = 1;
        modelSource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConversationProfile() {
        if (modelSourceCase_ == 1) {
          modelSourceCase_ = 0;
          modelSource_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource name of the Dialogflow conversation profile.
       * Format:
       * projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}
       * </pre>
       *
       * <code>string conversation_profile = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for conversationProfile to set.
       * @return This builder for chaining.
       */
      public Builder setConversationProfileBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelSourceCase_ = 1;
        modelSource_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @return Whether the summarizationModel field is set.
       */
      @java.lang.Override
      public boolean hasSummarizationModel() {
        return modelSourceCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for summarizationModel.
       */
      @java.lang.Override
      public int getSummarizationModelValue() {
        if (modelSourceCase_ == 2) {
          return ((java.lang.Integer) modelSource_).intValue();
        }
        return 0;
      }
      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for summarizationModel to set.
       * @return This builder for chaining.
       */
      public Builder setSummarizationModelValue(int value) {
        modelSourceCase_ = 2;
        modelSource_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @return The summarizationModel.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
              .SummarizationModel
          getSummarizationModel() {
        if (modelSourceCase_ == 2) {
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                  .SummarizationModel
              result =
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                      .SummarizationModel.forNumber((java.lang.Integer) modelSource_);
          return result == null
              ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                  .SummarizationModel.UNRECOGNIZED
              : result;
        }
        return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .SummarizationModel.SUMMARIZATION_MODEL_UNSPECIFIED;
      }
      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @param value The summarizationModel to set.
       * @return This builder for chaining.
       */
      public Builder setSummarizationModel(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                  .SummarizationModel
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelSourceCase_ = 2;
        modelSource_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Default summarization model to be used.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.SummarizationModel summarization_model = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSummarizationModel() {
        if (modelSourceCase_ == 2) {
          modelSourceCase_ = 0;
          modelSource_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig)
    private static final com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
            .SummarizationConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SummarizationConfig> PARSER =
        new com.google.protobuf.AbstractParser<SummarizationConfig>() {
          @java.lang.Override
          public SummarizationConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SummarizationConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SummarizationConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QaConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     *
     * @return Whether the scorecardList field is set.
     */
    boolean hasScorecardList();
    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     *
     * @return The scorecardList.
     */
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
        getScorecardList();
    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardListOrBuilder
        getScorecardListOrBuilder();

    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardSourceCase
        getScorecardSourceCase();
  }
  /**
   *
   *
   * <pre>
   * Configuration for the QA feature.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig}
   */
  public static final class QaConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)
      QaConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaConfig.newBuilder() to construct.
    private QaConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.class,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder.class);
    }

    public interface ScorecardListOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the qaScorecardRevisions.
       */
      java.util.List<java.lang.String> getQaScorecardRevisionsList();
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of qaScorecardRevisions.
       */
      int getQaScorecardRevisionsCount();
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The qaScorecardRevisions at the given index.
       */
      java.lang.String getQaScorecardRevisions(int index);
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the qaScorecardRevisions at the given index.
       */
      com.google.protobuf.ByteString getQaScorecardRevisionsBytes(int index);
    }
    /**
     *
     *
     * <pre>
     * Container for a list of scorecards.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList}
     */
    public static final class ScorecardList extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
        ScorecardListOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ScorecardList.newBuilder() to construct.
      private ScorecardList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ScorecardList() {
        qaScorecardRevisions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ScorecardList();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_ScorecardList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_ScorecardList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                    .class,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                    .Builder.class);
      }

      public static final int QA_SCORECARD_REVISIONS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList qaScorecardRevisions_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return A list containing the qaScorecardRevisions.
       */
      public com.google.protobuf.ProtocolStringList getQaScorecardRevisionsList() {
        return qaScorecardRevisions_;
      }
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The count of qaScorecardRevisions.
       */
      public int getQaScorecardRevisionsCount() {
        return qaScorecardRevisions_.size();
      }
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the element to return.
       * @return The qaScorecardRevisions at the given index.
       */
      public java.lang.String getQaScorecardRevisions(int index) {
        return qaScorecardRevisions_.get(index);
      }
      /**
       *
       *
       * <pre>
       * List of QaScorecardRevisions.
       * </pre>
       *
       * <code>
       * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the qaScorecardRevisions at the given index.
       */
      public com.google.protobuf.ByteString getQaScorecardRevisionsBytes(int index) {
        return qaScorecardRevisions_.getByteString(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < qaScorecardRevisions_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(
              output, 1, qaScorecardRevisions_.getRaw(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < qaScorecardRevisions_.size(); i++) {
            dataSize += computeStringSizeNoTag(qaScorecardRevisions_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getQaScorecardRevisionsList().size();
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList other =
            (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
                obj;

        if (!getQaScorecardRevisionsList().equals(other.getQaScorecardRevisionsList()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getQaScorecardRevisionsCount() > 0) {
          hash = (37 * hash) + QA_SCORECARD_REVISIONS_FIELD_NUMBER;
          hash = (53 * hash) + getQaScorecardRevisionsList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Container for a list of scorecards.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardListOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_ScorecardList_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_ScorecardList_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                      .class,
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          qaScorecardRevisions_ = com.google.protobuf.LazyStringArrayList.emptyList();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ResourcesProto
              .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_ScorecardList_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
            build() {
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              result =
                  new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                      .ScorecardList(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            qaScorecardRevisions_.makeImmutable();
            result.qaScorecardRevisions_ = qaScorecardRevisions_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                  .getDefaultInstance()) return this;
          if (!other.qaScorecardRevisions_.isEmpty()) {
            if (qaScorecardRevisions_.isEmpty()) {
              qaScorecardRevisions_ = other.qaScorecardRevisions_;
              bitField0_ |= 0x00000001;
            } else {
              ensureQaScorecardRevisionsIsMutable();
              qaScorecardRevisions_.addAll(other.qaScorecardRevisions_);
            }
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureQaScorecardRevisionsIsMutable();
                    qaScorecardRevisions_.add(s);
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList qaScorecardRevisions_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureQaScorecardRevisionsIsMutable() {
          if (!qaScorecardRevisions_.isModifiable()) {
            qaScorecardRevisions_ =
                new com.google.protobuf.LazyStringArrayList(qaScorecardRevisions_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return A list containing the qaScorecardRevisions.
         */
        public com.google.protobuf.ProtocolStringList getQaScorecardRevisionsList() {
          qaScorecardRevisions_.makeImmutable();
          return qaScorecardRevisions_;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return The count of qaScorecardRevisions.
         */
        public int getQaScorecardRevisionsCount() {
          return qaScorecardRevisions_.size();
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the element to return.
         * @return The qaScorecardRevisions at the given index.
         */
        public java.lang.String getQaScorecardRevisions(int index) {
          return qaScorecardRevisions_.get(index);
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the qaScorecardRevisions at the given index.
         */
        public com.google.protobuf.ByteString getQaScorecardRevisionsBytes(int index) {
          return qaScorecardRevisions_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param index The index to set the value at.
         * @param value The qaScorecardRevisions to set.
         * @return This builder for chaining.
         */
        public Builder setQaScorecardRevisions(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQaScorecardRevisionsIsMutable();
          qaScorecardRevisions_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The qaScorecardRevisions to add.
         * @return This builder for chaining.
         */
        public Builder addQaScorecardRevisions(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQaScorecardRevisionsIsMutable();
          qaScorecardRevisions_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param values The qaScorecardRevisions to add.
         * @return This builder for chaining.
         */
        public Builder addAllQaScorecardRevisions(java.lang.Iterable<java.lang.String> values) {
          ensureQaScorecardRevisionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qaScorecardRevisions_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearQaScorecardRevisions() {
          qaScorecardRevisions_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * List of QaScorecardRevisions.
         * </pre>
         *
         * <code>
         * repeated string qa_scorecard_revisions = 1 [(.google.api.resource_reference) = { ... }
         * </code>
         *
         * @param value The bytes of the qaScorecardRevisions to add.
         * @return This builder for chaining.
         */
        public Builder addQaScorecardRevisionsBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureQaScorecardRevisionsIsMutable();
          qaScorecardRevisions_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
      private static final com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                .ScorecardList();
      }

      public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardList
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ScorecardList> PARSER =
          new com.google.protobuf.AbstractParser<ScorecardList>() {
            @java.lang.Override
            public ScorecardList parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ScorecardList> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ScorecardList> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int scorecardSourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object scorecardSource_;

    public enum ScorecardSourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SCORECARD_LIST(1),
      SCORECARDSOURCE_NOT_SET(0);
      private final int value;

      private ScorecardSourceCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScorecardSourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static ScorecardSourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return SCORECARD_LIST;
          case 0:
            return SCORECARDSOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ScorecardSourceCase getScorecardSourceCase() {
      return ScorecardSourceCase.forNumber(scorecardSourceCase_);
    }

    public static final int SCORECARD_LIST_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     *
     * @return Whether the scorecardList field is set.
     */
    @java.lang.Override
    public boolean hasScorecardList() {
      return scorecardSourceCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     *
     * @return The scorecardList.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
        getScorecardList() {
      if (scorecardSourceCase_ == 1) {
        return (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
            scorecardSource_;
      }
      return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * A manual list of scorecards to score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
            .ScorecardListOrBuilder
        getScorecardListOrBuilder() {
      if (scorecardSourceCase_ == 1) {
        return (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
            scorecardSource_;
      }
      return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (scorecardSourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
                scorecardSource_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (scorecardSourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList)
                    scorecardSource_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig other =
          (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig) obj;

      if (!getScorecardSourceCase().equals(other.getScorecardSourceCase())) return false;
      switch (scorecardSourceCase_) {
        case 1:
          if (!getScorecardList().equals(other.getScorecardList())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (scorecardSourceCase_) {
        case 1:
          hash = (37 * hash) + SCORECARD_LIST_FIELD_NUMBER;
          hash = (53 * hash) + getScorecardList().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA feature.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.class,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (scorecardListBuilder_ != null) {
          scorecardListBuilder_.clear();
        }
        scorecardSourceCase_ = 0;
        scorecardSource_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_QaConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig build() {
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig buildPartial() {
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig result =
            new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig result) {
        result.scorecardSourceCase_ = scorecardSourceCase_;
        result.scorecardSource_ = this.scorecardSource_;
        if (scorecardSourceCase_ == 1 && scorecardListBuilder_ != null) {
          result.scorecardSource_ = scorecardListBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                .getDefaultInstance()) return this;
        switch (other.getScorecardSourceCase()) {
          case SCORECARD_LIST:
            {
              mergeScorecardList(other.getScorecardList());
              break;
            }
          case SCORECARDSOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getScorecardListFieldBuilder().getBuilder(), extensionRegistry);
                  scorecardSourceCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int scorecardSourceCase_ = 0;
      private java.lang.Object scorecardSource_;

      public ScorecardSourceCase getScorecardSourceCase() {
        return ScorecardSourceCase.forNumber(scorecardSourceCase_);
      }

      public Builder clearScorecardSource() {
        scorecardSourceCase_ = 0;
        scorecardSource_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                  .ScorecardListOrBuilder>
          scorecardListBuilder_;
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       *
       * @return Whether the scorecardList field is set.
       */
      @java.lang.Override
      public boolean hasScorecardList() {
        return scorecardSourceCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       *
       * @return The scorecardList.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
          getScorecardList() {
        if (scorecardListBuilder_ == null) {
          if (scorecardSourceCase_ == 1) {
            return (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                    .ScorecardList)
                scorecardSource_;
          }
          return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              .getDefaultInstance();
        } else {
          if (scorecardSourceCase_ == 1) {
            return scorecardListBuilder_.getMessage();
          }
          return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      public Builder setScorecardList(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              value) {
        if (scorecardListBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scorecardSource_ = value;
          onChanged();
        } else {
          scorecardListBuilder_.setMessage(value);
        }
        scorecardSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      public Builder setScorecardList(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList.Builder
              builderForValue) {
        if (scorecardListBuilder_ == null) {
          scorecardSource_ = builderForValue.build();
          onChanged();
        } else {
          scorecardListBuilder_.setMessage(builderForValue.build());
        }
        scorecardSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      public Builder mergeScorecardList(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              value) {
        if (scorecardListBuilder_ == null) {
          if (scorecardSourceCase_ == 1
              && scorecardSource_
                  != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                      .ScorecardList.getDefaultInstance()) {
            scorecardSource_ =
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                    .newBuilder(
                        (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                                .ScorecardList)
                            scorecardSource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            scorecardSource_ = value;
          }
          onChanged();
        } else {
          if (scorecardSourceCase_ == 1) {
            scorecardListBuilder_.mergeFrom(value);
          } else {
            scorecardListBuilder_.setMessage(value);
          }
        }
        scorecardSourceCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      public Builder clearScorecardList() {
        if (scorecardListBuilder_ == null) {
          if (scorecardSourceCase_ == 1) {
            scorecardSourceCase_ = 0;
            scorecardSource_ = null;
            onChanged();
          }
        } else {
          if (scorecardSourceCase_ == 1) {
            scorecardSourceCase_ = 0;
            scorecardSource_ = null;
          }
          scorecardListBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              .Builder
          getScorecardListBuilder() {
        return getScorecardListFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
              .ScorecardListOrBuilder
          getScorecardListOrBuilder() {
        if ((scorecardSourceCase_ == 1) && (scorecardListBuilder_ != null)) {
          return scorecardListBuilder_.getMessageOrBuilder();
        } else {
          if (scorecardSourceCase_ == 1) {
            return (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                    .ScorecardList)
                scorecardSource_;
          }
          return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * A manual list of scorecards to score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList scorecard_list = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                  .Builder,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                  .ScorecardListOrBuilder>
          getScorecardListFieldBuilder() {
        if (scorecardListBuilder_ == null) {
          if (!(scorecardSourceCase_ == 1)) {
            scorecardSource_ =
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                    .getDefaultInstance();
          }
          scorecardListBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                      .ScorecardList,
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.ScorecardList
                      .Builder,
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                      .ScorecardListOrBuilder>(
                  (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                          .ScorecardList)
                      scorecardSource_,
                  getParentForChildren(),
                  isClean());
          scorecardSource_ = null;
        }
        scorecardSourceCase_ = 1;
        onChanged();
        return scorecardListBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig)
    private static final com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaConfig> PARSER =
        new com.google.protobuf.AbstractParser<QaConfig>() {
          @java.lang.Override
          public QaConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int RUN_INTERRUPTION_ANNOTATOR_FIELD_NUMBER = 1;
  private boolean runInterruptionAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the interruption annotator.
   * </pre>
   *
   * <code>bool run_interruption_annotator = 1;</code>
   *
   * @return The runInterruptionAnnotator.
   */
  @java.lang.Override
  public boolean getRunInterruptionAnnotator() {
    return runInterruptionAnnotator_;
  }

  public static final int RUN_SILENCE_ANNOTATOR_FIELD_NUMBER = 2;
  private boolean runSilenceAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the silence annotator.
   * </pre>
   *
   * <code>bool run_silence_annotator = 2;</code>
   *
   * @return The runSilenceAnnotator.
   */
  @java.lang.Override
  public boolean getRunSilenceAnnotator() {
    return runSilenceAnnotator_;
  }

  public static final int RUN_PHRASE_MATCHER_ANNOTATOR_FIELD_NUMBER = 3;
  private boolean runPhraseMatcherAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the active phrase matcher annotator(s).
   * </pre>
   *
   * <code>bool run_phrase_matcher_annotator = 3;</code>
   *
   * @return The runPhraseMatcherAnnotator.
   */
  @java.lang.Override
  public boolean getRunPhraseMatcherAnnotator() {
    return runPhraseMatcherAnnotator_;
  }

  public static final int PHRASE_MATCHERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList phraseMatchers_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the phraseMatchers.
   */
  public com.google.protobuf.ProtocolStringList getPhraseMatchersList() {
    return phraseMatchers_;
  }
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of phraseMatchers.
   */
  public int getPhraseMatchersCount() {
    return phraseMatchers_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The phraseMatchers at the given index.
   */
  public java.lang.String getPhraseMatchers(int index) {
    return phraseMatchers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the phraseMatchers at the given index.
   */
  public com.google.protobuf.ByteString getPhraseMatchersBytes(int index) {
    return phraseMatchers_.getByteString(index);
  }

  public static final int RUN_SENTIMENT_ANNOTATOR_FIELD_NUMBER = 5;
  private boolean runSentimentAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the sentiment annotator.
   * </pre>
   *
   * <code>bool run_sentiment_annotator = 5;</code>
   *
   * @return The runSentimentAnnotator.
   */
  @java.lang.Override
  public boolean getRunSentimentAnnotator() {
    return runSentimentAnnotator_;
  }

  public static final int RUN_ENTITY_ANNOTATOR_FIELD_NUMBER = 6;
  private boolean runEntityAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the entity annotator.
   * </pre>
   *
   * <code>bool run_entity_annotator = 6;</code>
   *
   * @return The runEntityAnnotator.
   */
  @java.lang.Override
  public boolean getRunEntityAnnotator() {
    return runEntityAnnotator_;
  }

  public static final int RUN_INTENT_ANNOTATOR_FIELD_NUMBER = 7;
  private boolean runIntentAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the intent annotator.
   * </pre>
   *
   * <code>bool run_intent_annotator = 7;</code>
   *
   * @return The runIntentAnnotator.
   */
  @java.lang.Override
  public boolean getRunIntentAnnotator() {
    return runIntentAnnotator_;
  }

  public static final int RUN_ISSUE_MODEL_ANNOTATOR_FIELD_NUMBER = 8;
  private boolean runIssueModelAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the issue model annotator. A model should have already been
   * deployed for this to take effect.
   * </pre>
   *
   * <code>bool run_issue_model_annotator = 8;</code>
   *
   * @return The runIssueModelAnnotator.
   */
  @java.lang.Override
  public boolean getRunIssueModelAnnotator() {
    return runIssueModelAnnotator_;
  }

  public static final int ISSUE_MODELS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList issueModels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the issueModels.
   */
  public com.google.protobuf.ProtocolStringList getIssueModelsList() {
    return issueModels_;
  }
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of issueModels.
   */
  public int getIssueModelsCount() {
    return issueModels_.size();
  }
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The issueModels at the given index.
   */
  public java.lang.String getIssueModels(int index) {
    return issueModels_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the issueModels at the given index.
   */
  public com.google.protobuf.ByteString getIssueModelsBytes(int index) {
    return issueModels_.getByteString(index);
  }

  public static final int RUN_SUMMARIZATION_ANNOTATOR_FIELD_NUMBER = 9;
  private boolean runSummarizationAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the summarization annotator.
   * </pre>
   *
   * <code>bool run_summarization_annotator = 9;</code>
   *
   * @return The runSummarizationAnnotator.
   */
  @java.lang.Override
  public boolean getRunSummarizationAnnotator() {
    return runSummarizationAnnotator_;
  }

  public static final int SUMMARIZATION_CONFIG_FIELD_NUMBER = 11;
  private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
      summarizationConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   *
   * @return Whether the summarizationConfig field is set.
   */
  @java.lang.Override
  public boolean hasSummarizationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   *
   * @return The summarizationConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
      getSummarizationConfig() {
    return summarizationConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .getDefaultInstance()
        : summarizationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfigOrBuilder
      getSummarizationConfigOrBuilder() {
    return summarizationConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
            .getDefaultInstance()
        : summarizationConfig_;
  }

  public static final int RUN_QA_ANNOTATOR_FIELD_NUMBER = 12;
  private boolean runQaAnnotator_ = false;
  /**
   *
   *
   * <pre>
   * Whether to run the QA annotator.
   * </pre>
   *
   * <code>bool run_qa_annotator = 12;</code>
   *
   * @return The runQaAnnotator.
   */
  @java.lang.Override
  public boolean getRunQaAnnotator() {
    return runQaAnnotator_;
  }

  public static final int QA_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qaConfig_;
  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   *
   * @return Whether the qaConfig field is set.
   */
  @java.lang.Override
  public boolean hasQaConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   *
   * @return The qaConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig getQaConfig() {
    return qaConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.getDefaultInstance()
        : qaConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder
      getQaConfigOrBuilder() {
    return qaConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.getDefaultInstance()
        : qaConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (runInterruptionAnnotator_ != false) {
      output.writeBool(1, runInterruptionAnnotator_);
    }
    if (runSilenceAnnotator_ != false) {
      output.writeBool(2, runSilenceAnnotator_);
    }
    if (runPhraseMatcherAnnotator_ != false) {
      output.writeBool(3, runPhraseMatcherAnnotator_);
    }
    for (int i = 0; i < phraseMatchers_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, phraseMatchers_.getRaw(i));
    }
    if (runSentimentAnnotator_ != false) {
      output.writeBool(5, runSentimentAnnotator_);
    }
    if (runEntityAnnotator_ != false) {
      output.writeBool(6, runEntityAnnotator_);
    }
    if (runIntentAnnotator_ != false) {
      output.writeBool(7, runIntentAnnotator_);
    }
    if (runIssueModelAnnotator_ != false) {
      output.writeBool(8, runIssueModelAnnotator_);
    }
    if (runSummarizationAnnotator_ != false) {
      output.writeBool(9, runSummarizationAnnotator_);
    }
    for (int i = 0; i < issueModels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, issueModels_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getSummarizationConfig());
    }
    if (runQaAnnotator_ != false) {
      output.writeBool(12, runQaAnnotator_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(13, getQaConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (runInterruptionAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, runInterruptionAnnotator_);
    }
    if (runSilenceAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, runSilenceAnnotator_);
    }
    if (runPhraseMatcherAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, runPhraseMatcherAnnotator_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < phraseMatchers_.size(); i++) {
        dataSize += computeStringSizeNoTag(phraseMatchers_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPhraseMatchersList().size();
    }
    if (runSentimentAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, runSentimentAnnotator_);
    }
    if (runEntityAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, runEntityAnnotator_);
    }
    if (runIntentAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, runIntentAnnotator_);
    }
    if (runIssueModelAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, runIssueModelAnnotator_);
    }
    if (runSummarizationAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, runSummarizationAnnotator_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < issueModels_.size(); i++) {
        dataSize += computeStringSizeNoTag(issueModels_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getIssueModelsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSummarizationConfig());
    }
    if (runQaAnnotator_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, runQaAnnotator_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getQaConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.AnnotatorSelector)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector other =
        (com.google.cloud.contactcenterinsights.v1.AnnotatorSelector) obj;

    if (getRunInterruptionAnnotator() != other.getRunInterruptionAnnotator()) return false;
    if (getRunSilenceAnnotator() != other.getRunSilenceAnnotator()) return false;
    if (getRunPhraseMatcherAnnotator() != other.getRunPhraseMatcherAnnotator()) return false;
    if (!getPhraseMatchersList().equals(other.getPhraseMatchersList())) return false;
    if (getRunSentimentAnnotator() != other.getRunSentimentAnnotator()) return false;
    if (getRunEntityAnnotator() != other.getRunEntityAnnotator()) return false;
    if (getRunIntentAnnotator() != other.getRunIntentAnnotator()) return false;
    if (getRunIssueModelAnnotator() != other.getRunIssueModelAnnotator()) return false;
    if (!getIssueModelsList().equals(other.getIssueModelsList())) return false;
    if (getRunSummarizationAnnotator() != other.getRunSummarizationAnnotator()) return false;
    if (hasSummarizationConfig() != other.hasSummarizationConfig()) return false;
    if (hasSummarizationConfig()) {
      if (!getSummarizationConfig().equals(other.getSummarizationConfig())) return false;
    }
    if (getRunQaAnnotator() != other.getRunQaAnnotator()) return false;
    if (hasQaConfig() != other.hasQaConfig()) return false;
    if (hasQaConfig()) {
      if (!getQaConfig().equals(other.getQaConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RUN_INTERRUPTION_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunInterruptionAnnotator());
    hash = (37 * hash) + RUN_SILENCE_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunSilenceAnnotator());
    hash = (37 * hash) + RUN_PHRASE_MATCHER_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunPhraseMatcherAnnotator());
    if (getPhraseMatchersCount() > 0) {
      hash = (37 * hash) + PHRASE_MATCHERS_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseMatchersList().hashCode();
    }
    hash = (37 * hash) + RUN_SENTIMENT_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunSentimentAnnotator());
    hash = (37 * hash) + RUN_ENTITY_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunEntityAnnotator());
    hash = (37 * hash) + RUN_INTENT_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunIntentAnnotator());
    hash = (37 * hash) + RUN_ISSUE_MODEL_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunIssueModelAnnotator());
    if (getIssueModelsCount() > 0) {
      hash = (37 * hash) + ISSUE_MODELS_FIELD_NUMBER;
      hash = (53 * hash) + getIssueModelsList().hashCode();
    }
    hash = (37 * hash) + RUN_SUMMARIZATION_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunSummarizationAnnotator());
    if (hasSummarizationConfig()) {
      hash = (37 * hash) + SUMMARIZATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSummarizationConfig().hashCode();
    }
    hash = (37 * hash) + RUN_QA_ANNOTATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRunQaAnnotator());
    if (hasQaConfig()) {
      hash = (37 * hash) + QA_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getQaConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelector prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Selector of all available annotators and phrase matchers to run.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.AnnotatorSelector}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.AnnotatorSelector)
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.class,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSummarizationConfigFieldBuilder();
        getQaConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      runInterruptionAnnotator_ = false;
      runSilenceAnnotator_ = false;
      runPhraseMatcherAnnotator_ = false;
      phraseMatchers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      runSentimentAnnotator_ = false;
      runEntityAnnotator_ = false;
      runIntentAnnotator_ = false;
      runIssueModelAnnotator_ = false;
      issueModels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      runSummarizationAnnotator_ = false;
      summarizationConfig_ = null;
      if (summarizationConfigBuilder_ != null) {
        summarizationConfigBuilder_.dispose();
        summarizationConfigBuilder_ = null;
      }
      runQaAnnotator_ = false;
      qaConfig_ = null;
      if (qaConfigBuilder_ != null) {
        qaConfigBuilder_.dispose();
        qaConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_AnnotatorSelector_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector build() {
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelector result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector buildPartial() {
      com.google.cloud.contactcenterinsights.v1.AnnotatorSelector result =
          new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.AnnotatorSelector result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.runInterruptionAnnotator_ = runInterruptionAnnotator_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.runSilenceAnnotator_ = runSilenceAnnotator_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.runPhraseMatcherAnnotator_ = runPhraseMatcherAnnotator_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        phraseMatchers_.makeImmutable();
        result.phraseMatchers_ = phraseMatchers_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.runSentimentAnnotator_ = runSentimentAnnotator_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.runEntityAnnotator_ = runEntityAnnotator_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.runIntentAnnotator_ = runIntentAnnotator_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.runIssueModelAnnotator_ = runIssueModelAnnotator_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        issueModels_.makeImmutable();
        result.issueModels_ = issueModels_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.runSummarizationAnnotator_ = runSummarizationAnnotator_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.summarizationConfig_ =
            summarizationConfigBuilder_ == null
                ? summarizationConfig_
                : summarizationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.runQaAnnotator_ = runQaAnnotator_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.qaConfig_ = qaConfigBuilder_ == null ? qaConfig_ : qaConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.AnnotatorSelector) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.AnnotatorSelector) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.AnnotatorSelector other) {
      if (other == com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance())
        return this;
      if (other.getRunInterruptionAnnotator() != false) {
        setRunInterruptionAnnotator(other.getRunInterruptionAnnotator());
      }
      if (other.getRunSilenceAnnotator() != false) {
        setRunSilenceAnnotator(other.getRunSilenceAnnotator());
      }
      if (other.getRunPhraseMatcherAnnotator() != false) {
        setRunPhraseMatcherAnnotator(other.getRunPhraseMatcherAnnotator());
      }
      if (!other.phraseMatchers_.isEmpty()) {
        if (phraseMatchers_.isEmpty()) {
          phraseMatchers_ = other.phraseMatchers_;
          bitField0_ |= 0x00000008;
        } else {
          ensurePhraseMatchersIsMutable();
          phraseMatchers_.addAll(other.phraseMatchers_);
        }
        onChanged();
      }
      if (other.getRunSentimentAnnotator() != false) {
        setRunSentimentAnnotator(other.getRunSentimentAnnotator());
      }
      if (other.getRunEntityAnnotator() != false) {
        setRunEntityAnnotator(other.getRunEntityAnnotator());
      }
      if (other.getRunIntentAnnotator() != false) {
        setRunIntentAnnotator(other.getRunIntentAnnotator());
      }
      if (other.getRunIssueModelAnnotator() != false) {
        setRunIssueModelAnnotator(other.getRunIssueModelAnnotator());
      }
      if (!other.issueModels_.isEmpty()) {
        if (issueModels_.isEmpty()) {
          issueModels_ = other.issueModels_;
          bitField0_ |= 0x00000100;
        } else {
          ensureIssueModelsIsMutable();
          issueModels_.addAll(other.issueModels_);
        }
        onChanged();
      }
      if (other.getRunSummarizationAnnotator() != false) {
        setRunSummarizationAnnotator(other.getRunSummarizationAnnotator());
      }
      if (other.hasSummarizationConfig()) {
        mergeSummarizationConfig(other.getSummarizationConfig());
      }
      if (other.getRunQaAnnotator() != false) {
        setRunQaAnnotator(other.getRunQaAnnotator());
      }
      if (other.hasQaConfig()) {
        mergeQaConfig(other.getQaConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                runInterruptionAnnotator_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                runSilenceAnnotator_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                runPhraseMatcherAnnotator_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePhraseMatchersIsMutable();
                phraseMatchers_.add(s);
                break;
              } // case 34
            case 40:
              {
                runSentimentAnnotator_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                runEntityAnnotator_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                runIntentAnnotator_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                runIssueModelAnnotator_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                runSummarizationAnnotator_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIssueModelsIsMutable();
                issueModels_.add(s);
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getSummarizationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 96:
              {
                runQaAnnotator_ = input.readBool();
                bitField0_ |= 0x00000800;
                break;
              } // case 96
            case 106:
              {
                input.readMessage(getQaConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean runInterruptionAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the interruption annotator.
     * </pre>
     *
     * <code>bool run_interruption_annotator = 1;</code>
     *
     * @return The runInterruptionAnnotator.
     */
    @java.lang.Override
    public boolean getRunInterruptionAnnotator() {
      return runInterruptionAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the interruption annotator.
     * </pre>
     *
     * <code>bool run_interruption_annotator = 1;</code>
     *
     * @param value The runInterruptionAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunInterruptionAnnotator(boolean value) {

      runInterruptionAnnotator_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the interruption annotator.
     * </pre>
     *
     * <code>bool run_interruption_annotator = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunInterruptionAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000001);
      runInterruptionAnnotator_ = false;
      onChanged();
      return this;
    }

    private boolean runSilenceAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the silence annotator.
     * </pre>
     *
     * <code>bool run_silence_annotator = 2;</code>
     *
     * @return The runSilenceAnnotator.
     */
    @java.lang.Override
    public boolean getRunSilenceAnnotator() {
      return runSilenceAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the silence annotator.
     * </pre>
     *
     * <code>bool run_silence_annotator = 2;</code>
     *
     * @param value The runSilenceAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunSilenceAnnotator(boolean value) {

      runSilenceAnnotator_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the silence annotator.
     * </pre>
     *
     * <code>bool run_silence_annotator = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunSilenceAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000002);
      runSilenceAnnotator_ = false;
      onChanged();
      return this;
    }

    private boolean runPhraseMatcherAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the active phrase matcher annotator(s).
     * </pre>
     *
     * <code>bool run_phrase_matcher_annotator = 3;</code>
     *
     * @return The runPhraseMatcherAnnotator.
     */
    @java.lang.Override
    public boolean getRunPhraseMatcherAnnotator() {
      return runPhraseMatcherAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the active phrase matcher annotator(s).
     * </pre>
     *
     * <code>bool run_phrase_matcher_annotator = 3;</code>
     *
     * @param value The runPhraseMatcherAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunPhraseMatcherAnnotator(boolean value) {

      runPhraseMatcherAnnotator_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the active phrase matcher annotator(s).
     * </pre>
     *
     * <code>bool run_phrase_matcher_annotator = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunPhraseMatcherAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000004);
      runPhraseMatcherAnnotator_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList phraseMatchers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePhraseMatchersIsMutable() {
      if (!phraseMatchers_.isModifiable()) {
        phraseMatchers_ = new com.google.protobuf.LazyStringArrayList(phraseMatchers_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the phraseMatchers.
     */
    public com.google.protobuf.ProtocolStringList getPhraseMatchersList() {
      phraseMatchers_.makeImmutable();
      return phraseMatchers_;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of phraseMatchers.
     */
    public int getPhraseMatchersCount() {
      return phraseMatchers_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The phraseMatchers at the given index.
     */
    public java.lang.String getPhraseMatchers(int index) {
      return phraseMatchers_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the phraseMatchers at the given index.
     */
    public com.google.protobuf.ByteString getPhraseMatchersBytes(int index) {
      return phraseMatchers_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The phraseMatchers to set.
     * @return This builder for chaining.
     */
    public Builder setPhraseMatchers(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseMatchersIsMutable();
      phraseMatchers_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The phraseMatchers to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseMatchers(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePhraseMatchersIsMutable();
      phraseMatchers_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The phraseMatchers to add.
     * @return This builder for chaining.
     */
    public Builder addAllPhraseMatchers(java.lang.Iterable<java.lang.String> values) {
      ensurePhraseMatchersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseMatchers_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhraseMatchers() {
      phraseMatchers_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of phrase matchers to run. If not provided, all active phrase
     * matchers will be used. If inactive phrase matchers are provided, they will
     * not be used. Phrase matchers will be run only if
     * run_phrase_matcher_annotator is set to true. Format:
     * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
     * </pre>
     *
     * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the phraseMatchers to add.
     * @return This builder for chaining.
     */
    public Builder addPhraseMatchersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePhraseMatchersIsMutable();
      phraseMatchers_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean runSentimentAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the sentiment annotator.
     * </pre>
     *
     * <code>bool run_sentiment_annotator = 5;</code>
     *
     * @return The runSentimentAnnotator.
     */
    @java.lang.Override
    public boolean getRunSentimentAnnotator() {
      return runSentimentAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the sentiment annotator.
     * </pre>
     *
     * <code>bool run_sentiment_annotator = 5;</code>
     *
     * @param value The runSentimentAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunSentimentAnnotator(boolean value) {

      runSentimentAnnotator_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the sentiment annotator.
     * </pre>
     *
     * <code>bool run_sentiment_annotator = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunSentimentAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000010);
      runSentimentAnnotator_ = false;
      onChanged();
      return this;
    }

    private boolean runEntityAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the entity annotator.
     * </pre>
     *
     * <code>bool run_entity_annotator = 6;</code>
     *
     * @return The runEntityAnnotator.
     */
    @java.lang.Override
    public boolean getRunEntityAnnotator() {
      return runEntityAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the entity annotator.
     * </pre>
     *
     * <code>bool run_entity_annotator = 6;</code>
     *
     * @param value The runEntityAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunEntityAnnotator(boolean value) {

      runEntityAnnotator_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the entity annotator.
     * </pre>
     *
     * <code>bool run_entity_annotator = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunEntityAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000020);
      runEntityAnnotator_ = false;
      onChanged();
      return this;
    }

    private boolean runIntentAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the intent annotator.
     * </pre>
     *
     * <code>bool run_intent_annotator = 7;</code>
     *
     * @return The runIntentAnnotator.
     */
    @java.lang.Override
    public boolean getRunIntentAnnotator() {
      return runIntentAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the intent annotator.
     * </pre>
     *
     * <code>bool run_intent_annotator = 7;</code>
     *
     * @param value The runIntentAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunIntentAnnotator(boolean value) {

      runIntentAnnotator_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the intent annotator.
     * </pre>
     *
     * <code>bool run_intent_annotator = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunIntentAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000040);
      runIntentAnnotator_ = false;
      onChanged();
      return this;
    }

    private boolean runIssueModelAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the issue model annotator. A model should have already been
     * deployed for this to take effect.
     * </pre>
     *
     * <code>bool run_issue_model_annotator = 8;</code>
     *
     * @return The runIssueModelAnnotator.
     */
    @java.lang.Override
    public boolean getRunIssueModelAnnotator() {
      return runIssueModelAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the issue model annotator. A model should have already been
     * deployed for this to take effect.
     * </pre>
     *
     * <code>bool run_issue_model_annotator = 8;</code>
     *
     * @param value The runIssueModelAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunIssueModelAnnotator(boolean value) {

      runIssueModelAnnotator_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the issue model annotator. A model should have already been
     * deployed for this to take effect.
     * </pre>
     *
     * <code>bool run_issue_model_annotator = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunIssueModelAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000080);
      runIssueModelAnnotator_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList issueModels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureIssueModelsIsMutable() {
      if (!issueModels_.isModifiable()) {
        issueModels_ = new com.google.protobuf.LazyStringArrayList(issueModels_);
      }
      bitField0_ |= 0x00000100;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return A list containing the issueModels.
     */
    public com.google.protobuf.ProtocolStringList getIssueModelsList() {
      issueModels_.makeImmutable();
      return issueModels_;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The count of issueModels.
     */
    public int getIssueModelsCount() {
      return issueModels_.size();
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the element to return.
     * @return The issueModels at the given index.
     */
    public java.lang.String getIssueModels(int index) {
      return issueModels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the issueModels at the given index.
     */
    public com.google.protobuf.ByteString getIssueModelsBytes(int index) {
      return issueModels_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param index The index to set the value at.
     * @param value The issueModels to set.
     * @return This builder for chaining.
     */
    public Builder setIssueModels(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssueModelsIsMutable();
      issueModels_.set(index, value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The issueModels to add.
     * @return This builder for chaining.
     */
    public Builder addIssueModels(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIssueModelsIsMutable();
      issueModels_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param values The issueModels to add.
     * @return This builder for chaining.
     */
    public Builder addAllIssueModels(java.lang.Iterable<java.lang.String> values) {
      ensureIssueModelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, issueModels_);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIssueModels() {
      issueModels_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The issue model to run. If not provided, the most recently deployed topic
     * model will be used. The provided issue model will only be used for
     * inference if the issue model is deployed and if run_issue_model_annotator
     * is set to true. If more than one issue model is provided, only the first
     * provided issue model will be used for inference.
     * </pre>
     *
     * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes of the issueModels to add.
     * @return This builder for chaining.
     */
    public Builder addIssueModelsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIssueModelsIsMutable();
      issueModels_.add(value);
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean runSummarizationAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the summarization annotator.
     * </pre>
     *
     * <code>bool run_summarization_annotator = 9;</code>
     *
     * @return The runSummarizationAnnotator.
     */
    @java.lang.Override
    public boolean getRunSummarizationAnnotator() {
      return runSummarizationAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the summarization annotator.
     * </pre>
     *
     * <code>bool run_summarization_annotator = 9;</code>
     *
     * @param value The runSummarizationAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunSummarizationAnnotator(boolean value) {

      runSummarizationAnnotator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the summarization annotator.
     * </pre>
     *
     * <code>bool run_summarization_annotator = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunSummarizationAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000200);
      runSummarizationAnnotator_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        summarizationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                .SummarizationConfigOrBuilder>
        summarizationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     *
     * @return Whether the summarizationConfig field is set.
     */
    public boolean hasSummarizationConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     *
     * @return The summarizationConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
        getSummarizationConfig() {
      if (summarizationConfigBuilder_ == null) {
        return summarizationConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                .getDefaultInstance()
            : summarizationConfig_;
      } else {
        return summarizationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public Builder setSummarizationConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig value) {
      if (summarizationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        summarizationConfig_ = value;
      } else {
        summarizationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public Builder setSummarizationConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.Builder
            builderForValue) {
      if (summarizationConfigBuilder_ == null) {
        summarizationConfig_ = builderForValue.build();
      } else {
        summarizationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public Builder mergeSummarizationConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig value) {
      if (summarizationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && summarizationConfig_ != null
            && summarizationConfig_
                != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                    .getDefaultInstance()) {
          getSummarizationConfigBuilder().mergeFrom(value);
        } else {
          summarizationConfig_ = value;
        }
      } else {
        summarizationConfigBuilder_.mergeFrom(value);
      }
      if (summarizationConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public Builder clearSummarizationConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      summarizationConfig_ = null;
      if (summarizationConfigBuilder_ != null) {
        summarizationConfigBuilder_.dispose();
        summarizationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.Builder
        getSummarizationConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getSummarizationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfigOrBuilder
        getSummarizationConfigOrBuilder() {
      if (summarizationConfigBuilder_ != null) {
        return summarizationConfigBuilder_.getMessageOrBuilder();
      } else {
        return summarizationConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                .getDefaultInstance()
            : summarizationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the summarization annotator.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                .SummarizationConfigOrBuilder>
        getSummarizationConfigFieldBuilder() {
      if (summarizationConfigBuilder_ == null) {
        summarizationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                    .SummarizationConfigOrBuilder>(
                getSummarizationConfig(), getParentForChildren(), isClean());
        summarizationConfig_ = null;
      }
      return summarizationConfigBuilder_;
    }

    private boolean runQaAnnotator_;
    /**
     *
     *
     * <pre>
     * Whether to run the QA annotator.
     * </pre>
     *
     * <code>bool run_qa_annotator = 12;</code>
     *
     * @return The runQaAnnotator.
     */
    @java.lang.Override
    public boolean getRunQaAnnotator() {
      return runQaAnnotator_;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the QA annotator.
     * </pre>
     *
     * <code>bool run_qa_annotator = 12;</code>
     *
     * @param value The runQaAnnotator to set.
     * @return This builder for chaining.
     */
    public Builder setRunQaAnnotator(boolean value) {

      runQaAnnotator_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to run the QA annotator.
     * </pre>
     *
     * <code>bool run_qa_annotator = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRunQaAnnotator() {
      bitField0_ = (bitField0_ & ~0x00000800);
      runQaAnnotator_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qaConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder>
        qaConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     *
     * @return Whether the qaConfig field is set.
     */
    public boolean hasQaConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     *
     * @return The qaConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig getQaConfig() {
      if (qaConfigBuilder_ == null) {
        return qaConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                .getDefaultInstance()
            : qaConfig_;
      } else {
        return qaConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public Builder setQaConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig value) {
      if (qaConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        qaConfig_ = value;
      } else {
        qaConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public Builder setQaConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder
            builderForValue) {
      if (qaConfigBuilder_ == null) {
        qaConfig_ = builderForValue.build();
      } else {
        qaConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public Builder mergeQaConfig(
        com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig value) {
      if (qaConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && qaConfig_ != null
            && qaConfig_
                != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                    .getDefaultInstance()) {
          getQaConfigBuilder().mergeFrom(value);
        } else {
          qaConfig_ = value;
        }
      } else {
        qaConfigBuilder_.mergeFrom(value);
      }
      if (qaConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public Builder clearQaConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      qaConfig_ = null;
      if (qaConfigBuilder_ != null) {
        qaConfigBuilder_.dispose();
        qaConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder
        getQaConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getQaConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder
        getQaConfigOrBuilder() {
      if (qaConfigBuilder_ != null) {
        return qaConfigBuilder_.getMessageOrBuilder();
      } else {
        return qaConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig
                .getDefaultInstance()
            : qaConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for the QA annotator.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder>
        getQaConfigFieldBuilder() {
      if (qaConfigBuilder_ == null) {
        qaConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder>(
                getQaConfig(), getParentForChildren(), isClean());
        qaConfig_ = null;
      }
      return qaConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.AnnotatorSelector)
  private static final com.google.cloud.contactcenterinsights.v1.AnnotatorSelector DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.AnnotatorSelector();
  }

  public static com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotatorSelector> PARSER =
      new com.google.protobuf.AbstractParser<AnnotatorSelector>() {
        @java.lang.Override
        public AnnotatorSelector parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotatorSelector> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotatorSelector> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
