/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

public interface AnnotatorSelectorOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.AnnotatorSelector)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Whether to run the interruption annotator.
   * </pre>
   *
   * <code>bool run_interruption_annotator = 1;</code>
   *
   * @return The runInterruptionAnnotator.
   */
  boolean getRunInterruptionAnnotator();

  /**
   *
   *
   * <pre>
   * Whether to run the silence annotator.
   * </pre>
   *
   * <code>bool run_silence_annotator = 2;</code>
   *
   * @return The runSilenceAnnotator.
   */
  boolean getRunSilenceAnnotator();

  /**
   *
   *
   * <pre>
   * Whether to run the active phrase matcher annotator(s).
   * </pre>
   *
   * <code>bool run_phrase_matcher_annotator = 3;</code>
   *
   * @return The runPhraseMatcherAnnotator.
   */
  boolean getRunPhraseMatcherAnnotator();

  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the phraseMatchers.
   */
  java.util.List<java.lang.String> getPhraseMatchersList();
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of phraseMatchers.
   */
  int getPhraseMatchersCount();
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The phraseMatchers at the given index.
   */
  java.lang.String getPhraseMatchers(int index);
  /**
   *
   *
   * <pre>
   * The list of phrase matchers to run. If not provided, all active phrase
   * matchers will be used. If inactive phrase matchers are provided, they will
   * not be used. Phrase matchers will be run only if
   * run_phrase_matcher_annotator is set to true. Format:
   * projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
   * </pre>
   *
   * <code>repeated string phrase_matchers = 4 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the phraseMatchers at the given index.
   */
  com.google.protobuf.ByteString getPhraseMatchersBytes(int index);

  /**
   *
   *
   * <pre>
   * Whether to run the sentiment annotator.
   * </pre>
   *
   * <code>bool run_sentiment_annotator = 5;</code>
   *
   * @return The runSentimentAnnotator.
   */
  boolean getRunSentimentAnnotator();

  /**
   *
   *
   * <pre>
   * Whether to run the entity annotator.
   * </pre>
   *
   * <code>bool run_entity_annotator = 6;</code>
   *
   * @return The runEntityAnnotator.
   */
  boolean getRunEntityAnnotator();

  /**
   *
   *
   * <pre>
   * Whether to run the intent annotator.
   * </pre>
   *
   * <code>bool run_intent_annotator = 7;</code>
   *
   * @return The runIntentAnnotator.
   */
  boolean getRunIntentAnnotator();

  /**
   *
   *
   * <pre>
   * Whether to run the issue model annotator. A model should have already been
   * deployed for this to take effect.
   * </pre>
   *
   * <code>bool run_issue_model_annotator = 8;</code>
   *
   * @return The runIssueModelAnnotator.
   */
  boolean getRunIssueModelAnnotator();

  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return A list containing the issueModels.
   */
  java.util.List<java.lang.String> getIssueModelsList();
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The count of issueModels.
   */
  int getIssueModelsCount();
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the element to return.
   * @return The issueModels at the given index.
   */
  java.lang.String getIssueModels(int index);
  /**
   *
   *
   * <pre>
   * The issue model to run. If not provided, the most recently deployed topic
   * model will be used. The provided issue model will only be used for
   * inference if the issue model is deployed and if run_issue_model_annotator
   * is set to true. If more than one issue model is provided, only the first
   * provided issue model will be used for inference.
   * </pre>
   *
   * <code>repeated string issue_models = 10 [(.google.api.resource_reference) = { ... }</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the issueModels at the given index.
   */
  com.google.protobuf.ByteString getIssueModelsBytes(int index);

  /**
   *
   *
   * <pre>
   * Whether to run the summarization annotator.
   * </pre>
   *
   * <code>bool run_summarization_annotator = 9;</code>
   *
   * @return The runSummarizationAnnotator.
   */
  boolean getRunSummarizationAnnotator();

  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   *
   * @return Whether the summarizationConfig field is set.
   */
  boolean hasSummarizationConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   *
   * @return The summarizationConfig.
   */
  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig
      getSummarizationConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the summarization annotator.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfig summarization_config = 11;
   * </code>
   */
  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.SummarizationConfigOrBuilder
      getSummarizationConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Whether to run the QA annotator.
   * </pre>
   *
   * <code>bool run_qa_annotator = 12;</code>
   *
   * @return The runQaAnnotator.
   */
  boolean getRunQaAnnotator();

  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   *
   * @return Whether the qaConfig field is set.
   */
  boolean hasQaConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   *
   * @return The qaConfig.
   */
  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig getQaConfig();
  /**
   *
   *
   * <pre>
   * Configuration for the QA annotator.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfig qa_config = 13;</code>
   */
  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.QaConfigOrBuilder
      getQaConfigOrBuilder();
}
