/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Metadata for the BulkDownloadFeedbackLabel endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata}
 */
public final class BulkDownloadFeedbackLabelsMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata)
    BulkDownloadFeedbackLabelsMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkDownloadFeedbackLabelsMetadata.newBuilder() to construct.
  private BulkDownloadFeedbackLabelsMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkDownloadFeedbackLabelsMetadata() {
    partialErrors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkDownloadFeedbackLabelsMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.class,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.Builder
                .class);
  }

  public interface DownloadStatsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The number of objects processed during the download operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1;</code>
     *
     * @return The processedObjectCount.
     */
    int getProcessedObjectCount();

    /**
     *
     *
     * <pre>
     * The number of new feedback labels downloaded during this operation.
     * Different from "processed" because some labels might not be downloaded
     * because an error.
     * </pre>
     *
     * <code>int32 successful_download_count = 2;</code>
     *
     * @return The successfulDownloadCount.
     */
    int getSuccessfulDownloadCount();

    /**
     *
     *
     * <pre>
     * Total number of files written to the provided Cloud Storage bucket.
     * </pre>
     *
     * <code>int32 total_files_written = 3;</code>
     *
     * @return The totalFilesWritten.
     */
    int getTotalFilesWritten();

    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the fileNames.
     */
    java.util.List<java.lang.String> getFileNamesList();
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of fileNames.
     */
    int getFileNamesCount();
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The fileNames at the given index.
     */
    java.lang.String getFileNames(int index);
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fileNames at the given index.
     */
    com.google.protobuf.ByteString getFileNamesBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Statistics for BulkDownloadFeedbackLabels operation.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats}
   */
  public static final class DownloadStats extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats)
      DownloadStatsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DownloadStats.newBuilder() to construct.
    private DownloadStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DownloadStats() {
      fileNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DownloadStats();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_DownloadStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_DownloadStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                  .DownloadStats.class,
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                  .DownloadStats.Builder.class);
    }

    public static final int PROCESSED_OBJECT_COUNT_FIELD_NUMBER = 1;
    private int processedObjectCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of objects processed during the download operation.
     * </pre>
     *
     * <code>int32 processed_object_count = 1;</code>
     *
     * @return The processedObjectCount.
     */
    @java.lang.Override
    public int getProcessedObjectCount() {
      return processedObjectCount_;
    }

    public static final int SUCCESSFUL_DOWNLOAD_COUNT_FIELD_NUMBER = 2;
    private int successfulDownloadCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of new feedback labels downloaded during this operation.
     * Different from "processed" because some labels might not be downloaded
     * because an error.
     * </pre>
     *
     * <code>int32 successful_download_count = 2;</code>
     *
     * @return The successfulDownloadCount.
     */
    @java.lang.Override
    public int getSuccessfulDownloadCount() {
      return successfulDownloadCount_;
    }

    public static final int TOTAL_FILES_WRITTEN_FIELD_NUMBER = 3;
    private int totalFilesWritten_ = 0;
    /**
     *
     *
     * <pre>
     * Total number of files written to the provided Cloud Storage bucket.
     * </pre>
     *
     * <code>int32 total_files_written = 3;</code>
     *
     * @return The totalFilesWritten.
     */
    @java.lang.Override
    public int getTotalFilesWritten() {
      return totalFilesWritten_;
    }

    public static final int FILE_NAMES_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList fileNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return A list containing the fileNames.
     */
    public com.google.protobuf.ProtocolStringList getFileNamesList() {
      return fileNames_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The count of fileNames.
     */
    public int getFileNamesCount() {
      return fileNames_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the element to return.
     * @return The fileNames at the given index.
     */
    public java.lang.String getFileNames(int index) {
      return fileNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Full name of the files written to Cloud storage.
     * </pre>
     *
     * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fileNames at the given index.
     */
    public com.google.protobuf.ByteString getFileNamesBytes(int index) {
      return fileNames_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (processedObjectCount_ != 0) {
        output.writeInt32(1, processedObjectCount_);
      }
      if (successfulDownloadCount_ != 0) {
        output.writeInt32(2, successfulDownloadCount_);
      }
      if (totalFilesWritten_ != 0) {
        output.writeInt32(3, totalFilesWritten_);
      }
      for (int i = 0; i < fileNames_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fileNames_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (processedObjectCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, processedObjectCount_);
      }
      if (successfulDownloadCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, successfulDownloadCount_);
      }
      if (totalFilesWritten_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, totalFilesWritten_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < fileNames_.size(); i++) {
          dataSize += computeStringSizeNoTag(fileNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFileNamesList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .DownloadStats)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
          other =
              (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                      .DownloadStats)
                  obj;

      if (getProcessedObjectCount() != other.getProcessedObjectCount()) return false;
      if (getSuccessfulDownloadCount() != other.getSuccessfulDownloadCount()) return false;
      if (getTotalFilesWritten() != other.getTotalFilesWritten()) return false;
      if (!getFileNamesList().equals(other.getFileNamesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROCESSED_OBJECT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getProcessedObjectCount();
      hash = (37 * hash) + SUCCESSFUL_DOWNLOAD_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getSuccessfulDownloadCount();
      hash = (37 * hash) + TOTAL_FILES_WRITTEN_FIELD_NUMBER;
      hash = (53 * hash) + getTotalFilesWritten();
      if (getFileNamesCount() > 0) {
        hash = (37 * hash) + FILE_NAMES_FIELD_NUMBER;
        hash = (53 * hash) + getFileNamesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats)
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_DownloadStats_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_DownloadStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats.class,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        processedObjectCount_ = 0;
        successfulDownloadCount_ = 0;
        totalFilesWritten_ = 0;
        fileNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_DownloadStats_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .DownloadStats
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .DownloadStats
          build() {
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .DownloadStats
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            result =
                new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.processedObjectCount_ = processedObjectCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.successfulDownloadCount_ = successfulDownloadCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.totalFilesWritten_ = totalFilesWritten_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          fileNames_.makeImmutable();
          result.fileNames_ = fileNames_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                      .DownloadStats)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats.getDefaultInstance()) return this;
        if (other.getProcessedObjectCount() != 0) {
          setProcessedObjectCount(other.getProcessedObjectCount());
        }
        if (other.getSuccessfulDownloadCount() != 0) {
          setSuccessfulDownloadCount(other.getSuccessfulDownloadCount());
        }
        if (other.getTotalFilesWritten() != 0) {
          setTotalFilesWritten(other.getTotalFilesWritten());
        }
        if (!other.fileNames_.isEmpty()) {
          if (fileNames_.isEmpty()) {
            fileNames_ = other.fileNames_;
            bitField0_ |= 0x00000008;
          } else {
            ensureFileNamesIsMutable();
            fileNames_.addAll(other.fileNames_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  processedObjectCount_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  successfulDownloadCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  totalFilesWritten_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureFileNamesIsMutable();
                  fileNames_.add(s);
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int processedObjectCount_;
      /**
       *
       *
       * <pre>
       * The number of objects processed during the download operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @return The processedObjectCount.
       */
      @java.lang.Override
      public int getProcessedObjectCount() {
        return processedObjectCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of objects processed during the download operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @param value The processedObjectCount to set.
       * @return This builder for chaining.
       */
      public Builder setProcessedObjectCount(int value) {

        processedObjectCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of objects processed during the download operation.
       * </pre>
       *
       * <code>int32 processed_object_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProcessedObjectCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        processedObjectCount_ = 0;
        onChanged();
        return this;
      }

      private int successfulDownloadCount_;
      /**
       *
       *
       * <pre>
       * The number of new feedback labels downloaded during this operation.
       * Different from "processed" because some labels might not be downloaded
       * because an error.
       * </pre>
       *
       * <code>int32 successful_download_count = 2;</code>
       *
       * @return The successfulDownloadCount.
       */
      @java.lang.Override
      public int getSuccessfulDownloadCount() {
        return successfulDownloadCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of new feedback labels downloaded during this operation.
       * Different from "processed" because some labels might not be downloaded
       * because an error.
       * </pre>
       *
       * <code>int32 successful_download_count = 2;</code>
       *
       * @param value The successfulDownloadCount to set.
       * @return This builder for chaining.
       */
      public Builder setSuccessfulDownloadCount(int value) {

        successfulDownloadCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of new feedback labels downloaded during this operation.
       * Different from "processed" because some labels might not be downloaded
       * because an error.
       * </pre>
       *
       * <code>int32 successful_download_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuccessfulDownloadCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        successfulDownloadCount_ = 0;
        onChanged();
        return this;
      }

      private int totalFilesWritten_;
      /**
       *
       *
       * <pre>
       * Total number of files written to the provided Cloud Storage bucket.
       * </pre>
       *
       * <code>int32 total_files_written = 3;</code>
       *
       * @return The totalFilesWritten.
       */
      @java.lang.Override
      public int getTotalFilesWritten() {
        return totalFilesWritten_;
      }
      /**
       *
       *
       * <pre>
       * Total number of files written to the provided Cloud Storage bucket.
       * </pre>
       *
       * <code>int32 total_files_written = 3;</code>
       *
       * @param value The totalFilesWritten to set.
       * @return This builder for chaining.
       */
      public Builder setTotalFilesWritten(int value) {

        totalFilesWritten_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of files written to the provided Cloud Storage bucket.
       * </pre>
       *
       * <code>int32 total_files_written = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTotalFilesWritten() {
        bitField0_ = (bitField0_ & ~0x00000004);
        totalFilesWritten_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList fileNames_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureFileNamesIsMutable() {
        if (!fileNames_.isModifiable()) {
          fileNames_ = new com.google.protobuf.LazyStringArrayList(fileNames_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return A list containing the fileNames.
       */
      public com.google.protobuf.ProtocolStringList getFileNamesList() {
        fileNames_.makeImmutable();
        return fileNames_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The count of fileNames.
       */
      public int getFileNamesCount() {
        return fileNames_.size();
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the element to return.
       * @return The fileNames at the given index.
       */
      public java.lang.String getFileNames(int index) {
        return fileNames_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the fileNames at the given index.
       */
      public com.google.protobuf.ByteString getFileNamesBytes(int index) {
        return fileNames_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param index The index to set the value at.
       * @param value The fileNames to set.
       * @return This builder for chaining.
       */
      public Builder setFileNames(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileNamesIsMutable();
        fileNames_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The fileNames to add.
       * @return This builder for chaining.
       */
      public Builder addFileNames(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFileNamesIsMutable();
        fileNames_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param values The fileNames to add.
       * @return This builder for chaining.
       */
      public Builder addAllFileNames(java.lang.Iterable<java.lang.String> values) {
        ensureFileNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileNames_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFileNames() {
        fileNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full name of the files written to Cloud storage.
       * </pre>
       *
       * <code>repeated string file_names = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes of the fileNames to add.
       * @return This builder for chaining.
       */
      public Builder addFileNamesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureFileNamesIsMutable();
        fileNames_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats)
    private static final com.google.cloud.contactcenterinsights.v1
            .BulkDownloadFeedbackLabelsMetadata.DownloadStats
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .DownloadStats();
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DownloadStats> PARSER =
        new com.google.protobuf.AbstractParser<DownloadStats>() {
          @java.lang.Override
          public DownloadStats parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DownloadStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DownloadStats> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request_;
  /**
   *
   *
   * <pre>
   * Output only. The original request for download.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for download.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest getRequest() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request for download.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequestOrBuilder
      getRequestOrBuilder() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .getDefaultInstance()
        : request_;
  }

  public static final int PARTIAL_ERRORS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> partialErrors_;
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getPartialErrorsOrBuilderList() {
    return partialErrors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public int getPartialErrorsCount() {
    return partialErrors_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialErrors(int index) {
    return partialErrors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial errors during ingest operation that might cause the operation
   * output to be incomplete.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_errors = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
    return partialErrors_.get(index);
  }

  public static final int DOWNLOAD_STATS_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
      downloadStats_;
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkDownloadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the downloadStats field is set.
   */
  @java.lang.Override
  public boolean hasDownloadStats() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkDownloadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The downloadStats.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
      getDownloadStats() {
    return downloadStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            .getDefaultInstance()
        : downloadStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Statistics for BulkDownloadFeedbackLabels operation.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
          .DownloadStatsOrBuilder
      getDownloadStatsOrBuilder() {
    return downloadStats_ == null
        ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            .getDefaultInstance()
        : downloadStats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      output.writeMessage(4, partialErrors_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(5, getDownloadStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    for (int i = 0; i < partialErrors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, partialErrors_.get(i));
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDownloadStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata other =
        (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (!getPartialErrorsList().equals(other.getPartialErrorsList())) return false;
    if (hasDownloadStats() != other.hasDownloadStats()) return false;
    if (hasDownloadStats()) {
      if (!getDownloadStats().equals(other.getDownloadStats())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (getPartialErrorsCount() > 0) {
      hash = (37 * hash) + PARTIAL_ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getPartialErrorsList().hashCode();
    }
    if (hasDownloadStats()) {
      hash = (37 * hash) + DOWNLOAD_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getDownloadStats().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for the BulkDownloadFeedbackLabel endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata)
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.class,
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getRequestFieldBuilder();
        getPartialErrorsFieldBuilder();
        getDownloadStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
      } else {
        partialErrors_ = null;
        partialErrorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      downloadStats_ = null;
      if (downloadStatsBuilder_ != null) {
        downloadStatsBuilder_.dispose();
        downloadStatsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata build() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata result =
          new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata result) {
      if (partialErrorsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          partialErrors_ = java.util.Collections.unmodifiableList(partialErrors_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.partialErrors_ = partialErrors_;
      } else {
        result.partialErrors_ = partialErrorsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.downloadStats_ =
            downloadStatsBuilder_ == null ? downloadStats_ : downloadStatsBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
              .getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (partialErrorsBuilder_ == null) {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrors_.isEmpty()) {
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensurePartialErrorsIsMutable();
            partialErrors_.addAll(other.partialErrors_);
          }
          onChanged();
        }
      } else {
        if (!other.partialErrors_.isEmpty()) {
          if (partialErrorsBuilder_.isEmpty()) {
            partialErrorsBuilder_.dispose();
            partialErrorsBuilder_ = null;
            partialErrors_ = other.partialErrors_;
            bitField0_ = (bitField0_ & ~0x00000008);
            partialErrorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialErrorsFieldBuilder()
                    : null;
          } else {
            partialErrorsBuilder_.addAllMessages(other.partialErrors_);
          }
        }
      }
      if (other.hasDownloadStats()) {
        mergeDownloadStats(other.getDownloadStats());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (partialErrorsBuilder_ == null) {
                  ensurePartialErrorsIsMutable();
                  partialErrors_.add(m);
                } else {
                  partialErrorsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getDownloadStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The request.
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
        getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder
            builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRequest(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_
                != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder
        getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequestOrBuilder
        getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request for download.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder,
                com.google.cloud.contactcenterinsights.v1
                    .BulkDownloadFeedbackLabelsRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private java.util.List<com.google.rpc.Status> partialErrors_ =
        java.util.Collections.emptyList();

    private void ensurePartialErrorsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        partialErrors_ = new java.util.ArrayList<com.google.rpc.Status>(partialErrors_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialErrorsBuilder_;

    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialErrorsList() {
      if (partialErrorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialErrors_);
      } else {
        return partialErrorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public int getPartialErrorsCount() {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.size();
      } else {
        return partialErrorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status getPartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder setPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status value) {
      if (partialErrorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, value);
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addPartialErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialErrorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder addAllPartialErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialErrors_);
        onChanged();
      } else {
        partialErrorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder clearPartialErrors() {
      if (partialErrorsBuilder_ == null) {
        partialErrors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        partialErrorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public Builder removePartialErrors(int index) {
      if (partialErrorsBuilder_ == null) {
        ensurePartialErrorsIsMutable();
        partialErrors_.remove(index);
        onChanged();
      } else {
        partialErrorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder getPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialErrorsOrBuilder(int index) {
      if (partialErrorsBuilder_ == null) {
        return partialErrors_.get(index);
      } else {
        return partialErrorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialErrorsOrBuilderList() {
      if (partialErrorsBuilder_ != null) {
        return partialErrorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialErrors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder() {
      return getPartialErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public com.google.rpc.Status.Builder addPartialErrorsBuilder(int index) {
      return getPartialErrorsFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors during ingest operation that might cause the operation
     * output to be incomplete.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_errors = 4;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialErrorsBuilderList() {
      return getPartialErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialErrorsFieldBuilder() {
      if (partialErrorsBuilder_ == null) {
        partialErrorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialErrors_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        partialErrors_ = null;
      }
      return partialErrorsBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        downloadStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStatsOrBuilder>
        downloadStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the downloadStats field is set.
     */
    public boolean hasDownloadStats() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The downloadStats.
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats
        getDownloadStats() {
      if (downloadStatsBuilder_ == null) {
        return downloadStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats.getDefaultInstance()
            : downloadStats_;
      } else {
        return downloadStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDownloadStats(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            value) {
      if (downloadStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        downloadStats_ = value;
      } else {
        downloadStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDownloadStats(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
                .Builder
            builderForValue) {
      if (downloadStatsBuilder_ == null) {
        downloadStats_ = builderForValue.build();
      } else {
        downloadStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDownloadStats(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats
            value) {
      if (downloadStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && downloadStats_ != null
            && downloadStats_
                != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats.getDefaultInstance()) {
          getDownloadStatsBuilder().mergeFrom(value);
        } else {
          downloadStats_ = value;
        }
      } else {
        downloadStatsBuilder_.mergeFrom(value);
      }
      if (downloadStats_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDownloadStats() {
      bitField0_ = (bitField0_ & ~0x00000010);
      downloadStats_ = null;
      if (downloadStatsBuilder_ != null) {
        downloadStatsBuilder_.dispose();
        downloadStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStats.Builder
        getDownloadStatsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDownloadStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
            .DownloadStatsOrBuilder
        getDownloadStatsOrBuilder() {
      if (downloadStatsBuilder_ != null) {
        return downloadStatsBuilder_.getMessageOrBuilder();
      } else {
        return downloadStats_ == null
            ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats.getDefaultInstance()
            : downloadStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Statistics for BulkDownloadFeedbackLabels operation.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata.DownloadStats download_stats = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStats.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                .DownloadStatsOrBuilder>
        getDownloadStatsFieldBuilder() {
      if (downloadStatsBuilder_ == null) {
        downloadStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStats.Builder,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
                    .DownloadStatsOrBuilder>(getDownloadStats(), getParentForChildren(), isClean());
        downloadStats_ = null;
      }
      return downloadStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata)
  private static final com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata();
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkDownloadFeedbackLabelsMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BulkDownloadFeedbackLabelsMetadata>() {
        @java.lang.Override
        public BulkDownloadFeedbackLabelsMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkDownloadFeedbackLabelsMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkDownloadFeedbackLabelsMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
