/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Request for the BulkDownloadFeedbackLabel endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest}
 */
public final class BulkDownloadFeedbackLabelsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest)
    BulkDownloadFeedbackLabelsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkDownloadFeedbackLabelsRequest.newBuilder() to construct.
  private BulkDownloadFeedbackLabelsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkDownloadFeedbackLabelsRequest() {
    parent_ = "";
    filter_ = "";
    feedbackLabelType_ = 0;
    conversationFilter_ = "";
    templateQaScorecardId_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkDownloadFeedbackLabelsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.class,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder
                .class);
  }

  /**
   *
   *
   * <pre>
   * Possible feedback label types that will be downloaded.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType}
   */
  public enum FeedbackLabelType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified format
     * </pre>
     *
     * <code>FEEDBACK_LABEL_TYPE_UNSPECIFIED = 0;</code>
     */
    FEEDBACK_LABEL_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Downloaded file will contain all Quality AI labels from the latest
     * scorecard revision.
     * </pre>
     *
     * <code>QUALITY_AI = 1;</code>
     */
    QUALITY_AI(1),
    /**
     *
     *
     * <pre>
     * Downloaded file will contain only Topic Modeling labels.
     * </pre>
     *
     * <code>TOPIC_MODELING = 2;</code>
     */
    TOPIC_MODELING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified format
     * </pre>
     *
     * <code>FEEDBACK_LABEL_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int FEEDBACK_LABEL_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Downloaded file will contain all Quality AI labels from the latest
     * scorecard revision.
     * </pre>
     *
     * <code>QUALITY_AI = 1;</code>
     */
    public static final int QUALITY_AI_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Downloaded file will contain only Topic Modeling labels.
     * </pre>
     *
     * <code>TOPIC_MODELING = 2;</code>
     */
    public static final int TOPIC_MODELING_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FeedbackLabelType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static FeedbackLabelType forNumber(int value) {
      switch (value) {
        case 0:
          return FEEDBACK_LABEL_TYPE_UNSPECIFIED;
        case 1:
          return QUALITY_AI;
        case 2:
          return TOPIC_MODELING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FeedbackLabelType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<FeedbackLabelType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FeedbackLabelType>() {
              public FeedbackLabelType findValueByNumber(int number) {
                return FeedbackLabelType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
          .getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final FeedbackLabelType[] VALUES = values();

    public static FeedbackLabelType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private FeedbackLabelType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType)
  }

  public interface GcsDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. File format in which the labels will be exported.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    int getFormatValue();
    /**
     *
     *
     * <pre>
     * Required. File format in which the labels will be exported.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The format.
     */
    com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            .Format
        getFormat();

    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI to write the feedback labels to.
     * The file name will be used as a prefix for the files written to the
     * bucket if the output needs to be split across multiple files, otherwise
     * it will be used as is. The file extension will be appended to the file
     * name based on the format selected.
     *  E.g. `gs://bucket_name/object_uri_prefix`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The objectUri.
     */
    java.lang.String getObjectUri();
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI to write the feedback labels to.
     * The file name will be used as a prefix for the files written to the
     * bucket if the output needs to be split across multiple files, otherwise
     * it will be used as is. The file extension will be appended to the file
     * name based on the format selected.
     *  E.g. `gs://bucket_name/object_uri_prefix`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for objectUri.
     */
    com.google.protobuf.ByteString getObjectUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. Add whitespace to the JSON file. Makes easier to read, but
     * increases file size. Only applicable for JSON format.
     * </pre>
     *
     * <code>bool add_whitespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The addWhitespace.
     */
    boolean getAddWhitespace();

    /**
     *
     *
     * <pre>
     * Optional. Always print fields with no presence.
     * This is useful for printing fields that are not set, like implicit 0
     * value or empty lists/maps. Only applicable for JSON format.
     * </pre>
     *
     * <code>bool always_print_empty_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alwaysPrintEmptyFields.
     */
    boolean getAlwaysPrintEmptyFields();

    /**
     *
     *
     * <pre>
     * Optional. The number of records per file. Applicable for either format.
     * </pre>
     *
     * <code>int64 records_per_file_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The recordsPerFileCount.
     */
    long getRecordsPerFileCount();
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage Object details to write the feedback labels to.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination}
   */
  public static final class GcsDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination)
      GcsDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsDestination.newBuilder() to construct.
    private GcsDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsDestination() {
      format_ = 0;
      objectUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_GcsDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_GcsDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination.class,
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * All permissible file formats.
     * See `records_per_file_count` to override the default number of records
     * per file.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format}
     */
    public enum Format implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified format.
       * </pre>
       *
       * <code>FORMAT_UNSPECIFIED = 0;</code>
       */
      FORMAT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * CSV format.
       * 1,000 labels are stored per CSV file by default.
       * </pre>
       *
       * <code>CSV = 1;</code>
       */
      CSV(1),
      /**
       *
       *
       * <pre>
       * JSON format.
       * 1 label stored per JSON file by default.
       * </pre>
       *
       * <code>JSON = 2;</code>
       */
      JSON(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified format.
       * </pre>
       *
       * <code>FORMAT_UNSPECIFIED = 0;</code>
       */
      public static final int FORMAT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * CSV format.
       * 1,000 labels are stored per CSV file by default.
       * </pre>
       *
       * <code>CSV = 1;</code>
       */
      public static final int CSV_VALUE = 1;
      /**
       *
       *
       * <pre>
       * JSON format.
       * 1 label stored per JSON file by default.
       * </pre>
       *
       * <code>JSON = 2;</code>
       */
      public static final int JSON_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Format valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Format forNumber(int value) {
        switch (value) {
          case 0:
            return FORMAT_UNSPECIFIED;
          case 1:
            return CSV;
          case 2:
            return JSON;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Format> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Format> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Format>() {
            public Format findValueByNumber(int number) {
              return Format.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Format[] VALUES = values();

      public static Format valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Format(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format)
    }

    public static final int FORMAT_FIELD_NUMBER = 1;
    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * Required. File format in which the labels will be exported.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Required. File format in which the labels will be exported.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.Format
        getFormat() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
              .Format
          result =
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination.Format.forNumber(format_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination.Format.UNRECOGNIZED
          : result;
    }

    public static final int OBJECT_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object objectUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI to write the feedback labels to.
     * The file name will be used as a prefix for the files written to the
     * bucket if the output needs to be split across multiple files, otherwise
     * it will be used as is. The file extension will be appended to the file
     * name based on the format selected.
     *  E.g. `gs://bucket_name/object_uri_prefix`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The objectUri.
     */
    @java.lang.Override
    public java.lang.String getObjectUri() {
      java.lang.Object ref = objectUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI to write the feedback labels to.
     * The file name will be used as a prefix for the files written to the
     * bucket if the output needs to be split across multiple files, otherwise
     * it will be used as is. The file extension will be appended to the file
     * name based on the format selected.
     *  E.g. `gs://bucket_name/object_uri_prefix`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for objectUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectUriBytes() {
      java.lang.Object ref = objectUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADD_WHITESPACE_FIELD_NUMBER = 3;
    private boolean addWhitespace_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Add whitespace to the JSON file. Makes easier to read, but
     * increases file size. Only applicable for JSON format.
     * </pre>
     *
     * <code>bool add_whitespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The addWhitespace.
     */
    @java.lang.Override
    public boolean getAddWhitespace() {
      return addWhitespace_;
    }

    public static final int ALWAYS_PRINT_EMPTY_FIELDS_FIELD_NUMBER = 4;
    private boolean alwaysPrintEmptyFields_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Always print fields with no presence.
     * This is useful for printing fields that are not set, like implicit 0
     * value or empty lists/maps. Only applicable for JSON format.
     * </pre>
     *
     * <code>bool always_print_empty_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alwaysPrintEmptyFields.
     */
    @java.lang.Override
    public boolean getAlwaysPrintEmptyFields() {
      return alwaysPrintEmptyFields_;
    }

    public static final int RECORDS_PER_FILE_COUNT_FIELD_NUMBER = 5;
    private long recordsPerFileCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Optional. The number of records per file. Applicable for either format.
     * </pre>
     *
     * <code>int64 records_per_file_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The recordsPerFileCount.
     */
    @java.lang.Override
    public long getRecordsPerFileCount() {
      return recordsPerFileCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (format_
          != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination.Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectUri_);
      }
      if (addWhitespace_ != false) {
        output.writeBool(3, addWhitespace_);
      }
      if (alwaysPrintEmptyFields_ != false) {
        output.writeBool(4, alwaysPrintEmptyFields_);
      }
      if (recordsPerFileCount_ != 0L) {
        output.writeInt64(5, recordsPerFileCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (format_
          != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination.Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectUri_);
      }
      if (addWhitespace_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, addWhitespace_);
      }
      if (alwaysPrintEmptyFields_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, alwaysPrintEmptyFields_);
      }
      if (recordsPerFileCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, recordsPerFileCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
          other =
              (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                      .GcsDestination)
                  obj;

      if (format_ != other.format_) return false;
      if (!getObjectUri().equals(other.getObjectUri())) return false;
      if (getAddWhitespace() != other.getAddWhitespace()) return false;
      if (getAlwaysPrintEmptyFields() != other.getAlwaysPrintEmptyFields()) return false;
      if (getRecordsPerFileCount() != other.getRecordsPerFileCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + format_;
      hash = (37 * hash) + OBJECT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getObjectUri().hashCode();
      hash = (37 * hash) + ADD_WHITESPACE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAddWhitespace());
      hash = (37 * hash) + ALWAYS_PRINT_EMPTY_FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAlwaysPrintEmptyFields());
      hash = (37 * hash) + RECORDS_PER_FILE_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRecordsPerFileCount());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage Object details to write the feedback labels to.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination)
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_GcsDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_GcsDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination.class,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        format_ = 0;
        objectUri_ = "";
        addWhitespace_ = false;
        alwaysPrintEmptyFields_ = false;
        recordsPerFileCount_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_GcsDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination
          build() {
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            result =
                new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.format_ = format_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.objectUri_ = objectUri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.addWhitespace_ = addWhitespace_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.alwaysPrintEmptyFields_ = alwaysPrintEmptyFields_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.recordsPerFileCount_ = recordsPerFileCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                      .GcsDestination)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination.getDefaultInstance()) return this;
        if (other.format_ != 0) {
          setFormatValue(other.getFormatValue());
        }
        if (!other.getObjectUri().isEmpty()) {
          objectUri_ = other.objectUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getAddWhitespace() != false) {
          setAddWhitespace(other.getAddWhitespace());
        }
        if (other.getAlwaysPrintEmptyFields() != false) {
          setAlwaysPrintEmptyFields(other.getAlwaysPrintEmptyFields());
        }
        if (other.getRecordsPerFileCount() != 0L) {
          setRecordsPerFileCount(other.getRecordsPerFileCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  format_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  objectUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  addWhitespace_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 32:
                {
                  alwaysPrintEmptyFields_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 40:
                {
                  recordsPerFileCount_ = input.readInt64();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int format_ = 0;
      /**
       *
       *
       * <pre>
       * Required. File format in which the labels will be exported.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for format.
       */
      @java.lang.Override
      public int getFormatValue() {
        return format_;
      }
      /**
       *
       *
       * <pre>
       * Required. File format in which the labels will be exported.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for format to set.
       * @return This builder for chaining.
       */
      public Builder setFormatValue(int value) {
        format_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. File format in which the labels will be exported.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The format.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination.Format
          getFormat() {
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
                .Format
            result =
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination.Format.forNumber(format_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination.Format.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. File format in which the labels will be exported.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The format to set.
       * @return This builder for chaining.
       */
      public Builder setFormat(
          com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
                  .Format
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        format_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. File format in which the labels will be exported.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFormat() {
        bitField0_ = (bitField0_ & ~0x00000001);
        format_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object objectUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI to write the feedback labels to.
       * The file name will be used as a prefix for the files written to the
       * bucket if the output needs to be split across multiple files, otherwise
       * it will be used as is. The file extension will be appended to the file
       * name based on the format selected.
       *  E.g. `gs://bucket_name/object_uri_prefix`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The objectUri.
       */
      public java.lang.String getObjectUri() {
        java.lang.Object ref = objectUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          objectUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI to write the feedback labels to.
       * The file name will be used as a prefix for the files written to the
       * bucket if the output needs to be split across multiple files, otherwise
       * it will be used as is. The file extension will be appended to the file
       * name based on the format selected.
       *  E.g. `gs://bucket_name/object_uri_prefix`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for objectUri.
       */
      public com.google.protobuf.ByteString getObjectUriBytes() {
        java.lang.Object ref = objectUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          objectUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI to write the feedback labels to.
       * The file name will be used as a prefix for the files written to the
       * bucket if the output needs to be split across multiple files, otherwise
       * it will be used as is. The file extension will be appended to the file
       * name based on the format selected.
       *  E.g. `gs://bucket_name/object_uri_prefix`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The objectUri to set.
       * @return This builder for chaining.
       */
      public Builder setObjectUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI to write the feedback labels to.
       * The file name will be used as a prefix for the files written to the
       * bucket if the output needs to be split across multiple files, otherwise
       * it will be used as is. The file extension will be appended to the file
       * name based on the format selected.
       *  E.g. `gs://bucket_name/object_uri_prefix`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjectUri() {
        objectUri_ = getDefaultInstance().getObjectUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI to write the feedback labels to.
       * The file name will be used as a prefix for the files written to the
       * bucket if the output needs to be split across multiple files, otherwise
       * it will be used as is. The file extension will be appended to the file
       * name based on the format selected.
       *  E.g. `gs://bucket_name/object_uri_prefix`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for objectUri to set.
       * @return This builder for chaining.
       */
      public Builder setObjectUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        objectUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean addWhitespace_;
      /**
       *
       *
       * <pre>
       * Optional. Add whitespace to the JSON file. Makes easier to read, but
       * increases file size. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool add_whitespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The addWhitespace.
       */
      @java.lang.Override
      public boolean getAddWhitespace() {
        return addWhitespace_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Add whitespace to the JSON file. Makes easier to read, but
       * increases file size. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool add_whitespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The addWhitespace to set.
       * @return This builder for chaining.
       */
      public Builder setAddWhitespace(boolean value) {

        addWhitespace_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Add whitespace to the JSON file. Makes easier to read, but
       * increases file size. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool add_whitespace = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAddWhitespace() {
        bitField0_ = (bitField0_ & ~0x00000004);
        addWhitespace_ = false;
        onChanged();
        return this;
      }

      private boolean alwaysPrintEmptyFields_;
      /**
       *
       *
       * <pre>
       * Optional. Always print fields with no presence.
       * This is useful for printing fields that are not set, like implicit 0
       * value or empty lists/maps. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool always_print_empty_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alwaysPrintEmptyFields.
       */
      @java.lang.Override
      public boolean getAlwaysPrintEmptyFields() {
        return alwaysPrintEmptyFields_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Always print fields with no presence.
       * This is useful for printing fields that are not set, like implicit 0
       * value or empty lists/maps. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool always_print_empty_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The alwaysPrintEmptyFields to set.
       * @return This builder for chaining.
       */
      public Builder setAlwaysPrintEmptyFields(boolean value) {

        alwaysPrintEmptyFields_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Always print fields with no presence.
       * This is useful for printing fields that are not set, like implicit 0
       * value or empty lists/maps. Only applicable for JSON format.
       * </pre>
       *
       * <code>bool always_print_empty_fields = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlwaysPrintEmptyFields() {
        bitField0_ = (bitField0_ & ~0x00000008);
        alwaysPrintEmptyFields_ = false;
        onChanged();
        return this;
      }

      private long recordsPerFileCount_;
      /**
       *
       *
       * <pre>
       * Optional. The number of records per file. Applicable for either format.
       * </pre>
       *
       * <code>int64 records_per_file_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The recordsPerFileCount.
       */
      @java.lang.Override
      public long getRecordsPerFileCount() {
        return recordsPerFileCount_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of records per file. Applicable for either format.
       * </pre>
       *
       * <code>int64 records_per_file_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The recordsPerFileCount to set.
       * @return This builder for chaining.
       */
      public Builder setRecordsPerFileCount(long value) {

        recordsPerFileCount_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The number of records per file. Applicable for either format.
       * </pre>
       *
       * <code>int64 records_per_file_count = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecordsPerFileCount() {
        bitField0_ = (bitField0_ & ~0x00000010);
        recordsPerFileCount_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination)
    private static final com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination();
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsDestination> PARSER =
        new com.google.protobuf.AbstractParser<GcsDestination>() {
          @java.lang.Override
          public GcsDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(3),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 3:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * A cloud storage bucket destination.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
   * </code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket destination.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
   * </code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
      getGcsDestination() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination)
          destination_;
    }
    return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
        .GcsDestination.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket destination.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
          .GcsDestinationOrBuilder
      getGcsDestinationOrBuilder() {
    if (destinationCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .GcsDestination)
          destination_;
    }
    return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
        .GcsDestination.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new feedback labels.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new feedback labels.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A filter to reduce results to a specific subset. Supports
   * disjunctions (OR) and conjunctions (AND).
   *
   * Supported fields:
   *
   * * `issue_model_id`
   * * `qa_question_id`
   * * `qa_scorecard_id`
   * * `min_create_time`
   * * `max_create_time`
   * * `min_update_time`
   * * `max_update_time`
   * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A filter to reduce results to a specific subset. Supports
   * disjunctions (OR) and conjunctions (AND).
   *
   * Supported fields:
   *
   * * `issue_model_id`
   * * `qa_question_id`
   * * `qa_scorecard_id`
   * * `min_create_time`
   * * `max_create_time`
   * * `min_update_time`
   * * `max_update_time`
   * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_DOWNLOAD_COUNT_FIELD_NUMBER = 4;
  private int maxDownloadCount_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. Limits the maximum number of feedback labels that will be
   * downloaded. The first `N` feedback labels will be downloaded.
   * </pre>
   *
   * <code>int32 max_download_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxDownloadCount.
   */
  @java.lang.Override
  public int getMaxDownloadCount() {
    return maxDownloadCount_;
  }

  public static final int FEEDBACK_LABEL_TYPE_FIELD_NUMBER = 5;
  private int feedbackLabelType_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. The type of feedback labels that will be downloaded.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for feedbackLabelType.
   */
  @java.lang.Override
  public int getFeedbackLabelTypeValue() {
    return feedbackLabelType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of feedback labels that will be downloaded.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The feedbackLabelType.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
          .FeedbackLabelType
      getFeedbackLabelType() {
    com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType
        result =
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .FeedbackLabelType.forNumber(feedbackLabelType_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .FeedbackLabelType.UNRECOGNIZED
        : result;
  }

  public static final int CONVERSATION_FILTER_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversationFilter_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Filter parent conversations to download feedback labels for.
   * When specified, the feedback labels will be downloaded for the
   * conversations that match the filter.
   * If `template_qa_scorecard_id` is set, all the conversations that match the
   * filter will be paired with the questions under the scorecard for labeling.
   * </pre>
   *
   * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The conversationFilter.
   */
  @java.lang.Override
  public java.lang.String getConversationFilter() {
    java.lang.Object ref = conversationFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversationFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Filter parent conversations to download feedback labels for.
   * When specified, the feedback labels will be downloaded for the
   * conversations that match the filter.
   * If `template_qa_scorecard_id` is set, all the conversations that match the
   * filter will be paired with the questions under the scorecard for labeling.
   * </pre>
   *
   * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for conversationFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationFilterBytes() {
    java.lang.Object ref = conversationFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversationFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_QA_SCORECARD_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList templateQaScorecardId_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. If set, a template for labeling conversations and scorecard
   * questions will be created from the conversation_filter and the questions
   * under the scorecard(s). The feedback label `filter` will be ignored.
   * </pre>
   *
   * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the templateQaScorecardId.
   */
  public com.google.protobuf.ProtocolStringList getTemplateQaScorecardIdList() {
    return templateQaScorecardId_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, a template for labeling conversations and scorecard
   * questions will be created from the conversation_filter and the questions
   * under the scorecard(s). The feedback label `filter` will be ignored.
   * </pre>
   *
   * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of templateQaScorecardId.
   */
  public int getTemplateQaScorecardIdCount() {
    return templateQaScorecardId_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, a template for labeling conversations and scorecard
   * questions will be created from the conversation_filter and the questions
   * under the scorecard(s). The feedback label `filter` will be ignored.
   * </pre>
   *
   * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The templateQaScorecardId at the given index.
   */
  public java.lang.String getTemplateQaScorecardId(int index) {
    return templateQaScorecardId_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, a template for labeling conversations and scorecard
   * questions will be created from the conversation_filter and the questions
   * under the scorecard(s). The feedback label `filter` will be ignored.
   * </pre>
   *
   * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the templateQaScorecardId at the given index.
   */
  public com.google.protobuf.ByteString getTemplateQaScorecardIdBytes(int index) {
    return templateQaScorecardId_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (destinationCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination)
              destination_);
    }
    if (maxDownloadCount_ != 0) {
      output.writeInt32(4, maxDownloadCount_);
    }
    if (feedbackLabelType_
        != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .FeedbackLabelType.FEEDBACK_LABEL_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, feedbackLabelType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, conversationFilter_);
    }
    for (int i = 0; i < templateQaScorecardId_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 7, templateQaScorecardId_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (destinationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                      .GcsDestination)
                  destination_);
    }
    if (maxDownloadCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, maxDownloadCount_);
    }
    if (feedbackLabelType_
        != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .FeedbackLabelType.FEEDBACK_LABEL_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, feedbackLabelType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversationFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, conversationFilter_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < templateQaScorecardId_.size(); i++) {
        dataSize += computeStringSizeNoTag(templateQaScorecardId_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTemplateQaScorecardIdList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest other =
        (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (getMaxDownloadCount() != other.getMaxDownloadCount()) return false;
    if (feedbackLabelType_ != other.feedbackLabelType_) return false;
    if (!getConversationFilter().equals(other.getConversationFilter())) return false;
    if (!getTemplateQaScorecardIdList().equals(other.getTemplateQaScorecardIdList())) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 3:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + MAX_DOWNLOAD_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxDownloadCount();
    hash = (37 * hash) + FEEDBACK_LABEL_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + feedbackLabelType_;
    hash = (37 * hash) + CONVERSATION_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getConversationFilter().hashCode();
    if (getTemplateQaScorecardIdCount() > 0) {
      hash = (37 * hash) + TEMPLATE_QA_SCORECARD_ID_FIELD_NUMBER;
      hash = (53 * hash) + getTemplateQaScorecardIdList().hashCode();
    }
    switch (destinationCase_) {
      case 3:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request for the BulkDownloadFeedbackLabel endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest)
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.class,
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsDestinationBuilder_ != null) {
        gcsDestinationBuilder_.clear();
      }
      parent_ = "";
      filter_ = "";
      maxDownloadCount_ = 0;
      feedbackLabelType_ = 0;
      conversationFilter_ = "";
      templateQaScorecardId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkDownloadFeedbackLabelsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest build() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest result =
          new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.maxDownloadCount_ = maxDownloadCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.feedbackLabelType_ = feedbackLabelType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.conversationFilter_ = conversationFilter_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        templateQaScorecardId_.makeImmutable();
        result.templateQaScorecardId_ = templateQaScorecardId_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 3 && gcsDestinationBuilder_ != null) {
        result.destination_ = gcsDestinationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getMaxDownloadCount() != 0) {
        setMaxDownloadCount(other.getMaxDownloadCount());
      }
      if (other.feedbackLabelType_ != 0) {
        setFeedbackLabelTypeValue(other.getFeedbackLabelTypeValue());
      }
      if (!other.getConversationFilter().isEmpty()) {
        conversationFilter_ = other.conversationFilter_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.templateQaScorecardId_.isEmpty()) {
        if (templateQaScorecardId_.isEmpty()) {
          templateQaScorecardId_ = other.templateQaScorecardId_;
          bitField0_ |= 0x00000040;
        } else {
          ensureTemplateQaScorecardIdIsMutable();
          templateQaScorecardId_.addAll(other.templateQaScorecardId_);
        }
        onChanged();
      }
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 3;
                break;
              } // case 26
            case 32:
              {
                maxDownloadCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                feedbackLabelType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                conversationFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTemplateQaScorecardIdIsMutable();
                templateQaScorecardId_.add(s);
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestinationOrBuilder>
        gcsDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination
        getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination)
              destination_;
        }
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 3) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
                .Builder
            builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    public Builder mergeGcsDestination(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination
            value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 3
            && destination_
                != com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                              .GcsDestination)
                          destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 3) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 3) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.Builder
        getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestinationOrBuilder
        getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 3) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination)
              destination_;
        }
        return com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .GcsDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket destination.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.GcsDestination gcs_destination = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestination.Builder,
            com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 3)) {
          destination_ =
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestination.Builder,
                com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                    .GcsDestinationOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                        .GcsDestination)
                    destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 3;
      onChanged();
      return gcsDestinationBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A filter to reduce results to a specific subset. Supports
     * disjunctions (OR) and conjunctions (AND).
     *
     * Supported fields:
     *
     * * `issue_model_id`
     * * `qa_question_id`
     * * `qa_scorecard_id`
     * * `min_create_time`
     * * `max_create_time`
     * * `min_update_time`
     * * `max_update_time`
     * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter to reduce results to a specific subset. Supports
     * disjunctions (OR) and conjunctions (AND).
     *
     * Supported fields:
     *
     * * `issue_model_id`
     * * `qa_question_id`
     * * `qa_scorecard_id`
     * * `min_create_time`
     * * `max_create_time`
     * * `min_update_time`
     * * `max_update_time`
     * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter to reduce results to a specific subset. Supports
     * disjunctions (OR) and conjunctions (AND).
     *
     * Supported fields:
     *
     * * `issue_model_id`
     * * `qa_question_id`
     * * `qa_scorecard_id`
     * * `min_create_time`
     * * `max_create_time`
     * * `min_update_time`
     * * `max_update_time`
     * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter to reduce results to a specific subset. Supports
     * disjunctions (OR) and conjunctions (AND).
     *
     * Supported fields:
     *
     * * `issue_model_id`
     * * `qa_question_id`
     * * `qa_scorecard_id`
     * * `min_create_time`
     * * `max_create_time`
     * * `min_update_time`
     * * `max_update_time`
     * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter to reduce results to a specific subset. Supports
     * disjunctions (OR) and conjunctions (AND).
     *
     * Supported fields:
     *
     * * `issue_model_id`
     * * `qa_question_id`
     * * `qa_scorecard_id`
     * * `min_create_time`
     * * `max_create_time`
     * * `min_update_time`
     * * `max_update_time`
     * * `feedback_label_type`: QUALITY_AI, TOPIC_MODELING
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int maxDownloadCount_;
    /**
     *
     *
     * <pre>
     * Optional. Limits the maximum number of feedback labels that will be
     * downloaded. The first `N` feedback labels will be downloaded.
     * </pre>
     *
     * <code>int32 max_download_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxDownloadCount.
     */
    @java.lang.Override
    public int getMaxDownloadCount() {
      return maxDownloadCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Limits the maximum number of feedback labels that will be
     * downloaded. The first `N` feedback labels will be downloaded.
     * </pre>
     *
     * <code>int32 max_download_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxDownloadCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDownloadCount(int value) {

      maxDownloadCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Limits the maximum number of feedback labels that will be
     * downloaded. The first `N` feedback labels will be downloaded.
     * </pre>
     *
     * <code>int32 max_download_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDownloadCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      maxDownloadCount_ = 0;
      onChanged();
      return this;
    }

    private int feedbackLabelType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of feedback labels that will be downloaded.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for feedbackLabelType.
     */
    @java.lang.Override
    public int getFeedbackLabelTypeValue() {
      return feedbackLabelType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of feedback labels that will be downloaded.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for feedbackLabelType to set.
     * @return This builder for chaining.
     */
    public Builder setFeedbackLabelTypeValue(int value) {
      feedbackLabelType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of feedback labels that will be downloaded.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The feedbackLabelType.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
            .FeedbackLabelType
        getFeedbackLabelType() {
      com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType
          result =
              com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                  .FeedbackLabelType.forNumber(feedbackLabelType_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
              .FeedbackLabelType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of feedback labels that will be downloaded.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The feedbackLabelType to set.
     * @return This builder for chaining.
     */
    public Builder setFeedbackLabelType(
        com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
                .FeedbackLabelType
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      feedbackLabelType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of feedback labels that will be downloaded.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest.FeedbackLabelType feedback_label_type = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeedbackLabelType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      feedbackLabelType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object conversationFilter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Filter parent conversations to download feedback labels for.
     * When specified, the feedback labels will be downloaded for the
     * conversations that match the filter.
     * If `template_qa_scorecard_id` is set, all the conversations that match the
     * filter will be paired with the questions under the scorecard for labeling.
     * </pre>
     *
     * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The conversationFilter.
     */
    public java.lang.String getConversationFilter() {
      java.lang.Object ref = conversationFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversationFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter parent conversations to download feedback labels for.
     * When specified, the feedback labels will be downloaded for the
     * conversations that match the filter.
     * If `template_qa_scorecard_id` is set, all the conversations that match the
     * filter will be paired with the questions under the scorecard for labeling.
     * </pre>
     *
     * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for conversationFilter.
     */
    public com.google.protobuf.ByteString getConversationFilterBytes() {
      java.lang.Object ref = conversationFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversationFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter parent conversations to download feedback labels for.
     * When specified, the feedback labels will be downloaded for the
     * conversations that match the filter.
     * If `template_qa_scorecard_id` is set, all the conversations that match the
     * filter will be paired with the questions under the scorecard for labeling.
     * </pre>
     *
     * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The conversationFilter to set.
     * @return This builder for chaining.
     */
    public Builder setConversationFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversationFilter_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter parent conversations to download feedback labels for.
     * When specified, the feedback labels will be downloaded for the
     * conversations that match the filter.
     * If `template_qa_scorecard_id` is set, all the conversations that match the
     * filter will be paired with the questions under the scorecard for labeling.
     * </pre>
     *
     * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversationFilter() {
      conversationFilter_ = getDefaultInstance().getConversationFilter();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Filter parent conversations to download feedback labels for.
     * When specified, the feedback labels will be downloaded for the
     * conversations that match the filter.
     * If `template_qa_scorecard_id` is set, all the conversations that match the
     * filter will be paired with the questions under the scorecard for labeling.
     * </pre>
     *
     * <code>string conversation_filter = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for conversationFilter to set.
     * @return This builder for chaining.
     */
    public Builder setConversationFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversationFilter_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList templateQaScorecardId_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTemplateQaScorecardIdIsMutable() {
      if (!templateQaScorecardId_.isModifiable()) {
        templateQaScorecardId_ =
            new com.google.protobuf.LazyStringArrayList(templateQaScorecardId_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the templateQaScorecardId.
     */
    public com.google.protobuf.ProtocolStringList getTemplateQaScorecardIdList() {
      templateQaScorecardId_.makeImmutable();
      return templateQaScorecardId_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of templateQaScorecardId.
     */
    public int getTemplateQaScorecardIdCount() {
      return templateQaScorecardId_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The templateQaScorecardId at the given index.
     */
    public java.lang.String getTemplateQaScorecardId(int index) {
      return templateQaScorecardId_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the templateQaScorecardId at the given index.
     */
    public com.google.protobuf.ByteString getTemplateQaScorecardIdBytes(int index) {
      return templateQaScorecardId_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The templateQaScorecardId to set.
     * @return This builder for chaining.
     */
    public Builder setTemplateQaScorecardId(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTemplateQaScorecardIdIsMutable();
      templateQaScorecardId_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The templateQaScorecardId to add.
     * @return This builder for chaining.
     */
    public Builder addTemplateQaScorecardId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTemplateQaScorecardIdIsMutable();
      templateQaScorecardId_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The templateQaScorecardId to add.
     * @return This builder for chaining.
     */
    public Builder addAllTemplateQaScorecardId(java.lang.Iterable<java.lang.String> values) {
      ensureTemplateQaScorecardIdIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, templateQaScorecardId_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemplateQaScorecardId() {
      templateQaScorecardId_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, a template for labeling conversations and scorecard
     * questions will be created from the conversation_filter and the questions
     * under the scorecard(s). The feedback label `filter` will be ignored.
     * </pre>
     *
     * <code>repeated string template_qa_scorecard_id = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the templateQaScorecardId to add.
     * @return This builder for chaining.
     */
    public Builder addTemplateQaScorecardIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTemplateQaScorecardIdIsMutable();
      templateQaScorecardId_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest)
  private static final com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest();
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkDownloadFeedbackLabelsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BulkDownloadFeedbackLabelsRequest>() {
        @java.lang.Override
        public BulkDownloadFeedbackLabelsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkDownloadFeedbackLabelsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkDownloadFeedbackLabelsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkDownloadFeedbackLabelsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
