/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The request for bulk uploading feedback labels.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest}
 */
public final class BulkUploadFeedbackLabelsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest)
    BulkUploadFeedbackLabelsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BulkUploadFeedbackLabelsRequest.newBuilder() to construct.
  private BulkUploadFeedbackLabelsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BulkUploadFeedbackLabelsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BulkUploadFeedbackLabelsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.class,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder
                .class);
  }

  public interface GcsSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. File format which will be ingested.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    int getFormatValue();
    /**
     *
     *
     * <pre>
     * Required. File format which will be ingested.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The format.
     */
    com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
        getFormat();

    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the file to import.
     * Format: `gs://bucket_name/object_name`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The objectUri.
     */
    java.lang.String getObjectUri();
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the file to import.
     * Format: `gs://bucket_name/object_name`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for objectUri.
     */
    com.google.protobuf.ByteString getObjectUriBytes();
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage Object details to get the feedback label file from.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource}
   */
  public static final class GcsSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
      GcsSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsSource.newBuilder() to construct.
    private GcsSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsSource() {
      format_ = 0;
      objectUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_GcsSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_GcsSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                  .class,
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                  .Builder.class);
    }

    /**
     *
     *
     * <pre>
     * All permissible file formats.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format}
     */
    public enum Format implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified format.
       * </pre>
       *
       * <code>FORMAT_UNSPECIFIED = 0;</code>
       */
      FORMAT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * CSV format.
       * </pre>
       *
       * <code>CSV = 1;</code>
       */
      CSV(1),
      /**
       *
       *
       * <pre>
       * JSON format.
       * </pre>
       *
       * <code>JSON = 2;</code>
       */
      JSON(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified format.
       * </pre>
       *
       * <code>FORMAT_UNSPECIFIED = 0;</code>
       */
      public static final int FORMAT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * CSV format.
       * </pre>
       *
       * <code>CSV = 1;</code>
       */
      public static final int CSV_VALUE = 1;
      /**
       *
       *
       * <pre>
       * JSON format.
       * </pre>
       *
       * <code>JSON = 2;</code>
       */
      public static final int JSON_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Format valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Format forNumber(int value) {
        switch (value) {
          case 0:
            return FORMAT_UNSPECIFIED;
          case 1:
            return CSV;
          case 2:
            return JSON;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Format> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Format> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Format>() {
            public Format findValueByNumber(int number) {
              return Format.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Format[] VALUES = values();

      public static Format valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Format(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format)
    }

    public static final int FORMAT_FIELD_NUMBER = 1;
    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * Required. File format which will be ingested.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * Required. File format which will be ingested.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The format.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .Format
        getFormat() {
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
          result =
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                  .Format.forNumber(format_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              .Format.UNRECOGNIZED
          : result;
    }

    public static final int OBJECT_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object objectUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the file to import.
     * Format: `gs://bucket_name/object_name`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The objectUri.
     */
    @java.lang.Override
    public java.lang.String getObjectUri() {
      java.lang.Object ref = objectUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Google Cloud Storage URI of the file to import.
     * Format: `gs://bucket_name/object_name`
     * </pre>
     *
     * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for objectUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getObjectUriBytes() {
      java.lang.Object ref = objectUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (format_
          != com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              .Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, objectUri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (format_
          != com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              .Format.FORMAT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, format_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, objectUri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource other =
          (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource) obj;

      if (format_ != other.format_) return false;
      if (!getObjectUri().equals(other.getObjectUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FORMAT_FIELD_NUMBER;
      hash = (53 * hash) + format_;
      hash = (37 * hash) + OBJECT_URI_FIELD_NUMBER;
      hash = (53 * hash) + getObjectUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage Object details to get the feedback label file from.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_GcsSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_GcsSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                    .class,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        format_ = 0;
        objectUri_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_GcsSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
          build() {
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource result =
            new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.format_ = format_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.objectUri_ = objectUri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                .getDefaultInstance()) return this;
        if (other.format_ != 0) {
          setFormatValue(other.getFormatValue());
        }
        if (!other.getObjectUri().isEmpty()) {
          objectUri_ = other.objectUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  format_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  objectUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int format_ = 0;
      /**
       *
       *
       * <pre>
       * Required. File format which will be ingested.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for format.
       */
      @java.lang.Override
      public int getFormatValue() {
        return format_;
      }
      /**
       *
       *
       * <pre>
       * Required. File format which will be ingested.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for format to set.
       * @return This builder for chaining.
       */
      public Builder setFormatValue(int value) {
        format_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. File format which will be ingested.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The format.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
              .Format
          getFormat() {
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
            result =
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                    .Format.forNumber(format_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                .Format.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. File format which will be ingested.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The format to set.
       * @return This builder for chaining.
       */
      public Builder setFormat(
          com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        format_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. File format which will be ingested.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Format format = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFormat() {
        bitField0_ = (bitField0_ & ~0x00000001);
        format_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object objectUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI of the file to import.
       * Format: `gs://bucket_name/object_name`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The objectUri.
       */
      public java.lang.String getObjectUri() {
        java.lang.Object ref = objectUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          objectUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI of the file to import.
       * Format: `gs://bucket_name/object_name`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for objectUri.
       */
      public com.google.protobuf.ByteString getObjectUriBytes() {
        java.lang.Object ref = objectUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          objectUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI of the file to import.
       * Format: `gs://bucket_name/object_name`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The objectUri to set.
       * @return This builder for chaining.
       */
      public Builder setObjectUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI of the file to import.
       * Format: `gs://bucket_name/object_name`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearObjectUri() {
        objectUri_ = getDefaultInstance().getObjectUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Google Cloud Storage URI of the file to import.
       * Format: `gs://bucket_name/object_name`
       * </pre>
       *
       * <code>string object_uri = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for objectUri to set.
       * @return This builder for chaining.
       */
      public Builder setObjectUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        objectUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
    private static final com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource();
    }

    public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsSource> PARSER =
        new com.google.protobuf.AbstractParser<GcsSource>() {
          @java.lang.Override
          public GcsSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
   * </code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
   * </code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
      getGcsSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
          source_;
    }
    return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
          .GcsSourceOrBuilder
      getGcsSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
          source_;
    }
    return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
        .getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new feedback labels.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new feedback labels.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 3;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set, upload will not happen and the labels will be validated.
   * If not set, then default behavior will be to upload the labels after
   * validation is complete.
   * </pre>
   *
   * <code>bool validate_only = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
              source_);
    }
    if (validateOnly_ != false) {
      output.writeBool(3, validateOnly_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource)
                  source_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, validateOnly_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest other =
        (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for bulk uploading feedback labels.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest)
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.class,
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      parent_ = "";
      validateOnly_ = false;
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_BulkUploadFeedbackLabelsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest build() {
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest result =
          new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                .Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                .GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
        getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                  .GcsSource)
              source_;
        }
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder setGcsSource(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder setGcsSource(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource.Builder
            builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder mergeGcsSource(
        com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                    .GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                              .GcsSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .Builder
        getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
            .GcsSourceOrBuilder
        getGcsSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                  .GcsSource)
              source_;
        }
        return com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                .Builder,
            com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                .GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                  .getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest.GcsSource
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                    .GcsSourceOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
                        .GcsSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return gcsSourceBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new feedback labels.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. If set, upload will not happen and the labels will be validated.
     * If not set, then default behavior will be to upload the labels after
     * validation is complete.
     * </pre>
     *
     * <code>bool validate_only = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, upload will not happen and the labels will be validated.
     * If not set, then default behavior will be to upload the labels after
     * validation is complete.
     * </pre>
     *
     * <code>bool validate_only = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, upload will not happen and the labels will be validated.
     * If not set, then default behavior will be to upload the labels after
     * validation is complete.
     * </pre>
     *
     * <code>bool validate_only = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000004);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest)
  private static final com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest();
  }

  public static com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BulkUploadFeedbackLabelsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BulkUploadFeedbackLabelsRequest>() {
        @java.lang.Override
        public BulkUploadFeedbackLabelsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BulkUploadFeedbackLabelsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BulkUploadFeedbackLabelsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.BulkUploadFeedbackLabelsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
