/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * A piece of metadata that applies to a window of a call.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.CallAnnotation}
 */
public final class CallAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.CallAnnotation)
    CallAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CallAnnotation.newBuilder() to construct.
  private CallAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CallAnnotation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CallAnnotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_CallAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_CallAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.CallAnnotation.class,
            com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder.class);
  }

  private int bitField0_;
  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTERRUPTION_DATA(10),
    SENTIMENT_DATA(11),
    SILENCE_DATA(12),
    HOLD_DATA(13),
    ENTITY_MENTION_DATA(15),
    INTENT_MATCH_DATA(16),
    PHRASE_MATCH_DATA(17),
    ISSUE_MATCH_DATA(18),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 10:
          return INTERRUPTION_DATA;
        case 11:
          return SENTIMENT_DATA;
        case 12:
          return SILENCE_DATA;
        case 13:
          return HOLD_DATA;
        case 15:
          return ENTITY_MENTION_DATA;
        case 16:
          return INTENT_MATCH_DATA;
        case 17:
          return PHRASE_MATCH_DATA;
        case 18:
          return ISSUE_MATCH_DATA;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int INTERRUPTION_DATA_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Data specifying an interruption.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
   *
   * @return Whether the interruptionData field is set.
   */
  @java.lang.Override
  public boolean hasInterruptionData() {
    return dataCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Data specifying an interruption.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
   *
   * @return The interruptionData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.InterruptionData getInterruptionData() {
    if (dataCase_ == 10) {
      return (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying an interruption.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.InterruptionDataOrBuilder
      getInterruptionDataOrBuilder() {
    if (dataCase_ == 10) {
      return (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
  }

  public static final int SENTIMENT_DATA_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Data specifying sentiment.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
   *
   * @return Whether the sentimentData field is set.
   */
  @java.lang.Override
  public boolean hasSentimentData() {
    return dataCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Data specifying sentiment.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
   *
   * @return The sentimentData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SentimentData getSentimentData() {
    if (dataCase_ == 11) {
      return (com.google.cloud.contactcenterinsights.v1.SentimentData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying sentiment.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder
      getSentimentDataOrBuilder() {
    if (dataCase_ == 11) {
      return (com.google.cloud.contactcenterinsights.v1.SentimentData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
  }

  public static final int SILENCE_DATA_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Data specifying silence.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
   *
   * @return Whether the silenceData field is set.
   */
  @java.lang.Override
  public boolean hasSilenceData() {
    return dataCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Data specifying silence.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
   *
   * @return The silenceData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SilenceData getSilenceData() {
    if (dataCase_ == 12) {
      return (com.google.cloud.contactcenterinsights.v1.SilenceData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying silence.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SilenceDataOrBuilder getSilenceDataOrBuilder() {
    if (dataCase_ == 12) {
      return (com.google.cloud.contactcenterinsights.v1.SilenceData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
  }

  public static final int HOLD_DATA_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Data specifying a hold.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
   *
   * @return Whether the holdData field is set.
   */
  @java.lang.Override
  public boolean hasHoldData() {
    return dataCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Data specifying a hold.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
   *
   * @return The holdData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.HoldData getHoldData() {
    if (dataCase_ == 13) {
      return (com.google.cloud.contactcenterinsights.v1.HoldData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying a hold.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.HoldDataOrBuilder getHoldDataOrBuilder() {
    if (dataCase_ == 13) {
      return (com.google.cloud.contactcenterinsights.v1.HoldData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
  }

  public static final int ENTITY_MENTION_DATA_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Data specifying an entity mention.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;</code>
   *
   * @return Whether the entityMentionData field is set.
   */
  @java.lang.Override
  public boolean hasEntityMentionData() {
    return dataCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Data specifying an entity mention.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;</code>
   *
   * @return The entityMentionData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.EntityMentionData getEntityMentionData() {
    if (dataCase_ == 15) {
      return (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying an entity mention.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.EntityMentionDataOrBuilder
      getEntityMentionDataOrBuilder() {
    if (dataCase_ == 15) {
      return (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
  }

  public static final int INTENT_MATCH_DATA_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * Data specifying an intent match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
   *
   * @return Whether the intentMatchData field is set.
   */
  @java.lang.Override
  public boolean hasIntentMatchData() {
    return dataCase_ == 16;
  }
  /**
   *
   *
   * <pre>
   * Data specifying an intent match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
   *
   * @return The intentMatchData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IntentMatchData getIntentMatchData() {
    if (dataCase_ == 16) {
      return (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying an intent match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IntentMatchDataOrBuilder
      getIntentMatchDataOrBuilder() {
    if (dataCase_ == 16) {
      return (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
  }

  public static final int PHRASE_MATCH_DATA_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Data specifying a phrase match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
   *
   * @return Whether the phraseMatchData field is set.
   */
  @java.lang.Override
  public boolean hasPhraseMatchData() {
    return dataCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Data specifying a phrase match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
   *
   * @return The phraseMatchData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchData() {
    if (dataCase_ == 17) {
      return (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying a phrase match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchDataOrBuilder
      getPhraseMatchDataOrBuilder() {
    if (dataCase_ == 17) {
      return (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
  }

  public static final int ISSUE_MATCH_DATA_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Data specifying an issue match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
   *
   * @return Whether the issueMatchData field is set.
   */
  @java.lang.Override
  public boolean hasIssueMatchData() {
    return dataCase_ == 18;
  }
  /**
   *
   *
   * <pre>
   * Data specifying an issue match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
   *
   * @return The issueMatchData.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueMatchData getIssueMatchData() {
    if (dataCase_ == 18) {
      return (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Data specifying an issue match.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IssueMatchDataOrBuilder
      getIssueMatchDataOrBuilder() {
    if (dataCase_ == 18) {
      return (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_;
    }
    return com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
  }

  public static final int CHANNEL_TAG_FIELD_NUMBER = 1;
  private int channelTag_ = 0;
  /**
   *
   *
   * <pre>
   * The channel of the audio where the annotation occurs. For single-channel
   * audio, this field is not populated.
   * </pre>
   *
   * <code>int32 channel_tag = 1;</code>
   *
   * @return The channelTag.
   */
  @java.lang.Override
  public int getChannelTag() {
    return channelTag_;
  }

  public static final int ANNOTATION_START_BOUNDARY_FIELD_NUMBER = 4;
  private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotationStartBoundary_;
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
   * </code>
   *
   * @return Whether the annotationStartBoundary field is set.
   */
  @java.lang.Override
  public boolean hasAnnotationStartBoundary() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
   * </code>
   *
   * @return The annotationStartBoundary.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getAnnotationStartBoundary() {
    return annotationStartBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : annotationStartBoundary_;
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation starts, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
      getAnnotationStartBoundaryOrBuilder() {
    return annotationStartBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : annotationStartBoundary_;
  }

  public static final int ANNOTATION_END_BOUNDARY_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotationEndBoundary_;
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
   * </code>
   *
   * @return Whether the annotationEndBoundary field is set.
   */
  @java.lang.Override
  public boolean hasAnnotationEndBoundary() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
   * </code>
   *
   * @return The annotationEndBoundary.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getAnnotationEndBoundary() {
    return annotationEndBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : annotationEndBoundary_;
  }
  /**
   *
   *
   * <pre>
   * The boundary in the conversation where the annotation ends, inclusive.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
      getAnnotationEndBoundaryOrBuilder() {
    return annotationEndBoundary_ == null
        ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
        : annotationEndBoundary_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (channelTag_ != 0) {
      output.writeInt32(1, channelTag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getAnnotationStartBoundary());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getAnnotationEndBoundary());
    }
    if (dataCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_);
    }
    if (dataCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.contactcenterinsights.v1.SentimentData) data_);
    }
    if (dataCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.contactcenterinsights.v1.SilenceData) data_);
    }
    if (dataCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.contactcenterinsights.v1.HoldData) data_);
    }
    if (dataCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_);
    }
    if (dataCase_ == 16) {
      output.writeMessage(16, (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_);
    }
    if (dataCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_);
    }
    if (dataCase_ == 18) {
      output.writeMessage(18, (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (channelTag_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, channelTag_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAnnotationStartBoundary());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAnnotationEndBoundary());
    }
    if (dataCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_);
    }
    if (dataCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.contactcenterinsights.v1.SentimentData) data_);
    }
    if (dataCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.contactcenterinsights.v1.SilenceData) data_);
    }
    if (dataCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.contactcenterinsights.v1.HoldData) data_);
    }
    if (dataCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_);
    }
    if (dataCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              16, (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_);
    }
    if (dataCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_);
    }
    if (dataCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              18, (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.CallAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.CallAnnotation other =
        (com.google.cloud.contactcenterinsights.v1.CallAnnotation) obj;

    if (getChannelTag() != other.getChannelTag()) return false;
    if (hasAnnotationStartBoundary() != other.hasAnnotationStartBoundary()) return false;
    if (hasAnnotationStartBoundary()) {
      if (!getAnnotationStartBoundary().equals(other.getAnnotationStartBoundary())) return false;
    }
    if (hasAnnotationEndBoundary() != other.hasAnnotationEndBoundary()) return false;
    if (hasAnnotationEndBoundary()) {
      if (!getAnnotationEndBoundary().equals(other.getAnnotationEndBoundary())) return false;
    }
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 10:
        if (!getInterruptionData().equals(other.getInterruptionData())) return false;
        break;
      case 11:
        if (!getSentimentData().equals(other.getSentimentData())) return false;
        break;
      case 12:
        if (!getSilenceData().equals(other.getSilenceData())) return false;
        break;
      case 13:
        if (!getHoldData().equals(other.getHoldData())) return false;
        break;
      case 15:
        if (!getEntityMentionData().equals(other.getEntityMentionData())) return false;
        break;
      case 16:
        if (!getIntentMatchData().equals(other.getIntentMatchData())) return false;
        break;
      case 17:
        if (!getPhraseMatchData().equals(other.getPhraseMatchData())) return false;
        break;
      case 18:
        if (!getIssueMatchData().equals(other.getIssueMatchData())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CHANNEL_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getChannelTag();
    if (hasAnnotationStartBoundary()) {
      hash = (37 * hash) + ANNOTATION_START_BOUNDARY_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationStartBoundary().hashCode();
    }
    if (hasAnnotationEndBoundary()) {
      hash = (37 * hash) + ANNOTATION_END_BOUNDARY_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationEndBoundary().hashCode();
    }
    switch (dataCase_) {
      case 10:
        hash = (37 * hash) + INTERRUPTION_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getInterruptionData().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SENTIMENT_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getSentimentData().hashCode();
        break;
      case 12:
        hash = (37 * hash) + SILENCE_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getSilenceData().hashCode();
        break;
      case 13:
        hash = (37 * hash) + HOLD_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getHoldData().hashCode();
        break;
      case 15:
        hash = (37 * hash) + ENTITY_MENTION_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getEntityMentionData().hashCode();
        break;
      case 16:
        hash = (37 * hash) + INTENT_MATCH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getIntentMatchData().hashCode();
        break;
      case 17:
        hash = (37 * hash) + PHRASE_MATCH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getPhraseMatchData().hashCode();
        break;
      case 18:
        hash = (37 * hash) + ISSUE_MATCH_DATA_FIELD_NUMBER;
        hash = (53 * hash) + getIssueMatchData().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.CallAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A piece of metadata that applies to a window of a call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.CallAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.CallAnnotation)
      com.google.cloud.contactcenterinsights.v1.CallAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_CallAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_CallAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.CallAnnotation.class,
              com.google.cloud.contactcenterinsights.v1.CallAnnotation.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.CallAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAnnotationStartBoundaryFieldBuilder();
        getAnnotationEndBoundaryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (interruptionDataBuilder_ != null) {
        interruptionDataBuilder_.clear();
      }
      if (sentimentDataBuilder_ != null) {
        sentimentDataBuilder_.clear();
      }
      if (silenceDataBuilder_ != null) {
        silenceDataBuilder_.clear();
      }
      if (holdDataBuilder_ != null) {
        holdDataBuilder_.clear();
      }
      if (entityMentionDataBuilder_ != null) {
        entityMentionDataBuilder_.clear();
      }
      if (intentMatchDataBuilder_ != null) {
        intentMatchDataBuilder_.clear();
      }
      if (phraseMatchDataBuilder_ != null) {
        phraseMatchDataBuilder_.clear();
      }
      if (issueMatchDataBuilder_ != null) {
        issueMatchDataBuilder_.clear();
      }
      channelTag_ = 0;
      annotationStartBoundary_ = null;
      if (annotationStartBoundaryBuilder_ != null) {
        annotationStartBoundaryBuilder_.dispose();
        annotationStartBoundaryBuilder_ = null;
      }
      annotationEndBoundary_ = null;
      if (annotationEndBoundaryBuilder_ != null) {
        annotationEndBoundaryBuilder_.dispose();
        annotationEndBoundaryBuilder_ = null;
      }
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_CallAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CallAnnotation getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.CallAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CallAnnotation build() {
      com.google.cloud.contactcenterinsights.v1.CallAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.CallAnnotation buildPartial() {
      com.google.cloud.contactcenterinsights.v1.CallAnnotation result =
          new com.google.cloud.contactcenterinsights.v1.CallAnnotation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.CallAnnotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.channelTag_ = channelTag_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.annotationStartBoundary_ =
            annotationStartBoundaryBuilder_ == null
                ? annotationStartBoundary_
                : annotationStartBoundaryBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.annotationEndBoundary_ =
            annotationEndBoundaryBuilder_ == null
                ? annotationEndBoundary_
                : annotationEndBoundaryBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.CallAnnotation result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 10 && interruptionDataBuilder_ != null) {
        result.data_ = interruptionDataBuilder_.build();
      }
      if (dataCase_ == 11 && sentimentDataBuilder_ != null) {
        result.data_ = sentimentDataBuilder_.build();
      }
      if (dataCase_ == 12 && silenceDataBuilder_ != null) {
        result.data_ = silenceDataBuilder_.build();
      }
      if (dataCase_ == 13 && holdDataBuilder_ != null) {
        result.data_ = holdDataBuilder_.build();
      }
      if (dataCase_ == 15 && entityMentionDataBuilder_ != null) {
        result.data_ = entityMentionDataBuilder_.build();
      }
      if (dataCase_ == 16 && intentMatchDataBuilder_ != null) {
        result.data_ = intentMatchDataBuilder_.build();
      }
      if (dataCase_ == 17 && phraseMatchDataBuilder_ != null) {
        result.data_ = phraseMatchDataBuilder_.build();
      }
      if (dataCase_ == 18 && issueMatchDataBuilder_ != null) {
        result.data_ = issueMatchDataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.CallAnnotation) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.CallAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.CallAnnotation other) {
      if (other == com.google.cloud.contactcenterinsights.v1.CallAnnotation.getDefaultInstance())
        return this;
      if (other.getChannelTag() != 0) {
        setChannelTag(other.getChannelTag());
      }
      if (other.hasAnnotationStartBoundary()) {
        mergeAnnotationStartBoundary(other.getAnnotationStartBoundary());
      }
      if (other.hasAnnotationEndBoundary()) {
        mergeAnnotationEndBoundary(other.getAnnotationEndBoundary());
      }
      switch (other.getDataCase()) {
        case INTERRUPTION_DATA:
          {
            mergeInterruptionData(other.getInterruptionData());
            break;
          }
        case SENTIMENT_DATA:
          {
            mergeSentimentData(other.getSentimentData());
            break;
          }
        case SILENCE_DATA:
          {
            mergeSilenceData(other.getSilenceData());
            break;
          }
        case HOLD_DATA:
          {
            mergeHoldData(other.getHoldData());
            break;
          }
        case ENTITY_MENTION_DATA:
          {
            mergeEntityMentionData(other.getEntityMentionData());
            break;
          }
        case INTENT_MATCH_DATA:
          {
            mergeIntentMatchData(other.getIntentMatchData());
            break;
          }
        case PHRASE_MATCH_DATA:
          {
            mergePhraseMatchData(other.getPhraseMatchData());
            break;
          }
        case ISSUE_MATCH_DATA:
          {
            mergeIssueMatchData(other.getIssueMatchData());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                channelTag_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 8
            case 34:
              {
                input.readMessage(
                    getAnnotationStartBoundaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getAnnotationEndBoundaryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 42
            case 82:
              {
                input.readMessage(
                    getInterruptionDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 10;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getSentimentDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getSilenceDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getHoldDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 13;
                break;
              } // case 106
            case 122:
              {
                input.readMessage(
                    getEntityMentionDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 15;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getIntentMatchDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 16;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getPhraseMatchDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 17;
                break;
              } // case 138
            case 146:
              {
                input.readMessage(getIssueMatchDataFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 18;
                break;
              } // case 146
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.InterruptionData,
            com.google.cloud.contactcenterinsights.v1.InterruptionData.Builder,
            com.google.cloud.contactcenterinsights.v1.InterruptionDataOrBuilder>
        interruptionDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     *
     * @return Whether the interruptionData field is set.
     */
    @java.lang.Override
    public boolean hasInterruptionData() {
      return dataCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     *
     * @return The interruptionData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.InterruptionData getInterruptionData() {
      if (interruptionDataBuilder_ == null) {
        if (dataCase_ == 10) {
          return (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
      } else {
        if (dataCase_ == 10) {
          return interruptionDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    public Builder setInterruptionData(
        com.google.cloud.contactcenterinsights.v1.InterruptionData value) {
      if (interruptionDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        interruptionDataBuilder_.setMessage(value);
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    public Builder setInterruptionData(
        com.google.cloud.contactcenterinsights.v1.InterruptionData.Builder builderForValue) {
      if (interruptionDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        interruptionDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    public Builder mergeInterruptionData(
        com.google.cloud.contactcenterinsights.v1.InterruptionData value) {
      if (interruptionDataBuilder_ == null) {
        if (dataCase_ == 10
            && data_
                != com.google.cloud.contactcenterinsights.v1.InterruptionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.InterruptionData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 10) {
          interruptionDataBuilder_.mergeFrom(value);
        } else {
          interruptionDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    public Builder clearInterruptionData() {
      if (interruptionDataBuilder_ == null) {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
        }
        interruptionDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.InterruptionData.Builder
        getInterruptionDataBuilder() {
      return getInterruptionDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.InterruptionDataOrBuilder
        getInterruptionDataOrBuilder() {
      if ((dataCase_ == 10) && (interruptionDataBuilder_ != null)) {
        return interruptionDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 10) {
          return (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an interruption.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.InterruptionData interruption_data = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.InterruptionData,
            com.google.cloud.contactcenterinsights.v1.InterruptionData.Builder,
            com.google.cloud.contactcenterinsights.v1.InterruptionDataOrBuilder>
        getInterruptionDataFieldBuilder() {
      if (interruptionDataBuilder_ == null) {
        if (!(dataCase_ == 10)) {
          data_ = com.google.cloud.contactcenterinsights.v1.InterruptionData.getDefaultInstance();
        }
        interruptionDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.InterruptionData,
                com.google.cloud.contactcenterinsights.v1.InterruptionData.Builder,
                com.google.cloud.contactcenterinsights.v1.InterruptionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.InterruptionData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 10;
      onChanged();
      return interruptionDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SentimentData,
            com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
            com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>
        sentimentDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     *
     * @return Whether the sentimentData field is set.
     */
    @java.lang.Override
    public boolean hasSentimentData() {
      return dataCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     *
     * @return The sentimentData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SentimentData getSentimentData() {
      if (sentimentDataBuilder_ == null) {
        if (dataCase_ == 11) {
          return (com.google.cloud.contactcenterinsights.v1.SentimentData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
      } else {
        if (dataCase_ == 11) {
          return sentimentDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    public Builder setSentimentData(com.google.cloud.contactcenterinsights.v1.SentimentData value) {
      if (sentimentDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        sentimentDataBuilder_.setMessage(value);
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    public Builder setSentimentData(
        com.google.cloud.contactcenterinsights.v1.SentimentData.Builder builderForValue) {
      if (sentimentDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        sentimentDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    public Builder mergeSentimentData(
        com.google.cloud.contactcenterinsights.v1.SentimentData value) {
      if (sentimentDataBuilder_ == null) {
        if (dataCase_ == 11
            && data_
                != com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.SentimentData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.SentimentData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 11) {
          sentimentDataBuilder_.mergeFrom(value);
        } else {
          sentimentDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    public Builder clearSentimentData() {
      if (sentimentDataBuilder_ == null) {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
        }
        sentimentDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.SentimentData.Builder
        getSentimentDataBuilder() {
      return getSentimentDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder
        getSentimentDataOrBuilder() {
      if ((dataCase_ == 11) && (sentimentDataBuilder_ != null)) {
        return sentimentDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 11) {
          return (com.google.cloud.contactcenterinsights.v1.SentimentData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying sentiment.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SentimentData sentiment_data = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SentimentData,
            com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
            com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>
        getSentimentDataFieldBuilder() {
      if (sentimentDataBuilder_ == null) {
        if (!(dataCase_ == 11)) {
          data_ = com.google.cloud.contactcenterinsights.v1.SentimentData.getDefaultInstance();
        }
        sentimentDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SentimentData,
                com.google.cloud.contactcenterinsights.v1.SentimentData.Builder,
                com.google.cloud.contactcenterinsights.v1.SentimentDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.SentimentData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 11;
      onChanged();
      return sentimentDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SilenceData,
            com.google.cloud.contactcenterinsights.v1.SilenceData.Builder,
            com.google.cloud.contactcenterinsights.v1.SilenceDataOrBuilder>
        silenceDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     *
     * @return Whether the silenceData field is set.
     */
    @java.lang.Override
    public boolean hasSilenceData() {
      return dataCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     *
     * @return The silenceData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SilenceData getSilenceData() {
      if (silenceDataBuilder_ == null) {
        if (dataCase_ == 12) {
          return (com.google.cloud.contactcenterinsights.v1.SilenceData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
      } else {
        if (dataCase_ == 12) {
          return silenceDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    public Builder setSilenceData(com.google.cloud.contactcenterinsights.v1.SilenceData value) {
      if (silenceDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        silenceDataBuilder_.setMessage(value);
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    public Builder setSilenceData(
        com.google.cloud.contactcenterinsights.v1.SilenceData.Builder builderForValue) {
      if (silenceDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        silenceDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    public Builder mergeSilenceData(com.google.cloud.contactcenterinsights.v1.SilenceData value) {
      if (silenceDataBuilder_ == null) {
        if (dataCase_ == 12
            && data_
                != com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.SilenceData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.SilenceData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 12) {
          silenceDataBuilder_.mergeFrom(value);
        } else {
          silenceDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    public Builder clearSilenceData() {
      if (silenceDataBuilder_ == null) {
        if (dataCase_ == 12) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 12) {
          dataCase_ = 0;
          data_ = null;
        }
        silenceDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.SilenceData.Builder getSilenceDataBuilder() {
      return getSilenceDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.SilenceDataOrBuilder
        getSilenceDataOrBuilder() {
      if ((dataCase_ == 12) && (silenceDataBuilder_ != null)) {
        return silenceDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 12) {
          return (com.google.cloud.contactcenterinsights.v1.SilenceData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying silence.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.SilenceData silence_data = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SilenceData,
            com.google.cloud.contactcenterinsights.v1.SilenceData.Builder,
            com.google.cloud.contactcenterinsights.v1.SilenceDataOrBuilder>
        getSilenceDataFieldBuilder() {
      if (silenceDataBuilder_ == null) {
        if (!(dataCase_ == 12)) {
          data_ = com.google.cloud.contactcenterinsights.v1.SilenceData.getDefaultInstance();
        }
        silenceDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SilenceData,
                com.google.cloud.contactcenterinsights.v1.SilenceData.Builder,
                com.google.cloud.contactcenterinsights.v1.SilenceDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.SilenceData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 12;
      onChanged();
      return silenceDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.HoldData,
            com.google.cloud.contactcenterinsights.v1.HoldData.Builder,
            com.google.cloud.contactcenterinsights.v1.HoldDataOrBuilder>
        holdDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     *
     * @return Whether the holdData field is set.
     */
    @java.lang.Override
    public boolean hasHoldData() {
      return dataCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     *
     * @return The holdData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.HoldData getHoldData() {
      if (holdDataBuilder_ == null) {
        if (dataCase_ == 13) {
          return (com.google.cloud.contactcenterinsights.v1.HoldData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
      } else {
        if (dataCase_ == 13) {
          return holdDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    public Builder setHoldData(com.google.cloud.contactcenterinsights.v1.HoldData value) {
      if (holdDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        holdDataBuilder_.setMessage(value);
      }
      dataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    public Builder setHoldData(
        com.google.cloud.contactcenterinsights.v1.HoldData.Builder builderForValue) {
      if (holdDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        holdDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    public Builder mergeHoldData(com.google.cloud.contactcenterinsights.v1.HoldData value) {
      if (holdDataBuilder_ == null) {
        if (dataCase_ == 13
            && data_ != com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.HoldData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.HoldData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 13) {
          holdDataBuilder_.mergeFrom(value);
        } else {
          holdDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    public Builder clearHoldData() {
      if (holdDataBuilder_ == null) {
        if (dataCase_ == 13) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 13) {
          dataCase_ = 0;
          data_ = null;
        }
        holdDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.HoldData.Builder getHoldDataBuilder() {
      return getHoldDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.HoldDataOrBuilder getHoldDataOrBuilder() {
      if ((dataCase_ == 13) && (holdDataBuilder_ != null)) {
        return holdDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 13) {
          return (com.google.cloud.contactcenterinsights.v1.HoldData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying a hold.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.HoldData hold_data = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.HoldData,
            com.google.cloud.contactcenterinsights.v1.HoldData.Builder,
            com.google.cloud.contactcenterinsights.v1.HoldDataOrBuilder>
        getHoldDataFieldBuilder() {
      if (holdDataBuilder_ == null) {
        if (!(dataCase_ == 13)) {
          data_ = com.google.cloud.contactcenterinsights.v1.HoldData.getDefaultInstance();
        }
        holdDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.HoldData,
                com.google.cloud.contactcenterinsights.v1.HoldData.Builder,
                com.google.cloud.contactcenterinsights.v1.HoldDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.HoldData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 13;
      onChanged();
      return holdDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.EntityMentionData,
            com.google.cloud.contactcenterinsights.v1.EntityMentionData.Builder,
            com.google.cloud.contactcenterinsights.v1.EntityMentionDataOrBuilder>
        entityMentionDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     *
     * @return Whether the entityMentionData field is set.
     */
    @java.lang.Override
    public boolean hasEntityMentionData() {
      return dataCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     *
     * @return The entityMentionData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.EntityMentionData getEntityMentionData() {
      if (entityMentionDataBuilder_ == null) {
        if (dataCase_ == 15) {
          return (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
      } else {
        if (dataCase_ == 15) {
          return entityMentionDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    public Builder setEntityMentionData(
        com.google.cloud.contactcenterinsights.v1.EntityMentionData value) {
      if (entityMentionDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        entityMentionDataBuilder_.setMessage(value);
      }
      dataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    public Builder setEntityMentionData(
        com.google.cloud.contactcenterinsights.v1.EntityMentionData.Builder builderForValue) {
      if (entityMentionDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        entityMentionDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    public Builder mergeEntityMentionData(
        com.google.cloud.contactcenterinsights.v1.EntityMentionData value) {
      if (entityMentionDataBuilder_ == null) {
        if (dataCase_ == 15
            && data_
                != com.google.cloud.contactcenterinsights.v1.EntityMentionData
                    .getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.EntityMentionData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 15) {
          entityMentionDataBuilder_.mergeFrom(value);
        } else {
          entityMentionDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    public Builder clearEntityMentionData() {
      if (entityMentionDataBuilder_ == null) {
        if (dataCase_ == 15) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 15) {
          dataCase_ = 0;
          data_ = null;
        }
        entityMentionDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.EntityMentionData.Builder
        getEntityMentionDataBuilder() {
      return getEntityMentionDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.EntityMentionDataOrBuilder
        getEntityMentionDataOrBuilder() {
      if ((dataCase_ == 15) && (entityMentionDataBuilder_ != null)) {
        return entityMentionDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 15) {
          return (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an entity mention.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.EntityMentionData entity_mention_data = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.EntityMentionData,
            com.google.cloud.contactcenterinsights.v1.EntityMentionData.Builder,
            com.google.cloud.contactcenterinsights.v1.EntityMentionDataOrBuilder>
        getEntityMentionDataFieldBuilder() {
      if (entityMentionDataBuilder_ == null) {
        if (!(dataCase_ == 15)) {
          data_ = com.google.cloud.contactcenterinsights.v1.EntityMentionData.getDefaultInstance();
        }
        entityMentionDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.EntityMentionData,
                com.google.cloud.contactcenterinsights.v1.EntityMentionData.Builder,
                com.google.cloud.contactcenterinsights.v1.EntityMentionDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.EntityMentionData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 15;
      onChanged();
      return entityMentionDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IntentMatchData,
            com.google.cloud.contactcenterinsights.v1.IntentMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.IntentMatchDataOrBuilder>
        intentMatchDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     *
     * @return Whether the intentMatchData field is set.
     */
    @java.lang.Override
    public boolean hasIntentMatchData() {
      return dataCase_ == 16;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     *
     * @return The intentMatchData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IntentMatchData getIntentMatchData() {
      if (intentMatchDataBuilder_ == null) {
        if (dataCase_ == 16) {
          return (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
      } else {
        if (dataCase_ == 16) {
          return intentMatchDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    public Builder setIntentMatchData(
        com.google.cloud.contactcenterinsights.v1.IntentMatchData value) {
      if (intentMatchDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        intentMatchDataBuilder_.setMessage(value);
      }
      dataCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    public Builder setIntentMatchData(
        com.google.cloud.contactcenterinsights.v1.IntentMatchData.Builder builderForValue) {
      if (intentMatchDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        intentMatchDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    public Builder mergeIntentMatchData(
        com.google.cloud.contactcenterinsights.v1.IntentMatchData value) {
      if (intentMatchDataBuilder_ == null) {
        if (dataCase_ == 16
            && data_
                != com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.IntentMatchData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 16) {
          intentMatchDataBuilder_.mergeFrom(value);
        } else {
          intentMatchDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 16;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    public Builder clearIntentMatchData() {
      if (intentMatchDataBuilder_ == null) {
        if (dataCase_ == 16) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 16) {
          dataCase_ = 0;
          data_ = null;
        }
        intentMatchDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.IntentMatchData.Builder
        getIntentMatchDataBuilder() {
      return getIntentMatchDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IntentMatchDataOrBuilder
        getIntentMatchDataOrBuilder() {
      if ((dataCase_ == 16) && (intentMatchDataBuilder_ != null)) {
        return intentMatchDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 16) {
          return (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an intent match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IntentMatchData intent_match_data = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IntentMatchData,
            com.google.cloud.contactcenterinsights.v1.IntentMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.IntentMatchDataOrBuilder>
        getIntentMatchDataFieldBuilder() {
      if (intentMatchDataBuilder_ == null) {
        if (!(dataCase_ == 16)) {
          data_ = com.google.cloud.contactcenterinsights.v1.IntentMatchData.getDefaultInstance();
        }
        intentMatchDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IntentMatchData,
                com.google.cloud.contactcenterinsights.v1.IntentMatchData.Builder,
                com.google.cloud.contactcenterinsights.v1.IntentMatchDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.IntentMatchData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 16;
      onChanged();
      return intentMatchDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchData,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchDataOrBuilder>
        phraseMatchDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     *
     * @return Whether the phraseMatchData field is set.
     */
    @java.lang.Override
    public boolean hasPhraseMatchData() {
      return dataCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     *
     * @return The phraseMatchData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchData getPhraseMatchData() {
      if (phraseMatchDataBuilder_ == null) {
        if (dataCase_ == 17) {
          return (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
      } else {
        if (dataCase_ == 17) {
          return phraseMatchDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    public Builder setPhraseMatchData(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchData value) {
      if (phraseMatchDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        phraseMatchDataBuilder_.setMessage(value);
      }
      dataCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    public Builder setPhraseMatchData(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchData.Builder builderForValue) {
      if (phraseMatchDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        phraseMatchDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    public Builder mergePhraseMatchData(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchData value) {
      if (phraseMatchDataBuilder_ == null) {
        if (dataCase_ == 17
            && data_
                != com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.PhraseMatchData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 17) {
          phraseMatchDataBuilder_.mergeFrom(value);
        } else {
          phraseMatchDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    public Builder clearPhraseMatchData() {
      if (phraseMatchDataBuilder_ == null) {
        if (dataCase_ == 17) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 17) {
          dataCase_ = 0;
          data_ = null;
        }
        phraseMatchDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchData.Builder
        getPhraseMatchDataBuilder() {
      return getPhraseMatchDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchDataOrBuilder
        getPhraseMatchDataOrBuilder() {
      if ((dataCase_ == 17) && (phraseMatchDataBuilder_ != null)) {
        return phraseMatchDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 17) {
          return (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying a phrase match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.PhraseMatchData phrase_match_data = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchData,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchDataOrBuilder>
        getPhraseMatchDataFieldBuilder() {
      if (phraseMatchDataBuilder_ == null) {
        if (!(dataCase_ == 17)) {
          data_ = com.google.cloud.contactcenterinsights.v1.PhraseMatchData.getDefaultInstance();
        }
        phraseMatchDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.PhraseMatchData,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchData.Builder,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.PhraseMatchData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 17;
      onChanged();
      return phraseMatchDataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueMatchData,
            com.google.cloud.contactcenterinsights.v1.IssueMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueMatchDataOrBuilder>
        issueMatchDataBuilder_;
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     *
     * @return Whether the issueMatchData field is set.
     */
    @java.lang.Override
    public boolean hasIssueMatchData() {
      return dataCase_ == 18;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     *
     * @return The issueMatchData.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueMatchData getIssueMatchData() {
      if (issueMatchDataBuilder_ == null) {
        if (dataCase_ == 18) {
          return (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
      } else {
        if (dataCase_ == 18) {
          return issueMatchDataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    public Builder setIssueMatchData(
        com.google.cloud.contactcenterinsights.v1.IssueMatchData value) {
      if (issueMatchDataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        issueMatchDataBuilder_.setMessage(value);
      }
      dataCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    public Builder setIssueMatchData(
        com.google.cloud.contactcenterinsights.v1.IssueMatchData.Builder builderForValue) {
      if (issueMatchDataBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        issueMatchDataBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    public Builder mergeIssueMatchData(
        com.google.cloud.contactcenterinsights.v1.IssueMatchData value) {
      if (issueMatchDataBuilder_ == null) {
        if (dataCase_ == 18
            && data_
                != com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance()) {
          data_ =
              com.google.cloud.contactcenterinsights.v1.IssueMatchData.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 18) {
          issueMatchDataBuilder_.mergeFrom(value);
        } else {
          issueMatchDataBuilder_.setMessage(value);
        }
      }
      dataCase_ = 18;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    public Builder clearIssueMatchData() {
      if (issueMatchDataBuilder_ == null) {
        if (dataCase_ == 18) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 18) {
          dataCase_ = 0;
          data_ = null;
        }
        issueMatchDataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.IssueMatchData.Builder
        getIssueMatchDataBuilder() {
      return getIssueMatchDataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IssueMatchDataOrBuilder
        getIssueMatchDataOrBuilder() {
      if ((dataCase_ == 18) && (issueMatchDataBuilder_ != null)) {
        return issueMatchDataBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 18) {
          return (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_;
        }
        return com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Data specifying an issue match.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.IssueMatchData issue_match_data = 18;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IssueMatchData,
            com.google.cloud.contactcenterinsights.v1.IssueMatchData.Builder,
            com.google.cloud.contactcenterinsights.v1.IssueMatchDataOrBuilder>
        getIssueMatchDataFieldBuilder() {
      if (issueMatchDataBuilder_ == null) {
        if (!(dataCase_ == 18)) {
          data_ = com.google.cloud.contactcenterinsights.v1.IssueMatchData.getDefaultInstance();
        }
        issueMatchDataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IssueMatchData,
                com.google.cloud.contactcenterinsights.v1.IssueMatchData.Builder,
                com.google.cloud.contactcenterinsights.v1.IssueMatchDataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.IssueMatchData) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 18;
      onChanged();
      return issueMatchDataBuilder_;
    }

    private int channelTag_;
    /**
     *
     *
     * <pre>
     * The channel of the audio where the annotation occurs. For single-channel
     * audio, this field is not populated.
     * </pre>
     *
     * <code>int32 channel_tag = 1;</code>
     *
     * @return The channelTag.
     */
    @java.lang.Override
    public int getChannelTag() {
      return channelTag_;
    }
    /**
     *
     *
     * <pre>
     * The channel of the audio where the annotation occurs. For single-channel
     * audio, this field is not populated.
     * </pre>
     *
     * <code>int32 channel_tag = 1;</code>
     *
     * @param value The channelTag to set.
     * @return This builder for chaining.
     */
    public Builder setChannelTag(int value) {

      channelTag_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The channel of the audio where the annotation occurs. For single-channel
     * audio, this field is not populated.
     * </pre>
     *
     * <code>int32 channel_tag = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChannelTag() {
      bitField0_ = (bitField0_ & ~0x00000100);
      channelTag_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotationStartBoundary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        annotationStartBoundaryBuilder_;
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     *
     * @return Whether the annotationStartBoundary field is set.
     */
    public boolean hasAnnotationStartBoundary() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     *
     * @return The annotationStartBoundary.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary
        getAnnotationStartBoundary() {
      if (annotationStartBoundaryBuilder_ == null) {
        return annotationStartBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : annotationStartBoundary_;
      } else {
        return annotationStartBoundaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public Builder setAnnotationStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (annotationStartBoundaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationStartBoundary_ = value;
      } else {
        annotationStartBoundaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public Builder setAnnotationStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder builderForValue) {
      if (annotationStartBoundaryBuilder_ == null) {
        annotationStartBoundary_ = builderForValue.build();
      } else {
        annotationStartBoundaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public Builder mergeAnnotationStartBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (annotationStartBoundaryBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && annotationStartBoundary_ != null
            && annotationStartBoundary_
                != com.google.cloud.contactcenterinsights.v1.AnnotationBoundary
                    .getDefaultInstance()) {
          getAnnotationStartBoundaryBuilder().mergeFrom(value);
        } else {
          annotationStartBoundary_ = value;
        }
      } else {
        annotationStartBoundaryBuilder_.mergeFrom(value);
      }
      if (annotationStartBoundary_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public Builder clearAnnotationStartBoundary() {
      bitField0_ = (bitField0_ & ~0x00000200);
      annotationStartBoundary_ = null;
      if (annotationStartBoundaryBuilder_ != null) {
        annotationStartBoundaryBuilder_.dispose();
        annotationStartBoundaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder
        getAnnotationStartBoundaryBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getAnnotationStartBoundaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
        getAnnotationStartBoundaryOrBuilder() {
      if (annotationStartBoundaryBuilder_ != null) {
        return annotationStartBoundaryBuilder_.getMessageOrBuilder();
      } else {
        return annotationStartBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : annotationStartBoundary_;
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation starts, inclusive.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_start_boundary = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        getAnnotationStartBoundaryFieldBuilder() {
      if (annotationStartBoundaryBuilder_ == null) {
        annotationStartBoundaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>(
                getAnnotationStartBoundary(), getParentForChildren(), isClean());
        annotationStartBoundary_ = null;
      }
      return annotationStartBoundaryBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotationEndBoundary_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        annotationEndBoundaryBuilder_;
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     *
     * @return Whether the annotationEndBoundary field is set.
     */
    public boolean hasAnnotationEndBoundary() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     *
     * @return The annotationEndBoundary.
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary getAnnotationEndBoundary() {
      if (annotationEndBoundaryBuilder_ == null) {
        return annotationEndBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : annotationEndBoundary_;
      } else {
        return annotationEndBoundaryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public Builder setAnnotationEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (annotationEndBoundaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationEndBoundary_ = value;
      } else {
        annotationEndBoundaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public Builder setAnnotationEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder builderForValue) {
      if (annotationEndBoundaryBuilder_ == null) {
        annotationEndBoundary_ = builderForValue.build();
      } else {
        annotationEndBoundaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public Builder mergeAnnotationEndBoundary(
        com.google.cloud.contactcenterinsights.v1.AnnotationBoundary value) {
      if (annotationEndBoundaryBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && annotationEndBoundary_ != null
            && annotationEndBoundary_
                != com.google.cloud.contactcenterinsights.v1.AnnotationBoundary
                    .getDefaultInstance()) {
          getAnnotationEndBoundaryBuilder().mergeFrom(value);
        } else {
          annotationEndBoundary_ = value;
        }
      } else {
        annotationEndBoundaryBuilder_.mergeFrom(value);
      }
      if (annotationEndBoundary_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public Builder clearAnnotationEndBoundary() {
      bitField0_ = (bitField0_ & ~0x00000400);
      annotationEndBoundary_ = null;
      if (annotationEndBoundaryBuilder_ != null) {
        annotationEndBoundaryBuilder_.dispose();
        annotationEndBoundaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder
        getAnnotationEndBoundaryBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getAnnotationEndBoundaryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder
        getAnnotationEndBoundaryOrBuilder() {
      if (annotationEndBoundaryBuilder_ != null) {
        return annotationEndBoundaryBuilder_.getMessageOrBuilder();
      } else {
        return annotationEndBoundary_ == null
            ? com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.getDefaultInstance()
            : annotationEndBoundary_;
      }
    }
    /**
     *
     *
     * <pre>
     * The boundary in the conversation where the annotation ends, inclusive.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotationBoundary annotation_end_boundary = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
            com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>
        getAnnotationEndBoundaryFieldBuilder() {
      if (annotationEndBoundaryBuilder_ == null) {
        annotationEndBoundaryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundary.Builder,
                com.google.cloud.contactcenterinsights.v1.AnnotationBoundaryOrBuilder>(
                getAnnotationEndBoundary(), getParentForChildren(), isClean());
        annotationEndBoundary_ = null;
      }
      return annotationEndBoundaryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.CallAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.CallAnnotation)
  private static final com.google.cloud.contactcenterinsights.v1.CallAnnotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.CallAnnotation();
  }

  public static com.google.cloud.contactcenterinsights.v1.CallAnnotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CallAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<CallAnnotation>() {
        @java.lang.Override
        public CallAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CallAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CallAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.CallAnnotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
