/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The call participant speaking for a given utterance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.ConversationParticipant}
 */
public final class ConversationParticipant extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.ConversationParticipant)
    ConversationParticipantOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConversationParticipant.newBuilder() to construct.
  private ConversationParticipant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConversationParticipant() {
    dialogflowParticipant_ = "";
    obfuscatedExternalUserId_ = "";
    role_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConversationParticipant();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_ConversationParticipant_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_ConversationParticipant_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.ConversationParticipant.class,
            com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The role of the participant.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.ConversationParticipant.Role}
   */
  public enum Role implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Participant's role is not set.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    ROLE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Participant is a human agent.
     * </pre>
     *
     * <code>HUMAN_AGENT = 1;</code>
     */
    HUMAN_AGENT(1),
    /**
     *
     *
     * <pre>
     * Participant is an automated agent.
     * </pre>
     *
     * <code>AUTOMATED_AGENT = 2;</code>
     */
    AUTOMATED_AGENT(2),
    /**
     *
     *
     * <pre>
     * Participant is an end user who conversed with the contact center.
     * </pre>
     *
     * <code>END_USER = 3;</code>
     */
    END_USER(3),
    /**
     *
     *
     * <pre>
     * Participant is either a human or automated agent.
     * </pre>
     *
     * <code>ANY_AGENT = 4;</code>
     */
    ANY_AGENT(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Participant's role is not set.
     * </pre>
     *
     * <code>ROLE_UNSPECIFIED = 0;</code>
     */
    public static final int ROLE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Participant is a human agent.
     * </pre>
     *
     * <code>HUMAN_AGENT = 1;</code>
     */
    public static final int HUMAN_AGENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Participant is an automated agent.
     * </pre>
     *
     * <code>AUTOMATED_AGENT = 2;</code>
     */
    public static final int AUTOMATED_AGENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Participant is an end user who conversed with the contact center.
     * </pre>
     *
     * <code>END_USER = 3;</code>
     */
    public static final int END_USER_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Participant is either a human or automated agent.
     * </pre>
     *
     * <code>ANY_AGENT = 4;</code>
     */
    public static final int ANY_AGENT_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Role valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Role forNumber(int value) {
      switch (value) {
        case 0:
          return ROLE_UNSPECIFIED;
        case 1:
          return HUMAN_AGENT;
        case 2:
          return AUTOMATED_AGENT;
        case 3:
          return END_USER;
        case 4:
          return ANY_AGENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Role> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Role> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Role>() {
          public Role findValueByNumber(int number) {
            return Role.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ConversationParticipant.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Role[] VALUES = values();

    public static Role valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Role(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.ConversationParticipant.Role)
  }

  private int participantCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object participant_;

  public enum ParticipantCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DIALOGFLOW_PARTICIPANT_NAME(5),
    USER_ID(6),
    PARTICIPANT_NOT_SET(0);
    private final int value;

    private ParticipantCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ParticipantCase valueOf(int value) {
      return forNumber(value);
    }

    public static ParticipantCase forNumber(int value) {
      switch (value) {
        case 5:
          return DIALOGFLOW_PARTICIPANT_NAME;
        case 6:
          return USER_ID;
        case 0:
          return PARTICIPANT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ParticipantCase getParticipantCase() {
    return ParticipantCase.forNumber(participantCase_);
  }

  public static final int DIALOGFLOW_PARTICIPANT_NAME_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The name of the participant provided by Dialogflow. Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
   * </pre>
   *
   * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return Whether the dialogflowParticipantName field is set.
   */
  public boolean hasDialogflowParticipantName() {
    return participantCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The name of the participant provided by Dialogflow. Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
   * </pre>
   *
   * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The dialogflowParticipantName.
   */
  public java.lang.String getDialogflowParticipantName() {
    java.lang.Object ref = "";
    if (participantCase_ == 5) {
      ref = participant_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (participantCase_ == 5) {
        participant_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the participant provided by Dialogflow. Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
   * </pre>
   *
   * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for dialogflowParticipantName.
   */
  public com.google.protobuf.ByteString getDialogflowParticipantNameBytes() {
    java.lang.Object ref = "";
    if (participantCase_ == 5) {
      ref = participant_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (participantCase_ == 5) {
        participant_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_ID_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * A user-specified ID representing the participant.
   * </pre>
   *
   * <code>string user_id = 6;</code>
   *
   * @return Whether the userId field is set.
   */
  public boolean hasUserId() {
    return participantCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * A user-specified ID representing the participant.
   * </pre>
   *
   * <code>string user_id = 6;</code>
   *
   * @return The userId.
   */
  public java.lang.String getUserId() {
    java.lang.Object ref = "";
    if (participantCase_ == 6) {
      ref = participant_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (participantCase_ == 6) {
        participant_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-specified ID representing the participant.
   * </pre>
   *
   * <code>string user_id = 6;</code>
   *
   * @return The bytes for userId.
   */
  public com.google.protobuf.ByteString getUserIdBytes() {
    java.lang.Object ref = "";
    if (participantCase_ == 6) {
      ref = participant_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (participantCase_ == 6) {
        participant_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIALOGFLOW_PARTICIPANT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dialogflowParticipant_ = "";
  /**
   *
   *
   * <pre>
   * Deprecated. Use `dialogflow_participant_name` instead.
   * The name of the Dialogflow participant. Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
   * </pre>
   *
   * <code>string dialogflow_participant = 1 [deprecated = true];</code>
   *
   * @deprecated
   *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
   *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
   * @return The dialogflowParticipant.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.lang.String getDialogflowParticipant() {
    java.lang.Object ref = dialogflowParticipant_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dialogflowParticipant_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Use `dialogflow_participant_name` instead.
   * The name of the Dialogflow participant. Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
   * </pre>
   *
   * <code>string dialogflow_participant = 1 [deprecated = true];</code>
   *
   * @deprecated
   *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
   *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
   * @return The bytes for dialogflowParticipant.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getDialogflowParticipantBytes() {
    java.lang.Object ref = dialogflowParticipant_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dialogflowParticipant_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OBFUSCATED_EXTERNAL_USER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object obfuscatedExternalUserId_ = "";
  /**
   *
   *
   * <pre>
   * Obfuscated user ID from Dialogflow.
   * </pre>
   *
   * <code>string obfuscated_external_user_id = 3;</code>
   *
   * @return The obfuscatedExternalUserId.
   */
  @java.lang.Override
  public java.lang.String getObfuscatedExternalUserId() {
    java.lang.Object ref = obfuscatedExternalUserId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      obfuscatedExternalUserId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Obfuscated user ID from Dialogflow.
   * </pre>
   *
   * <code>string obfuscated_external_user_id = 3;</code>
   *
   * @return The bytes for obfuscatedExternalUserId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObfuscatedExternalUserIdBytes() {
    java.lang.Object ref = obfuscatedExternalUserId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      obfuscatedExternalUserId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLE_FIELD_NUMBER = 2;
  private int role_ = 0;
  /**
   *
   *
   * <pre>
   * The role of the participant.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
   *
   * @return The enum numeric value on the wire for role.
   */
  @java.lang.Override
  public int getRoleValue() {
    return role_;
  }
  /**
   *
   *
   * <pre>
   * The role of the participant.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
   *
   * @return The role.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role getRole() {
    com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role result =
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.forNumber(role_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowParticipant_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dialogflowParticipant_);
    }
    if (role_
        != com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.ROLE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, role_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(obfuscatedExternalUserId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, obfuscatedExternalUserId_);
    }
    if (participantCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, participant_);
    }
    if (participantCase_ == 6) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, participant_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dialogflowParticipant_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dialogflowParticipant_);
    }
    if (role_
        != com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.ROLE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, role_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(obfuscatedExternalUserId_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, obfuscatedExternalUserId_);
    }
    if (participantCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, participant_);
    }
    if (participantCase_ == 6) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, participant_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.ConversationParticipant)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.ConversationParticipant other =
        (com.google.cloud.contactcenterinsights.v1.ConversationParticipant) obj;

    if (!getDialogflowParticipant().equals(other.getDialogflowParticipant())) return false;
    if (!getObfuscatedExternalUserId().equals(other.getObfuscatedExternalUserId())) return false;
    if (role_ != other.role_) return false;
    if (!getParticipantCase().equals(other.getParticipantCase())) return false;
    switch (participantCase_) {
      case 5:
        if (!getDialogflowParticipantName().equals(other.getDialogflowParticipantName()))
          return false;
        break;
      case 6:
        if (!getUserId().equals(other.getUserId())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DIALOGFLOW_PARTICIPANT_FIELD_NUMBER;
    hash = (53 * hash) + getDialogflowParticipant().hashCode();
    hash = (37 * hash) + OBFUSCATED_EXTERNAL_USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getObfuscatedExternalUserId().hashCode();
    hash = (37 * hash) + ROLE_FIELD_NUMBER;
    hash = (53 * hash) + role_;
    switch (participantCase_) {
      case 5:
        hash = (37 * hash) + DIALOGFLOW_PARTICIPANT_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getDialogflowParticipantName().hashCode();
        break;
      case 6:
        hash = (37 * hash) + USER_ID_FIELD_NUMBER;
        hash = (53 * hash) + getUserId().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The call participant speaking for a given utterance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.ConversationParticipant}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.ConversationParticipant)
      com.google.cloud.contactcenterinsights.v1.ConversationParticipantOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_ConversationParticipant_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_ConversationParticipant_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.ConversationParticipant.class,
              com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Builder.class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.ConversationParticipant.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      dialogflowParticipant_ = "";
      obfuscatedExternalUserId_ = "";
      role_ = 0;
      participantCase_ = 0;
      participant_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_ConversationParticipant_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationParticipant
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.ConversationParticipant.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationParticipant build() {
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationParticipant buildPartial() {
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant result =
          new com.google.cloud.contactcenterinsights.v1.ConversationParticipant(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dialogflowParticipant_ = dialogflowParticipant_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.obfuscatedExternalUserId_ = obfuscatedExternalUserId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.role_ = role_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant result) {
      result.participantCase_ = participantCase_;
      result.participant_ = this.participant_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.ConversationParticipant) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.ConversationParticipant) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.ConversationParticipant.getDefaultInstance())
        return this;
      if (!other.getDialogflowParticipant().isEmpty()) {
        dialogflowParticipant_ = other.dialogflowParticipant_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getObfuscatedExternalUserId().isEmpty()) {
        obfuscatedExternalUserId_ = other.obfuscatedExternalUserId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.role_ != 0) {
        setRoleValue(other.getRoleValue());
      }
      switch (other.getParticipantCase()) {
        case DIALOGFLOW_PARTICIPANT_NAME:
          {
            participantCase_ = 5;
            participant_ = other.participant_;
            onChanged();
            break;
          }
        case USER_ID:
          {
            participantCase_ = 6;
            participant_ = other.participant_;
            onChanged();
            break;
          }
        case PARTICIPANT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                dialogflowParticipant_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 16:
              {
                role_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 16
            case 26:
              {
                obfuscatedExternalUserId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                participantCase_ = 5;
                participant_ = s;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                participantCase_ = 6;
                participant_ = s;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int participantCase_ = 0;
    private java.lang.Object participant_;

    public ParticipantCase getParticipantCase() {
      return ParticipantCase.forNumber(participantCase_);
    }

    public Builder clearParticipant() {
      participantCase_ = 0;
      participant_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return Whether the dialogflowParticipantName field is set.
     */
    @java.lang.Override
    public boolean hasDialogflowParticipantName() {
      return participantCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dialogflowParticipantName.
     */
    @java.lang.Override
    public java.lang.String getDialogflowParticipantName() {
      java.lang.Object ref = "";
      if (participantCase_ == 5) {
        ref = participant_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (participantCase_ == 5) {
          participant_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dialogflowParticipantName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDialogflowParticipantNameBytes() {
      java.lang.Object ref = "";
      if (participantCase_ == 5) {
        ref = participant_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (participantCase_ == 5) {
          participant_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dialogflowParticipantName to set.
     * @return This builder for chaining.
     */
    public Builder setDialogflowParticipantName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participantCase_ = 5;
      participant_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDialogflowParticipantName() {
      if (participantCase_ == 5) {
        participantCase_ = 0;
        participant_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the participant provided by Dialogflow. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant_name = 5 [(.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dialogflowParticipantName to set.
     * @return This builder for chaining.
     */
    public Builder setDialogflowParticipantNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participantCase_ = 5;
      participant_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @return Whether the userId field is set.
     */
    @java.lang.Override
    public boolean hasUserId() {
      return participantCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @return The userId.
     */
    @java.lang.Override
    public java.lang.String getUserId() {
      java.lang.Object ref = "";
      if (participantCase_ == 6) {
        ref = participant_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (participantCase_ == 6) {
          participant_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @return The bytes for userId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserIdBytes() {
      java.lang.Object ref = "";
      if (participantCase_ == 6) {
        ref = participant_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (participantCase_ == 6) {
          participant_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      participantCase_ = 6;
      participant_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      if (participantCase_ == 6) {
        participantCase_ = 0;
        participant_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-specified ID representing the participant.
     * </pre>
     *
     * <code>string user_id = 6;</code>
     *
     * @param value The bytes for userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      participantCase_ = 6;
      participant_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object dialogflowParticipant_ = "";
    /**
     *
     *
     * <pre>
     * Deprecated. Use `dialogflow_participant_name` instead.
     * The name of the Dialogflow participant. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant = 1 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
     * @return The dialogflowParticipant.
     */
    @java.lang.Deprecated
    public java.lang.String getDialogflowParticipant() {
      java.lang.Object ref = dialogflowParticipant_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dialogflowParticipant_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use `dialogflow_participant_name` instead.
     * The name of the Dialogflow participant. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant = 1 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
     * @return The bytes for dialogflowParticipant.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getDialogflowParticipantBytes() {
      java.lang.Object ref = dialogflowParticipant_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dialogflowParticipant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use `dialogflow_participant_name` instead.
     * The name of the Dialogflow participant. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant = 1 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
     * @param value The dialogflowParticipant to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setDialogflowParticipant(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dialogflowParticipant_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use `dialogflow_participant_name` instead.
     * The name of the Dialogflow participant. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant = 1 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearDialogflowParticipant() {
      dialogflowParticipant_ = getDefaultInstance().getDialogflowParticipant();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Use `dialogflow_participant_name` instead.
     * The name of the Dialogflow participant. Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/participants/{participant}
     * </pre>
     *
     * <code>string dialogflow_participant = 1 [deprecated = true];</code>
     *
     * @deprecated
     *     google.cloud.contactcenterinsights.v1.ConversationParticipant.dialogflow_participant is
     *     deprecated. See google/cloud/contactcenterinsights/v1/resources.proto;l=1470
     * @param value The bytes for dialogflowParticipant to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setDialogflowParticipantBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dialogflowParticipant_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object obfuscatedExternalUserId_ = "";
    /**
     *
     *
     * <pre>
     * Obfuscated user ID from Dialogflow.
     * </pre>
     *
     * <code>string obfuscated_external_user_id = 3;</code>
     *
     * @return The obfuscatedExternalUserId.
     */
    public java.lang.String getObfuscatedExternalUserId() {
      java.lang.Object ref = obfuscatedExternalUserId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        obfuscatedExternalUserId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID from Dialogflow.
     * </pre>
     *
     * <code>string obfuscated_external_user_id = 3;</code>
     *
     * @return The bytes for obfuscatedExternalUserId.
     */
    public com.google.protobuf.ByteString getObfuscatedExternalUserIdBytes() {
      java.lang.Object ref = obfuscatedExternalUserId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        obfuscatedExternalUserId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID from Dialogflow.
     * </pre>
     *
     * <code>string obfuscated_external_user_id = 3;</code>
     *
     * @param value The obfuscatedExternalUserId to set.
     * @return This builder for chaining.
     */
    public Builder setObfuscatedExternalUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      obfuscatedExternalUserId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID from Dialogflow.
     * </pre>
     *
     * <code>string obfuscated_external_user_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObfuscatedExternalUserId() {
      obfuscatedExternalUserId_ = getDefaultInstance().getObfuscatedExternalUserId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Obfuscated user ID from Dialogflow.
     * </pre>
     *
     * <code>string obfuscated_external_user_id = 3;</code>
     *
     * @param value The bytes for obfuscatedExternalUserId to set.
     * @return This builder for chaining.
     */
    public Builder setObfuscatedExternalUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      obfuscatedExternalUserId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int role_ = 0;
    /**
     *
     *
     * <pre>
     * The role of the participant.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
     *
     * @return The enum numeric value on the wire for role.
     */
    @java.lang.Override
    public int getRoleValue() {
      return role_;
    }
    /**
     *
     *
     * <pre>
     * The role of the participant.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
     *
     * @param value The enum numeric value on the wire for role to set.
     * @return This builder for chaining.
     */
    public Builder setRoleValue(int value) {
      role_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role of the participant.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
     *
     * @return The role.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role getRole() {
      com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role result =
          com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.forNumber(role_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The role of the participant.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
     *
     * @param value The role to set.
     * @return This builder for chaining.
     */
    public Builder setRole(
        com.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      role_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The role of the participant.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.ConversationParticipant.Role role = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRole() {
      bitField0_ = (bitField0_ & ~0x00000010);
      role_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.ConversationParticipant)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.ConversationParticipant)
  private static final com.google.cloud.contactcenterinsights.v1.ConversationParticipant
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.ConversationParticipant();
  }

  public static com.google.cloud.contactcenterinsights.v1.ConversationParticipant
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConversationParticipant> PARSER =
      new com.google.protobuf.AbstractParser<ConversationParticipant>() {
        @java.lang.Override
        public ConversationParticipant parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConversationParticipant> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConversationParticipant> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ConversationParticipant
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
