/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * A dimension determines the grouping key for the query. In SQL terms, these
 * would be part of both the "SELECT" and "GROUP BY" clauses.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension}
 */
public final class Dimension extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Dimension)
    DimensionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Dimension.newBuilder() to construct.
  private Dimension(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dimension() {
    dimensionKey_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dimension();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_Dimension_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_Dimension_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.Dimension.class,
            com.google.cloud.contactcenterinsights.v1.Dimension.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The key of the dimension.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.Dimension.DimensionKey}
   */
  public enum DimensionKey implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The key of the dimension is unspecified.
     * </pre>
     *
     * <code>DIMENSION_KEY_UNSPECIFIED = 0;</code>
     */
    DIMENSION_KEY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by issues.
     * </pre>
     *
     * <code>ISSUE = 1;</code>
     */
    ISSUE(1),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by agents.
     * </pre>
     *
     * <code>AGENT = 2;</code>
     */
    AGENT(2),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by agent teams.
     * </pre>
     *
     * <code>AGENT_TEAM = 3;</code>
     */
    AGENT_TEAM(3),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by QaQuestionIds.
     * Note that: We only group by the QuestionId and not the revision-id of the
     * scorecard this question is a part of. This allows for showing stats for
     * the same question across different scorecard revisions.
     * </pre>
     *
     * <code>QA_QUESTION_ID = 4;</code>
     */
    QA_QUESTION_ID(4),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by QaQuestionIds-Answer value pairs.
     * Note that: We only group by the QuestionId and not the revision-id of the
     * scorecard this question is a part of. This allows for showing
     * distribution of answers per question across different scorecard
     * revisions.
     * </pre>
     *
     * <code>QA_QUESTION_ANSWER_VALUE = 5;</code>
     */
    QA_QUESTION_ANSWER_VALUE(5),
    /**
     *
     *
     * <pre>
     * The dimension is keyed by the conversation profile ID.
     * </pre>
     *
     * <code>CONVERSATION_PROFILE_ID = 6;</code>
     */
    CONVERSATION_PROFILE_ID(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The key of the dimension is unspecified.
     * </pre>
     *
     * <code>DIMENSION_KEY_UNSPECIFIED = 0;</code>
     */
    public static final int DIMENSION_KEY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by issues.
     * </pre>
     *
     * <code>ISSUE = 1;</code>
     */
    public static final int ISSUE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by agents.
     * </pre>
     *
     * <code>AGENT = 2;</code>
     */
    public static final int AGENT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by agent teams.
     * </pre>
     *
     * <code>AGENT_TEAM = 3;</code>
     */
    public static final int AGENT_TEAM_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by QaQuestionIds.
     * Note that: We only group by the QuestionId and not the revision-id of the
     * scorecard this question is a part of. This allows for showing stats for
     * the same question across different scorecard revisions.
     * </pre>
     *
     * <code>QA_QUESTION_ID = 4;</code>
     */
    public static final int QA_QUESTION_ID_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by QaQuestionIds-Answer value pairs.
     * Note that: We only group by the QuestionId and not the revision-id of the
     * scorecard this question is a part of. This allows for showing
     * distribution of answers per question across different scorecard
     * revisions.
     * </pre>
     *
     * <code>QA_QUESTION_ANSWER_VALUE = 5;</code>
     */
    public static final int QA_QUESTION_ANSWER_VALUE_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The dimension is keyed by the conversation profile ID.
     * </pre>
     *
     * <code>CONVERSATION_PROFILE_ID = 6;</code>
     */
    public static final int CONVERSATION_PROFILE_ID_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DimensionKey valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DimensionKey forNumber(int value) {
      switch (value) {
        case 0:
          return DIMENSION_KEY_UNSPECIFIED;
        case 1:
          return ISSUE;
        case 2:
          return AGENT;
        case 3:
          return AGENT_TEAM;
        case 4:
          return QA_QUESTION_ID;
        case 5:
          return QA_QUESTION_ANSWER_VALUE;
        case 6:
          return CONVERSATION_PROFILE_ID;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DimensionKey> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DimensionKey> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DimensionKey>() {
          public DimensionKey findValueByNumber(int number) {
            return DimensionKey.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.Dimension.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final DimensionKey[] VALUES = values();

    public static DimensionKey valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DimensionKey(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.Dimension.DimensionKey)
  }

  public interface IssueDimensionMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The issue ID.
     * </pre>
     *
     * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The issueId.
     */
    java.lang.String getIssueId();
    /**
     *
     *
     * <pre>
     * The issue ID.
     * </pre>
     *
     * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for issueId.
     */
    com.google.protobuf.ByteString getIssueIdBytes();

    /**
     *
     *
     * <pre>
     * The issue display name.
     * </pre>
     *
     * <code>string issue_display_name = 2;</code>
     *
     * @return The issueDisplayName.
     */
    java.lang.String getIssueDisplayName();
    /**
     *
     *
     * <pre>
     * The issue display name.
     * </pre>
     *
     * <code>string issue_display_name = 2;</code>
     *
     * @return The bytes for issueDisplayName.
     */
    com.google.protobuf.ByteString getIssueDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * The parent issue model ID.
     * </pre>
     *
     * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The issueModelId.
     */
    java.lang.String getIssueModelId();
    /**
     *
     *
     * <pre>
     * The parent issue model ID.
     * </pre>
     *
     * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for issueModelId.
     */
    com.google.protobuf.ByteString getIssueModelIdBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the issue dimension.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata}
   */
  public static final class IssueDimensionMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
      IssueDimensionMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IssueDimensionMetadata.newBuilder() to construct.
    private IssueDimensionMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IssueDimensionMetadata() {
      issueId_ = "";
      issueDisplayName_ = "";
      issueModelId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new IssueDimensionMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_IssueDimensionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_IssueDimensionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.class,
              com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder
                  .class);
    }

    public static final int ISSUE_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object issueId_ = "";
    /**
     *
     *
     * <pre>
     * The issue ID.
     * </pre>
     *
     * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The issueId.
     */
    @java.lang.Override
    public java.lang.String getIssueId() {
      java.lang.Object ref = issueId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issueId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The issue ID.
     * </pre>
     *
     * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for issueId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIssueIdBytes() {
      java.lang.Object ref = issueId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issueId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ISSUE_DISPLAY_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object issueDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * The issue display name.
     * </pre>
     *
     * <code>string issue_display_name = 2;</code>
     *
     * @return The issueDisplayName.
     */
    @java.lang.Override
    public java.lang.String getIssueDisplayName() {
      java.lang.Object ref = issueDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issueDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The issue display name.
     * </pre>
     *
     * <code>string issue_display_name = 2;</code>
     *
     * @return The bytes for issueDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIssueDisplayNameBytes() {
      java.lang.Object ref = issueDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issueDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ISSUE_MODEL_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object issueModelId_ = "";
    /**
     *
     *
     * <pre>
     * The parent issue model ID.
     * </pre>
     *
     * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The issueModelId.
     */
    @java.lang.Override
    public java.lang.String getIssueModelId() {
      java.lang.Object ref = issueModelId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        issueModelId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The parent issue model ID.
     * </pre>
     *
     * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for issueModelId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getIssueModelIdBytes() {
      java.lang.Object ref = issueModelId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        issueModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, issueId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, issueDisplayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueModelId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, issueModelId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, issueId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, issueDisplayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(issueModelId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, issueModelId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata other =
          (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata) obj;

      if (!getIssueId().equals(other.getIssueId())) return false;
      if (!getIssueDisplayName().equals(other.getIssueDisplayName())) return false;
      if (!getIssueModelId().equals(other.getIssueModelId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ISSUE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getIssueId().hashCode();
      hash = (37 * hash) + ISSUE_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getIssueDisplayName().hashCode();
      hash = (37 * hash) + ISSUE_MODEL_ID_FIELD_NUMBER;
      hash = (53 * hash) + getIssueModelId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the issue dimension.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_IssueDimensionMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_IssueDimensionMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.class,
                com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        issueId_ = "";
        issueDisplayName_ = "";
        issueModelId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_IssueDimensionMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata build() {
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata result =
            new com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.issueId_ = issueId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.issueDisplayName_ = issueDisplayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.issueModelId_ = issueModelId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
                .getDefaultInstance()) return this;
        if (!other.getIssueId().isEmpty()) {
          issueId_ = other.issueId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getIssueDisplayName().isEmpty()) {
          issueDisplayName_ = other.issueDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getIssueModelId().isEmpty()) {
          issueModelId_ = other.issueModelId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  issueId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  issueDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  issueModelId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object issueId_ = "";
      /**
       *
       *
       * <pre>
       * The issue ID.
       * </pre>
       *
       * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The issueId.
       */
      public java.lang.String getIssueId() {
        java.lang.Object ref = issueId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issueId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The issue ID.
       * </pre>
       *
       * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for issueId.
       */
      public com.google.protobuf.ByteString getIssueIdBytes() {
        java.lang.Object ref = issueId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issueId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The issue ID.
       * </pre>
       *
       * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The issueId to set.
       * @return This builder for chaining.
       */
      public Builder setIssueId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        issueId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The issue ID.
       * </pre>
       *
       * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIssueId() {
        issueId_ = getDefaultInstance().getIssueId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The issue ID.
       * </pre>
       *
       * <code>string issue_id = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for issueId to set.
       * @return This builder for chaining.
       */
      public Builder setIssueIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        issueId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object issueDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * The issue display name.
       * </pre>
       *
       * <code>string issue_display_name = 2;</code>
       *
       * @return The issueDisplayName.
       */
      public java.lang.String getIssueDisplayName() {
        java.lang.Object ref = issueDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issueDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The issue display name.
       * </pre>
       *
       * <code>string issue_display_name = 2;</code>
       *
       * @return The bytes for issueDisplayName.
       */
      public com.google.protobuf.ByteString getIssueDisplayNameBytes() {
        java.lang.Object ref = issueDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issueDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The issue display name.
       * </pre>
       *
       * <code>string issue_display_name = 2;</code>
       *
       * @param value The issueDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setIssueDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        issueDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The issue display name.
       * </pre>
       *
       * <code>string issue_display_name = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIssueDisplayName() {
        issueDisplayName_ = getDefaultInstance().getIssueDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The issue display name.
       * </pre>
       *
       * <code>string issue_display_name = 2;</code>
       *
       * @param value The bytes for issueDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setIssueDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        issueDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object issueModelId_ = "";
      /**
       *
       *
       * <pre>
       * The parent issue model ID.
       * </pre>
       *
       * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The issueModelId.
       */
      public java.lang.String getIssueModelId() {
        java.lang.Object ref = issueModelId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          issueModelId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The parent issue model ID.
       * </pre>
       *
       * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for issueModelId.
       */
      public com.google.protobuf.ByteString getIssueModelIdBytes() {
        java.lang.Object ref = issueModelId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          issueModelId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The parent issue model ID.
       * </pre>
       *
       * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The issueModelId to set.
       * @return This builder for chaining.
       */
      public Builder setIssueModelId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        issueModelId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The parent issue model ID.
       * </pre>
       *
       * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIssueModelId() {
        issueModelId_ = getDefaultInstance().getIssueModelId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The parent issue model ID.
       * </pre>
       *
       * <code>string issue_model_id = 3 [(.google.api.resource_reference) = { ... }</code>
       *
       * @param value The bytes for issueModelId to set.
       * @return This builder for chaining.
       */
      public Builder setIssueModelIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        issueModelId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IssueDimensionMetadata> PARSER =
        new com.google.protobuf.AbstractParser<IssueDimensionMetadata>() {
          @java.lang.Override
          public IssueDimensionMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<IssueDimensionMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IssueDimensionMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AgentDimensionMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentId.
     */
    java.lang.String getAgentId();
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentId.
     */
    com.google.protobuf.ByteString getAgentIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The agent's name
     * </pre>
     *
     * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentDisplayName.
     */
    java.lang.String getAgentDisplayName();
    /**
     *
     *
     * <pre>
     * Optional. The agent's name
     * </pre>
     *
     * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentDisplayName.
     */
    com.google.protobuf.ByteString getAgentDisplayNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent's team.
     * </pre>
     *
     * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentTeam.
     */
    java.lang.String getAgentTeam();
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent's team.
     * </pre>
     *
     * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentTeam.
     */
    com.google.protobuf.ByteString getAgentTeamBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the agent dimension.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata}
   */
  public static final class AgentDimensionMetadata extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
      AgentDimensionMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AgentDimensionMetadata.newBuilder() to construct.
    private AgentDimensionMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AgentDimensionMetadata() {
      agentId_ = "";
      agentDisplayName_ = "";
      agentTeam_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AgentDimensionMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_AgentDimensionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_AgentDimensionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.class,
              com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder
                  .class);
    }

    public static final int AGENT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object agentId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentId.
     */
    @java.lang.Override
    public java.lang.String getAgentId() {
      java.lang.Object ref = agentId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentIdBytes() {
      java.lang.Object ref = agentId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AGENT_DISPLAY_NAME_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object agentDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The agent's name
     * </pre>
     *
     * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentDisplayName.
     */
    @java.lang.Override
    public java.lang.String getAgentDisplayName() {
      java.lang.Object ref = agentDisplayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentDisplayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The agent's name
     * </pre>
     *
     * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentDisplayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentDisplayNameBytes() {
      java.lang.Object ref = agentDisplayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AGENT_TEAM_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object agentTeam_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent's team.
     * </pre>
     *
     * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentTeam.
     */
    @java.lang.Override
    public java.lang.String getAgentTeam() {
      java.lang.Object ref = agentTeam_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentTeam_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A user-specified string representing the agent's team.
     * </pre>
     *
     * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentTeam.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentTeamBytes() {
      java.lang.Object ref = agentTeam_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentTeam_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agentId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentDisplayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, agentDisplayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentTeam_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, agentTeam_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agentId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentDisplayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, agentDisplayName_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentTeam_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, agentTeam_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata other =
          (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata) obj;

      if (!getAgentId().equals(other.getAgentId())) return false;
      if (!getAgentDisplayName().equals(other.getAgentDisplayName())) return false;
      if (!getAgentTeam().equals(other.getAgentTeam())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AGENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAgentId().hashCode();
      hash = (37 * hash) + AGENT_DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getAgentDisplayName().hashCode();
      hash = (37 * hash) + AGENT_TEAM_FIELD_NUMBER;
      hash = (53 * hash) + getAgentTeam().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the agent dimension.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_AgentDimensionMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_AgentDimensionMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.class,
                com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        agentId_ = "";
        agentDisplayName_ = "";
        agentTeam_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_AgentDimensionMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata build() {
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata result =
            new com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.agentId_ = agentId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.agentDisplayName_ = agentDisplayName_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.agentTeam_ = agentTeam_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
                .getDefaultInstance()) return this;
        if (!other.getAgentId().isEmpty()) {
          agentId_ = other.agentId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getAgentDisplayName().isEmpty()) {
          agentDisplayName_ = other.agentDisplayName_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getAgentTeam().isEmpty()) {
          agentTeam_ = other.agentTeam_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  agentId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  agentDisplayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  agentTeam_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object agentId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The agentId.
       */
      public java.lang.String getAgentId() {
        java.lang.Object ref = agentId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agentId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for agentId.
       */
      public com.google.protobuf.ByteString getAgentIdBytes() {
        java.lang.Object ref = agentId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agentId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The agentId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentId() {
        agentId_ = getDefaultInstance().getAgentId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for agentId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        agentId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object agentDisplayName_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The agent's name
       * </pre>
       *
       * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The agentDisplayName.
       */
      public java.lang.String getAgentDisplayName() {
        java.lang.Object ref = agentDisplayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agentDisplayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The agent's name
       * </pre>
       *
       * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for agentDisplayName.
       */
      public com.google.protobuf.ByteString getAgentDisplayNameBytes() {
        java.lang.Object ref = agentDisplayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agentDisplayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The agent's name
       * </pre>
       *
       * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The agentDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setAgentDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The agent's name
       * </pre>
       *
       * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentDisplayName() {
        agentDisplayName_ = getDefaultInstance().getAgentDisplayName();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The agent's name
       * </pre>
       *
       * <code>string agent_display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for agentDisplayName to set.
       * @return This builder for chaining.
       */
      public Builder setAgentDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        agentDisplayName_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object agentTeam_ = "";
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent's team.
       * </pre>
       *
       * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The agentTeam.
       */
      public java.lang.String getAgentTeam() {
        java.lang.Object ref = agentTeam_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agentTeam_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent's team.
       * </pre>
       *
       * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for agentTeam.
       */
      public com.google.protobuf.ByteString getAgentTeamBytes() {
        java.lang.Object ref = agentTeam_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agentTeam_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent's team.
       * </pre>
       *
       * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The agentTeam to set.
       * @return This builder for chaining.
       */
      public Builder setAgentTeam(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentTeam_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent's team.
       * </pre>
       *
       * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentTeam() {
        agentTeam_ = getDefaultInstance().getAgentTeam();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. A user-specified string representing the agent's team.
       * </pre>
       *
       * <code>string agent_team = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for agentTeam to set.
       * @return This builder for chaining.
       */
      public Builder setAgentTeamBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        agentTeam_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AgentDimensionMetadata> PARSER =
        new com.google.protobuf.AbstractParser<AgentDimensionMetadata>() {
          @java.lang.Override
          public AgentDimensionMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AgentDimensionMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AgentDimensionMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QaQuestionDimensionMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaScorecardId.
     */
    java.lang.String getQaScorecardId();
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaScorecardId.
     */
    com.google.protobuf.ByteString getQaScorecardIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaQuestionId.
     */
    java.lang.String getQaQuestionId();
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaQuestionId.
     */
    com.google.protobuf.ByteString getQaQuestionIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The questionBody.
     */
    java.lang.String getQuestionBody();
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for questionBody.
     */
    com.google.protobuf.ByteString getQuestionBodyBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the QA question dimension.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata}
   */
  public static final class QaQuestionDimensionMetadata
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
      QaQuestionDimensionMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaQuestionDimensionMetadata.newBuilder() to construct.
    private QaQuestionDimensionMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaQuestionDimensionMetadata() {
      qaScorecardId_ = "";
      qaQuestionId_ = "";
      questionBody_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaQuestionDimensionMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionDimensionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionDimensionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.class,
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                  .Builder.class);
    }

    public static final int QA_SCORECARD_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object qaScorecardId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaScorecardId.
     */
    @java.lang.Override
    public java.lang.String getQaScorecardId() {
      java.lang.Object ref = qaScorecardId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaScorecardId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaScorecardId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQaScorecardIdBytes() {
      java.lang.Object ref = qaScorecardId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaScorecardId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QA_QUESTION_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object qaQuestionId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaQuestionId.
     */
    @java.lang.Override
    public java.lang.String getQaQuestionId() {
      java.lang.Object ref = qaQuestionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaQuestionId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaQuestionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQaQuestionIdBytes() {
      java.lang.Object ref = qaQuestionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaQuestionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUESTION_BODY_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object questionBody_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The questionBody.
     */
    @java.lang.Override
    public java.lang.String getQuestionBody() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        questionBody_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for questionBody.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQuestionBodyBytes() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        questionBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, qaScorecardId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, qaQuestionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, questionBody_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, qaScorecardId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, qaQuestionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, questionBody_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata other =
          (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata) obj;

      if (!getQaScorecardId().equals(other.getQaScorecardId())) return false;
      if (!getQaQuestionId().equals(other.getQaQuestionId())) return false;
      if (!getQuestionBody().equals(other.getQuestionBody())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QA_SCORECARD_ID_FIELD_NUMBER;
      hash = (53 * hash) + getQaScorecardId().hashCode();
      hash = (37 * hash) + QA_QUESTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getQaQuestionId().hashCode();
      hash = (37 * hash) + QUESTION_BODY_FIELD_NUMBER;
      hash = (53 * hash) + getQuestionBody().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the QA question dimension.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionDimensionMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionDimensionMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                    .class,
                com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        qaScorecardId_ = "";
        qaQuestionId_ = "";
        questionBody_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionDimensionMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
          build() {
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata result =
            new com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.qaScorecardId_ = qaScorecardId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.qaQuestionId_ = qaQuestionId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.questionBody_ = questionBody_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                .getDefaultInstance()) return this;
        if (!other.getQaScorecardId().isEmpty()) {
          qaScorecardId_ = other.qaScorecardId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getQaQuestionId().isEmpty()) {
          qaQuestionId_ = other.qaQuestionId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getQuestionBody().isEmpty()) {
          questionBody_ = other.questionBody_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  qaScorecardId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  qaQuestionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  questionBody_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object qaScorecardId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The qaScorecardId.
       */
      public java.lang.String getQaScorecardId() {
        java.lang.Object ref = qaScorecardId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          qaScorecardId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for qaScorecardId.
       */
      public com.google.protobuf.ByteString getQaScorecardIdBytes() {
        java.lang.Object ref = qaScorecardId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          qaScorecardId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The qaScorecardId to set.
       * @return This builder for chaining.
       */
      public Builder setQaScorecardId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        qaScorecardId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQaScorecardId() {
        qaScorecardId_ = getDefaultInstance().getQaScorecardId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for qaScorecardId to set.
       * @return This builder for chaining.
       */
      public Builder setQaScorecardIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        qaScorecardId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object qaQuestionId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The qaQuestionId.
       */
      public java.lang.String getQaQuestionId() {
        java.lang.Object ref = qaQuestionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          qaQuestionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for qaQuestionId.
       */
      public com.google.protobuf.ByteString getQaQuestionIdBytes() {
        java.lang.Object ref = qaQuestionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          qaQuestionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The qaQuestionId to set.
       * @return This builder for chaining.
       */
      public Builder setQaQuestionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        qaQuestionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQaQuestionId() {
        qaQuestionId_ = getDefaultInstance().getQaQuestionId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for qaQuestionId to set.
       * @return This builder for chaining.
       */
      public Builder setQaQuestionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        qaQuestionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object questionBody_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The questionBody.
       */
      public java.lang.String getQuestionBody() {
        java.lang.Object ref = questionBody_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          questionBody_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for questionBody.
       */
      public com.google.protobuf.ByteString getQuestionBodyBytes() {
        java.lang.Object ref = questionBody_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          questionBody_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The questionBody to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBody(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        questionBody_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuestionBody() {
        questionBody_ = getDefaultInstance().getQuestionBody();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for questionBody to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBodyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        questionBody_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionDimensionMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaQuestionDimensionMetadata> PARSER =
        new com.google.protobuf.AbstractParser<QaQuestionDimensionMetadata>() {
          @java.lang.Override
          public QaQuestionDimensionMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaQuestionDimensionMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaQuestionDimensionMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QaQuestionAnswerDimensionMetadataOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaScorecardId.
     */
    java.lang.String getQaScorecardId();
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaScorecardId.
     */
    com.google.protobuf.ByteString getQaScorecardIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaQuestionId.
     */
    java.lang.String getQaQuestionId();
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaQuestionId.
     */
    com.google.protobuf.ByteString getQaQuestionIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The questionBody.
     */
    java.lang.String getQuestionBody();
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for questionBody.
     */
    com.google.protobuf.ByteString getQuestionBodyBytes();

    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The answerValue.
     */
    java.lang.String getAnswerValue();
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for answerValue.
     */
    com.google.protobuf.ByteString getAnswerValueBytes();
  }
  /**
   *
   *
   * <pre>
   * Metadata about the QA question-answer dimension.
   * This is useful for showing the answer distribution for questions for a
   * given scorecard.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata}
   */
  public static final class QaQuestionAnswerDimensionMetadata
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
      QaQuestionAnswerDimensionMetadataOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaQuestionAnswerDimensionMetadata.newBuilder() to construct.
    private QaQuestionAnswerDimensionMetadata(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaQuestionAnswerDimensionMetadata() {
      qaScorecardId_ = "";
      qaQuestionId_ = "";
      questionBody_ = "";
      answerValue_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaQuestionAnswerDimensionMetadata();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionAnswerDimensionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionAnswerDimensionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                  .class,
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                  .Builder.class);
    }

    public static final int QA_SCORECARD_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object qaScorecardId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaScorecardId.
     */
    @java.lang.Override
    public java.lang.String getQaScorecardId() {
      java.lang.Object ref = qaScorecardId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaScorecardId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The QA scorecard ID.
     * </pre>
     *
     * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaScorecardId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQaScorecardIdBytes() {
      java.lang.Object ref = qaScorecardId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaScorecardId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QA_QUESTION_ID_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object qaQuestionId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The qaQuestionId.
     */
    @java.lang.Override
    public java.lang.String getQaQuestionId() {
      java.lang.Object ref = qaQuestionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaQuestionId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The QA question ID.
     * </pre>
     *
     * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for qaQuestionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQaQuestionIdBytes() {
      java.lang.Object ref = qaQuestionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaQuestionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int QUESTION_BODY_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object questionBody_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The questionBody.
     */
    @java.lang.Override
    public java.lang.String getQuestionBody() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        questionBody_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for questionBody.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQuestionBodyBytes() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        questionBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANSWER_VALUE_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object answerValue_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The answerValue.
     */
    @java.lang.Override
    public java.lang.String getAnswerValue() {
      java.lang.Object ref = answerValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        answerValue_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The full body of the question.
     * </pre>
     *
     * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for answerValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnswerValueBytes() {
      java.lang.Object ref = answerValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        answerValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, qaScorecardId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, qaQuestionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, questionBody_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerValue_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, answerValue_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, qaScorecardId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, qaQuestionId_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, questionBody_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(answerValue_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, answerValue_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata other =
          (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
              obj;

      if (!getQaScorecardId().equals(other.getQaScorecardId())) return false;
      if (!getQaQuestionId().equals(other.getQaQuestionId())) return false;
      if (!getQuestionBody().equals(other.getQuestionBody())) return false;
      if (!getAnswerValue().equals(other.getAnswerValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QA_SCORECARD_ID_FIELD_NUMBER;
      hash = (53 * hash) + getQaScorecardId().hashCode();
      hash = (37 * hash) + QA_QUESTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getQaQuestionId().hashCode();
      hash = (37 * hash) + QUESTION_BODY_FIELD_NUMBER;
      hash = (53 * hash) + getQuestionBody().hashCode();
      hash = (37 * hash) + ANSWER_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the QA question-answer dimension.
     * This is useful for showing the answer distribution for questions for a
     * given scorecard.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
        com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionAnswerDimensionMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionAnswerDimensionMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata.class,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        qaScorecardId_ = "";
        qaQuestionId_ = "";
        questionBody_ = "";
        answerValue_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_Dimension_QaQuestionAnswerDimensionMetadata_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
          build() {
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            result =
                new com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.qaScorecardId_ = qaScorecardId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.qaQuestionId_ = qaQuestionId_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.questionBody_ = questionBody_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.answerValue_ = answerValue_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Dimension
                      .QaQuestionAnswerDimensionMetadata)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                .getDefaultInstance()) return this;
        if (!other.getQaScorecardId().isEmpty()) {
          qaScorecardId_ = other.qaScorecardId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getQaQuestionId().isEmpty()) {
          qaQuestionId_ = other.qaQuestionId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getQuestionBody().isEmpty()) {
          questionBody_ = other.questionBody_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getAnswerValue().isEmpty()) {
          answerValue_ = other.answerValue_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  qaScorecardId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  qaQuestionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  questionBody_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  answerValue_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object qaScorecardId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The qaScorecardId.
       */
      public java.lang.String getQaScorecardId() {
        java.lang.Object ref = qaScorecardId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          qaScorecardId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for qaScorecardId.
       */
      public com.google.protobuf.ByteString getQaScorecardIdBytes() {
        java.lang.Object ref = qaScorecardId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          qaScorecardId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The qaScorecardId to set.
       * @return This builder for chaining.
       */
      public Builder setQaScorecardId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        qaScorecardId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQaScorecardId() {
        qaScorecardId_ = getDefaultInstance().getQaScorecardId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA scorecard ID.
       * </pre>
       *
       * <code>string qa_scorecard_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for qaScorecardId to set.
       * @return This builder for chaining.
       */
      public Builder setQaScorecardIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        qaScorecardId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object qaQuestionId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The qaQuestionId.
       */
      public java.lang.String getQaQuestionId() {
        java.lang.Object ref = qaQuestionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          qaQuestionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for qaQuestionId.
       */
      public com.google.protobuf.ByteString getQaQuestionIdBytes() {
        java.lang.Object ref = qaQuestionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          qaQuestionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The qaQuestionId to set.
       * @return This builder for chaining.
       */
      public Builder setQaQuestionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        qaQuestionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQaQuestionId() {
        qaQuestionId_ = getDefaultInstance().getQaQuestionId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The QA question ID.
       * </pre>
       *
       * <code>string qa_question_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for qaQuestionId to set.
       * @return This builder for chaining.
       */
      public Builder setQaQuestionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        qaQuestionId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object questionBody_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The questionBody.
       */
      public java.lang.String getQuestionBody() {
        java.lang.Object ref = questionBody_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          questionBody_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for questionBody.
       */
      public com.google.protobuf.ByteString getQuestionBodyBytes() {
        java.lang.Object ref = questionBody_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          questionBody_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The questionBody to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBody(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        questionBody_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuestionBody() {
        questionBody_ = getDefaultInstance().getQuestionBody();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string question_body = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for questionBody to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBodyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        questionBody_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object answerValue_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The answerValue.
       */
      public java.lang.String getAnswerValue() {
        java.lang.Object ref = answerValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          answerValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for answerValue.
       */
      public com.google.protobuf.ByteString getAnswerValueBytes() {
        java.lang.Object ref = answerValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          answerValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The answerValue to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerValue_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnswerValue() {
        answerValue_ = getDefaultInstance().getAnswerValue();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The full body of the question.
       * </pre>
       *
       * <code>string answer_value = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for answerValue to set.
       * @return This builder for chaining.
       */
      public Builder setAnswerValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        answerValue_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
    private static final com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.Dimension
              .QaQuestionAnswerDimensionMetadata();
    }

    public static com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadata
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaQuestionAnswerDimensionMetadata> PARSER =
        new com.google.protobuf.AbstractParser<QaQuestionAnswerDimensionMetadata>() {
          @java.lang.Override
          public QaQuestionAnswerDimensionMetadata parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaQuestionAnswerDimensionMetadata> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaQuestionAnswerDimensionMetadata> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int dimensionMetadataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dimensionMetadata_;

  public enum DimensionMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ISSUE_DIMENSION_METADATA(2),
    AGENT_DIMENSION_METADATA(3),
    QA_QUESTION_DIMENSION_METADATA(4),
    QA_QUESTION_ANSWER_DIMENSION_METADATA(5),
    DIMENSIONMETADATA_NOT_SET(0);
    private final int value;

    private DimensionMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DimensionMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DimensionMetadataCase forNumber(int value) {
      switch (value) {
        case 2:
          return ISSUE_DIMENSION_METADATA;
        case 3:
          return AGENT_DIMENSION_METADATA;
        case 4:
          return QA_QUESTION_DIMENSION_METADATA;
        case 5:
          return QA_QUESTION_ANSWER_DIMENSION_METADATA;
        case 0:
          return DIMENSIONMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DimensionMetadataCase getDimensionMetadataCase() {
    return DimensionMetadataCase.forNumber(dimensionMetadataCase_);
  }

  public static final int ISSUE_DIMENSION_METADATA_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the issue dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the issueDimensionMetadata field is set.
   */
  @java.lang.Override
  public boolean hasIssueDimensionMetadata() {
    return dimensionMetadataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the issue dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The issueDimensionMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
      getIssueDimensionMetadata() {
    if (dimensionMetadataCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the issue dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadataOrBuilder
      getIssueDimensionMetadataOrBuilder() {
    if (dimensionMetadataCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        .getDefaultInstance();
  }

  public static final int AGENT_DIMENSION_METADATA_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the agent dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the agentDimensionMetadata field is set.
   */
  @java.lang.Override
  public boolean hasAgentDimensionMetadata() {
    return dimensionMetadataCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the agent dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The agentDimensionMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
      getAgentDimensionMetadata() {
    if (dimensionMetadataCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the agent dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadataOrBuilder
      getAgentDimensionMetadataOrBuilder() {
    if (dimensionMetadataCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        .getDefaultInstance();
  }

  public static final int QA_QUESTION_DIMENSION_METADATA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the qaQuestionDimensionMetadata field is set.
   */
  @java.lang.Override
  public boolean hasQaQuestionDimensionMetadata() {
    return dimensionMetadataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The qaQuestionDimensionMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
      getQaQuestionDimensionMetadata() {
    if (dimensionMetadataCase_ == 4) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadataOrBuilder
      getQaQuestionDimensionMetadataOrBuilder() {
    if (dimensionMetadataCase_ == 4) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        .getDefaultInstance();
  }

  public static final int QA_QUESTION_ANSWER_DIMENSION_METADATA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question-answer dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the qaQuestionAnswerDimensionMetadata field is set.
   */
  @java.lang.Override
  public boolean hasQaQuestionAnswerDimensionMetadata() {
    return dimensionMetadataCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question-answer dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The qaQuestionAnswerDimensionMetadata.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
      getQaQuestionAnswerDimensionMetadata() {
    if (dimensionMetadataCase_ == 5) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Metadata about the QA question-answer dimension.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension
          .QaQuestionAnswerDimensionMetadataOrBuilder
      getQaQuestionAnswerDimensionMetadataOrBuilder() {
    if (dimensionMetadataCase_ == 5) {
      return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
          dimensionMetadata_;
    }
    return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
        .getDefaultInstance();
  }

  public static final int DIMENSION_KEY_FIELD_NUMBER = 1;
  private int dimensionKey_ = 0;
  /**
   *
   *
   * <pre>
   * The key of the dimension.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
   *
   * @return The enum numeric value on the wire for dimensionKey.
   */
  @java.lang.Override
  public int getDimensionKeyValue() {
    return dimensionKey_;
  }
  /**
   *
   *
   * <pre>
   * The key of the dimension.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
   *
   * @return The dimensionKey.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey getDimensionKey() {
    com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey result =
        com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey.forNumber(dimensionKey_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dimensionKey_
        != com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey
            .DIMENSION_KEY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, dimensionKey_);
    }
    if (dimensionMetadataCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
              dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
              dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
              dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata)
              dimensionMetadata_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dimensionKey_
        != com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey
            .DIMENSION_KEY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dimensionKey_);
    }
    if (dimensionMetadataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
                  dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
                  dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
                  dimensionMetadata_);
    }
    if (dimensionMetadataCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.contactcenterinsights.v1.Dimension
                      .QaQuestionAnswerDimensionMetadata)
                  dimensionMetadata_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Dimension)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.Dimension other =
        (com.google.cloud.contactcenterinsights.v1.Dimension) obj;

    if (dimensionKey_ != other.dimensionKey_) return false;
    if (!getDimensionMetadataCase().equals(other.getDimensionMetadataCase())) return false;
    switch (dimensionMetadataCase_) {
      case 2:
        if (!getIssueDimensionMetadata().equals(other.getIssueDimensionMetadata())) return false;
        break;
      case 3:
        if (!getAgentDimensionMetadata().equals(other.getAgentDimensionMetadata())) return false;
        break;
      case 4:
        if (!getQaQuestionDimensionMetadata().equals(other.getQaQuestionDimensionMetadata()))
          return false;
        break;
      case 5:
        if (!getQaQuestionAnswerDimensionMetadata()
            .equals(other.getQaQuestionAnswerDimensionMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DIMENSION_KEY_FIELD_NUMBER;
    hash = (53 * hash) + dimensionKey_;
    switch (dimensionMetadataCase_) {
      case 2:
        hash = (37 * hash) + ISSUE_DIMENSION_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getIssueDimensionMetadata().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AGENT_DIMENSION_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getAgentDimensionMetadata().hashCode();
        break;
      case 4:
        hash = (37 * hash) + QA_QUESTION_DIMENSION_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getQaQuestionDimensionMetadata().hashCode();
        break;
      case 5:
        hash = (37 * hash) + QA_QUESTION_ANSWER_DIMENSION_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getQaQuestionAnswerDimensionMetadata().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.Dimension prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A dimension determines the grouping key for the query. In SQL terms, these
   * would be part of both the "SELECT" and "GROUP BY" clauses.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Dimension}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Dimension)
      com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Dimension.class,
              com.google.cloud.contactcenterinsights.v1.Dimension.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.Dimension.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (issueDimensionMetadataBuilder_ != null) {
        issueDimensionMetadataBuilder_.clear();
      }
      if (agentDimensionMetadataBuilder_ != null) {
        agentDimensionMetadataBuilder_.clear();
      }
      if (qaQuestionDimensionMetadataBuilder_ != null) {
        qaQuestionDimensionMetadataBuilder_.clear();
      }
      if (qaQuestionAnswerDimensionMetadataBuilder_ != null) {
        qaQuestionAnswerDimensionMetadataBuilder_.clear();
      }
      dimensionKey_ = 0;
      dimensionMetadataCase_ = 0;
      dimensionMetadata_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_Dimension_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension build() {
      com.google.cloud.contactcenterinsights.v1.Dimension result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension buildPartial() {
      com.google.cloud.contactcenterinsights.v1.Dimension result =
          new com.google.cloud.contactcenterinsights.v1.Dimension(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.Dimension result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.dimensionKey_ = dimensionKey_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.contactcenterinsights.v1.Dimension result) {
      result.dimensionMetadataCase_ = dimensionMetadataCase_;
      result.dimensionMetadata_ = this.dimensionMetadata_;
      if (dimensionMetadataCase_ == 2 && issueDimensionMetadataBuilder_ != null) {
        result.dimensionMetadata_ = issueDimensionMetadataBuilder_.build();
      }
      if (dimensionMetadataCase_ == 3 && agentDimensionMetadataBuilder_ != null) {
        result.dimensionMetadata_ = agentDimensionMetadataBuilder_.build();
      }
      if (dimensionMetadataCase_ == 4 && qaQuestionDimensionMetadataBuilder_ != null) {
        result.dimensionMetadata_ = qaQuestionDimensionMetadataBuilder_.build();
      }
      if (dimensionMetadataCase_ == 5 && qaQuestionAnswerDimensionMetadataBuilder_ != null) {
        result.dimensionMetadata_ = qaQuestionAnswerDimensionMetadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.Dimension) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.Dimension) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.Dimension other) {
      if (other == com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance())
        return this;
      if (other.dimensionKey_ != 0) {
        setDimensionKeyValue(other.getDimensionKeyValue());
      }
      switch (other.getDimensionMetadataCase()) {
        case ISSUE_DIMENSION_METADATA:
          {
            mergeIssueDimensionMetadata(other.getIssueDimensionMetadata());
            break;
          }
        case AGENT_DIMENSION_METADATA:
          {
            mergeAgentDimensionMetadata(other.getAgentDimensionMetadata());
            break;
          }
        case QA_QUESTION_DIMENSION_METADATA:
          {
            mergeQaQuestionDimensionMetadata(other.getQaQuestionDimensionMetadata());
            break;
          }
        case QA_QUESTION_ANSWER_DIMENSION_METADATA:
          {
            mergeQaQuestionAnswerDimensionMetadata(other.getQaQuestionAnswerDimensionMetadata());
            break;
          }
        case DIMENSIONMETADATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                dimensionKey_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getIssueDimensionMetadataFieldBuilder().getBuilder(), extensionRegistry);
                dimensionMetadataCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getAgentDimensionMetadataFieldBuilder().getBuilder(), extensionRegistry);
                dimensionMetadataCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getQaQuestionDimensionMetadataFieldBuilder().getBuilder(), extensionRegistry);
                dimensionMetadataCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getQaQuestionAnswerDimensionMetadataFieldBuilder().getBuilder(),
                    extensionRegistry);
                dimensionMetadataCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dimensionMetadataCase_ = 0;
    private java.lang.Object dimensionMetadata_;

    public DimensionMetadataCase getDimensionMetadataCase() {
      return DimensionMetadataCase.forNumber(dimensionMetadataCase_);
    }

    public Builder clearDimensionMetadata() {
      dimensionMetadataCase_ = 0;
      dimensionMetadata_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadataOrBuilder>
        issueDimensionMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the issueDimensionMetadata field is set.
     */
    @java.lang.Override
    public boolean hasIssueDimensionMetadata() {
      return dimensionMetadataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The issueDimensionMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
        getIssueDimensionMetadata() {
      if (issueDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
            .getDefaultInstance();
      } else {
        if (dimensionMetadataCase_ == 2) {
          return issueDimensionMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIssueDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata value) {
      if (issueDimensionMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionMetadata_ = value;
        onChanged();
      } else {
        issueDimensionMetadataBuilder_.setMessage(value);
      }
      dimensionMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIssueDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder
            builderForValue) {
      if (issueDimensionMetadataBuilder_ == null) {
        dimensionMetadata_ = builderForValue.build();
        onChanged();
      } else {
        issueDimensionMetadataBuilder_.setMessage(builderForValue.build());
      }
      dimensionMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIssueDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata value) {
      if (issueDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 2
            && dimensionMetadata_
                != com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
                    .getDefaultInstance()) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
                          dimensionMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dimensionMetadata_ = value;
        }
        onChanged();
      } else {
        if (dimensionMetadataCase_ == 2) {
          issueDimensionMetadataBuilder_.mergeFrom(value);
        } else {
          issueDimensionMetadataBuilder_.setMessage(value);
        }
      }
      dimensionMetadataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIssueDimensionMetadata() {
      if (issueDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 2) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
          onChanged();
        }
      } else {
        if (dimensionMetadataCase_ == 2) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
        }
        issueDimensionMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder
        getIssueDimensionMetadataBuilder() {
      return getIssueDimensionMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadataOrBuilder
        getIssueDimensionMetadataOrBuilder() {
      if ((dimensionMetadataCase_ == 2) && (issueDimensionMetadataBuilder_ != null)) {
        return issueDimensionMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (dimensionMetadataCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the issue dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata issue_dimension_metadata = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadataOrBuilder>
        getIssueDimensionMetadataFieldBuilder() {
      if (issueDimensionMetadataBuilder_ == null) {
        if (!(dimensionMetadataCase_ == 2)) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata
                  .getDefaultInstance();
        }
        issueDimensionMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata,
                com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .IssueDimensionMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.Dimension.IssueDimensionMetadata)
                    dimensionMetadata_,
                getParentForChildren(),
                isClean());
        dimensionMetadata_ = null;
      }
      dimensionMetadataCase_ = 2;
      onChanged();
      return issueDimensionMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadataOrBuilder>
        agentDimensionMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the agentDimensionMetadata field is set.
     */
    @java.lang.Override
    public boolean hasAgentDimensionMetadata() {
      return dimensionMetadataCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The agentDimensionMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
        getAgentDimensionMetadata() {
      if (agentDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
            .getDefaultInstance();
      } else {
        if (dimensionMetadataCase_ == 3) {
          return agentDimensionMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAgentDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata value) {
      if (agentDimensionMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionMetadata_ = value;
        onChanged();
      } else {
        agentDimensionMetadataBuilder_.setMessage(value);
      }
      dimensionMetadataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAgentDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder
            builderForValue) {
      if (agentDimensionMetadataBuilder_ == null) {
        dimensionMetadata_ = builderForValue.build();
        onChanged();
      } else {
        agentDimensionMetadataBuilder_.setMessage(builderForValue.build());
      }
      dimensionMetadataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAgentDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata value) {
      if (agentDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 3
            && dimensionMetadata_
                != com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
                    .getDefaultInstance()) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
                          dimensionMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dimensionMetadata_ = value;
        }
        onChanged();
      } else {
        if (dimensionMetadataCase_ == 3) {
          agentDimensionMetadataBuilder_.mergeFrom(value);
        } else {
          agentDimensionMetadataBuilder_.setMessage(value);
        }
      }
      dimensionMetadataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAgentDimensionMetadata() {
      if (agentDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 3) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
          onChanged();
        }
      } else {
        if (dimensionMetadataCase_ == 3) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
        }
        agentDimensionMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder
        getAgentDimensionMetadataBuilder() {
      return getAgentDimensionMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadataOrBuilder
        getAgentDimensionMetadataOrBuilder() {
      if ((dimensionMetadataCase_ == 3) && (agentDimensionMetadataBuilder_ != null)) {
        return agentDimensionMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (dimensionMetadataCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the agent dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata agent_dimension_metadata = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadataOrBuilder>
        getAgentDimensionMetadataFieldBuilder() {
      if (agentDimensionMetadataBuilder_ == null) {
        if (!(dimensionMetadataCase_ == 3)) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata
                  .getDefaultInstance();
        }
        agentDimensionMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata,
                com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .AgentDimensionMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.Dimension.AgentDimensionMetadata)
                    dimensionMetadata_,
                getParentForChildren(),
                isClean());
        dimensionMetadata_ = null;
      }
      dimensionMetadataCase_ = 3;
      onChanged();
      return agentDimensionMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension
                .QaQuestionDimensionMetadataOrBuilder>
        qaQuestionDimensionMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the qaQuestionDimensionMetadata field is set.
     */
    @java.lang.Override
    public boolean hasQaQuestionDimensionMetadata() {
      return dimensionMetadataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The qaQuestionDimensionMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
        getQaQuestionDimensionMetadata() {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 4) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
            .getDefaultInstance();
      } else {
        if (dimensionMetadataCase_ == 4) {
          return qaQuestionDimensionMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata value) {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionMetadata_ = value;
        onChanged();
      } else {
        qaQuestionDimensionMetadataBuilder_.setMessage(value);
      }
      dimensionMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.Builder
            builderForValue) {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        dimensionMetadata_ = builderForValue.build();
        onChanged();
      } else {
        qaQuestionDimensionMetadataBuilder_.setMessage(builderForValue.build());
      }
      dimensionMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeQaQuestionDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata value) {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 4
            && dimensionMetadata_
                != com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                    .getDefaultInstance()) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.Dimension
                              .QaQuestionDimensionMetadata)
                          dimensionMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dimensionMetadata_ = value;
        }
        onChanged();
      } else {
        if (dimensionMetadataCase_ == 4) {
          qaQuestionDimensionMetadataBuilder_.mergeFrom(value);
        } else {
          qaQuestionDimensionMetadataBuilder_.setMessage(value);
        }
      }
      dimensionMetadataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQaQuestionDimensionMetadata() {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 4) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
          onChanged();
        }
      } else {
        if (dimensionMetadataCase_ == 4) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
        }
        qaQuestionDimensionMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.Builder
        getQaQuestionDimensionMetadataBuilder() {
      return getQaQuestionDimensionMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadataOrBuilder
        getQaQuestionDimensionMetadataOrBuilder() {
      if ((dimensionMetadataCase_ == 4) && (qaQuestionDimensionMetadataBuilder_ != null)) {
        return qaQuestionDimensionMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (dimensionMetadataCase_ == 4) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata qa_question_dimension_metadata = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata.Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension
                .QaQuestionDimensionMetadataOrBuilder>
        getQaQuestionDimensionMetadataFieldBuilder() {
      if (qaQuestionDimensionMetadataBuilder_ == null) {
        if (!(dimensionMetadataCase_ == 4)) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                  .getDefaultInstance();
        }
        qaQuestionDimensionMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata,
                com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionDimensionMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionDimensionMetadata)
                    dimensionMetadata_,
                getParentForChildren(),
                isClean());
        dimensionMetadata_ = null;
      }
      dimensionMetadataCase_ = 4;
      onChanged();
      return qaQuestionDimensionMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                .Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension
                .QaQuestionAnswerDimensionMetadataOrBuilder>
        qaQuestionAnswerDimensionMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the qaQuestionAnswerDimensionMetadata field is set.
     */
    @java.lang.Override
    public boolean hasQaQuestionAnswerDimensionMetadata() {
      return dimensionMetadataCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The qaQuestionAnswerDimensionMetadata.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
        getQaQuestionAnswerDimensionMetadata() {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 5) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension
                  .QaQuestionAnswerDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            .getDefaultInstance();
      } else {
        if (dimensionMetadataCase_ == 5) {
          return qaQuestionAnswerDimensionMetadataBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionAnswerDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            value) {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dimensionMetadata_ = value;
        onChanged();
      } else {
        qaQuestionAnswerDimensionMetadataBuilder_.setMessage(value);
      }
      dimensionMetadataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionAnswerDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                .Builder
            builderForValue) {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        dimensionMetadata_ = builderForValue.build();
        onChanged();
      } else {
        qaQuestionAnswerDimensionMetadataBuilder_.setMessage(builderForValue.build());
      }
      dimensionMetadataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeQaQuestionAnswerDimensionMetadata(
        com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            value) {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 5
            && dimensionMetadata_
                != com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata.getDefaultInstance()) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.Dimension
                              .QaQuestionAnswerDimensionMetadata)
                          dimensionMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dimensionMetadata_ = value;
        }
        onChanged();
      } else {
        if (dimensionMetadataCase_ == 5) {
          qaQuestionAnswerDimensionMetadataBuilder_.mergeFrom(value);
        } else {
          qaQuestionAnswerDimensionMetadataBuilder_.setMessage(value);
        }
      }
      dimensionMetadataCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQaQuestionAnswerDimensionMetadata() {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        if (dimensionMetadataCase_ == 5) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
          onChanged();
        }
      } else {
        if (dimensionMetadataCase_ == 5) {
          dimensionMetadataCase_ = 0;
          dimensionMetadata_ = null;
        }
        qaQuestionAnswerDimensionMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            .Builder
        getQaQuestionAnswerDimensionMetadataBuilder() {
      return getQaQuestionAnswerDimensionMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension
            .QaQuestionAnswerDimensionMetadataOrBuilder
        getQaQuestionAnswerDimensionMetadataOrBuilder() {
      if ((dimensionMetadataCase_ == 5) && (qaQuestionAnswerDimensionMetadataBuilder_ != null)) {
        return qaQuestionAnswerDimensionMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (dimensionMetadataCase_ == 5) {
          return (com.google.cloud.contactcenterinsights.v1.Dimension
                  .QaQuestionAnswerDimensionMetadata)
              dimensionMetadata_;
        }
        return com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata about the QA question-answer dimension.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata qa_question_answer_dimension_metadata = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata,
            com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                .Builder,
            com.google.cloud.contactcenterinsights.v1.Dimension
                .QaQuestionAnswerDimensionMetadataOrBuilder>
        getQaQuestionAnswerDimensionMetadataFieldBuilder() {
      if (qaQuestionAnswerDimensionMetadataBuilder_ == null) {
        if (!(dimensionMetadataCase_ == 5)) {
          dimensionMetadata_ =
              com.google.cloud.contactcenterinsights.v1.Dimension.QaQuestionAnswerDimensionMetadata
                  .getDefaultInstance();
        }
        qaQuestionAnswerDimensionMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadata.Builder,
                com.google.cloud.contactcenterinsights.v1.Dimension
                    .QaQuestionAnswerDimensionMetadataOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.Dimension
                        .QaQuestionAnswerDimensionMetadata)
                    dimensionMetadata_,
                getParentForChildren(),
                isClean());
        dimensionMetadata_ = null;
      }
      dimensionMetadataCase_ = 5;
      onChanged();
      return qaQuestionAnswerDimensionMetadataBuilder_;
    }

    private int dimensionKey_ = 0;
    /**
     *
     *
     * <pre>
     * The key of the dimension.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
     *
     * @return The enum numeric value on the wire for dimensionKey.
     */
    @java.lang.Override
    public int getDimensionKeyValue() {
      return dimensionKey_;
    }
    /**
     *
     *
     * <pre>
     * The key of the dimension.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
     *
     * @param value The enum numeric value on the wire for dimensionKey to set.
     * @return This builder for chaining.
     */
    public Builder setDimensionKeyValue(int value) {
      dimensionKey_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the dimension.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
     *
     * @return The dimensionKey.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey getDimensionKey() {
      com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey result =
          com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey.forNumber(dimensionKey_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The key of the dimension.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
     *
     * @param value The dimensionKey to set.
     * @return This builder for chaining.
     */
    public Builder setDimensionKey(
        com.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      dimensionKey_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the dimension.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Dimension.DimensionKey dimension_key = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDimensionKey() {
      bitField0_ = (bitField0_ & ~0x00000010);
      dimensionKey_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Dimension)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Dimension)
  private static final com.google.cloud.contactcenterinsights.v1.Dimension DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Dimension();
  }

  public static com.google.cloud.contactcenterinsights.v1.Dimension getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dimension> PARSER =
      new com.google.protobuf.AbstractParser<Dimension>() {
        @java.lang.Override
        public Dimension parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Dimension> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dimension> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
