/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The request to export insights.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest}
 */
public final class ExportInsightsDataRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest)
    ExportInsightsDataRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ExportInsightsDataRequest.newBuilder() to construct.
  private ExportInsightsDataRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ExportInsightsDataRequest() {
    parent_ = "";
    filter_ = "";
    kmsKey_ = "";
    writeDisposition_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ExportInsightsDataRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.class,
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies the action that occurs if the destination table already exists.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition}
   */
  public enum WriteDisposition implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Write disposition is not specified. Defaults to WRITE_TRUNCATE.
     * </pre>
     *
     * <code>WRITE_DISPOSITION_UNSPECIFIED = 0;</code>
     */
    WRITE_DISPOSITION_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * If the table already exists, BigQuery will overwrite the table data and
     * use the schema from the load.
     * </pre>
     *
     * <code>WRITE_TRUNCATE = 1;</code>
     */
    WRITE_TRUNCATE(1),
    /**
     *
     *
     * <pre>
     * If the table already exists, BigQuery will append data to the table.
     * </pre>
     *
     * <code>WRITE_APPEND = 2;</code>
     */
    WRITE_APPEND(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Write disposition is not specified. Defaults to WRITE_TRUNCATE.
     * </pre>
     *
     * <code>WRITE_DISPOSITION_UNSPECIFIED = 0;</code>
     */
    public static final int WRITE_DISPOSITION_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * If the table already exists, BigQuery will overwrite the table data and
     * use the schema from the load.
     * </pre>
     *
     * <code>WRITE_TRUNCATE = 1;</code>
     */
    public static final int WRITE_TRUNCATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If the table already exists, BigQuery will append data to the table.
     * </pre>
     *
     * <code>WRITE_APPEND = 2;</code>
     */
    public static final int WRITE_APPEND_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static WriteDisposition valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static WriteDisposition forNumber(int value) {
      switch (value) {
        case 0:
          return WRITE_DISPOSITION_UNSPECIFIED;
        case 1:
          return WRITE_TRUNCATE;
        case 2:
          return WRITE_APPEND;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<WriteDisposition> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<WriteDisposition>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<WriteDisposition>() {
              public WriteDisposition findValueByNumber(int number) {
                return WriteDisposition.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final WriteDisposition[] VALUES = values();

    public static WriteDisposition valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private WriteDisposition(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition)
  }

  public interface BigQueryDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A project ID or number. If specified, then export will attempt to
     * write data to this project instead of the resource project. Otherwise,
     * the resource project will be used.
     * </pre>
     *
     * <code>string project_id = 3;</code>
     *
     * @return The projectId.
     */
    java.lang.String getProjectId();
    /**
     *
     *
     * <pre>
     * A project ID or number. If specified, then export will attempt to
     * write data to this project instead of the resource project. Otherwise,
     * the resource project will be used.
     * </pre>
     *
     * <code>string project_id = 3;</code>
     *
     * @return The bytes for projectId.
     */
    com.google.protobuf.ByteString getProjectIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The name of the BigQuery dataset that the snapshot result
     * should be exported to. If this dataset does not exist, the export call
     * returns an INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The dataset.
     */
    java.lang.String getDataset();
    /**
     *
     *
     * <pre>
     * Required. The name of the BigQuery dataset that the snapshot result
     * should be exported to. If this dataset does not exist, the export call
     * returns an INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for dataset.
     */
    com.google.protobuf.ByteString getDatasetBytes();

    /**
     *
     *
     * <pre>
     * The BigQuery table name to which the insights data should be written.
     * If this table does not exist, the export call returns an INVALID_ARGUMENT
     * error.
     * </pre>
     *
     * <code>string table = 2;</code>
     *
     * @return The table.
     */
    java.lang.String getTable();
    /**
     *
     *
     * <pre>
     * The BigQuery table name to which the insights data should be written.
     * If this table does not exist, the export call returns an INVALID_ARGUMENT
     * error.
     * </pre>
     *
     * <code>string table = 2;</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();
  }
  /**
   *
   *
   * <pre>
   * A BigQuery Table Reference.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination}
   */
  public static final class BigQueryDestination extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
      BigQueryDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BigQueryDestination.newBuilder() to construct.
    private BigQueryDestination(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BigQueryDestination() {
      projectId_ = "";
      dataset_ = "";
      table_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BigQueryDestination();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_BigQueryDestination_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_BigQueryDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination.class,
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination.Builder.class);
    }

    public static final int PROJECT_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * A project ID or number. If specified, then export will attempt to
     * write data to this project instead of the resource project. Otherwise,
     * the resource project will be used.
     * </pre>
     *
     * <code>string project_id = 3;</code>
     *
     * @return The projectId.
     */
    @java.lang.Override
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A project ID or number. If specified, then export will attempt to
     * write data to this project instead of the resource project. Otherwise,
     * the resource project will be used.
     * </pre>
     *
     * <code>string project_id = 3;</code>
     *
     * @return The bytes for projectId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the BigQuery dataset that the snapshot result
     * should be exported to. If this dataset does not exist, the export call
     * returns an INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The dataset.
     */
    @java.lang.Override
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the BigQuery dataset that the snapshot result
     * should be exported to. If this dataset does not exist, the export call
     * returns an INVALID_ARGUMENT error.
     * </pre>
     *
     * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for dataset.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TABLE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * The BigQuery table name to which the insights data should be written.
     * If this table does not exist, the export call returns an INVALID_ARGUMENT
     * error.
     * </pre>
     *
     * <code>string table = 2;</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The BigQuery table name to which the insights data should be written.
     * If this table does not exist, the export call returns an INVALID_ARGUMENT
     * error.
     * </pre>
     *
     * <code>string table = 2;</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, table_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, projectId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, table_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, projectId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
              .BigQueryDestination)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
          other =
              (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                      .BigQueryDestination)
                  obj;

      if (!getProjectId().equals(other.getProjectId())) return false;
      if (!getDataset().equals(other.getDataset())) return false;
      if (!getTable().equals(other.getTable())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getProjectId().hashCode();
      hash = (37 * hash) + DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getDataset().hashCode();
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A BigQuery Table Reference.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestinationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_BigQueryDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination.class,
                com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        projectId_ = "";
        dataset_ = "";
        table_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_BigQueryDestination_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
          build() {
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            result =
                new com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.projectId_ = projectId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dataset_ = dataset_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.table_ = table_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                .BigQueryDestination) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                      .BigQueryDestination)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                .BigQueryDestination.getDefaultInstance()) return this;
        if (!other.getProjectId().isEmpty()) {
          projectId_ = other.projectId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDataset().isEmpty()) {
          dataset_ = other.dataset_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataset_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 10
              case 18:
                {
                  table_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 18
              case 26:
                {
                  projectId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object projectId_ = "";
      /**
       *
       *
       * <pre>
       * A project ID or number. If specified, then export will attempt to
       * write data to this project instead of the resource project. Otherwise,
       * the resource project will be used.
       * </pre>
       *
       * <code>string project_id = 3;</code>
       *
       * @return The projectId.
       */
      public java.lang.String getProjectId() {
        java.lang.Object ref = projectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          projectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A project ID or number. If specified, then export will attempt to
       * write data to this project instead of the resource project. Otherwise,
       * the resource project will be used.
       * </pre>
       *
       * <code>string project_id = 3;</code>
       *
       * @return The bytes for projectId.
       */
      public com.google.protobuf.ByteString getProjectIdBytes() {
        java.lang.Object ref = projectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          projectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A project ID or number. If specified, then export will attempt to
       * write data to this project instead of the resource project. Otherwise,
       * the resource project will be used.
       * </pre>
       *
       * <code>string project_id = 3;</code>
       *
       * @param value The projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A project ID or number. If specified, then export will attempt to
       * write data to this project instead of the resource project. Otherwise,
       * the resource project will be used.
       * </pre>
       *
       * <code>string project_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearProjectId() {
        projectId_ = getDefaultInstance().getProjectId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A project ID or number. If specified, then export will attempt to
       * write data to this project instead of the resource project. Otherwise,
       * the resource project will be used.
       * </pre>
       *
       * <code>string project_id = 3;</code>
       *
       * @param value The bytes for projectId to set.
       * @return This builder for chaining.
       */
      public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        projectId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object dataset_ = "";
      /**
       *
       *
       * <pre>
       * Required. The name of the BigQuery dataset that the snapshot result
       * should be exported to. If this dataset does not exist, the export call
       * returns an INVALID_ARGUMENT error.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The dataset.
       */
      public java.lang.String getDataset() {
        java.lang.Object ref = dataset_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataset_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the BigQuery dataset that the snapshot result
       * should be exported to. If this dataset does not exist, the export call
       * returns an INVALID_ARGUMENT error.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for dataset.
       */
      public com.google.protobuf.ByteString getDatasetBytes() {
        java.lang.Object ref = dataset_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataset_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the BigQuery dataset that the snapshot result
       * should be exported to. If this dataset does not exist, the export call
       * returns an INVALID_ARGUMENT error.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDataset(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the BigQuery dataset that the snapshot result
       * should be exported to. If this dataset does not exist, the export call
       * returns an INVALID_ARGUMENT error.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataset() {
        dataset_ = getDefaultInstance().getDataset();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The name of the BigQuery dataset that the snapshot result
       * should be exported to. If this dataset does not exist, the export call
       * returns an INVALID_ARGUMENT error.
       * </pre>
       *
       * <code>string dataset = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for dataset to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataset_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object table_ = "";
      /**
       *
       *
       * <pre>
       * The BigQuery table name to which the insights data should be written.
       * If this table does not exist, the export call returns an INVALID_ARGUMENT
       * error.
       * </pre>
       *
       * <code>string table = 2;</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table name to which the insights data should be written.
       * If this table does not exist, the export call returns an INVALID_ARGUMENT
       * error.
       * </pre>
       *
       * <code>string table = 2;</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table name to which the insights data should be written.
       * If this table does not exist, the export call returns an INVALID_ARGUMENT
       * error.
       * </pre>
       *
       * <code>string table = 2;</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        table_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table name to which the insights data should be written.
       * If this table does not exist, the export call returns an INVALID_ARGUMENT
       * error.
       * </pre>
       *
       * <code>string table = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {
        table_ = getDefaultInstance().getTable();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The BigQuery table name to which the insights data should be written.
       * If this table does not exist, the export call returns an INVALID_ARGUMENT
       * error.
       * </pre>
       *
       * <code>string table = 2;</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        table_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
    private static final com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
              .BigQueryDestination();
    }

    public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BigQueryDestination> PARSER =
        new com.google.protobuf.AbstractParser<BigQueryDestination>() {
          @java.lang.Override
          public BigQueryDestination parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BigQueryDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BigQueryDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIG_QUERY_DESTINATION(2),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 2:
          return BIG_QUERY_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int BIG_QUERY_DESTINATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Specified if sink is a BigQuery table.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
   * </code>
   *
   * @return Whether the bigQueryDestination field is set.
   */
  @java.lang.Override
  public boolean hasBigQueryDestination() {
    return destinationCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Specified if sink is a BigQuery table.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
   * </code>
   *
   * @return The bigQueryDestination.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
      getBigQueryDestination() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
              .BigQueryDestination)
          destination_;
    }
    return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specified if sink is a BigQuery table.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
          .BigQueryDestinationOrBuilder
      getBigQueryDestinationOrBuilder() {
    if (destinationCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
              .BigQueryDestination)
          destination_;
    }
    return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
        .getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource to export data from.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource to export data from.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * A filter to reduce results to a specific subset. Useful for exporting
   * conversations with specific properties.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A filter to reduce results to a specific subset. Useful for exporting
   * conversations with specific properties.
   * </pre>
   *
   * <code>string filter = 3;</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";
  /**
   *
   *
   * <pre>
   * A fully qualified KMS key name for BigQuery tables protected by CMEK.
   * Format:
   * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
   * </pre>
   *
   * <code>string kms_key = 4;</code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A fully qualified KMS key name for BigQuery tables protected by CMEK.
   * Format:
   * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
   * </pre>
   *
   * <code>string kms_key = 4;</code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WRITE_DISPOSITION_FIELD_NUMBER = 5;
  private int writeDisposition_ = 0;
  /**
   *
   *
   * <pre>
   * Options for what to do if the destination table already exists.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for writeDisposition.
   */
  @java.lang.Override
  public int getWriteDispositionValue() {
    return writeDisposition_;
  }
  /**
   *
   *
   * <pre>
   * Options for what to do if the destination table already exists.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
   * </code>
   *
   * @return The writeDisposition.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
      getWriteDisposition() {
    com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition result =
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
            .forNumber(writeDisposition_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
            .UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (destinationCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination)
              destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, kmsKey_);
    }
    if (writeDisposition_
        != com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
            .WRITE_DISPOSITION_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, writeDisposition_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (destinationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                      .BigQueryDestination)
                  destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, filter_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, kmsKey_);
    }
    if (writeDisposition_
        != com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
            .WRITE_DISPOSITION_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, writeDisposition_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest other =
        (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (writeDisposition_ != other.writeDisposition_) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 2:
        if (!getBigQueryDestination().equals(other.getBigQueryDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    hash = (37 * hash) + WRITE_DISPOSITION_FIELD_NUMBER;
    hash = (53 * hash) + writeDisposition_;
    switch (destinationCase_) {
      case 2:
        hash = (37 * hash) + BIG_QUERY_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getBigQueryDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request to export insights.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest)
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.class,
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (bigQueryDestinationBuilder_ != null) {
        bigQueryDestinationBuilder_.clear();
      }
      parent_ = "";
      filter_ = "";
      kmsKey_ = "";
      writeDisposition_ = 0;
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_ExportInsightsDataRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest build() {
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest buildPartial() {
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest result =
          new com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.writeDisposition_ = writeDisposition_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 2 && bigQueryDestinationBuilder_ != null) {
        result.destination_ = bigQueryDestinationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.writeDisposition_ != 0) {
        setWriteDispositionValue(other.getWriteDispositionValue());
      }
      switch (other.getDestinationCase()) {
        case BIG_QUERY_DESTINATION:
          {
            mergeBigQueryDestination(other.getBigQueryDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getBigQueryDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                writeDisposition_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination,
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
                .Builder,
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                .BigQueryDestinationOrBuilder>
        bigQueryDestinationBuilder_;
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     *
     * @return Whether the bigQueryDestination field is set.
     */
    @java.lang.Override
    public boolean hasBigQueryDestination() {
      return destinationCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     *
     * @return The bigQueryDestination.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
        getBigQueryDestination() {
      if (bigQueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination)
              destination_;
        }
        return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 2) {
          return bigQueryDestinationBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    public Builder setBigQueryDestination(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            value) {
      if (bigQueryDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        bigQueryDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    public Builder setBigQueryDestination(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
                .Builder
            builderForValue) {
      if (bigQueryDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        bigQueryDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    public Builder mergeBigQueryDestination(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            value) {
      if (bigQueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2
            && destination_
                != com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                              .BigQueryDestination)
                          destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 2) {
          bigQueryDestinationBuilder_.mergeFrom(value);
        } else {
          bigQueryDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    public Builder clearBigQueryDestination() {
      if (bigQueryDestinationBuilder_ == null) {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 2) {
          destinationCase_ = 0;
          destination_ = null;
        }
        bigQueryDestinationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
            .Builder
        getBigQueryDestinationBuilder() {
      return getBigQueryDestinationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestinationOrBuilder
        getBigQueryDestinationOrBuilder() {
      if ((destinationCase_ == 2) && (bigQueryDestinationBuilder_ != null)) {
        return bigQueryDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination)
              destination_;
        }
        return com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
            .BigQueryDestination.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specified if sink is a BigQuery table.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination big_query_destination = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination,
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.BigQueryDestination
                .Builder,
            com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                .BigQueryDestinationOrBuilder>
        getBigQueryDestinationFieldBuilder() {
      if (bigQueryDestinationBuilder_ == null) {
        if (!(destinationCase_ == 2)) {
          destination_ =
              com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                  .BigQueryDestination.getDefaultInstance();
        }
        bigQueryDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination,
                com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestination.Builder,
                com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                    .BigQueryDestinationOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
                        .BigQueryDestination)
                    destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 2;
      onChanged();
      return bigQueryDestinationBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource to export data from.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource to export data from.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource to export data from.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource to export data from.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource to export data from.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * A filter to reduce results to a specific subset. Useful for exporting
     * conversations with specific properties.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter to reduce results to a specific subset. Useful for exporting
     * conversations with specific properties.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A filter to reduce results to a specific subset. Useful for exporting
     * conversations with specific properties.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to reduce results to a specific subset. Useful for exporting
     * conversations with specific properties.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A filter to reduce results to a specific subset. Useful for exporting
     * conversations with specific properties.
     * </pre>
     *
     * <code>string filter = 3;</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKey_ = "";
    /**
     *
     *
     * <pre>
     * A fully qualified KMS key name for BigQuery tables protected by CMEK.
     * Format:
     * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     * </pre>
     *
     * <code>string kms_key = 4;</code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fully qualified KMS key name for BigQuery tables protected by CMEK.
     * Format:
     * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     * </pre>
     *
     * <code>string kms_key = 4;</code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fully qualified KMS key name for BigQuery tables protected by CMEK.
     * Format:
     * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     * </pre>
     *
     * <code>string kms_key = 4;</code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fully qualified KMS key name for BigQuery tables protected by CMEK.
     * Format:
     * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     * </pre>
     *
     * <code>string kms_key = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fully qualified KMS key name for BigQuery tables protected by CMEK.
     * Format:
     * projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}
     * </pre>
     *
     * <code>string kms_key = 4;</code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private int writeDisposition_ = 0;
    /**
     *
     *
     * <pre>
     * Options for what to do if the destination table already exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for writeDisposition.
     */
    @java.lang.Override
    public int getWriteDispositionValue() {
      return writeDisposition_;
    }
    /**
     *
     *
     * <pre>
     * Options for what to do if the destination table already exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for writeDisposition to set.
     * @return This builder for chaining.
     */
    public Builder setWriteDispositionValue(int value) {
      writeDisposition_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for what to do if the destination table already exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
     * </code>
     *
     * @return The writeDisposition.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
        getWriteDisposition() {
      com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition result =
          com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
              .forNumber(writeDisposition_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Options for what to do if the destination table already exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
     * </code>
     *
     * @param value The writeDisposition to set.
     * @return This builder for chaining.
     */
    public Builder setWriteDisposition(
        com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      writeDisposition_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for what to do if the destination table already exists.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest.WriteDisposition write_disposition = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWriteDisposition() {
      bitField0_ = (bitField0_ & ~0x00000010);
      writeDisposition_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest)
  private static final com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest();
  }

  public static com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ExportInsightsDataRequest> PARSER =
      new com.google.protobuf.AbstractParser<ExportInsightsDataRequest>() {
        @java.lang.Override
        public ExportInsightsDataRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ExportInsightsDataRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ExportInsightsDataRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.ExportInsightsDataRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
