/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Represents a conversation, resource, and label provided by the user.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.FeedbackLabel}
 */
public final class FeedbackLabel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.FeedbackLabel)
    FeedbackLabelOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FeedbackLabel.newBuilder() to construct.
  private FeedbackLabel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeedbackLabel() {
    name_ = "";
    labeledResource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeedbackLabel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_FeedbackLabel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_FeedbackLabel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.FeedbackLabel.class,
            com.google.cloud.contactcenterinsights.v1.FeedbackLabel.Builder.class);
  }

  private int bitField0_;
  private int labelTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object labelType_;

  public enum LabelTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    LABEL(4),
    QA_ANSWER_LABEL(7),
    LABELTYPE_NOT_SET(0);
    private final int value;

    private LabelTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LabelTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static LabelTypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return LABEL;
        case 7:
          return QA_ANSWER_LABEL;
        case 0:
          return LABELTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public LabelTypeCase getLabelTypeCase() {
    return LabelTypeCase.forNumber(labelTypeCase_);
  }

  public static final int LABEL_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * String label.
   * </pre>
   *
   * <code>string label = 4;</code>
   *
   * @return Whether the label field is set.
   */
  public boolean hasLabel() {
    return labelTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * String label.
   * </pre>
   *
   * <code>string label = 4;</code>
   *
   * @return The label.
   */
  public java.lang.String getLabel() {
    java.lang.Object ref = "";
    if (labelTypeCase_ == 4) {
      ref = labelType_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (labelTypeCase_ == 4) {
        labelType_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * String label.
   * </pre>
   *
   * <code>string label = 4;</code>
   *
   * @return The bytes for label.
   */
  public com.google.protobuf.ByteString getLabelBytes() {
    java.lang.Object ref = "";
    if (labelTypeCase_ == 4) {
      ref = labelType_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (labelTypeCase_ == 4) {
        labelType_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QA_ANSWER_LABEL_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * QaAnswer label.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
   *
   * @return Whether the qaAnswerLabel field is set.
   */
  @java.lang.Override
  public boolean hasQaAnswerLabel() {
    return labelTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * QaAnswer label.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
   *
   * @return The qaAnswerLabel.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getQaAnswerLabel() {
    if (labelTypeCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_;
    }
    return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * QaAnswer label.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
      getQaAnswerLabelOrBuilder() {
    if (labelTypeCase_ == 7) {
      return (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_;
    }
    return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the FeedbackLabel.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the FeedbackLabel.
   * Format:
   * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELED_RESOURCE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labeledResource_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the resource to be labeled.
   * </pre>
   *
   * <code>string labeled_resource = 3;</code>
   *
   * @return The labeledResource.
   */
  @java.lang.Override
  public java.lang.String getLabeledResource() {
    java.lang.Object ref = labeledResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labeledResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the resource to be labeled.
   * </pre>
   *
   * <code>string labeled_resource = 3;</code>
   *
   * @return The bytes for labeledResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabeledResourceBytes() {
    java.lang.Object ref = labeledResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labeledResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Create time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Create time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Update time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Update time of the label.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labeledResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, labeledResource_);
    }
    if (labelTypeCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, labelType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getUpdateTime());
    }
    if (labelTypeCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(labeledResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, labeledResource_);
    }
    if (labelTypeCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, labelType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getUpdateTime());
    }
    if (labelTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.FeedbackLabel)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.FeedbackLabel other =
        (com.google.cloud.contactcenterinsights.v1.FeedbackLabel) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLabeledResource().equals(other.getLabeledResource())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getLabelTypeCase().equals(other.getLabelTypeCase())) return false;
    switch (labelTypeCase_) {
      case 4:
        if (!getLabel().equals(other.getLabel())) return false;
        break;
      case 7:
        if (!getQaAnswerLabel().equals(other.getQaAnswerLabel())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LABELED_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLabeledResource().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    switch (labelTypeCase_) {
      case 4:
        hash = (37 * hash) + LABEL_FIELD_NUMBER;
        hash = (53 * hash) + getLabel().hashCode();
        break;
      case 7:
        hash = (37 * hash) + QA_ANSWER_LABEL_FIELD_NUMBER;
        hash = (53 * hash) + getQaAnswerLabel().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.FeedbackLabel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a conversation, resource, and label provided by the user.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.FeedbackLabel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.FeedbackLabel)
      com.google.cloud.contactcenterinsights.v1.FeedbackLabelOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FeedbackLabel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FeedbackLabel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.FeedbackLabel.class,
              com.google.cloud.contactcenterinsights.v1.FeedbackLabel.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.FeedbackLabel.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (qaAnswerLabelBuilder_ != null) {
        qaAnswerLabelBuilder_.clear();
      }
      name_ = "";
      labeledResource_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      labelTypeCase_ = 0;
      labelType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_FeedbackLabel_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FeedbackLabel getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.FeedbackLabel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FeedbackLabel build() {
      com.google.cloud.contactcenterinsights.v1.FeedbackLabel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.FeedbackLabel buildPartial() {
      com.google.cloud.contactcenterinsights.v1.FeedbackLabel result =
          new com.google.cloud.contactcenterinsights.v1.FeedbackLabel(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.FeedbackLabel result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labeledResource_ = labeledResource_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.FeedbackLabel result) {
      result.labelTypeCase_ = labelTypeCase_;
      result.labelType_ = this.labelType_;
      if (labelTypeCase_ == 7 && qaAnswerLabelBuilder_ != null) {
        result.labelType_ = qaAnswerLabelBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.FeedbackLabel) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.FeedbackLabel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.FeedbackLabel other) {
      if (other == com.google.cloud.contactcenterinsights.v1.FeedbackLabel.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLabeledResource().isEmpty()) {
        labeledResource_ = other.labeledResource_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      switch (other.getLabelTypeCase()) {
        case LABEL:
          {
            labelTypeCase_ = 4;
            labelType_ = other.labelType_;
            onChanged();
            break;
          }
        case QA_ANSWER_LABEL:
          {
            mergeQaAnswerLabel(other.getQaAnswerLabel());
            break;
          }
        case LABELTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 26:
              {
                labeledResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                labelTypeCase_ = 4;
                labelType_ = s;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getQaAnswerLabelFieldBuilder().getBuilder(), extensionRegistry);
                labelTypeCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int labelTypeCase_ = 0;
    private java.lang.Object labelType_;

    public LabelTypeCase getLabelTypeCase() {
      return LabelTypeCase.forNumber(labelTypeCase_);
    }

    public Builder clearLabelType() {
      labelTypeCase_ = 0;
      labelType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @return Whether the label field is set.
     */
    @java.lang.Override
    public boolean hasLabel() {
      return labelTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @return The label.
     */
    @java.lang.Override
    public java.lang.String getLabel() {
      java.lang.Object ref = "";
      if (labelTypeCase_ == 4) {
        ref = labelType_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (labelTypeCase_ == 4) {
          labelType_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @return The bytes for label.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLabelBytes() {
      java.lang.Object ref = "";
      if (labelTypeCase_ == 4) {
        ref = labelType_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (labelTypeCase_ == 4) {
          labelType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @param value The label to set.
     * @return This builder for chaining.
     */
    public Builder setLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelTypeCase_ = 4;
      labelType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabel() {
      if (labelTypeCase_ == 4) {
        labelTypeCase_ = 0;
        labelType_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * String label.
     * </pre>
     *
     * <code>string label = 4;</code>
     *
     * @param value The bytes for label to set.
     * @return This builder for chaining.
     */
    public Builder setLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelTypeCase_ = 4;
      labelType_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
        qaAnswerLabelBuilder_;
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     *
     * @return Whether the qaAnswerLabel field is set.
     */
    @java.lang.Override
    public boolean hasQaAnswerLabel() {
      return labelTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     *
     * @return The qaAnswerLabel.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getQaAnswerLabel() {
      if (qaAnswerLabelBuilder_ == null) {
        if (labelTypeCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_;
        }
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
      } else {
        if (labelTypeCase_ == 7) {
          return qaAnswerLabelBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    public Builder setQaAnswerLabel(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
      if (qaAnswerLabelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelType_ = value;
        onChanged();
      } else {
        qaAnswerLabelBuilder_.setMessage(value);
      }
      labelTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    public Builder setQaAnswerLabel(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder builderForValue) {
      if (qaAnswerLabelBuilder_ == null) {
        labelType_ = builderForValue.build();
        onChanged();
      } else {
        qaAnswerLabelBuilder_.setMessage(builderForValue.build());
      }
      labelTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    public Builder mergeQaAnswerLabel(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
      if (qaAnswerLabelBuilder_ == null) {
        if (labelTypeCase_ == 7
            && labelType_
                != com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
                    .getDefaultInstance()) {
          labelType_ =
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          labelType_ = value;
        }
        onChanged();
      } else {
        if (labelTypeCase_ == 7) {
          qaAnswerLabelBuilder_.mergeFrom(value);
        } else {
          qaAnswerLabelBuilder_.setMessage(value);
        }
      }
      labelTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    public Builder clearQaAnswerLabel() {
      if (qaAnswerLabelBuilder_ == null) {
        if (labelTypeCase_ == 7) {
          labelTypeCase_ = 0;
          labelType_ = null;
          onChanged();
        }
      } else {
        if (labelTypeCase_ == 7) {
          labelTypeCase_ = 0;
          labelType_ = null;
        }
        qaAnswerLabelBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder
        getQaAnswerLabelBuilder() {
      return getQaAnswerLabelFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
        getQaAnswerLabelOrBuilder() {
      if ((labelTypeCase_ == 7) && (qaAnswerLabelBuilder_ != null)) {
        return qaAnswerLabelBuilder_.getMessageOrBuilder();
      } else {
        if (labelTypeCase_ == 7) {
          return (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_;
        }
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * QaAnswer label.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue qa_answer_label = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
        getQaAnswerLabelFieldBuilder() {
      if (qaAnswerLabelBuilder_ == null) {
        if (!(labelTypeCase_ == 7)) {
          labelType_ =
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
        }
        qaAnswerLabelBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) labelType_,
                getParentForChildren(),
                isClean());
        labelType_ = null;
      }
      labelTypeCase_ = 7;
      onChanged();
      return qaAnswerLabelBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the FeedbackLabel.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the FeedbackLabel.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the FeedbackLabel.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the FeedbackLabel.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the FeedbackLabel.
     * Format:
     * projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object labeledResource_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the resource to be labeled.
     * </pre>
     *
     * <code>string labeled_resource = 3;</code>
     *
     * @return The labeledResource.
     */
    public java.lang.String getLabeledResource() {
      java.lang.Object ref = labeledResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labeledResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the resource to be labeled.
     * </pre>
     *
     * <code>string labeled_resource = 3;</code>
     *
     * @return The bytes for labeledResource.
     */
    public com.google.protobuf.ByteString getLabeledResourceBytes() {
      java.lang.Object ref = labeledResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labeledResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the resource to be labeled.
     * </pre>
     *
     * <code>string labeled_resource = 3;</code>
     *
     * @param value The labeledResource to set.
     * @return This builder for chaining.
     */
    public Builder setLabeledResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labeledResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the resource to be labeled.
     * </pre>
     *
     * <code>string labeled_resource = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabeledResource() {
      labeledResource_ = getDefaultInstance().getLabeledResource();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the resource to be labeled.
     * </pre>
     *
     * <code>string labeled_resource = 3;</code>
     *
     * @param value The bytes for labeledResource to set.
     * @return This builder for chaining.
     */
    public Builder setLabeledResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labeledResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Create time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Update time of the label.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.FeedbackLabel)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.FeedbackLabel)
  private static final com.google.cloud.contactcenterinsights.v1.FeedbackLabel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.FeedbackLabel();
  }

  public static com.google.cloud.contactcenterinsights.v1.FeedbackLabel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeedbackLabel> PARSER =
      new com.google.protobuf.AbstractParser<FeedbackLabel>() {
        @java.lang.Override
        public FeedbackLabel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeedbackLabel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeedbackLabel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.FeedbackLabel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
