/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The request to ingest conversations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.IngestConversationsRequest}
 */
public final class IngestConversationsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest)
    IngestConversationsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use IngestConversationsRequest.newBuilder() to construct.
  private IngestConversationsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private IngestConversationsRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new IngestConversationsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.class,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder.class);
  }

  public interface GcsSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket containing source objects.
     * </pre>
     *
     * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketUri.
     */
    java.lang.String getBucketUri();
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket containing source objects.
     * </pre>
     *
     * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketUri.
     */
    com.google.protobuf.ByteString getBucketUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. Specifies the type of the objects in `bucket_uri`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for bucketObjectType.
     */
    int getBucketObjectTypeValue();
    /**
     *
     *
     * <pre>
     * Optional. Specifies the type of the objects in `bucket_uri`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bucketObjectType.
     */
    com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType
        getBucketObjectType();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the metadataBucketUri field is set.
     */
    boolean hasMetadataBucketUri();
    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metadataBucketUri.
     */
    java.lang.String getMetadataBucketUri();
    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for metadataBucketUri.
     */
    com.google.protobuf.ByteString getMetadataBucketUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the customMetadataKeys.
     */
    java.util.List<java.lang.String> getCustomMetadataKeysList();
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of customMetadataKeys.
     */
    int getCustomMetadataKeysCount();
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The customMetadataKeys at the given index.
     */
    java.lang.String getCustomMetadataKeys(int index);
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customMetadataKeys at the given index.
     */
    com.google.protobuf.ByteString getCustomMetadataKeysBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration for Cloud Storage bucket sources.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource}
   */
  public static final class GcsSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
      GcsSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GcsSource.newBuilder() to construct.
    private GcsSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GcsSource() {
      bucketUri_ = "";
      bucketObjectType_ = 0;
      metadataBucketUri_ = "";
      customMetadataKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GcsSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_GcsSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_GcsSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.Builder
                  .class);
    }

    /**
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType}
     */
    public enum BucketObjectType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The object type is unspecified and will default to `TRANSCRIPT`.
       * </pre>
       *
       * <code>BUCKET_OBJECT_TYPE_UNSPECIFIED = 0;</code>
       */
      BUCKET_OBJECT_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The object is a transcript.
       * </pre>
       *
       * <code>TRANSCRIPT = 1;</code>
       */
      TRANSCRIPT(1),
      /**
       *
       *
       * <pre>
       * The object is an audio file.
       * </pre>
       *
       * <code>AUDIO = 2;</code>
       */
      AUDIO(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The object type is unspecified and will default to `TRANSCRIPT`.
       * </pre>
       *
       * <code>BUCKET_OBJECT_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int BUCKET_OBJECT_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The object is a transcript.
       * </pre>
       *
       * <code>TRANSCRIPT = 1;</code>
       */
      public static final int TRANSCRIPT_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The object is an audio file.
       * </pre>
       *
       * <code>AUDIO = 2;</code>
       */
      public static final int AUDIO_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static BucketObjectType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static BucketObjectType forNumber(int value) {
        switch (value) {
          case 0:
            return BUCKET_OBJECT_TYPE_UNSPECIFIED;
          case 1:
            return TRANSCRIPT;
          case 2:
            return AUDIO;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<BucketObjectType>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<BucketObjectType>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<BucketObjectType>() {
                public BucketObjectType findValueByNumber(int number) {
                  return BucketObjectType.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final BucketObjectType[] VALUES = values();

      public static BucketObjectType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private BucketObjectType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType)
    }

    private int bitField0_;
    public static final int BUCKET_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object bucketUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket containing source objects.
     * </pre>
     *
     * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bucketUri.
     */
    @java.lang.Override
    public java.lang.String getBucketUri() {
      java.lang.Object ref = bucketUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucketUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Cloud Storage bucket containing source objects.
     * </pre>
     *
     * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for bucketUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBucketUriBytes() {
      java.lang.Object ref = bucketUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucketUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BUCKET_OBJECT_TYPE_FIELD_NUMBER = 2;
    private int bucketObjectType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Specifies the type of the objects in `bucket_uri`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for bucketObjectType.
     */
    @java.lang.Override
    public int getBucketObjectTypeValue() {
      return bucketObjectType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Specifies the type of the objects in `bucket_uri`.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bucketObjectType.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .BucketObjectType
        getBucketObjectType() {
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
              .BucketObjectType
          result =
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                  .BucketObjectType.forNumber(bucketObjectType_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
              .BucketObjectType.UNRECOGNIZED
          : result;
    }

    public static final int METADATA_BUCKET_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object metadataBucketUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the metadataBucketUri field is set.
     */
    @java.lang.Override
    public boolean hasMetadataBucketUri() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The metadataBucketUri.
     */
    @java.lang.Override
    public java.lang.String getMetadataBucketUri() {
      java.lang.Object ref = metadataBucketUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metadataBucketUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage path to the conversation metadata. Note that:
     * [1] Metadata files are expected to be in JSON format.
     * [2] Metadata and source files (transcripts or audio) must be in
     *     separate buckets.
     * [3] A source file and its corresponding metadata file must share the same
     * name to
     *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
     *     `gs://bucket/metadata/conversation1.json`.
     * </pre>
     *
     * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The bytes for metadataBucketUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetadataBucketUriBytes() {
      java.lang.Object ref = metadataBucketUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metadataBucketUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CUSTOM_METADATA_KEYS_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList customMetadataKeys_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the customMetadataKeys.
     */
    public com.google.protobuf.ProtocolStringList getCustomMetadataKeysList() {
      return customMetadataKeys_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of customMetadataKeys.
     */
    public int getCustomMetadataKeysCount() {
      return customMetadataKeys_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The customMetadataKeys at the given index.
     */
    public java.lang.String getCustomMetadataKeys(int index) {
      return customMetadataKeys_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Custom keys to extract as conversation labels from metadata
     * files in `metadata_bucket_uri`. Keys not included in this field will be
     * ignored. Note that there is a limit of 100 labels per conversation.
     * </pre>
     *
     * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the customMetadataKeys at the given index.
     */
    public com.google.protobuf.ByteString getCustomMetadataKeysBytes(int index) {
      return customMetadataKeys_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucketUri_);
      }
      if (bucketObjectType_
          != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
              .BucketObjectType.BUCKET_OBJECT_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, bucketObjectType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metadataBucketUri_);
      }
      for (int i = 0; i < customMetadataKeys_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(
            output, 12, customMetadataKeys_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucketUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucketUri_);
      }
      if (bucketObjectType_
          != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
              .BucketObjectType.BUCKET_OBJECT_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, bucketObjectType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metadataBucketUri_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < customMetadataKeys_.size(); i++) {
          dataSize += computeStringSizeNoTag(customMetadataKeys_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCustomMetadataKeysList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource other =
          (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource) obj;

      if (!getBucketUri().equals(other.getBucketUri())) return false;
      if (bucketObjectType_ != other.bucketObjectType_) return false;
      if (hasMetadataBucketUri() != other.hasMetadataBucketUri()) return false;
      if (hasMetadataBucketUri()) {
        if (!getMetadataBucketUri().equals(other.getMetadataBucketUri())) return false;
      }
      if (!getCustomMetadataKeysList().equals(other.getCustomMetadataKeysList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BUCKET_URI_FIELD_NUMBER;
      hash = (53 * hash) + getBucketUri().hashCode();
      hash = (37 * hash) + BUCKET_OBJECT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + bucketObjectType_;
      if (hasMetadataBucketUri()) {
        hash = (37 * hash) + METADATA_BUCKET_URI_FIELD_NUMBER;
        hash = (53 * hash) + getMetadataBucketUri().hashCode();
      }
      if (getCustomMetadataKeysCount() > 0) {
        hash = (37 * hash) + CUSTOM_METADATA_KEYS_FIELD_NUMBER;
        hash = (53 * hash) + getCustomMetadataKeysList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for Cloud Storage bucket sources.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_GcsSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_GcsSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                    .class,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        bucketUri_ = "";
        bucketObjectType_ = 0;
        metadataBucketUri_ = "";
        customMetadataKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_GcsSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
          build() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource result =
            new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.bucketUri_ = bucketUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.bucketObjectType_ = bucketObjectType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.metadataBucketUri_ = metadataBucketUri_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          customMetadataKeys_.makeImmutable();
          result.customMetadataKeys_ = customMetadataKeys_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                .getDefaultInstance()) return this;
        if (!other.getBucketUri().isEmpty()) {
          bucketUri_ = other.bucketUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.bucketObjectType_ != 0) {
          setBucketObjectTypeValue(other.getBucketObjectTypeValue());
        }
        if (other.hasMetadataBucketUri()) {
          metadataBucketUri_ = other.metadataBucketUri_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.customMetadataKeys_.isEmpty()) {
          if (customMetadataKeys_.isEmpty()) {
            customMetadataKeys_ = other.customMetadataKeys_;
            bitField0_ |= 0x00000008;
          } else {
            ensureCustomMetadataKeysIsMutable();
            customMetadataKeys_.addAll(other.customMetadataKeys_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  bucketUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  bucketObjectType_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  metadataBucketUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 98:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureCustomMetadataKeysIsMutable();
                  customMetadataKeys_.add(s);
                  break;
                } // case 98
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object bucketUri_ = "";
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket containing source objects.
       * </pre>
       *
       * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bucketUri.
       */
      public java.lang.String getBucketUri() {
        java.lang.Object ref = bucketUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          bucketUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket containing source objects.
       * </pre>
       *
       * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for bucketUri.
       */
      public com.google.protobuf.ByteString getBucketUriBytes() {
        java.lang.Object ref = bucketUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          bucketUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket containing source objects.
       * </pre>
       *
       * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bucketUri to set.
       * @return This builder for chaining.
       */
      public Builder setBucketUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bucketUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket containing source objects.
       * </pre>
       *
       * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucketUri() {
        bucketUri_ = getDefaultInstance().getBucketUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The Cloud Storage bucket containing source objects.
       * </pre>
       *
       * <code>string bucket_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for bucketUri to set.
       * @return This builder for chaining.
       */
      public Builder setBucketUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        bucketUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int bucketObjectType_ = 0;
      /**
       *
       *
       * <pre>
       * Optional. Specifies the type of the objects in `bucket_uri`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for bucketObjectType.
       */
      @java.lang.Override
      public int getBucketObjectTypeValue() {
        return bucketObjectType_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the type of the objects in `bucket_uri`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for bucketObjectType to set.
       * @return This builder for chaining.
       */
      public Builder setBucketObjectTypeValue(int value) {
        bucketObjectType_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the type of the objects in `bucket_uri`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bucketObjectType.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
              .BucketObjectType
          getBucketObjectType() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                .BucketObjectType
            result =
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                    .BucketObjectType.forNumber(bucketObjectType_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                .BucketObjectType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the type of the objects in `bucket_uri`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bucketObjectType to set.
       * @return This builder for chaining.
       */
      public Builder setBucketObjectType(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                  .BucketObjectType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        bucketObjectType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Specifies the type of the objects in `bucket_uri`.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.BucketObjectType bucket_object_type = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBucketObjectType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        bucketObjectType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object metadataBucketUri_ = "";
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the metadataBucketUri field is set.
       */
      public boolean hasMetadataBucketUri() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The metadataBucketUri.
       */
      public java.lang.String getMetadataBucketUri() {
        java.lang.Object ref = metadataBucketUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metadataBucketUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The bytes for metadataBucketUri.
       */
      public com.google.protobuf.ByteString getMetadataBucketUriBytes() {
        java.lang.Object ref = metadataBucketUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metadataBucketUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The metadataBucketUri to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataBucketUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadataBucketUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetadataBucketUri() {
        metadataBucketUri_ = getDefaultInstance().getMetadataBucketUri();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage path to the conversation metadata. Note that:
       * [1] Metadata files are expected to be in JSON format.
       * [2] Metadata and source files (transcripts or audio) must be in
       *     separate buckets.
       * [3] A source file and its corresponding metadata file must share the same
       * name to
       *     be properly ingested, E.g. `gs://bucket/audio/conversation1.mp3` and
       *     `gs://bucket/metadata/conversation1.json`.
       * </pre>
       *
       * <code>optional string metadata_bucket_uri = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes for metadataBucketUri to set.
       * @return This builder for chaining.
       */
      public Builder setMetadataBucketUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        metadataBucketUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList customMetadataKeys_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureCustomMetadataKeysIsMutable() {
        if (!customMetadataKeys_.isModifiable()) {
          customMetadataKeys_ = new com.google.protobuf.LazyStringArrayList(customMetadataKeys_);
        }
        bitField0_ |= 0x00000008;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return A list containing the customMetadataKeys.
       */
      public com.google.protobuf.ProtocolStringList getCustomMetadataKeysList() {
        customMetadataKeys_.makeImmutable();
        return customMetadataKeys_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The count of customMetadataKeys.
       */
      public int getCustomMetadataKeysCount() {
        return customMetadataKeys_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the element to return.
       * @return The customMetadataKeys at the given index.
       */
      public java.lang.String getCustomMetadataKeys(int index) {
        return customMetadataKeys_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the customMetadataKeys at the given index.
       */
      public com.google.protobuf.ByteString getCustomMetadataKeysBytes(int index) {
        return customMetadataKeys_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The customMetadataKeys to set.
       * @return This builder for chaining.
       */
      public Builder setCustomMetadataKeys(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomMetadataKeysIsMutable();
        customMetadataKeys_.set(index, value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The customMetadataKeys to add.
       * @return This builder for chaining.
       */
      public Builder addCustomMetadataKeys(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCustomMetadataKeysIsMutable();
        customMetadataKeys_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param values The customMetadataKeys to add.
       * @return This builder for chaining.
       */
      public Builder addAllCustomMetadataKeys(java.lang.Iterable<java.lang.String> values) {
        ensureCustomMetadataKeysIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, customMetadataKeys_);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomMetadataKeys() {
        customMetadataKeys_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Custom keys to extract as conversation labels from metadata
       * files in `metadata_bucket_uri`. Keys not included in this field will be
       * ignored. Note that there is a limit of 100 labels per conversation.
       * </pre>
       *
       * <code>repeated string custom_metadata_keys = 12 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The bytes of the customMetadataKeys to add.
       * @return This builder for chaining.
       */
      public Builder addCustomMetadataKeysBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureCustomMetadataKeysIsMutable();
        customMetadataKeys_.add(value);
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
    private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .GcsSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource();
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GcsSource> PARSER =
        new com.google.protobuf.AbstractParser<GcsSource>() {
          @java.lang.Override
          public GcsSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GcsSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GcsSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TranscriptObjectConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The medium transcript objects represent.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for medium.
     */
    int getMediumValue();
    /**
     *
     *
     * <pre>
     * Required. The medium transcript objects represent.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The medium.
     */
    com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium();
  }
  /**
   *
   *
   * <pre>
   * Configuration for processing transcript objects.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig}
   */
  public static final class TranscriptObjectConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig)
      TranscriptObjectConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TranscriptObjectConfig.newBuilder() to construct.
    private TranscriptObjectConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TranscriptObjectConfig() {
      medium_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TranscriptObjectConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_TranscriptObjectConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_TranscriptObjectConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig.Builder.class);
    }

    public static final int MEDIUM_FIELD_NUMBER = 1;
    private int medium_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The medium transcript objects represent.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for medium.
     */
    @java.lang.Override
    public int getMediumValue() {
      return medium_;
    }
    /**
     *
     *
     * <pre>
     * Required. The medium transcript objects represent.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The medium.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
      com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
          com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (medium_
          != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, medium_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (medium_
          != com.google.cloud.contactcenterinsights.v1.Conversation.Medium.MEDIUM_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, medium_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
          other =
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                      .TranscriptObjectConfig)
                  obj;

      if (medium_ != other.medium_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MEDIUM_FIELD_NUMBER;
      hash = (53 * hash) + medium_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for processing transcript objects.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig)
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_TranscriptObjectConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_TranscriptObjectConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig.class,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        medium_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_TranscriptObjectConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig
          build() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
            result =
                new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.medium_ = medium_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                      .TranscriptObjectConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig.getDefaultInstance()) return this;
        if (other.medium_ != 0) {
          setMediumValue(other.getMediumValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  medium_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int medium_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The medium transcript objects represent.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for medium.
       */
      @java.lang.Override
      public int getMediumValue() {
        return medium_;
      }
      /**
       *
       *
       * <pre>
       * Required. The medium transcript objects represent.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for medium to set.
       * @return This builder for chaining.
       */
      public Builder setMediumValue(int value) {
        medium_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The medium transcript objects represent.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The medium.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Conversation.Medium getMedium() {
        com.google.cloud.contactcenterinsights.v1.Conversation.Medium result =
            com.google.cloud.contactcenterinsights.v1.Conversation.Medium.forNumber(medium_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.Conversation.Medium.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The medium transcript objects represent.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The medium to set.
       * @return This builder for chaining.
       */
      public Builder setMedium(
          com.google.cloud.contactcenterinsights.v1.Conversation.Medium value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        medium_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The medium transcript objects represent.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.Conversation.Medium medium = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMedium() {
        bitField0_ = (bitField0_ & ~0x00000001);
        medium_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig)
    private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TranscriptObjectConfig> PARSER =
        new com.google.protobuf.AbstractParser<TranscriptObjectConfig>() {
          @java.lang.Override
          public TranscriptObjectConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TranscriptObjectConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TranscriptObjectConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConversationConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. An opaque, user-specified string representing a human agent who
     * handled all conversations in the import. Note that this will be
     * overridden if per-conversation metadata is provided through the
     * `metadata_bucket_uri`.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentId.
     */
    java.lang.String getAgentId();
    /**
     *
     *
     * <pre>
     * Optional. An opaque, user-specified string representing a human agent who
     * handled all conversations in the import. Note that this will be
     * overridden if per-conversation metadata is provided through the
     * `metadata_bucket_uri`.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentId.
     */
    com.google.protobuf.ByteString getAgentIdBytes();

    /**
     *
     *
     * <pre>
     * Optional. Indicates which of the channels, 1 or 2, contains the agent.
     * Note that this must be set for conversations to be properly displayed and
     * analyzed.
     * </pre>
     *
     * <code>int32 agent_channel = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentChannel.
     */
    int getAgentChannel();

    /**
     *
     *
     * <pre>
     * Optional. Indicates which of the channels, 1 or 2, contains the agent.
     * Note that this must be set for conversations to be properly displayed and
     * analyzed.
     * </pre>
     *
     * <code>int32 customer_channel = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The customerChannel.
     */
    int getCustomerChannel();
  }
  /**
   *
   *
   * <pre>
   * Configuration that applies to all conversations.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig}
   */
  public static final class ConversationConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig)
      ConversationConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConversationConfig.newBuilder() to construct.
    private ConversationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConversationConfig() {
      agentId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConversationConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_ConversationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_ConversationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .ConversationConfig.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .ConversationConfig.Builder.class);
    }

    public static final int AGENT_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object agentId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. An opaque, user-specified string representing a human agent who
     * handled all conversations in the import. Note that this will be
     * overridden if per-conversation metadata is provided through the
     * `metadata_bucket_uri`.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentId.
     */
    @java.lang.Override
    public java.lang.String getAgentId() {
      java.lang.Object ref = agentId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. An opaque, user-specified string representing a human agent who
     * handled all conversations in the import. Note that this will be
     * overridden if per-conversation metadata is provided through the
     * `metadata_bucket_uri`.
     * </pre>
     *
     * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAgentIdBytes() {
      java.lang.Object ref = agentId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AGENT_CHANNEL_FIELD_NUMBER = 2;
    private int agentChannel_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates which of the channels, 1 or 2, contains the agent.
     * Note that this must be set for conversations to be properly displayed and
     * analyzed.
     * </pre>
     *
     * <code>int32 agent_channel = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentChannel.
     */
    @java.lang.Override
    public int getAgentChannel() {
      return agentChannel_;
    }

    public static final int CUSTOMER_CHANNEL_FIELD_NUMBER = 3;
    private int customerChannel_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Indicates which of the channels, 1 or 2, contains the agent.
     * Note that this must be set for conversations to be properly displayed and
     * analyzed.
     * </pre>
     *
     * <code>int32 customer_channel = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The customerChannel.
     */
    @java.lang.Override
    public int getCustomerChannel() {
      return customerChannel_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, agentId_);
      }
      if (agentChannel_ != 0) {
        output.writeInt32(2, agentChannel_);
      }
      if (customerChannel_ != 0) {
        output.writeInt32(3, customerChannel_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, agentId_);
      }
      if (agentChannel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, agentChannel_);
      }
      if (customerChannel_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, customerChannel_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .ConversationConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
          other =
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                      .ConversationConfig)
                  obj;

      if (!getAgentId().equals(other.getAgentId())) return false;
      if (getAgentChannel() != other.getAgentChannel()) return false;
      if (getCustomerChannel() != other.getCustomerChannel()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + AGENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAgentId().hashCode();
      hash = (37 * hash) + AGENT_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getAgentChannel();
      hash = (37 * hash) + CUSTOMER_CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerChannel();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig)
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_ConversationConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_ConversationConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig.class,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        agentId_ = "";
        agentChannel_ = 0;
        customerChannel_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_ConversationConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
          build() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            result =
                new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.agentId_ = agentId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.agentChannel_ = agentChannel_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.customerChannel_ = customerChannel_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                      .ConversationConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfig.getDefaultInstance()) return this;
        if (!other.getAgentId().isEmpty()) {
          agentId_ = other.agentId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getAgentChannel() != 0) {
          setAgentChannel(other.getAgentChannel());
        }
        if (other.getCustomerChannel() != 0) {
          setCustomerChannel(other.getCustomerChannel());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  agentId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  agentChannel_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  customerChannel_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object agentId_ = "";
      /**
       *
       *
       * <pre>
       * Optional. An opaque, user-specified string representing a human agent who
       * handled all conversations in the import. Note that this will be
       * overridden if per-conversation metadata is provided through the
       * `metadata_bucket_uri`.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The agentId.
       */
      public java.lang.String getAgentId() {
        java.lang.Object ref = agentId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agentId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. An opaque, user-specified string representing a human agent who
       * handled all conversations in the import. Note that this will be
       * overridden if per-conversation metadata is provided through the
       * `metadata_bucket_uri`.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for agentId.
       */
      public com.google.protobuf.ByteString getAgentIdBytes() {
        java.lang.Object ref = agentId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          agentId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. An opaque, user-specified string representing a human agent who
       * handled all conversations in the import. Note that this will be
       * overridden if per-conversation metadata is provided through the
       * `metadata_bucket_uri`.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The agentId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        agentId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. An opaque, user-specified string representing a human agent who
       * handled all conversations in the import. Note that this will be
       * overridden if per-conversation metadata is provided through the
       * `metadata_bucket_uri`.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentId() {
        agentId_ = getDefaultInstance().getAgentId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. An opaque, user-specified string representing a human agent who
       * handled all conversations in the import. Note that this will be
       * overridden if per-conversation metadata is provided through the
       * `metadata_bucket_uri`.
       * </pre>
       *
       * <code>string agent_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for agentId to set.
       * @return This builder for chaining.
       */
      public Builder setAgentIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        agentId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int agentChannel_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 agent_channel = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The agentChannel.
       */
      @java.lang.Override
      public int getAgentChannel() {
        return agentChannel_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 agent_channel = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The agentChannel to set.
       * @return This builder for chaining.
       */
      public Builder setAgentChannel(int value) {

        agentChannel_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 agent_channel = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAgentChannel() {
        bitField0_ = (bitField0_ & ~0x00000002);
        agentChannel_ = 0;
        onChanged();
        return this;
      }

      private int customerChannel_;
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 customer_channel = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The customerChannel.
       */
      @java.lang.Override
      public int getCustomerChannel() {
        return customerChannel_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 customer_channel = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The customerChannel to set.
       * @return This builder for chaining.
       */
      public Builder setCustomerChannel(int value) {

        customerChannel_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Indicates which of the channels, 1 or 2, contains the agent.
       * Note that this must be set for conversations to be properly displayed and
       * analyzed.
       * </pre>
       *
       * <code>int32 customer_channel = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCustomerChannel() {
        bitField0_ = (bitField0_ & ~0x00000004);
        customerChannel_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig)
    private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .ConversationConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConversationConfig> PARSER =
        new com.google.protobuf.AbstractParser<ConversationConfig>() {
          @java.lang.Override
          public ConversationConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConversationConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConversationConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  private int objectConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object objectConfig_;

  public enum ObjectConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSCRIPT_OBJECT_CONFIG(3),
    OBJECTCONFIG_NOT_SET(0);
    private final int value;

    private ObjectConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ObjectConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ObjectConfigCase forNumber(int value) {
      switch (value) {
        case 3:
          return TRANSCRIPT_OBJECT_CONFIG;
        case 0:
          return OBJECTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ObjectConfigCase getObjectConfigCase() {
    return ObjectConfigCase.forNumber(objectConfigCase_);
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source. Note that any previously ingested objects
   * from the source will be skipped to avoid duplication.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
   * </code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source. Note that any previously ingested objects
   * from the source will be skipped to avoid duplication.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
   * </code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
      getGcsSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
          source_;
    }
    return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A cloud storage bucket source. Note that any previously ingested objects
   * from the source will be skipped to avoid duplication.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSourceOrBuilder
      getGcsSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
          source_;
    }
    return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        .getDefaultInstance();
  }

  public static final int TRANSCRIPT_OBJECT_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Configuration for when `source` contains conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
   * </code>
   *
   * @return Whether the transcriptObjectConfig field is set.
   */
  @java.lang.Override
  public boolean hasTranscriptObjectConfig() {
    return objectConfigCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Configuration for when `source` contains conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
   * </code>
   *
   * @return The transcriptObjectConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
      getTranscriptObjectConfig() {
    if (objectConfigCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig)
          objectConfig_;
    }
    return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
        .TranscriptObjectConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for when `source` contains conversation transcripts.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
          .TranscriptObjectConfigOrBuilder
      getTranscriptObjectConfigOrBuilder() {
    if (objectConfigCase_ == 3) {
      return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .TranscriptObjectConfig)
          objectConfig_;
    }
    return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
        .TranscriptObjectConfig.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new conversations.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource for new conversations.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
      conversationConfig_;
  /**
   *
   *
   * <pre>
   * Configuration that applies to all conversations.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
   * </code>
   *
   * @return Whether the conversationConfig field is set.
   */
  @java.lang.Override
  public boolean hasConversationConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Configuration that applies to all conversations.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
   * </code>
   *
   * @return The conversationConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
      getConversationConfig() {
    return conversationConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            .getDefaultInstance()
        : conversationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration that applies to all conversations.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
          .ConversationConfigOrBuilder
      getConversationConfigOrBuilder() {
    return conversationConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            .getDefaultInstance()
        : conversationConfig_;
  }

  public static final int REDACTION_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.contactcenterinsights.v1.RedactionConfig redactionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. DLP settings for transcript redaction. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the redactionConfig field is set.
   */
  @java.lang.Override
  public boolean hasRedactionConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. DLP settings for transcript redaction. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The redactionConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RedactionConfig getRedactionConfig() {
    return redactionConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
        : redactionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. DLP settings for transcript redaction. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder
      getRedactionConfigOrBuilder() {
    return redactionConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
        : redactionConfig_;
  }

  public static final int SPEECH_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.contactcenterinsights.v1.SpeechConfig speechConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text configuration. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speechConfig field is set.
   */
  @java.lang.Override
  public boolean hasSpeechConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text configuration. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speechConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SpeechConfig getSpeechConfig() {
    return speechConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text configuration. Optional, will default to
   * the config specified in Settings.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder
      getSpeechConfigOrBuilder() {
    return speechConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }

  public static final int SAMPLE_SIZE_FIELD_NUMBER = 7;
  private int sampleSize_ = 0;
  /**
   *
   *
   * <pre>
   * Optional. If set, this fields indicates the number of objects to ingest
   * from the Cloud Storage bucket. If empty, the entire bucket will be
   * ingested. Unless they are first deleted, conversations produced through
   * sampling won't be ingested by subsequent ingest requests.
   * </pre>
   *
   * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the sampleSize field is set.
   */
  @java.lang.Override
  public boolean hasSampleSize() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. If set, this fields indicates the number of objects to ingest
   * from the Cloud Storage bucket. If empty, the entire bucket will be
   * ingested. Unless they are first deleted, conversations produced through
   * sampling won't be ingested by subsequent ingest requests.
   * </pre>
   *
   * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The sampleSize.
   */
  @java.lang.Override
  public int getSampleSize() {
    return sampleSize_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource) source_);
    }
    if (objectConfigCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig)
              objectConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getConversationConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getRedactionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getSpeechConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt32(7, sampleSize_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
                  source_);
    }
    if (objectConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                      .TranscriptObjectConfig)
                  objectConfig_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getConversationConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRedactionConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSpeechConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, sampleSize_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest other =
        (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasConversationConfig() != other.hasConversationConfig()) return false;
    if (hasConversationConfig()) {
      if (!getConversationConfig().equals(other.getConversationConfig())) return false;
    }
    if (hasRedactionConfig() != other.hasRedactionConfig()) return false;
    if (hasRedactionConfig()) {
      if (!getRedactionConfig().equals(other.getRedactionConfig())) return false;
    }
    if (hasSpeechConfig() != other.hasSpeechConfig()) return false;
    if (hasSpeechConfig()) {
      if (!getSpeechConfig().equals(other.getSpeechConfig())) return false;
    }
    if (hasSampleSize() != other.hasSampleSize()) return false;
    if (hasSampleSize()) {
      if (getSampleSize() != other.getSampleSize()) return false;
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getObjectConfigCase().equals(other.getObjectConfigCase())) return false;
    switch (objectConfigCase_) {
      case 3:
        if (!getTranscriptObjectConfig().equals(other.getTranscriptObjectConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasConversationConfig()) {
      hash = (37 * hash) + CONVERSATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConversationConfig().hashCode();
    }
    if (hasRedactionConfig()) {
      hash = (37 * hash) + REDACTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRedactionConfig().hashCode();
    }
    if (hasSpeechConfig()) {
      hash = (37 * hash) + SPEECH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechConfig().hashCode();
    }
    if (hasSampleSize()) {
      hash = (37 * hash) + SAMPLE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getSampleSize();
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 0:
      default:
    }
    switch (objectConfigCase_) {
      case 3:
        hash = (37 * hash) + TRANSCRIPT_OBJECT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTranscriptObjectConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request to ingest conversations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.IngestConversationsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.IngestConversationsRequest)
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.class,
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConversationConfigFieldBuilder();
        getRedactionConfigFieldBuilder();
        getSpeechConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsSourceBuilder_ != null) {
        gcsSourceBuilder_.clear();
      }
      if (transcriptObjectConfigBuilder_ != null) {
        transcriptObjectConfigBuilder_.clear();
      }
      parent_ = "";
      conversationConfig_ = null;
      if (conversationConfigBuilder_ != null) {
        conversationConfigBuilder_.dispose();
        conversationConfigBuilder_ = null;
      }
      redactionConfig_ = null;
      if (redactionConfigBuilder_ != null) {
        redactionConfigBuilder_.dispose();
        redactionConfigBuilder_ = null;
      }
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      sampleSize_ = 0;
      sourceCase_ = 0;
      source_ = null;
      objectConfigCase_ = 0;
      objectConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_IngestConversationsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest build() {
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest buildPartial() {
      com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest result =
          new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.conversationConfig_ =
            conversationConfigBuilder_ == null
                ? conversationConfig_
                : conversationConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.redactionConfig_ =
            redactionConfigBuilder_ == null ? redactionConfig_ : redactionConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.speechConfig_ =
            speechConfigBuilder_ == null ? speechConfig_ : speechConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sampleSize_ = sampleSize_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && gcsSourceBuilder_ != null) {
        result.source_ = gcsSourceBuilder_.build();
      }
      result.objectConfigCase_ = objectConfigCase_;
      result.objectConfig_ = this.objectConfig_;
      if (objectConfigCase_ == 3 && transcriptObjectConfigBuilder_ != null) {
        result.objectConfig_ = transcriptObjectConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasConversationConfig()) {
        mergeConversationConfig(other.getConversationConfig());
      }
      if (other.hasRedactionConfig()) {
        mergeRedactionConfig(other.getRedactionConfig());
      }
      if (other.hasSpeechConfig()) {
        mergeSpeechConfig(other.getSpeechConfig());
      }
      if (other.hasSampleSize()) {
        setSampleSize(other.getSampleSize());
      }
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getObjectConfigCase()) {
        case TRANSCRIPT_OBJECT_CONFIG:
          {
            mergeTranscriptObjectConfig(other.getTranscriptObjectConfig());
            break;
          }
        case OBJECTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTranscriptObjectConfigFieldBuilder().getBuilder(), extensionRegistry);
                objectConfigCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getConversationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRedactionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSpeechConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                sampleSize_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int objectConfigCase_ = 0;
    private java.lang.Object objectConfig_;

    public ObjectConfigCase getObjectConfigCase() {
      return ObjectConfigCase.forNumber(objectConfigCase_);
    }

    public Builder clearObjectConfig() {
      objectConfigCase_ = 0;
      objectConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
        getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
              source_;
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder setGcsSource(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder setGcsSource(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.Builder
            builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder mergeGcsSource(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_
                != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                    .getDefaultInstance()) {
          source_ =
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                  .newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                              .GcsSource)
                          source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.Builder
        getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSourceOrBuilder
        getGcsSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
              source_;
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A cloud storage bucket source. Note that any previously ingested objects
     * from the source will be skipped to avoid duplication.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource gcs_source = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ =
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                  .getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource
                    .Builder,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .GcsSourceOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.GcsSource)
                    source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfigOrBuilder>
        transcriptObjectConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     *
     * @return Whether the transcriptObjectConfig field is set.
     */
    @java.lang.Override
    public boolean hasTranscriptObjectConfig() {
      return objectConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     *
     * @return The transcriptObjectConfig.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig
        getTranscriptObjectConfig() {
      if (transcriptObjectConfigBuilder_ == null) {
        if (objectConfigCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig)
              objectConfig_;
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig.getDefaultInstance();
      } else {
        if (objectConfigCase_ == 3) {
          return transcriptObjectConfigBuilder_.getMessage();
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    public Builder setTranscriptObjectConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
            value) {
      if (transcriptObjectConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        objectConfig_ = value;
        onChanged();
      } else {
        transcriptObjectConfigBuilder_.setMessage(value);
      }
      objectConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    public Builder setTranscriptObjectConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
                .Builder
            builderForValue) {
      if (transcriptObjectConfigBuilder_ == null) {
        objectConfig_ = builderForValue.build();
        onChanged();
      } else {
        transcriptObjectConfigBuilder_.setMessage(builderForValue.build());
      }
      objectConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    public Builder mergeTranscriptObjectConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig
            value) {
      if (transcriptObjectConfigBuilder_ == null) {
        if (objectConfigCase_ == 3
            && objectConfig_
                != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig.getDefaultInstance()) {
          objectConfig_ =
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig.newBuilder(
                      (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                              .TranscriptObjectConfig)
                          objectConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          objectConfig_ = value;
        }
        onChanged();
      } else {
        if (objectConfigCase_ == 3) {
          transcriptObjectConfigBuilder_.mergeFrom(value);
        } else {
          transcriptObjectConfigBuilder_.setMessage(value);
        }
      }
      objectConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    public Builder clearTranscriptObjectConfig() {
      if (transcriptObjectConfigBuilder_ == null) {
        if (objectConfigCase_ == 3) {
          objectConfigCase_ = 0;
          objectConfig_ = null;
          onChanged();
        }
      } else {
        if (objectConfigCase_ == 3) {
          objectConfigCase_ = 0;
          objectConfig_ = null;
        }
        transcriptObjectConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig.Builder
        getTranscriptObjectConfigBuilder() {
      return getTranscriptObjectConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfigOrBuilder
        getTranscriptObjectConfigOrBuilder() {
      if ((objectConfigCase_ == 3) && (transcriptObjectConfigBuilder_ != null)) {
        return transcriptObjectConfigBuilder_.getMessageOrBuilder();
      } else {
        if (objectConfigCase_ == 3) {
          return (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig)
              objectConfig_;
        }
        return com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .TranscriptObjectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for when `source` contains conversation transcripts.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.TranscriptObjectConfig transcript_object_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .TranscriptObjectConfigOrBuilder>
        getTranscriptObjectConfigFieldBuilder() {
      if (transcriptObjectConfigBuilder_ == null) {
        if (!(objectConfigCase_ == 3)) {
          objectConfig_ =
              com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                  .TranscriptObjectConfig.getDefaultInstance();
        }
        transcriptObjectConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .TranscriptObjectConfigOrBuilder>(
                (com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                        .TranscriptObjectConfig)
                    objectConfig_,
                getParentForChildren(),
                isClean());
        objectConfig_ = null;
      }
      objectConfigCase_ = 3;
      onChanged();
      return transcriptObjectConfigBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new conversations.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new conversations.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new conversations.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new conversations.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource for new conversations.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
        conversationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
                .Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfigOrBuilder>
        conversationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     *
     * @return Whether the conversationConfig field is set.
     */
    public boolean hasConversationConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     *
     * @return The conversationConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
        getConversationConfig() {
      if (conversationConfigBuilder_ == null) {
        return conversationConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfig.getDefaultInstance()
            : conversationConfig_;
      } else {
        return conversationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public Builder setConversationConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            value) {
      if (conversationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationConfig_ = value;
      } else {
        conversationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public Builder setConversationConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
                .Builder
            builderForValue) {
      if (conversationConfigBuilder_ == null) {
        conversationConfig_ = builderForValue.build();
      } else {
        conversationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public Builder mergeConversationConfig(
        com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            value) {
      if (conversationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && conversationConfig_ != null
            && conversationConfig_
                != com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig.getDefaultInstance()) {
          getConversationConfigBuilder().mergeFrom(value);
        } else {
          conversationConfig_ = value;
        }
      } else {
        conversationConfigBuilder_.mergeFrom(value);
      }
      if (conversationConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public Builder clearConversationConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      conversationConfig_ = null;
      if (conversationConfigBuilder_ != null) {
        conversationConfigBuilder_.dispose();
        conversationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
            .Builder
        getConversationConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getConversationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
            .ConversationConfigOrBuilder
        getConversationConfigOrBuilder() {
      if (conversationConfigBuilder_ != null) {
        return conversationConfigBuilder_.getMessageOrBuilder();
      } else {
        return conversationConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfig.getDefaultInstance()
            : conversationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration that applies to all conversations.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig conversation_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest.ConversationConfig
                .Builder,
            com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                .ConversationConfigOrBuilder>
        getConversationConfigFieldBuilder() {
      if (conversationConfigBuilder_ == null) {
        conversationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
                    .ConversationConfigOrBuilder>(
                getConversationConfig(), getParentForChildren(), isClean());
        conversationConfig_ = null;
      }
      return conversationConfigBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.RedactionConfig redactionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RedactionConfig,
            com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>
        redactionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the redactionConfig field is set.
     */
    public boolean hasRedactionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The redactionConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfig getRedactionConfig() {
      if (redactionConfigBuilder_ == null) {
        return redactionConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
            : redactionConfig_;
      } else {
        return redactionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig value) {
      if (redactionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        redactionConfig_ = value;
      } else {
        redactionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder builderForValue) {
      if (redactionConfigBuilder_ == null) {
        redactionConfig_ = builderForValue.build();
      } else {
        redactionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig value) {
      if (redactionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && redactionConfig_ != null
            && redactionConfig_
                != com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()) {
          getRedactionConfigBuilder().mergeFrom(value);
        } else {
          redactionConfig_ = value;
        }
      } else {
        redactionConfigBuilder_.mergeFrom(value);
      }
      if (redactionConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRedactionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      redactionConfig_ = null;
      if (redactionConfigBuilder_ != null) {
        redactionConfigBuilder_.dispose();
        redactionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder
        getRedactionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRedactionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder
        getRedactionConfigOrBuilder() {
      if (redactionConfigBuilder_ != null) {
        return redactionConfigBuilder_.getMessageOrBuilder();
      } else {
        return redactionConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
            : redactionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. DLP settings for transcript redaction. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RedactionConfig,
            com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>
        getRedactionConfigFieldBuilder() {
      if (redactionConfigBuilder_ == null) {
        redactionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.RedactionConfig,
                com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>(
                getRedactionConfig(), getParentForChildren(), isClean());
        redactionConfig_ = null;
      }
      return redactionConfigBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.SpeechConfig speechConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SpeechConfig,
            com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>
        speechConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the speechConfig field is set.
     */
    public boolean hasSpeechConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The speechConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfig getSpeechConfig() {
      if (speechConfigBuilder_ == null) {
        return speechConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      } else {
        return speechConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(com.google.cloud.contactcenterinsights.v1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechConfig_ = value;
      } else {
        speechConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(
        com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder builderForValue) {
      if (speechConfigBuilder_ == null) {
        speechConfig_ = builderForValue.build();
      } else {
        speechConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpeechConfig(com.google.cloud.contactcenterinsights.v1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && speechConfig_ != null
            && speechConfig_
                != com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()) {
          getSpeechConfigBuilder().mergeFrom(value);
        } else {
          speechConfig_ = value;
        }
      } else {
        speechConfigBuilder_.mergeFrom(value);
      }
      if (speechConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeechConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder getSpeechConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSpeechConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder
        getSpeechConfigOrBuilder() {
      if (speechConfigBuilder_ != null) {
        return speechConfigBuilder_.getMessageOrBuilder();
      } else {
        return speechConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text configuration. Optional, will default to
     * the config specified in Settings.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SpeechConfig,
            com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>
        getSpeechConfigFieldBuilder() {
      if (speechConfigBuilder_ == null) {
        speechConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SpeechConfig,
                com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>(
                getSpeechConfig(), getParentForChildren(), isClean());
        speechConfig_ = null;
      }
      return speechConfigBuilder_;
    }

    private int sampleSize_;
    /**
     *
     *
     * <pre>
     * Optional. If set, this fields indicates the number of objects to ingest
     * from the Cloud Storage bucket. If empty, the entire bucket will be
     * ingested. Unless they are first deleted, conversations produced through
     * sampling won't be ingested by subsequent ingest requests.
     * </pre>
     *
     * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the sampleSize field is set.
     */
    @java.lang.Override
    public boolean hasSampleSize() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, this fields indicates the number of objects to ingest
     * from the Cloud Storage bucket. If empty, the entire bucket will be
     * ingested. Unless they are first deleted, conversations produced through
     * sampling won't be ingested by subsequent ingest requests.
     * </pre>
     *
     * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The sampleSize.
     */
    @java.lang.Override
    public int getSampleSize() {
      return sampleSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, this fields indicates the number of objects to ingest
     * from the Cloud Storage bucket. If empty, the entire bucket will be
     * ingested. Unless they are first deleted, conversations produced through
     * sampling won't be ingested by subsequent ingest requests.
     * </pre>
     *
     * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sampleSize to set.
     * @return This builder for chaining.
     */
    public Builder setSampleSize(int value) {

      sampleSize_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set, this fields indicates the number of objects to ingest
     * from the Cloud Storage bucket. If empty, the entire bucket will be
     * ingested. Unless they are first deleted, conversations produced through
     * sampling won't be ingested by subsequent ingest requests.
     * </pre>
     *
     * <code>optional int32 sample_size = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSampleSize() {
      bitField0_ = (bitField0_ & ~0x00000040);
      sampleSize_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.IngestConversationsRequest)
  private static final com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest();
  }

  public static com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<IngestConversationsRequest> PARSER =
      new com.google.protobuf.AbstractParser<IngestConversationsRequest>() {
        @java.lang.Override
        public IngestConversationsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<IngestConversationsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<IngestConversationsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.IngestConversationsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
