/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * A message representing a rule in the phrase matcher.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup}
 */
public final class PhraseMatchRuleGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup)
    PhraseMatchRuleGroupOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PhraseMatchRuleGroup.newBuilder() to construct.
  private PhraseMatchRuleGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PhraseMatchRuleGroup() {
    type_ = 0;
    phraseMatchRules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PhraseMatchRuleGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatchRuleGroup_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatchRuleGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.class,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how to combine each phrase match rule for whether there is a
   * match.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType}
   */
  public enum PhraseMatchRuleGroupType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED = 0;</code>
     */
    PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Must meet all phrase match rules or there is no match.
     * </pre>
     *
     * <code>ALL_OF = 1;</code>
     */
    ALL_OF(1),
    /**
     *
     *
     * <pre>
     * If any of the phrase match rules are met, there is a match.
     * </pre>
     *
     * <code>ANY_OF = 2;</code>
     */
    ANY_OF(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Must meet all phrase match rules or there is no match.
     * </pre>
     *
     * <code>ALL_OF = 1;</code>
     */
    public static final int ALL_OF_VALUE = 1;
    /**
     *
     *
     * <pre>
     * If any of the phrase match rules are met, there is a match.
     * </pre>
     *
     * <code>ANY_OF = 2;</code>
     */
    public static final int ANY_OF_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PhraseMatchRuleGroupType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PhraseMatchRuleGroupType forNumber(int value) {
      switch (value) {
        case 0:
          return PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED;
        case 1:
          return ALL_OF;
        case 2:
          return ANY_OF;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PhraseMatchRuleGroupType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PhraseMatchRuleGroupType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PhraseMatchRuleGroupType>() {
              public PhraseMatchRuleGroupType findValueByNumber(int number) {
                return PhraseMatchRuleGroupType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PhraseMatchRuleGroupType[] VALUES = values();

    public static PhraseMatchRuleGroupType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PhraseMatchRuleGroupType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The type of this phrase match rule group.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of this phrase match rule group.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
      getType() {
    com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType result =
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
            .forNumber(type_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
            .UNRECOGNIZED
        : result;
  }

  public static final int PHRASE_MATCH_RULES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>
      phraseMatchRules_;
  /**
   *
   *
   * <pre>
   * A list of phrase match rules that are included in this group.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>
      getPhraseMatchRulesList() {
    return phraseMatchRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of phrase match rules that are included in this group.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder>
      getPhraseMatchRulesOrBuilderList() {
    return phraseMatchRules_;
  }
  /**
   *
   *
   * <pre>
   * A list of phrase match rules that are included in this group.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
   * </code>
   */
  @java.lang.Override
  public int getPhraseMatchRulesCount() {
    return phraseMatchRules_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of phrase match rules that are included in this group.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRule getPhraseMatchRules(int index) {
    return phraseMatchRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of phrase match rules that are included in this group.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder
      getPhraseMatchRulesOrBuilder(int index) {
    return phraseMatchRules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
            .PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    for (int i = 0; i < phraseMatchRules_.size(); i++) {
      output.writeMessage(2, phraseMatchRules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
            .PHRASE_MATCH_RULE_GROUP_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    for (int i = 0; i < phraseMatchRules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, phraseMatchRules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup other =
        (com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup) obj;

    if (type_ != other.type_) return false;
    if (!getPhraseMatchRulesList().equals(other.getPhraseMatchRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (getPhraseMatchRulesCount() > 0) {
      hash = (37 * hash) + PHRASE_MATCH_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getPhraseMatchRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A message representing a rule in the phrase matcher.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup)
      com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatchRuleGroup_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatchRuleGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.class,
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      if (phraseMatchRulesBuilder_ == null) {
        phraseMatchRules_ = java.util.Collections.emptyList();
      } else {
        phraseMatchRules_ = null;
        phraseMatchRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_PhraseMatchRuleGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup build() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup buildPartial() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup result =
          new com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup result) {
      if (phraseMatchRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          phraseMatchRules_ = java.util.Collections.unmodifiableList(phraseMatchRules_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.phraseMatchRules_ = phraseMatchRules_;
      } else {
        result.phraseMatchRules_ = phraseMatchRulesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (phraseMatchRulesBuilder_ == null) {
        if (!other.phraseMatchRules_.isEmpty()) {
          if (phraseMatchRules_.isEmpty()) {
            phraseMatchRules_ = other.phraseMatchRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePhraseMatchRulesIsMutable();
            phraseMatchRules_.addAll(other.phraseMatchRules_);
          }
          onChanged();
        }
      } else {
        if (!other.phraseMatchRules_.isEmpty()) {
          if (phraseMatchRulesBuilder_.isEmpty()) {
            phraseMatchRulesBuilder_.dispose();
            phraseMatchRulesBuilder_ = null;
            phraseMatchRules_ = other.phraseMatchRules_;
            bitField0_ = (bitField0_ & ~0x00000002);
            phraseMatchRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPhraseMatchRulesFieldBuilder()
                    : null;
          } else {
            phraseMatchRulesBuilder_.addAllMessages(other.phraseMatchRules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRule m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.parser(),
                        extensionRegistry);
                if (phraseMatchRulesBuilder_ == null) {
                  ensurePhraseMatchRulesIsMutable();
                  phraseMatchRules_.add(m);
                } else {
                  phraseMatchRulesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase match rule group.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase match rule group.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase match rule group.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
        getType() {
      com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
          result =
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
                  .PhraseMatchRuleGroupType.forNumber(type_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase match rule group.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType
            value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of this phrase match rule group.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup.PhraseMatchRuleGroupType type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>
        phraseMatchRules_ = java.util.Collections.emptyList();

    private void ensurePhraseMatchRulesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        phraseMatchRules_ =
            new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>(
                phraseMatchRules_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRule,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder>
        phraseMatchRulesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>
        getPhraseMatchRulesList() {
      if (phraseMatchRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(phraseMatchRules_);
      } else {
        return phraseMatchRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public int getPhraseMatchRulesCount() {
      if (phraseMatchRulesBuilder_ == null) {
        return phraseMatchRules_.size();
      } else {
        return phraseMatchRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRule getPhraseMatchRules(
        int index) {
      if (phraseMatchRulesBuilder_ == null) {
        return phraseMatchRules_.get(index);
      } else {
        return phraseMatchRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder setPhraseMatchRules(
        int index, com.google.cloud.contactcenterinsights.v1.PhraseMatchRule value) {
      if (phraseMatchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.set(index, value);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder setPhraseMatchRules(
        int index,
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder builderForValue) {
      if (phraseMatchRulesBuilder_ == null) {
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        phraseMatchRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder addPhraseMatchRules(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRule value) {
      if (phraseMatchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.add(value);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder addPhraseMatchRules(
        int index, com.google.cloud.contactcenterinsights.v1.PhraseMatchRule value) {
      if (phraseMatchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.add(index, value);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder addPhraseMatchRules(
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder builderForValue) {
      if (phraseMatchRulesBuilder_ == null) {
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.add(builderForValue.build());
        onChanged();
      } else {
        phraseMatchRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder addPhraseMatchRules(
        int index,
        com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder builderForValue) {
      if (phraseMatchRulesBuilder_ == null) {
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        phraseMatchRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder addAllPhraseMatchRules(
        java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRule>
            values) {
      if (phraseMatchRulesBuilder_ == null) {
        ensurePhraseMatchRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, phraseMatchRules_);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder clearPhraseMatchRules() {
      if (phraseMatchRulesBuilder_ == null) {
        phraseMatchRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public Builder removePhraseMatchRules(int index) {
      if (phraseMatchRulesBuilder_ == null) {
        ensurePhraseMatchRulesIsMutable();
        phraseMatchRules_.remove(index);
        onChanged();
      } else {
        phraseMatchRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder
        getPhraseMatchRulesBuilder(int index) {
      return getPhraseMatchRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder
        getPhraseMatchRulesOrBuilder(int index) {
      if (phraseMatchRulesBuilder_ == null) {
        return phraseMatchRules_.get(index);
      } else {
        return phraseMatchRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder>
        getPhraseMatchRulesOrBuilderList() {
      if (phraseMatchRulesBuilder_ != null) {
        return phraseMatchRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(phraseMatchRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder
        addPhraseMatchRulesBuilder() {
      return getPhraseMatchRulesFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder
        addPhraseMatchRulesBuilder(int index) {
      return getPhraseMatchRulesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of phrase match rules that are included in this group.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.PhraseMatchRule phrase_match_rules = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder>
        getPhraseMatchRulesBuilderList() {
      return getPhraseMatchRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRule,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder,
            com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder>
        getPhraseMatchRulesFieldBuilder() {
      if (phraseMatchRulesBuilder_ == null) {
        phraseMatchRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRule,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRule.Builder,
                com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleOrBuilder>(
                phraseMatchRules_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        phraseMatchRules_ = null;
      }
      return phraseMatchRulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup)
  private static final com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup();
  }

  public static com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PhraseMatchRuleGroup> PARSER =
      new com.google.protobuf.AbstractParser<PhraseMatchRuleGroup>() {
        @java.lang.Override
        public PhraseMatchRuleGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PhraseMatchRuleGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PhraseMatchRuleGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.PhraseMatchRuleGroup
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
