/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * An answer to a QaQuestion.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer}
 */
public final class QaAnswer extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaAnswer)
    QaAnswerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QaAnswer.newBuilder() to construct.
  private QaAnswer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QaAnswer() {
    qaQuestion_ = "";
    conversation_ = "";
    questionBody_ = "";
    tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
    answerSources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QaAnswer();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QaAnswer.class,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder.class);
  }

  public interface AnswerValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return Whether the strValue field is set.
     */
    boolean hasStrValue();
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The strValue.
     */
    java.lang.String getStrValue();
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The bytes for strValue.
     */
    com.google.protobuf.ByteString getStrValueBytes();

    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return Whether the numValue field is set.
     */
    boolean hasNumValue();
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return The numValue.
     */
    double getNumValue();

    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return Whether the boolValue field is set.
     */
    boolean hasBoolValue();
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return The boolValue.
     */
    boolean getBoolValue();

    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". Should only ever be `true`.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return Whether the naValue field is set.
     */
    boolean hasNaValue();
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". Should only ever be `true`.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return The naValue.
     */
    boolean getNaValue();

    /**
     *
     *
     * <pre>
     * A short string used as an identifier. Matches the value used in
     * QaQuestion.AnswerChoice.key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    java.lang.String getKey();
    /**
     *
     *
     * <pre>
     * A short string used as an identifier. Matches the value used in
     * QaQuestion.AnswerChoice.key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString getKeyBytes();

    /**
     *
     *
     * <pre>
     * Output only. Numerical score of the answer.
     * </pre>
     *
     * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the score field is set.
     */
    boolean hasScore();
    /**
     *
     *
     * <pre>
     * Output only. Numerical score of the answer.
     * </pre>
     *
     * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The score.
     */
    double getScore();

    /**
     *
     *
     * <pre>
     * Output only. The maximum potential score of the question.
     * </pre>
     *
     * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the potentialScore field is set.
     */
    boolean hasPotentialScore();
    /**
     *
     *
     * <pre>
     * Output only. The maximum potential score of the question.
     * </pre>
     *
     * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The potentialScore.
     */
    double getPotentialScore();

    /**
     *
     *
     * <pre>
     * Output only. Normalized score of the questions. Calculated as score /
     * potential_score.
     * </pre>
     *
     * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the normalizedScore field is set.
     */
    boolean hasNormalizedScore();
    /**
     *
     *
     * <pre>
     * Output only. Normalized score of the questions. Calculated as score /
     * potential_score.
     * </pre>
     *
     * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The normalizedScore.
     */
    double getNormalizedScore();

    com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.ValueCase getValueCase();
  }
  /**
   *
   *
   * <pre>
   * Message for holding the value of a
   * [QaAnswer][google.cloud.contactcenterinsights.v1.QaAnswer].
   * [QaQuestion.AnswerChoice][google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice]
   * defines the possible answer values for a question.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue}
   */
  public static final class AnswerValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)
      AnswerValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerValue.newBuilder() to construct.
    private AnswerValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerValue() {
      key_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.class,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder.class);
    }

    private int bitField0_;
    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      STR_VALUE(2),
      NUM_VALUE(3),
      BOOL_VALUE(4),
      NA_VALUE(5),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 2:
            return STR_VALUE;
          case 3:
            return NUM_VALUE;
          case 4:
            return BOOL_VALUE;
          case 5:
            return NA_VALUE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int STR_VALUE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return Whether the strValue field is set.
     */
    public boolean hasStrValue() {
      return valueCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The strValue.
     */
    public java.lang.String getStrValue() {
      java.lang.Object ref = "";
      if (valueCase_ == 2) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (valueCase_ == 2) {
          value_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * String value.
     * </pre>
     *
     * <code>string str_value = 2;</code>
     *
     * @return The bytes for strValue.
     */
    public com.google.protobuf.ByteString getStrValueBytes() {
      java.lang.Object ref = "";
      if (valueCase_ == 2) {
        ref = value_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (valueCase_ == 2) {
          value_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUM_VALUE_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return Whether the numValue field is set.
     */
    @java.lang.Override
    public boolean hasNumValue() {
      return valueCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Numerical value.
     * </pre>
     *
     * <code>double num_value = 3;</code>
     *
     * @return The numValue.
     */
    @java.lang.Override
    public double getNumValue() {
      if (valueCase_ == 3) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int BOOL_VALUE_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return Whether the boolValue field is set.
     */
    @java.lang.Override
    public boolean hasBoolValue() {
      return valueCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Boolean value.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return The boolValue.
     */
    @java.lang.Override
    public boolean getBoolValue() {
      if (valueCase_ == 4) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }

    public static final int NA_VALUE_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". Should only ever be `true`.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return Whether the naValue field is set.
     */
    @java.lang.Override
    public boolean hasNaValue() {
      return valueCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * A value of "Not Applicable (N/A)". Should only ever be `true`.
     * </pre>
     *
     * <code>bool na_value = 5;</code>
     *
     * @return The naValue.
     */
    @java.lang.Override
    public boolean getNaValue() {
      if (valueCase_ == 5) {
        return (java.lang.Boolean) value_;
      }
      return false;
    }

    public static final int KEY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object key_ = "";
    /**
     *
     *
     * <pre>
     * A short string used as an identifier. Matches the value used in
     * QaQuestion.AnswerChoice.key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A short string used as an identifier. Matches the value used in
     * QaQuestion.AnswerChoice.key.
     * </pre>
     *
     * <code>string key = 1;</code>
     *
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 6;
    private double score_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. Numerical score of the answer.
     * </pre>
     *
     * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Numerical score of the answer.
     * </pre>
     *
     * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    public static final int POTENTIAL_SCORE_FIELD_NUMBER = 7;
    private double potentialScore_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. The maximum potential score of the question.
     * </pre>
     *
     * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the potentialScore field is set.
     */
    @java.lang.Override
    public boolean hasPotentialScore() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The maximum potential score of the question.
     * </pre>
     *
     * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The potentialScore.
     */
    @java.lang.Override
    public double getPotentialScore() {
      return potentialScore_;
    }

    public static final int NORMALIZED_SCORE_FIELD_NUMBER = 8;
    private double normalizedScore_ = 0D;
    /**
     *
     *
     * <pre>
     * Output only. Normalized score of the questions. Calculated as score /
     * potential_score.
     * </pre>
     *
     * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the normalizedScore field is set.
     */
    @java.lang.Override
    public boolean hasNormalizedScore() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Normalized score of the questions. Calculated as score /
     * potential_score.
     * </pre>
     *
     * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The normalizedScore.
     */
    @java.lang.Override
    public double getNormalizedScore() {
      return normalizedScore_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (valueCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      if (valueCase_ == 3) {
        output.writeDouble(3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        output.writeBool(4, (boolean) ((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        output.writeBool(5, (boolean) ((java.lang.Boolean) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(6, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeDouble(7, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeDouble(8, normalizedScore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (valueCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      if (valueCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                3, (double) ((java.lang.Double) value_));
      }
      if (valueCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, (boolean) ((java.lang.Boolean) value_));
      }
      if (valueCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                5, (boolean) ((java.lang.Boolean) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(7, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(8, normalizedScore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue other =
          (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) obj;

      if (!getKey().equals(other.getKey())) return false;
      if (hasScore() != other.hasScore()) return false;
      if (hasScore()) {
        if (java.lang.Double.doubleToLongBits(getScore())
            != java.lang.Double.doubleToLongBits(other.getScore())) return false;
      }
      if (hasPotentialScore() != other.hasPotentialScore()) return false;
      if (hasPotentialScore()) {
        if (java.lang.Double.doubleToLongBits(getPotentialScore())
            != java.lang.Double.doubleToLongBits(other.getPotentialScore())) return false;
      }
      if (hasNormalizedScore() != other.hasNormalizedScore()) return false;
      if (hasNormalizedScore()) {
        if (java.lang.Double.doubleToLongBits(getNormalizedScore())
            != java.lang.Double.doubleToLongBits(other.getNormalizedScore())) return false;
      }
      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 2:
          if (!getStrValue().equals(other.getStrValue())) return false;
          break;
        case 3:
          if (java.lang.Double.doubleToLongBits(getNumValue())
              != java.lang.Double.doubleToLongBits(other.getNumValue())) return false;
          break;
        case 4:
          if (getBoolValue() != other.getBoolValue()) return false;
          break;
        case 5:
          if (getNaValue() != other.getNaValue()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (hasScore()) {
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScore()));
      }
      if (hasPotentialScore()) {
        hash = (37 * hash) + POTENTIAL_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getPotentialScore()));
      }
      if (hasNormalizedScore()) {
        hash = (37 * hash) + NORMALIZED_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getNormalizedScore()));
      }
      switch (valueCase_) {
        case 2:
          hash = (37 * hash) + STR_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getStrValue().hashCode();
          break;
        case 3:
          hash = (37 * hash) + NUM_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getNumValue()));
          break;
        case 4:
          hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
          break;
        case 5:
          hash = (37 * hash) + NA_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNaValue());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Message for holding the value of a
     * [QaAnswer][google.cloud.contactcenterinsights.v1.QaAnswer].
     * [QaQuestion.AnswerChoice][google.cloud.contactcenterinsights.v1.QaQuestion.AnswerChoice]
     * defines the possible answer values for a question.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.class,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder.class);
      }

      // Construct using com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        key_ = "";
        score_ = 0D;
        potentialScore_ = 0D;
        normalizedScore_ = 0D;
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerValue_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue build() {
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue result =
            new com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.key_ = key_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.score_ = score_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.potentialScore_ = potentialScore_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.normalizedScore_ = normalizedScore_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) {
          return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance())
          return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.hasScore()) {
          setScore(other.getScore());
        }
        if (other.hasPotentialScore()) {
          setPotentialScore(other.getPotentialScore());
        }
        if (other.hasNormalizedScore()) {
          setNormalizedScore(other.getNormalizedScore());
        }
        switch (other.getValueCase()) {
          case STR_VALUE:
            {
              valueCase_ = 2;
              value_ = other.value_;
              onChanged();
              break;
            }
          case NUM_VALUE:
            {
              setNumValue(other.getNumValue());
              break;
            }
          case BOOL_VALUE:
            {
              setBoolValue(other.getBoolValue());
              break;
            }
          case NA_VALUE:
            {
              setNaValue(other.getNaValue());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  key_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  valueCase_ = 2;
                  value_ = s;
                  break;
                } // case 18
              case 25:
                {
                  value_ = input.readDouble();
                  valueCase_ = 3;
                  break;
                } // case 25
              case 32:
                {
                  value_ = input.readBool();
                  valueCase_ = 4;
                  break;
                } // case 32
              case 40:
                {
                  value_ = input.readBool();
                  valueCase_ = 5;
                  break;
                } // case 40
              case 49:
                {
                  score_ = input.readDouble();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 49
              case 57:
                {
                  potentialScore_ = input.readDouble();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 57
              case 65:
                {
                  normalizedScore_ = input.readDouble();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 65
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return Whether the strValue field is set.
       */
      @java.lang.Override
      public boolean hasStrValue() {
        return valueCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return The strValue.
       */
      @java.lang.Override
      public java.lang.String getStrValue() {
        java.lang.Object ref = "";
        if (valueCase_ == 2) {
          ref = value_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (valueCase_ == 2) {
            value_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return The bytes for strValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getStrValueBytes() {
        java.lang.Object ref = "";
        if (valueCase_ == 2) {
          ref = value_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (valueCase_ == 2) {
            value_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @param value The strValue to set.
       * @return This builder for chaining.
       */
      public Builder setStrValue(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStrValue() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * String value.
       * </pre>
       *
       * <code>string str_value = 2;</code>
       *
       * @param value The bytes for strValue to set.
       * @return This builder for chaining.
       */
      public Builder setStrValueBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return Whether the numValue field is set.
       */
      public boolean hasNumValue() {
        return valueCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return The numValue.
       */
      public double getNumValue() {
        if (valueCase_ == 3) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @param value The numValue to set.
       * @return This builder for chaining.
       */
      public Builder setNumValue(double value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Numerical value.
       * </pre>
       *
       * <code>double num_value = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumValue() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return Whether the boolValue field is set.
       */
      public boolean hasBoolValue() {
        return valueCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return The boolValue.
       */
      public boolean getBoolValue() {
        if (valueCase_ == 4) {
          return (java.lang.Boolean) value_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @param value The boolValue to set.
       * @return This builder for chaining.
       */
      public Builder setBoolValue(boolean value) {

        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Boolean value.
       * </pre>
       *
       * <code>bool bool_value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBoolValue() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". Should only ever be `true`.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return Whether the naValue field is set.
       */
      public boolean hasNaValue() {
        return valueCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". Should only ever be `true`.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return The naValue.
       */
      public boolean getNaValue() {
        if (valueCase_ == 5) {
          return (java.lang.Boolean) value_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". Should only ever be `true`.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @param value The naValue to set.
       * @return This builder for chaining.
       */
      public Builder setNaValue(boolean value) {

        valueCase_ = 5;
        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A value of "Not Applicable (N/A)". Should only ever be `true`.
       * </pre>
       *
       * <code>bool na_value = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNaValue() {
        if (valueCase_ == 5) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       *
       *
       * <pre>
       * A short string used as an identifier. Matches the value used in
       * QaQuestion.AnswerChoice.key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier. Matches the value used in
       * QaQuestion.AnswerChoice.key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier. Matches the value used in
       * QaQuestion.AnswerChoice.key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier. Matches the value used in
       * QaQuestion.AnswerChoice.key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        key_ = getDefaultInstance().getKey();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A short string used as an identifier. Matches the value used in
       * QaQuestion.AnswerChoice.key.
       * </pre>
       *
       * <code>string key = 1;</code>
       *
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        key_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private double score_;
      /**
       *
       *
       * <pre>
       * Output only. Numerical score of the answer.
       * </pre>
       *
       * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Numerical score of the answer.
       * </pre>
       *
       * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Numerical score of the answer.
       * </pre>
       *
       * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(double value) {

        score_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Numerical score of the answer.
       * </pre>
       *
       * <code>optional double score = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000020);
        score_ = 0D;
        onChanged();
        return this;
      }

      private double potentialScore_;
      /**
       *
       *
       * <pre>
       * Output only. The maximum potential score of the question.
       * </pre>
       *
       * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the potentialScore field is set.
       */
      @java.lang.Override
      public boolean hasPotentialScore() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The maximum potential score of the question.
       * </pre>
       *
       * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The potentialScore.
       */
      @java.lang.Override
      public double getPotentialScore() {
        return potentialScore_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The maximum potential score of the question.
       * </pre>
       *
       * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The potentialScore to set.
       * @return This builder for chaining.
       */
      public Builder setPotentialScore(double value) {

        potentialScore_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The maximum potential score of the question.
       * </pre>
       *
       * <code>optional double potential_score = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPotentialScore() {
        bitField0_ = (bitField0_ & ~0x00000040);
        potentialScore_ = 0D;
        onChanged();
        return this;
      }

      private double normalizedScore_;
      /**
       *
       *
       * <pre>
       * Output only. Normalized score of the questions. Calculated as score /
       * potential_score.
       * </pre>
       *
       * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the normalizedScore field is set.
       */
      @java.lang.Override
      public boolean hasNormalizedScore() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Normalized score of the questions. Calculated as score /
       * potential_score.
       * </pre>
       *
       * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The normalizedScore.
       */
      @java.lang.Override
      public double getNormalizedScore() {
        return normalizedScore_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Normalized score of the questions. Calculated as score /
       * potential_score.
       * </pre>
       *
       * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The normalizedScore to set.
       * @return This builder for chaining.
       */
      public Builder setNormalizedScore(double value) {

        normalizedScore_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Normalized score of the questions. Calculated as score /
       * potential_score.
       * </pre>
       *
       * <code>optional double normalized_score = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNormalizedScore() {
        bitField0_ = (bitField0_ & ~0x00000080);
        normalizedScore_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue)
    private static final com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerValue> PARSER =
        new com.google.protobuf.AbstractParser<AnswerValue>() {
          @java.lang.Override
          public AnswerValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AnswerSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * What created the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    int getSourceTypeValue();
    /**
     *
     *
     * <pre>
     * What created the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
     * </code>
     *
     * @return The sourceType.
     */
    com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType getSourceType();

    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     *
     * @return Whether the answerValue field is set.
     */
    boolean hasAnswerValue();
    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     *
     * @return The answerValue.
     */
    com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getAnswerValue();
    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     */
    com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
        getAnswerValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A question may have multiple answers from varying sources, one of which
   * becomes the "main" answer above. AnswerSource represents each individual
   * answer.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource}
   */
  public static final class AnswerSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)
      AnswerSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnswerSource.newBuilder() to construct.
    private AnswerSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnswerSource() {
      sourceType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnswerSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.class,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * What created the answer.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType}
     */
    public enum SourceType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Source type is unspecified.
       * </pre>
       *
       * <code>SOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      SOURCE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Answer was system-generated; created during an Insights analysis.
       * </pre>
       *
       * <code>SYSTEM_GENERATED = 1;</code>
       */
      SYSTEM_GENERATED(1),
      /**
       *
       *
       * <pre>
       * Answer was created by a human via manual edit.
       * </pre>
       *
       * <code>MANUAL_EDIT = 2;</code>
       */
      MANUAL_EDIT(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Source type is unspecified.
       * </pre>
       *
       * <code>SOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int SOURCE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Answer was system-generated; created during an Insights analysis.
       * </pre>
       *
       * <code>SYSTEM_GENERATED = 1;</code>
       */
      public static final int SYSTEM_GENERATED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Answer was created by a human via manual edit.
       * </pre>
       *
       * <code>MANUAL_EDIT = 2;</code>
       */
      public static final int MANUAL_EDIT_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SourceType forNumber(int value) {
        switch (value) {
          case 0:
            return SOURCE_TYPE_UNSPECIFIED;
          case 1:
            return SYSTEM_GENERATED;
          case 2:
            return MANUAL_EDIT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SourceType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SourceType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SourceType>() {
            public SourceType findValueByNumber(int number) {
              return SourceType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SourceType[] VALUES = values();

      public static SourceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SourceType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType)
    }

    private int bitField0_;
    public static final int SOURCE_TYPE_FIELD_NUMBER = 1;
    private int sourceType_ = 0;
    /**
     *
     *
     * <pre>
     * What created the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override
    public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     *
     *
     * <pre>
     * What created the answer.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
     * </code>
     *
     * @return The sourceType.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType
        getSourceType() {
      com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType result =
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType.forNumber(
              sourceType_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType.UNRECOGNIZED
          : result;
    }

    public static final int ANSWER_VALUE_FIELD_NUMBER = 2;
    private com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answerValue_;
    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     *
     * @return Whether the answerValue field is set.
     */
    @java.lang.Override
    public boolean hasAnswerValue() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     *
     * @return The answerValue.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getAnswerValue() {
      return answerValue_ == null
          ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
          : answerValue_;
    }
    /**
     *
     *
     * <pre>
     * The answer value from this source.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
        getAnswerValueOrBuilder() {
      return answerValue_ == null
          ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
          : answerValue_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceType_
          != com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType
              .SOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, sourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getAnswerValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceType_
          != com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType
              .SOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, sourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAnswerValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource other =
          (com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource) obj;

      if (sourceType_ != other.sourceType_) return false;
      if (hasAnswerValue() != other.hasAnswerValue()) return false;
      if (hasAnswerValue()) {
        if (!getAnswerValue().equals(other.getAnswerValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + sourceType_;
      if (hasAnswerValue()) {
        hash = (37 * hash) + ANSWER_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getAnswerValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A question may have multiple answers from varying sources, one of which
     * becomes the "main" answer above. AnswerSource represents each individual
     * answer.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.class,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAnswerValueFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sourceType_ = 0;
        answerValue_ = null;
        if (answerValueBuilder_ != null) {
          answerValueBuilder_.dispose();
          answerValueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_AnswerSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource build() {
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource result =
            new com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sourceType_ = sourceType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.answerValue_ =
              answerValueBuilder_ == null ? answerValue_ : answerValueBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource) {
          return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.getDefaultInstance())
          return this;
        if (other.sourceType_ != 0) {
          setSourceTypeValue(other.getSourceTypeValue());
        }
        if (other.hasAnswerValue()) {
          mergeAnswerValue(other.getAnswerValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  sourceType_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getAnswerValueFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int sourceType_ = 0;
      /**
       *
       *
       * <pre>
       * What created the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for sourceType.
       */
      @java.lang.Override
      public int getSourceTypeValue() {
        return sourceType_;
      }
      /**
       *
       *
       * <pre>
       * What created the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for sourceType to set.
       * @return This builder for chaining.
       */
      public Builder setSourceTypeValue(int value) {
        sourceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * What created the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
       * </code>
       *
       * @return The sourceType.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType
          getSourceType() {
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType result =
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType.forNumber(
                sourceType_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * What created the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
       * </code>
       *
       * @param value The sourceType to set.
       * @return This builder for chaining.
       */
      public Builder setSourceType(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        sourceType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * What created the answer.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.SourceType source_type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sourceType_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answerValue_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
          answerValueBuilder_;
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       *
       * @return Whether the answerValue field is set.
       */
      public boolean hasAnswerValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       *
       * @return The answerValue.
       */
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getAnswerValue() {
        if (answerValueBuilder_ == null) {
          return answerValue_ == null
              ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
              : answerValue_;
        } else {
          return answerValueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public Builder setAnswerValue(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
        if (answerValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          answerValue_ = value;
        } else {
          answerValueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public Builder setAnswerValue(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder builderForValue) {
        if (answerValueBuilder_ == null) {
          answerValue_ = builderForValue.build();
        } else {
          answerValueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public Builder mergeAnswerValue(
          com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
        if (answerValueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && answerValue_ != null
              && answerValue_
                  != com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
                      .getDefaultInstance()) {
            getAnswerValueBuilder().mergeFrom(value);
          } else {
            answerValue_ = value;
          }
        } else {
          answerValueBuilder_.mergeFrom(value);
        }
        if (answerValue_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public Builder clearAnswerValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        answerValue_ = null;
        if (answerValueBuilder_ != null) {
          answerValueBuilder_.dispose();
          answerValueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder
          getAnswerValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getAnswerValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
          getAnswerValueOrBuilder() {
        if (answerValueBuilder_ != null) {
          return answerValueBuilder_.getMessageOrBuilder();
        } else {
          return answerValue_ == null
              ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
              : answerValue_;
        }
      }
      /**
       *
       *
       * <pre>
       * The answer value from this source.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
          getAnswerValueFieldBuilder() {
        if (answerValueBuilder_ == null) {
          answerValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
                  com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
                  com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>(
                  getAnswerValue(), getParentForChildren(), isClean());
          answerValue_ = null;
        }
        return answerValueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource)
    private static final com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnswerSource> PARSER =
        new com.google.protobuf.AbstractParser<AnswerSource>() {
          @java.lang.Override
          public AnswerSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnswerSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnswerSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int QA_QUESTION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object qaQuestion_ = "";
  /**
   *
   *
   * <pre>
   * The QaQuestion answered by this answer.
   * </pre>
   *
   * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The qaQuestion.
   */
  @java.lang.Override
  public java.lang.String getQaQuestion() {
    java.lang.Object ref = qaQuestion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      qaQuestion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The QaQuestion answered by this answer.
   * </pre>
   *
   * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for qaQuestion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQaQuestionBytes() {
    java.lang.Object ref = qaQuestion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      qaQuestion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversation_ = "";
  /**
   *
   *
   * <pre>
   * The conversation the answer applies to.
   * </pre>
   *
   * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public java.lang.String getConversation() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The conversation the answer applies to.
   * </pre>
   *
   * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for conversation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationBytes() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUESTION_BODY_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object questionBody_ = "";
  /**
   *
   *
   * <pre>
   * Question text. E.g., "Did the agent greet the customer?"
   * </pre>
   *
   * <code>string question_body = 6;</code>
   *
   * @return The questionBody.
   */
  @java.lang.Override
  public java.lang.String getQuestionBody() {
    java.lang.Object ref = questionBody_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      questionBody_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Question text. E.g., "Did the agent greet the customer?"
   * </pre>
   *
   * <code>string question_body = 6;</code>
   *
   * @return The bytes for questionBody.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuestionBodyBytes() {
    java.lang.Object ref = questionBody_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      questionBody_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANSWER_VALUE_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answerValue_;
  /**
   *
   *
   * <pre>
   * The main answer value, incorporating any manual edits if they exist.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
   *
   * @return Whether the answerValue field is set.
   */
  @java.lang.Override
  public boolean hasAnswerValue() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The main answer value, incorporating any manual edits if they exist.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
   *
   * @return The answerValue.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getAnswerValue() {
    return answerValue_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
        : answerValue_;
  }
  /**
   *
   *
   * <pre>
   * The main answer value, incorporating any manual edits if they exist.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
      getAnswerValueOrBuilder() {
    return answerValue_ == null
        ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
        : answerValue_;
  }

  public static final int TAGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList tags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags. Matches the value from
   * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
   * for weighting the score of each answer.
   * </pre>
   *
   * <code>repeated string tags = 5;</code>
   *
   * @return A list containing the tags.
   */
  public com.google.protobuf.ProtocolStringList getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags. Matches the value from
   * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
   * for weighting the score of each answer.
   * </pre>
   *
   * <code>repeated string tags = 5;</code>
   *
   * @return The count of tags.
   */
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags. Matches the value from
   * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
   * for weighting the score of each answer.
   * </pre>
   *
   * <code>repeated string tags = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The tags at the given index.
   */
  public java.lang.String getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User-defined list of arbitrary tags. Matches the value from
   * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
   * for weighting the score of each answer.
   * </pre>
   *
   * <code>repeated string tags = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the tags at the given index.
   */
  public com.google.protobuf.ByteString getTagsBytes(int index) {
    return tags_.getByteString(index);
  }

  public static final int ANSWER_SOURCES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>
      answerSources_;
  /**
   *
   *
   * <pre>
   * List of all individual answers given to the question.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>
      getAnswerSourcesList() {
    return answerSources_;
  }
  /**
   *
   *
   * <pre>
   * List of all individual answers given to the question.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder>
      getAnswerSourcesOrBuilderList() {
    return answerSources_;
  }
  /**
   *
   *
   * <pre>
   * List of all individual answers given to the question.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
   * </code>
   */
  @java.lang.Override
  public int getAnswerSourcesCount() {
    return answerSources_.size();
  }
  /**
   *
   *
   * <pre>
   * List of all individual answers given to the question.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource getAnswerSources(
      int index) {
    return answerSources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of all individual answers given to the question.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder
      getAnswerSourcesOrBuilder(int index) {
    return answerSources_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, conversation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAnswerValue());
    }
    for (int i = 0; i < tags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, tags_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, questionBody_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, qaQuestion_);
    }
    for (int i = 0; i < answerSources_.size(); i++) {
      output.writeMessage(8, answerSources_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, conversation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnswerValue());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < tags_.size(); i++) {
        dataSize += computeStringSizeNoTag(tags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTagsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(questionBody_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, questionBody_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaQuestion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, qaQuestion_);
    }
    for (int i = 0; i < answerSources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, answerSources_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QaAnswer other =
        (com.google.cloud.contactcenterinsights.v1.QaAnswer) obj;

    if (!getQaQuestion().equals(other.getQaQuestion())) return false;
    if (!getConversation().equals(other.getConversation())) return false;
    if (!getQuestionBody().equals(other.getQuestionBody())) return false;
    if (hasAnswerValue() != other.hasAnswerValue()) return false;
    if (hasAnswerValue()) {
      if (!getAnswerValue().equals(other.getAnswerValue())) return false;
    }
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getAnswerSourcesList().equals(other.getAnswerSourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + QA_QUESTION_FIELD_NUMBER;
    hash = (53 * hash) + getQaQuestion().hashCode();
    hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + getConversation().hashCode();
    hash = (37 * hash) + QUESTION_BODY_FIELD_NUMBER;
    hash = (53 * hash) + getQuestionBody().hashCode();
    if (hasAnswerValue()) {
      hash = (37 * hash) + ANSWER_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerValue().hashCode();
    }
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    if (getAnswerSourcesCount() > 0) {
      hash = (37 * hash) + ANSWER_SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getAnswerSourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.QaAnswer prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An answer to a QaQuestion.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaAnswer}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaAnswer)
      com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaAnswer.class,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QaAnswer.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAnswerValueFieldBuilder();
        getAnswerSourcesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      qaQuestion_ = "";
      conversation_ = "";
      questionBody_ = "";
      answerValue_ = null;
      if (answerValueBuilder_ != null) {
        answerValueBuilder_.dispose();
        answerValueBuilder_ = null;
      }
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (answerSourcesBuilder_ == null) {
        answerSources_ = java.util.Collections.emptyList();
      } else {
        answerSources_ = null;
        answerSourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaAnswer_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QaAnswer.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer build() {
      com.google.cloud.contactcenterinsights.v1.QaAnswer result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaAnswer buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QaAnswer result =
          new com.google.cloud.contactcenterinsights.v1.QaAnswer(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.QaAnswer result) {
      if (answerSourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          answerSources_ = java.util.Collections.unmodifiableList(answerSources_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.answerSources_ = answerSources_;
      } else {
        result.answerSources_ = answerSourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.QaAnswer result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.qaQuestion_ = qaQuestion_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.conversation_ = conversation_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.questionBody_ = questionBody_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.answerValue_ =
            answerValueBuilder_ == null ? answerValue_ : answerValueBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        tags_.makeImmutable();
        result.tags_ = tags_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QaAnswer) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaAnswer) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QaAnswer other) {
      if (other == com.google.cloud.contactcenterinsights.v1.QaAnswer.getDefaultInstance())
        return this;
      if (!other.getQaQuestion().isEmpty()) {
        qaQuestion_ = other.qaQuestion_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getConversation().isEmpty()) {
        conversation_ = other.conversation_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getQuestionBody().isEmpty()) {
        questionBody_ = other.questionBody_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasAnswerValue()) {
        mergeAnswerValue(other.getAnswerValue());
      }
      if (!other.tags_.isEmpty()) {
        if (tags_.isEmpty()) {
          tags_ = other.tags_;
          bitField0_ |= 0x00000010;
        } else {
          ensureTagsIsMutable();
          tags_.addAll(other.tags_);
        }
        onChanged();
      }
      if (answerSourcesBuilder_ == null) {
        if (!other.answerSources_.isEmpty()) {
          if (answerSources_.isEmpty()) {
            answerSources_ = other.answerSources_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureAnswerSourcesIsMutable();
            answerSources_.addAll(other.answerSources_);
          }
          onChanged();
        }
      } else {
        if (!other.answerSources_.isEmpty()) {
          if (answerSourcesBuilder_.isEmpty()) {
            answerSourcesBuilder_.dispose();
            answerSourcesBuilder_ = null;
            answerSources_ = other.answerSources_;
            bitField0_ = (bitField0_ & ~0x00000020);
            answerSourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnswerSourcesFieldBuilder()
                    : null;
          } else {
            answerSourcesBuilder_.addAllMessages(other.answerSources_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                conversation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAnswerValueFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTagsIsMutable();
                tags_.add(s);
                break;
              } // case 42
            case 50:
              {
                questionBody_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 50
            case 58:
              {
                qaQuestion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.parser(),
                        extensionRegistry);
                if (answerSourcesBuilder_ == null) {
                  ensureAnswerSourcesIsMutable();
                  answerSources_.add(m);
                } else {
                  answerSourcesBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object qaQuestion_ = "";
    /**
     *
     *
     * <pre>
     * The QaQuestion answered by this answer.
     * </pre>
     *
     * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The qaQuestion.
     */
    public java.lang.String getQaQuestion() {
      java.lang.Object ref = qaQuestion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaQuestion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The QaQuestion answered by this answer.
     * </pre>
     *
     * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for qaQuestion.
     */
    public com.google.protobuf.ByteString getQaQuestionBytes() {
      java.lang.Object ref = qaQuestion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaQuestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The QaQuestion answered by this answer.
     * </pre>
     *
     * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The qaQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setQaQuestion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      qaQuestion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The QaQuestion answered by this answer.
     * </pre>
     *
     * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQaQuestion() {
      qaQuestion_ = getDefaultInstance().getQaQuestion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The QaQuestion answered by this answer.
     * </pre>
     *
     * <code>string qa_question = 7 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for qaQuestion to set.
     * @return This builder for chaining.
     */
    public Builder setQaQuestionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      qaQuestion_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object conversation_ = "";
    /**
     *
     *
     * <pre>
     * The conversation the answer applies to.
     * </pre>
     *
     * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The conversation.
     */
    public java.lang.String getConversation() {
      java.lang.Object ref = conversation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation the answer applies to.
     * </pre>
     *
     * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for conversation.
     */
    public com.google.protobuf.ByteString getConversationBytes() {
      java.lang.Object ref = conversation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation the answer applies to.
     * </pre>
     *
     * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation the answer applies to.
     * </pre>
     *
     * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversation() {
      conversation_ = getDefaultInstance().getConversation();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation the answer applies to.
     * </pre>
     *
     * <code>string conversation = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversation_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object questionBody_ = "";
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 6;</code>
     *
     * @return The questionBody.
     */
    public java.lang.String getQuestionBody() {
      java.lang.Object ref = questionBody_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        questionBody_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 6;</code>
     *
     * @return The bytes for questionBody.
     */
    public com.google.protobuf.ByteString getQuestionBodyBytes() {
      java.lang.Object ref = questionBody_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        questionBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 6;</code>
     *
     * @param value The questionBody to set.
     * @return This builder for chaining.
     */
    public Builder setQuestionBody(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      questionBody_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuestionBody() {
      questionBody_ = getDefaultInstance().getQuestionBody();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Question text. E.g., "Did the agent greet the customer?"
     * </pre>
     *
     * <code>string question_body = 6;</code>
     *
     * @param value The bytes for questionBody to set.
     * @return This builder for chaining.
     */
    public Builder setQuestionBodyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      questionBody_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answerValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
        answerValueBuilder_;
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     *
     * @return Whether the answerValue field is set.
     */
    public boolean hasAnswerValue() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     *
     * @return The answerValue.
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue getAnswerValue() {
      if (answerValueBuilder_ == null) {
        return answerValue_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
            : answerValue_;
      } else {
        return answerValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public Builder setAnswerValue(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
      if (answerValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        answerValue_ = value;
      } else {
        answerValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public Builder setAnswerValue(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder builderForValue) {
      if (answerValueBuilder_ == null) {
        answerValue_ = builderForValue.build();
      } else {
        answerValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public Builder mergeAnswerValue(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue value) {
      if (answerValueBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && answerValue_ != null
            && answerValue_
                != com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue
                    .getDefaultInstance()) {
          getAnswerValueBuilder().mergeFrom(value);
        } else {
          answerValue_ = value;
        }
      } else {
        answerValueBuilder_.mergeFrom(value);
      }
      if (answerValue_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public Builder clearAnswerValue() {
      bitField0_ = (bitField0_ & ~0x00000008);
      answerValue_ = null;
      if (answerValueBuilder_ != null) {
        answerValueBuilder_.dispose();
        answerValueBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder
        getAnswerValueBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAnswerValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder
        getAnswerValueOrBuilder() {
      if (answerValueBuilder_ != null) {
        return answerValueBuilder_.getMessageOrBuilder();
      } else {
        return answerValue_ == null
            ? com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.getDefaultInstance()
            : answerValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * The main answer value, incorporating any manual edits if they exist.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue answer_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>
        getAnswerValueFieldBuilder() {
      if (answerValueBuilder_ == null) {
        answerValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValue.Builder,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerValueOrBuilder>(
                getAnswerValue(), getParentForChildren(), isClean());
        answerValue_ = null;
      }
      return answerValueBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList tags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureTagsIsMutable() {
      if (!tags_.isModifiable()) {
        tags_ = new com.google.protobuf.LazyStringArrayList(tags_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return A list containing the tags.
     */
    public com.google.protobuf.ProtocolStringList getTagsList() {
      tags_.makeImmutable();
      return tags_;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return The count of tags.
     */
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The tags at the given index.
     */
    public java.lang.String getTags(int index) {
      return tags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the tags at the given index.
     */
    public com.google.protobuf.ByteString getTagsBytes(int index) {
      return tags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The tags to set.
     * @return This builder for chaining.
     */
    public Builder setTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param value The tags to add.
     * @return This builder for chaining.
     */
    public Builder addTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param values The tags to add.
     * @return This builder for chaining.
     */
    public Builder addAllTags(java.lang.Iterable<java.lang.String> values) {
      ensureTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTags() {
      tags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-defined list of arbitrary tags. Matches the value from
     * QaScorecard.ScorecardQuestion.tags. Used for grouping/organization and
     * for weighting the score of each answer.
     * </pre>
     *
     * <code>repeated string tags = 5;</code>
     *
     * @param value The bytes of the tags to add.
     * @return This builder for chaining.
     */
    public Builder addTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTagsIsMutable();
      tags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>
        answerSources_ = java.util.Collections.emptyList();

    private void ensureAnswerSourcesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        answerSources_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>(answerSources_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder>
        answerSourcesBuilder_;

    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>
        getAnswerSourcesList() {
      if (answerSourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(answerSources_);
      } else {
        return answerSourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public int getAnswerSourcesCount() {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.size();
      } else {
        return answerSourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource getAnswerSources(
        int index) {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.get(index);
      } else {
        return answerSourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder setAnswerSources(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.set(index, value);
        onChanged();
      } else {
        answerSourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder setAnswerSources(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.set(index, builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder addAnswerSources(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.add(value);
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder addAnswerSources(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource value) {
      if (answerSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnswerSourcesIsMutable();
        answerSources_.add(index, value);
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder addAnswerSources(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.add(builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder addAnswerSources(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder builderForValue) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.add(index, builderForValue.build());
        onChanged();
      } else {
        answerSourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder addAllAnswerSources(
        java.lang.Iterable<
                ? extends com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource>
            values) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, answerSources_);
        onChanged();
      } else {
        answerSourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder clearAnswerSources() {
      if (answerSourcesBuilder_ == null) {
        answerSources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        answerSourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public Builder removeAnswerSources(int index) {
      if (answerSourcesBuilder_ == null) {
        ensureAnswerSourcesIsMutable();
        answerSources_.remove(index);
        onChanged();
      } else {
        answerSourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder
        getAnswerSourcesBuilder(int index) {
      return getAnswerSourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder
        getAnswerSourcesOrBuilder(int index) {
      if (answerSourcesBuilder_ == null) {
        return answerSources_.get(index);
      } else {
        return answerSourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder>
        getAnswerSourcesOrBuilderList() {
      if (answerSourcesBuilder_ != null) {
        return answerSourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(answerSources_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder
        addAnswerSourcesBuilder() {
      return getAnswerSourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder
        addAnswerSourcesBuilder(int index) {
      return getAnswerSourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all individual answers given to the question.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource answer_sources = 8;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder>
        getAnswerSourcesBuilderList() {
      return getAnswerSourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder>
        getAnswerSourcesFieldBuilder() {
      if (answerSourcesBuilder_ == null) {
        answerSourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSource.Builder,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.AnswerSourceOrBuilder>(
                answerSources_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        answerSources_ = null;
      }
      return answerSourcesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaAnswer)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaAnswer)
  private static final com.google.cloud.contactcenterinsights.v1.QaAnswer DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaAnswer();
  }

  public static com.google.cloud.contactcenterinsights.v1.QaAnswer getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QaAnswer> PARSER =
      new com.google.protobuf.AbstractParser<QaAnswer>() {
        @java.lang.Override
        public QaAnswer parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QaAnswer> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QaAnswer> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
