/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The results of scoring a single conversation against a QaScorecard. Contains
 * a collection of QaAnswers and aggregate score.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult}
 */
public final class QaScorecardResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult)
    QaScorecardResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QaScorecardResult.newBuilder() to construct.
  private QaScorecardResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QaScorecardResult() {
    name_ = "";
    qaScorecardRevision_ = "";
    conversation_ = "";
    agentId_ = "";
    qaAnswers_ = java.util.Collections.emptyList();
    qaTagResults_ = java.util.Collections.emptyList();
    scoreSources_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QaScorecardResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.class,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.Builder.class);
  }

  public interface QaTagResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The tag the score applies to.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The tag.
     */
    java.lang.String getTag();
    /**
     *
     *
     * <pre>
     * The tag the score applies to.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The bytes for tag.
     */
    com.google.protobuf.ByteString getTagBytes();

    /**
     *
     *
     * <pre>
     * The score the tag applies to.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return Whether the score field is set.
     */
    boolean hasScore();
    /**
     *
     *
     * <pre>
     * The score the tag applies to.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return The score.
     */
    double getScore();

    /**
     *
     *
     * <pre>
     * The potential score the tag applies to.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return Whether the potentialScore field is set.
     */
    boolean hasPotentialScore();
    /**
     *
     *
     * <pre>
     * The potential score the tag applies to.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return The potentialScore.
     */
    double getPotentialScore();

    /**
     *
     *
     * <pre>
     * The normalized score the tag applies to.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return Whether the normalizedScore field is set.
     */
    boolean hasNormalizedScore();
    /**
     *
     *
     * <pre>
     * The normalized score the tag applies to.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return The normalizedScore.
     */
    double getNormalizedScore();
  }
  /**
   *
   *
   * <pre>
   * Tags and their corresponding results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult}
   */
  public static final class QaTagResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)
      QaTagResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaTagResult.newBuilder() to construct.
    private QaTagResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaTagResult() {
      tag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaTagResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_QaTagResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_QaTagResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.class,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
                  .class);
    }

    private int bitField0_;
    public static final int TAG_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object tag_ = "";
    /**
     *
     *
     * <pre>
     * The tag the score applies to.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The tag.
     */
    @java.lang.Override
    public java.lang.String getTag() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tag_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The tag the score applies to.
     * </pre>
     *
     * <code>string tag = 1;</code>
     *
     * @return The bytes for tag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTagBytes() {
      java.lang.Object ref = tag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private double score_ = 0D;
    /**
     *
     *
     * <pre>
     * The score the tag applies to.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The score the tag applies to.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    public static final int POTENTIAL_SCORE_FIELD_NUMBER = 3;
    private double potentialScore_ = 0D;
    /**
     *
     *
     * <pre>
     * The potential score the tag applies to.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return Whether the potentialScore field is set.
     */
    @java.lang.Override
    public boolean hasPotentialScore() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The potential score the tag applies to.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return The potentialScore.
     */
    @java.lang.Override
    public double getPotentialScore() {
      return potentialScore_;
    }

    public static final int NORMALIZED_SCORE_FIELD_NUMBER = 4;
    private double normalizedScore_ = 0D;
    /**
     *
     *
     * <pre>
     * The normalized score the tag applies to.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return Whether the normalizedScore field is set.
     */
    @java.lang.Override
    public boolean hasNormalizedScore() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The normalized score the tag applies to.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return The normalizedScore.
     */
    @java.lang.Override
    public double getNormalizedScore() {
      return normalizedScore_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tag_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(2, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeDouble(3, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeDouble(4, normalizedScore_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tag_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, normalizedScore_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult other =
          (com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult) obj;

      if (!getTag().equals(other.getTag())) return false;
      if (hasScore() != other.hasScore()) return false;
      if (hasScore()) {
        if (java.lang.Double.doubleToLongBits(getScore())
            != java.lang.Double.doubleToLongBits(other.getScore())) return false;
      }
      if (hasPotentialScore() != other.hasPotentialScore()) return false;
      if (hasPotentialScore()) {
        if (java.lang.Double.doubleToLongBits(getPotentialScore())
            != java.lang.Double.doubleToLongBits(other.getPotentialScore())) return false;
      }
      if (hasNormalizedScore() != other.hasNormalizedScore()) return false;
      if (hasNormalizedScore()) {
        if (java.lang.Double.doubleToLongBits(getNormalizedScore())
            != java.lang.Double.doubleToLongBits(other.getNormalizedScore())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TAG_FIELD_NUMBER;
      hash = (53 * hash) + getTag().hashCode();
      if (hasScore()) {
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScore()));
      }
      if (hasPotentialScore()) {
        hash = (37 * hash) + POTENTIAL_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getPotentialScore()));
      }
      if (hasNormalizedScore()) {
        hash = (37 * hash) + NORMALIZED_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getNormalizedScore()));
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Tags and their corresponding results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_QaTagResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_QaTagResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.class,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        tag_ = "";
        score_ = 0D;
        potentialScore_ = 0D;
        normalizedScore_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_QaTagResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult build() {
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult result =
            new com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.tag_ = tag_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.score_ = score_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.potentialScore_ = potentialScore_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.normalizedScore_ = normalizedScore_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                .getDefaultInstance()) return this;
        if (!other.getTag().isEmpty()) {
          tag_ = other.tag_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasScore()) {
          setScore(other.getScore());
        }
        if (other.hasPotentialScore()) {
          setPotentialScore(other.getPotentialScore());
        }
        if (other.hasNormalizedScore()) {
          setNormalizedScore(other.getNormalizedScore());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  tag_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  score_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 25:
                {
                  potentialScore_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              case 33:
                {
                  normalizedScore_ = input.readDouble();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 33
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object tag_ = "";
      /**
       *
       *
       * <pre>
       * The tag the score applies to.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return The tag.
       */
      public java.lang.String getTag() {
        java.lang.Object ref = tag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The tag the score applies to.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return The bytes for tag.
       */
      public com.google.protobuf.ByteString getTagBytes() {
        java.lang.Object ref = tag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          tag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The tag the score applies to.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @param value The tag to set.
       * @return This builder for chaining.
       */
      public Builder setTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        tag_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The tag the score applies to.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTag() {
        tag_ = getDefaultInstance().getTag();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The tag the score applies to.
       * </pre>
       *
       * <code>string tag = 1;</code>
       *
       * @param value The bytes for tag to set.
       * @return This builder for chaining.
       */
      public Builder setTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        tag_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private double score_;
      /**
       *
       *
       * <pre>
       * The score the tag applies to.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The score the tag applies to.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * The score the tag applies to.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(double value) {

        score_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The score the tag applies to.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000002);
        score_ = 0D;
        onChanged();
        return this;
      }

      private double potentialScore_;
      /**
       *
       *
       * <pre>
       * The potential score the tag applies to.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return Whether the potentialScore field is set.
       */
      @java.lang.Override
      public boolean hasPotentialScore() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The potential score the tag applies to.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return The potentialScore.
       */
      @java.lang.Override
      public double getPotentialScore() {
        return potentialScore_;
      }
      /**
       *
       *
       * <pre>
       * The potential score the tag applies to.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @param value The potentialScore to set.
       * @return This builder for chaining.
       */
      public Builder setPotentialScore(double value) {

        potentialScore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The potential score the tag applies to.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPotentialScore() {
        bitField0_ = (bitField0_ & ~0x00000004);
        potentialScore_ = 0D;
        onChanged();
        return this;
      }

      private double normalizedScore_;
      /**
       *
       *
       * <pre>
       * The normalized score the tag applies to.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return Whether the normalizedScore field is set.
       */
      @java.lang.Override
      public boolean hasNormalizedScore() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The normalized score the tag applies to.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return The normalizedScore.
       */
      @java.lang.Override
      public double getNormalizedScore() {
        return normalizedScore_;
      }
      /**
       *
       *
       * <pre>
       * The normalized score the tag applies to.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @param value The normalizedScore to set.
       * @return This builder for chaining.
       */
      public Builder setNormalizedScore(double value) {

        normalizedScore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The normalized score the tag applies to.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNormalizedScore() {
        bitField0_ = (bitField0_ & ~0x00000008);
        normalizedScore_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult)
    private static final com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaTagResult> PARSER =
        new com.google.protobuf.AbstractParser<QaTagResult>() {
          @java.lang.Override
          public QaTagResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaTagResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaTagResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScoreSourceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * What created the score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    int getSourceTypeValue();
    /**
     *
     *
     * <pre>
     * What created the score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
     * </code>
     *
     * @return The sourceType.
     */
    com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
        getSourceType();

    /**
     *
     *
     * <pre>
     * The overall numerical score of the result.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return Whether the score field is set.
     */
    boolean hasScore();
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return The score.
     */
    double getScore();

    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return Whether the potentialScore field is set.
     */
    boolean hasPotentialScore();
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return The potentialScore.
     */
    double getPotentialScore();

    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return Whether the normalizedScore field is set.
     */
    boolean hasNormalizedScore();
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return The normalizedScore.
     */
    double getNormalizedScore();

    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
        getQaTagResultsList();
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult getQaTagResults(
        int index);
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    int getQaTagResultsCount();
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
        getQaTagResultsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder
        getQaTagResultsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A scorecard result may have multiple sets of scores from varying sources,
   * one of which becomes the "main" answer above. A ScoreSource represents
   * each individual set of scores.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource}
   */
  public static final class ScoreSource extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)
      ScoreSourceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ScoreSource.newBuilder() to construct.
    private ScoreSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ScoreSource() {
      sourceType_ = 0;
      qaTagResults_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ScoreSource();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_ScoreSource_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_ScoreSource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.class,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * What created the score.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType}
     */
    public enum SourceType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Source type is unspecified.
       * </pre>
       *
       * <code>SOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      SOURCE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Score is derived only from system-generated answers.
       * </pre>
       *
       * <code>SYSTEM_GENERATED_ONLY = 1;</code>
       */
      SYSTEM_GENERATED_ONLY(1),
      /**
       *
       *
       * <pre>
       * Score is derived from both system-generated answers, and includes
       * any manual edits if they exist.
       * </pre>
       *
       * <code>INCLUDES_MANUAL_EDITS = 2;</code>
       */
      INCLUDES_MANUAL_EDITS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Source type is unspecified.
       * </pre>
       *
       * <code>SOURCE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int SOURCE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Score is derived only from system-generated answers.
       * </pre>
       *
       * <code>SYSTEM_GENERATED_ONLY = 1;</code>
       */
      public static final int SYSTEM_GENERATED_ONLY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Score is derived from both system-generated answers, and includes
       * any manual edits if they exist.
       * </pre>
       *
       * <code>INCLUDES_MANUAL_EDITS = 2;</code>
       */
      public static final int INCLUDES_MANUAL_EDITS_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static SourceType forNumber(int value) {
        switch (value) {
          case 0:
            return SOURCE_TYPE_UNSPECIFIED;
          case 1:
            return SYSTEM_GENERATED_ONLY;
          case 2:
            return INCLUDES_MANUAL_EDITS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SourceType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<SourceType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SourceType>() {
            public SourceType findValueByNumber(int number) {
              return SourceType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final SourceType[] VALUES = values();

      public static SourceType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SourceType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType)
    }

    private int bitField0_;
    public static final int SOURCE_TYPE_FIELD_NUMBER = 1;
    private int sourceType_ = 0;
    /**
     *
     *
     * <pre>
     * What created the score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for sourceType.
     */
    @java.lang.Override
    public int getSourceTypeValue() {
      return sourceType_;
    }
    /**
     *
     *
     * <pre>
     * What created the score.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
     * </code>
     *
     * @return The sourceType.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
        getSourceType() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType result =
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
              .forNumber(sourceType_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
              .UNRECOGNIZED
          : result;
    }

    public static final int SCORE_FIELD_NUMBER = 2;
    private double score_ = 0D;
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result.
     * </pre>
     *
     * <code>optional double score = 2;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }

    public static final int POTENTIAL_SCORE_FIELD_NUMBER = 3;
    private double potentialScore_ = 0D;
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return Whether the potentialScore field is set.
     */
    @java.lang.Override
    public boolean hasPotentialScore() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 3;</code>
     *
     * @return The potentialScore.
     */
    @java.lang.Override
    public double getPotentialScore() {
      return potentialScore_;
    }

    public static final int NORMALIZED_SCORE_FIELD_NUMBER = 4;
    private double normalizedScore_ = 0D;
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return Whether the normalizedScore field is set.
     */
    @java.lang.Override
    public boolean hasNormalizedScore() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * </pre>
     *
     * <code>optional double normalized_score = 4;</code>
     *
     * @return The normalizedScore.
     */
    @java.lang.Override
    public double getNormalizedScore() {
      return normalizedScore_;
    }

    public static final int QA_TAG_RESULTS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
        qaTagResults_;
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
        getQaTagResultsList() {
      return qaTagResults_;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
        getQaTagResultsOrBuilderList() {
      return qaTagResults_;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    @java.lang.Override
    public int getQaTagResultsCount() {
      return qaTagResults_.size();
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult getQaTagResults(
        int index) {
      return qaTagResults_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder
        getQaTagResultsOrBuilder(int index) {
      return qaTagResults_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceType_
          != com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
              .SOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, sourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeDouble(2, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeDouble(3, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeDouble(4, normalizedScore_);
      }
      for (int i = 0; i < qaTagResults_.size(); i++) {
        output.writeMessage(5, qaTagResults_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceType_
          != com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
              .SOURCE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, sourceType_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, score_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, potentialScore_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, normalizedScore_);
      }
      for (int i = 0; i < qaTagResults_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, qaTagResults_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource other =
          (com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource) obj;

      if (sourceType_ != other.sourceType_) return false;
      if (hasScore() != other.hasScore()) return false;
      if (hasScore()) {
        if (java.lang.Double.doubleToLongBits(getScore())
            != java.lang.Double.doubleToLongBits(other.getScore())) return false;
      }
      if (hasPotentialScore() != other.hasPotentialScore()) return false;
      if (hasPotentialScore()) {
        if (java.lang.Double.doubleToLongBits(getPotentialScore())
            != java.lang.Double.doubleToLongBits(other.getPotentialScore())) return false;
      }
      if (hasNormalizedScore() != other.hasNormalizedScore()) return false;
      if (hasNormalizedScore()) {
        if (java.lang.Double.doubleToLongBits(getNormalizedScore())
            != java.lang.Double.doubleToLongBits(other.getNormalizedScore())) return false;
      }
      if (!getQaTagResultsList().equals(other.getQaTagResultsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + sourceType_;
      if (hasScore()) {
        hash = (37 * hash) + SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getScore()));
      }
      if (hasPotentialScore()) {
        hash = (37 * hash) + POTENTIAL_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getPotentialScore()));
      }
      if (hasNormalizedScore()) {
        hash = (37 * hash) + NORMALIZED_SCORE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getNormalizedScore()));
      }
      if (getQaTagResultsCount() > 0) {
        hash = (37 * hash) + QA_TAG_RESULTS_FIELD_NUMBER;
        hash = (53 * hash) + getQaTagResultsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A scorecard result may have multiple sets of scores from varying sources,
     * one of which becomes the "main" answer above. A ScoreSource represents
     * each individual set of scores.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_ScoreSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_ScoreSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.class,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sourceType_ = 0;
        score_ = 0D;
        potentialScore_ = 0D;
        normalizedScore_ = 0D;
        if (qaTagResultsBuilder_ == null) {
          qaTagResults_ = java.util.Collections.emptyList();
        } else {
          qaTagResults_ = null;
          qaTagResultsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_ScoreSource_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource build() {
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource result =
            new com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource result) {
        if (qaTagResultsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            qaTagResults_ = java.util.Collections.unmodifiableList(qaTagResults_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.qaTagResults_ = qaTagResults_;
        } else {
          result.qaTagResults_ = qaTagResultsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sourceType_ = sourceType_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.score_ = score_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.potentialScore_ = potentialScore_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.normalizedScore_ = normalizedScore_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
                .getDefaultInstance()) return this;
        if (other.sourceType_ != 0) {
          setSourceTypeValue(other.getSourceTypeValue());
        }
        if (other.hasScore()) {
          setScore(other.getScore());
        }
        if (other.hasPotentialScore()) {
          setPotentialScore(other.getPotentialScore());
        }
        if (other.hasNormalizedScore()) {
          setNormalizedScore(other.getNormalizedScore());
        }
        if (qaTagResultsBuilder_ == null) {
          if (!other.qaTagResults_.isEmpty()) {
            if (qaTagResults_.isEmpty()) {
              qaTagResults_ = other.qaTagResults_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureQaTagResultsIsMutable();
              qaTagResults_.addAll(other.qaTagResults_);
            }
            onChanged();
          }
        } else {
          if (!other.qaTagResults_.isEmpty()) {
            if (qaTagResultsBuilder_.isEmpty()) {
              qaTagResultsBuilder_.dispose();
              qaTagResultsBuilder_ = null;
              qaTagResults_ = other.qaTagResults_;
              bitField0_ = (bitField0_ & ~0x00000010);
              qaTagResultsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getQaTagResultsFieldBuilder()
                      : null;
            } else {
              qaTagResultsBuilder_.addAllMessages(other.qaTagResults_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  sourceType_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 17:
                {
                  score_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              case 25:
                {
                  potentialScore_ = input.readDouble();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 25
              case 33:
                {
                  normalizedScore_ = input.readDouble();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 33
              case 42:
                {
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult m =
                      input.readMessage(
                          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                              .parser(),
                          extensionRegistry);
                  if (qaTagResultsBuilder_ == null) {
                    ensureQaTagResultsIsMutable();
                    qaTagResults_.add(m);
                  } else {
                    qaTagResultsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int sourceType_ = 0;
      /**
       *
       *
       * <pre>
       * What created the score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for sourceType.
       */
      @java.lang.Override
      public int getSourceTypeValue() {
        return sourceType_;
      }
      /**
       *
       *
       * <pre>
       * What created the score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for sourceType to set.
       * @return This builder for chaining.
       */
      public Builder setSourceTypeValue(int value) {
        sourceType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * What created the score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
       * </code>
       *
       * @return The sourceType.
       */
      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
          getSourceType() {
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType result =
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
                .forNumber(sourceType_);
        return result == null
            ? com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * What created the score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
       * </code>
       *
       * @param value The sourceType to set.
       * @return This builder for chaining.
       */
      public Builder setSourceType(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        sourceType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * What created the score.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.SourceType source_type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        sourceType_ = 0;
        onChanged();
        return this;
      }

      private double score_;
      /**
       *
       *
       * <pre>
       * The overall numerical score of the result.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return Whether the score field is set.
       */
      @java.lang.Override
      public boolean hasScore() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The overall numerical score of the result.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return The score.
       */
      @java.lang.Override
      public double getScore() {
        return score_;
      }
      /**
       *
       *
       * <pre>
       * The overall numerical score of the result.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @param value The score to set.
       * @return This builder for chaining.
       */
      public Builder setScore(double value) {

        score_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The overall numerical score of the result.
       * </pre>
       *
       * <code>optional double score = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScore() {
        bitField0_ = (bitField0_ & ~0x00000002);
        score_ = 0D;
        onChanged();
        return this;
      }

      private double potentialScore_;
      /**
       *
       *
       * <pre>
       * The maximum potential overall score of the scorecard. Any questions
       * answered using `na_value` are excluded from this calculation.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return Whether the potentialScore field is set.
       */
      @java.lang.Override
      public boolean hasPotentialScore() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The maximum potential overall score of the scorecard. Any questions
       * answered using `na_value` are excluded from this calculation.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return The potentialScore.
       */
      @java.lang.Override
      public double getPotentialScore() {
        return potentialScore_;
      }
      /**
       *
       *
       * <pre>
       * The maximum potential overall score of the scorecard. Any questions
       * answered using `na_value` are excluded from this calculation.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @param value The potentialScore to set.
       * @return This builder for chaining.
       */
      public Builder setPotentialScore(double value) {

        potentialScore_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum potential overall score of the scorecard. Any questions
       * answered using `na_value` are excluded from this calculation.
       * </pre>
       *
       * <code>optional double potential_score = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPotentialScore() {
        bitField0_ = (bitField0_ & ~0x00000004);
        potentialScore_ = 0D;
        onChanged();
        return this;
      }

      private double normalizedScore_;
      /**
       *
       *
       * <pre>
       * The normalized score, which is the score divided by the potential score.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return Whether the normalizedScore field is set.
       */
      @java.lang.Override
      public boolean hasNormalizedScore() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The normalized score, which is the score divided by the potential score.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return The normalizedScore.
       */
      @java.lang.Override
      public double getNormalizedScore() {
        return normalizedScore_;
      }
      /**
       *
       *
       * <pre>
       * The normalized score, which is the score divided by the potential score.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @param value The normalizedScore to set.
       * @return This builder for chaining.
       */
      public Builder setNormalizedScore(double value) {

        normalizedScore_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The normalized score, which is the score divided by the potential score.
       * </pre>
       *
       * <code>optional double normalized_score = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNormalizedScore() {
        bitField0_ = (bitField0_ & ~0x00000008);
        normalizedScore_ = 0D;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
          qaTagResults_ = java.util.Collections.emptyList();

      private void ensureQaTagResultsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          qaTagResults_ =
              new java.util.ArrayList<
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>(
                  qaTagResults_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
          qaTagResultsBuilder_;

      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
          getQaTagResultsList() {
        if (qaTagResultsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(qaTagResults_);
        } else {
          return qaTagResultsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public int getQaTagResultsCount() {
        if (qaTagResultsBuilder_ == null) {
          return qaTagResults_.size();
        } else {
          return qaTagResultsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
          getQaTagResults(int index) {
        if (qaTagResultsBuilder_ == null) {
          return qaTagResults_.get(index);
        } else {
          return qaTagResultsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder setQaTagResults(
          int index,
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
        if (qaTagResultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQaTagResultsIsMutable();
          qaTagResults_.set(index, value);
          onChanged();
        } else {
          qaTagResultsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder setQaTagResults(
          int index,
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
              builderForValue) {
        if (qaTagResultsBuilder_ == null) {
          ensureQaTagResultsIsMutable();
          qaTagResults_.set(index, builderForValue.build());
          onChanged();
        } else {
          qaTagResultsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder addQaTagResults(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
        if (qaTagResultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQaTagResultsIsMutable();
          qaTagResults_.add(value);
          onChanged();
        } else {
          qaTagResultsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder addQaTagResults(
          int index,
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
        if (qaTagResultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureQaTagResultsIsMutable();
          qaTagResults_.add(index, value);
          onChanged();
        } else {
          qaTagResultsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder addQaTagResults(
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
              builderForValue) {
        if (qaTagResultsBuilder_ == null) {
          ensureQaTagResultsIsMutable();
          qaTagResults_.add(builderForValue.build());
          onChanged();
        } else {
          qaTagResultsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder addQaTagResults(
          int index,
          com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
              builderForValue) {
        if (qaTagResultsBuilder_ == null) {
          ensureQaTagResultsIsMutable();
          qaTagResults_.add(index, builderForValue.build());
          onChanged();
        } else {
          qaTagResultsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder addAllQaTagResults(
          java.lang.Iterable<
                  ? extends com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
              values) {
        if (qaTagResultsBuilder_ == null) {
          ensureQaTagResultsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qaTagResults_);
          onChanged();
        } else {
          qaTagResultsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder clearQaTagResults() {
        if (qaTagResultsBuilder_ == null) {
          qaTagResults_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          qaTagResultsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public Builder removeQaTagResults(int index) {
        if (qaTagResultsBuilder_ == null) {
          ensureQaTagResultsIsMutable();
          qaTagResults_.remove(index);
          onChanged();
        } else {
          qaTagResultsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
          getQaTagResultsBuilder(int index) {
        return getQaTagResultsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder
          getQaTagResultsOrBuilder(int index) {
        if (qaTagResultsBuilder_ == null) {
          return qaTagResults_.get(index);
        } else {
          return qaTagResultsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
          getQaTagResultsOrBuilderList() {
        if (qaTagResultsBuilder_ != null) {
          return qaTagResultsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(qaTagResults_);
        }
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
          addQaTagResultsBuilder() {
        return getQaTagResultsFieldBuilder()
            .addBuilder(
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
          addQaTagResultsBuilder(int index) {
        return getQaTagResultsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Collection of tags and their scores.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 5;
       * </code>
       */
      public java.util.List<
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder>
          getQaTagResultsBuilderList() {
        return getQaTagResultsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
          getQaTagResultsFieldBuilder() {
        if (qaTagResultsBuilder_ == null) {
          qaTagResultsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
                  com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>(
                  qaTagResults_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          qaTagResults_ = null;
        }
        return qaTagResultsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource)
    private static final com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource();
    }

    public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ScoreSource> PARSER =
        new com.google.protobuf.AbstractParser<ScoreSource>() {
          @java.lang.Override
          public ScoreSource parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ScoreSource> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScoreSource> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. The name of the scorecard result.
   * Format:
   * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. The name of the scorecard result.
   * Format:
   * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QA_SCORECARD_REVISION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object qaScorecardRevision_ = "";
  /**
   *
   *
   * <pre>
   * The QaScorecardRevision scored by this result.
   * </pre>
   *
   * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The qaScorecardRevision.
   */
  @java.lang.Override
  public java.lang.String getQaScorecardRevision() {
    java.lang.Object ref = qaScorecardRevision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      qaScorecardRevision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The QaScorecardRevision scored by this result.
   * </pre>
   *
   * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for qaScorecardRevision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQaScorecardRevisionBytes() {
    java.lang.Object ref = qaScorecardRevision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      qaScorecardRevision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object conversation_ = "";
  /**
   *
   *
   * <pre>
   * The conversation scored by this result.
   * </pre>
   *
   * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The conversation.
   */
  @java.lang.Override
  public java.lang.String getConversation() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      conversation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The conversation scored by this result.
   * </pre>
   *
   * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for conversation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getConversationBytes() {
    java.lang.Object ref = conversation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      conversation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp that the revision was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int AGENT_ID_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agentId_ = "";
  /**
   *
   *
   * <pre>
   * ID of the agent that handled the conversation.
   * </pre>
   *
   * <code>string agent_id = 5;</code>
   *
   * @return The agentId.
   */
  @java.lang.Override
  public java.lang.String getAgentId() {
    java.lang.Object ref = agentId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * ID of the agent that handled the conversation.
   * </pre>
   *
   * <code>string agent_id = 5;</code>
   *
   * @return The bytes for agentId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentIdBytes() {
    java.lang.Object ref = agentId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QA_ANSWERS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer> qaAnswers_;
  /**
   *
   *
   * <pre>
   * Set of QaAnswers represented in the result.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer> getQaAnswersList() {
    return qaAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Set of QaAnswers represented in the result.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder>
      getQaAnswersOrBuilderList() {
    return qaAnswers_;
  }
  /**
   *
   *
   * <pre>
   * Set of QaAnswers represented in the result.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
   */
  @java.lang.Override
  public int getQaAnswersCount() {
    return qaAnswers_.size();
  }
  /**
   *
   *
   * <pre>
   * Set of QaAnswers represented in the result.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswer getQaAnswers(int index) {
    return qaAnswers_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Set of QaAnswers represented in the result.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder getQaAnswersOrBuilder(
      int index) {
    return qaAnswers_.get(index);
  }

  public static final int SCORE_FIELD_NUMBER = 7;
  private double score_ = 0D;
  /**
   *
   *
   * <pre>
   * The overall numerical score of the result, incorporating any manual edits
   * if they exist.
   * </pre>
   *
   * <code>optional double score = 7;</code>
   *
   * @return Whether the score field is set.
   */
  @java.lang.Override
  public boolean hasScore() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The overall numerical score of the result, incorporating any manual edits
   * if they exist.
   * </pre>
   *
   * <code>optional double score = 7;</code>
   *
   * @return The score.
   */
  @java.lang.Override
  public double getScore() {
    return score_;
  }

  public static final int POTENTIAL_SCORE_FIELD_NUMBER = 8;
  private double potentialScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The maximum potential overall score of the scorecard. Any questions
   * answered using `na_value` are excluded from this calculation.
   * </pre>
   *
   * <code>optional double potential_score = 8;</code>
   *
   * @return Whether the potentialScore field is set.
   */
  @java.lang.Override
  public boolean hasPotentialScore() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum potential overall score of the scorecard. Any questions
   * answered using `na_value` are excluded from this calculation.
   * </pre>
   *
   * <code>optional double potential_score = 8;</code>
   *
   * @return The potentialScore.
   */
  @java.lang.Override
  public double getPotentialScore() {
    return potentialScore_;
  }

  public static final int NORMALIZED_SCORE_FIELD_NUMBER = 9;
  private double normalizedScore_ = 0D;
  /**
   *
   *
   * <pre>
   * The normalized score, which is the score divided by the potential score.
   * Any manual edits are included if they exist.
   * </pre>
   *
   * <code>optional double normalized_score = 9;</code>
   *
   * @return Whether the normalizedScore field is set.
   */
  @java.lang.Override
  public boolean hasNormalizedScore() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The normalized score, which is the score divided by the potential score.
   * Any manual edits are included if they exist.
   * </pre>
   *
   * <code>optional double normalized_score = 9;</code>
   *
   * @return The normalizedScore.
   */
  @java.lang.Override
  public double getNormalizedScore() {
    return normalizedScore_;
  }

  public static final int QA_TAG_RESULTS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
      qaTagResults_;
  /**
   *
   *
   * <pre>
   * Collection of tags and their scores.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
      getQaTagResultsList() {
    return qaTagResults_;
  }
  /**
   *
   *
   * <pre>
   * Collection of tags and their scores.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
      getQaTagResultsOrBuilderList() {
    return qaTagResults_;
  }
  /**
   *
   *
   * <pre>
   * Collection of tags and their scores.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
   * </code>
   */
  @java.lang.Override
  public int getQaTagResultsCount() {
    return qaTagResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Collection of tags and their scores.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult getQaTagResults(
      int index) {
    return qaTagResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Collection of tags and their scores.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder
      getQaTagResultsOrBuilder(int index) {
    return qaTagResults_.get(index);
  }

  public static final int SCORE_SOURCES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>
      scoreSources_;
  /**
   *
   *
   * <pre>
   * List of all individual score sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>
      getScoreSourcesList() {
    return scoreSources_;
  }
  /**
   *
   *
   * <pre>
   * List of all individual score sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder>
      getScoreSourcesOrBuilderList() {
    return scoreSources_;
  }
  /**
   *
   *
   * <pre>
   * List of all individual score sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
   * </code>
   */
  @java.lang.Override
  public int getScoreSourcesCount() {
    return scoreSources_.size();
  }
  /**
   *
   *
   * <pre>
   * List of all individual score sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource getScoreSources(
      int index) {
    return scoreSources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of all individual score sets.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder
      getScoreSourcesOrBuilder(int index) {
    return scoreSources_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardRevision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, qaScorecardRevision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, conversation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, agentId_);
    }
    for (int i = 0; i < qaAnswers_.size(); i++) {
      output.writeMessage(6, qaAnswers_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeDouble(7, score_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeDouble(8, potentialScore_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeDouble(9, normalizedScore_);
    }
    for (int i = 0; i < qaTagResults_.size(); i++) {
      output.writeMessage(10, qaTagResults_.get(i));
    }
    for (int i = 0; i < scoreSources_.size(); i++) {
      output.writeMessage(11, scoreSources_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qaScorecardRevision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, qaScorecardRevision_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(conversation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, conversation_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, agentId_);
    }
    for (int i = 0; i < qaAnswers_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, qaAnswers_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(7, score_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(8, potentialScore_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(9, normalizedScore_);
    }
    for (int i = 0; i < qaTagResults_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, qaTagResults_.get(i));
    }
    for (int i = 0; i < scoreSources_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, scoreSources_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QaScorecardResult other =
        (com.google.cloud.contactcenterinsights.v1.QaScorecardResult) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getQaScorecardRevision().equals(other.getQaScorecardRevision())) return false;
    if (!getConversation().equals(other.getConversation())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getAgentId().equals(other.getAgentId())) return false;
    if (!getQaAnswersList().equals(other.getQaAnswersList())) return false;
    if (hasScore() != other.hasScore()) return false;
    if (hasScore()) {
      if (java.lang.Double.doubleToLongBits(getScore())
          != java.lang.Double.doubleToLongBits(other.getScore())) return false;
    }
    if (hasPotentialScore() != other.hasPotentialScore()) return false;
    if (hasPotentialScore()) {
      if (java.lang.Double.doubleToLongBits(getPotentialScore())
          != java.lang.Double.doubleToLongBits(other.getPotentialScore())) return false;
    }
    if (hasNormalizedScore() != other.hasNormalizedScore()) return false;
    if (hasNormalizedScore()) {
      if (java.lang.Double.doubleToLongBits(getNormalizedScore())
          != java.lang.Double.doubleToLongBits(other.getNormalizedScore())) return false;
    }
    if (!getQaTagResultsList().equals(other.getQaTagResultsList())) return false;
    if (!getScoreSourcesList().equals(other.getScoreSourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + QA_SCORECARD_REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getQaScorecardRevision().hashCode();
    hash = (37 * hash) + CONVERSATION_FIELD_NUMBER;
    hash = (53 * hash) + getConversation().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + AGENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAgentId().hashCode();
    if (getQaAnswersCount() > 0) {
      hash = (37 * hash) + QA_ANSWERS_FIELD_NUMBER;
      hash = (53 * hash) + getQaAnswersList().hashCode();
    }
    if (hasScore()) {
      hash = (37 * hash) + SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getScore()));
    }
    if (hasPotentialScore()) {
      hash = (37 * hash) + POTENTIAL_SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getPotentialScore()));
    }
    if (hasNormalizedScore()) {
      hash = (37 * hash) + NORMALIZED_SCORE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getNormalizedScore()));
    }
    if (getQaTagResultsCount() > 0) {
      hash = (37 * hash) + QA_TAG_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getQaTagResultsList().hashCode();
    }
    if (getScoreSourcesCount() > 0) {
      hash = (37 * hash) + SCORE_SOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getScoreSourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The results of scoring a single conversation against a QaScorecard. Contains
   * a collection of QaAnswers and aggregate score.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QaScorecardResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QaScorecardResult)
      com.google.cloud.contactcenterinsights.v1.QaScorecardResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.class,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QaScorecardResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getQaAnswersFieldBuilder();
        getQaTagResultsFieldBuilder();
        getScoreSourcesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      qaScorecardRevision_ = "";
      conversation_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      agentId_ = "";
      if (qaAnswersBuilder_ == null) {
        qaAnswers_ = java.util.Collections.emptyList();
      } else {
        qaAnswers_ = null;
        qaAnswersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      score_ = 0D;
      potentialScore_ = 0D;
      normalizedScore_ = 0D;
      if (qaTagResultsBuilder_ == null) {
        qaTagResults_ = java.util.Collections.emptyList();
      } else {
        qaTagResults_ = null;
        qaTagResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      if (scoreSourcesBuilder_ == null) {
        scoreSources_ = java.util.Collections.emptyList();
      } else {
        scoreSources_ = null;
        scoreSourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_QaScorecardResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QaScorecardResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult build() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QaScorecardResult result =
          new com.google.cloud.contactcenterinsights.v1.QaScorecardResult(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult result) {
      if (qaAnswersBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          qaAnswers_ = java.util.Collections.unmodifiableList(qaAnswers_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.qaAnswers_ = qaAnswers_;
      } else {
        result.qaAnswers_ = qaAnswersBuilder_.build();
      }
      if (qaTagResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          qaTagResults_ = java.util.Collections.unmodifiableList(qaTagResults_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.qaTagResults_ = qaTagResults_;
      } else {
        result.qaTagResults_ = qaTagResultsBuilder_.build();
      }
      if (scoreSourcesBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          scoreSources_ = java.util.Collections.unmodifiableList(scoreSources_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.scoreSources_ = scoreSources_;
      } else {
        result.scoreSources_ = scoreSourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.QaScorecardResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.qaScorecardRevision_ = qaScorecardRevision_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.conversation_ = conversation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.agentId_ = agentId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.score_ = score_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.potentialScore_ = potentialScore_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.normalizedScore_ = normalizedScore_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QaScorecardResult) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QaScorecardResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QaScorecardResult other) {
      if (other == com.google.cloud.contactcenterinsights.v1.QaScorecardResult.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQaScorecardRevision().isEmpty()) {
        qaScorecardRevision_ = other.qaScorecardRevision_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getConversation().isEmpty()) {
        conversation_ = other.conversation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getAgentId().isEmpty()) {
        agentId_ = other.agentId_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (qaAnswersBuilder_ == null) {
        if (!other.qaAnswers_.isEmpty()) {
          if (qaAnswers_.isEmpty()) {
            qaAnswers_ = other.qaAnswers_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureQaAnswersIsMutable();
            qaAnswers_.addAll(other.qaAnswers_);
          }
          onChanged();
        }
      } else {
        if (!other.qaAnswers_.isEmpty()) {
          if (qaAnswersBuilder_.isEmpty()) {
            qaAnswersBuilder_.dispose();
            qaAnswersBuilder_ = null;
            qaAnswers_ = other.qaAnswers_;
            bitField0_ = (bitField0_ & ~0x00000020);
            qaAnswersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQaAnswersFieldBuilder()
                    : null;
          } else {
            qaAnswersBuilder_.addAllMessages(other.qaAnswers_);
          }
        }
      }
      if (other.hasScore()) {
        setScore(other.getScore());
      }
      if (other.hasPotentialScore()) {
        setPotentialScore(other.getPotentialScore());
      }
      if (other.hasNormalizedScore()) {
        setNormalizedScore(other.getNormalizedScore());
      }
      if (qaTagResultsBuilder_ == null) {
        if (!other.qaTagResults_.isEmpty()) {
          if (qaTagResults_.isEmpty()) {
            qaTagResults_ = other.qaTagResults_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureQaTagResultsIsMutable();
            qaTagResults_.addAll(other.qaTagResults_);
          }
          onChanged();
        }
      } else {
        if (!other.qaTagResults_.isEmpty()) {
          if (qaTagResultsBuilder_.isEmpty()) {
            qaTagResultsBuilder_.dispose();
            qaTagResultsBuilder_ = null;
            qaTagResults_ = other.qaTagResults_;
            bitField0_ = (bitField0_ & ~0x00000200);
            qaTagResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQaTagResultsFieldBuilder()
                    : null;
          } else {
            qaTagResultsBuilder_.addAllMessages(other.qaTagResults_);
          }
        }
      }
      if (scoreSourcesBuilder_ == null) {
        if (!other.scoreSources_.isEmpty()) {
          if (scoreSources_.isEmpty()) {
            scoreSources_ = other.scoreSources_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureScoreSourcesIsMutable();
            scoreSources_.addAll(other.scoreSources_);
          }
          onChanged();
        }
      } else {
        if (!other.scoreSources_.isEmpty()) {
          if (scoreSourcesBuilder_.isEmpty()) {
            scoreSourcesBuilder_.dispose();
            scoreSourcesBuilder_ = null;
            scoreSources_ = other.scoreSources_;
            bitField0_ = (bitField0_ & ~0x00000400);
            scoreSourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getScoreSourcesFieldBuilder()
                    : null;
          } else {
            scoreSourcesBuilder_.addAllMessages(other.scoreSources_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                qaScorecardRevision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                conversation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                agentId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.contactcenterinsights.v1.QaAnswer m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QaAnswer.parser(),
                        extensionRegistry);
                if (qaAnswersBuilder_ == null) {
                  ensureQaAnswersIsMutable();
                  qaAnswers_.add(m);
                } else {
                  qaAnswersBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 57:
              {
                score_ = input.readDouble();
                bitField0_ |= 0x00000040;
                break;
              } // case 57
            case 65:
              {
                potentialScore_ = input.readDouble();
                bitField0_ |= 0x00000080;
                break;
              } // case 65
            case 73:
              {
                normalizedScore_ = input.readDouble();
                bitField0_ |= 0x00000100;
                break;
              } // case 73
            case 82:
              {
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                            .parser(),
                        extensionRegistry);
                if (qaTagResultsBuilder_ == null) {
                  ensureQaTagResultsIsMutable();
                  qaTagResults_.add(m);
                } else {
                  qaTagResultsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
                            .parser(),
                        extensionRegistry);
                if (scoreSourcesBuilder_ == null) {
                  ensureScoreSourcesIsMutable();
                  scoreSources_.add(m);
                } else {
                  scoreSourcesBuilder_.addMessage(m);
                }
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard result.
     * Format:
     * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard result.
     * Format:
     * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard result.
     * Format:
     * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard result.
     * Format:
     * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. The name of the scorecard result.
     * Format:
     * projects/{project}/locations/{location}/qaScorecardResults/{qa_scorecard_result}
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object qaScorecardRevision_ = "";
    /**
     *
     *
     * <pre>
     * The QaScorecardRevision scored by this result.
     * </pre>
     *
     * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The qaScorecardRevision.
     */
    public java.lang.String getQaScorecardRevision() {
      java.lang.Object ref = qaScorecardRevision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qaScorecardRevision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The QaScorecardRevision scored by this result.
     * </pre>
     *
     * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for qaScorecardRevision.
     */
    public com.google.protobuf.ByteString getQaScorecardRevisionBytes() {
      java.lang.Object ref = qaScorecardRevision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qaScorecardRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The QaScorecardRevision scored by this result.
     * </pre>
     *
     * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The qaScorecardRevision to set.
     * @return This builder for chaining.
     */
    public Builder setQaScorecardRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      qaScorecardRevision_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The QaScorecardRevision scored by this result.
     * </pre>
     *
     * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQaScorecardRevision() {
      qaScorecardRevision_ = getDefaultInstance().getQaScorecardRevision();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The QaScorecardRevision scored by this result.
     * </pre>
     *
     * <code>string qa_scorecard_revision = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for qaScorecardRevision to set.
     * @return This builder for chaining.
     */
    public Builder setQaScorecardRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      qaScorecardRevision_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object conversation_ = "";
    /**
     *
     *
     * <pre>
     * The conversation scored by this result.
     * </pre>
     *
     * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The conversation.
     */
    public java.lang.String getConversation() {
      java.lang.Object ref = conversation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        conversation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation scored by this result.
     * </pre>
     *
     * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for conversation.
     */
    public com.google.protobuf.ByteString getConversationBytes() {
      java.lang.Object ref = conversation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        conversation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The conversation scored by this result.
     * </pre>
     *
     * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      conversation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation scored by this result.
     * </pre>
     *
     * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConversation() {
      conversation_ = getDefaultInstance().getConversation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The conversation scored by this result.
     * </pre>
     *
     * <code>string conversation = 3 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for conversation to set.
     * @return This builder for chaining.
     */
    public Builder setConversationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      conversation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp that the revision was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.lang.Object agentId_ = "";
    /**
     *
     *
     * <pre>
     * ID of the agent that handled the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return The agentId.
     */
    public java.lang.String getAgentId() {
      java.lang.Object ref = agentId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the agent that handled the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return The bytes for agentId.
     */
    public com.google.protobuf.ByteString getAgentIdBytes() {
      java.lang.Object ref = agentId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * ID of the agent that handled the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @param value The agentId to set.
     * @return This builder for chaining.
     */
    public Builder setAgentId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the agent that handled the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentId() {
      agentId_ = getDefaultInstance().getAgentId();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ID of the agent that handled the conversation.
     * </pre>
     *
     * <code>string agent_id = 5;</code>
     *
     * @param value The bytes for agentId to set.
     * @return This builder for chaining.
     */
    public Builder setAgentIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentId_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer> qaAnswers_ =
        java.util.Collections.emptyList();

    private void ensureQaAnswersIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        qaAnswers_ =
            new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.QaAnswer>(qaAnswers_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder>
        qaAnswersBuilder_;

    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer> getQaAnswersList() {
      if (qaAnswersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(qaAnswers_);
      } else {
        return qaAnswersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public int getQaAnswersCount() {
      if (qaAnswersBuilder_ == null) {
        return qaAnswers_.size();
      } else {
        return qaAnswersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer getQaAnswers(int index) {
      if (qaAnswersBuilder_ == null) {
        return qaAnswers_.get(index);
      } else {
        return qaAnswersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder setQaAnswers(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer value) {
      if (qaAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaAnswersIsMutable();
        qaAnswers_.set(index, value);
        onChanged();
      } else {
        qaAnswersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder setQaAnswers(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder builderForValue) {
      if (qaAnswersBuilder_ == null) {
        ensureQaAnswersIsMutable();
        qaAnswers_.set(index, builderForValue.build());
        onChanged();
      } else {
        qaAnswersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder addQaAnswers(com.google.cloud.contactcenterinsights.v1.QaAnswer value) {
      if (qaAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaAnswersIsMutable();
        qaAnswers_.add(value);
        onChanged();
      } else {
        qaAnswersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder addQaAnswers(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer value) {
      if (qaAnswersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaAnswersIsMutable();
        qaAnswers_.add(index, value);
        onChanged();
      } else {
        qaAnswersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder addQaAnswers(
        com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder builderForValue) {
      if (qaAnswersBuilder_ == null) {
        ensureQaAnswersIsMutable();
        qaAnswers_.add(builderForValue.build());
        onChanged();
      } else {
        qaAnswersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder addQaAnswers(
        int index, com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder builderForValue) {
      if (qaAnswersBuilder_ == null) {
        ensureQaAnswersIsMutable();
        qaAnswers_.add(index, builderForValue.build());
        onChanged();
      } else {
        qaAnswersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder addAllQaAnswers(
        java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.QaAnswer> values) {
      if (qaAnswersBuilder_ == null) {
        ensureQaAnswersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qaAnswers_);
        onChanged();
      } else {
        qaAnswersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder clearQaAnswers() {
      if (qaAnswersBuilder_ == null) {
        qaAnswers_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        qaAnswersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public Builder removeQaAnswers(int index) {
      if (qaAnswersBuilder_ == null) {
        ensureQaAnswersIsMutable();
        qaAnswers_.remove(index);
        onChanged();
      } else {
        qaAnswersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder getQaAnswersBuilder(
        int index) {
      return getQaAnswersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder getQaAnswersOrBuilder(
        int index) {
      if (qaAnswersBuilder_ == null) {
        return qaAnswers_.get(index);
      } else {
        return qaAnswersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder>
        getQaAnswersOrBuilderList() {
      if (qaAnswersBuilder_ != null) {
        return qaAnswersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(qaAnswers_);
      }
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder addQaAnswersBuilder() {
      return getQaAnswersFieldBuilder()
          .addBuilder(com.google.cloud.contactcenterinsights.v1.QaAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder addQaAnswersBuilder(
        int index) {
      return getQaAnswersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.contactcenterinsights.v1.QaAnswer.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Set of QaAnswers represented in the result.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.QaAnswer qa_answers = 6;</code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder>
        getQaAnswersBuilderList() {
      return getQaAnswersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaAnswer,
            com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder,
            com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder>
        getQaAnswersFieldBuilder() {
      if (qaAnswersBuilder_ == null) {
        qaAnswersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaAnswer,
                com.google.cloud.contactcenterinsights.v1.QaAnswer.Builder,
                com.google.cloud.contactcenterinsights.v1.QaAnswerOrBuilder>(
                qaAnswers_, ((bitField0_ & 0x00000020) != 0), getParentForChildren(), isClean());
        qaAnswers_ = null;
      }
      return qaAnswersBuilder_;
    }

    private double score_;
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result, incorporating any manual edits
     * if they exist.
     * </pre>
     *
     * <code>optional double score = 7;</code>
     *
     * @return Whether the score field is set.
     */
    @java.lang.Override
    public boolean hasScore() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result, incorporating any manual edits
     * if they exist.
     * </pre>
     *
     * <code>optional double score = 7;</code>
     *
     * @return The score.
     */
    @java.lang.Override
    public double getScore() {
      return score_;
    }
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result, incorporating any manual edits
     * if they exist.
     * </pre>
     *
     * <code>optional double score = 7;</code>
     *
     * @param value The score to set.
     * @return This builder for chaining.
     */
    public Builder setScore(double value) {

      score_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The overall numerical score of the result, incorporating any manual edits
     * if they exist.
     * </pre>
     *
     * <code>optional double score = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScore() {
      bitField0_ = (bitField0_ & ~0x00000040);
      score_ = 0D;
      onChanged();
      return this;
    }

    private double potentialScore_;
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 8;</code>
     *
     * @return Whether the potentialScore field is set.
     */
    @java.lang.Override
    public boolean hasPotentialScore() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 8;</code>
     *
     * @return The potentialScore.
     */
    @java.lang.Override
    public double getPotentialScore() {
      return potentialScore_;
    }
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 8;</code>
     *
     * @param value The potentialScore to set.
     * @return This builder for chaining.
     */
    public Builder setPotentialScore(double value) {

      potentialScore_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum potential overall score of the scorecard. Any questions
     * answered using `na_value` are excluded from this calculation.
     * </pre>
     *
     * <code>optional double potential_score = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPotentialScore() {
      bitField0_ = (bitField0_ & ~0x00000080);
      potentialScore_ = 0D;
      onChanged();
      return this;
    }

    private double normalizedScore_;
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * Any manual edits are included if they exist.
     * </pre>
     *
     * <code>optional double normalized_score = 9;</code>
     *
     * @return Whether the normalizedScore field is set.
     */
    @java.lang.Override
    public boolean hasNormalizedScore() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * Any manual edits are included if they exist.
     * </pre>
     *
     * <code>optional double normalized_score = 9;</code>
     *
     * @return The normalizedScore.
     */
    @java.lang.Override
    public double getNormalizedScore() {
      return normalizedScore_;
    }
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * Any manual edits are included if they exist.
     * </pre>
     *
     * <code>optional double normalized_score = 9;</code>
     *
     * @param value The normalizedScore to set.
     * @return This builder for chaining.
     */
    public Builder setNormalizedScore(double value) {

      normalizedScore_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The normalized score, which is the score divided by the potential score.
     * Any manual edits are included if they exist.
     * </pre>
     *
     * <code>optional double normalized_score = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNormalizedScore() {
      bitField0_ = (bitField0_ & ~0x00000100);
      normalizedScore_ = 0D;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
        qaTagResults_ = java.util.Collections.emptyList();

    private void ensureQaTagResultsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        qaTagResults_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>(
                qaTagResults_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
        qaTagResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
        getQaTagResultsList() {
      if (qaTagResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(qaTagResults_);
      } else {
        return qaTagResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public int getQaTagResultsCount() {
      if (qaTagResultsBuilder_ == null) {
        return qaTagResults_.size();
      } else {
        return qaTagResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult getQaTagResults(
        int index) {
      if (qaTagResultsBuilder_ == null) {
        return qaTagResults_.get(index);
      } else {
        return qaTagResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder setQaTagResults(
        int index, com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
      if (qaTagResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaTagResultsIsMutable();
        qaTagResults_.set(index, value);
        onChanged();
      } else {
        qaTagResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder setQaTagResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
            builderForValue) {
      if (qaTagResultsBuilder_ == null) {
        ensureQaTagResultsIsMutable();
        qaTagResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        qaTagResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder addQaTagResults(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
      if (qaTagResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaTagResultsIsMutable();
        qaTagResults_.add(value);
        onChanged();
      } else {
        qaTagResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder addQaTagResults(
        int index, com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult value) {
      if (qaTagResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaTagResultsIsMutable();
        qaTagResults_.add(index, value);
        onChanged();
      } else {
        qaTagResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder addQaTagResults(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
            builderForValue) {
      if (qaTagResultsBuilder_ == null) {
        ensureQaTagResultsIsMutable();
        qaTagResults_.add(builderForValue.build());
        onChanged();
      } else {
        qaTagResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder addQaTagResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
            builderForValue) {
      if (qaTagResultsBuilder_ == null) {
        ensureQaTagResultsIsMutable();
        qaTagResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        qaTagResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder addAllQaTagResults(
        java.lang.Iterable<
                ? extends com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult>
            values) {
      if (qaTagResultsBuilder_ == null) {
        ensureQaTagResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, qaTagResults_);
        onChanged();
      } else {
        qaTagResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder clearQaTagResults() {
      if (qaTagResultsBuilder_ == null) {
        qaTagResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        qaTagResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public Builder removeQaTagResults(int index) {
      if (qaTagResultsBuilder_ == null) {
        ensureQaTagResultsIsMutable();
        qaTagResults_.remove(index);
        onChanged();
      } else {
        qaTagResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
        getQaTagResultsBuilder(int index) {
      return getQaTagResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder
        getQaTagResultsOrBuilder(int index) {
      if (qaTagResultsBuilder_ == null) {
        return qaTagResults_.get(index);
      } else {
        return qaTagResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
        getQaTagResultsOrBuilderList() {
      if (qaTagResultsBuilder_ != null) {
        return qaTagResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(qaTagResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
        addQaTagResultsBuilder() {
      return getQaTagResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder
        addQaTagResultsBuilder(int index) {
      return getQaTagResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Collection of tags and their scores.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult qa_tag_results = 10;
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder>
        getQaTagResultsBuilderList() {
      return getQaTagResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>
        getQaTagResultsFieldBuilder() {
      if (qaTagResultsBuilder_ == null) {
        qaTagResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResult.Builder,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.QaTagResultOrBuilder>(
                qaTagResults_, ((bitField0_ & 0x00000200) != 0), getParentForChildren(), isClean());
        qaTagResults_ = null;
      }
      return qaTagResultsBuilder_;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>
        scoreSources_ = java.util.Collections.emptyList();

    private void ensureScoreSourcesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        scoreSources_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>(
                scoreSources_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder>
        scoreSourcesBuilder_;

    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>
        getScoreSourcesList() {
      if (scoreSourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(scoreSources_);
      } else {
        return scoreSourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public int getScoreSourcesCount() {
      if (scoreSourcesBuilder_ == null) {
        return scoreSources_.size();
      } else {
        return scoreSourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource getScoreSources(
        int index) {
      if (scoreSourcesBuilder_ == null) {
        return scoreSources_.get(index);
      } else {
        return scoreSourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder setScoreSources(
        int index, com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource value) {
      if (scoreSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreSourcesIsMutable();
        scoreSources_.set(index, value);
        onChanged();
      } else {
        scoreSourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder setScoreSources(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
            builderForValue) {
      if (scoreSourcesBuilder_ == null) {
        ensureScoreSourcesIsMutable();
        scoreSources_.set(index, builderForValue.build());
        onChanged();
      } else {
        scoreSourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder addScoreSources(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource value) {
      if (scoreSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreSourcesIsMutable();
        scoreSources_.add(value);
        onChanged();
      } else {
        scoreSourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder addScoreSources(
        int index, com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource value) {
      if (scoreSourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureScoreSourcesIsMutable();
        scoreSources_.add(index, value);
        onChanged();
      } else {
        scoreSourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder addScoreSources(
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
            builderForValue) {
      if (scoreSourcesBuilder_ == null) {
        ensureScoreSourcesIsMutable();
        scoreSources_.add(builderForValue.build());
        onChanged();
      } else {
        scoreSourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder addScoreSources(
        int index,
        com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
            builderForValue) {
      if (scoreSourcesBuilder_ == null) {
        ensureScoreSourcesIsMutable();
        scoreSources_.add(index, builderForValue.build());
        onChanged();
      } else {
        scoreSourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder addAllScoreSources(
        java.lang.Iterable<
                ? extends com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource>
            values) {
      if (scoreSourcesBuilder_ == null) {
        ensureScoreSourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, scoreSources_);
        onChanged();
      } else {
        scoreSourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder clearScoreSources() {
      if (scoreSourcesBuilder_ == null) {
        scoreSources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        scoreSourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public Builder removeScoreSources(int index) {
      if (scoreSourcesBuilder_ == null) {
        ensureScoreSourcesIsMutable();
        scoreSources_.remove(index);
        onChanged();
      } else {
        scoreSourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
        getScoreSourcesBuilder(int index) {
      return getScoreSourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder
        getScoreSourcesOrBuilder(int index) {
      if (scoreSourcesBuilder_ == null) {
        return scoreSources_.get(index);
      } else {
        return scoreSourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder>
        getScoreSourcesOrBuilderList() {
      if (scoreSourcesBuilder_ != null) {
        return scoreSourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(scoreSources_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
        addScoreSourcesBuilder() {
      return getScoreSourcesFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder
        addScoreSourcesBuilder(int index) {
      return getScoreSourcesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of all individual score sets.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource score_sources = 11;
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder>
        getScoreSourcesBuilderList() {
      return getScoreSourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder,
            com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder>
        getScoreSourcesFieldBuilder() {
      if (scoreSourcesBuilder_ == null) {
        scoreSourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSource.Builder,
                com.google.cloud.contactcenterinsights.v1.QaScorecardResult.ScoreSourceOrBuilder>(
                scoreSources_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        scoreSources_ = null;
      }
      return scoreSourcesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QaScorecardResult)
  private static final com.google.cloud.contactcenterinsights.v1.QaScorecardResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QaScorecardResult();
  }

  public static com.google.cloud.contactcenterinsights.v1.QaScorecardResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QaScorecardResult> PARSER =
      new com.google.protobuf.AbstractParser<QaScorecardResult>() {
        @java.lang.Override
        public QaScorecardResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QaScorecardResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QaScorecardResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QaScorecardResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
