/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The request for querying metrics.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsRequest}
 */
public final class QueryMetricsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.QueryMetricsRequest)
    QueryMetricsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryMetricsRequest.newBuilder() to construct.
  private QueryMetricsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryMetricsRequest() {
    location_ = "";
    filter_ = "";
    timeGranularity_ = 0;
    dimensions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryMetricsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.class,
            com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A time granularity divides the time line into discrete time periods.
   * This is useful for defining buckets over which filtering and aggregation
   * should be performed.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity}
   */
  public enum TimeGranularity implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The time granularity is unspecified and will default to NONE.
     * </pre>
     *
     * <code>TIME_GRANULARITY_UNSPECIFIED = 0;</code>
     */
    TIME_GRANULARITY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * No time granularity. The response won't contain a time series.
     * This is the default value if no time granularity is specified.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    NONE(1),
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * 1 day means [midnight to midnight).
     * </pre>
     *
     * <code>DAILY = 2;</code>
     */
    DAILY(2),
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * 1 HOUR means [01:00 to 02:00).
     * </pre>
     *
     * <code>HOURLY = 3;</code>
     */
    HOURLY(3),
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * PER_MINUTE means [01:00 to 01:01).
     * </pre>
     *
     * <code>PER_MINUTE = 4;</code>
     */
    PER_MINUTE(4),
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a 1 minute  granularity.
     * PER_5_MINUTES means [01:00 to 01:05).
     * </pre>
     *
     * <code>PER_5_MINUTES = 5;</code>
     */
    PER_5_MINUTES(5),
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a monthly granularity.
     * 1 MONTH means [01st of the month to 1st of the next month).
     * </pre>
     *
     * <code>MONTHLY = 6;</code>
     */
    MONTHLY(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The time granularity is unspecified and will default to NONE.
     * </pre>
     *
     * <code>TIME_GRANULARITY_UNSPECIFIED = 0;</code>
     */
    public static final int TIME_GRANULARITY_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * No time granularity. The response won't contain a time series.
     * This is the default value if no time granularity is specified.
     * </pre>
     *
     * <code>NONE = 1;</code>
     */
    public static final int NONE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * 1 day means [midnight to midnight).
     * </pre>
     *
     * <code>DAILY = 2;</code>
     */
    public static final int DAILY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * 1 HOUR means [01:00 to 02:00).
     * </pre>
     *
     * <code>HOURLY = 3;</code>
     */
    public static final int HOURLY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a daily granularity.
     * PER_MINUTE means [01:00 to 01:01).
     * </pre>
     *
     * <code>PER_MINUTE = 4;</code>
     */
    public static final int PER_MINUTE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a 1 minute  granularity.
     * PER_5_MINUTES means [01:00 to 01:05).
     * </pre>
     *
     * <code>PER_5_MINUTES = 5;</code>
     */
    public static final int PER_5_MINUTES_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Data points in the time series will aggregate at a monthly granularity.
     * 1 MONTH means [01st of the month to 1st of the next month).
     * </pre>
     *
     * <code>MONTHLY = 6;</code>
     */
    public static final int MONTHLY_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimeGranularity valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TimeGranularity forNumber(int value) {
      switch (value) {
        case 0:
          return TIME_GRANULARITY_UNSPECIFIED;
        case 1:
          return NONE;
        case 2:
          return DAILY;
        case 3:
          return HOURLY;
        case 4:
          return PER_MINUTE;
        case 5:
          return PER_5_MINUTES;
        case 6:
          return MONTHLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TimeGranularity> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TimeGranularity>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TimeGranularity>() {
              public TimeGranularity findValueByNumber(int number) {
                return TimeGranularity.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TimeGranularity[] VALUES = values();

    public static TimeGranularity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TimeGranularity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity)
  }

  private int bitField0_;
  public static final int LOCATION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * Required. The location of the data.
   * "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The location of the data.
   * "projects/{project}/locations/{location}"
   * </pre>
   *
   * <code>
   * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILTER_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";
  /**
   *
   *
   * <pre>
   * Required. Filter to select a subset of conversations to compute the
   * metrics. Must specify a window of the conversation create time to compute
   * the metrics. The returned metrics will be from the range [DATE(starting
   * create time), DATE(ending create time)).
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Filter to select a subset of conversations to compute the
   * metrics. Must specify a window of the conversation create time to compute
   * the metrics. The returned metrics will be from the range [DATE(starting
   * create time), DATE(ending create time)).
   * </pre>
   *
   * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIME_GRANULARITY_FIELD_NUMBER = 3;
  private int timeGranularity_ = 0;
  /**
   *
   *
   * <pre>
   * The time granularity of each data point in the time series.
   * Defaults to NONE if this field is unspecified.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
   * </code>
   *
   * @return The enum numeric value on the wire for timeGranularity.
   */
  @java.lang.Override
  public int getTimeGranularityValue() {
    return timeGranularity_;
  }
  /**
   *
   *
   * <pre>
   * The time granularity of each data point in the time series.
   * Defaults to NONE if this field is unspecified.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
   * </code>
   *
   * @return The timeGranularity.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
      getTimeGranularity() {
    com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity result =
        com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity.forNumber(
            timeGranularity_);
    return result == null
        ? com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity.UNRECOGNIZED
        : result;
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> dimensions_;
  /**
   *
   *
   * <pre>
   * The dimensions that determine the grouping key for the query. Defaults to
   * no dimension if this field is unspecified. If a dimension is specified,
   * its key must also be specified. Each dimension's key must be unique.
   *
   * If a time granularity is also specified, metric values in the dimension
   * will be bucketed by this granularity.
   *
   * Up to one dimension is supported for now.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> getDimensionsList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions that determine the grouping key for the query. Defaults to
   * no dimension if this field is unspecified. If a dimension is specified,
   * its key must also be specified. Each dimension's key must be unique.
   *
   * If a time granularity is also specified, metric values in the dimension
   * will be bucketed by this granularity.
   *
   * Up to one dimension is supported for now.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
      getDimensionsOrBuilderList() {
    return dimensions_;
  }
  /**
   *
   *
   * <pre>
   * The dimensions that determine the grouping key for the query. Defaults to
   * no dimension if this field is unspecified. If a dimension is specified,
   * its key must also be specified. Each dimension's key must be unique.
   *
   * If a time granularity is also specified, metric values in the dimension
   * will be bucketed by this granularity.
   *
   * Up to one dimension is supported for now.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
   */
  @java.lang.Override
  public int getDimensionsCount() {
    return dimensions_.size();
  }
  /**
   *
   *
   * <pre>
   * The dimensions that determine the grouping key for the query. Defaults to
   * no dimension if this field is unspecified. If a dimension is specified,
   * its key must also be specified. Each dimension's key must be unique.
   *
   * If a time granularity is also specified, metric values in the dimension
   * will be bucketed by this granularity.
   *
   * Up to one dimension is supported for now.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Dimension getDimensions(int index) {
    return dimensions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The dimensions that determine the grouping key for the query. Defaults to
   * no dimension if this field is unspecified. If a dimension is specified,
   * its key must also be specified. Each dimension's key must be unique.
   *
   * If a time granularity is also specified, metric values in the dimension
   * will be bucketed by this granularity.
   *
   * Up to one dimension is supported for now.
   * </pre>
   *
   * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder getDimensionsOrBuilder(
      int index) {
    return dimensions_.get(index);
  }

  public static final int MEASURE_MASK_FIELD_NUMBER = 5;
  private com.google.protobuf.FieldMask measureMask_;
  /**
   *
   *
   * <pre>
   * Measures to return. Defaults to all measures if this field is unspecified.
   * A valid mask should traverse from the `measure` field from the response.
   * For example, a path from a measure mask to get the conversation count is
   * "conversation_measure.count".
   * </pre>
   *
   * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
   *
   * @return Whether the measureMask field is set.
   */
  @java.lang.Override
  public boolean hasMeasureMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Measures to return. Defaults to all measures if this field is unspecified.
   * A valid mask should traverse from the `measure` field from the response.
   * For example, a path from a measure mask to get the conversation count is
   * "conversation_measure.count".
   * </pre>
   *
   * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
   *
   * @return The measureMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getMeasureMask() {
    return measureMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : measureMask_;
  }
  /**
   *
   *
   * <pre>
   * Measures to return. Defaults to all measures if this field is unspecified.
   * A valid mask should traverse from the `measure` field from the response.
   * For example, a path from a measure mask to get the conversation count is
   * "conversation_measure.count".
   * </pre>
   *
   * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getMeasureMaskOrBuilder() {
    return measureMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : measureMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
    }
    if (timeGranularity_
        != com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
            .TIME_GRANULARITY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, timeGranularity_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      output.writeMessage(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getMeasureMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(location_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, location_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
    }
    if (timeGranularity_
        != com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
            .TIME_GRANULARITY_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, timeGranularity_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, dimensions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMeasureMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest other =
        (com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest) obj;

    if (!getLocation().equals(other.getLocation())) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (timeGranularity_ != other.timeGranularity_) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (hasMeasureMask() != other.hasMeasureMask()) return false;
    if (hasMeasureMask()) {
      if (!getMeasureMask().equals(other.getMeasureMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + TIME_GRANULARITY_FIELD_NUMBER;
    hash = (53 * hash) + timeGranularity_;
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    if (hasMeasureMask()) {
      hash = (37 * hash) + MEASURE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getMeasureMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for querying metrics.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.QueryMetricsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.QueryMetricsRequest)
      com.google.cloud.contactcenterinsights.v1.QueryMetricsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.class,
              com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDimensionsFieldBuilder();
        getMeasureMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      location_ = "";
      filter_ = "";
      timeGranularity_ = 0;
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
      } else {
        dimensions_ = null;
        dimensionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      measureMask_ = null;
      if (measureMaskBuilder_ != null) {
        measureMaskBuilder_.dispose();
        measureMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_QueryMetricsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest build() {
      com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest buildPartial() {
      com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest result =
          new com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest result) {
      if (dimensionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          dimensions_ = java.util.Collections.unmodifiableList(dimensions_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.dimensions_ = dimensions_;
      } else {
        result.dimensions_ = dimensionsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.location_ = location_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.filter_ = filter_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.timeGranularity_ = timeGranularity_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.measureMask_ =
            measureMaskBuilder_ == null ? measureMask_ : measureMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.getDefaultInstance())
        return this;
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.timeGranularity_ != 0) {
        setTimeGranularityValue(other.getTimeGranularityValue());
      }
      if (dimensionsBuilder_ == null) {
        if (!other.dimensions_.isEmpty()) {
          if (dimensions_.isEmpty()) {
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureDimensionsIsMutable();
            dimensions_.addAll(other.dimensions_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensions_.isEmpty()) {
          if (dimensionsBuilder_.isEmpty()) {
            dimensionsBuilder_.dispose();
            dimensionsBuilder_ = null;
            dimensions_ = other.dimensions_;
            bitField0_ = (bitField0_ & ~0x00000008);
            dimensionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsFieldBuilder()
                    : null;
          } else {
            dimensionsBuilder_.addAllMessages(other.dimensions_);
          }
        }
      }
      if (other.hasMeasureMask()) {
        mergeMeasureMask(other.getMeasureMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                timeGranularity_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.contactcenterinsights.v1.Dimension m =
                    input.readMessage(
                        com.google.cloud.contactcenterinsights.v1.Dimension.parser(),
                        extensionRegistry);
                if (dimensionsBuilder_ == null) {
                  ensureDimensionsIsMutable();
                  dimensions_.add(m);
                } else {
                  dimensionsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMeasureMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The location of the data.
     * "projects/{project}/locations/{location}"
     * </pre>
     *
     * <code>
     * string location = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Required. Filter to select a subset of conversations to compute the
     * metrics. Must specify a window of the conversation create time to compute
     * the metrics. The returned metrics will be from the range [DATE(starting
     * create time), DATE(ending create time)).
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select a subset of conversations to compute the
     * metrics. Must specify a window of the conversation create time to compute
     * the metrics. The returned metrics will be from the range [DATE(starting
     * create time), DATE(ending create time)).
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select a subset of conversations to compute the
     * metrics. Must specify a window of the conversation create time to compute
     * the metrics. The returned metrics will be from the range [DATE(starting
     * create time), DATE(ending create time)).
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select a subset of conversations to compute the
     * metrics. Must specify a window of the conversation create time to compute
     * the metrics. The returned metrics will be from the range [DATE(starting
     * create time), DATE(ending create time)).
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Filter to select a subset of conversations to compute the
     * metrics. Must specify a window of the conversation create time to compute
     * the metrics. The returned metrics will be from the range [DATE(starting
     * create time), DATE(ending create time)).
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int timeGranularity_ = 0;
    /**
     *
     *
     * <pre>
     * The time granularity of each data point in the time series.
     * Defaults to NONE if this field is unspecified.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for timeGranularity.
     */
    @java.lang.Override
    public int getTimeGranularityValue() {
      return timeGranularity_;
    }
    /**
     *
     *
     * <pre>
     * The time granularity of each data point in the time series.
     * Defaults to NONE if this field is unspecified.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
     * </code>
     *
     * @param value The enum numeric value on the wire for timeGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setTimeGranularityValue(int value) {
      timeGranularity_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time granularity of each data point in the time series.
     * Defaults to NONE if this field is unspecified.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
     * </code>
     *
     * @return The timeGranularity.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
        getTimeGranularity() {
      com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity result =
          com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity.forNumber(
              timeGranularity_);
      return result == null
          ? com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity
              .UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The time granularity of each data point in the time series.
     * Defaults to NONE if this field is unspecified.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
     * </code>
     *
     * @param value The timeGranularity to set.
     * @return This builder for chaining.
     */
    public Builder setTimeGranularity(
        com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      timeGranularity_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time granularity of each data point in the time series.
     * Defaults to NONE if this field is unspecified.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.QueryMetricsRequest.TimeGranularity time_granularity = 3;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeGranularity() {
      bitField0_ = (bitField0_ & ~0x00000004);
      timeGranularity_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> dimensions_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        dimensions_ =
            new java.util.ArrayList<com.google.cloud.contactcenterinsights.v1.Dimension>(
                dimensions_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension,
            com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
            com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
        dimensionsBuilder_;

    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension> getDimensionsList() {
      if (dimensionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensions_);
      } else {
        return dimensionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public int getDimensionsCount() {
      if (dimensionsBuilder_ == null) {
        return dimensions_.size();
      } else {
        return dimensionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension getDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder setDimensions(
        int index, com.google.cloud.contactcenterinsights.v1.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.set(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder setDimensions(
        int index, com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder addDimensions(com.google.cloud.contactcenterinsights.v1.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder addDimensions(
        int index, com.google.cloud.contactcenterinsights.v1.Dimension value) {
      if (dimensionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsIsMutable();
        dimensions_.add(index, value);
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder addDimensions(
        com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder addDimensions(
        int index, com.google.cloud.contactcenterinsights.v1.Dimension.Builder builderForValue) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder addAllDimensions(
        java.lang.Iterable<? extends com.google.cloud.contactcenterinsights.v1.Dimension> values) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
        onChanged();
      } else {
        dimensionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder clearDimensions() {
      if (dimensionsBuilder_ == null) {
        dimensions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        dimensionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public Builder removeDimensions(int index) {
      if (dimensionsBuilder_ == null) {
        ensureDimensionsIsMutable();
        dimensions_.remove(index);
        onChanged();
      } else {
        dimensionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.Builder getDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder getDimensionsOrBuilder(
        int index) {
      if (dimensionsBuilder_ == null) {
        return dimensions_.get(index);
      } else {
        return dimensionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
        getDimensionsOrBuilderList() {
      if (dimensionsBuilder_ != null) {
        return dimensionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensions_);
      }
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.Builder addDimensionsBuilder() {
      return getDimensionsFieldBuilder()
          .addBuilder(com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.Dimension.Builder addDimensionsBuilder(
        int index) {
      return getDimensionsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.contactcenterinsights.v1.Dimension.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The dimensions that determine the grouping key for the query. Defaults to
     * no dimension if this field is unspecified. If a dimension is specified,
     * its key must also be specified. Each dimension's key must be unique.
     *
     * If a time granularity is also specified, metric values in the dimension
     * will be bucketed by this granularity.
     *
     * Up to one dimension is supported for now.
     * </pre>
     *
     * <code>repeated .google.cloud.contactcenterinsights.v1.Dimension dimensions = 4;</code>
     */
    public java.util.List<com.google.cloud.contactcenterinsights.v1.Dimension.Builder>
        getDimensionsBuilderList() {
      return getDimensionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Dimension,
            com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
            com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>
        getDimensionsFieldBuilder() {
      if (dimensionsBuilder_ == null) {
        dimensionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Dimension,
                com.google.cloud.contactcenterinsights.v1.Dimension.Builder,
                com.google.cloud.contactcenterinsights.v1.DimensionOrBuilder>(
                dimensions_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        dimensions_ = null;
      }
      return dimensionsBuilder_;
    }

    private com.google.protobuf.FieldMask measureMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        measureMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     *
     * @return Whether the measureMask field is set.
     */
    public boolean hasMeasureMask() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     *
     * @return The measureMask.
     */
    public com.google.protobuf.FieldMask getMeasureMask() {
      if (measureMaskBuilder_ == null) {
        return measureMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : measureMask_;
      } else {
        return measureMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public Builder setMeasureMask(com.google.protobuf.FieldMask value) {
      if (measureMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        measureMask_ = value;
      } else {
        measureMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public Builder setMeasureMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (measureMaskBuilder_ == null) {
        measureMask_ = builderForValue.build();
      } else {
        measureMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public Builder mergeMeasureMask(com.google.protobuf.FieldMask value) {
      if (measureMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && measureMask_ != null
            && measureMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getMeasureMaskBuilder().mergeFrom(value);
        } else {
          measureMask_ = value;
        }
      } else {
        measureMaskBuilder_.mergeFrom(value);
      }
      if (measureMask_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public Builder clearMeasureMask() {
      bitField0_ = (bitField0_ & ~0x00000010);
      measureMask_ = null;
      if (measureMaskBuilder_ != null) {
        measureMaskBuilder_.dispose();
        measureMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public com.google.protobuf.FieldMask.Builder getMeasureMaskBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMeasureMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getMeasureMaskOrBuilder() {
      if (measureMaskBuilder_ != null) {
        return measureMaskBuilder_.getMessageOrBuilder();
      } else {
        return measureMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : measureMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Measures to return. Defaults to all measures if this field is unspecified.
     * A valid mask should traverse from the `measure` field from the response.
     * For example, a path from a measure mask to get the conversation count is
     * "conversation_measure.count".
     * </pre>
     *
     * <code>.google.protobuf.FieldMask measure_mask = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getMeasureMaskFieldBuilder() {
      if (measureMaskBuilder_ == null) {
        measureMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getMeasureMask(), getParentForChildren(), isClean());
        measureMask_ = null;
      }
      return measureMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.QueryMetricsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.QueryMetricsRequest)
  private static final com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest();
  }

  public static com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryMetricsRequest> PARSER =
      new com.google.protobuf.AbstractParser<QueryMetricsRequest>() {
        @java.lang.Override
        public QueryMetricsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QueryMetricsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryMetricsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.QueryMetricsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
