/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/resources.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * The CCAI Insights project wide settings.
 * Use these settings to configure the behavior of Insights.
 * View these settings with
 * [`getsettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings)
 * and change the settings with
 * [`updateSettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.Settings}
 */
public final class Settings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Settings)
    SettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Settings.newBuilder() to construct.
  private Settings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Settings() {
    name_ = "";
    languageCode_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Settings();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Settings_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetPubsubNotificationSettings();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ResourcesProto
        .internal_static_google_cloud_contactcenterinsights_v1_Settings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.Settings.class,
            com.google.cloud.contactcenterinsights.v1.Settings.Builder.class);
  }

  public interface AnalysisConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Percentage of conversations created using Dialogflow runtime integration
     * to analyze automatically, between [0, 100].
     * </pre>
     *
     * <code>double runtime_integration_analysis_percentage = 1;</code>
     *
     * @return The runtimeIntegrationAnalysisPercentage.
     */
    double getRuntimeIntegrationAnalysisPercentage();

    /**
     *
     *
     * <pre>
     * Percentage of conversations created using the UploadConversation endpoint
     * to analyze automatically, between [0, 100].
     * </pre>
     *
     * <code>double upload_conversation_analysis_percentage = 6;</code>
     *
     * @return The uploadConversationAnalysisPercentage.
     */
    double getUploadConversationAnalysisPercentage();

    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     *
     * @return Whether the annotatorSelector field is set.
     */
    boolean hasAnnotatorSelector();
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     *
     * @return The annotatorSelector.
     */
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector();
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     */
    com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
        getAnnotatorSelectorOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Default configuration when creating Analyses in Insights.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig}
   */
  public static final class AnalysisConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)
      AnalysisConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnalysisConfig.newBuilder() to construct.
    private AnalysisConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnalysisConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnalysisConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Settings_AnalysisConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Settings_AnalysisConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.class,
              com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder.class);
    }

    private int bitField0_;
    public static final int RUNTIME_INTEGRATION_ANALYSIS_PERCENTAGE_FIELD_NUMBER = 1;
    private double runtimeIntegrationAnalysisPercentage_ = 0D;
    /**
     *
     *
     * <pre>
     * Percentage of conversations created using Dialogflow runtime integration
     * to analyze automatically, between [0, 100].
     * </pre>
     *
     * <code>double runtime_integration_analysis_percentage = 1;</code>
     *
     * @return The runtimeIntegrationAnalysisPercentage.
     */
    @java.lang.Override
    public double getRuntimeIntegrationAnalysisPercentage() {
      return runtimeIntegrationAnalysisPercentage_;
    }

    public static final int UPLOAD_CONVERSATION_ANALYSIS_PERCENTAGE_FIELD_NUMBER = 6;
    private double uploadConversationAnalysisPercentage_ = 0D;
    /**
     *
     *
     * <pre>
     * Percentage of conversations created using the UploadConversation endpoint
     * to analyze automatically, between [0, 100].
     * </pre>
     *
     * <code>double upload_conversation_analysis_percentage = 6;</code>
     *
     * @return The uploadConversationAnalysisPercentage.
     */
    @java.lang.Override
    public double getUploadConversationAnalysisPercentage() {
      return uploadConversationAnalysisPercentage_;
    }

    public static final int ANNOTATOR_SELECTOR_FIELD_NUMBER = 5;
    private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     *
     * @return Whether the annotatorSelector field is set.
     */
    @java.lang.Override
    public boolean hasAnnotatorSelector() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     *
     * @return The annotatorSelector.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
      return annotatorSelector_ == null
          ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
          : annotatorSelector_;
    }
    /**
     *
     *
     * <pre>
     * To select the annotators to run and the phrase matchers to use
     * (if any). If not specified, all annotators will be run.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
        getAnnotatorSelectorOrBuilder() {
      return annotatorSelector_ == null
          ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
          : annotatorSelector_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (java.lang.Double.doubleToRawLongBits(runtimeIntegrationAnalysisPercentage_) != 0) {
        output.writeDouble(1, runtimeIntegrationAnalysisPercentage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(5, getAnnotatorSelector());
      }
      if (java.lang.Double.doubleToRawLongBits(uploadConversationAnalysisPercentage_) != 0) {
        output.writeDouble(6, uploadConversationAnalysisPercentage_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (java.lang.Double.doubleToRawLongBits(runtimeIntegrationAnalysisPercentage_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                1, runtimeIntegrationAnalysisPercentage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getAnnotatorSelector());
      }
      if (java.lang.Double.doubleToRawLongBits(uploadConversationAnalysisPercentage_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                6, uploadConversationAnalysisPercentage_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig other =
          (com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig) obj;

      if (java.lang.Double.doubleToLongBits(getRuntimeIntegrationAnalysisPercentage())
          != java.lang.Double.doubleToLongBits(other.getRuntimeIntegrationAnalysisPercentage()))
        return false;
      if (java.lang.Double.doubleToLongBits(getUploadConversationAnalysisPercentage())
          != java.lang.Double.doubleToLongBits(other.getUploadConversationAnalysisPercentage()))
        return false;
      if (hasAnnotatorSelector() != other.hasAnnotatorSelector()) return false;
      if (hasAnnotatorSelector()) {
        if (!getAnnotatorSelector().equals(other.getAnnotatorSelector())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RUNTIME_INTEGRATION_ANALYSIS_PERCENTAGE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getRuntimeIntegrationAnalysisPercentage()));
      hash = (37 * hash) + UPLOAD_CONVERSATION_ANALYSIS_PERCENTAGE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getUploadConversationAnalysisPercentage()));
      if (hasAnnotatorSelector()) {
        hash = (37 * hash) + ANNOTATOR_SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotatorSelector().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Default configuration when creating Analyses in Insights.
     * </pre>
     *
     * Protobuf type {@code google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Settings_AnalysisConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Settings_AnalysisConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.class,
                com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getAnnotatorSelectorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        runtimeIntegrationAnalysisPercentage_ = 0D;
        uploadConversationAnalysisPercentage_ = 0D;
        annotatorSelector_ = null;
        if (annotatorSelectorBuilder_ != null) {
          annotatorSelectorBuilder_.dispose();
          annotatorSelectorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ResourcesProto
            .internal_static_google_cloud_contactcenterinsights_v1_Settings_AnalysisConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig build() {
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig buildPartial() {
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig result =
            new com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.runtimeIntegrationAnalysisPercentage_ = runtimeIntegrationAnalysisPercentage_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.uploadConversationAnalysisPercentage_ = uploadConversationAnalysisPercentage_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.annotatorSelector_ =
              annotatorSelectorBuilder_ == null
                  ? annotatorSelector_
                  : annotatorSelectorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
                .getDefaultInstance()) return this;
        if (other.getRuntimeIntegrationAnalysisPercentage() != 0D) {
          setRuntimeIntegrationAnalysisPercentage(other.getRuntimeIntegrationAnalysisPercentage());
        }
        if (other.getUploadConversationAnalysisPercentage() != 0D) {
          setUploadConversationAnalysisPercentage(other.getUploadConversationAnalysisPercentage());
        }
        if (other.hasAnnotatorSelector()) {
          mergeAnnotatorSelector(other.getAnnotatorSelector());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 9:
                {
                  runtimeIntegrationAnalysisPercentage_ = input.readDouble();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 9
              case 42:
                {
                  input.readMessage(
                      getAnnotatorSelectorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 42
              case 49:
                {
                  uploadConversationAnalysisPercentage_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 49
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private double runtimeIntegrationAnalysisPercentage_;
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using Dialogflow runtime integration
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double runtime_integration_analysis_percentage = 1;</code>
       *
       * @return The runtimeIntegrationAnalysisPercentage.
       */
      @java.lang.Override
      public double getRuntimeIntegrationAnalysisPercentage() {
        return runtimeIntegrationAnalysisPercentage_;
      }
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using Dialogflow runtime integration
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double runtime_integration_analysis_percentage = 1;</code>
       *
       * @param value The runtimeIntegrationAnalysisPercentage to set.
       * @return This builder for chaining.
       */
      public Builder setRuntimeIntegrationAnalysisPercentage(double value) {

        runtimeIntegrationAnalysisPercentage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using Dialogflow runtime integration
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double runtime_integration_analysis_percentage = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRuntimeIntegrationAnalysisPercentage() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runtimeIntegrationAnalysisPercentage_ = 0D;
        onChanged();
        return this;
      }

      private double uploadConversationAnalysisPercentage_;
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using the UploadConversation endpoint
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double upload_conversation_analysis_percentage = 6;</code>
       *
       * @return The uploadConversationAnalysisPercentage.
       */
      @java.lang.Override
      public double getUploadConversationAnalysisPercentage() {
        return uploadConversationAnalysisPercentage_;
      }
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using the UploadConversation endpoint
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double upload_conversation_analysis_percentage = 6;</code>
       *
       * @param value The uploadConversationAnalysisPercentage to set.
       * @return This builder for chaining.
       */
      public Builder setUploadConversationAnalysisPercentage(double value) {

        uploadConversationAnalysisPercentage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Percentage of conversations created using the UploadConversation endpoint
       * to analyze automatically, between [0, 100].
       * </pre>
       *
       * <code>double upload_conversation_analysis_percentage = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUploadConversationAnalysisPercentage() {
        bitField0_ = (bitField0_ & ~0x00000002);
        uploadConversationAnalysisPercentage_ = 0D;
        onChanged();
        return this;
      }

      private com.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotatorSelector_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
          annotatorSelectorBuilder_;
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       *
       * @return Whether the annotatorSelector field is set.
       */
      public boolean hasAnnotatorSelector() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       *
       * @return The annotatorSelector.
       */
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector getAnnotatorSelector() {
        if (annotatorSelectorBuilder_ == null) {
          return annotatorSelector_ == null
              ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
              : annotatorSelector_;
        } else {
          return annotatorSelectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public Builder setAnnotatorSelector(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
        if (annotatorSelectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          annotatorSelector_ = value;
        } else {
          annotatorSelectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public Builder setAnnotatorSelector(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder builderForValue) {
        if (annotatorSelectorBuilder_ == null) {
          annotatorSelector_ = builderForValue.build();
        } else {
          annotatorSelectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public Builder mergeAnnotatorSelector(
          com.google.cloud.contactcenterinsights.v1.AnnotatorSelector value) {
        if (annotatorSelectorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && annotatorSelector_ != null
              && annotatorSelector_
                  != com.google.cloud.contactcenterinsights.v1.AnnotatorSelector
                      .getDefaultInstance()) {
            getAnnotatorSelectorBuilder().mergeFrom(value);
          } else {
            annotatorSelector_ = value;
          }
        } else {
          annotatorSelectorBuilder_.mergeFrom(value);
        }
        if (annotatorSelector_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public Builder clearAnnotatorSelector() {
        bitField0_ = (bitField0_ & ~0x00000004);
        annotatorSelector_ = null;
        if (annotatorSelectorBuilder_ != null) {
          annotatorSelectorBuilder_.dispose();
          annotatorSelectorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder
          getAnnotatorSelectorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getAnnotatorSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder
          getAnnotatorSelectorOrBuilder() {
        if (annotatorSelectorBuilder_ != null) {
          return annotatorSelectorBuilder_.getMessageOrBuilder();
        } else {
          return annotatorSelector_ == null
              ? com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.getDefaultInstance()
              : annotatorSelector_;
        }
      }
      /**
       *
       *
       * <pre>
       * To select the annotators to run and the phrase matchers to use
       * (if any). If not specified, all annotators will be run.
       * </pre>
       *
       * <code>.google.cloud.contactcenterinsights.v1.AnnotatorSelector annotator_selector = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
              com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>
          getAnnotatorSelectorFieldBuilder() {
        if (annotatorSelectorBuilder_ == null) {
          annotatorSelectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector,
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelector.Builder,
                  com.google.cloud.contactcenterinsights.v1.AnnotatorSelectorOrBuilder>(
                  getAnnotatorSelector(), getParentForChildren(), isClean());
          annotatorSelector_ = null;
        }
        return annotatorSelectorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig)
    private static final com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig();
    }

    public static com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnalysisConfig> PARSER =
        new com.google.protobuf.AbstractParser<AnalysisConfig>() {
          @java.lang.Override
          public AnalysisConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AnalysisConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnalysisConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the settings resource.
   * Format:
   * projects/{project}/locations/{location}/settings
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. The resource name of the settings resource.
   * Format:
   * projects/{project}/locations/{location}/settings
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time at which the settings were last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * A language code to be applied to each transcript segment unless the segment
   * already specifies a language code. Language code defaults to "en-US" if it
   * is neither specified on the segment nor here.
   * </pre>
   *
   * <code>string language_code = 4;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A language code to be applied to each transcript segment unless the segment
   * already specifies a language code. Language code defaults to "en-US" if it
   * is neither specified on the segment nor here.
   * </pre>
   *
   * <code>string language_code = 4;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONVERSATION_TTL_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration conversationTtl_;
  /**
   *
   *
   * <pre>
   * The default TTL for newly-created conversations. If a conversation has a
   * specified expiration, that value will be used instead. Changing this
   * value will not change the expiration of existing conversations.
   * Conversations with no expire time persist until they are deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
   *
   * @return Whether the conversationTtl field is set.
   */
  @java.lang.Override
  public boolean hasConversationTtl() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The default TTL for newly-created conversations. If a conversation has a
   * specified expiration, that value will be used instead. Changing this
   * value will not change the expiration of existing conversations.
   * Conversations with no expire time persist until they are deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
   *
   * @return The conversationTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getConversationTtl() {
    return conversationTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : conversationTtl_;
  }
  /**
   *
   *
   * <pre>
   * The default TTL for newly-created conversations. If a conversation has a
   * specified expiration, that value will be used instead. Changing this
   * value will not change the expiration of existing conversations.
   * Conversations with no expire time persist until they are deleted.
   * </pre>
   *
   * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getConversationTtlOrBuilder() {
    return conversationTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : conversationTtl_;
  }

  public static final int PUBSUB_NOTIFICATION_SETTINGS_FIELD_NUMBER = 6;

  private static final class PubsubNotificationSettingsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.contactcenterinsights.v1.ResourcesProto
                .internal_static_google_cloud_contactcenterinsights_v1_Settings_PubsubNotificationSettingsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      pubsubNotificationSettings_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetPubsubNotificationSettings() {
    if (pubsubNotificationSettings_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          PubsubNotificationSettingsDefaultEntryHolder.defaultEntry);
    }
    return pubsubNotificationSettings_;
  }

  public int getPubsubNotificationSettingsCount() {
    return internalGetPubsubNotificationSettings().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map that maps a notification trigger to a Pub/Sub topic. Each time a
   * specified trigger occurs, Insights will notify the corresponding Pub/Sub
   * topic.
   *
   * Keys are notification triggers. Supported keys are:
   *
   * * "all-triggers": Notify each time any of the supported triggers occurs.
   * * "create-analysis": Notify each time an analysis is created.
   * * "create-conversation": Notify each time a conversation is created.
   * * "export-insights-data": Notify each time an export is complete.
   * * "ingest-conversations": Notify each time an IngestConversations LRO is
   * complete.
   * * "update-conversation": Notify each time a conversation is updated via
   * UpdateConversation.
   * * "upload-conversation": Notify when an UploadConversation LRO is complete.
   *
   * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
   * projects/{project}/topics/{topic}
   * </pre>
   *
   * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
   */
  @java.lang.Override
  public boolean containsPubsubNotificationSettings(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetPubsubNotificationSettings().getMap().containsKey(key);
  }
  /** Use {@link #getPubsubNotificationSettingsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getPubsubNotificationSettings() {
    return getPubsubNotificationSettingsMap();
  }
  /**
   *
   *
   * <pre>
   * A map that maps a notification trigger to a Pub/Sub topic. Each time a
   * specified trigger occurs, Insights will notify the corresponding Pub/Sub
   * topic.
   *
   * Keys are notification triggers. Supported keys are:
   *
   * * "all-triggers": Notify each time any of the supported triggers occurs.
   * * "create-analysis": Notify each time an analysis is created.
   * * "create-conversation": Notify each time a conversation is created.
   * * "export-insights-data": Notify each time an export is complete.
   * * "ingest-conversations": Notify each time an IngestConversations LRO is
   * complete.
   * * "update-conversation": Notify each time a conversation is updated via
   * UpdateConversation.
   * * "upload-conversation": Notify when an UploadConversation LRO is complete.
   *
   * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
   * projects/{project}/topics/{topic}
   * </pre>
   *
   * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPubsubNotificationSettingsMap() {
    return internalGetPubsubNotificationSettings().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map that maps a notification trigger to a Pub/Sub topic. Each time a
   * specified trigger occurs, Insights will notify the corresponding Pub/Sub
   * topic.
   *
   * Keys are notification triggers. Supported keys are:
   *
   * * "all-triggers": Notify each time any of the supported triggers occurs.
   * * "create-analysis": Notify each time an analysis is created.
   * * "create-conversation": Notify each time a conversation is created.
   * * "export-insights-data": Notify each time an export is complete.
   * * "ingest-conversations": Notify each time an IngestConversations LRO is
   * complete.
   * * "update-conversation": Notify each time a conversation is updated via
   * UpdateConversation.
   * * "upload-conversation": Notify when an UploadConversation LRO is complete.
   *
   * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
   * projects/{project}/topics/{topic}
   * </pre>
   *
   * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPubsubNotificationSettingsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetPubsubNotificationSettings().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map that maps a notification trigger to a Pub/Sub topic. Each time a
   * specified trigger occurs, Insights will notify the corresponding Pub/Sub
   * topic.
   *
   * Keys are notification triggers. Supported keys are:
   *
   * * "all-triggers": Notify each time any of the supported triggers occurs.
   * * "create-analysis": Notify each time an analysis is created.
   * * "create-conversation": Notify each time a conversation is created.
   * * "export-insights-data": Notify each time an export is complete.
   * * "ingest-conversations": Notify each time an IngestConversations LRO is
   * complete.
   * * "update-conversation": Notify each time a conversation is updated via
   * UpdateConversation.
   * * "upload-conversation": Notify when an UploadConversation LRO is complete.
   *
   * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
   * projects/{project}/topics/{topic}
   * </pre>
   *
   * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getPubsubNotificationSettingsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetPubsubNotificationSettings().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ANALYSIS_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysisConfig_;
  /**
   *
   *
   * <pre>
   * Default analysis settings.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
   * </code>
   *
   * @return Whether the analysisConfig field is set.
   */
  @java.lang.Override
  public boolean hasAnalysisConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Default analysis settings.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
   * </code>
   *
   * @return The analysisConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig getAnalysisConfig() {
    return analysisConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.getDefaultInstance()
        : analysisConfig_;
  }
  /**
   *
   *
   * <pre>
   * Default analysis settings.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder
      getAnalysisConfigOrBuilder() {
    return analysisConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.getDefaultInstance()
        : analysisConfig_;
  }

  public static final int REDACTION_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.contactcenterinsights.v1.RedactionConfig redactionConfig_;
  /**
   *
   *
   * <pre>
   * Default DLP redaction resources to be applied while ingesting
   * conversations. This applies to conversations ingested from the
   * `UploadConversation` and `IngestConversations` endpoints, including
   * conversations coming from CCAI Platform.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
   *
   * @return Whether the redactionConfig field is set.
   */
  @java.lang.Override
  public boolean hasRedactionConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Default DLP redaction resources to be applied while ingesting
   * conversations. This applies to conversations ingested from the
   * `UploadConversation` and `IngestConversations` endpoints, including
   * conversations coming from CCAI Platform.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
   *
   * @return The redactionConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RedactionConfig getRedactionConfig() {
    return redactionConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
        : redactionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Default DLP redaction resources to be applied while ingesting
   * conversations. This applies to conversations ingested from the
   * `UploadConversation` and `IngestConversations` endpoints, including
   * conversations coming from CCAI Platform.
   * </pre>
   *
   * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder
      getRedactionConfigOrBuilder() {
    return redactionConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
        : redactionConfig_;
  }

  public static final int SPEECH_CONFIG_FIELD_NUMBER = 11;
  private com.google.cloud.contactcenterinsights.v1.SpeechConfig speechConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text resources to use while ingesting audio
   * files. Optional, CCAI Insights will create a default if not provided. This
   * applies to conversations ingested from the `UploadConversation` and
   * `IngestConversations` endpoints, including conversations coming from CCAI
   * Platform.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the speechConfig field is set.
   */
  @java.lang.Override
  public boolean hasSpeechConfig() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text resources to use while ingesting audio
   * files. Optional, CCAI Insights will create a default if not provided. This
   * applies to conversations ingested from the `UploadConversation` and
   * `IngestConversations` endpoints, including conversations coming from CCAI
   * Platform.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The speechConfig.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SpeechConfig getSpeechConfig() {
    return speechConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Default Speech-to-Text resources to use while ingesting audio
   * files. Optional, CCAI Insights will create a default if not provided. This
   * applies to conversations ingested from the `UploadConversation` and
   * `IngestConversations` endpoints, including conversations coming from CCAI
   * Platform.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder
      getSpeechConfigOrBuilder() {
    return speechConfig_ == null
        ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
        : speechConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, languageCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getConversationTtl());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetPubsubNotificationSettings(),
        PubsubNotificationSettingsDefaultEntryHolder.defaultEntry,
        6);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getAnalysisConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getRedactionConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(11, getSpeechConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, languageCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getConversationTtl());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetPubsubNotificationSettings().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
          pubsubNotificationSettings__ =
              PubsubNotificationSettingsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, pubsubNotificationSettings__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getAnalysisConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getRedactionConfig());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSpeechConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.contactcenterinsights.v1.Settings)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.Settings other =
        (com.google.cloud.contactcenterinsights.v1.Settings) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (hasConversationTtl() != other.hasConversationTtl()) return false;
    if (hasConversationTtl()) {
      if (!getConversationTtl().equals(other.getConversationTtl())) return false;
    }
    if (!internalGetPubsubNotificationSettings()
        .equals(other.internalGetPubsubNotificationSettings())) return false;
    if (hasAnalysisConfig() != other.hasAnalysisConfig()) return false;
    if (hasAnalysisConfig()) {
      if (!getAnalysisConfig().equals(other.getAnalysisConfig())) return false;
    }
    if (hasRedactionConfig() != other.hasRedactionConfig()) return false;
    if (hasRedactionConfig()) {
      if (!getRedactionConfig().equals(other.getRedactionConfig())) return false;
    }
    if (hasSpeechConfig() != other.hasSpeechConfig()) return false;
    if (hasSpeechConfig()) {
      if (!getSpeechConfig().equals(other.getSpeechConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    if (hasConversationTtl()) {
      hash = (37 * hash) + CONVERSATION_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getConversationTtl().hashCode();
    }
    if (!internalGetPubsubNotificationSettings().getMap().isEmpty()) {
      hash = (37 * hash) + PUBSUB_NOTIFICATION_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetPubsubNotificationSettings().hashCode();
    }
    if (hasAnalysisConfig()) {
      hash = (37 * hash) + ANALYSIS_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAnalysisConfig().hashCode();
    }
    if (hasRedactionConfig()) {
      hash = (37 * hash) + REDACTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRedactionConfig().hashCode();
    }
    if (hasSpeechConfig()) {
      hash = (37 * hash) + SPEECH_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.contactcenterinsights.v1.Settings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The CCAI Insights project wide settings.
   * Use these settings to configure the behavior of Insights.
   * View these settings with
   * [`getsettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/getSettings)
   * and change the settings with
   * [`updateSettings`](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations/updateSettings).
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.Settings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.Settings)
      com.google.cloud.contactcenterinsights.v1.SettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Settings_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetPubsubNotificationSettings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutablePubsubNotificationSettings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Settings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.Settings.class,
              com.google.cloud.contactcenterinsights.v1.Settings.Builder.class);
    }

    // Construct using com.google.cloud.contactcenterinsights.v1.Settings.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getConversationTtlFieldBuilder();
        getAnalysisConfigFieldBuilder();
        getRedactionConfigFieldBuilder();
        getSpeechConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      languageCode_ = "";
      conversationTtl_ = null;
      if (conversationTtlBuilder_ != null) {
        conversationTtlBuilder_.dispose();
        conversationTtlBuilder_ = null;
      }
      internalGetMutablePubsubNotificationSettings().clear();
      analysisConfig_ = null;
      if (analysisConfigBuilder_ != null) {
        analysisConfigBuilder_.dispose();
        analysisConfigBuilder_ = null;
      }
      redactionConfig_ = null;
      if (redactionConfigBuilder_ != null) {
        redactionConfigBuilder_.dispose();
        redactionConfigBuilder_ = null;
      }
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ResourcesProto
          .internal_static_google_cloud_contactcenterinsights_v1_Settings_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Settings getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.Settings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Settings build() {
      com.google.cloud.contactcenterinsights.v1.Settings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.Settings buildPartial() {
      com.google.cloud.contactcenterinsights.v1.Settings result =
          new com.google.cloud.contactcenterinsights.v1.Settings(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.contactcenterinsights.v1.Settings result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.conversationTtl_ =
            conversationTtlBuilder_ == null ? conversationTtl_ : conversationTtlBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.pubsubNotificationSettings_ = internalGetPubsubNotificationSettings();
        result.pubsubNotificationSettings_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.analysisConfig_ =
            analysisConfigBuilder_ == null ? analysisConfig_ : analysisConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.redactionConfig_ =
            redactionConfigBuilder_ == null ? redactionConfig_ : redactionConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.speechConfig_ =
            speechConfigBuilder_ == null ? speechConfig_ : speechConfigBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.contactcenterinsights.v1.Settings) {
        return mergeFrom((com.google.cloud.contactcenterinsights.v1.Settings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.contactcenterinsights.v1.Settings other) {
      if (other == com.google.cloud.contactcenterinsights.v1.Settings.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasConversationTtl()) {
        mergeConversationTtl(other.getConversationTtl());
      }
      internalGetMutablePubsubNotificationSettings()
          .mergeFrom(other.internalGetPubsubNotificationSettings());
      bitField0_ |= 0x00000020;
      if (other.hasAnalysisConfig()) {
        mergeAnalysisConfig(other.getAnalysisConfig());
      }
      if (other.hasRedactionConfig()) {
        mergeRedactionConfig(other.getRedactionConfig());
      }
      if (other.hasSpeechConfig()) {
        mergeSpeechConfig(other.getSpeechConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getConversationTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    pubsubNotificationSettings__ =
                        input.readMessage(
                            PubsubNotificationSettingsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutablePubsubNotificationSettings()
                    .getMutableMap()
                    .put(
                        pubsubNotificationSettings__.getKey(),
                        pubsubNotificationSettings__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getAnalysisConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 82:
              {
                input.readMessage(getRedactionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getSpeechConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the settings resource.
     * Format:
     * projects/{project}/locations/{location}/settings
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the settings resource.
     * Format:
     * projects/{project}/locations/{location}/settings
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the settings resource.
     * Format:
     * projects/{project}/locations/{location}/settings
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the settings resource.
     * Format:
     * projects/{project}/locations/{location}/settings
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The resource name of the settings resource.
     * Format:
     * projects/{project}/locations/{location}/settings
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time at which the settings were last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * A language code to be applied to each transcript segment unless the segment
     * already specifies a language code. Language code defaults to "en-US" if it
     * is neither specified on the segment nor here.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A language code to be applied to each transcript segment unless the segment
     * already specifies a language code. Language code defaults to "en-US" if it
     * is neither specified on the segment nor here.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A language code to be applied to each transcript segment unless the segment
     * already specifies a language code. Language code defaults to "en-US" if it
     * is neither specified on the segment nor here.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A language code to be applied to each transcript segment unless the segment
     * already specifies a language code. Language code defaults to "en-US" if it
     * is neither specified on the segment nor here.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A language code to be applied to each transcript segment unless the segment
     * already specifies a language code. Language code defaults to "en-US" if it
     * is neither specified on the segment nor here.
     * </pre>
     *
     * <code>string language_code = 4;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration conversationTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        conversationTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     *
     * @return Whether the conversationTtl field is set.
     */
    public boolean hasConversationTtl() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     *
     * @return The conversationTtl.
     */
    public com.google.protobuf.Duration getConversationTtl() {
      if (conversationTtlBuilder_ == null) {
        return conversationTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : conversationTtl_;
      } else {
        return conversationTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public Builder setConversationTtl(com.google.protobuf.Duration value) {
      if (conversationTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conversationTtl_ = value;
      } else {
        conversationTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public Builder setConversationTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (conversationTtlBuilder_ == null) {
        conversationTtl_ = builderForValue.build();
      } else {
        conversationTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public Builder mergeConversationTtl(com.google.protobuf.Duration value) {
      if (conversationTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && conversationTtl_ != null
            && conversationTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getConversationTtlBuilder().mergeFrom(value);
        } else {
          conversationTtl_ = value;
        }
      } else {
        conversationTtlBuilder_.mergeFrom(value);
      }
      if (conversationTtl_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public Builder clearConversationTtl() {
      bitField0_ = (bitField0_ & ~0x00000010);
      conversationTtl_ = null;
      if (conversationTtlBuilder_ != null) {
        conversationTtlBuilder_.dispose();
        conversationTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getConversationTtlBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getConversationTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getConversationTtlOrBuilder() {
      if (conversationTtlBuilder_ != null) {
        return conversationTtlBuilder_.getMessageOrBuilder();
      } else {
        return conversationTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : conversationTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The default TTL for newly-created conversations. If a conversation has a
     * specified expiration, that value will be used instead. Changing this
     * value will not change the expiration of existing conversations.
     * Conversations with no expire time persist until they are deleted.
     * </pre>
     *
     * <code>.google.protobuf.Duration conversation_ttl = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getConversationTtlFieldBuilder() {
      if (conversationTtlBuilder_ == null) {
        conversationTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getConversationTtl(), getParentForChildren(), isClean());
        conversationTtl_ = null;
      }
      return conversationTtlBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        pubsubNotificationSettings_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetPubsubNotificationSettings() {
      if (pubsubNotificationSettings_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PubsubNotificationSettingsDefaultEntryHolder.defaultEntry);
      }
      return pubsubNotificationSettings_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutablePubsubNotificationSettings() {
      if (pubsubNotificationSettings_ == null) {
        pubsubNotificationSettings_ =
            com.google.protobuf.MapField.newMapField(
                PubsubNotificationSettingsDefaultEntryHolder.defaultEntry);
      }
      if (!pubsubNotificationSettings_.isMutable()) {
        pubsubNotificationSettings_ = pubsubNotificationSettings_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return pubsubNotificationSettings_;
    }

    public int getPubsubNotificationSettingsCount() {
      return internalGetPubsubNotificationSettings().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    @java.lang.Override
    public boolean containsPubsubNotificationSettings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetPubsubNotificationSettings().getMap().containsKey(key);
    }
    /** Use {@link #getPubsubNotificationSettingsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getPubsubNotificationSettings() {
      return getPubsubNotificationSettingsMap();
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPubsubNotificationSettingsMap() {
      return internalGetPubsubNotificationSettings().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPubsubNotificationSettingsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetPubsubNotificationSettings().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getPubsubNotificationSettingsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetPubsubNotificationSettings().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearPubsubNotificationSettings() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutablePubsubNotificationSettings().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    public Builder removePubsubNotificationSettings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutablePubsubNotificationSettings().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String>
        getMutablePubsubNotificationSettings() {
      bitField0_ |= 0x00000020;
      return internalGetMutablePubsubNotificationSettings().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    public Builder putPubsubNotificationSettings(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutablePubsubNotificationSettings().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map that maps a notification trigger to a Pub/Sub topic. Each time a
     * specified trigger occurs, Insights will notify the corresponding Pub/Sub
     * topic.
     *
     * Keys are notification triggers. Supported keys are:
     *
     * * "all-triggers": Notify each time any of the supported triggers occurs.
     * * "create-analysis": Notify each time an analysis is created.
     * * "create-conversation": Notify each time a conversation is created.
     * * "export-insights-data": Notify each time an export is complete.
     * * "ingest-conversations": Notify each time an IngestConversations LRO is
     * complete.
     * * "update-conversation": Notify each time a conversation is updated via
     * UpdateConversation.
     * * "upload-conversation": Notify when an UploadConversation LRO is complete.
     *
     * Values are Pub/Sub topics. The format of each Pub/Sub topic is:
     * projects/{project}/topics/{topic}
     * </pre>
     *
     * <code>map&lt;string, string&gt; pubsub_notification_settings = 6;</code>
     */
    public Builder putAllPubsubNotificationSettings(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutablePubsubNotificationSettings().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysisConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig,
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder>
        analysisConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     *
     * @return Whether the analysisConfig field is set.
     */
    public boolean hasAnalysisConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     *
     * @return The analysisConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig getAnalysisConfig() {
      if (analysisConfigBuilder_ == null) {
        return analysisConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.getDefaultInstance()
            : analysisConfig_;
      } else {
        return analysisConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public Builder setAnalysisConfig(
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig value) {
      if (analysisConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        analysisConfig_ = value;
      } else {
        analysisConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public Builder setAnalysisConfig(
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder builderForValue) {
      if (analysisConfigBuilder_ == null) {
        analysisConfig_ = builderForValue.build();
      } else {
        analysisConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public Builder mergeAnalysisConfig(
        com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig value) {
      if (analysisConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && analysisConfig_ != null
            && analysisConfig_
                != com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig
                    .getDefaultInstance()) {
          getAnalysisConfigBuilder().mergeFrom(value);
        } else {
          analysisConfig_ = value;
        }
      } else {
        analysisConfigBuilder_.mergeFrom(value);
      }
      if (analysisConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public Builder clearAnalysisConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      analysisConfig_ = null;
      if (analysisConfigBuilder_ != null) {
        analysisConfigBuilder_.dispose();
        analysisConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder
        getAnalysisConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getAnalysisConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder
        getAnalysisConfigOrBuilder() {
      if (analysisConfigBuilder_ != null) {
        return analysisConfigBuilder_.getMessageOrBuilder();
      } else {
        return analysisConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.getDefaultInstance()
            : analysisConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Default analysis settings.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig analysis_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig,
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder>
        getAnalysisConfigFieldBuilder() {
      if (analysisConfigBuilder_ == null) {
        analysisConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig,
                com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.Settings.AnalysisConfigOrBuilder>(
                getAnalysisConfig(), getParentForChildren(), isClean());
        analysisConfig_ = null;
      }
      return analysisConfigBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.RedactionConfig redactionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RedactionConfig,
            com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>
        redactionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     *
     * @return Whether the redactionConfig field is set.
     */
    public boolean hasRedactionConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     *
     * @return The redactionConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfig getRedactionConfig() {
      if (redactionConfigBuilder_ == null) {
        return redactionConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
            : redactionConfig_;
      } else {
        return redactionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public Builder setRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig value) {
      if (redactionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        redactionConfig_ = value;
      } else {
        redactionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public Builder setRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder builderForValue) {
      if (redactionConfigBuilder_ == null) {
        redactionConfig_ = builderForValue.build();
      } else {
        redactionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public Builder mergeRedactionConfig(
        com.google.cloud.contactcenterinsights.v1.RedactionConfig value) {
      if (redactionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && redactionConfig_ != null
            && redactionConfig_
                != com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()) {
          getRedactionConfigBuilder().mergeFrom(value);
        } else {
          redactionConfig_ = value;
        }
      } else {
        redactionConfigBuilder_.mergeFrom(value);
      }
      if (redactionConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public Builder clearRedactionConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      redactionConfig_ = null;
      if (redactionConfigBuilder_ != null) {
        redactionConfigBuilder_.dispose();
        redactionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder
        getRedactionConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRedactionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    public com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder
        getRedactionConfigOrBuilder() {
      if (redactionConfigBuilder_ != null) {
        return redactionConfigBuilder_.getMessageOrBuilder();
      } else {
        return redactionConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.RedactionConfig.getDefaultInstance()
            : redactionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Default DLP redaction resources to be applied while ingesting
     * conversations. This applies to conversations ingested from the
     * `UploadConversation` and `IngestConversations` endpoints, including
     * conversations coming from CCAI Platform.
     * </pre>
     *
     * <code>.google.cloud.contactcenterinsights.v1.RedactionConfig redaction_config = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.RedactionConfig,
            com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>
        getRedactionConfigFieldBuilder() {
      if (redactionConfigBuilder_ == null) {
        redactionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.RedactionConfig,
                com.google.cloud.contactcenterinsights.v1.RedactionConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.RedactionConfigOrBuilder>(
                getRedactionConfig(), getParentForChildren(), isClean());
        redactionConfig_ = null;
      }
      return redactionConfigBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.SpeechConfig speechConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SpeechConfig,
            com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>
        speechConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the speechConfig field is set.
     */
    public boolean hasSpeechConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The speechConfig.
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfig getSpeechConfig() {
      if (speechConfigBuilder_ == null) {
        return speechConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      } else {
        return speechConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(com.google.cloud.contactcenterinsights.v1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        speechConfig_ = value;
      } else {
        speechConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSpeechConfig(
        com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder builderForValue) {
      if (speechConfigBuilder_ == null) {
        speechConfig_ = builderForValue.build();
      } else {
        speechConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSpeechConfig(com.google.cloud.contactcenterinsights.v1.SpeechConfig value) {
      if (speechConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && speechConfig_ != null
            && speechConfig_
                != com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()) {
          getSpeechConfigBuilder().mergeFrom(value);
        } else {
          speechConfig_ = value;
        }
      } else {
        speechConfigBuilder_.mergeFrom(value);
      }
      if (speechConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSpeechConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      speechConfig_ = null;
      if (speechConfigBuilder_ != null) {
        speechConfigBuilder_.dispose();
        speechConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder getSpeechConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getSpeechConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder
        getSpeechConfigOrBuilder() {
      if (speechConfigBuilder_ != null) {
        return speechConfigBuilder_.getMessageOrBuilder();
      } else {
        return speechConfig_ == null
            ? com.google.cloud.contactcenterinsights.v1.SpeechConfig.getDefaultInstance()
            : speechConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default Speech-to-Text resources to use while ingesting audio
     * files. Optional, CCAI Insights will create a default if not provided. This
     * applies to conversations ingested from the `UploadConversation` and
     * `IngestConversations` endpoints, including conversations coming from CCAI
     * Platform.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.SpeechConfig speech_config = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.SpeechConfig,
            com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
            com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>
        getSpeechConfigFieldBuilder() {
      if (speechConfigBuilder_ == null) {
        speechConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.SpeechConfig,
                com.google.cloud.contactcenterinsights.v1.SpeechConfig.Builder,
                com.google.cloud.contactcenterinsights.v1.SpeechConfigOrBuilder>(
                getSpeechConfig(), getParentForChildren(), isClean());
        speechConfig_ = null;
      }
      return speechConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.Settings)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.Settings)
  private static final com.google.cloud.contactcenterinsights.v1.Settings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.contactcenterinsights.v1.Settings();
  }

  public static com.google.cloud.contactcenterinsights.v1.Settings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Settings> PARSER =
      new com.google.protobuf.AbstractParser<Settings>() {
        @java.lang.Override
        public Settings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Settings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Settings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.Settings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
