/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.contactcenterinsights.v1;

/**
 *
 *
 * <pre>
 * Metadata for TuneQaScorecardRevision endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata}
 */
public final class TuneQaScorecardRevisionMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata)
    TuneQaScorecardRevisionMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TuneQaScorecardRevisionMetadata.newBuilder() to construct.
  private TuneQaScorecardRevisionMetadata(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TuneQaScorecardRevisionMetadata() {
    qaQuestionDatasetValidationResults_ = java.util.Collections.emptyList();
    qaQuestionDatasetTuningMetrics_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TuneQaScorecardRevisionMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
        .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.class,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.Builder
                .class);
  }

  public interface QaQuestionDatasetValidationResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The question.
     */
    java.lang.String getQuestion();
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for question.
     */
    com.google.protobuf.ByteString getQuestionBytes();

    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the datasetValidationWarnings.
     */
    java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        getDatasetValidationWarningsList();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return The count of datasetValidationWarnings.
     */
    int getDatasetValidationWarningsCount();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The datasetValidationWarnings at the given index.
     */
    com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning getDatasetValidationWarnings(
        int index);
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for datasetValidationWarnings.
     */
    java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList();
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
     */
    int getDatasetValidationWarningsValue(int index);

    /**
     *
     *
     * <pre>
     * The number of valid feedback labels in the question's dataset.
     * </pre>
     *
     * <code>int32 valid_feedback_labels_count = 3;</code>
     *
     * @return The validFeedbackLabelsCount.
     */
    int getValidFeedbackLabelsCount();
  }
  /**
   *
   *
   * <pre>
   * Contains validation results for a question in the tuning request.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult}
   */
  public static final class QaQuestionDatasetValidationResult
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult)
      QaQuestionDatasetValidationResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaQuestionDatasetValidationResult.newBuilder() to construct.
    private QaQuestionDatasetValidationResult(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaQuestionDatasetValidationResult() {
      question_ = "";
      datasetValidationWarnings_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaQuestionDatasetValidationResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult.class,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult.Builder.class);
    }

    public static final int QUESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object question_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The question.
     */
    @java.lang.Override
    public java.lang.String getQuestion() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        question_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for question.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQuestionBytes() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        question_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DATASET_VALIDATION_WARNINGS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> datasetValidationWarnings_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        datasetValidationWarnings_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer,
                com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>() {
              public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning convert(
                  java.lang.Integer from) {
                com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning result =
                    com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning.forNumber(
                        from);
                return result == null
                    ? com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
                        .UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the datasetValidationWarnings.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
        getDatasetValidationWarningsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>(
          datasetValidationWarnings_, datasetValidationWarnings_converter_);
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return The count of datasetValidationWarnings.
     */
    @java.lang.Override
    public int getDatasetValidationWarningsCount() {
      return datasetValidationWarnings_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The datasetValidationWarnings at the given index.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
        getDatasetValidationWarnings(int index) {
      return datasetValidationWarnings_converter_.convert(datasetValidationWarnings_.get(index));
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for datasetValidationWarnings.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList() {
      return datasetValidationWarnings_;
    }
    /**
     *
     *
     * <pre>
     * A list of any applicable data validation warnings about the question's
     * feedback labels.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
     */
    @java.lang.Override
    public int getDatasetValidationWarningsValue(int index) {
      return datasetValidationWarnings_.get(index);
    }

    private int datasetValidationWarningsMemoizedSerializedSize;

    public static final int VALID_FEEDBACK_LABELS_COUNT_FIELD_NUMBER = 3;
    private int validFeedbackLabelsCount_ = 0;
    /**
     *
     *
     * <pre>
     * The number of valid feedback labels in the question's dataset.
     * </pre>
     *
     * <code>int32 valid_feedback_labels_count = 3;</code>
     *
     * @return The validFeedbackLabelsCount.
     */
    @java.lang.Override
    public int getValidFeedbackLabelsCount() {
      return validFeedbackLabelsCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, question_);
      }
      if (getDatasetValidationWarningsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(datasetValidationWarningsMemoizedSerializedSize);
      }
      for (int i = 0; i < datasetValidationWarnings_.size(); i++) {
        output.writeEnumNoTag(datasetValidationWarnings_.get(i));
      }
      if (validFeedbackLabelsCount_ != 0) {
        output.writeInt32(3, validFeedbackLabelsCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, question_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < datasetValidationWarnings_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                  datasetValidationWarnings_.get(i));
        }
        size += dataSize;
        if (!getDatasetValidationWarningsList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        datasetValidationWarningsMemoizedSerializedSize = dataSize;
      }
      if (validFeedbackLabelsCount_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(3, validFeedbackLabelsCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult
          other =
              (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetValidationResult)
                  obj;

      if (!getQuestion().equals(other.getQuestion())) return false;
      if (!datasetValidationWarnings_.equals(other.datasetValidationWarnings_)) return false;
      if (getValidFeedbackLabelsCount() != other.getValidFeedbackLabelsCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QUESTION_FIELD_NUMBER;
      hash = (53 * hash) + getQuestion().hashCode();
      if (getDatasetValidationWarningsCount() > 0) {
        hash = (37 * hash) + DATASET_VALIDATION_WARNINGS_FIELD_NUMBER;
        hash = (53 * hash) + datasetValidationWarnings_.hashCode();
      }
      hash = (37 * hash) + VALID_FEEDBACK_LABELS_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getValidFeedbackLabelsCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains validation results for a question in the tuning request.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult)
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult.class,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        question_ = "";
        datasetValidationWarnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        validFeedbackLabelsCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetValidationResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult
          build() {
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            result =
                new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult
              result) {
        if (((bitField0_ & 0x00000002) != 0)) {
          datasetValidationWarnings_ =
              java.util.Collections.unmodifiableList(datasetValidationWarnings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.datasetValidationWarnings_ = datasetValidationWarnings_;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.question_ = question_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.validFeedbackLabelsCount_ = validFeedbackLabelsCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetValidationResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.getDefaultInstance()) return this;
        if (!other.getQuestion().isEmpty()) {
          question_ = other.question_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.datasetValidationWarnings_.isEmpty()) {
          if (datasetValidationWarnings_.isEmpty()) {
            datasetValidationWarnings_ = other.datasetValidationWarnings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDatasetValidationWarningsIsMutable();
            datasetValidationWarnings_.addAll(other.datasetValidationWarnings_);
          }
          onChanged();
        }
        if (other.getValidFeedbackLabelsCount() != 0) {
          setValidFeedbackLabelsCount(other.getValidFeedbackLabelsCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  question_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  int tmpRaw = input.readEnum();
                  ensureDatasetValidationWarningsIsMutable();
                  datasetValidationWarnings_.add(tmpRaw);
                  break;
                } // case 16
              case 18:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureDatasetValidationWarningsIsMutable();
                    datasetValidationWarnings_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 18
              case 24:
                {
                  validFeedbackLabelsCount_ = input.readInt32();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object question_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The question.
       */
      public java.lang.String getQuestion() {
        java.lang.Object ref = question_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          question_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for question.
       */
      public com.google.protobuf.ByteString getQuestionBytes() {
        java.lang.Object ref = question_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          question_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        question_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuestion() {
        question_ = getDefaultInstance().getQuestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        question_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> datasetValidationWarnings_ =
          java.util.Collections.emptyList();

      private void ensureDatasetValidationWarningsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          datasetValidationWarnings_ =
              new java.util.ArrayList<java.lang.Integer>(datasetValidationWarnings_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return A list containing the datasetValidationWarnings.
       */
      public java.util.List<com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
          getDatasetValidationWarningsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>(
            datasetValidationWarnings_, datasetValidationWarnings_converter_);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return The count of datasetValidationWarnings.
       */
      public int getDatasetValidationWarningsCount() {
        return datasetValidationWarnings_.size();
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index of the element to return.
       * @return The datasetValidationWarnings at the given index.
       */
      public com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning
          getDatasetValidationWarnings(int index) {
        return datasetValidationWarnings_converter_.convert(datasetValidationWarnings_.get(index));
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The datasetValidationWarnings to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetValidationWarnings(
          int index, com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param value The datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addDatasetValidationWarnings(
          com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param values The datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addAllDatasetValidationWarnings(
          java.lang.Iterable<
                  ? extends com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning>
              values) {
        ensureDatasetValidationWarningsIsMutable();
        for (com.google.cloud.contactcenterinsights.v1.DatasetValidationWarning value : values) {
          datasetValidationWarnings_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDatasetValidationWarnings() {
        datasetValidationWarnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @return A list containing the enum numeric values on the wire for
       *     datasetValidationWarnings.
       */
      public java.util.List<java.lang.Integer> getDatasetValidationWarningsValueList() {
        return java.util.Collections.unmodifiableList(datasetValidationWarnings_);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of datasetValidationWarnings at the given index.
       */
      public int getDatasetValidationWarningsValue(int index) {
        return datasetValidationWarnings_.get(index);
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for datasetValidationWarnings to set.
       * @return This builder for chaining.
       */
      public Builder setDatasetValidationWarningsValue(int index, int value) {
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addDatasetValidationWarningsValue(int value) {
        ensureDatasetValidationWarningsIsMutable();
        datasetValidationWarnings_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of any applicable data validation warnings about the question's
       * feedback labels.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.contactcenterinsights.v1.DatasetValidationWarning dataset_validation_warnings = 2;
       * </code>
       *
       * @param values The enum numeric values on the wire for datasetValidationWarnings to add.
       * @return This builder for chaining.
       */
      public Builder addAllDatasetValidationWarningsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureDatasetValidationWarningsIsMutable();
        for (int value : values) {
          datasetValidationWarnings_.add(value);
        }
        onChanged();
        return this;
      }

      private int validFeedbackLabelsCount_;
      /**
       *
       *
       * <pre>
       * The number of valid feedback labels in the question's dataset.
       * </pre>
       *
       * <code>int32 valid_feedback_labels_count = 3;</code>
       *
       * @return The validFeedbackLabelsCount.
       */
      @java.lang.Override
      public int getValidFeedbackLabelsCount() {
        return validFeedbackLabelsCount_;
      }
      /**
       *
       *
       * <pre>
       * The number of valid feedback labels in the question's dataset.
       * </pre>
       *
       * <code>int32 valid_feedback_labels_count = 3;</code>
       *
       * @param value The validFeedbackLabelsCount to set.
       * @return This builder for chaining.
       */
      public Builder setValidFeedbackLabelsCount(int value) {

        validFeedbackLabelsCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of valid feedback labels in the question's dataset.
       * </pre>
       *
       * <code>int32 valid_feedback_labels_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValidFeedbackLabelsCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        validFeedbackLabelsCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult)
    private static final com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult();
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaQuestionDatasetValidationResult> PARSER =
        new com.google.protobuf.AbstractParser<QaQuestionDatasetValidationResult>() {
          @java.lang.Override
          public QaQuestionDatasetValidationResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaQuestionDatasetValidationResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaQuestionDatasetValidationResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface QaQuestionDatasetTuningMetricsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The question.
     */
    java.lang.String getQuestion();
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for question.
     */
    com.google.protobuf.ByteString getQuestionBytes();

    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metrics field is set.
     */
    boolean hasMetrics();
    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metrics.
     */
    com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Metrics
        getMetrics();
    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.MetricsOrBuilder
        getMetricsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Contains performance metrics for each QaQuestion in the
   * TuneScorecardRevision request.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics}
   */
  public static final class QaQuestionDatasetTuningMetrics
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics)
      QaQuestionDatasetTuningMetricsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use QaQuestionDatasetTuningMetrics.newBuilder() to construct.
    private QaQuestionDatasetTuningMetrics(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private QaQuestionDatasetTuningMetrics() {
      question_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new QaQuestionDatasetTuningMetrics();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.class,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Builder.class);
    }

    public interface MetricsOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Accuracy of the question's dataset.
       * </pre>
       *
       * <code>double accuracy = 1;</code>
       *
       * @return The accuracy.
       */
      double getAccuracy();
    }
    /**
     *
     *
     * <pre>
     * Performance metrics for the question's dataset calculated over the tuned
     * model.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics}
     */
    public static final class Metrics extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics)
        MetricsOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Metrics.newBuilder() to construct.
      private Metrics(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Metrics() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Metrics();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Metrics.class,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Metrics.Builder.class);
      }

      public static final int ACCURACY_FIELD_NUMBER = 1;
      private double accuracy_ = 0D;
      /**
       *
       *
       * <pre>
       * Accuracy of the question's dataset.
       * </pre>
       *
       * <code>double accuracy = 1;</code>
       *
       * @return The accuracy.
       */
      @java.lang.Override
      public double getAccuracy() {
        return accuracy_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Double.doubleToRawLongBits(accuracy_) != 0) {
          output.writeDouble(1, accuracy_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Double.doubleToRawLongBits(accuracy_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, accuracy_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics)) {
          return super.equals(obj);
        }
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics
            other =
                (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetTuningMetrics.Metrics)
                    obj;

        if (java.lang.Double.doubleToLongBits(getAccuracy())
            != java.lang.Double.doubleToLongBits(other.getAccuracy())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + ACCURACY_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getAccuracy()));
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Performance metrics for the question's dataset calculated over the tuned
       * model.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics)
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.MetricsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics.class,
                  com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics.Builder.class);
        }

        // Construct using
        // com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          accuracy_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
              .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_Metrics_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics
            getDefaultInstanceForType() {
          return com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics
            build() {
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics
            buildPartial() {
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics
              result =
                  new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Metrics
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.accuracy_ = accuracy_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics) {
            return mergeFrom(
                (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetTuningMetrics.Metrics)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Metrics
                other) {
          if (other
              == com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()) return this;
          if (other.getAccuracy() != 0D) {
            setAccuracy(other.getAccuracy());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    accuracy_ = input.readDouble();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 9
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private double accuracy_;
        /**
         *
         *
         * <pre>
         * Accuracy of the question's dataset.
         * </pre>
         *
         * <code>double accuracy = 1;</code>
         *
         * @return The accuracy.
         */
        @java.lang.Override
        public double getAccuracy() {
          return accuracy_;
        }
        /**
         *
         *
         * <pre>
         * Accuracy of the question's dataset.
         * </pre>
         *
         * <code>double accuracy = 1;</code>
         *
         * @param value The accuracy to set.
         * @return This builder for chaining.
         */
        public Builder setAccuracy(double value) {

          accuracy_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Accuracy of the question's dataset.
         * </pre>
         *
         * <code>double accuracy = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAccuracy() {
          bitField0_ = (bitField0_ & ~0x00000001);
          accuracy_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics)
      private static final com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Metrics();
      }

      public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Metrics> PARSER =
          new com.google.protobuf.AbstractParser<Metrics>() {
            @java.lang.Override
            public Metrics parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Metrics> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Metrics> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int QUESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object question_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The question.
     */
    @java.lang.Override
    public java.lang.String getQuestion() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        question_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource path of the question whose dataset was
     * evaluated for tuning.
     * </pre>
     *
     * <code>
     * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for question.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getQuestionBytes() {
      java.lang.Object ref = question_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        question_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRICS_FIELD_NUMBER = 2;
    private com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Metrics
        metrics_;
    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metrics field is set.
     */
    @java.lang.Override
    public boolean hasMetrics() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metrics.
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Metrics
        getMetrics() {
      return metrics_ == null
          ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()
          : metrics_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for the question's dataset.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.MetricsOrBuilder
        getMetricsOrBuilder() {
      return metrics_ == null
          ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()
          : metrics_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, question_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getMetrics());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(question_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, question_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMetrics());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics)) {
        return super.equals(obj);
      }
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics
          other =
              (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics)
                  obj;

      if (!getQuestion().equals(other.getQuestion())) return false;
      if (hasMetrics() != other.hasMetrics()) return false;
      if (hasMetrics()) {
        if (!getMetrics().equals(other.getMetrics())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + QUESTION_FIELD_NUMBER;
      hash = (53 * hash) + getQuestion().hashCode();
      if (hasMetrics()) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetrics().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Contains performance metrics for each QaQuestion in the
     * TuneScorecardRevision request.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics)
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetricsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.class,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Builder.class);
      }

      // Construct using
      // com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetricsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        question_ = "";
        metrics_ = null;
        if (metricsBuilder_ != null) {
          metricsBuilder_.dispose();
          metricsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
            .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_QaQuestionDatasetTuningMetrics_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics
          getDefaultInstanceForType() {
        return com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics
          build() {
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics
          buildPartial() {
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            result =
                new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.question_ = question_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.metrics_ = metricsBuilder_ == null ? metrics_ : metricsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics) {
          return mergeFrom(
              (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics
              other) {
        if (other
            == com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.getDefaultInstance()) return this;
        if (!other.getQuestion().isEmpty()) {
          question_ = other.question_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasMetrics()) {
          mergeMetrics(other.getMetrics());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  question_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getMetricsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object question_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The question.
       */
      public java.lang.String getQuestion() {
        java.lang.Object ref = question_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          question_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for question.
       */
      public com.google.protobuf.ByteString getQuestionBytes() {
        java.lang.Object ref = question_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          question_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        question_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearQuestion() {
        question_ = getDefaultInstance().getQuestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource path of the question whose dataset was
       * evaluated for tuning.
       * </pre>
       *
       * <code>
       * string question = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for question to set.
       * @return This builder for chaining.
       */
      public Builder setQuestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        question_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          metrics_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.Builder,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.MetricsOrBuilder>
          metricsBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the metrics field is set.
       */
      public boolean hasMetrics() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The metrics.
       */
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics
          getMetrics() {
        if (metricsBuilder_ == null) {
          return metrics_ == null
              ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()
              : metrics_;
        } else {
          return metricsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMetrics(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics
              value) {
        if (metricsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metrics_ = value;
        } else {
          metricsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMetrics(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.Builder
              builderForValue) {
        if (metricsBuilder_ == null) {
          metrics_ = builderForValue.build();
        } else {
          metricsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeMetrics(
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics
              value) {
        if (metricsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && metrics_ != null
              && metrics_
                  != com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()) {
            getMetricsBuilder().mergeFrom(value);
          } else {
            metrics_ = value;
          }
        } else {
          metricsBuilder_.mergeFrom(value);
        }
        if (metrics_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearMetrics() {
        bitField0_ = (bitField0_ & ~0x00000002);
        metrics_ = null;
        if (metricsBuilder_ != null) {
          metricsBuilder_.dispose();
          metricsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.Metrics.Builder
          getMetricsBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMetricsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics.MetricsOrBuilder
          getMetricsOrBuilder() {
        if (metricsBuilder_ != null) {
          return metricsBuilder_.getMessageOrBuilder();
        } else {
          return metrics_ == null
              ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.getDefaultInstance()
              : metrics_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The metrics for the question's dataset.
       * </pre>
       *
       * <code>
       * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics.Metrics metrics = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.Metrics.Builder,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.MetricsOrBuilder>
          getMetricsFieldBuilder() {
        if (metricsBuilder_ == null) {
          metricsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics,
                  com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.Metrics.Builder,
                  com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                      .QaQuestionDatasetTuningMetrics.MetricsOrBuilder>(
                  getMetrics(), getParentForChildren(), isClean());
          metrics_ = null;
        }
        return metricsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics)
    private static final com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics();
    }

    public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QaQuestionDatasetTuningMetrics> PARSER =
        new com.google.protobuf.AbstractParser<QaQuestionDatasetTuningMetrics>() {
          @java.lang.Override
          public QaQuestionDatasetTuningMetrics parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<QaQuestionDatasetTuningMetrics> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QaQuestionDatasetTuningMetrics> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int CREATE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the operation finished running.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request_;
  /**
   *
   *
   * <pre>
   * Output only. The original request.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest getRequest() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
            .getDefaultInstance()
        : request_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The original request.
   * </pre>
   *
   * <code>
   * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequestOrBuilder
      getRequestOrBuilder() {
    return request_ == null
        ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
            .getDefaultInstance()
        : request_;
  }

  public static final int QA_QUESTION_DATASET_VALIDATION_RESULTS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult>
      qaQuestionDatasetValidationResults_;
  /**
   *
   *
   * <pre>
   * Output only. The results of data validation per question in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetValidationResult>
      getQaQuestionDatasetValidationResultsList() {
    return qaQuestionDatasetValidationResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The results of data validation per question in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResultOrBuilder>
      getQaQuestionDatasetValidationResultsOrBuilderList() {
    return qaQuestionDatasetValidationResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The results of data validation per question in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getQaQuestionDatasetValidationResultsCount() {
    return qaQuestionDatasetValidationResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The results of data validation per question in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
          .QaQuestionDatasetValidationResult
      getQaQuestionDatasetValidationResults(int index) {
    return qaQuestionDatasetValidationResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The results of data validation per question in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
          .QaQuestionDatasetValidationResultOrBuilder
      getQaQuestionDatasetValidationResultsOrBuilder(int index) {
    return qaQuestionDatasetValidationResults_.get(index);
  }

  public static final int QA_QUESTION_DATASET_TUNING_METRICS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics>
      qaQuestionDatasetTuningMetrics_;
  /**
   *
   *
   * <pre>
   * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .QaQuestionDatasetTuningMetrics>
      getQaQuestionDatasetTuningMetricsList() {
    return qaQuestionDatasetTuningMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetricsOrBuilder>
      getQaQuestionDatasetTuningMetricsOrBuilderList() {
    return qaQuestionDatasetTuningMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getQaQuestionDatasetTuningMetricsCount() {
    return qaQuestionDatasetTuningMetrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
          .QaQuestionDatasetTuningMetrics
      getQaQuestionDatasetTuningMetrics(int index) {
    return qaQuestionDatasetTuningMetrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
   * request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
          .QaQuestionDatasetTuningMetricsOrBuilder
      getQaQuestionDatasetTuningMetricsOrBuilder(int index) {
    return qaQuestionDatasetTuningMetrics_.get(index);
  }

  public static final int TUNING_COMPLETION_RATIO_FIELD_NUMBER = 6;
  private double tuningCompletionRatio_ = 0D;
  /**
   *
   *
   * <pre>
   * Output only. The percentage of the tuning job that has completed. Always
   * between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
   * indicates the job has completed i.e. 100%.
   * </pre>
   *
   * <code>double tuning_completion_ratio = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The tuningCompletionRatio.
   */
  @java.lang.Override
  public double getTuningCompletionRatio() {
    return tuningCompletionRatio_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getRequest());
    }
    for (int i = 0; i < qaQuestionDatasetValidationResults_.size(); i++) {
      output.writeMessage(4, qaQuestionDatasetValidationResults_.get(i));
    }
    for (int i = 0; i < qaQuestionDatasetTuningMetrics_.size(); i++) {
      output.writeMessage(5, qaQuestionDatasetTuningMetrics_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(tuningCompletionRatio_) != 0) {
      output.writeDouble(6, tuningCompletionRatio_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEndTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    for (int i = 0; i < qaQuestionDatasetValidationResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, qaQuestionDatasetValidationResults_.get(i));
    }
    for (int i = 0; i < qaQuestionDatasetTuningMetrics_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, qaQuestionDatasetTuningMetrics_.get(i));
    }
    if (java.lang.Double.doubleToRawLongBits(tuningCompletionRatio_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(6, tuningCompletionRatio_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata other =
        (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata) obj;

    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (!getQaQuestionDatasetValidationResultsList()
        .equals(other.getQaQuestionDatasetValidationResultsList())) return false;
    if (!getQaQuestionDatasetTuningMetricsList()
        .equals(other.getQaQuestionDatasetTuningMetricsList())) return false;
    if (java.lang.Double.doubleToLongBits(getTuningCompletionRatio())
        != java.lang.Double.doubleToLongBits(other.getTuningCompletionRatio())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    if (getQaQuestionDatasetValidationResultsCount() > 0) {
      hash = (37 * hash) + QA_QUESTION_DATASET_VALIDATION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getQaQuestionDatasetValidationResultsList().hashCode();
    }
    if (getQaQuestionDatasetTuningMetricsCount() > 0) {
      hash = (37 * hash) + QA_QUESTION_DATASET_TUNING_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getQaQuestionDatasetTuningMetricsList().hashCode();
    }
    hash = (37 * hash) + TUNING_COMPLETION_RATIO_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getTuningCompletionRatio()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata for TuneQaScorecardRevision endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata)
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.class,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getEndTimeFieldBuilder();
        getRequestFieldBuilder();
        getQaQuestionDatasetValidationResultsFieldBuilder();
        getQaQuestionDatasetTuningMetricsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        qaQuestionDatasetValidationResults_ = java.util.Collections.emptyList();
      } else {
        qaQuestionDatasetValidationResults_ = null;
        qaQuestionDatasetValidationResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        qaQuestionDatasetTuningMetrics_ = java.util.Collections.emptyList();
      } else {
        qaQuestionDatasetTuningMetrics_ = null;
        qaQuestionDatasetTuningMetricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      tuningCompletionRatio_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.contactcenterinsights.v1.ContactCenterInsightsProto
          .internal_static_google_cloud_contactcenterinsights_v1_TuneQaScorecardRevisionMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata build() {
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
        buildPartial() {
      com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata result =
          new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata result) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          qaQuestionDatasetValidationResults_ =
              java.util.Collections.unmodifiableList(qaQuestionDatasetValidationResults_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.qaQuestionDatasetValidationResults_ = qaQuestionDatasetValidationResults_;
      } else {
        result.qaQuestionDatasetValidationResults_ =
            qaQuestionDatasetValidationResultsBuilder_.build();
      }
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          qaQuestionDatasetTuningMetrics_ =
              java.util.Collections.unmodifiableList(qaQuestionDatasetTuningMetrics_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.qaQuestionDatasetTuningMetrics_ = qaQuestionDatasetTuningMetrics_;
      } else {
        result.qaQuestionDatasetTuningMetrics_ = qaQuestionDatasetTuningMetricsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.tuningCompletionRatio_ = tuningCompletionRatio_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata) {
        return mergeFrom(
            (com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata other) {
      if (other
          == com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
              .getDefaultInstance()) return this;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        if (!other.qaQuestionDatasetValidationResults_.isEmpty()) {
          if (qaQuestionDatasetValidationResults_.isEmpty()) {
            qaQuestionDatasetValidationResults_ = other.qaQuestionDatasetValidationResults_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureQaQuestionDatasetValidationResultsIsMutable();
            qaQuestionDatasetValidationResults_.addAll(other.qaQuestionDatasetValidationResults_);
          }
          onChanged();
        }
      } else {
        if (!other.qaQuestionDatasetValidationResults_.isEmpty()) {
          if (qaQuestionDatasetValidationResultsBuilder_.isEmpty()) {
            qaQuestionDatasetValidationResultsBuilder_.dispose();
            qaQuestionDatasetValidationResultsBuilder_ = null;
            qaQuestionDatasetValidationResults_ = other.qaQuestionDatasetValidationResults_;
            bitField0_ = (bitField0_ & ~0x00000008);
            qaQuestionDatasetValidationResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQaQuestionDatasetValidationResultsFieldBuilder()
                    : null;
          } else {
            qaQuestionDatasetValidationResultsBuilder_.addAllMessages(
                other.qaQuestionDatasetValidationResults_);
          }
        }
      }
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        if (!other.qaQuestionDatasetTuningMetrics_.isEmpty()) {
          if (qaQuestionDatasetTuningMetrics_.isEmpty()) {
            qaQuestionDatasetTuningMetrics_ = other.qaQuestionDatasetTuningMetrics_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureQaQuestionDatasetTuningMetricsIsMutable();
            qaQuestionDatasetTuningMetrics_.addAll(other.qaQuestionDatasetTuningMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.qaQuestionDatasetTuningMetrics_.isEmpty()) {
          if (qaQuestionDatasetTuningMetricsBuilder_.isEmpty()) {
            qaQuestionDatasetTuningMetricsBuilder_.dispose();
            qaQuestionDatasetTuningMetricsBuilder_ = null;
            qaQuestionDatasetTuningMetrics_ = other.qaQuestionDatasetTuningMetrics_;
            bitField0_ = (bitField0_ & ~0x00000010);
            qaQuestionDatasetTuningMetricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getQaQuestionDatasetTuningMetricsFieldBuilder()
                    : null;
          } else {
            qaQuestionDatasetTuningMetricsBuilder_.addAllMessages(
                other.qaQuestionDatasetTuningMetrics_);
          }
        }
      }
      if (other.getTuningCompletionRatio() != 0D) {
        setTuningCompletionRatio(other.getTuningCompletionRatio());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetValidationResult
                    m =
                        input.readMessage(
                            com.google.cloud.contactcenterinsights.v1
                                .TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult
                                .parser(),
                            extensionRegistry);
                if (qaQuestionDatasetValidationResultsBuilder_ == null) {
                  ensureQaQuestionDatasetValidationResultsIsMutable();
                  qaQuestionDatasetValidationResults_.add(m);
                } else {
                  qaQuestionDatasetValidationResultsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetTuningMetrics
                    m =
                        input.readMessage(
                            com.google.cloud.contactcenterinsights.v1
                                .TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics
                                .parser(),
                            extensionRegistry);
                if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
                  ensureQaQuestionDatasetTuningMetricsIsMutable();
                  qaQuestionDatasetTuningMetrics_.add(m);
                } else {
                  qaQuestionDatasetTuningMetricsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 49:
              {
                tuningCompletionRatio_ = input.readDouble();
                bitField0_ |= 0x00000020;
                break;
              } // case 49
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      if (endTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the operation finished running.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequestOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The request.
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
                .getDefaultInstance()
            : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRequest(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest.Builder
            builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRequest(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_
                != com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
                    .getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest.Builder
        getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequestOrBuilder
        getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null
            ? com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest
                .getDefaultInstance()
            : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The original request.
     * </pre>
     *
     * <code>
     * .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest request = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequestOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequest.Builder,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionRequestOrBuilder>(
                getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult>
        qaQuestionDatasetValidationResults_ = java.util.Collections.emptyList();

    private void ensureQaQuestionDatasetValidationResultsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        qaQuestionDatasetValidationResults_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult>(qaQuestionDatasetValidationResults_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResultOrBuilder>
        qaQuestionDatasetValidationResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult>
        getQaQuestionDatasetValidationResultsList() {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(qaQuestionDatasetValidationResults_);
      } else {
        return qaQuestionDatasetValidationResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getQaQuestionDatasetValidationResultsCount() {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        return qaQuestionDatasetValidationResults_.size();
      } else {
        return qaQuestionDatasetValidationResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult
        getQaQuestionDatasetValidationResults(int index) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        return qaQuestionDatasetValidationResults_.get(index);
      } else {
        return qaQuestionDatasetValidationResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDatasetValidationResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            value) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.set(index, value);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDatasetValidationResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder
            builderForValue) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetValidationResults(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            value) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.add(value);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetValidationResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult
            value) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.add(index, value);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetValidationResults(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder
            builderForValue) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.add(builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetValidationResults(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder
            builderForValue) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllQaQuestionDatasetValidationResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetValidationResult>
            values) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        ensureQaQuestionDatasetValidationResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, qaQuestionDatasetValidationResults_);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQaQuestionDatasetValidationResults() {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        qaQuestionDatasetValidationResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeQaQuestionDatasetValidationResults(int index) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        ensureQaQuestionDatasetValidationResultsIsMutable();
        qaQuestionDatasetValidationResults_.remove(index);
        onChanged();
      } else {
        qaQuestionDatasetValidationResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult.Builder
        getQaQuestionDatasetValidationResultsBuilder(int index) {
      return getQaQuestionDatasetValidationResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResultOrBuilder
        getQaQuestionDatasetValidationResultsOrBuilder(int index) {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        return qaQuestionDatasetValidationResults_.get(index);
      } else {
        return qaQuestionDatasetValidationResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResultOrBuilder>
        getQaQuestionDatasetValidationResultsOrBuilderList() {
      if (qaQuestionDatasetValidationResultsBuilder_ != null) {
        return qaQuestionDatasetValidationResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(qaQuestionDatasetValidationResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult.Builder
        addQaQuestionDatasetValidationResultsBuilder() {
      return getQaQuestionDatasetValidationResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetValidationResult.Builder
        addQaQuestionDatasetValidationResultsBuilder(int index) {
      return getQaQuestionDatasetValidationResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetValidationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The results of data validation per question in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetValidationResult qa_question_dataset_validation_results = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder>
        getQaQuestionDatasetValidationResultsBuilderList() {
      return getQaQuestionDatasetValidationResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResult.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetValidationResultOrBuilder>
        getQaQuestionDatasetValidationResultsFieldBuilder() {
      if (qaQuestionDatasetValidationResultsBuilder_ == null) {
        qaQuestionDatasetValidationResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResult.Builder,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetValidationResultOrBuilder>(
                qaQuestionDatasetValidationResults_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        qaQuestionDatasetValidationResults_ = null;
      }
      return qaQuestionDatasetValidationResultsBuilder_;
    }

    private java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics>
        qaQuestionDatasetTuningMetrics_ = java.util.Collections.emptyList();

    private void ensureQaQuestionDatasetTuningMetricsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        qaQuestionDatasetTuningMetrics_ =
            new java.util.ArrayList<
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics>(qaQuestionDatasetTuningMetrics_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetricsOrBuilder>
        qaQuestionDatasetTuningMetricsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics>
        getQaQuestionDatasetTuningMetricsList() {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(qaQuestionDatasetTuningMetrics_);
      } else {
        return qaQuestionDatasetTuningMetricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getQaQuestionDatasetTuningMetricsCount() {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        return qaQuestionDatasetTuningMetrics_.size();
      } else {
        return qaQuestionDatasetTuningMetricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics
        getQaQuestionDatasetTuningMetrics(int index) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        return qaQuestionDatasetTuningMetrics_.get(index);
      } else {
        return qaQuestionDatasetTuningMetricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDatasetTuningMetrics(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            value) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.set(index, value);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setQaQuestionDatasetTuningMetrics(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder
            builderForValue) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetTuningMetrics(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            value) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.add(value);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetTuningMetrics(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics
            value) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.add(index, value);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetTuningMetrics(
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder
            builderForValue) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addQaQuestionDatasetTuningMetrics(
        int index,
        com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder
            builderForValue) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllQaQuestionDatasetTuningMetrics(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                        .QaQuestionDatasetTuningMetrics>
            values) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, qaQuestionDatasetTuningMetrics_);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearQaQuestionDatasetTuningMetrics() {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        qaQuestionDatasetTuningMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeQaQuestionDatasetTuningMetrics(int index) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        ensureQaQuestionDatasetTuningMetricsIsMutable();
        qaQuestionDatasetTuningMetrics_.remove(index);
        onChanged();
      } else {
        qaQuestionDatasetTuningMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Builder
        getQaQuestionDatasetTuningMetricsBuilder(int index) {
      return getQaQuestionDatasetTuningMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetricsOrBuilder
        getQaQuestionDatasetTuningMetricsOrBuilder(int index) {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        return qaQuestionDatasetTuningMetrics_.get(index);
      } else {
        return qaQuestionDatasetTuningMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetricsOrBuilder>
        getQaQuestionDatasetTuningMetricsOrBuilderList() {
      if (qaQuestionDatasetTuningMetricsBuilder_ != null) {
        return qaQuestionDatasetTuningMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(qaQuestionDatasetTuningMetrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Builder
        addQaQuestionDatasetTuningMetricsBuilder() {
      return getQaQuestionDatasetTuningMetricsFieldBuilder()
          .addBuilder(
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
            .QaQuestionDatasetTuningMetrics.Builder
        addQaQuestionDatasetTuningMetricsBuilder(int index) {
      return getQaQuestionDatasetTuningMetricsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                  .QaQuestionDatasetTuningMetrics.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The metrics for each QaQuestion in the TuneScorecardRevision
     * request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata.QaQuestionDatasetTuningMetrics qa_question_dataset_tuning_metrics = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder>
        getQaQuestionDatasetTuningMetricsBuilderList() {
      return getQaQuestionDatasetTuningMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetrics.Builder,
            com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                .QaQuestionDatasetTuningMetricsOrBuilder>
        getQaQuestionDatasetTuningMetricsFieldBuilder() {
      if (qaQuestionDatasetTuningMetricsBuilder_ == null) {
        qaQuestionDatasetTuningMetricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetrics.Builder,
                com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
                    .QaQuestionDatasetTuningMetricsOrBuilder>(
                qaQuestionDatasetTuningMetrics_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        qaQuestionDatasetTuningMetrics_ = null;
      }
      return qaQuestionDatasetTuningMetricsBuilder_;
    }

    private double tuningCompletionRatio_;
    /**
     *
     *
     * <pre>
     * Output only. The percentage of the tuning job that has completed. Always
     * between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
     * indicates the job has completed i.e. 100%.
     * </pre>
     *
     * <code>double tuning_completion_ratio = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The tuningCompletionRatio.
     */
    @java.lang.Override
    public double getTuningCompletionRatio() {
      return tuningCompletionRatio_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The percentage of the tuning job that has completed. Always
     * between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
     * indicates the job has completed i.e. 100%.
     * </pre>
     *
     * <code>double tuning_completion_ratio = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The tuningCompletionRatio to set.
     * @return This builder for chaining.
     */
    public Builder setTuningCompletionRatio(double value) {

      tuningCompletionRatio_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The percentage of the tuning job that has completed. Always
     * between 0 and 1 where 0 indicates the job has not started i.e. 0% and 1
     * indicates the job has completed i.e. 100%.
     * </pre>
     *
     * <code>double tuning_completion_ratio = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTuningCompletionRatio() {
      bitField0_ = (bitField0_ & ~0x00000020);
      tuningCompletionRatio_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata)
  private static final com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata();
  }

  public static com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TuneQaScorecardRevisionMetadata> PARSER =
      new com.google.protobuf.AbstractParser<TuneQaScorecardRevisionMetadata>() {
        @java.lang.Override
        public TuneQaScorecardRevisionMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TuneQaScorecardRevisionMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TuneQaScorecardRevisionMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.contactcenterinsights.v1.TuneQaScorecardRevisionMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
