/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnalysisRuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ANALYSIS_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/analysisRules/{analysis_rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String analysisRule;

    @Deprecated
    protected AnalysisRuleName() {
        this.project = null;
        this.location = null;
        this.analysisRule = null;
    }

    private AnalysisRuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.analysisRule = (String)Preconditions.checkNotNull((Object)builder.getAnalysisRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAnalysisRule() {
        return this.analysisRule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnalysisRuleName of(String project, String location, String analysisRule) {
        return AnalysisRuleName.newBuilder().setProject(project).setLocation(location).setAnalysisRule(analysisRule).build();
    }

    public static String format(String project, String location, String analysisRule) {
        return AnalysisRuleName.newBuilder().setProject(project).setLocation(location).setAnalysisRule(analysisRule).build().toString();
    }

    public static AnalysisRuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ANALYSIS_RULE.validatedMatch(formattedString, "AnalysisRuleName.parse: formattedString not in valid format");
        return AnalysisRuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("analysis_rule"));
    }

    public static List<AnalysisRuleName> parseList(List<String> formattedStrings) {
        ArrayList<AnalysisRuleName> list = new ArrayList<AnalysisRuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnalysisRuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnalysisRuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnalysisRuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ANALYSIS_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnalysisRuleName analysisRuleName = this;
            synchronized (analysisRuleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.analysisRule != null) {
                        fieldMapBuilder.put((Object)"analysis_rule", (Object)this.analysisRule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ANALYSIS_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "analysis_rule", this.analysisRule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AnalysisRuleName that = (AnalysisRuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.analysisRule, that.analysisRule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.analysisRule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String analysisRule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAnalysisRule() {
            return this.analysisRule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAnalysisRule(String analysisRule) {
            this.analysisRule = analysisRule;
            return this;
        }

        private Builder(AnalysisRuleName analysisRuleName) {
            this.project = analysisRuleName.project;
            this.location = analysisRuleName.location;
            this.analysisRule = analysisRuleName.analysisRule;
        }

        public AnalysisRuleName build() {
            return new AnalysisRuleName(this);
        }
    }
}

