/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QaScorecardName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_QA_SCORECARD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/qaScorecards/{qa_scorecard}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String qaScorecard;

    @Deprecated
    protected QaScorecardName() {
        this.project = null;
        this.location = null;
        this.qaScorecard = null;
    }

    private QaScorecardName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.qaScorecard = (String)Preconditions.checkNotNull((Object)builder.getQaScorecard());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQaScorecard() {
        return this.qaScorecard;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static QaScorecardName of(String project, String location, String qaScorecard) {
        return QaScorecardName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).build();
    }

    public static String format(String project, String location, String qaScorecard) {
        return QaScorecardName.newBuilder().setProject(project).setLocation(location).setQaScorecard(qaScorecard).build().toString();
    }

    public static QaScorecardName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_QA_SCORECARD.validatedMatch(formattedString, "QaScorecardName.parse: formattedString not in valid format");
        return QaScorecardName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("qa_scorecard"));
    }

    public static List<QaScorecardName> parseList(List<String> formattedStrings) {
        ArrayList<QaScorecardName> list = new ArrayList<QaScorecardName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QaScorecardName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QaScorecardName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QaScorecardName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_QA_SCORECARD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QaScorecardName qaScorecardName = this;
            synchronized (qaScorecardName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.qaScorecard != null) {
                        fieldMapBuilder.put((Object)"qa_scorecard", (Object)this.qaScorecard);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_QA_SCORECARD.instantiate(new String[]{"project", this.project, "location", this.location, "qa_scorecard", this.qaScorecard});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            QaScorecardName that = (QaScorecardName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.qaScorecard, that.qaScorecard);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.qaScorecard);
    }

    public static class Builder {
        private String project;
        private String location;
        private String qaScorecard;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQaScorecard() {
            return this.qaScorecard;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQaScorecard(String qaScorecard) {
            this.qaScorecard = qaScorecard;
            return this;
        }

        private Builder(QaScorecardName qaScorecardName) {
            this.project = qaScorecardName.project;
            this.location = qaScorecardName.location;
            this.qaScorecard = qaScorecardName.qaScorecard;
        }

        public QaScorecardName build() {
            return new QaScorecardName(this);
        }
    }
}

