/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contactcenterinsights.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeedbackLabelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}");
    private static final PathTemplate PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_FEEDBACK_LABEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/authorizedViewSets/{authorized_view_set}/authorizedViews/{authorized_view}/conversations/{conversation}/feedbackLabels/{feedback_label}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String conversation;
    private final String feedbackLabel;
    private final String authorizedViewSet;
    private final String authorizedView;

    @Deprecated
    protected FeedbackLabelName() {
        this.project = null;
        this.location = null;
        this.conversation = null;
        this.feedbackLabel = null;
        this.authorizedViewSet = null;
        this.authorizedView = null;
    }

    private FeedbackLabelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.feedbackLabel = (String)Preconditions.checkNotNull((Object)builder.getFeedbackLabel());
        this.authorizedViewSet = null;
        this.authorizedView = null;
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL;
    }

    private FeedbackLabelName(ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.authorizedViewSet = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedViewSet());
        this.authorizedView = (String)Preconditions.checkNotNull((Object)builder.getAuthorizedView());
        this.conversation = (String)Preconditions.checkNotNull((Object)builder.getConversation());
        this.feedbackLabel = (String)Preconditions.checkNotNull((Object)builder.getFeedbackLabel());
        this.pathTemplate = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_FEEDBACK_LABEL;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getConversation() {
        return this.conversation;
    }

    public String getFeedbackLabel() {
        return this.feedbackLabel;
    }

    public String getAuthorizedViewSet() {
        return this.authorizedViewSet;
    }

    public String getAuthorizedView() {
        return this.authorizedView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationConversationFeedbackLabelBuilder() {
        return new Builder();
    }

    public static ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder newProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder() {
        return new ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeedbackLabelName of(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build();
    }

    public static FeedbackLabelName ofProjectLocationConversationFeedbackLabelName(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build();
    }

    public static FeedbackLabelName ofProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelName(String project, String location, String authorizedViewSet, String authorizedView, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).setFeedbackLabel(feedbackLabel).build();
    }

    public static String format(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build().toString();
    }

    public static String formatProjectLocationConversationFeedbackLabelName(String project, String location, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newBuilder().setProject(project).setLocation(location).setConversation(conversation).setFeedbackLabel(feedbackLabel).build().toString();
    }

    public static String formatProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelName(String project, String location, String authorizedViewSet, String authorizedView, String conversation, String feedbackLabel) {
        return FeedbackLabelName.newProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder().setProject(project).setLocation(location).setAuthorizedViewSet(authorizedViewSet).setAuthorizedView(authorizedView).setConversation(conversation).setFeedbackLabel(feedbackLabel).build().toString();
    }

    public static FeedbackLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.match(formattedString);
            return FeedbackLabelName.ofProjectLocationConversationFeedbackLabelName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation"), (String)matchMap.get("feedback_label"));
        }
        if (PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_FEEDBACK_LABEL.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_FEEDBACK_LABEL.match(formattedString);
            return FeedbackLabelName.ofProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("authorized_view_set"), (String)matchMap.get("authorized_view"), (String)matchMap.get("conversation"), (String)matchMap.get("feedback_label"));
        }
        throw new ValidationException("FeedbackLabelName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FeedbackLabelName> parseList(List<String> formattedStrings) {
        ArrayList<FeedbackLabelName> list = new ArrayList<FeedbackLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedbackLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedbackLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedbackLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL.matches(formattedString) || PROJECT_LOCATION_AUTHORIZED_VIEW_SET_AUTHORIZED_VIEW_CONVERSATION_FEEDBACK_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedbackLabelName feedbackLabelName = this;
            synchronized (feedbackLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.conversation != null) {
                        fieldMapBuilder.put((Object)"conversation", (Object)this.conversation);
                    }
                    if (this.feedbackLabel != null) {
                        fieldMapBuilder.put((Object)"feedback_label", (Object)this.feedbackLabel);
                    }
                    if (this.authorizedViewSet != null) {
                        fieldMapBuilder.put((Object)"authorized_view_set", (Object)this.authorizedViewSet);
                    }
                    if (this.authorizedView != null) {
                        fieldMapBuilder.put((Object)"authorized_view", (Object)this.authorizedView);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeedbackLabelName that = (FeedbackLabelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.conversation, that.conversation) && Objects.equals(this.feedbackLabel, that.feedbackLabel) && Objects.equals(this.authorizedViewSet, that.authorizedViewSet) && Objects.equals(this.authorizedView, that.authorizedView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversation);
        h *= 1000003;
        h ^= Objects.hashCode(this.feedbackLabel);
        h *= 1000003;
        h ^= Objects.hashCode(this.authorizedViewSet);
        h *= 1000003;
        return h ^= Objects.hashCode(this.authorizedView);
    }

    public static class ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder {
        private String project;
        private String location;
        private String authorizedViewSet;
        private String authorizedView;
        private String conversation;
        private String feedbackLabel;

        protected ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAuthorizedViewSet() {
            return this.authorizedViewSet;
        }

        public String getAuthorizedView() {
            return this.authorizedView;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getFeedbackLabel() {
            return this.feedbackLabel;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setAuthorizedViewSet(String authorizedViewSet) {
            this.authorizedViewSet = authorizedViewSet;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setAuthorizedView(String authorizedView) {
            this.authorizedView = authorizedView;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public ProjectLocationAuthorizedViewSetAuthorizedViewConversationFeedbackLabelBuilder setFeedbackLabel(String feedbackLabel) {
            this.feedbackLabel = feedbackLabel;
            return this;
        }

        public FeedbackLabelName build() {
            return new FeedbackLabelName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String conversation;
        private String feedbackLabel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversation() {
            return this.conversation;
        }

        public String getFeedbackLabel() {
            return this.feedbackLabel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setConversation(String conversation) {
            this.conversation = conversation;
            return this;
        }

        public Builder setFeedbackLabel(String feedbackLabel) {
            this.feedbackLabel = feedbackLabel;
            return this;
        }

        private Builder(FeedbackLabelName feedbackLabelName) {
            Preconditions.checkArgument((boolean)Objects.equals(feedbackLabelName.pathTemplate, PROJECT_LOCATION_CONVERSATION_FEEDBACK_LABEL), (Object)"toBuilder is only supported when FeedbackLabelName has the pattern of projects/{project}/locations/{location}/conversations/{conversation}/feedbackLabels/{feedback_label}");
            this.project = feedbackLabelName.project;
            this.location = feedbackLabelName.location;
            this.conversation = feedbackLabelName.conversation;
            this.feedbackLabel = feedbackLabelName.feedbackLabel;
        }

        public FeedbackLabelName build() {
            return new FeedbackLabelName(this);
        }
    }
}

